#ifndef __NLL_CONFIG_H_INCLUDED__
#define __NLL_CONFIG_H_INCLUDED__

#ifdef USE_FLOATING_POINT
#define NLL_FLOATING_POINT
#endif

#ifdef USE_SYSTEM_FUNCTION
#define NLL_SYSTEM_FUNCTION
#endif
#ifdef USE_SYSCALL_FUNCTION
#define NLL_SYSCALL_FUNCTION
#endif
#ifdef USE_NETWORK_FUNCTION
#define NLL_NETWORK_FUNCTION
#endif

/* #define NLL_MEMORY_STATIC */

#define NLL_MULTIBYTE_NAME
/* #define NLL_STDIO_FUNCTION */
#define NLL_TYPECHANGE_ENABLE
#define NLL_COMMAND_NEED_SPACE
/* #define NLL_FORMULA_NO_FIXED */
/* #define NLL_CLEAR_VALUE */
/* #define NLL_LOGICAL_VECTOR */

/* #define NLL_TERM_DISABLE */

/* #define NLL_INTERNAL_EXEC_DISABLE */

/* #define NLL_EXTEND_FUNCTION */
/* #define NLL_EXTEND_FUNCTION_FILE "extfunc.c" */

#ifdef WIN32
#define NLL_OUTPUT_NOWAIT
#endif
/* #define NLL_OUTPUT_WAIT_FORCE 1000 */

#if defined(USE_SDL1) || defined(USE_SDL2)
#define USE_SDL
#endif
#ifdef USE_SDL2
#define USE_SDL_RENDERER
#endif

#ifndef LINE_MAXLEN
#define LINE_MAXLEN 256
#endif
#ifndef LINE_MAXNUM
#define LINE_MAXNUM 1024
#endif

#ifndef SYMBOL_NAMELEN
#define SYMBOL_NAMELEN 32
#endif

#ifndef LABEL_NAMELEN
#define LABEL_NAMELEN SYMBOL_NAMELEN
#endif
#ifndef LABEL_MAXNUM
#define LABEL_MAXNUM 256
#endif

#ifndef VARIABLE_NAMELEN
#define VARIABLE_NAMELEN SYMBOL_NAMELEN
#endif
#ifndef VARIABLE_MAXNUM
#define VARIABLE_MAXNUM 256
#endif

#ifndef VALUE_MAXNUM
#define VALUE_MAXNUM 4096
#endif

#ifndef STRING_MAXLEN
#ifdef NLL_MEMORY_STATIC
#define STRING_MAXLEN 256
#else
#define STRING_MAXLEN 65536
#endif
#endif
#ifndef STRING_MAXNUM
#define STRING_MAXNUM 256
#endif

#ifndef ELEMENT_MAXNUM
#define ELEMENT_MAXNUM 1024
#endif

#ifndef COMMAND_MAXNUM
#define COMMAND_MAXNUM 1024
#endif
#ifndef COMMAND_ARG_MAXNUM
#define COMMAND_ARG_MAXNUM 4
#endif
#ifndef COMMAND_ARG_WORD_MAXLEN
#define COMMAND_ARG_WORD_MAXLEN 0 /* unused */
#endif

#ifndef POSITION_MAXNUM
#define POSITION_MAXNUM 64
#endif

#ifndef ARRAY_MAXNUM
#define ARRAY_MAXNUM 1024
#endif

#ifndef AREA_SIZE
#define AREA_SIZE 4096
#endif

#ifndef STACK_MAXNUM
#define STACK_MAXNUM 256
#endif

#ifndef FILEID_MAXNUM
#define FILEID_MAXNUM 256
#endif
#ifndef QUEUEID_MAXNUM
#define QUEUEID_MAXNUM 64
#endif

/* #define KEY_HASH_SMALL */

#ifndef FRAMEBUF_MAXWIDTH
#define FRAMEBUF_MAXWIDTH       120
#endif
#ifndef FRAMEBUF_MAXHEIGHT
#define FRAMEBUF_MAXHEIGHT       60
#endif
#ifndef FRAMEBUF_DEFAULT_WIDTH
#define FRAMEBUF_DEFAULT_WIDTH   40
#endif
#ifndef FRAMEBUF_DEFAULT_HEIGHT
#define FRAMEBUF_DEFAULT_HEIGHT  25
#endif

/* #define GRAPHIC_CHARACTER_PRESET_LIMITED */
/* #define GRAPHIC_CHARACTER_PRESET_RDONLY */
/* #define GRAPHIC_EXTERNAL_DRIVER */
/* #define GRAPHIC_INPUT_DIRECT */

#ifndef GRAPHIC_MAXWIDTH
#define GRAPHIC_MAXWIDTH       4096
#endif
#ifndef GRAPHIC_MAXHEIGHT
#define GRAPHIC_MAXHEIGHT      4096
#endif
#ifndef GRAPHIC_DEFAULT_WIDTH
#define GRAPHIC_DEFAULT_WIDTH   640
#endif
#ifndef GRAPHIC_DEFAULT_HEIGHT
#define GRAPHIC_DEFAULT_HEIGHT  480
#endif

#ifndef GRAPHIC_IMAGE_MAXNUM
#define GRAPHIC_IMAGE_MAXNUM 1024
#endif

/* #define AUDIO_AVERAGING_AMP_LEVEL */
/* #define AUDIO_SIN_DATA_RAW */
/* #define AUDIO_EXTERNAL_DRIVER */

#ifndef AUDIO_PER_NUM
#define AUDIO_PER_NUM 1024
#endif
#ifndef AUDIO_DEFAULT_SAMPLING_FREQ
#define AUDIO_DEFAULT_SAMPLING_FREQ 44100
#endif
#ifndef AUDIO_DEFAULT_SAMPLES
#define AUDIO_DEFAULT_SAMPLES 256
#endif
#ifndef AUDIO_UNIT_OUTMAX
#define AUDIO_UNIT_OUTMAX 8
#endif
#ifndef AUDIO_UNIT_ENVMAX
#define AUDIO_UNIT_ENVMAX 16
#endif
#ifndef AUDIO_UNIT_FILFWMAX
#define AUDIO_UNIT_FILFWMAX 16
#endif
#ifndef AUDIO_UNIT_FILBWMAX
#define AUDIO_UNIT_FILBWMAX 16
#endif
#ifndef AUDIO_UNIT_BUFNUM
#define AUDIO_UNIT_BUFNUM AUDIO_UNIT_FILFWMAX /* Max of FILFWMAX and FILBWMAX */
#endif
#ifndef AUDIO_UNITSET_MAXNUM
#define AUDIO_UNITSET_MAXNUM 64
#endif

#ifndef AUDIO_SOUND_MAXNUM
#define AUDIO_SOUND_MAXNUM 128
#endif

#endif
