#ifndef __NLL_FRAMEBUF_H_INCLUDED__
#define __NLL_FRAMEBUF_H_INCLUDED__

int framebuf_get_screen_flags(void);
int framebuf_get_screen_width(void);
int framebuf_get_screen_height(void);
int framebuf_get_cursor_x(void);
int framebuf_get_cursor_y(void);
int framebuf_get_cursor_effect(void);
int framebuf_get_cursor_fgcolor(void);
int framebuf_get_cursor_bgcolor(void);
int framebuf_init(void);
int framebuf_done(void);
int framebuf_setscreen(int flags, int width, int height);
int framebuf_enable(int enable);
int framebuf_cursor_on(void);
int framebuf_cursor_off(void);
int framebuf_flush(int flags);
int framebuf_seteffect(int effect);
int framebuf_setfgcolor(int color);
int framebuf_setbgcolor(int color);
int framebuf_move_cursor(int x, int y);
int framebuf_move_left(int num);
int framebuf_move_right(int num);
int framebuf_move_up(int num);
int framebuf_move_down(int num);
int framebuf_getch(int x, int y);
int framebuf_clear(int chara, int flags);
int framebuf_scroll(int x, int y, int chara);
int framebuf_puts(const char *str);
int framebuf_line(int x0, int y0, int x1, int y1, const char *str);
int framebuf_box(int x0, int y0, int x1, int y1, const char *str, int flags);
key_code_t framebuf_getkey(void);

#endif
