#ifndef __NLL_TERM_H_INCLUDED__
#define __NLL_TERM_H_INCLUDED__

#ifndef WIN32
#define NLL_TERM_KEY_ESCAPE   0x1b
#define NLL_TERM_KEY_START1   0x4f
#define NLL_TERM_KEY_START2   0x5b
#define NLL_TERM_KEY_START3   0x5b35
#define NLL_TERM_KEY_START4   0x5b36

#define NLL_TERM_KEY_END      0x4f64
#define NLL_TERM_KEY_UP       0x5b41
#define NLL_TERM_KEY_DOWN     0x5b42
#define NLL_TERM_KEY_RIGHT    0x5b43
#define NLL_TERM_KEY_LEFT     0x5b44
#define NLL_TERM_KEY_PAGEUP   0x5b357e
#define NLL_TERM_KEY_PAGEDOWN 0x5b367e
#else
#define NLL_TERM_KEY_ESCAPE   0xe0

#define NLL_TERM_KEY_END      0x4f
#define NLL_TERM_KEY_UP       0x48
#define NLL_TERM_KEY_DOWN     0x50
#define NLL_TERM_KEY_RIGHT    0x4d
#define NLL_TERM_KEY_LEFT     0x4b
#define NLL_TERM_KEY_PAGEUP   0x49
#define NLL_TERM_KEY_PAGEDOWN 0x51
#endif

int nll_term_init(void);
int nll_term_done(void);
int nll_term_start(int flags);
int nll_term_restore(int flags);
int nll_term_key(int flags);

#endif
