# 1 "main.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "main.c"
# 1 "config.h" 1
# 2 "main.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "main.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "main.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "main.c" 2
# 1 "../include/unistd.h" 1
# 14 "../include/unistd.h"
void _exit(int status);
pid_t fork(void);
int execve(const char *path, char *const argv[], char *const envp[]);

ssize_t read(int fd, void *buf, size_t nbytes);
ssize_t write(int fd, const void *buf, size_t nbytes);
int close(int fd);

int dup(int oldd);
int pipe(int fildes[2]);
int dup2(int oldd, int newd);
int pipe2(int fildes[2], int flags);

pid_t getpid(void);
pid_t getppid(void);
pid_t getsid(pid_t pid);
pid_t setsid(void);
pid_t getpgid(pid_t pid);
int setpgid(pid_t pid, pid_t pgrp);
pid_t getpgrp(void);

pid_t tcgetpgrp(int fd);
int tcsetpgrp(int fd, pid_t pgrp_id);

int unlink(const char *path);
int chdir(const char *path);
int chdir(const char *path);
int fchdir(int fd);
int chown(const char *path, uid_t owner, gid_t group);
off_t lseek(int fildes, off_t offset, int whence);
int access(const char *path, int mode);
void sync(void);
int fsync(int fd);
int fchown(int fd, uid_t owner, gid_t group);

int truncate(const char *path, off_t length);
int ftruncate(int fd, off_t length);


int brk(void *addr);



void *sbrk(intptr_t incr);

char *getcwd(char *buf, size_t size);

unsigned int sleep(unsigned int seconds);
int usleep(useconds_t microseconds);

int isatty(int fd);
# 7 "main.c" 2
# 1 "../include/signal.h" 1
# 88 "../include/signal.h"
typedef void (*sig_t)(int);
# 106 "../include/signal.h"
typedef struct {
  unsigned int sig[2];
} sigset_t;

struct siginfo;
struct sigaction;


struct sigaction {
  union {
    void (*__sa_handler)(int);
    void (*__sa_sigaction)(int, struct siginfo *, void *);
  } __sigaction_u;
  sigset_t sa_mask;
  unsigned long sa_flags;

  void (*sa_restorer)(void);

};
# 193 "../include/signal.h"
struct sigcontext;
int sigreturn(struct sigcontext *scp);
# 216 "../include/signal.h"
int kill(pid_t pid, int sig);

int sigaction(int sig, const struct sigaction *act, struct sigaction *oact);
int sigprocmask(int how, const sigset_t *set, sigset_t *oset);

int killpg(pid_t pgrp, int sig);
# 8 "main.c" 2
# 19 "main.c"
# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 20 "main.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 23 "main.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 24 "main.c" 2
# 1 "nllmain.h" 1



int nll_init(FILE *in, FILE *out);
int nll_new(void);
int nll_done(void);

int nll_make_argc(int argc);
int nll_make_argv(int argc, char *argv[]);
int nll_set_arg(int index, value_t arg);
int nll_del_argc(void);
int nll_del_argv(void);

int nll_main(int argc, char *argv[], int quit, int auto_run, int auto_number, char *command);
# 25 "main.c" 2
# 1 "argument.h" 1





typedef enum {
  ARGUMENT_TYPE_NONE,
  ARGUMENT_TYPE_FUNCTION,
  ARGUMENT_TYPE_FLAG_ON,
  ARGUMENT_TYPE_FLAG_OFF,
  ARGUMENT_TYPE_INTEGER,



  ARGUMENT_TYPE_STRING
} argument_type_t;




typedef struct _argument {
  const char *name;
  argument_type_t type;
  void *value;
} argument_t;





int argument_read(int *argc, char *argv[], const argument_t args[], unsigned int flags);
# 26 "main.c" 2

static void signal_init(void);

static void sigint_handler(int arg)
{
  nll_finish();



  return;
}





static void signal_init(void)
{

  struct sigaction sa;

  memset(&sa, 0, sizeof(sa));
  sa.__sigaction_u.__sa_handler = sigint_handler;

  sigaction(2, &sa, ((void *)0));



}

static void signal_reset(void)
{

  struct sigaction sa;

  memset(&sa, 0, sizeof(sa));
  sa.__sigaction_u.__sa_handler = ((sig_t) 0);

  sigaction(2, &sa, ((void *)0));



}

static void init(void)
{
  int r;

  signal_init();

  if ((r = nll_init(stdin, stdout)) < 0)
    nll_error_exit("main.c", 77, r, "(EXIT)");
}

static void done(void)
{
  int r;

  if ((r = nll_done()) < 0)
    nll_error_exit("main.c", 85, r, "(EXIT)");

  signal_reset();
}

static void help(void)
{
  printf("nll [-help|-h] [-version|-v] [-quit|-q] [-number|-n] [-no-run|-nr] [-no-argv|-na] [-no-system|-ns] [-no-syscall|-nc] [-no-network|-nn] [-no-fixed|-nf] [-e <command>] [<filename>|-|{--|stdin}] [<arguments>...]\n");
  printf("\t-help,-h\tOutput help message.\n");
  printf("\t-version,-v\tOutput version.\n");
  printf("\t-quit,-q\tAuto quit after execution of the input file.\n");
  printf("\t-number,-n\tAuto numbering mode of the input file.\n");
  printf("\t-no-run,-nr\tDisable auto execution of the input file.\n");
  printf("\t-no-argv,-na\tNot give ARGV[] for arguments.\n");
  printf("\t-no-system,-ns\tDisable system functions.\n");
  printf("\t-no-syscall,-nc\tDisable SYSCALL() function.\n");
  printf("\t-no-network,-nn\tDisable network functions.\n");
  printf("\t-no-fixed,-nf\tDisable one time only calculation of the fixed value.\n");
  printf("\t-e <command>\tExecute the command.\n");
  printf("\t-\t\tThe file name not to read.\n");
  printf("\t--,stdin\tInput the commands from standard input.\n");
  printf("Examples:\n");
  printf("\t$ nll sample.nll arg0 arg1 arg2\n");
  printf("\t$ echo \"abc\" | nll -e \'S=FGETS(0);FPUTS(0,S)\'\n");
  exit(0);
}

static void outver(void)
{

  printf("%s\n", "20251213a");

  exit(0);
}

static int quit = 0;
static int auto_number = 0;
static int auto_run = 1;
static int enable_argv = 1;
static int no_system = 0;
static int no_syscall = 0;
static int no_network = 0;
static int no_fixed = 0;
static char *command = ((void *)0);

static argument_t args[] = {
  { "-help" , ARGUMENT_TYPE_FUNCTION, help },
  { "-h" , ARGUMENT_TYPE_FUNCTION, help },
  { "-version" , ARGUMENT_TYPE_FUNCTION, outver },
  { "-v" , ARGUMENT_TYPE_FUNCTION, outver },
  { "-quit" , ARGUMENT_TYPE_FLAG_ON , &quit },
  { "-q" , ARGUMENT_TYPE_FLAG_ON , &quit },
  { "-number" , ARGUMENT_TYPE_FLAG_ON , &auto_number },
  { "-n" , ARGUMENT_TYPE_FLAG_ON , &auto_number },
  { "-no-run" , ARGUMENT_TYPE_FLAG_OFF, &auto_run },
  { "-nr" , ARGUMENT_TYPE_FLAG_OFF, &auto_run },
  { "-no-argv" , ARGUMENT_TYPE_FLAG_OFF, &enable_argv },
  { "-na" , ARGUMENT_TYPE_FLAG_OFF, &enable_argv },
  { "-no-system" , ARGUMENT_TYPE_FLAG_ON , &no_system },
  { "-ns" , ARGUMENT_TYPE_FLAG_ON , &no_system },
  { "-no-syscall", ARGUMENT_TYPE_FLAG_ON , &no_syscall },
  { "-nc" , ARGUMENT_TYPE_FLAG_ON , &no_syscall },
  { "-no-network", ARGUMENT_TYPE_FLAG_ON , &no_network },
  { "-nn" , ARGUMENT_TYPE_FLAG_ON , &no_network },
  { "-no-fixed" , ARGUMENT_TYPE_FLAG_ON , &no_fixed },
  { "-nf" , ARGUMENT_TYPE_FLAG_ON , &no_fixed },
  { "-e" , ARGUMENT_TYPE_STRING , &command },
  { ((void *)0), ARGUMENT_TYPE_NONE, ((void *)0) }
};

int main(int argc, char *argv[])
{
  char *filename = ((void *)0), *nullargv = ((void *)0);
  int r;

  argc--;
  argv++;

  argument_read(&argc, argv, args, (1 << 2));

  if (no_system)
    nll_nosystem_set();
  if (no_syscall)
    nll_nosyscall_set();
  if (no_network)
    nll_nonetwork_set();
  if (no_fixed)
    nll_nofixed_set();

  if (argc > 0) {
    filename = argv[0];
  }

  init();

  if (filename) {
    if (!strcmp(filename, "-")) {

    } else if (!strcmp(filename, "--") || !strcmp(filename, "stdin")) {
      if ((r = nll_file_stdin()) < 0)
 nll_error_exit("main.c", 185, r, "(stdin)");
    } else {
      if ((r = nll_file_open(filename)) < 0)
 nll_error_exit("main.c", 188, r, filename);
    }
  }

  if (isatty(0))
    nll_tty_set();

  if (!enable_argv) {
    argc = 0;
    argv = &nullargv;
  }

  r = nll_main(argc, argv, quit, auto_run, auto_number, command);

  done();

  return r;
}
