#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "imath.h"

/* #define IMATH_SIN_DATA_RAW */

#ifdef IMATH_SIN_DATA_RAW
#define AMPLIMIT 32767
#define SINNUM 64
static const int sin_val[SINNUM + 1] = {
      0,   804,  1608,  2410,  3212,  4011,  4808,  5602,
   6393,  7179,  7962,  8739,  9512, 10278, 11039, 11793,
  12539, 13279, 14010, 14732, 15446, 16151, 16846, 17530,
  18204, 18868, 19519, 20159, 20787, 21403, 22005, 22594,
  23170, 23731, 24279, 24811, 25329, 25832, 26319, 26790,
  27245, 27683, 28105, 28510, 28898, 29268, 29621, 29956,
  30273, 30571, 30852, 31113, 31356, 31580, 31785, 31971,
  32137, 32285, 32412, 32521, 32609, 32678, 32728, 32757, 32767
};
#else
#define AMPLIMIT 32767
#define SINNUM 256
static const int sin_val[SINNUM + 1] = {
      0,   201,   402,   603,   804,  1005,  1206,  1407,
   1608,  1809,  2009,  2210,  2410,  2611,  2811,  3012,
   3212,  3412,  3612,  3811,  4011,  4210,  4410,  4609,
   4808,  5007,  5205,  5404,  5602,  5800,  5998,  6195,
   6393,  6590,  6786,  6983,  7179,  7375,  7571,  7767,
   7962,  8157,  8351,  8545,  8739,  8933,  9126,  9319,
   9512,  9704,  9896, 10087, 10278, 10469, 10659, 10849,
  11039, 11228, 11417, 11605, 11793, 11980, 12167, 12353,
  12539, 12725, 12910, 13094, 13279, 13462, 13645, 13828,
  14010, 14191, 14372, 14553, 14732, 14912, 15090, 15269,
  15446, 15623, 15800, 15976, 16151, 16325, 16499, 16673,
  16846, 17018, 17189, 17360, 17530, 17700, 17869, 18037,
  18204, 18371, 18537, 18703, 18868, 19032, 19195, 19357,
  19519, 19680, 19841, 20000, 20159, 20317, 20475, 20631,
  20787, 20942, 21096, 21250, 21403, 21554, 21705, 21856,
  22005, 22154, 22301, 22448, 22594, 22739, 22884, 23027,
  23170, 23311, 23452, 23592, 23731, 23870, 24007, 24143,
  24279, 24413, 24547, 24680, 24811, 24942, 25072, 25201,
  25329, 25456, 25582, 25708, 25832, 25955, 26077, 26198,
  26319, 26438, 26556, 26674, 26790, 26905, 27019, 27133,
  27245, 27356, 27466, 27575, 27683, 27790, 27896, 28001,
  28105, 28208, 28310, 28411, 28510, 28609, 28706, 28803,
  28898, 28992, 29085, 29177, 29268, 29358, 29447, 29534,
  29621, 29706, 29791, 29874, 29956, 30037, 30117, 30195,
  30273, 30349, 30424, 30498, 30571, 30643, 30714, 30783,
  30852, 30919, 30985, 31050, 31113, 31176, 31237, 31297,
  31356, 31414, 31470, 31526, 31580, 31633, 31685, 31736,
  31785, 31833, 31880, 31926, 31971, 32014, 32057, 32098,
  32137, 32176, 32213, 32250, 32285, 32318, 32351, 32382,
  32412, 32441, 32469, 32495, 32521, 32545, 32567, 32589,
  32609, 32628, 32646, 32663, 32678, 32692, 32705, 32717,
  32728, 32737, 32745, 32752, 32757, 32761, 32765, 32766, 32767
};
#endif

static int degree_inrange(int deg)
{
  while (deg < 0)
    deg += (SINNUM*4);
  deg %= (SINNUM*4);
  return deg;
}

static int int_sin(int deg)
{
  deg = degree_inrange(deg);
  if (deg >= (SINNUM*2))
    return -int_sin(deg - (SINNUM*2));
  if (deg > SINNUM)
    return int_sin((SINNUM*2) - deg);
  return sin_val[deg];
}

int imath_deg(void)
{
  return SINNUM * 4;
}

int imath_amp(void)
{
  return AMPLIMIT;
}

int imath_sin(int deg)
{
  return int_sin(deg);
}

int imath_cos(int deg)
{
  return int_sin(deg + SINNUM);
}

long imath_sqr(long val)
{
  long m, n, m2, n2;

  m = m2 = 0;
  for (n = 1;; n++) {
    n2 = n * n;
    if (m2 > n2)
      break;
    if (n2 > val)
      return m;
    m = n;
    m2 = n2;
  }

  return -1;
}

long imath_pow(long b, int n)
{
  int i;
  long val = 1;

  for (i = 0; i < n; i++)
    val *= b;

  return val;
}

int imath_log(long b, long val)
{
  int m, n;
  long mm, nn;

  if (b <= 1)
    return -1;

  m = 0;
  mm = nn = 1;
  for (n = 1;; n++) {
    nn = nn * b;
    if (mm > nn)
      break;
    if (nn > val)
      return m;
    m = n;
    mm = nn;
  }

  return -1;
}
