# 1 "framebuf.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "framebuf.c"
# 1 "config.h" 1
# 2 "framebuf.c" 2


# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 5 "framebuf.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 6 "framebuf.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 7 "framebuf.c" 2






# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 14 "framebuf.c" 2


# 1 "const.h" 1
# 17 "framebuf.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 18 "framebuf.c" 2
# 1 "key.h" 1



typedef enum {
  KEY_CODE_NONE = 0,

  KEY_CODE_ENTER = '\n',
  KEY_CODE_ESCAPE = 0x1b,
  KEY_CODE_BACKSPACE = '\b',
  KEY_CODE_TAB = '\t',
  KEY_CODE_SPACE = ' ',
  KEY_CODE_EXCLAIM = '!',
  KEY_CODE_QUOTEDBL = '"',
  KEY_CODE_HASH = '#',
  KEY_CODE_PERCENT = '%',
  KEY_CODE_DOLLAR = '$',
  KEY_CODE_AMPERSAND = '&',
  KEY_CODE_QUOTE = '\'',
  KEY_CODE_LEFTPAREN = '(',
  KEY_CODE_RIGHTPAREN = ')',
  KEY_CODE_ASTERISK = '*',
  KEY_CODE_PLUS = '+',
  KEY_CODE_COMMA = ',',
  KEY_CODE_MINUS = '-',
  KEY_CODE_PERIOD = '.',
  KEY_CODE_SLASH = '/',
  KEY_CODE_0 = '0',
  KEY_CODE_1 = '1',
  KEY_CODE_2 = '2',
  KEY_CODE_3 = '3',
  KEY_CODE_4 = '4',
  KEY_CODE_5 = '5',
  KEY_CODE_6 = '6',
  KEY_CODE_7 = '7',
  KEY_CODE_8 = '8',
  KEY_CODE_9 = '9',
  KEY_CODE_COLON = ':',
  KEY_CODE_SEMICOLON = ';',
  KEY_CODE_LESS = '<',
  KEY_CODE_EQUALS = '=',
  KEY_CODE_GREATER = '>',
  KEY_CODE_QUESTION = '?',
  KEY_CODE_AT = '@',
  KEY_CODE_LEFTBRACKET = '[',
  KEY_CODE_BACKSLASH = '\\',
  KEY_CODE_RIGHTBRACKET = ']',
  KEY_CODE_CARET = '^',
  KEY_CODE_UNDERSCORE = '_',
  KEY_CODE_BACKQUOTE = '`',
  KEY_CODE_A = 'a',
  KEY_CODE_B = 'b',
  KEY_CODE_C = 'c',
  KEY_CODE_D = 'd',
  KEY_CODE_E = 'e',
  KEY_CODE_F = 'f',
  KEY_CODE_G = 'g',
  KEY_CODE_H = 'h',
  KEY_CODE_I = 'i',
  KEY_CODE_J = 'j',
  KEY_CODE_K = 'k',
  KEY_CODE_L = 'l',
  KEY_CODE_M = 'm',
  KEY_CODE_N = 'n',
  KEY_CODE_O = 'o',
  KEY_CODE_P = 'p',
  KEY_CODE_Q = 'q',
  KEY_CODE_R = 'r',
  KEY_CODE_S = 's',
  KEY_CODE_T = 't',
  KEY_CODE_U = 'u',
  KEY_CODE_V = 'v',
  KEY_CODE_W = 'w',
  KEY_CODE_X = 'x',
  KEY_CODE_Y = 'y',
  KEY_CODE_Z = 'z',

  KEY_CODE_CAPSLOCK = 128,
  KEY_CODE_F1,
  KEY_CODE_F2,
  KEY_CODE_F3,
  KEY_CODE_F4,
  KEY_CODE_F5,
  KEY_CODE_F6,
  KEY_CODE_F7,
  KEY_CODE_F8,
  KEY_CODE_F9,
  KEY_CODE_F10,
  KEY_CODE_F11,
  KEY_CODE_F12,

  KEY_CODE_PRINTSCREEN,
  KEY_CODE_SCROLLLOCK,
  KEY_CODE_PAUSE,
  KEY_CODE_INSERT,
  KEY_CODE_HOME,
  KEY_CODE_PAGEUP,
  KEY_CODE_DELETE,
  KEY_CODE_END,
  KEY_CODE_PAGEDOWN,
  KEY_CODE_RIGHT,
  KEY_CODE_LEFT,
  KEY_CODE_DOWN,
  KEY_CODE_UP,

  KEY_CODE_F13,
  KEY_CODE_F14,
  KEY_CODE_F15,

  KEY_CODE_LCTRL,
  KEY_CODE_LSHIFT,
  KEY_CODE_LALT,
  KEY_CODE_RCTRL,
  KEY_CODE_RSHIFT,
  KEY_CODE_RALT,

  KEY_CODE_NUM
} key_code_t;
# 228 "key.h"
const char *keyname_get(key_code_t code);
key_code_t keycode_get(const char *name);
# 19 "framebuf.c" 2
# 1 "framebuf.h" 1



int framebuf_get_screen_flags(void);
int framebuf_get_screen_width(void);
int framebuf_get_screen_height(void);
int framebuf_get_cursor_x(void);
int framebuf_get_cursor_y(void);
int framebuf_get_cursor_effect(void);
int framebuf_get_cursor_fgcolor(void);
int framebuf_get_cursor_bgcolor(void);
int framebuf_init(void);
int framebuf_done(void);
int framebuf_setscreen(int flags, int width, int height);
int framebuf_enable(int enable);
int framebuf_cursor_on(void);
int framebuf_cursor_off(void);
int framebuf_flush(int flags);
int framebuf_seteffect(int effect);
int framebuf_setfgcolor(int color);
int framebuf_setbgcolor(int color);
int framebuf_move_cursor(int x, int y);
int framebuf_move_left(int num);
int framebuf_move_right(int num);
int framebuf_move_up(int num);
int framebuf_move_down(int num);
int framebuf_getch(int x, int y);
int framebuf_clear(int chara, int flags);
int framebuf_scroll(int x, int y, int chara);
int framebuf_puts(const char *str);
int framebuf_line(int x0, int y0, int x1, int y1, const char *str);
int framebuf_box(int x0, int y0, int x1, int y1, const char *str, int flags);
key_code_t framebuf_getkey(void);
# 20 "framebuf.c" 2
# 1 "term.h" 1
# 30 "term.h"
int nll_term_init(void);
int nll_term_done(void);
int nll_term_start(int flags);
int nll_term_restore(int flags);
int nll_term_key(int flags);
# 21 "framebuf.c" 2

static struct linebuf {
  unsigned char chara[120];
  unsigned int attr[120];
} linebuf[60];

typedef struct framebuf_context {
  unsigned int flags;
  int width;
  int height;

  struct {
    int x;
    int y;
    unsigned int attr;
  } cursor;

  struct frameline {
    unsigned int flags;

    struct linebuf *buffer;
  } line[60];
} *framebuf_context_t;

static struct framebuf_context _context;
static framebuf_context_t context = ((void *)0);
# 70 "framebuf.c"
int framebuf_get_screen_flags(void)
{
  return context ? context->flags : 0;
}

int framebuf_get_screen_width(void)
{
  return context ? context->width : -1;
}

int framebuf_get_screen_height(void)
{
  return context ? context->height : -1;
}

int framebuf_get_cursor_x(void)
{
  return context ? context->cursor.x : -1;
}

int framebuf_get_cursor_y(void)
{
  return context ? context->cursor.y : -1;
}

int framebuf_get_cursor_effect(void)
{
  return context ? (((context->cursor.attr) & 0xf) >> 0) : -1;
}

int framebuf_get_cursor_fgcolor(void)
{
  return context ? (((context->cursor.attr) & 0xf0) >> 4) : -1;
}

int framebuf_get_cursor_bgcolor(void)
{
  return context ? (((context->cursor.attr) & 0xf00) >> 8) : -1;
}

int framebuf_init(void)
{
  int r;
  if ((r = nll_term_init()) < 0)
    return r;
  framebuf_enable(1);
  r = framebuf_setscreen(0, 0, 0);
  framebuf_enable(0);
  if (r < 0)
    return r;
  return 0;
}

int framebuf_done(void)
{
  int r;
  framebuf_enable(1);
  r = framebuf_setscreen(0, 0, 0);
  framebuf_enable(0);
  if (r < 0)
    return r;
  if ((r = nll_term_done()) < 0)
    return r;
  return 0;
}

static void _flush(FILE *fp)
{
  fflush(fp);
}

static void _clear(FILE *fp)
{
  fprintf(fp, "\x1b[2J");
  fprintf(fp, "\x1b[1;1H");
}

static void _wait(FILE *fp)
{
  nll_wait_output(fp);
}

static void _cursor_on(FILE *fp)
{
  fprintf(fp, "\x1b[>5l");
}

static void _cursor_off(FILE *fp)
{
  fprintf(fp, "\x1b[>5h");
}

static void _home(FILE *fp)
{
  fprintf(fp, "\x1b[1;1H");
}

static void _effect(FILE *fp, int e)
{
  fprintf(fp, "\x1b[%dm", e);
}

static void _fgcolor(FILE *fp, int c)
{
  fprintf(fp, "\x1b[%dm", 30 + c);
}

static void _bgcolor(FILE *fp, int c)
{
  fprintf(fp, "\x1b[%dm", 40 + c);
}

static void _newline(FILE *fp)
{



  fprintf(fp, "\n");

}

static void _movex(FILE *fp, int num)
{
  if (num < 0) fprintf(fp, "\x1b[%dD", -num);
  else fprintf(fp, "\x1b[%dC", num);
}

static void _movey(FILE *fp, int num)
{
  if (num < 0) fprintf(fp, "\x1b[%dA", -num);
  else fprintf(fp, "\x1b[%dB", num);
}

static void _move(FILE *fp, int x, int y)
{
  fprintf(fp, "\x1b[%d;%dH", y + 1, x + 1);
}

static void _scroll_y(FILE *fp, int num)
{
  if (num < 0) fprintf(fp, "\x1b[%dT", -num);
  else fprintf(fp, "\x1b[%dS", num);
}

static FILE *outfp(framebuf_context_t context)
{
  return nll_stdout;
}
# 263 "framebuf.c"
static int _enable(framebuf_context_t context)
{
  return nll_term_start(context ? context->flags : 0);
}

static int _disable(framebuf_context_t context)
{
  return nll_term_restore(context ? context->flags : 0);
}

static int _init(framebuf_context_t context)
{






  return 0;
}

static int _done(framebuf_context_t context)
{






  return 0;
}

static int flush_reset(framebuf_context_t context)
{
# 308 "framebuf.c"
  _effect(outfp(context), 0);
  _fgcolor(outfp(context), 9);
  _bgcolor(outfp(context), 9);
  _flush(outfp(context));

  return 0;
}

static int flush_wait(framebuf_context_t context)
{






  _wait(outfp(context));

  return 0;
}

static int flush_cursor_on(framebuf_context_t context, int on)
{







  if (on)
    _cursor_on(outfp(context));
  else
    _cursor_off(outfp(context));
  _flush(outfp(context));

  return 0;
}

static int flush_home(framebuf_context_t context)
{







  _home(outfp(context));

  return 0;
}

static int flush_effect(framebuf_context_t context, int effect)
{
# 390 "framebuf.c"
  _effect(outfp(context), effect);

  return 0;
}
# 415 "framebuf.c"
static int flush_color(framebuf_context_t context, int fgcolor, int bgcolor)
{
# 428 "framebuf.c"
  _fgcolor(outfp(context), fgcolor);
  _bgcolor(outfp(context), bgcolor);

  return 0;
}

static int flush_write(framebuf_context_t context, unsigned char *p, int size)
{







  fwrite(p, size, 1, outfp(context));

  return 0;
}

static int flush_newline(framebuf_context_t context, int line)
{







  _newline(outfp(context));

  return 0;
}

static int flush_finish(framebuf_context_t context)
{







  fflush(outfp(context));

  return 0;
}

static int flush(framebuf_context_t context, unsigned int flags)
{
  int i, n, size;
  unsigned char *cp;
  unsigned int attr = -1, *ap;

  if (!context)
    return 0;

  if ((flags | context->flags) & (1 << 4)) {
    for (i = 0; i < context->height; i++)
      context->line[i].flags |= (1 << 0);
  }

  flush_wait(context);

  flush_home(context);

  for (i = 0; i < context->height; i++) {
    if (context->line[i].flags & (1 << 0)) {
      n = 0;
      cp = context->line[i].buffer->chara;
      ap = context->line[i].buffer->attr;

      flush_wait(context);

      while (n < context->width) {
 if (attr != *ap) {
   attr = *ap;
   flush_effect(context, (((attr) & 0xf) >> 0));
   flush_color(context, (((attr) & 0xf0) >> 4), (((attr) & 0xf00) >> 8));
 }
 for (size = 0; n + size < context->width; size++, ap++) {
   if (*ap != attr)
     break;
 }
 flush_write(context, cp, size);
 cp += size;
 n += size;
      }
      context->line[i].flags &= ~(1 << 0);
    }
    flush_newline(context, i);
  }

  flush_finish(context);

  return 0;
}

static int frameline_clear(struct frameline *line, int width,
      int chara, unsigned int attr)
{
  int i;
  for (i = 0; i < width; i++) {
    line->buffer->chara[i] = chara;
    line->buffer->attr[i] = attr;
  }
  line->flags |= (1 << 0);
  return 0;
}

static int lineclear(framebuf_context_t context, int chara, unsigned int attr)
{
  int i;
  for (i = 0; i < context->height; i++) {
    context->line[i].buffer = &linebuf[i];
    frameline_clear(&context->line[i], context->width, chara, attr);
  }
  return 0;
}

int framebuf_setscreen(int flags, int width, int height)
{
  if (flags < 0) {
    flags = framebuf_get_screen_flags();
    if (flags == 0)
      flags = (1 << 0);
  }

  switch (flags) {
  case 0:
    if (context) {
      _disable(context);
      _done(context);
      context = ((void *)0);
      _enable(context);
      flush_reset(context);
      flush_cursor_on(context, 1);
    }
    break;

  default:
    _disable(context);

    if (context) {
      width = (width < 0) ? context->width : width;
      height = (height < 0) ? context->height : height;
    }

    width = ((width > 0) && (width <= 120 ))
      ? width : 40;
    height = ((height > 0) && (height <= 60))
      ? height : 25;

    context = &_context;
    memset(context, 0, sizeof(*context));

    context->flags = flags;
    context->width = width;
    context->height = height;

    context->cursor.x = 0;
    context->cursor.y = 0;
    context->cursor.attr = ((((0) << 0) & 0xf) | (((9) << 4) & 0xf0) | (((9) << 8) & 0xf00));

    _init(context);

    _enable(context);

    flush_reset(context);
    flush_cursor_on(context, (flags & (1 << 2)) ? 1 : 0);

    lineclear(context, ' ', ((((0) << 0) & 0xf) | (((9) << 4) & 0xf0) | (((9) << 8) & 0xf00)));
    flush(context, 0);

    break;
  }

  return 0;
}

int framebuf_enable(int enable)
{
  return enable ? _enable(context) : _disable(context);
}

int framebuf_cursor_on(void)
{
  if (!context) {
    _cursor_on(nll_stdout);
    _flush(nll_stdout);
    return 0;
  }

  flush_cursor_on(context, 1);

  return 0;
}

int framebuf_cursor_off(void)
{
  if (!context) {
    _cursor_off(nll_stdout);
    _flush(nll_stdout);
    return 0;
  }

  flush_cursor_on(context, 0);

  return 0;
}

int framebuf_flush(int flags)
{
  if (!context) {
    return 0;
  }

  flush(context, flags);

  return 0;
}

int framebuf_seteffect(int effect)
{
  if (!context) {
    if ((effect < 0) || (effect > 9))
      ;
    else {
      _effect(nll_stdout, effect);
      _flush(nll_stdout);
    }
    return 0;
  }

  if ((effect < 0) || (effect > 9))
    effect = (((context->cursor.attr) & 0xf) >> 0);

  context->cursor.attr =
    (context->cursor.attr & ~0xf) | ((((effect) << 0) & 0xf) | (((0) << 4) & 0xf0) | (((0) << 8) & 0xf00));

  return 0;
}

int framebuf_setfgcolor(int color)
{
  if (!context) {
    if ((color < 0) || (color > 9))
      ;
    else {
      _fgcolor(nll_stdout, color);
      _flush(nll_stdout);
    }
    return 0;
  }

  if ((color < 0) || (color > 9))
    color = (((context->cursor.attr) & 0xf0) >> 4);

  context->cursor.attr =
    (context->cursor.attr & ~0xf0) | ((((0) << 0) & 0xf) | (((color) << 4) & 0xf0) | (((0) << 8) & 0xf00));

  return 0;
}

int framebuf_setbgcolor(int color)
{
  if (!context) {
    if ((color < 0) || (color > 9))
      ;
    else {
      _bgcolor(nll_stdout, color);
      _flush(nll_stdout);
    }
    return 0;
  }

  if ((color < 0) || (color > 9))
    color = (((context->cursor.attr) & 0xf00) >> 8);

  context->cursor.attr =
    (context->cursor.attr & ~0xf00) | ((((0) << 0) & 0xf) | (((0) << 4) & 0xf0) | (((color) << 8) & 0xf00));

  return 0;
}

int framebuf_move_cursor(int x, int y)
{
  if (!context) {
    _move(nll_stdout, x, y);
    _flush(nll_stdout);
    return 0;
  }

  x = ((x < 0) || (x > context->width - 1)) ? context->cursor.x : x;
  y = ((y < 0) || (y > context->height - 1)) ? context->cursor.y : y;

  context->cursor.x = x;
  context->cursor.y = y;

  return 0;
}

int framebuf_move_left(int num)
{
  if (!context) {
    _movex(nll_stdout, -num);
    _flush(nll_stdout);
    return 0;
  }

  if (num > context->cursor.x)
    num = context->cursor.x;

  context->cursor.x -= num;

  return 0;
}

int framebuf_move_right(int num)
{
  if (!context) {
    _movex(nll_stdout, num);
    _flush(nll_stdout);
    return 0;
  }

  if (num > context->width - 1 - context->cursor.x)
    num = context->width - 1 - context->cursor.x;

  context->cursor.x += num;

  return 0;
}

int framebuf_move_up(int num)
{
  if (!context) {
    _movey(nll_stdout, -num);
    _flush(nll_stdout);
    return 0;
  }

  if (num > context->cursor.y)
    num = context->cursor.y;

  context->cursor.y -= num;

  return 0;
}

int framebuf_move_down(int num)
{
  if (!context) {
    _movey(nll_stdout, num);
    _flush(nll_stdout);
    return 0;
  }

  if (num > context->height - 1 - context->cursor.y)
    num = context->height - 1 - context->cursor.y;

  context->cursor.y += num;

  return 0;
}

int framebuf_getch(int x, int y)
{
  if (!context) {
    return -1;
  }

  x = ((x < 0) || (x > context->width - 1)) ? context->cursor.x : x;
  y = ((y < 0) || (y > context->height - 1)) ? context->cursor.y : y;

  return context->line[y].buffer->chara[x];
}

int framebuf_clear(int chara, int flags)
{
  if (!context) {
    if (chara >= 0) {
      _clear(nll_stdout);
      _flush(nll_stdout);
    }
    return 0;
  }

  chara = (chara < 0) ? ' ' : chara;

  lineclear(context, chara, context->cursor.attr);

  if ((flags | context->flags) & (1 << 1))
    flush(context, flags);

  return 0;
}

static int _scroll_x(int num, int chara)
{
  int i, x, n;
  struct linebuf *buffer;

  if (!context) {
    return 0;
  }

  for (i = 0; i < context->height; i++) {
    buffer = context->line[i].buffer;
    for (x = 0; x < context->width; x++) {
      n = (num < 0) ? context->width - x - 1 : x;
      if ((n + num < 0) || (n + num > context->width - 1)) {
 buffer->chara[n] = chara;
 buffer->attr[n] = context->cursor.attr;
      } else {
 buffer->chara[n] = buffer->chara[n + num];
 buffer->attr[n] = buffer->attr[n + num];
      }
    }
    context->line[i].flags |= (1 << 0);
  }

  return 0;
}

static int _scroll_up(int num, int chara)
{
  int i;
  struct linebuf *buffer;

  if (!context) {
    _scroll_y(nll_stdout, -num);
    _flush(nll_stdout);
    return 0;
  }

  for (i = context->height - 1; i >= 0; i--) {
    if (i >= num) {
      buffer = context->line[i].buffer;
      context->line[i].buffer = context->line[i - num].buffer;
      context->line[i - num].buffer = buffer;
    } else {
      frameline_clear(&context->line[i], context->width, chara, context->cursor.attr);
    }
    context->line[i].flags |= (1 << 0);
  }

  return 0;
}

static int _scroll_down(int num, int chara)
{
  int i;
  struct linebuf *buffer;

  if (!context) {
    _scroll_y(nll_stdout, num);
    _flush(nll_stdout);
    return 0;
  }

  for (i = 0; i < context->height; i++) {
    if (i + num < context->height) {
      buffer = context->line[i].buffer;
      context->line[i].buffer = context->line[i + num].buffer;
      context->line[i + num].buffer = buffer;
    } else {
      frameline_clear(&context->line[i], context->width, chara, context->cursor.attr);
    }
    context->line[i].flags |= (1 << 0);
  }

  return 0;
}

int framebuf_scroll(int x, int y, int chara)
{
  chara = (chara < 0) ? ' ' : chara;

  if (x) _scroll_x(x, chara);
  if (y < 0) _scroll_up(-y, chara);
  else if (y > 0) _scroll_down(y, chara);

  if (context->flags & (1 << 1))
    flush(context, 0);

  return 0;
}

int framebuf_puts(const char *str)
{
  int len, i;

  if (!context) {
    nll_wait_output(nll_stdout);
    fputs(str, nll_stdout);
    _flush(nll_stdout);
    return 0;
  }

  len = strlen(str);

  for (i = 0; i < len; i++) {
    switch (str[i]) {
    case '\n':
      goto newline;

    default:
      if (context->cursor.x < context->width) {
 context->line[context->cursor.y].buffer->chara[context->cursor.x] = str[i];
 context->line[context->cursor.y].buffer->attr[context->cursor.x] = context->cursor.attr;
 context->line[context->cursor.y].flags |= (1 << 0);
 if (++context->cursor.x >= context->width)
   goto newline;
      }
      break;

    newline:
      context->cursor.x = 0;
      if (context->cursor.y < context->height - 1)
 context->cursor.y++;
      else
 _scroll_down(1, ' ');
      break;
    }
  }

  if (context->flags & (1 << 1))
    flush(context, 0);

  return 0;
}

static int _cursorpos(int *x, int *y)
{
  if (!context) {
    *x = (*x == 0x7FFFFFFF) ? 0 : *x;
    *y = (*y == 0x7FFFFFFF) ? 0 : *y;
    return 0;
  }

  *x = (*x == 0x7FFFFFFF) ? context->cursor.x : *x;
  *y = (*y == 0x7FFFFFFF) ? context->cursor.y : *y;

  return 0;
}

static int _put(int x, int y, const char *str)
{
  if ((x < 0) || (y < 0))
    return -1;
  if (context) {
    if ((x > context->width - 1) || (y > context->height - 1))
      return -1;
  }
  framebuf_move_cursor(x, y);
  framebuf_puts(str);
  return 0;
}

int framebuf_line(int x0, int y0, int x1, int y1, const char *str)
{
  int nx, ny, n, d, dx, dy;

  _cursorpos(&x0, &y0);
  _cursorpos(&x1, &y1);

  nx = (x0 < x1) ? x1 - x0 : x0 - x1;
  ny = (y0 < y1) ? y1 - y0 : y0 - y1;

  n = (nx > ny) ? nx : ny;

  for (d = 0; d <= n; d++) {
    if (!n) {
      dx = x0;
      dy = y0;
    } else {
      if (nx > ny) {
 dx = (x0 < x1) ? (x0 + d) : (x0 - d);
 dy = (y0 < y1) ? (y0 + d * ny / n) : (y0 - d * ny / n);
      } else {
 dx = (x0 < x1) ? (x0 + d * nx / n) : (x0 - d * nx / n);
 dy = (y0 < y1) ? (y0 + d) : (y0 - d);
      }
    }
    _put(dx, dy, str);
  }

  return 0;
}

int framebuf_box(int x0, int y0, int x1, int y1, const char *str, int flags)
{
  int x, y;

  _cursorpos(&x0, &y0);
  _cursorpos(&x1, &y1);

  if (x0 > x1) { x = x0; x0 = x1; x1 = x; }
  if (y0 > y1) { y = y0; y0 = y1; y1 = y; }

  if (flags & (1 << 0)) {
    for (y = y0; y <= y1; y++) {
      for (x = x0; x <= x1; x++) {
 _put(x, y, str);
      }
    }
  } else {
    for (x = x0; x <= x1; x++)
      _put(x, y0, str);
    if (y0 < y1) {
      for (x = x0; x <= x1; x++)
 _put(x, y1, str);
    }
    if (y0 + 1 < y1) {
      for (y = y0 + 1; y <= y1 - 1; y++)
 _put(x0, y, str);
      if (x0 < x1) {
 for (y = y0 + 1; y <= y1 - 1; y++)
   _put(x1, y, str);
      }
    }
  }

  return 0;
}

key_code_t framebuf_getkey(void)
{
  int key;
  key = nll_term_key(context ? context->flags : 0);

  switch (key) {
  case 0x4f64: return KEY_CODE_END;
  case 0x5b41: return KEY_CODE_UP;
  case 0x5b42: return KEY_CODE_DOWN;
  case 0x5b43: return KEY_CODE_RIGHT;
  case 0x5b44: return KEY_CODE_LEFT;
  case 0x5b357e: return KEY_CODE_PAGEUP;
  case 0x5b367e: return KEY_CODE_PAGEDOWN;
  default:
    break;
  }

  return key;
}
