# 1 "constval.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "constval.c"
# 1 "config.h" 1
# 2 "constval.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "constval.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "constval.c" 2
# 1 "../include/unistd.h" 1
# 14 "../include/unistd.h"
void _exit(int status);
pid_t fork(void);
int execve(const char *path, char *const argv[], char *const envp[]);

ssize_t read(int fd, void *buf, size_t nbytes);
ssize_t write(int fd, const void *buf, size_t nbytes);
int close(int fd);

int dup(int oldd);
int pipe(int fildes[2]);
int dup2(int oldd, int newd);
int pipe2(int fildes[2], int flags);

pid_t getpid(void);
pid_t getppid(void);
pid_t getsid(pid_t pid);
pid_t setsid(void);
pid_t getpgid(pid_t pid);
int setpgid(pid_t pid, pid_t pgrp);
pid_t getpgrp(void);

pid_t tcgetpgrp(int fd);
int tcsetpgrp(int fd, pid_t pgrp_id);

int unlink(const char *path);
int chdir(const char *path);
int chdir(const char *path);
int fchdir(int fd);
int chown(const char *path, uid_t owner, gid_t group);
off_t lseek(int fildes, off_t offset, int whence);
int access(const char *path, int mode);
void sync(void);
int fsync(int fd);
int fchown(int fd, uid_t owner, gid_t group);

int truncate(const char *path, off_t length);
int ftruncate(int fd, off_t length);


int brk(void *addr);



void *sbrk(intptr_t incr);

char *getcwd(char *buf, size_t size);

unsigned int sleep(unsigned int seconds);
int usleep(useconds_t microseconds);

int isatty(int fd);
# 6 "constval.c" 2
# 1 "../include/fcntl.h" 1
# 42 "../include/fcntl.h"
int open(const char *path, int flags, ...);

int fcntl(int fd, int cmd, int args);
# 7 "constval.c" 2





# 1 "../include/sys/socket.h" 1
# 13 "constval.c" 2





# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 19 "constval.c" 2


# 1 "const.h" 1
# 22 "constval.c" 2
# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 23 "constval.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 24 "constval.c" 2
# 1 "key.h" 1



typedef enum {
  KEY_CODE_NONE = 0,

  KEY_CODE_ENTER = '\n',
  KEY_CODE_ESCAPE = 0x1b,
  KEY_CODE_BACKSPACE = '\b',
  KEY_CODE_TAB = '\t',
  KEY_CODE_SPACE = ' ',
  KEY_CODE_EXCLAIM = '!',
  KEY_CODE_QUOTEDBL = '"',
  KEY_CODE_HASH = '#',
  KEY_CODE_PERCENT = '%',
  KEY_CODE_DOLLAR = '$',
  KEY_CODE_AMPERSAND = '&',
  KEY_CODE_QUOTE = '\'',
  KEY_CODE_LEFTPAREN = '(',
  KEY_CODE_RIGHTPAREN = ')',
  KEY_CODE_ASTERISK = '*',
  KEY_CODE_PLUS = '+',
  KEY_CODE_COMMA = ',',
  KEY_CODE_MINUS = '-',
  KEY_CODE_PERIOD = '.',
  KEY_CODE_SLASH = '/',
  KEY_CODE_0 = '0',
  KEY_CODE_1 = '1',
  KEY_CODE_2 = '2',
  KEY_CODE_3 = '3',
  KEY_CODE_4 = '4',
  KEY_CODE_5 = '5',
  KEY_CODE_6 = '6',
  KEY_CODE_7 = '7',
  KEY_CODE_8 = '8',
  KEY_CODE_9 = '9',
  KEY_CODE_COLON = ':',
  KEY_CODE_SEMICOLON = ';',
  KEY_CODE_LESS = '<',
  KEY_CODE_EQUALS = '=',
  KEY_CODE_GREATER = '>',
  KEY_CODE_QUESTION = '?',
  KEY_CODE_AT = '@',
  KEY_CODE_LEFTBRACKET = '[',
  KEY_CODE_BACKSLASH = '\\',
  KEY_CODE_RIGHTBRACKET = ']',
  KEY_CODE_CARET = '^',
  KEY_CODE_UNDERSCORE = '_',
  KEY_CODE_BACKQUOTE = '`',
  KEY_CODE_A = 'a',
  KEY_CODE_B = 'b',
  KEY_CODE_C = 'c',
  KEY_CODE_D = 'd',
  KEY_CODE_E = 'e',
  KEY_CODE_F = 'f',
  KEY_CODE_G = 'g',
  KEY_CODE_H = 'h',
  KEY_CODE_I = 'i',
  KEY_CODE_J = 'j',
  KEY_CODE_K = 'k',
  KEY_CODE_L = 'l',
  KEY_CODE_M = 'm',
  KEY_CODE_N = 'n',
  KEY_CODE_O = 'o',
  KEY_CODE_P = 'p',
  KEY_CODE_Q = 'q',
  KEY_CODE_R = 'r',
  KEY_CODE_S = 's',
  KEY_CODE_T = 't',
  KEY_CODE_U = 'u',
  KEY_CODE_V = 'v',
  KEY_CODE_W = 'w',
  KEY_CODE_X = 'x',
  KEY_CODE_Y = 'y',
  KEY_CODE_Z = 'z',

  KEY_CODE_CAPSLOCK = 128,
  KEY_CODE_F1,
  KEY_CODE_F2,
  KEY_CODE_F3,
  KEY_CODE_F4,
  KEY_CODE_F5,
  KEY_CODE_F6,
  KEY_CODE_F7,
  KEY_CODE_F8,
  KEY_CODE_F9,
  KEY_CODE_F10,
  KEY_CODE_F11,
  KEY_CODE_F12,

  KEY_CODE_PRINTSCREEN,
  KEY_CODE_SCROLLLOCK,
  KEY_CODE_PAUSE,
  KEY_CODE_INSERT,
  KEY_CODE_HOME,
  KEY_CODE_PAGEUP,
  KEY_CODE_DELETE,
  KEY_CODE_END,
  KEY_CODE_PAGEDOWN,
  KEY_CODE_RIGHT,
  KEY_CODE_LEFT,
  KEY_CODE_DOWN,
  KEY_CODE_UP,

  KEY_CODE_F13,
  KEY_CODE_F14,
  KEY_CODE_F15,

  KEY_CODE_LCTRL,
  KEY_CODE_LSHIFT,
  KEY_CODE_LALT,
  KEY_CODE_RCTRL,
  KEY_CODE_RSHIFT,
  KEY_CODE_RALT,

  KEY_CODE_NUM
} key_code_t;
# 228 "key.h"
const char *keyname_get(key_code_t code);
key_code_t keycode_get(const char *name);
# 25 "constval.c" 2
# 1 "constval.h" 1



struct const_variable {
  const char *name;
  unsigned int flags;
  value_type_t type;
  integer_t integer;
  const char *string;
  void *pointer;
};

extern const struct const_variable const_variables[];

extern const double const_variables_floating[];
# 26 "constval.c" 2

const struct const_variable const_variables[] = {

  { "VERSION" , (1 << 0), VALUE_TYPE_STRING , 0, "20251213a" , ((void *)0) },


  { "UNDEF" , (1 << 1),VALUE_TYPE_UNDEFINED, 0 , ((void *)0), ((void *)0) },
  { "NULL" , (1 << 0), VALUE_TYPE_NULL , 0 , ((void *)0), ((void *)0) },
  { "NULLSTR" , (1 << 0), VALUE_TYPE_STRING , 0 , ((void *)0), ((void *)0) },
  { "NULLARRAY" , (1 << 0), VALUE_TYPE_ARRAY , 0 , ((void *)0), ((void *)0) },
  { "NULLMEM" , (1 << 0), VALUE_TYPE_AREA , 0 , ((void *)0), ((void *)0) },
  { "NULLPTR" , (1 << 0), VALUE_TYPE_POINTER , 0 , ((void *)0), ((void *)0) },
  { "NULLFUNC" , (1 << 0), VALUE_TYPE_FUNCTION , 0 , ((void *)0), ((void *)0) },
  { "NULLLABEL" , (1 << 0), VALUE_TYPE_LABEL , 0 , ((void *)0), ((void *)0) },

  { "T_UNKNOWN" , (1 << 0), VALUE_TYPE_INTEGER , -1 , ((void *)0), ((void *)0) },
  { "T_UNDEFINED" , (1 << 0), VALUE_TYPE_INTEGER , 0 , ((void *)0), ((void *)0) },
  { "T_NULL" , (1 << 0), VALUE_TYPE_INTEGER , 1 , ((void *)0), ((void *)0) },
  { "T_VALUE" , (1 << 0), VALUE_TYPE_INTEGER , 2 , ((void *)0), ((void *)0) },
  { "T_VECTOR" , (1 << 0), VALUE_TYPE_INTEGER , 3 , ((void *)0), ((void *)0) },
  { "T_INTEGER" , (1 << 0), VALUE_TYPE_INTEGER , 4 , ((void *)0), ((void *)0) },
  { "T_STRING" , (1 << 0), VALUE_TYPE_INTEGER , 5 , ((void *)0), ((void *)0) },

  { "T_FLOAT" , (1 << 0), VALUE_TYPE_INTEGER , 6 , ((void *)0), ((void *)0) },

  { "T_ARRAY" , (1 << 0), VALUE_TYPE_INTEGER , 7 , ((void *)0), ((void *)0) },
  { "T_AREA" , (1 << 0), VALUE_TYPE_INTEGER , 8 , ((void *)0), ((void *)0) },
  { "T_POINTER" , (1 << 0), VALUE_TYPE_INTEGER , 9 , ((void *)0), ((void *)0) },
  { "T_FUNCTION" , (1 << 0), VALUE_TYPE_INTEGER , 10 , ((void *)0), ((void *)0) },
  { "T_LABEL" , (1 << 0), VALUE_TYPE_INTEGER , 11 , ((void *)0), ((void *)0) },

  { "D_VARIABLE" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 0) , ((void *)0), ((void *)0) },
  { "D_STRING" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 1) , ((void *)0), ((void *)0) },
  { "D_LABEL" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 2) , ((void *)0), ((void *)0) },
  { "D_LINE" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 3) , ((void *)0), ((void *)0) },
  { "D_STACK" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 4) , ((void *)0), ((void *)0) },
  { "D_POSITION" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 5) , ((void *)0), ((void *)0) },
  { "D_ALL" , (1 << 0), VALUE_TYPE_INTEGER , ((1 << 0)|(1 << 1)|(1 << 2)|(1 << 3)|(1 << 4)|(1 << 5)) , ((void *)0), ((void *)0) },
  { "L_COMMAND" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 16) , ((void *)0), ((void *)0) },
  { "L_FUNCTION" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 17) , ((void *)0), ((void *)0) },
  { "L_CONST" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 18) , ((void *)0), ((void *)0) },
  { "L_OPERATOR" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 19) , ((void *)0), ((void *)0) },


  { "F_DISABLE" , (1 << 0), VALUE_TYPE_INTEGER , 0 , ((void *)0), ((void *)0) },
  { "F_ENABLE" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 0) , ((void *)0), ((void *)0) },
  { "F_BUFFER" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 0) , ((void *)0), ((void *)0) },
  { "F_FLUSH" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 1) , ((void *)0), ((void *)0) },
  { "F_CURSOR" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 2) , ((void *)0), ((void *)0) },
  { "F_CURSES" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 3) , ((void *)0), ((void *)0) },
  { "F_FORCE" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 4) , ((void *)0), ((void *)0) },

  { "F_FILL" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 0) , ((void *)0), ((void *)0) },

  { "F_CURSORPOS" , (1 << 0), VALUE_TYPE_INTEGER , 0x7FFFFFFF , ((void *)0), ((void *)0) },

  { "C_RESET" , (1 << 0), VALUE_TYPE_INTEGER , 9 , ((void *)0), ((void *)0) },
  { "C_BLACK" , (1 << 0), VALUE_TYPE_INTEGER , 0 , ((void *)0), ((void *)0) },
  { "C_RED" , (1 << 0), VALUE_TYPE_INTEGER , 1 , ((void *)0), ((void *)0) },
  { "C_GREEN" , (1 << 0), VALUE_TYPE_INTEGER , 2 , ((void *)0), ((void *)0) },
  { "C_YELLOW" , (1 << 0), VALUE_TYPE_INTEGER , 3 , ((void *)0), ((void *)0) },
  { "C_BLUE" , (1 << 0), VALUE_TYPE_INTEGER , 4 , ((void *)0), ((void *)0) },
  { "C_MAGENTA" , (1 << 0), VALUE_TYPE_INTEGER , 5 , ((void *)0), ((void *)0) },
  { "C_CYAN" , (1 << 0), VALUE_TYPE_INTEGER , 6 , ((void *)0), ((void *)0) },
  { "C_WHITE" , (1 << 0), VALUE_TYPE_INTEGER , 7 , ((void *)0), ((void *)0) },

  { "A_RESET" , (1 << 0), VALUE_TYPE_INTEGER , 0 , ((void *)0), ((void *)0) },
  { "A_BOLD" , (1 << 0), VALUE_TYPE_INTEGER , 1 , ((void *)0), ((void *)0) },
  { "A_FAINT" , (1 << 0), VALUE_TYPE_INTEGER , 2 , ((void *)0), ((void *)0) },
  { "A_ITALIC" , (1 << 0), VALUE_TYPE_INTEGER , 3 , ((void *)0), ((void *)0) },
  { "A_UNDERLINE" , (1 << 0), VALUE_TYPE_INTEGER , 4 , ((void *)0), ((void *)0) },
  { "A_BLINK" , (1 << 0), VALUE_TYPE_INTEGER , 5 , ((void *)0), ((void *)0) },
  { "A_RAPIDBLINK", (1 << 0), VALUE_TYPE_INTEGER , 6, ((void *)0), ((void *)0) },
  { "A_INVERSE" , (1 << 0), VALUE_TYPE_INTEGER , 7 , ((void *)0), ((void *)0) },
  { "A_INVISIBLE" , (1 << 0), VALUE_TYPE_INTEGER , 8 , ((void *)0), ((void *)0) },
  { "A_CROSSOUT" , (1 << 0), VALUE_TYPE_INTEGER , 9 , ((void *)0), ((void *)0) },


  { "KEY_ENTER" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_ENTER , ((void *)0), ((void *)0) },
  { "KEY_ESCAPE" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_ESCAPE , ((void *)0), ((void *)0) },
  { "KEY_BACKSPACE" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_BACKSPACE , ((void *)0), ((void *)0) },
  { "KEY_TAB" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_TAB , ((void *)0), ((void *)0) },
  { "KEY_SPACE" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_SPACE , ((void *)0), ((void *)0) },
  { "KEY_EXCLAIM" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_EXCLAIM , ((void *)0), ((void *)0) },
  { "KEY_QUOTEDBL" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_QUOTEDBL , ((void *)0), ((void *)0) },
  { "KEY_HASH" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_HASH , ((void *)0), ((void *)0) },
  { "KEY_PERCENT" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_PERCENT , ((void *)0), ((void *)0) },
  { "KEY_DOLLAR" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_DOLLAR , ((void *)0), ((void *)0) },
  { "KEY_AMPERSAND" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_AMPERSAND , ((void *)0), ((void *)0) },
  { "KEY_QUOTE" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_QUOTE , ((void *)0), ((void *)0) },
  { "KEY_LEFTPAREN" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_LEFTPAREN , ((void *)0), ((void *)0) },
  { "KEY_RIGHTPAREN" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_RIGHTPAREN , ((void *)0), ((void *)0) },
  { "KEY_ASTERISK" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_ASTERISK , ((void *)0), ((void *)0) },
  { "KEY_PLUS" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_PLUS , ((void *)0), ((void *)0) },
  { "KEY_COMMA" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_COMMA , ((void *)0), ((void *)0) },
  { "KEY_MINUS" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_MINUS , ((void *)0), ((void *)0) },
  { "KEY_PERIOD" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_PERIOD , ((void *)0), ((void *)0) },
  { "KEY_SLASH" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_SLASH , ((void *)0), ((void *)0) },
  { "KEY_0" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_0 , ((void *)0), ((void *)0) },
  { "KEY_1" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_1 , ((void *)0), ((void *)0) },
  { "KEY_2" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_2 , ((void *)0), ((void *)0) },
  { "KEY_3" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_3 , ((void *)0), ((void *)0) },
  { "KEY_4" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_4 , ((void *)0), ((void *)0) },
  { "KEY_5" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_5 , ((void *)0), ((void *)0) },
  { "KEY_6" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_6 , ((void *)0), ((void *)0) },
  { "KEY_7" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_7 , ((void *)0), ((void *)0) },
  { "KEY_8" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_8 , ((void *)0), ((void *)0) },
  { "KEY_9" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_9 , ((void *)0), ((void *)0) },
  { "KEY_COLON" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_COLON , ((void *)0), ((void *)0) },
  { "KEY_SEMICOLON" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_SEMICOLON , ((void *)0), ((void *)0) },
  { "KEY_LESS" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_LESS , ((void *)0), ((void *)0) },
  { "KEY_EQUALS" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_EQUALS , ((void *)0), ((void *)0) },
  { "KEY_GREATER" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_GREATER , ((void *)0), ((void *)0) },
  { "KEY_QUESTION" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_QUESTION , ((void *)0), ((void *)0) },
  { "KEY_AT" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_AT , ((void *)0), ((void *)0) },
  { "KEY_LEFTBRACKET" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_LEFTBRACKET , ((void *)0), ((void *)0) },
  { "KEY_BACKSLASH" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_BACKSLASH , ((void *)0), ((void *)0) },
  { "KEY_RIGHTBRACKET", (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_RIGHTBRACKET, ((void *)0), ((void *)0) },
  { "KEY_CARET" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_CARET , ((void *)0), ((void *)0) },
  { "KEY_UNDERSCORE" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_UNDERSCORE , ((void *)0), ((void *)0) },
  { "KEY_BACKQUOTE" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_BACKQUOTE , ((void *)0), ((void *)0) },
  { "KEY_A" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_A , ((void *)0), ((void *)0) },
  { "KEY_B" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_B , ((void *)0), ((void *)0) },
  { "KEY_C" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_C , ((void *)0), ((void *)0) },
  { "KEY_D" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_D , ((void *)0), ((void *)0) },
  { "KEY_E" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_E , ((void *)0), ((void *)0) },
  { "KEY_F" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F , ((void *)0), ((void *)0) },
  { "KEY_G" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_G , ((void *)0), ((void *)0) },
  { "KEY_H" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_H , ((void *)0), ((void *)0) },
  { "KEY_I" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_I , ((void *)0), ((void *)0) },
  { "KEY_J" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_J , ((void *)0), ((void *)0) },
  { "KEY_K" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_K , ((void *)0), ((void *)0) },
  { "KEY_L" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_L , ((void *)0), ((void *)0) },
  { "KEY_M" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_M , ((void *)0), ((void *)0) },
  { "KEY_N" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_N , ((void *)0), ((void *)0) },
  { "KEY_O" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_O , ((void *)0), ((void *)0) },
  { "KEY_P" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_P , ((void *)0), ((void *)0) },
  { "KEY_Q" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_Q , ((void *)0), ((void *)0) },
  { "KEY_R" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_R , ((void *)0), ((void *)0) },
  { "KEY_S" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_S , ((void *)0), ((void *)0) },
  { "KEY_T" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_T , ((void *)0), ((void *)0) },
  { "KEY_U" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_U , ((void *)0), ((void *)0) },
  { "KEY_V" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_V , ((void *)0), ((void *)0) },
  { "KEY_W" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_W , ((void *)0), ((void *)0) },
  { "KEY_X" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_X , ((void *)0), ((void *)0) },
  { "KEY_Y" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_Y , ((void *)0), ((void *)0) },
  { "KEY_Z" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_Z , ((void *)0), ((void *)0) },

  { "KEY_CAPSLOCK" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_CAPSLOCK , ((void *)0), ((void *)0) },
  { "KEY_F1" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F1 , ((void *)0), ((void *)0) },
  { "KEY_F2" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F2 , ((void *)0), ((void *)0) },
  { "KEY_F3" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F3 , ((void *)0), ((void *)0) },
  { "KEY_F4" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F4 , ((void *)0), ((void *)0) },
  { "KEY_F5" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F5 , ((void *)0), ((void *)0) },
  { "KEY_F6" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F6 , ((void *)0), ((void *)0) },
  { "KEY_F7" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F7 , ((void *)0), ((void *)0) },
  { "KEY_F8" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F8 , ((void *)0), ((void *)0) },
  { "KEY_F9" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F9 , ((void *)0), ((void *)0) },
  { "KEY_F10" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F10 , ((void *)0), ((void *)0) },
  { "KEY_F11" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F11 , ((void *)0), ((void *)0) },
  { "KEY_F12" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F12 , ((void *)0), ((void *)0) },

  { "KEY_PRINTSCREEN" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_PRINTSCREEN , ((void *)0), ((void *)0) },
  { "KEY_SCROLLLOCK" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_SCROLLLOCK , ((void *)0), ((void *)0) },
  { "KEY_PAUSE" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_PAUSE , ((void *)0), ((void *)0) },
  { "KEY_INSERT" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_INSERT , ((void *)0), ((void *)0) },
  { "KEY_HOME" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_HOME , ((void *)0), ((void *)0) },
  { "KEY_PAGEUP" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_PAGEUP , ((void *)0), ((void *)0) },
  { "KEY_DELETE" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_DELETE , ((void *)0), ((void *)0) },
  { "KEY_END" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_END , ((void *)0), ((void *)0) },
  { "KEY_PAGEDOWN" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_PAGEDOWN , ((void *)0), ((void *)0) },
  { "KEY_RIGHT" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_RIGHT , ((void *)0), ((void *)0) },
  { "KEY_LEFT" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_LEFT , ((void *)0), ((void *)0) },
  { "KEY_DOWN" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_DOWN , ((void *)0), ((void *)0) },
  { "KEY_UP" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_UP , ((void *)0), ((void *)0) },

  { "KEY_F13" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F13 , ((void *)0), ((void *)0) },
  { "KEY_F14" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F14 , ((void *)0), ((void *)0) },
  { "KEY_F15" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_F15 , ((void *)0), ((void *)0) },

  { "KEY_LCTRL" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_LCTRL , ((void *)0), ((void *)0) },
  { "KEY_LSHIFT" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_LSHIFT , ((void *)0), ((void *)0) },
  { "KEY_LALT" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_LALT , ((void *)0), ((void *)0) },
  { "KEY_RCTRL" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_RCTRL , ((void *)0), ((void *)0) },
  { "KEY_RSHIFT" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_RSHIFT , ((void *)0), ((void *)0) },
  { "KEY_RALT" , (1 << 0), VALUE_TYPE_INTEGER , KEY_CODE_RALT , ((void *)0), ((void *)0) },


  { "O_RDONLY" , (1 << 0), VALUE_TYPE_INTEGER , 00000 , ((void *)0), ((void *)0) },


  { "O_WRONLY" , (1 << 0), VALUE_TYPE_INTEGER , 00001 , ((void *)0), ((void *)0) },


  { "O_RDWR" , (1 << 0), VALUE_TYPE_INTEGER , 00002 , ((void *)0), ((void *)0) },


  { "O_ACCMODE" , (1 << 0), VALUE_TYPE_INTEGER , 00003 , ((void *)0), ((void *)0) },


  { "O_APPEND" , (1 << 0), VALUE_TYPE_INTEGER , 02000 , ((void *)0), ((void *)0) },


  { "O_CREAT" , (1 << 0), VALUE_TYPE_INTEGER , 00100 , ((void *)0), ((void *)0) },


  { "O_TRUNC" , (1 << 0), VALUE_TYPE_INTEGER , 01000 , ((void *)0), ((void *)0) },
# 244 "constval.c"
  { "SEEK_SET" , (1 << 0), VALUE_TYPE_INTEGER , 0 , ((void *)0), ((void *)0) },


  { "SEEK_CUR" , (1 << 0), VALUE_TYPE_INTEGER , 1 , ((void *)0), ((void *)0) },


  { "SEEK_END" , (1 << 0), VALUE_TYPE_INTEGER , 2 , ((void *)0), ((void *)0) },


  { "INADDR_ANY" , (1 << 0), VALUE_TYPE_STRING, 0, "0.0.0.0" , ((void *)0) },
  { "INADDR_BROADCAST", (1 << 0), VALUE_TYPE_STRING, 0, "255.255.255.255", ((void *)0) },
  { "INADDR_LOOPBACK" , (1 << 0), VALUE_TYPE_STRING, 0, "127.0.0.1" , ((void *)0) },
  { "IN6ADDR_ANY" , (1 << 0), VALUE_TYPE_STRING, 0, "::" , ((void *)0) },
  { "IN6ADDR_LOOPBACK", (1 << 0), VALUE_TYPE_STRING, 0, "::1" , ((void *)0) },


  { "AF_UNIX" , (1 << 0), VALUE_TYPE_INTEGER , 1 , ((void *)0), ((void *)0) },


  { "AF_INET" , (1 << 0), VALUE_TYPE_INTEGER , 2 , ((void *)0), ((void *)0) },


  { "AF_INET6" , (1 << 0), VALUE_TYPE_INTEGER , 10 , ((void *)0), ((void *)0) },
# 292 "constval.c"
  { "G_DISABLE" , (1 << 0), VALUE_TYPE_INTEGER , 0 , ((void *)0), ((void *)0) },
  { "G_ENABLE" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 0) , ((void *)0), ((void *)0) },
  { "G_DIRECT" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 0) , ((void *)0), ((void *)0) },
  { "G_BUFFER" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 1) , ((void *)0), ((void *)0) },
  { "G_RENDERER" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 2) , ((void *)0), ((void *)0) },
  { "G_FORCE" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 3) , ((void *)0), ((void *)0) },
  { "G_SYNC" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 4) , ((void *)0), ((void *)0) },
  { "G_FLUSH" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 5) , ((void *)0), ((void *)0) },
  { "G_ROUGH" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 6) , ((void *)0), ((void *)0) },
  { "G_HROUGH" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 7) , ((void *)0), ((void *)0) },

  { "G_CONST" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 8) , ((void *)0), ((void *)0) },
  { "G_STATIC" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 9) , ((void *)0), ((void *)0) },
  { "G_RDONLY" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 10) , ((void *)0), ((void *)0) },
  { "G_NDRAWPIXEL", (1 << 0), VALUE_TYPE_INTEGER , (1 << 11), ((void *)0), ((void *)0) },
  { "G_NDRAWLNCL" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 12) , ((void *)0), ((void *)0) },
  { "G_NDRAWALL" , (1 << 0), VALUE_TYPE_INTEGER , ((1 << 11)|(1 << 12)) , ((void *)0), ((void *)0) },
  { "G_AUTOCOLOR" , (1 << 0), VALUE_TYPE_INTEGER , (0 << 13) , ((void *)0), ((void *)0) },
  { "G_FULLCOLOR" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 13) , ((void *)0), ((void *)0) },
  { "G_MONOCOLOR" , (1 << 0), VALUE_TYPE_INTEGER , (2 << 13) , ((void *)0), ((void *)0) },
  { "G_MONOBCOLOR", (1 << 0), VALUE_TYPE_INTEGER , (3 << 13), ((void *)0), ((void *)0) },
  { "G_BASICCOLOR", (1 << 0), VALUE_TYPE_INTEGER , (4 << 13), ((void *)0), ((void *)0) },
  { "G_ROUGHCOLOR", (1 << 0), VALUE_TYPE_INTEGER , (5 << 13), ((void *)0), ((void *)0) },
  { "G_GRAYCOLOR" , (1 << 0), VALUE_TYPE_INTEGER , (6 << 13) , ((void *)0), ((void *)0) },
  { "G_HALFCOLOR" , (1 << 0), VALUE_TYPE_INTEGER , (7 << 13) , ((void *)0), ((void *)0) },

  { "G_SET" , (1 << 0), VALUE_TYPE_INTEGER , (0 << 16) , ((void *)0), ((void *)0) },
  { "G_AND" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 16) , ((void *)0), ((void *)0) },
  { "G_OR" , (1 << 0), VALUE_TYPE_INTEGER , (2 << 16) , ((void *)0), ((void *)0) },
  { "G_XOR" , (1 << 0), VALUE_TYPE_INTEGER , (3 << 16) , ((void *)0), ((void *)0) },
  { "G_FILL" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 18) , ((void *)0), ((void *)0) },
  { "G_ODDPOS" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 19) , ((void *)0), ((void *)0) },
  { "G_EVENPOS" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 20) , ((void *)0), ((void *)0) },
  { "G_NUPDATE" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 21) , ((void *)0), ((void *)0) },
  { "G_OFFSET" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 22) , ((void *)0), ((void *)0) },

  { "G_MAINIMG" , (1 << 0), VALUE_TYPE_INTEGER , -1 , ((void *)0), ((void *)0) },

  { "G_FONT8X8" , (1 << 0), VALUE_TYPE_INTEGER , 0 , ((void *)0), ((void *)0) },
  { "G_FONT16X16" , (1 << 0), VALUE_TYPE_INTEGER , 1 , ((void *)0), ((void *)0) },
  { "G_FONT5X5" , (1 << 0), VALUE_TYPE_INTEGER , 2 , ((void *)0), ((void *)0) },
  { "G_CHARA" , (1 << 0), VALUE_TYPE_INTEGER , 3 , ((void *)0), ((void *)0) },
  { "G_CHARA2" , (1 << 0), VALUE_TYPE_INTEGER , 4 , ((void *)0), ((void *)0) },
  { "G_CHARA3" , (1 << 0), VALUE_TYPE_INTEGER , 5 , ((void *)0), ((void *)0) },

  { "G_DEFAULT" , (1 << 0), VALUE_TYPE_INTEGER , 0x7FFFFFFF , ((void *)0), ((void *)0) },

  { "G_BLACK" , (1 << 0), VALUE_TYPE_INTEGER , 0x000000 , ((void *)0), ((void *)0) },
  { "G_BLUE" , (1 << 0), VALUE_TYPE_INTEGER , 0x0000FF , ((void *)0), ((void *)0) },
  { "G_GREEN" , (1 << 0), VALUE_TYPE_INTEGER , 0x00FF00 , ((void *)0), ((void *)0) },
  { "G_CYAN" , (1 << 0), VALUE_TYPE_INTEGER , 0x00FFFF , ((void *)0), ((void *)0) },
  { "G_RED" , (1 << 0), VALUE_TYPE_INTEGER , 0xFF0000 , ((void *)0), ((void *)0) },
  { "G_MAGENTA" , (1 << 0), VALUE_TYPE_INTEGER , 0xFF00FF , ((void *)0), ((void *)0) },
  { "G_YELLOW" , (1 << 0), VALUE_TYPE_INTEGER , 0xFFFF00 , ((void *)0), ((void *)0) },
  { "G_WHITE" , (1 << 0), VALUE_TYPE_INTEGER , 0xFFFFFF , ((void *)0), ((void *)0) },

  { "G_TRANSPARENT", (1 << 0), VALUE_TYPE_INTEGER , -1,((void *)0), ((void *)0) },



  { "A_OUTPUT" , (1 << 0), VALUE_TYPE_INTEGER , 0 , ((void *)0), ((void *)0) },
  { "A_NOOUT" , (1 << 0), VALUE_TYPE_INTEGER , -1 , ((void *)0), ((void *)0) },

  { "A_SIN" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x0 << 24) , ((void *)0), ((void *)0) },
  { "A_TRIANGLE" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x1 << 24) , ((void *)0), ((void *)0) },
  { "A_SQUARE" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x2 << 24) , ((void *)0), ((void *)0) },
  { "A_PULSE" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x3 << 24) , ((void *)0), ((void *)0) },
  { "A_SAWUP" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x4 << 24) , ((void *)0), ((void *)0) },
  { "A_SAWDOWN" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x5 << 24) , ((void *)0), ((void *)0) },
  { "A_SAWTOOTH" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x5 << 24) , ((void *)0), ((void *)0) },
  { "A_RANDOM" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x6 << 24) , ((void *)0), ((void *)0) },
  { "A_NOISE" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x7 << 24) , ((void *)0), ((void *)0) },
  { "A_ZERO" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x8 << 24) , ((void *)0), ((void *)0) },
  { "A_HIGH" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x9 << 24) , ((void *)0), ((void *)0) },
  { "A_INPULSE" , (1 << 0), VALUE_TYPE_INTEGER , ( 0xA << 24) , ((void *)0), ((void *)0) },
  { "A_EXTIN" , (1 << 0), VALUE_TYPE_INTEGER , ( 0xB << 24) , ((void *)0), ((void *)0) },
  { "A_DATA" , (1 << 0), VALUE_TYPE_INTEGER , ( 0xC << 24) , ((void *)0), ((void *)0) },

  { "A_FLUSH" , (1 << 0), VALUE_TYPE_INTEGER , 0 , ((void *)0), ((void *)0) },
  { "A_FIXED" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 0) , ((void *)0), ((void *)0) },
  { "A_ENVCLEAR" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 1) , ((void *)0), ((void *)0) },
  { "A_ENVFDOUT" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 2) , ((void *)0), ((void *)0) },
  { "A_ENVFDIN" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 3) , ((void *)0), ((void *)0) },
  { "A_ENVFIXED" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 4) , ((void *)0), ((void *)0) },
  { "A_FILCLEAR" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 5) , ((void *)0), ((void *)0) },
  { "A_FILFIXED" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 6) , ((void *)0), ((void *)0) },
  { "A_FILINC" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 7) , ((void *)0), ((void *)0) },
  { "A_FILDEC" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 8) , ((void *)0), ((void *)0) },
  { "A_SAVE" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 9) , ((void *)0), ((void *)0) },
  { "A_NEW" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 10) , ((void *)0), ((void *)0) },
  { "A_REMAIN" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 11) , ((void *)0), ((void *)0) },
  { "A_STEREO" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 12) , ((void *)0), ((void *)0) },
  { "A_TEXT" , (1 << 0), VALUE_TYPE_INTEGER , (1 << 13) , ((void *)0), ((void *)0) },

  { "A_PHASE" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x0 << 24) , ((void *)0), ((void *)0) },
  { "A_FREQ" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x1 << 24) , ((void *)0), ((void *)0) },
  { "A_NULL" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x2 << 24) , ((void *)0), ((void *)0) },
  { "A_REV" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x3 << 24) , ((void *)0), ((void *)0) },
  { "A_ABS" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x4 << 24) , ((void *)0), ((void *)0) },
  { "A_INV" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x5 << 24) , ((void *)0), ((void *)0) },
  { "A_SIGN" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x6 << 24) , ((void *)0), ((void *)0) },
  { "A_CLIP" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x7 << 24) , ((void *)0), ((void *)0) },
  { "A_ADD" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x8 << 24) , ((void *)0), ((void *)0) },
  { "A_SUB" , (1 << 0), VALUE_TYPE_INTEGER , ( 0x9 << 24) , ((void *)0), ((void *)0) },
  { "A_MUL" , (1 << 0), VALUE_TYPE_INTEGER , ( 0xA << 24) , ((void *)0), ((void *)0) },
  { "A_AND" , (1 << 0), VALUE_TYPE_INTEGER , ( 0xB << 24) , ((void *)0), ((void *)0) },
  { "A_OR" , (1 << 0), VALUE_TYPE_INTEGER , ( 0xC << 24) , ((void *)0), ((void *)0) },
  { "A_XOR" , (1 << 0), VALUE_TYPE_INTEGER , ( 0xD << 24) , ((void *)0), ((void *)0) },
  { "A_AVE" , (1 << 0), VALUE_TYPE_INTEGER , ( 0xE << 24) , ((void *)0), ((void *)0) },
  { "A_PER" , (1 << 0), VALUE_TYPE_INTEGER , ( 0xF << 24) , ((void *)0), ((void *)0) },
  { "A_MIN" , (1 << 0), VALUE_TYPE_INTEGER , (0x10 << 24) , ((void *)0), ((void *)0) },
  { "A_MAX" , (1 << 0), VALUE_TYPE_INTEGER , (0x11 << 24) , ((void *)0), ((void *)0) },
  { "A_LT" , (1 << 0), VALUE_TYPE_INTEGER , (0x12 << 24) , ((void *)0), ((void *)0) },
  { "A_GT" , (1 << 0), VALUE_TYPE_INTEGER , (0x13 << 24) , ((void *)0), ((void *)0) },

  { "A_FILFW" , (1 << 0), VALUE_TYPE_INTEGER , 0 , ((void *)0), ((void *)0) },
  { "A_FILBW" , (1 << 0), VALUE_TYPE_INTEGER , 1 , ((void *)0), ((void *)0) },

  { "A_NULLUNITSET",(1 << 0), VALUE_TYPE_INTEGER , -1,((void *)0), ((void *)0) },
  { "A_DEFUNITSET", (1 << 0), VALUE_TYPE_INTEGER , 0, ((void *)0), ((void *)0) },


  { ((void *)0) , 0 , VALUE_TYPE_UNDEFINED, 0 , ((void *)0), ((void *)0) }
};


const double const_variables_floating[] = {




  0.0
};
