#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "const.h"
#include "image.h"
#include "charset.h"

#define CHARACTER_SIZE 5

#ifdef USE_GRAPHIC
static GRAPHIC_CHARACTER_PRESET_TYPE unsigned char bitmap[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x00 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x01 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x02 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x03 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x04 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x05 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x06 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x07 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x08 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x09 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0a */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0b */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0c */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0d */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0e */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0f */

  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x10 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x11 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x12 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x13 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x14 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x15 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x16 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x17 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x18 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x19 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x1a */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x1b */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x1c */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x1d */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x1e */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x1f */

  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x20   (space) */
  0x06, 0x06, 0x06, 0x00, 0x06, /* 0x21 ! (exclamation) */
  0x0a, 0x0a, 0x00, 0x00, 0x00, /* 0x22 " (double quotation) */
  0x0a, 0x1f, 0x0a, 0x1f, 0x0a, /* 0x23 # (hash) */
  0x0e, 0x05, 0x0e, 0x14, 0x0e, /* 0x24 $ (dollar) */
  0x00, 0x09, 0x04, 0x02, 0x09, /* 0x25 % (percent) */
  0x02, 0x05, 0x16, 0x0d, 0x16, /* 0x26 & (ampersand) */
  0x04, 0x04, 0x00, 0x00, 0x00, /* 0x27 ' (single quotation) */
  0x0c, 0x06, 0x06, 0x06, 0x0c, /* 0x28 ( (left parenthesis) */
  0x06, 0x0c, 0x0c, 0x0c, 0x06, /* 0x29 ) (right parenthesis) */
  0x04, 0x15, 0x0e, 0x15, 0x04, /* 0x2a * (asterisk) */
  0x04, 0x04, 0x1f, 0x04, 0x04, /* 0x2b + (plus) */
  0x00, 0x00, 0x06, 0x04, 0x02, /* 0x2c , (comma) */
  0x00, 0x00, 0x1f, 0x00, 0x00, /* 0x2d - (minus) */
  0x00, 0x00, 0x00, 0x06, 0x06, /* 0x2e . (period) */
  0x00, 0x08, 0x04, 0x02, 0x01, /* 0x2f / (slash) */

  0x0e, 0x19, 0x15, 0x13, 0x0e, /* 0x30 0 */
  0x0c, 0x0e, 0x0c, 0x0c, 0x1e, /* 0x31 1 */
  0x0e, 0x1b, 0x08, 0x06, 0x1f, /* 0x32 2 */
  0x0e, 0x19, 0x1c, 0x19, 0x0e, /* 0x33 3 */
  0x0c, 0x0e, 0x0d, 0x1f, 0x0c, /* 0x34 4 */
  0x0f, 0x03, 0x0f, 0x10, 0x0e, /* 0x35 5 */
  0x0e, 0x03, 0x0f, 0x13, 0x0e, /* 0x36 6 */
  0x1f, 0x1b, 0x18, 0x0c, 0x0c, /* 0x37 7 */
  0x0e, 0x13, 0x0e, 0x13, 0x0e, /* 0x38 8 */
  0x0e, 0x19, 0x1e, 0x0c, 0x0c, /* 0x39 9 */

  0x00, 0x06, 0x00, 0x06, 0x00, /* 0x3a : (colon) */
  0x00, 0x06, 0x00, 0x06, 0x04, /* 0x3b ; (semicolon) */
  0x0c, 0x06, 0x03, 0x06, 0x0c, /* 0x3c < (less than) */
  0x00, 0x1f, 0x00, 0x1f, 0x00, /* 0x3d = (equal) */
  0x06, 0x0c, 0x18, 0x0c, 0x06, /* 0x3e > (greater than) */
  0x0e, 0x19, 0x0c, 0x00, 0x04, /* 0x3f ? (question) */
  0x0e, 0x13, 0x1b, 0x03, 0x0e, /* 0x40 @ (at) */

  0x04, 0x0a, 0x13, 0x1f, 0x13, /* 0x41 A */
  0x0f, 0x13, 0x0f, 0x13, 0x0f, /* 0x42 B */
  0x0e, 0x13, 0x03, 0x13, 0x0e, /* 0x43 C */
  0x0f, 0x13, 0x13, 0x13, 0x0f, /* 0x44 D */
  0x1f, 0x03, 0x0f, 0x03, 0x1f, /* 0x45 E */
  0x1f, 0x03, 0x0f, 0x03, 0x03, /* 0x46 F */
  0x0e, 0x03, 0x1b, 0x13, 0x0e, /* 0x47 G */
  0x13, 0x13, 0x1f, 0x13, 0x13, /* 0x48 H */
  0x0f, 0x06, 0x06, 0x06, 0x0f, /* 0x49 I */
  0x1e, 0x0c, 0x0c, 0x0d, 0x06, /* 0x4a J */
  0x13, 0x0b, 0x07, 0x0b, 0x13, /* 0x4b K */
  0x03, 0x03, 0x03, 0x03, 0x1f, /* 0x4c L */
  0x11, 0x1b, 0x17, 0x13, 0x13, /* 0x4d M */
  0x11, 0x13, 0x17, 0x1b, 0x13, /* 0x4e N */
  0x0e, 0x13, 0x13, 0x13, 0x0e, /* 0x4f O */
  0x0f, 0x13, 0x0f, 0x03, 0x03, /* 0x50 P */
  0x0e, 0x13, 0x13, 0x0b, 0x16, /* 0x51 Q */
  0x0f, 0x13, 0x0f, 0x0b, 0x13, /* 0x52 R */
  0x1e, 0x03, 0x1f, 0x18, 0x0f, /* 0x53 S */
  0x0f, 0x06, 0x06, 0x06, 0x06, /* 0x54 T */
  0x13, 0x13, 0x13, 0x13, 0x0e, /* 0x55 U */
  0x13, 0x13, 0x13, 0x0a, 0x04, /* 0x56 V */
  0x13, 0x13, 0x11, 0x15, 0x0a, /* 0x57 W */
  0x13, 0x0a, 0x04, 0x0a, 0x13, /* 0x58 X */
  0x13, 0x0e, 0x0c, 0x0c, 0x0c, /* 0x59 Y */
  0x1f, 0x08, 0x04, 0x06, 0x1f, /* 0x5a Z */

  0x0e, 0x06, 0x06, 0x06, 0x0e, /* 0x5b [ (left bracket) */
  0x00, 0x01, 0x02, 0x04, 0x08, /* 0x5c \ (backslash) */
  0x0e, 0x0c, 0x0c, 0x0c, 0x0e, /* 0x5d ] (right bracket) */
  0x04, 0x0a, 0x11, 0x00, 0x00, /* 0x5e ^ (hat) */
  0x00, 0x00, 0x00, 0x00, 0x1f, /* 0x5f _ (underscore) */
  0x06, 0x04, 0x00, 0x00, 0x00, /* 0x60 ` (backquote) */

  0x06, 0x08, 0x0e, 0x0b, 0x16, /* 0x61 a */
  0x03, 0x03, 0x0f, 0x13, 0x0f, /* 0x62 b */
  0x00, 0x0e, 0x03, 0x03, 0x0e, /* 0x63 c */
  0x18, 0x18, 0x1e, 0x19, 0x1e, /* 0x64 d */
  0x0e, 0x13, 0x1f, 0x03, 0x0e, /* 0x65 e */
  0x0c, 0x06, 0x0f, 0x06, 0x06, /* 0x66 f */
  0x0e, 0x19, 0x1e, 0x18, 0x0e, /* 0x67 g */
  0x03, 0x03, 0x0f, 0x1b, 0x1b, /* 0x68 h */
  0x06, 0x00, 0x06, 0x06, 0x06, /* 0x69 i */
  0x0c, 0x00, 0x0c, 0x0d, 0x06, /* 0x6a j */
  0x03, 0x03, 0x0b, 0x07, 0x0b, /* 0x6b k */
  0x06, 0x06, 0x06, 0x06, 0x0c, /* 0x6c l */
  0x00, 0x0b, 0x1f, 0x15, 0x15, /* 0x6d m */
  0x00, 0x0f, 0x13, 0x13, 0x13, /* 0x6e n */
  0x00, 0x0e, 0x13, 0x13, 0x0e, /* 0x6f o */
  0x00, 0x0f, 0x13, 0x0f, 0x03, /* 0x70 p */
  0x00, 0x1e, 0x19, 0x1e, 0x18, /* 0x71 q */
  0x00, 0x0f, 0x13, 0x03, 0x03, /* 0x72 r */
  0x0e, 0x03, 0x0e, 0x10, 0x0e, /* 0x73 s */
  0x06, 0x0f, 0x06, 0x06, 0x0c, /* 0x74 t */
  0x00, 0x13, 0x13, 0x13, 0x0e, /* 0x75 u */
  0x00, 0x13, 0x13, 0x0a, 0x04, /* 0x76 v */
  0x00, 0x11, 0x15, 0x15, 0x0e, /* 0x77 w */
  0x00, 0x09, 0x06, 0x06, 0x09, /* 0x78 x */
  0x00, 0x1b, 0x1f, 0x18, 0x0e, /* 0x79 y */
  0x00, 0x0f, 0x04, 0x02, 0x0f, /* 0x7a z */

  0x0c, 0x04, 0x06, 0x04, 0x0c, /* 0x7b { (left brace) */
  0x04, 0x04, 0x04, 0x04, 0x04, /* 0x7c | (pipe) */
  0x06, 0x04, 0x0c, 0x04, 0x06, /* 0x7d } (right brace) */
  0x02, 0x15, 0x08, 0x00, 0x00, /* 0x7e ~ (tilde) */

  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x7f DEL */

#ifndef GRAPHIC_CHARACTER_PRESET_LIMITED
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x80 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x81 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x82 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x83 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x84 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x85 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x86 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x87 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x88 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x89 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x8a */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x8b */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x8c */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x8d */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x8e */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x8f */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x90 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x91 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x92 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x93 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x94 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x95 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x96 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x97 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x98 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x99 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x9a */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x9b */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x9c */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x9d */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x9e */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0x9f */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xa0 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xa1 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xa2 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xa3 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xa4 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xa5 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xa6 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xa7 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xa8 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xa9 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xaa */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xab */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xac */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xad */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xae */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xaf */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xb0 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xb1 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xb2 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xb3 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xb4 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xb5 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xb6 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xb7 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xb8 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xb9 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xba */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xbb */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xbc */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xbd */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xbe */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xbf */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xc0 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xc1 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xc2 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xc3 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xc4 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xc5 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xc6 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xc7 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xc8 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xc9 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xca */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xcb */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xcc */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xcd */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xce */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xcf */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xd0 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xd1 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xd2 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xd3 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xd4 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xd5 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xd6 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xd7 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xd8 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xd9 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xda */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xdb */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xdc */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xdd */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xde */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xdf */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xe0 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xe1 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xe2 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xe3 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xe4 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xe5 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xe6 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xe7 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xe8 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xe9 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xea */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xeb */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xec */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xed */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xee */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xef */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xf0 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xf1 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xf2 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xf3 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xf4 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xf5 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xf6 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xf7 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xf8 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xf9 */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xfa */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xfb */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xfc */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xfd */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xfe */
  0x00, 0x00, 0x00, 0x00, 0x00, /* 0xff */
#endif
};

const struct charset charset_font5x5 = {
  CHARACTER_SIZE, CHARACTER_SIZE,
  sizeof(bitmap) / (sizeof(*bitmap) * CHARACTER_SIZE),
  bitmap, IMAGE_TYPE_MONOBCOLOR, NLL_G_STATIC
};
#endif
