#ifndef __NLL_NLLTYPES_H_INCLUDED__
#define __NLL_NLLTYPES_H_INCLUDED__

typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;
#define FUNCTION_FLAG_FIXED (1 <<  0)
};

#endif
