# 1 "sound.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "sound.c"
# 1 "config.h" 1
# 2 "sound.c" 2


# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 5 "sound.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 6 "sound.c" 2
# 1 "../include/stdint.h" 1
# 7 "sound.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 8 "sound.c" 2
# 1 "../include/ctype.h" 1



int isalnum(int c);
int isalpha(int c);
int isascii(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);
int tolower(int c);
int toupper(int c);
# 9 "sound.c" 2



# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 13 "sound.c" 2


# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 16 "sound.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 17 "sound.c" 2
# 1 "sound.h" 1



typedef enum {
  SOUND_TYPE_UNKNOWN = 0,
  SOUND_TYPE_WAV,
  SOUND_TYPE_TEXT,

  SOUND_TYPE_NUM
} sound_type_t;

typedef struct sound *sound_t;

struct sound {
  int index;
  sound_type_t type;

  int samplefreq;
  int channels;
  int bits;
  int samplenum;

  unsigned int flags;

  FILE *fp;
  int offset;

  union {
    void *p;
    int8_t *b;
    int16_t *h;
    int32_t *w;
  } frames;
};

int sound_init(void);
int sound_done(void);
int sound_check(void);

int sound_get_index(sound_t sound);
sound_t sound_get_sound(int index);
int sound_destroy(sound_t sound);
sound_t sound_create(sound_type_t type, unsigned int flags);

int sound_ropen(sound_t sound, const char *filename);
int sound_wopen(sound_t sound, const char *filename,
  int samplefreq, int channels, int bits, int samplenum);
int sound_read(sound_t sound, short *frames, int num);
int sound_write(sound_t sound, short *frames, int num);
int sound_rclose(sound_t sound);
int sound_wclose(sound_t sound);
# 18 "sound.c" 2

struct chunk_header {



  uint32_t id;
  uint32_t size;
};


struct riff_chunk_header {
  struct chunk_header header;

  uint32_t format;
};


struct fmt_chunk_header {
  struct chunk_header header;

  uint16_t format_type;
  uint16_t channels;
  uint32_t samples_per_sec;
  uint32_t bytes_per_sec;
  uint16_t block_size;
  uint16_t bits_per_sample;
};


struct data_chunk_header {
  struct chunk_header header;
};


static sound_t sounds[128];
static int sound_num = 0;

int sound_init(void)
{
  sound_num = 0;
  memset(sounds, 0, sizeof(sounds));
  return 0;
}

int sound_done(void)
{
  int index;
  sound_t sound;

  for (index = 0; index < 128; index++) {
    sound = sounds[index];
    if (sound) {
      sound_destroy(sound);
    }
  }

  return 0;
}

int sound_check(void)
{
  int index;

  if (sound_num)
    return NLL_ERRCODE_MEMORY_NOT_EMPTY;

  for (index = 0; index < 128; index++) {
    if (sounds[index])
      return NLL_ERRCODE_MEMORY_NOT_EMPTY;
  }

  return 0;
}

static sound_t _alloc(void)
{
  sound_t sound;
  if ((sound = memory_alloc(sizeof(*sound))) == ((void *)0))
    return ((void *)0);
  return sound;
}

static int _free(sound_t sound)
{
  memory_free(sound);
  return 0;
}

union evalue {
  uint8_t b[4];
  uint16_t h[2];
  uint32_t w[1];
};

static uint16_t read_le16(uint16_t val)
{
  union evalue e;
  e.h[0] = val;
  return (e.b[1] << 8) | e.b[0];
}

static uint32_t read_le32(uint32_t val)
{
  union evalue e;
  e.w[0] = val;
  return (e.b[3] << 24) | (e.b[2] << 16) | (e.b[1] << 8) | e.b[0];
}

static uint16_t write_le16(uint16_t val)
{
  union evalue e;
  e.b[0] = val & 0xff;
  e.b[1] = (val >> 8) & 0xff;
  return e.h[0];
}

static uint32_t write_le32(uint32_t val)
{
  union evalue e;
  e.b[0] = val & 0xff;
  e.b[1] = (val >> 8) & 0xff;
  e.b[2] = (val >> 16) & 0xff;
  e.b[3] = (val >> 24) & 0xff;
  return e.w[0];
}

static int sound_null_ropen(sound_t sound, const char *filename)
{
  return -1;
}

static int sound_null_wopen(sound_t sound, const char *filename,
       int samplefreq, int channels, int bits, int samplenum)
{
  return -1;
}

static int sound_null_read(sound_t sound, short *frames, int num)
{
  return -1;
}

static int sound_null_write(sound_t sound, short *frames, int num)
{
  return -1;
}

static int sound_null_rclose(sound_t sound)
{
  return -1;
}

static int sound_null_wclose(sound_t sound)
{
  return -1;
}

static int sound_wav_ropen(sound_t sound, const char *filename)
{
  struct riff_chunk_header rhdr;
  struct fmt_chunk_header fhdr;
  struct data_chunk_header dhdr;
  int riffsize, fmtsize, datasize, i, ch, n = 0, size;
  const char *mode;
  unsigned char dummy;
  union evalue e;


  mode = "r";




  sound->fp = fopen(filename, mode);
  if (!sound->fp)
    goto err;

  memset(&rhdr, 0, sizeof(rhdr));
  memset(&fhdr, 0, sizeof(fhdr));
  memset(&dhdr, 0, sizeof(dhdr));

  if (fread(&rhdr, 1, sizeof(struct riff_chunk_header), sound->fp) != sizeof(struct riff_chunk_header))
    goto err;

  rhdr.header.id = read_le32(rhdr.header.id);
  rhdr.header.size = read_le32(rhdr.header.size);
  rhdr.format = read_le32(rhdr.format);

  if ((rhdr.header.id != 0x46464952) ||
      (rhdr.format != 0x45564157))
    goto err;

  riffsize = rhdr.header.size + sizeof(struct chunk_header);

  if (fread(&fhdr, 1, sizeof(struct fmt_chunk_header), sound->fp) != sizeof(struct fmt_chunk_header))
    goto err;

  fhdr.header.id = read_le32(fhdr.header.id);
  fhdr.header.size = read_le32(fhdr.header.size);
  fhdr.format_type = read_le16(fhdr.format_type);
  fhdr.channels = read_le16(fhdr.channels);
  fhdr.samples_per_sec = read_le32(fhdr.samples_per_sec);
  fhdr.bytes_per_sec = read_le32(fhdr.bytes_per_sec);
  fhdr.block_size = read_le16(fhdr.block_size);
  fhdr.bits_per_sample = read_le16(fhdr.bits_per_sample);

  if ((fhdr.header.id != 0x20746d66) ||
      (fhdr.format_type != 0x0001))
    goto err;

  fmtsize = fhdr.header.size + sizeof(struct chunk_header);

  if (fmtsize < sizeof(struct fmt_chunk_header))
    goto err;

  sound->channels = fhdr.channels;
  sound->samplefreq = fhdr.samples_per_sec;
  sound->bits = fhdr.bits_per_sample;

  if (sound->samplefreq <= 0)
    goto err;

  if ((sound->channels != 1) && (sound->channels != 2))
    goto err;

  if ((sound->bits != 8) && (sound->bits != 16) && (sound->bits != 32))
    goto err;

  if (fmtsize > sizeof(struct fmt_chunk_header)) {
    for (i = 0; i < fmtsize - sizeof(struct fmt_chunk_header); i++) {
      if (fread(&dummy, 1, 1, sound->fp) != 1)
 goto err;
    }
  }

  if (fread(&dhdr, 1, sizeof(struct data_chunk_header), sound->fp) != sizeof(struct data_chunk_header))
    goto err;

  dhdr.header.id = read_le32(dhdr.header.id);
  dhdr.header.size = read_le32(dhdr.header.size);

  if (dhdr.header.id != 0x61746164)
    goto err;

  datasize = dhdr.header.size + sizeof(struct chunk_header);

  if (riffsize < sizeof(struct riff_chunk_header) + fmtsize + datasize)
    goto err;

  sound->samplenum = (datasize - sizeof(struct data_chunk_header)) / sound->channels / (sound->bits / 8);

  if (sound->samplenum < 0)
    goto err;

  size = sound->channels * (sound->bits / 8) * sound->samplenum;
  sound->frames.p = memory_alloc(size);
  if (!sound->frames.p)
    goto err;
  memset(sound->frames.p, 0, size);

  sound->offset = 0;

  for (i = 0; i < sound->samplenum; i++) {
    for (ch = 0; ch < sound->channels; ch++) {
      memset(&e, 0, sizeof(e));
      if (fread(&e, 1, sound->bits / 8, sound->fp) != (sound->bits / 8))
 goto err;
      switch (sound->bits) {
      case 8: sound->frames.b[n] = e.b[0] ; break;
      case 16: sound->frames.h[n] = read_le16(e.h[0]); break;
      case 32: sound->frames.w[n] = read_le32(e.w[0]); break;
      default: break;
      }
      n++;
    }
    sound->offset++;
  }

  sound->offset = 0;

  fclose(sound->fp);
  sound->fp = ((void *)0);

  return 0;

err:
  if (sound->frames.p) {
    memory_free(sound->frames.p);
    sound->frames.p = ((void *)0);
  }
  if (sound->fp) {
    fclose(sound->fp);
    sound->fp = ((void *)0);
  }
  return -1;
}

static int sound_wav_wopen(sound_t sound, const char *filename,
      int samplefreq, int channels, int bits, int samplenum)
{
  struct riff_chunk_header rhdr;
  struct fmt_chunk_header fhdr;
  struct data_chunk_header dhdr;
  int riffsize, fmtsize, datasize;
  const char *mode;

  if ((samplenum < 0) || (samplefreq <= 0))
    goto err;

  if ((channels != 1) && (channels != 2))
    goto err;

  if ((bits != 8) && (bits != 16) && (bits != 32))
    goto err;

  sound->samplefreq = samplefreq;
  sound->channels = channels;
  sound->bits = bits;
  sound->samplenum = samplenum;


  mode = "w";




  sound->fp = fopen(filename, mode);
  if (!sound->fp)
    goto err;

  datasize = sizeof(struct data_chunk_header) + (sound->channels * (sound->bits / 8) * sound->samplenum);
  fmtsize = sizeof(struct fmt_chunk_header);
  riffsize = sizeof(struct riff_chunk_header) + fmtsize + datasize;

  memset(&rhdr, 0, sizeof(rhdr));
  memset(&fhdr, 0, sizeof(fhdr));
  memset(&dhdr, 0, sizeof(dhdr));

  rhdr.header.id = write_le32(0x46464952);
  rhdr.header.size = write_le32(riffsize - sizeof(struct chunk_header));
  rhdr.format = write_le32(0x45564157);

  fhdr.header.id = write_le32(0x20746d66);
  fhdr.header.size = write_le32(fmtsize - sizeof(struct chunk_header));
  fhdr.format_type = write_le16(0x0001);
  fhdr.channels = write_le16(sound->channels);
  fhdr.samples_per_sec = write_le32(sound->samplefreq);
  fhdr.bytes_per_sec = write_le32((sound->bits / 8) * sound->channels * sound->samplefreq);
  fhdr.block_size = write_le16((sound->bits / 8) * sound->channels);
  fhdr.bits_per_sample = write_le16(sound->bits);

  dhdr.header.id = write_le32(0x61746164);
  dhdr.header.size = write_le32(datasize - sizeof(struct chunk_header));

  if (fwrite(&rhdr, 1, sizeof(struct riff_chunk_header), sound->fp) != sizeof(struct riff_chunk_header))
    goto err;

  if (fwrite(&fhdr, 1, sizeof(struct fmt_chunk_header), sound->fp) != sizeof(struct fmt_chunk_header))
    goto err;

  if (fwrite(&dhdr, 1, sizeof(struct data_chunk_header), sound->fp) != sizeof(struct data_chunk_header))
    goto err;

  return 0;

err:
  if (sound->fp) {
    fclose(sound->fp);
    sound->fp = ((void *)0);
  }
  return -1;
}

static int _read(sound_t sound, short *frames, int num)
{
  int i, ch, n = 0, m;

  m = sound->offset * sound->channels;

  for (i = 0; i < num; i++) {
    for (ch = 0; ch < sound->channels; ch++) {
      if (sound->offset < sound->samplenum) {
 switch (sound->bits) {
 case 8: frames[n] = sound->frames.b[m] << 8; break;
 case 16: frames[n] = sound->frames.h[m] ; break;
 case 32: frames[n] = sound->frames.w[m] >> 16; break;
 default: break;
 }
      } else {
 frames[n] = 0;
      }
      n++;
      m++;
    }
    sound->offset++;
  }

  return 0;
}

static int sound_wav_read(sound_t sound, short *frames, int num)
{
  return _read(sound, frames, num);
}

static int sound_wav_write(sound_t sound, short *frames, int num)
{
  int i, ch, n = 0;
  union evalue e;

  if (!sound->fp)
    return -1;

  for (i = 0; i < num; i++) {
    for (ch = 0; ch < sound->channels; ch++) {
      memset(&e, 0, sizeof(e));
      if (sound->offset < sound->samplenum) {
 switch (sound->bits) {
 case 8: e.b[0] = (frames[n] >> 8); break;
 case 16: e.h[0] = write_le16(frames[n] ); break;
 case 32: e.w[0] = write_le32(frames[n] << 16); break;
 default: break;
 }
      }
      fwrite(&e, 1, sound->bits / 8, sound->fp);
      n++;
    }
    sound->offset++;
  }

  return 0;
}

static int _close(sound_t sound)
{
  if (!sound->fp)
    return -1;

  fclose(sound->fp);
  sound->fp = ((void *)0);

  return 0;
}

static int sound_wav_rclose(sound_t sound)
{
  return _close(sound);
}

static int sound_wav_wclose(sound_t sound)
{
  int align_num, ch;
  union evalue e;

  if (!sound->fp)
    return -1;

  align_num = sound->samplenum;
  if ((sound->channels == 1) && (sound->bits == 8) && ((sound->samplenum % 2) != 0))
    align_num++;

  memset(&e, 0, sizeof(e));

  while (sound->offset < align_num) {
    for (ch = 0; ch < sound->channels; ch++) {
      fwrite(&e, 1, sound->bits / 8, sound->fp);
    }
    sound->offset++;
  }

  fclose(sound->fp);
  sound->fp = ((void *)0);

  return 0;
}

static int skipspace(char **p)
{
  while (**p && isspace(**p))
    (*p)++;
  if (!**p)
    return -1;
  return 0;
}

static int skipnspace(char **p)
{
  while (**p && !isspace(**p))
    (*p)++;
  if (!**p)
    return -1;
  return 0;
}

static int getparam(char *p, char *keyword)
{
  char *k;
  int param;

  if (*p != '#')
    return -1;
  p++;

  if (skipspace(&p) < 0)
    return -1;

  k = p;

  if (skipnspace(&p) < 0)
    return -1;

  *(p++) = '\0';
  if (strcmp(k, keyword))
    return -1;

  param = strtol(p, ((void *)0), 0);
  if (param < 0)
    return 0;

  return param;
}

static int sound_text_ropen(sound_t sound, const char *filename)
{
  const char *mode;
  char line[256], *p;
  int i, ch, n = 0, size;

  mode = "r";

  sound->fp = fopen(filename, mode);
  if (!sound->fp)
    goto err;

  if (fgets(line, sizeof(line), sound->fp) == ((void *)0))
    goto err;

  if (fgets(line, sizeof(line), sound->fp) == ((void *)0))
    goto err;
  sound->samplefreq = getparam(line, "Freq:");

  if (fgets(line, sizeof(line), sound->fp) == ((void *)0))
    goto err;
  sound->channels = getparam(line, "Channels:");

  if (fgets(line, sizeof(line), sound->fp) == ((void *)0))
    goto err;
  sound->bits = getparam(line, "Bits:");

  if (fgets(line, sizeof(line), sound->fp) == ((void *)0))
    goto err;
  sound->samplenum = getparam(line, "Length:");

  if ((sound->samplenum < 0) || (sound->samplefreq <= 0))
    goto err;

  if ((sound->bits != 8) && (sound->bits != 16) && (sound->bits != 32))
    goto err;

  size = sound->channels * (sound->bits / 8) * sound->samplenum;
  sound->frames.p = memory_alloc(size);
  if (!sound->frames.p)
    goto err;
  memset(sound->frames.p, 0, size);

  sound->offset = 0;

  for (i = 0; i < sound->samplenum; i++) {
    if (fgets(line, sizeof(line), sound->fp) == ((void *)0))
      goto err;
    p = line;
    for (ch = 0; ch < sound->channels; ch++) {
      if (skipnspace(&p) < 0)
 goto err;
      if (skipspace(&p) < 0)
 goto err;
      switch (sound->bits) {
      case 8: sound->frames.b[n] = strtol(p, ((void *)0), 0); break;
      case 16: sound->frames.h[n] = strtol(p, ((void *)0), 0); break;
      case 32: sound->frames.w[n] = strtol(p, ((void *)0), 0); break;
      default: break;
      }
      n++;
    }
    sound->offset++;
  }

  sound->offset = 0;

  fclose(sound->fp);
  sound->fp = ((void *)0);

  return 0;

err:
  if (sound->frames.p) {
    memory_free(sound->frames.p);
    sound->frames.p = ((void *)0);
  }
  if (sound->fp) {
    fclose(sound->fp);
    sound->fp = ((void *)0);
  }
  return -1;
}

static int sound_text_wopen(sound_t sound, const char *filename,
       int samplefreq, int channels, int bits, int samplenum)
{
  const char *mode;

  if ((samplenum < 0) || (samplefreq <= 0))
    goto err;

  if ((bits != 8) && (bits != 16) && (bits != 32))
    goto err;

  sound->samplefreq = samplefreq;
  sound->channels = channels;
  sound->bits = bits;
  sound->samplenum = samplenum;

  mode = "w";

  sound->fp = fopen(filename, mode);
  if (!sound->fp)
    goto err;

  fprintf(sound->fp, "# %s\n", filename);
  fprintf(sound->fp, "# Freq: %d\n", sound->samplefreq);
  fprintf(sound->fp, "# Channels: %d\n", sound->channels);
  fprintf(sound->fp, "# Bits: %d\n", sound->bits);
  fprintf(sound->fp, "# Length: %d\n", sound->samplenum);

  return 0;

err:
  if (sound->fp) {
    fclose(sound->fp);
    sound->fp = ((void *)0);
  }
  return -1;
}

static int sound_text_read(sound_t sound, short *frames, int num)
{
  return _read(sound, frames, num);
}

static int sound_text_write(sound_t sound, short *frames, int num)
{
  int i, ch, n = 0, val;

  if (!sound->fp)
    return -1;

  for (i = 0; i < num; i++) {
    fprintf(sound->fp, "%d", sound->offset);
    for (ch = 0; ch < sound->channels; ch++) {
      val = 0;
      if (sound->offset < sound->samplenum)
 val = frames[n];
      fprintf(sound->fp, " %d", val);
      n++;
    }
    fprintf(sound->fp, "\n");
    sound->offset++;
  }

  return 0;
}

static int sound_text_rclose(sound_t sound)
{
  return _close(sound);
}

static int sound_text_wclose(sound_t sound)
{
  return _close(sound);
}

static struct {
  int (*ropen)(sound_t sound, const char *filename);
  int (*wopen)(sound_t sound, const char *filename,
        int samplefreq, int channels, int bits, int samplenum);
  int (*read)(sound_t sound, short *frames, int num);
  int (*write)(sound_t sound, short *frames, int num);
  int (*rclose)(sound_t sound);
  int (*wclose)(sound_t sound);
} functions[] = {
  { sound_null_ropen, sound_null_wopen, sound_null_read, sound_null_write, sound_null_rclose, sound_null_wclose },
  { sound_wav_ropen, sound_wav_wopen, sound_wav_read, sound_wav_write, sound_wav_rclose, sound_wav_wclose },
  { sound_text_ropen, sound_text_wopen, sound_text_read, sound_text_write, sound_text_rclose, sound_text_wclose },

  { ((void *)0), ((void *)0), ((void *)0) }
};

int sound_get_index(sound_t sound)
{
  if (!sound)
    return -1;
  return sound->index;
}

sound_t sound_get_sound(int index)
{
  if ((index < 0) || (index >= 128))
    return ((void *)0);
  return sounds[index];
}

int sound_destroy(sound_t sound)
{
  int r;

  sounds[sound->index] = ((void *)0);

  if (sound->frames.p) memory_free(sound->frames.p);
  if (sound->fp) fclose(sound->fp);

  memset(sound, 0, sizeof(*sound));

  sound_num--;
  if ((r = _free(sound)) < 0)
    return r;

  return 0;
}

sound_t sound_create(sound_type_t type, unsigned int flags)
{
  sound_t sound = ((void *)0);
  int index;

  if (type >= SOUND_TYPE_NUM)
    goto err;

  for (index = 0; index < 128; index++) {
    sound = sounds[index];
    if (!sound)
      break;
  }
  if (index == 128)
    goto err;

  if ((sound = _alloc()) == ((void *)0))
    goto err;
  sound_num++;

  memset(sound, 0, sizeof(*sound));
  sound->index = index;

  sounds[index] = sound;

  sound->type = type;
  sound->samplefreq = 0;
  sound->channels = 0;
  sound->bits = 0;
  sound->samplenum = 0;

  sound->flags = flags;

  sound->fp = ((void *)0);
  sound->offset = 0;

  sound->frames.p = ((void *)0);

  return sound;

err:
  if (sound)
    sound_destroy(sound);
  return ((void *)0);
}

int sound_ropen(sound_t sound, const char *filename)
{
  if (!sound)
    return -1;
  return functions[sound->type].ropen(sound, filename);
}

int sound_wopen(sound_t sound, const char *filename,
  int samplefreq, int channels, int bits, int samplenum)
{
  if (!sound)
    return -1;
  return functions[sound->type].wopen(sound, filename, samplefreq, channels, bits, samplenum);
}

int sound_read(sound_t sound, short *frames, int num)
{
  if (!sound)
    return -1;
  return functions[sound->type].read(sound, frames, num);
}

int sound_write(sound_t sound, short *frames, int num)
{
  if (!sound)
    return -1;
  return functions[sound->type].write(sound, frames, num);
}

int sound_rclose(sound_t sound)
{
  if (!sound)
    return -1;
  return functions[sound->type].rclose(sound);
}

int sound_wclose(sound_t sound)
{
  if (!sound)
    return -1;
  return functions[sound->type].wclose(sound);
}
