# 1 "libprintf.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "libprintf.c"
# 1 "config.h" 1
# 2 "libprintf.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "libprintf.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "libprintf.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "libprintf.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 9 "libprintf.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 12 "libprintf.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 13 "libprintf.c" 2
# 1 "libprintf.h" 1



int nll_sprintf(char *str, int size, const char *format, value_t args);
# 14 "libprintf.c" 2

static char *_utostr(unsigned long val)
{
  static char s[32];
  char *p;

  p = s + sizeof(s);
  *(--p) = '\0';
  while (val) {
    *(--p) = "0123456789"[val % 10];
    val /= 10;
  }
  if (*p == '\0')
    *(--p) = '0';

  return p;
}

static char *_itostr(long val)
{
  char *p;

  p = _utostr((val < 0) ? -val : val);
  if (val < 0)
    *(--p) = '-';

  return p;
}

static char *_btostr(unsigned long val)
{
  static char s[128];
  char *p;

  p = s + sizeof(s);
  *(--p) = '\0';
  while (val) {
    *(--p) = "01"[val & 0x1];
    val >>= 1;
  }
  if (*p == '\0')
    *(--p) = '0';

  return p;
}

static char *_otostr(unsigned long val)
{
  static char s[32];
  char *p;

  p = s + sizeof(s);
  *(--p) = '\0';
  while (val) {
    *(--p) = "01234567"[val & 0x7];
    val >>= 3;
  }
  if (*p == '\0')
    *(--p) = '0';

  return p;
}

static char *_xtostr(unsigned long val, int upper, int suffix)
{
  static char s[32];
  char *p;
  char *x;

  x = upper ? "0123456789ABCDEF" : "0123456789abcdef";

  p = s + sizeof(s);
  *(--p) = '\0';
  while (val) {
    *(--p) = x[val & 0xf];
    val >>= 4;
  }
  if (*p == '\0')
    *(--p) = '0';

  if (suffix) {
    *(--p) = 'x';
    *(--p) = '0';
  }

  return p;
}


static char *_ftostr(double f)
{
  static char s[64];
  sprintf(s, "%f", f);
  return s;
}


static char *outc(char *p, int *size, int c)
{
  if (p && (*size > 0)) {
    *(p++) = c;
    (*size)--;
  }

  return p;
}

static char *outs(char *p, int *size, char *s, int col, int pad)
{
  int len;
  char ch;

  if (s == ((void *)0))
    s = "(null)";
  len = strlen(s);

  ch = pad;
  for (; col > len; col--) {
    if (p && (*size > 0)) {
      *(p++) = ch;
      (*size)--;
    }
  }

  if (p) {
    while (*s && (*size > 0)) {
      *(p++) = *(s++);
      (*size)--;
    }
  }

  return p;
}

static integer_t arg_integer(value_t arg)
{
  int r;
  integer_t integer = 0;

  if (arg) {
    if ((r = value_get_integer(arg, &integer)) < 0)
      return 0;
  }

  return integer;
}

static char *arg_string(value_t arg)
{
  int r;
  char *string = "";

  if (arg) {
    if ((r = value_get_string(arg, &string, ((void *)0))) < 0)
      return "";
    if (!string)
      string = "(null)";
  }

  return string;
}


static double arg_float(value_t arg)
{
  int r;
  double f = 0.0;

  if (arg) {
    if ((r = value_get_float(arg, &f)) < 0)
      return 0.0;
  }

  return f;
}


int nll_sprintf(char *str, int size, const char *format, value_t args)
{
  char *p = str, *sv;
  const char *f;
  int col = 0, pad = ' ';
  enum {
    MODE_NORMAL = 0,
    MODE_INT = 1,
    MODE_LONG = 2,
    MODE_QUAD = 3,
  } mode;

  mode = MODE_NORMAL;

  if (p)
    *p = '\0';

  size--;

  for (f = format; *f; f++) {
    if (mode != MODE_NORMAL) {
      switch (*f) {
      case '0':
 if (!col) {
   pad = '0';
   continue;
 }

      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
 col = col * 10 + (*f - '0');
 continue;
      case 'c':
 p = outc(p, &size, arg_integer(args));
 if (args) args = args->next;
 break;
      case 's':
 p = outs(p, &size, arg_string(args), col, pad);
 if (args) args = args->next;
 col = 0; pad = ' ';
 break;
      case 'l':
 switch (mode) {
 case MODE_INT: mode = MODE_LONG; break;
 case MODE_LONG: mode = MODE_QUAD; break;
 default: break;
 }
 continue;
      case 'q':
 switch (mode) {
 case MODE_INT:
 case MODE_LONG: mode = MODE_QUAD; break;
 default: break;
 }
 continue;
      case 'd':
 switch (mode) {
 case MODE_LONG:
 case MODE_QUAD: sv = _itostr((long)arg_integer(args)); break;
 case MODE_INT:
 default: sv = _itostr((long)arg_integer(args)); break;
 }
 p = outs(p, &size, sv, col, pad);
 if (args) args = args->next;
 col = 0; pad = ' ';
 break;
      case 'u':
 switch (mode) {
 case MODE_LONG:
 case MODE_QUAD: sv = _utostr((unsigned long)arg_integer(args)); break;
 case MODE_INT:
 default: sv = _utostr((unsigned long)arg_integer(args)); break;
 }
 p = outs(p, &size, sv, col, pad);
 if (args) args = args->next;
 col = 0; pad = ' ';
 break;
      case 'b':
 switch (mode) {
 case MODE_LONG:
 case MODE_QUAD: sv = _btostr((unsigned long)arg_integer(args)); break;
 case MODE_INT:
 default: sv = _btostr((unsigned long)arg_integer(args)); break;
 }
 p = outs(p, &size, sv, col, pad);
 if (args) args = args->next;
 col = 0; pad = ' ';
 break;
      case 'o':
 switch (mode) {
 case MODE_LONG:
 case MODE_QUAD: sv = _otostr((unsigned long)arg_integer(args)); break;
 case MODE_INT:
 default: sv = _otostr((unsigned long)arg_integer(args)); break;
 }
 p = outs(p, &size, sv, col, pad);
 if (args) args = args->next;
 col = 0; pad = ' ';
 break;
      case 'x':
 switch (mode) {
 case MODE_LONG:
 case MODE_QUAD: sv = _xtostr((unsigned long)arg_integer(args), 0, 0); break;
 case MODE_INT:
 default: sv = _xtostr((unsigned long)arg_integer(args), 0, 0); break;
 }
 p = outs(p, &size, sv, col, pad);
 if (args) args = args->next;
 col = 0; pad = ' ';
 break;
      case 'X':
 switch (mode) {
 case MODE_LONG:
 case MODE_QUAD: sv = _xtostr((unsigned long)arg_integer(args), 1, 0); break;
 case MODE_INT:
 default: sv = _xtostr((unsigned long)arg_integer(args), 1, 0); break;
 }
 p = outs(p, &size, sv, col, pad);
 if (args) args = args->next;
 col = 0; pad = ' ';
 break;

      case 'f':
 sv = _ftostr(arg_float(args));
 p = outs(p, &size, sv, col, pad);
 if (args) args = args->next;
 col = 0; pad = ' ';
 break;

      case '%':
 p = outc(p, &size, '%');
 break;
      default:
 break;
      }
      mode = MODE_NORMAL;
      continue;
    }

    if (*f == '%') {
      mode = MODE_INT;
      continue;
    }

    p = outc(p, &size, *f);
  }

  *p = '\0';

  return p - str;
}
