# 1 "image.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "image.c"
# 1 "config.h" 1
# 2 "image.c" 2


# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 5 "image.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 6 "image.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 7 "image.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 10 "image.c" 2


# 1 "const.h" 1
# 13 "image.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 14 "image.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 15 "image.c" 2
# 1 "image.h" 1



typedef unsigned int image_draw_count_t;

typedef enum {
  IMAGE_TYPE_NONE = -1,


  IMAGE_TYPE_FULLCOLOR = 0,
  IMAGE_TYPE_MONOCOLOR,
  IMAGE_TYPE_MONOBCOLOR,
  IMAGE_TYPE_ROUGHCOLOR,
  IMAGE_TYPE_GRAYCOLOR,
  IMAGE_TYPE_HALFCOLOR,
} image_type_t;

typedef enum {
  IMAGE_STATUS_NONE = 0,
  IMAGE_STATUS_ACTIVE,
  IMAGE_STATUS_FREE,
} image_status_t;

typedef struct image *image_t;

struct image_procs {
  int bytesize;
  int (*index)(image_t image, int width, int x, int y, int *indexp, int *offsetp);
  int (*get_color)(image_t image, int x, int y);
  int (*set_color)(image_t image, int x, int y, int color, unsigned int flags);
  int (*copy_get_color)(image_t image, int x, int y);
  int (*copy_save)(image_t image, int x, int y, int width, int height);
  int (*copy_save_color)(image_t image, int x, int y);
};

union image_bitmap {
  void *p;
  int *word;
  unsigned char *byte;
  unsigned short *half;
};

struct image {
  int index;
  int width;
  int height;
  int size;
  image_type_t type;
  unsigned int flags;
  struct {
    int fg;
    int bg;
    int from;
    int to;
  } color;
  struct {
    int x;
    int y;
    int width;
    int height;
    int mulx;
    int muly;
  } range;
  struct {
    int x;
    int y;
  } offset;
  struct {
    struct {
      int x;
      int y;
    } mul;
    struct {
      int x;
      int y;
    } div;
  } scale;
  struct {
    int x;
    int y;
    int width;
    int height;
  } dot;
  struct {
    int x;
    int y;
    int color;
  } current;
  union image_bitmap bitmap;
  volatile image_status_t status;
  struct image_draw {
    image_draw_count_t count;
    image_draw_count_t *line;
    int column_per;
    int column_num;
    image_draw_count_t *column;
    image_draw_count_t *pixel;
  } draw;
  struct image_copy {
    union image_bitmap bitmap;
  } copy;
  struct image_procs *procs;
};

int image_init(void);
int image_done(void);
int image_check(void);
int image_is_draw_line(image_t image, image_draw_count_t count, int y);
int image_is_draw_column(image_t image, image_draw_count_t count, int x, int y);
int image_is_draw_pixel(image_t image, image_draw_count_t count, int x, int y);
int image_set_draw_line(image_t image, image_draw_count_t count, int y);
int image_set_draw_column(image_t image, image_draw_count_t count, int x, int y);
int image_set_draw_pixel(image_t image, image_draw_count_t count, int x, int y);
int image_get_color(image_t image, int x, int y);
int image_set_color(image_t image, int x, int y, int color, unsigned int flags);
int image_copy_save(image_t image, int x, int y, int width, int height);
int image_copy_get_color(image_t image, int x, int y);
int image_copy_save_color(image_t image, int x, int y);
int image_get_index(image_t image);
image_t image_get_image(int index);
int image_reset_draw(image_t image);
int image_destroy(image_t image);
int image_create(image_t image, int width, int height, void *bitmap,
   image_type_t type, unsigned int flags);
image_t image_get(int width, int height, void *bitmap,
    image_type_t type, unsigned int flags);
# 16 "image.c" 2

static image_t images[1024];
static int image_num = 0;

int image_init(void)
{
  image_num = 0;
  memset(images, 0, sizeof(images));
  return 0;
}

int image_done(void)
{
  int index;
  image_t image;

  for (index = 0; index < 1024; index++) {
    image = images[index];
    if (image) {
      if (image->flags & (1 << 8))
 image->flags &= ~(1 << 8);
      image_destroy(image);
    }
  }

  return 0;
}

int image_check(void)
{
  int index;

  if (image_num)
    return NLL_ERRCODE_MEMORY_NOT_EMPTY;

  for (index = 0; index < 1024; index++) {
    if (images[index])
      return NLL_ERRCODE_MEMORY_NOT_EMPTY;
  }

  return 0;
}

static image_t _alloc(void)
{
  image_t image;
  if ((image = memory_alloc(sizeof(*image))) == ((void *)0))
    return ((void *)0);
  return image;
}

static int _free(image_t image)
{
  memory_free(image);
  return 0;
}

int image_is_draw_line(image_t image, image_draw_count_t count, int y)
{
  if (!image->draw.line)
    return 0;
  return (image->draw.line[y] >= count) ? 1 : 0;
}

int image_is_draw_column(image_t image, image_draw_count_t count, int x, int y)
{
  int i;
  if (!image->draw.column)
    return 0;
  i = image->draw.column_num * y + (x / image->draw.column_per);
  return (image->draw.column[i] >= count) ? 1 : 0;
}

int image_is_draw_pixel(image_t image, image_draw_count_t count, int x, int y)
{
  if (!image->draw.pixel)
    return (image->flags & (1 << 11)) ? 1 : 0;
  return (image->draw.pixel[image->width * y + x] >= count) ? 1 : 0;
}

int image_set_draw_line(image_t image, image_draw_count_t count, int y)
{
  if (!image->draw.line)
    return 0;
  image->draw.line[y] = count;
  return 0;
}

int image_set_draw_column(image_t image, image_draw_count_t count, int x, int y)
{
  int i;
  if (!image->draw.column)
    return 0;
  i = image->draw.column_num * y + (x / image->draw.column_per);
  image->draw.column[i] = count;
  return 0;
}

int image_set_draw_pixel(image_t image, image_draw_count_t count, int x, int y)
{
  if (!image->draw.pixel)
    return 0;
  image->draw.pixel[image->width * y + x] = count;
  return 0;
}

static int word_index(image_t image, int width, int x, int y, int *indexp, int *offsetp)
{
  if (indexp)
    *indexp = width * y + x;
  if (offsetp)
    *offsetp = 0;

  return 0;
}

static int fullcolor_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return image->bitmap.word[index];
}

static int fullcolor_set_color(image_t image, int x, int y, int color, unsigned int flags)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  image->bitmap.word[index] = color;
  return 0;
}

static int fullcolor_copy_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return image->copy.bitmap.word[index];
}

static int bit_index(image_t image, int width, int x, int y, int *indexp, int *offsetp)
{
  int bits, w;

  bits = image->procs->bytesize * 8;
  w = (width + (bits - 1)) / bits;

  if (indexp)
    *indexp = w * y + (x / bits);
  if (offsetp)
    *offsetp = x % bits;

  return 0;
}

static int monocolor_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return (image->bitmap.word[index] & (1 << offset)) ? image->color.fg : image->color.bg;
}

static int monocolor_set_color(image_t image, int x, int y, int color, unsigned int flags)
{
  int index, offset, mask;

  image->procs->index(image, image->width, x, y, &index, &offset);
  mask = (1 << offset);

  image->bitmap.word[index] &= ~mask;
  if (color > 0)
    image->bitmap.word[index] |= mask;

  return 0;
}

static int monocolor_copy_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return (image->copy.bitmap.word[index] & (1 << offset)) ? image->color.fg : image->color.bg;
}

static int monobcolor_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return (image->bitmap.byte[index] & (1 << offset)) ? image->color.fg : image->color.bg;
}

static int monobcolor_set_color(image_t image, int x, int y, int color, unsigned int flags)
{
  int index, offset, mask;

  image->procs->index(image, image->width, x, y, &index, &offset);
  mask = (1 << offset);

  image->bitmap.byte[index] &= ~mask;
  if (color > 0)
    image->bitmap.byte[index] |= mask;

  return 0;
}

static int monobcolor_copy_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return (image->copy.bitmap.byte[index] & (1 << offset)) ? image->color.fg : image->color.bg;
}

static int byte_index(image_t image, int width, int x, int y, int *indexp, int *offsetp)
{
  if (indexp)
    *indexp = width * y + x;
  if (offsetp)
    *offsetp = 0;

  return 0;
}

static int roughcolor_to_fullcolor(int rough_color)
{
  int r, g, b;

  if (rough_color & 0x80)
    return -1;

  r = (rough_color >> 4) & 0x3;
  g = (rough_color >> 2) & 0x3;
  b = (rough_color >> 0) & 0x3;

  r = r ? ((r << 6) | 0x3f) : 0;
  g = g ? ((g << 6) | 0x3f) : 0;
  b = b ? ((b << 6) | 0x3f) : 0;

  return (r << 16) | (g << 8) | b;
}

static int fullcolor_to_roughcolor(int full_color)
{
  int r, g, b;

  if (full_color < 0)
    return 0x80;

  r = (full_color >> 16) & 0xff;
  g = (full_color >> 8) & 0xff;
  b = (full_color >> 0) & 0xff;

  r = (r >> 6) & 0x3;
  g = (g >> 6) & 0x3;
  b = (b >> 6) & 0x3;

  return (r << 4) | (g << 2) | b;
}

static int roughcolor_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return roughcolor_to_fullcolor(image->bitmap.byte[index]);
}

static int roughcolor_set_color(image_t image, int x, int y, int color, unsigned int flags)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  image->bitmap.byte[index] = fullcolor_to_roughcolor(color);
  return 0;
}

static int roughcolor_copy_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return roughcolor_to_fullcolor(image->copy.bitmap.byte[index]);
}

static int graycolor_to_fullcolor(int gray_color)
{
  int r, g, b;

  if (gray_color & 0x80)
    return -1;

  r = g = b = gray_color ? ((gray_color << 1) | 0x1) : 0;

  return (r << 16) | (g << 8) | b;
}

static int fullcolor_to_graycolor(int full_color)
{
  int r, g, b;

  if (full_color < 0)
    return 0x80;

  r = (full_color >> 16) & 0xff;
  g = (full_color >> 8) & 0xff;
  b = (full_color >> 0) & 0xff;

  return (((r + g + b) / 3) >> 1) & 0x7f;
}

static int graycolor_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return graycolor_to_fullcolor(image->bitmap.byte[index]);
}

static int graycolor_set_color(image_t image, int x, int y, int color, unsigned int flags)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  image->bitmap.byte[index] = fullcolor_to_graycolor(color);
  return 0;
}

static int graycolor_copy_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return graycolor_to_fullcolor(image->copy.bitmap.byte[index]);
}

static int half_index(image_t image, int width, int x, int y, int *indexp, int *offsetp)
{
  if (indexp)
    *indexp = width * y + x;
  if (offsetp)
    *offsetp = 0;

  return 0;
}

static int halfcolor_to_fullcolor(int half_color)
{
  int r, g, b;

  if (half_color & 0x8000)
    return -1;

  r = (half_color >> 10) & 0x1f;
  g = (half_color >> 5) & 0x1f;
  b = (half_color >> 0) & 0x1f;

  r = r ? ((r << 3) | 0x7) : 0;
  g = g ? ((g << 3) | 0x7) : 0;
  b = b ? ((b << 3) | 0x7) : 0;

  return (r << 16) | (g << 8) | b;
}

static int fullcolor_to_halfcolor(int full_color)
{
  int r, g, b;

  if (full_color < 0)
    return 0x8000;

  r = (full_color >> 16) & 0xff;
  g = (full_color >> 8) & 0xff;
  b = (full_color >> 0) & 0xff;

  r = (r >> 3) & 0x1f;
  g = (g >> 3) & 0x1f;
  b = (b >> 3) & 0x1f;

  return (r << 10) | (g << 5) | b;
}

static int halfcolor_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return halfcolor_to_fullcolor(image->bitmap.half[index]);
}

static int halfcolor_set_color(image_t image, int x, int y, int color, unsigned int flags)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  image->bitmap.half[index] = fullcolor_to_halfcolor(color);
  return 0;
}

static int halfcolor_copy_get_color(image_t image, int x, int y)
{
  int index, offset;
  image->procs->index(image, image->width, x, y, &index, &offset);
  return halfcolor_to_fullcolor(image->copy.bitmap.half[index]);
}

static int word_copy_save(image_t image, int x, int y, int width, int height)
{
  int i, index0, index1;

  for (i = 0; i < height; i++) {
    image->procs->index(image, image->width, x , y + i, &index0, ((void *)0));
    image->procs->index(image, image->width, x + width - 1, y + i, &index1, ((void *)0));
    memcpy(&image->copy.bitmap.word[index0], &image->bitmap.word[index0],
    (index1 - index0 + 1) * image->procs->bytesize);
  }

  return 0;
}

static int word_copy_save_color(image_t image, int x, int y)
{
  int index;
  image->procs->index(image, image->width, x, y, &index, ((void *)0));
  image->copy.bitmap.word[index] = image->bitmap.word[index];
  return 0;
}

static int half_copy_save(image_t image, int x, int y, int width, int height)
{
  int i, index0, index1;

  for (i = 0; i < height; i++) {
    image->procs->index(image, image->width, x , y + i, &index0, ((void *)0));
    image->procs->index(image, image->width, x + width - 1, y + i, &index1, ((void *)0));
    memcpy(&image->copy.bitmap.half[index0], &image->bitmap.half[index0],
    (index1 - index0 + 1) * image->procs->bytesize);
  }

  return 0;
}

static int half_copy_save_color(image_t image, int x, int y)
{
  int index;
  image->procs->index(image, image->width, x, y, &index, ((void *)0));
  image->copy.bitmap.half[index] = image->bitmap.half[index];
  return 0;
}

static int byte_copy_save(image_t image, int x, int y, int width, int height)
{
  int i, index0, index1;

  for (i = 0; i < height; i++) {
    image->procs->index(image, image->width, x , y + i, &index0, ((void *)0));
    image->procs->index(image, image->width, x + width - 1, y + i, &index1, ((void *)0));
    memcpy(&image->copy.bitmap.byte[index0], &image->bitmap.byte[index0],
    (index1 - index0 + 1) * image->procs->bytesize);
  }

  return 0;
}

static int byte_copy_save_color(image_t image, int x, int y)
{
  int index;
  image->procs->index(image, image->width, x, y, &index, ((void *)0));
  image->copy.bitmap.byte[index] = image->bitmap.byte[index];
  return 0;
}

static struct image_procs image_procs[] = {
  { sizeof(int), word_index,
    fullcolor_get_color, fullcolor_set_color, fullcolor_copy_get_color,
    word_copy_save, word_copy_save_color
  },
  { sizeof(int), bit_index,
    monocolor_get_color, monocolor_set_color, monocolor_copy_get_color,
    word_copy_save, word_copy_save_color
  },
  { sizeof(unsigned char), bit_index,
    monobcolor_get_color, monobcolor_set_color, monobcolor_copy_get_color,
    byte_copy_save, byte_copy_save_color
  },
  { sizeof(unsigned char), byte_index,
    roughcolor_get_color, roughcolor_set_color, roughcolor_copy_get_color,
    byte_copy_save, byte_copy_save_color
  },
  { sizeof(unsigned char), byte_index,
    graycolor_get_color, graycolor_set_color, graycolor_copy_get_color,
    byte_copy_save, byte_copy_save_color
  },
  { sizeof(unsigned short), half_index,
    halfcolor_get_color, halfcolor_set_color, halfcolor_copy_get_color,
    half_copy_save, half_copy_save_color
  },
  { 0, ((void *)0), ((void *)0), ((void *)0), ((void *)0), ((void *)0) }
};

int image_get_color(image_t image, int x, int y)
{
  if ((x < 0) || (x > image->width - 1) ||
      (y < 0) || (y > image->height - 1))
    return -1;
  return image->procs->get_color(image, x, y);
}

int image_set_color(image_t image, int x, int y, int color, unsigned int flags)
{
  int c, set;

  if ((x < 0) || (x > image->width - 1) ||
      (y < 0) || (y > image->height - 1))
    return -1;

  if (image->flags & (1 << 10))
    return 0;

  set = flags & (3 << 16);

  switch (set) {
  case (0 << 16):
    break;
  default:
    c = image->procs->get_color(image, x, y);
    switch (set) {
    case (1 << 16): color &= c; break;
    case (2 << 16): color |= c; break;
    case (3 << 16): color ^= c; break;
    default:
      break;
    }
  }

  if (color < 0)
    color = -1;

  return image->procs->set_color(image, x, y, color, flags);
}

int image_copy_get_color(image_t image, int x, int y)
{
  if ((x < 0) || (x > image->width - 1) ||
      (y < 0) || (y > image->height - 1))
    return -1;
  return image->procs->copy_get_color(image, x, y);
}

int image_copy_save(image_t image, int x, int y, int width, int height)
{
  if (width < 0) { x += width; width = -width; }
  if (height < 0) { y += height; height = -height; }

  if (x < 0) { width += x; x = 0; }
  if (y < 0) { height += y; y = 0; }

  if (x + width > image->width ) width = image->width - x;
  if (y + height > image->height) height = image->height - y;

  if ((width <= 0) || (height <= 0))
    return 0;

  if (image->copy.bitmap.p == image->bitmap.p)
    return 0;

  return image->procs->copy_save(image, x, y, width, height);
}

int image_copy_save_color(image_t image, int x, int y)
{
  if ((x < 0) || (x > image->width - 1) ||
      (y < 0) || (y > image->height - 1))
    return -1;
  if (image->copy.bitmap.p == image->bitmap.p)
    return 0;
  return image->procs->copy_save_color(image, x, y);
}

int image_get_index(image_t image)
{
  if (!image)
    return -1;
  return image->index;
}

image_t image_get_image(int index)
{
  image_t image;

  if (index >= 1024)
    return ((void *)0);

  if (index < 0) {
    for (index = 0; index < 1024; index++) {
      image = images[index];
      if (image && image->status == IMAGE_STATUS_FREE) {
 image_destroy(image);
 image = images[index];
      }
      if (!image)
 break;
    }
    if (index == 1024)
      return ((void *)0);

    if ((image = _alloc()) == ((void *)0))
      return ((void *)0);
    image_num++;

    memset(image, 0, sizeof(*image));
    image->status = IMAGE_STATUS_NONE;
    image->index = index;

    images[index] = image;
  }

  return images[index];
}

int image_reset_draw(image_t image)
{
  if (image->draw.line)
    memset(image->draw.line, 0, image->height * sizeof(image_draw_count_t));
  if (image->draw.column)
    memset(image->draw.column, 0, image->draw.column_num * image->height * sizeof(image_draw_count_t));
  if (image->draw.pixel)
    memset(image->draw.pixel, 0, image->width * image->height * sizeof(image_draw_count_t));
  return 0;
}

int image_destroy(image_t image)
{
  int r;

  if (image->flags & (1 << 8))
    return 0;

  image->status = IMAGE_STATUS_NONE;

  images[image->index] = ((void *)0);

  if (image->copy.bitmap.p && (image->copy.bitmap.p != image->bitmap.p))
    memory_free(image->copy.bitmap.p);
  if (image->draw.pixel) memory_free(image->draw.pixel);
  if (image->draw.column) memory_free(image->draw.column);
  if (image->draw.line) memory_free(image->draw.line);

  if (!(image->flags & (1 << 9))) {
    if (image->bitmap.p)
      memory_free(image->bitmap.p);
  }

  memset(image, 0, sizeof(*image));

  image_num--;
  if ((r = _free(image)) < 0)
    return r;

  return 0;
}

int image_create(image_t image, int width, int height, void *bitmap,
   image_type_t type, unsigned int flags)
{
  int size;

  if (type == IMAGE_TYPE_NONE) {
    switch (flags & (7 << 13)) {
    case (2 << 13): type = IMAGE_TYPE_MONOCOLOR; break;
    case (3 << 13): type = IMAGE_TYPE_MONOBCOLOR; break;
    case (4 << 13): type = IMAGE_TYPE_ROUGHCOLOR; break;
    case (5 << 13): type = IMAGE_TYPE_GRAYCOLOR; break;
    case (6 << 13): type = IMAGE_TYPE_HALFCOLOR; break;
    case (1 << 13):
    case (0 << 13):
    default: type = IMAGE_TYPE_FULLCOLOR; break;
    }
  }

  image->width = width;
  image->height = height;

  image->type = type;
  image->procs = &image_procs[type];

  image->procs->index(image, image->width, image->width - 1, 0, &size, ((void *)0));
  size = (size + 1) * image->procs->bytesize;
  size *= image->height;

  image->size = size;
  image->flags = flags;

  image->color.fg = 0xFFFFFF;
  image->color.bg = -1;
  image->color.from = -1;
  image->color.to = -1;

  if (bitmap) {
    image->bitmap.word = bitmap;
  } else {
    image->bitmap.p = memory_alloc(image->size);
    if (!image->bitmap.p)
      goto err;
    memset(image->bitmap.p, 0, image->size);
  }

  image->draw.column_per = 32;
  image->draw.column_num = (image->width + image->draw.column_per - 1) / image->draw.column_per;

  if (image->flags & (1 << 10)) {
    image->draw.line = ((void *)0);
    image->draw.column = ((void *)0);
    image->draw.pixel = ((void *)0);
    image->copy.bitmap.p = image->bitmap.p;
  } else {
    image->draw.line = memory_alloc(image->height * sizeof(image_draw_count_t));
    image->draw.column = memory_alloc(image->draw.column_num * image->height * sizeof(image_draw_count_t));
    if (!image->draw.line || !image->draw.column)
      goto err;

    if (image->flags & (1 << 11)) {
      image->draw.pixel = ((void *)0);
    } else {
      image->draw.pixel = memory_alloc(image->width * image->height * sizeof(image_draw_count_t));
      if (!image->draw.pixel)
 goto err;
    }

    image->copy.bitmap.p = memory_alloc(image->size);
    if (!image->copy.bitmap.p)
      goto err;
    memset(image->copy.bitmap.p, 0, image->size);
  }

  image_reset_draw(image);

  image->draw.count = 0;

  image->status = IMAGE_STATUS_ACTIVE;

  return 0;

err:
  image_destroy(image);
  return -1;
}

image_t image_get(int width, int height, void *bitmap,
    image_type_t type, unsigned int flags)
{
  image_t image;

  image = image_get_image(-1);
  if (!image)
    return ((void *)0);

  if (image_create(image, width, height, bitmap, type, flags) < 0)
    return ((void *)0);

  return image;
}
