# 0 "variable.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "variable.c"
# 1 "config.h" 1
# 2 "variable.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "variable.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "variable.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "variable.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 9 "variable.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 12 "variable.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 13 "variable.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 14 "variable.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 15 "variable.c" 2
# 1 "constval.h" 1



struct const_variable {
  const char *name;
  unsigned int flags;
  value_type_t type;
  integer_t integer;
  const char *string;
  void *pointer;
};

extern const struct const_variable const_variables[];

extern const double const_variables_floating[];
# 16 "variable.c" 2
# 1 "function.h" 1



enum {
  FUNCTION_TYPE_NONE = 0,
  FUNCTION_TYPE_FARGS,
  FUNCTION_TYPE_COPY,
  FUNCTION_TYPE_TRUE,
  FUNCTION_TYPE_FALSE,
  FUNCTION_TYPE_ARGNUM,
  FUNCTION_TYPE_BOOLEAN,
  FUNCTION_TYPE_COND,
  FUNCTION_TYPE_AT,
  FUNCTION_TYPE_FPUSH,
  FUNCTION_TYPE_FPOP,
  FUNCTION_TYPE_STACKNUM,
  FUNCTION_TYPE_FPRINT,
  FUNCTION_TYPE_SPRINTF,
  FUNCTION_TYPE_PRINTF,
  FUNCTION_TYPE_PRINTM,
  FUNCTION_TYPE_INPUT,
  FUNCTION_TYPE_INPUTN,
  FUNCTION_TYPE_FWAIT,
  FUNCTION_TYPE_TIMER,
  FUNCTION_TYPE_NOSYSTEM,
  FUNCTION_TYPE_NOSYSCALL,
  FUNCTION_TYPE_NONETWORK,





  FUNCTION_TYPE_SYSTEM,


  FUNCTION_TYPE_SYSCALL,

  FUNCTION_TYPE_FEVAL,
  FUNCTION_TYPE_FEVALF,
  FUNCTION_TYPE_TYPEOF,
  FUNCTION_TYPE_TYPENAME,
  FUNCTION_TYPE_SIZEOF,
  FUNCTION_TYPE_NZERO,
  FUNCTION_TYPE_CMP,
  FUNCTION_TYPE_REP,
  FUNCTION_TYPE_INSERT,
  FUNCTION_TYPE_DELETE,
  FUNCTION_TYPE_ITOC,
  FUNCTION_TYPE_CTOI,
  FUNCTION_TYPE_ITOA,
  FUNCTION_TYPE_ATOI,

  FUNCTION_TYPE_ITOF,
  FUNCTION_TYPE_FTOI,
  FUNCTION_TYPE_ATOF,
  FUNCTION_TYPE_FTOA,

  FUNCTION_TYPE_ISALNUM,
  FUNCTION_TYPE_ISALPHA,
  FUNCTION_TYPE_ISASCII,
  FUNCTION_TYPE_ISCNTRL,
  FUNCTION_TYPE_ISDIGIT,
  FUNCTION_TYPE_ISGRAPH,
  FUNCTION_TYPE_ISLOWER,
  FUNCTION_TYPE_ISPRINT,
  FUNCTION_TYPE_ISPUNCT,
  FUNCTION_TYPE_ISSPACE,
  FUNCTION_TYPE_ISUPPER,
  FUNCTION_TYPE_ISXDIGIT,
  FUNCTION_TYPE_TOLOWER,
  FUNCTION_TYPE_TOUPPER,
  FUNCTION_TYPE_LEFT,
  FUNCTION_TYPE_RIGHT,
  FUNCTION_TYPE_MID,
  FUNCTION_TYPE_INSTR,
  FUNCTION_TYPE_STRLEN,
  FUNCTION_TYPE_STRCPY,
  FUNCTION_TYPE_SPLIT,
  FUNCTION_TYPE_SPLITS,
  FUNCTION_TYPE_CHOMP,
  FUNCTION_TYPE_LCHOMP,
  FUNCTION_TYPE_RCHOMP,
  FUNCTION_TYPE_SRAND,
  FUNCTION_TYPE_RAND,
  FUNCTION_TYPE_INT,
  FUNCTION_TYPE_ABS,
  FUNCTION_TYPE_SIGN,
  FUNCTION_TYPE_MAX,
  FUNCTION_TYPE_MIN,
  FUNCTION_TYPE_ABS2SUM,
  FUNCTION_TYPE_TIME,
  FUNCTION_TYPE_DATE,
  FUNCTION_TYPE_FDIM,
  FUNCTION_TYPE_FMEMORY,
  FUNCTION_TYPE_PEEK,
  FUNCTION_TYPE_POKE,
  FUNCTION_TYPE_MREAD,
  FUNCTION_TYPE_MWRITE,
  FUNCTION_TYPE_MCOPY,
# 127 "function.h"
  FUNCTION_TYPE_RENAME,
  FUNCTION_TYPE_UNLINK,
  FUNCTION_TYPE_TRUNCATE,
  FUNCTION_TYPE_MKDIR,
  FUNCTION_TYPE_RMDIR,
  FUNCTION_TYPE_CHDIR,
  FUNCTION_TYPE_OPEN,
  FUNCTION_TYPE_CLOSE,
  FUNCTION_TYPE_READ,
  FUNCTION_TYPE_WRITE,
  FUNCTION_TYPE_LSEEK,
  FUNCTION_TYPE_FTRUNCATE,
  FUNCTION_TYPE_ISREADABLE,
  FUNCTION_TYPE_ISWRITABLE,
  FUNCTION_TYPE_FOPEN,
  FUNCTION_TYPE_FDOPEN,
  FUNCTION_TYPE_FCLOSE,
  FUNCTION_TYPE_FILENO,
  FUNCTION_TYPE_FEOF,
  FUNCTION_TYPE_FERROR,
  FUNCTION_TYPE_FGETC,
  FUNCTION_TYPE_FPUTC,
  FUNCTION_TYPE_FGETS,
  FUNCTION_TYPE_FPUTS,
  FUNCTION_TYPE_FPRINTF,
  FUNCTION_TYPE_FREAD,
  FUNCTION_TYPE_FWRITE,
  FUNCTION_TYPE_FSEEK,
  FUNCTION_TYPE_QOPEN,
  FUNCTION_TYPE_QCLOSE,
  FUNCTION_TYPE_QLENGTH,
  FUNCTION_TYPE_QPUSHF,
  FUNCTION_TYPE_QPOPL,
  FUNCTION_TYPE_QPUSHL,
  FUNCTION_TYPE_QPOPF,
# 175 "function.h"
  FUNCTION_TYPE_KEYNAME,
  FUNCTION_TYPE_KEYCODE,
  FUNCTION_TYPE_SCREEN,
  FUNCTION_TYPE_SCRSTAT,
  FUNCTION_TYPE_FLUSH,
  FUNCTION_TYPE_GETCOLOR,
  FUNCTION_TYPE_GETFGCOLOR,
  FUNCTION_TYPE_GETBGCOLOR,
  FUNCTION_TYPE_SETCOLOR,
  FUNCTION_TYPE_GETATTR,
  FUNCTION_TYPE_SETATTR,
  FUNCTION_TYPE_GETPOS,
  FUNCTION_TYPE_MOVE,
  FUNCTION_TYPE_GETCH,
  FUNCTION_TYPE_CLEAR,
  FUNCTION_TYPE_SCROLL,
  FUNCTION_TYPE_LINE,
  FUNCTION_TYPE_BOX,
  FUNCTION_TYPE_INKEY,
  FUNCTION_TYPE_GSCREEN,
  FUNCTION_TYPE_GSCRSTAT,
  FUNCTION_TYPE_GCOLOR,
  FUNCTION_TYPE_GRGB,
  FUNCTION_TYPE_GSYNC,
  FUNCTION_TYPE_GFLUSH,
  FUNCTION_TYPE_GGETMAINIMG,
  FUNCTION_TYPE_GSETMAINIMG,
  FUNCTION_TYPE_GGETSIZE,
  FUNCTION_TYPE_GGETRANGE,
  FUNCTION_TYPE_GSETRANGE,
  FUNCTION_TYPE_GGETOFFSET,
  FUNCTION_TYPE_GSETOFFSET,
  FUNCTION_TYPE_GGETSCALE,
  FUNCTION_TYPE_GSETSCALE,
  FUNCTION_TYPE_GGETDOTOFFSET,
  FUNCTION_TYPE_GSETDOTOFFSET,
  FUNCTION_TYPE_GGETDOTSIZE,
  FUNCTION_TYPE_GSETDOTSIZE,
  FUNCTION_TYPE_GGETCOLOR,
  FUNCTION_TYPE_GSETCOLOR,
  FUNCTION_TYPE_GGETPIXEL,
  FUNCTION_TYPE_GCLEAR,
  FUNCTION_TYPE_GSCROLL,
  FUNCTION_TYPE_GDOT,
  FUNCTION_TYPE_GLINE,
  FUNCTION_TYPE_GBOX,
  FUNCTION_TYPE_GCIRCLE,
  FUNCTION_TYPE_GPAINT,
  FUNCTION_TYPE_GCOPY,
  FUNCTION_TYPE_GROTATE,
  FUNCTION_TYPE_GCHAR,
  FUNCTION_TYPE_GPRINT,
  FUNCTION_TYPE_GINKEY,
  FUNCTION_TYPE_GKEYSTAT,
  FUNCTION_TYPE_GMOUSEPOS,
  FUNCTION_TYPE_GINMOUSE,
  FUNCTION_TYPE_GMOUSESTAT,
  FUNCTION_TYPE_GALLOCIMAGE,
  FUNCTION_TYPE_GFREEIMAGE,
  FUNCTION_TYPE_GLOADIMAGE,
  FUNCTION_TYPE_GSAVEIMAGE,
  FUNCTION_TYPE_GCMPIMAGE,
  FUNCTION_TYPE_GCHARSET,
  FUNCTION_TYPE_ASTOP,
  FUNCTION_TYPE_ACLEAR,
  FUNCTION_TYPE_ASOUND,
  FUNCTION_TYPE_ASNDSTAT,
  FUNCTION_TYPE_APLAYNUM,
  FUNCTION_TYPE_AWAIT,
  FUNCTION_TYPE_AUNITSET,
  FUNCTION_TYPE_AUNIT,
  FUNCTION_TYPE_AOSC,
  FUNCTION_TYPE_AADDOUT,
  FUNCTION_TYPE_AENVPOINT,
  FUNCTION_TYPE_AENVCOPY,
  FUNCTION_TYPE_AFILPOINT,
  FUNCTION_TYPE_AFILCOPY,
  FUNCTION_TYPE_APLAY,
  FUNCTION_TYPE_AOPEN,
  FUNCTION_TYPE_ACLOSE,
};

const char *function_name(function_t function);
int function_search(const char *name, function_t *functionp);
int function_list(FILE *fp);
int function_proc(function_t function, value_t *valuep, value_t args);
# 17 "variable.c" 2
# 1 "variable.h" 1



struct variable {
  struct variable *next;
  struct variable *prev;
  value_t value;
  int refcount;
  char name[32 + 1];
};

int variable_check(void);
int variable_del(variable_t variable);
int variable_clean(void);
int variable_clear(void);
int variable_new(variable_t variable);
int variable_init(void);
int variable_done(void);
int variable_get(const char *name, variable_t *variablep);
int variable_dump(FILE *fp, variable_t variable);
int variable_const_list(FILE *fp);
# 18 "variable.c" 2

static int variable_num = 0;
static int pool_num = 0;

static variable_t head = ((void *)0);
static variable_t pool = ((void *)0);

static variable_t pool_alloc(void)
{
  variable_t variable;

  if (!pool)
    return ((void *)0);

  variable = pool;
  pool = pool->next;
  pool_num--;

  return variable;
}

static int pool_free(variable_t variable)
{
  variable->next = pool;
  pool = variable;
  pool_num++;
  return 0;
}


static int _init(void)
{
  return 0;
}

static int _done(void)
{
  while (pool)
    memory_free(pool_alloc());
  return 0;
}

static int _check(void)
{
  if (pool)
    return NLL_ERRCODE_VARIABLE_NOT_EMPTY;
  return 0;
}

static variable_t _alloc(void)
{
  variable_t variable;
  variable = pool_alloc();
  if (!variable)
    variable = memory_alloc(sizeof(*variable));
  return variable;
}

static int _free(variable_t variable)
{
  if ((256 < 0) || (pool_num < 256))
    return pool_free(variable);
  memory_free(variable);
  return 0;
}
# 133 "variable.c"
int variable_check(void)
{
  if (variable_num || head)
    return NLL_ERRCODE_VARIABLE_NOT_EMPTY;

  return _check();
}

static int variable_free(variable_t variable)
{
  variable_t next;
  int r;

  for (; variable; variable = next) {
    next = variable->next;

    if (variable->value) {



      value_free(variable->value);
    }

    variable_num--;
    if ((r = _free(variable)) < 0)
      return r;
  }

  return 0;
}

static int variable_alloc(variable_t *variablep)
{
  variable_t variable;
  int r;

  if ((variable = _alloc()) == ((void *)0))
    return NLL_ERRCODE_VARIABLE_BUFFER_OVER;
  variable_num++;

  memset(variable, 0, sizeof(*variable));

  if ((r = value_alloc(&variable->value)) < 0) {
    variable_free(variable);
    return r;
  }

  *variablep = variable;

  return 0;
}

int variable_del(variable_t variable)
{
  if ((--(variable->refcount) == 0) &&
      (variable->value->type == VALUE_TYPE_UNDEFINED)) {
    if (variable->next)
      variable->next->prev = variable->prev;
    if (variable->prev)
      variable->prev->next = variable->next;
    if (head == variable)
      head = variable->next;
    variable->next = variable->prev = ((void *)0);
    variable_free(variable);
  }

  return 0;
}

int variable_clean(void)
{
  variable_t variable, next;

  for (variable = head; variable; variable = next) {
    next = variable->next;
    if (variable->refcount == 0) {
      if (variable->next)
 variable->next->prev = variable->prev;
      if (variable->prev)
 variable->prev->next = variable->next;
      if (head == variable)
 head = variable->next;
      variable->next = variable->prev = ((void *)0);
      variable_free(variable);
    }
  }

  return 0;
}

int variable_clear(void)
{
  variable_t variable;
  int r;

  for (variable = head; variable; variable = variable->next) {
    if ((r = value_clear(variable->value)) < 0)
      return r;
  }

  return 0;
}

int variable_new(variable_t variable)
{
  int r;

  if (variable->value) {
    if (variable->value->flags & (1 << 0))
      return NLL_ERRCODE_VALUE_CONST_VALUE;
    if (variable->value->flags & (1 << 1))
      return 0;



    value_free(variable->value);
    variable->value = ((void *)0);
  }

  if ((r = value_alloc(&variable->value)) < 0)
    return r;

  return 0;
}

int variable_init(void)
{
  variable_num = 0;
  pool_num = 0;
  head = ((void *)0);
  pool = ((void *)0);
  return _init();
}

int variable_done(void)
{
  return _done();
}

static int variable_const(variable_t variable)
{
  int r;
  const struct const_variable *p;

  const double *dp = const_variables_floating;


  for (p = const_variables; p->name; p++) {
    if (!strcmp(variable->name, p->name)) {
      switch (p->type) {
      case VALUE_TYPE_UNDEFINED:
 if ((r = value_clear(variable->value)) < 0)
   return r;
 break;
      case VALUE_TYPE_NULL:
 if ((r = value_set_null(variable->value)) < 0)
   return r;
 break;
      case VALUE_TYPE_INTEGER:
 if ((r = value_set_integer(variable->value, p->integer)) < 0)
   return r;
 break;
      case VALUE_TYPE_STRING:
 if ((r = value_set_string(variable->value, p->string, -1)) < 0)
   return r;
 break;

      case VALUE_TYPE_FLOAT:
 if ((r = value_set_float(variable->value, *dp)) < 0)
   return r;
 break;

      case VALUE_TYPE_ARRAY:
 if ((r = value_set_array(variable->value, p->pointer, 0)) < 0)
   return r;
 break;
      case VALUE_TYPE_AREA:
 if ((r = value_set_area(variable->value, p->pointer)) < 0)
   return r;
 break;
      case VALUE_TYPE_POINTER:
 if ((r = value_set_pointer(variable->value, p->pointer, 0)) < 0)
   return r;
 break;
      case VALUE_TYPE_FUNCTION:
 if ((r = value_set_function(variable->value, p->pointer)) < 0)
   return r;
 break;
      case VALUE_TYPE_LABEL:
 if ((r = value_set_label(variable->value, p->pointer)) < 0)
   return r;
 break;
      default:
 return NLL_ERRCODE_VALUE_INVALID_TYPE;
      }
      variable->value->flags = p->flags;
      break;
    }

    if (p->type == VALUE_TYPE_FLOAT)
      dp++;

  }

  return 0;
}

int variable_get(const char *name, variable_t *variablep)
{
  variable_t variable;
  function_t function;
  int r;

  for (variable = head; variable; variable = variable->next) {
    if (variable->name[0] && !strcmp(variable->name, name))
      break;
  }

  if (!variable) {
    if (strlen(name) > 32)
      return NLL_ERRCODE_VARIABLE_TOO_LONG;

    if ((r = variable_alloc(&variable)) < 0)
      return r;

    strcpy(variable->name, name);

    if ((r = variable_const(variable)) < 0) {
      variable_free(variable);
      return r;
    }

    if ((r = function_search(name, &function)) < 0) {

    } else {
      if ((r = value_set_function(variable->value, function)) < 0)
 return r;
      variable->value->flags |= (1 << 0);
    }

    variable->next = head;
    variable->prev = ((void *)0);
    if (head)
      head->prev = variable;
    head = variable;

    r = 1;
  } else {
    r = 0;
  }

  variable->refcount++;

  *variablep = variable;

  return r;
}

int variable_dump(FILE *fp, variable_t variable)
{
  if (!variable)
    variable = head;

  nll_wait_output(fp);
  fprintf(fp, "\n-- Variable dump --\n");

  for (; variable; variable = variable->next) {
    nll_wait_output(fp);
    fprintf(fp, "%s:\tRef:%d\tValue:", variable->name, variable->refcount);
    if (variable->value->flags & (1 << 0))
      fprintf(fp, "(C)");
    if (variable->value->flags & (1 << 1))
      fprintf(fp, "(R)");
    if (variable->value->flags & (1 << 2))
      fprintf(fp, "(S)");
    value_dump(fp, variable->value);
    fprintf(fp, "\n");
  }

  fflush(fp);

  return 0;
}

int variable_const_list(FILE *fp)
{
  const struct const_variable *p;

  const double *dp = const_variables_floating;


  for (p = const_variables; p->name; p++) {
    nll_wait_output(fp);
    fprintf(fp, "%s", p->name);
    switch (p->type) {
    case VALUE_TYPE_INTEGER:
      fprintf(fp, "\t%ld(0x%lx)", p->integer, p->integer);
      break;
    case VALUE_TYPE_STRING:
      if (p->string)
 fprintf(fp, "\t\"%s\"", p->string);
      break;

    case VALUE_TYPE_FLOAT:
      fprintf(fp, "\t%f(FLOAT)", *dp);
      break;

    default:
      fprintf(fp, "\t(%s)", value_typename_string(p->type));
      break;
    }
    fprintf(fp, "\n");

    if (p->type == VALUE_TYPE_FLOAT)
      dp++;

  }

  fflush(fp);

  return 0;
}
