# 0 "value.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "value.c"
# 1 "config.h" 1
# 2 "value.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "value.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "value.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "value.c" 2
# 1 "../include/ctype.h" 1



int isalnum(int c);
int isalpha(int c);
int isascii(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);
int tolower(int c);
int toupper(int c);
# 7 "value.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 10 "value.c" 2


# 1 "const.h" 1
# 13 "value.c" 2
# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 14 "value.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 15 "value.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 16 "value.c" 2
# 1 "string.h" 1



struct string {
  struct string *next;
  char *s;
  int length;
  int size;
};

int string_check(void);
int string_alloc(string_t *stringp);
int string_free(string_t string);
int string_del(string_t string);
int string_init(void);
int string_done(void);
int string_set(string_t string, const char *s, int length);
char *string_buffer(void);
int string_buffer_size(void);
int string_dump_string(FILE *fp, string_t string);
int string_dump(FILE *fp, string_t string);
# 17 "value.c" 2
# 1 "label.h" 1



struct label {
  struct label *next;
  struct label *prev;
  struct spot spot;
  int refcount;
  char name[32 + 1];
};

int label_check(void);
int label_init(void);
int label_done(void);
int label_get(const char *name, label_t *labelp);
int label_set(const char *name, spot_t spot, label_t *labelp);
int label_clear(label_t label);
int label_clean(label_t label);
int label_del(label_t label);
int label_dump(FILE *fp, label_t label);
# 18 "value.c" 2
# 1 "array.h" 1



struct array {
  value_t value;
};

int array_check(void);
int array_init(void);
int array_get_number(array_t array);
int array_get_value(array_t array, int index, value_t *valuep);
int array_set_value(array_t array, int index, value_t value);
int array_alloc(array_t *arrayp, int number);
int array_free(array_t array, int number);
int array_make(value_t value, int *n);
int array_make_values(value_t value, value_t numbers);
int array_dump(FILE *fp, array_t array);
# 19 "value.c" 2
# 1 "area.h" 1



struct area {
  struct area *next;
  struct area *prev;
  int refcount;
  int size;
  int area_size;
};

int area_check(void);
int area_alloc(area_t *areap, int size);
int area_free(area_t area);
int area_init(void);
int area_get_size(area_t area);
char *area_get_buffer(area_t area);
int area_copy_area(area_t area, int offset, area_t _area, int _offset, int size);
int area_read(area_t area, int offset, char *buffer, int size);
int area_write(area_t area, int offset, char *buffer, int size);
int area_read_integer(area_t area, int offset, integer_t *integerp, int size);
int area_write_integer(area_t area, int offset, integer_t integer, int size);
int area_dump(FILE *fp, area_t area);
# 20 "value.c" 2
# 1 "key.h" 1



typedef enum {
  KEY_CODE_NONE = 0,

  KEY_CODE_ENTER = '\n',
  KEY_CODE_ESCAPE = 0x1b,
  KEY_CODE_BACKSPACE = '\b',
  KEY_CODE_TAB = '\t',
  KEY_CODE_SPACE = ' ',
  KEY_CODE_EXCLAIM = '!',
  KEY_CODE_QUOTEDBL = '"',
  KEY_CODE_HASH = '#',
  KEY_CODE_PERCENT = '%',
  KEY_CODE_DOLLAR = '$',
  KEY_CODE_AMPERSAND = '&',
  KEY_CODE_QUOTE = '\'',
  KEY_CODE_LEFTPAREN = '(',
  KEY_CODE_RIGHTPAREN = ')',
  KEY_CODE_ASTERISK = '*',
  KEY_CODE_PLUS = '+',
  KEY_CODE_COMMA = ',',
  KEY_CODE_MINUS = '-',
  KEY_CODE_PERIOD = '.',
  KEY_CODE_SLASH = '/',
  KEY_CODE_0 = '0',
  KEY_CODE_1 = '1',
  KEY_CODE_2 = '2',
  KEY_CODE_3 = '3',
  KEY_CODE_4 = '4',
  KEY_CODE_5 = '5',
  KEY_CODE_6 = '6',
  KEY_CODE_7 = '7',
  KEY_CODE_8 = '8',
  KEY_CODE_9 = '9',
  KEY_CODE_COLON = ':',
  KEY_CODE_SEMICOLON = ';',
  KEY_CODE_LESS = '<',
  KEY_CODE_EQUALS = '=',
  KEY_CODE_GREATER = '>',
  KEY_CODE_QUESTION = '?',
  KEY_CODE_AT = '@',
  KEY_CODE_LEFTBRACKET = '[',
  KEY_CODE_BACKSLASH = '\\',
  KEY_CODE_RIGHTBRACKET = ']',
  KEY_CODE_CARET = '^',
  KEY_CODE_UNDERSCORE = '_',
  KEY_CODE_BACKQUOTE = '`',
  KEY_CODE_A = 'a',
  KEY_CODE_B = 'b',
  KEY_CODE_C = 'c',
  KEY_CODE_D = 'd',
  KEY_CODE_E = 'e',
  KEY_CODE_F = 'f',
  KEY_CODE_G = 'g',
  KEY_CODE_H = 'h',
  KEY_CODE_I = 'i',
  KEY_CODE_J = 'j',
  KEY_CODE_K = 'k',
  KEY_CODE_L = 'l',
  KEY_CODE_M = 'm',
  KEY_CODE_N = 'n',
  KEY_CODE_O = 'o',
  KEY_CODE_P = 'p',
  KEY_CODE_Q = 'q',
  KEY_CODE_R = 'r',
  KEY_CODE_S = 's',
  KEY_CODE_T = 't',
  KEY_CODE_U = 'u',
  KEY_CODE_V = 'v',
  KEY_CODE_W = 'w',
  KEY_CODE_X = 'x',
  KEY_CODE_Y = 'y',
  KEY_CODE_Z = 'z',

  KEY_CODE_CAPSLOCK = 128,
  KEY_CODE_F1,
  KEY_CODE_F2,
  KEY_CODE_F3,
  KEY_CODE_F4,
  KEY_CODE_F5,
  KEY_CODE_F6,
  KEY_CODE_F7,
  KEY_CODE_F8,
  KEY_CODE_F9,
  KEY_CODE_F10,
  KEY_CODE_F11,
  KEY_CODE_F12,

  KEY_CODE_PRINTSCREEN,
  KEY_CODE_SCROLLLOCK,
  KEY_CODE_PAUSE,
  KEY_CODE_INSERT,
  KEY_CODE_HOME,
  KEY_CODE_PAGEUP,
  KEY_CODE_DELETE,
  KEY_CODE_END,
  KEY_CODE_PAGEDOWN,
  KEY_CODE_RIGHT,
  KEY_CODE_LEFT,
  KEY_CODE_DOWN,
  KEY_CODE_UP,

  KEY_CODE_F13,
  KEY_CODE_F14,
  KEY_CODE_F15,

  KEY_CODE_LCTRL,
  KEY_CODE_LSHIFT,
  KEY_CODE_LALT,
  KEY_CODE_RCTRL,
  KEY_CODE_RSHIFT,
  KEY_CODE_RALT,

  KEY_CODE_NUM
} key_code_t;
# 228 "key.h"
const char *keyname_get(key_code_t code);
key_code_t keycode_get(const char *name);
# 21 "value.c" 2
# 1 "framebuf.h" 1



int framebuf_get_screen_flags(void);
int framebuf_get_screen_width(void);
int framebuf_get_screen_height(void);
int framebuf_get_cursor_x(void);
int framebuf_get_cursor_y(void);
int framebuf_get_cursor_effect(void);
int framebuf_get_cursor_fgcolor(void);
int framebuf_get_cursor_bgcolor(void);
int framebuf_init(void);
int framebuf_done(void);
int framebuf_setscreen(int flags, int width, int height);
int framebuf_enable(int enable);
int framebuf_cursor_on(void);
int framebuf_cursor_off(void);
int framebuf_flush(int flags);
int framebuf_seteffect(int effect);
int framebuf_setfgcolor(int color);
int framebuf_setbgcolor(int color);
int framebuf_move_cursor(int x, int y);
int framebuf_move_left(int num);
int framebuf_move_right(int num);
int framebuf_move_up(int num);
int framebuf_move_down(int num);
int framebuf_getch(int x, int y);
int framebuf_clear(int chara, int flags);
int framebuf_scroll(int x, int y, int chara);
int framebuf_puts(const char *str);
int framebuf_line(int x0, int y0, int x1, int y1, const char *str);
int framebuf_box(int x0, int y0, int x1, int y1, const char *str, int flags);
key_code_t framebuf_getkey(void);
# 22 "value.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 23 "value.c" 2

static int _procid = 0;

static int procid_set(void)
{
  if ((++_procid) == 0)
    _procid = 1;
  return _procid;
}

static int value_num = 0;
static int pool_num = 0;

static value_t pool = ((void *)0);

static value_t pool_alloc(void)
{
  value_t value;

  if (!pool)
    return ((void *)0);

  value = pool;
  pool = pool->next;
  pool_num--;

  return value;
}

static int pool_free(value_t value)
{
  value->next = pool;
  pool = value;
  pool_num++;
  return 0;
}


static int _init(void)
{
  return 0;
}

static int _done(void)
{
  while (pool)
    memory_free(pool_alloc());
  return 0;
}

static int _check(void)
{
  if (pool)
    return NLL_ERRCODE_VALUE_NOT_EMPTY;
  return 0;
}

static value_t _alloc(void)
{
  value_t value;
  value = pool_alloc();
  if (!value)
    value = memory_alloc(sizeof(*value));
  return value;
}

static int _free(value_t value)
{
  if ((4096 < 0) || (pool_num < 4096))
    return pool_free(value);
  memory_free(value);
  return 0;
}
# 146 "value.c"
int value_check(void)
{
  if (value_num)
    return NLL_ERRCODE_VALUE_NOT_EMPTY;

  return _check();
}

int value_alloc(value_t *valuep)
{
  value_t value;

  if ((value = _alloc()) == ((void *)0))
    return NLL_ERRCODE_VALUE_BUFFER_OVER;
  value_num++;

  memset(value, 0, sizeof(*value));

  value->refcount++;

  *valuep = value;

  return 0;
}

int value_free(value_t value)
{
  value_t next;
  int r;

  if (value->refcount > 1) {
    value->refcount--;
    return 1;
  }

  for (; value; value = next) {
    next = value->next;
    value->next = ((void *)0);

    if (--(value->refcount) == 0) {
      value->flags &= ~((1 << 0)|(1 << 1));
      if ((r = value_clear(value)) < 0)
 return r;

      value_num--;
      if ((r = _free(value)) < 0)
 return r;
    }
  }

  return 0;
}

int value_init(void)
{
  value_num = 0;
  pool_num = 0;
  pool = ((void *)0);
  return _init();
}

int value_done(void)
{
  return _done();
}

int value_clear(value_t value)
{
  int r;
  value_type_t type;

  if (!value || (value->flags & ((1 << 0)|(1 << 1))))
    return 0;

  type = value->type;


  value->type = VALUE_TYPE_UNDEFINED;

  switch (type) {
  case VALUE_TYPE_UNDEFINED:
  case VALUE_TYPE_NULL:
  case VALUE_TYPE_INTEGER:

  case VALUE_TYPE_FLOAT:

  case VALUE_TYPE_FUNCTION:
    break;

  case VALUE_TYPE_VALUE:
  case VALUE_TYPE_VECTOR:
    if (value->val.value) {
      if ((r = value_free(value->val.value)) < 0)
 return r;
    }
    break;

  case VALUE_TYPE_STRING:
    if (value->val.string) {
      if ((r = string_del(value->val.string)) < 0)
 return r;
    }
    break;

  case VALUE_TYPE_ARRAY:
    if (value->val.array.a) {
      if ((r = array_free(value->val.array.a, -1)) < 0)
 return r;
    }
    break;

  case VALUE_TYPE_AREA:
    if (value->val.area) {
      if ((r = area_free(value->val.area)) < 0)
 return r;
    }
    break;

  case VALUE_TYPE_POINTER:
    if (value->val.pointer.point) {
      if ((r = value_free(value->val.pointer.point)) < 0)
 return r;
    }
    break;

  case VALUE_TYPE_LABEL:
    if (value->val.label) {
      if ((r = label_del(value->val.label)) < 0)
 return r;
    }
    break;

  default:
    return NLL_ERRCODE_VALUE_INVALID_TYPE;
  }

  return 0;
}

static int type_code[] = {
  0,
  1,
  2,
  3,
  4,
  5,

  6,

  7,
  8,
  9,
  10,
  11,
};

static const char *type_name[] = {
  "UNDEF",
  "NULL",
  "VALUE",
  "VECTOR",
  "INTEGER",
  "STRING",

  "FLOAT",

  "ARRAY",
  "AREA",
  "POINTER",
  "FUNCTION",
  "LABEL",
};

static int _typecode(value_type_t type)
{
  if ((type >= 0) && (type < VALUE_TYPE_NUM))
    return type_code[type];
  return -1;
}

int value_typecode(value_t value)
{
  value = value_entity(value);
  if (!value)
    return -1;
  return _typecode(value->type);
}

const char *value_typename_string(value_type_t type)
{
  if ((type >= 0) && (type < VALUE_TYPE_NUM))
    return type_name[type];
  return "UNKNOWN";
}

const char *value_typename(value_t value)
{
  value = value_entity(value);
  if (!value)
    return "NULL";
  return value_typename_string(value->type);
}

int value_is_true(value_t value)
{
  int r, length;
  integer_t integer;
  char *string;

  double f;

  array_t array;
  area_t area;
  value_t point;
  function_t function;
  label_t label;

  value = value_entity(value);
  if (!value)
    return 0;

  switch (value->type) {
  case VALUE_TYPE_UNDEFINED:
  case VALUE_TYPE_NULL:
    return 0;

  case VALUE_TYPE_VECTOR:
    for (value = value->val.value; value; value = value->next) {
      if ((r = value_is_true(value)) < 0)
 return r;
      if (r)
 break;
    }
    return value ? 1 : 0;

  case VALUE_TYPE_INTEGER:
    if ((r = value_get_integer(value, &integer)) < 0)
      return r;
    return integer ? 1 : 0;

  case VALUE_TYPE_STRING:
    if ((r = value_get_string(value, &string, &length)) < 0)
      return r;
    return (length > 0) ? 1 : 0;


  case VALUE_TYPE_FLOAT:
    if ((r = value_get_float(value, &f)) < 0)
      return r;
    return (f != 0.0) ? 1 : 0;


  case VALUE_TYPE_ARRAY:
    if ((r = value_get_array(value, &array, ((void *)0))) < 0)
      return r;
    return array ? 1 : 0;

  case VALUE_TYPE_AREA:
    if ((r = value_get_area(value, &area)) < 0)
      return r;
    return area ? 1 : 0;

  case VALUE_TYPE_POINTER:
    if ((r = value_get_pointer(value, &point, ((void *)0))) < 0)
      return r;
    return point ? 1 : 0;

  case VALUE_TYPE_FUNCTION:
    if ((r = value_get_function(value, &function)) < 0)
      return r;
    return function ? 1 : 0;

  case VALUE_TYPE_LABEL:
    if ((r = value_get_label(value, &label)) < 0)
      return r;
    return label ? 1 : 0;

  case VALUE_TYPE_VALUE:
  default:
    break;
  }

  return NLL_ERRCODE_VALUE_INVALID_TYPE;
}

value_t value_entity(value_t value)
{
  while (value && (value->type == VALUE_TYPE_VALUE))
    value = value->val.value;

  return value;
}

int value_insert_value(value_t *valuep)
{
  value_t value;
  int r;

  if ((r = value_alloc(&value)) < 0)
    return r;
  if ((r = value_set_next(value, *valuep)) < 0)
    return r;
  *valuep = value;

  return 0;
}

int value_extend_value(value_t *valuep)
{
  if (*valuep)
    return 0;
  return value_insert_value(valuep);
}

int value_shrink_value(value_t *valuep)
{
  int r;

  if (*valuep) {
    if ((r = value_free(*valuep)) < 0)
      return r;
    *valuep = ((void *)0);
  }

  return 0;
}

int value_match_values(value_t *valuep, int num)
{
  int r, i;

  for (i = 0; i < num; i++) {
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

int value_cmp_value(value_t value0, value_t value1)
{
  value0 = value_entity(value0);
  value1 = value_entity(value1);
  if (!value0 && !value1) return 0;
  if (!value0 || !value1) return 1;

  if (value0->type != value1->type)
    return 1;

  switch (value0->type) {
  case VALUE_TYPE_NULL:
    return 0;
  case VALUE_TYPE_VECTOR:
    return value_cmp_values(value0->val.value, value1->val.value);
  case VALUE_TYPE_INTEGER:
    if (value0->val.integer != value1->val.integer)
      return 1;
    break;
  case VALUE_TYPE_STRING:
    if (!value0->val.string && !value1->val.string)
      return 0;
    if (!value0->val.string || !value1->val.string)
      return 1;
    if (value0->val.string->length != value1->val.string->length)
      return 1;
    if (memcmp(value0->val.string->s, value1->val.string->s, value0->val.string->length))
      return 1;
    break;

  case VALUE_TYPE_FLOAT:
    if (value0->val.floating != value1->val.floating)
      return 1;
    break;

  case VALUE_TYPE_ARRAY:
    if ((value0->val.array.a != value1->val.array.a) ||
 (value0->val.array.offset != value1->val.array.offset))
      return 1;
    break;
  case VALUE_TYPE_AREA:
    if (value0->val.area != value1->val.area)
      return 1;
    break;
  case VALUE_TYPE_POINTER:
    if ((value0->val.pointer.point != value1->val.pointer.point) ||
 (value0->val.pointer.offset != value1->val.pointer.offset))
      return 1;
    break;
  case VALUE_TYPE_FUNCTION:
    if (value0->val.function != value1->val.function)
      return 1;
    break;
  case VALUE_TYPE_LABEL:
    if (value0->val.label != value1->val.label)
      return 1;
    break;
  case VALUE_TYPE_UNDEFINED:
    break;
  default:
    return NLL_ERRCODE_VALUE_INVALID_TYPE;
  }

  return 0;
}

int value_cmp_values(value_t value0, value_t value1)
{
  int r;

  for (; value0 || value1; value0 = value0->next, value1 = value1->next) {
    if (!value0 || !value1)
      return 1;
    if ((r = value_cmp_value(value0, value1)) != 0)
      return r;
  }

  return 0;
}

int value_copy_value(value_t dvalue, value_t svalue)
{
  int r;
  value_t value;

  value = value_entity(svalue);
  if (!value)
    return 0;


  svalue->refcount++;

  switch (value->type) {
  case VALUE_TYPE_NULL:
    if ((r = value_set_null(dvalue)) < 0)
      goto ret;
    break;
  case VALUE_TYPE_VECTOR:
    if (value_get_type(dvalue) != VALUE_TYPE_VECTOR) {
      if ((r = value_set_vector(dvalue, ((void *)0))) < 0)
 goto ret;
    }
    dvalue = value_entity(dvalue);
    if ((r = value_copy_values(&dvalue->val.value, value->val.value)) < 0)
      goto ret;
    break;
  case VALUE_TYPE_INTEGER:
    if ((r = value_set_integer(dvalue, value->val.integer)) < 0)
      goto ret;
    break;
  case VALUE_TYPE_STRING:
    if (value->val.string) {
      if ((r = value_set_string(dvalue, value->val.string->s, value->val.string->length)) < 0)
 goto ret;
    } else {
      if ((r = value_set_string(dvalue, ((void *)0), -1)) < 0)
 goto ret;
    }
    break;

  case VALUE_TYPE_FLOAT:
    if ((r = value_set_float(dvalue, value->val.floating)) < 0)
      goto ret;
    break;

  case VALUE_TYPE_ARRAY:
    if ((r = value_set_array(dvalue, value->val.array.a, value->val.array.offset)) < 0)
      goto ret;
    break;
  case VALUE_TYPE_AREA:
    if ((r = value_set_area(dvalue, value->val.area)) < 0)
      goto ret;
    break;
  case VALUE_TYPE_POINTER:
    if ((r = value_set_pointer(dvalue, value->val.pointer.point, value->val.pointer.offset)) < 0)
      goto ret;
    break;
  case VALUE_TYPE_FUNCTION:
    if ((r = value_set_function(dvalue, value->val.function)) < 0)
      goto ret;
    break;
  case VALUE_TYPE_LABEL:
    if ((r = value_set_label(dvalue, value->val.label)) < 0)
      goto ret;
    break;
  case VALUE_TYPE_UNDEFINED:
    break;
  default:
    r = NLL_ERRCODE_VALUE_INVALID_TYPE;
    goto ret;
  }

  r = 0;

ret:

  value_free(svalue);

  return r;
}

int value_copy_values(value_t *dvaluep, value_t svalue)
{
  int r;

  for (; svalue; svalue = svalue->next) {
    if ((r = value_extend_value(dvaluep)) < 0)
      return r;
    if ((r = value_copy_value(*dvaluep, svalue)) < 0)
      return r;
    dvaluep = &(*dvaluep)->next;
  }

  if ((r = value_shrink_value(dvaluep)) < 0)
    return r;

  return 0;
}

int value_copy_values_novector(value_t *dvaluep, value_t svalue)
{
  int r;

  for (; svalue; svalue = svalue->next) {
    if ((r = value_extend_value(dvaluep)) < 0)
      return r;
    if (value_get_type(svalue) == VALUE_TYPE_VECTOR) {
      if ((r = value_set_vector(*dvaluep, ((void *)0))) < 0)
 return r;
    } else {
      if ((r = value_copy_value(*dvaluep, svalue)) < 0)
 return r;
    }
    dvaluep = &(*dvaluep)->next;
  }

  if ((r = value_shrink_value(dvaluep)) < 0)
    return r;

  return 0;
}

value_type_t value_get_type(value_t value)
{
  value = value_entity(value);
  if (!value)
    return VALUE_TYPE_UNDEFINED;
  return value->type;
}

unsigned int value_get_flags(value_t value)
{
  value = value_entity(value);
  return value->flags;
}

int value_set_flags(value_t value, unsigned int flags)
{
  value = value_entity(value);
  value->flags |= flags;
  return 0;
}

int value_reset_flags(value_t value, unsigned int flags)
{
  value = value_entity(value);
  value->flags &= ~flags;
  return 0;
}

int value_size(value_t value)
{
  int n = 0;

  value = value_entity(value);
  if (!value)
    return 0;

  switch (value->type) {
  case VALUE_TYPE_INTEGER:

  case VALUE_TYPE_FLOAT:

    n = 1;
    break;
  case VALUE_TYPE_VECTOR:
    for (value = value->val.value; value; value = value->next)
      n++;
    break;
  case VALUE_TYPE_STRING:
    if (value->val.string)
      n = value->val.string->length;
    break;
  case VALUE_TYPE_ARRAY:
    if (value->val.array.a)
      n = array_get_number(value->val.array.a) - value->val.array.offset;
    break;
  case VALUE_TYPE_AREA:
    if (value->val.area)
      n = area_get_size(value->val.area);
    break;
  case VALUE_TYPE_POINTER:
    if (value->val.pointer.point)
      n = 1;
    break;
  case VALUE_TYPE_FUNCTION:
    if (value->val.function)
      n = 1;
    break;
  case VALUE_TYPE_LABEL:
    if (value->val.label)
      n = 1;
    break;
  case VALUE_TYPE_UNDEFINED:
  case VALUE_TYPE_NULL:
  default:
    break;
  }

  return n;
}

int value_is_same(value_t value0, value_t value1)
{
  value0 = value_entity(value0);
  value1 = value_entity(value1);
  return (value0 && (value0 == value1)) ? 1 : 0;
}

int value_chain_to_vector(value_t *valuep)
{
  value_t value;
  int r;

  if ((*valuep)->type == VALUE_TYPE_VECTOR)
    return 0;

  if ((*valuep)->type == VALUE_TYPE_UNDEFINED) {
    if ((r = value_set_vector(*valuep, ((void *)0))) < 0)
      return r;
    return 0;
  }

  if ((r = value_alloc(&value)) < 0)
    return r;
  if ((r = value_set_vector(value, ((void *)0))) < 0)
    return r;
  value->val.value = *valuep;
  *valuep = value;

  return 0;
}

int value_vector_to_chain(value_t *valuep)
{
  value_t value;
  int r;

  if ((*valuep)->type != VALUE_TYPE_VECTOR)
    return 0;

  if ((*valuep)->val.value == ((void *)0)) {
    if ((r = value_clear(*valuep)) < 0)
      return r;
    return 0;
  }

  value = *valuep;
  *valuep = (*valuep)->val.value;
  value->val.value = ((void *)0);

  if ((r = value_free(value)) < 0)
    return r;

  return 0;
}

int value_value_to_vector(value_t value)
{
  value_t _value;

  if (value->type == VALUE_TYPE_VALUE) {
    _value = value->val.value;
    value->type = VALUE_TYPE_VECTOR;
    value->val.value = _value;
  }

  return 0;
}

int value_vector_to_value(value_t value)
{
  value_t _value;

  if (value->type == VALUE_TYPE_VECTOR) {
    _value = value->val.value;
    value->type = VALUE_TYPE_VALUE;
    value->val.value = _value;
  }

  return 0;
}

int value_set_next(value_t value, value_t _value)
{
  int r;

  if (_value)
    _value->refcount++;

  if (value->next) {
    if ((r = value_free(value->next)) < 0)
      return r;
  }

  value->next = _value;

  return 0;
}

int value_set_null(value_t value)
{
  int r;

  value = value_entity(value);
  if (!value)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (value->flags & (1 << 0))
    return NLL_ERRCODE_VALUE_CONST_VALUE;

  if (value->flags & (1 << 1))
    return 0;

  if ((value->type != VALUE_TYPE_UNDEFINED) &&
      (value->type != VALUE_TYPE_NULL)) {
    if (value->flags & (1 << 2))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    if ((r = value_clear(value)) < 0)
      return r;



  }

  value->type = VALUE_TYPE_NULL;

  return 0;
}

int value_get_value(value_t value, value_t *valuep)
{
  if (value->type != VALUE_TYPE_VALUE)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (valuep)
    *valuep = value->val.value;

  return 0;
}

int value_set_value(value_t value, value_t _value)
{
  int r;

  if (value->flags & (1 << 0))
    return NLL_ERRCODE_VALUE_CONST_VALUE;

  if (value->flags & (1 << 1))
    return 0;

  if ((value->type != VALUE_TYPE_UNDEFINED) &&
      (value->type != VALUE_TYPE_VALUE)) {
    if (value->flags & (1 << 2))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    if ((r = value_clear(value)) < 0)
      return r;



  }

  _value->refcount++;

  if (value->type == VALUE_TYPE_VALUE) {
    if ((r = value_free(value->val.value)) < 0)
      return r;
  }

  value->type = VALUE_TYPE_VALUE;
  value->val.value = _value;

  return 0;
}

int value_set_values(value_t value, value_t _value)
{
  int r;

  for (; value && _value; value = value->next, _value = _value->next) {
    if ((r = value_set_value(value, _value)) < 0)
      return r;
  }

  return 0;
}

int value_get_vector(value_t value, value_t *valuep)
{
  value = value_entity(value);
  if (!value)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (value->type != VALUE_TYPE_VECTOR)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (valuep)
    *valuep = value->val.value;

  return 0;
}

int value_set_vector(value_t value, value_t _value)
{
  int r;

  value = value_entity(value);
  if (!value)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (value->flags & (1 << 0))
    return NLL_ERRCODE_VALUE_CONST_VALUE;

  if (value->flags & (1 << 1))
    return 0;

  if ((value->type != VALUE_TYPE_UNDEFINED) &&
      (value->type != VALUE_TYPE_VECTOR)) {
    if (value->flags & (1 << 2))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    if ((r = value_clear(value)) < 0)
      return r;



  }

  if (_value)
    _value->refcount++;

  if (value->type == VALUE_TYPE_VECTOR) {
    if (value->val.value) {
      if ((r = value_free(value->val.value)) < 0)
 return r;
    }
  }

  value->type = VALUE_TYPE_VECTOR;
  value->val.value = _value;

  return 0;
}

static int _getval(value_t *valuep)
{
  value_t value;

  value = value_entity(*valuep);
  if (!value)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;
# 1032 "value.c"
  *valuep = value;

  return 0;
}

static int _getval_alloc(value_t *valuep)
{
  value_t value;




  value = value_entity(*valuep);
  if (!value)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;
# 1060 "value.c"
  *valuep = value;

  return 0;
}

int value_get_integer(value_t value, integer_t *integerp)
{
  int r;

  if ((r = _getval(&value)) < 0)
    return r;

  if (value->type != VALUE_TYPE_INTEGER)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (integerp)
    *integerp = value->val.integer;

  return 0;
}

int value_set_integer(value_t value, integer_t integer)
{
  int r;

  if ((r = _getval_alloc(&value)) < 0)
    return r;

  if (value->flags & (1 << 0))
    return NLL_ERRCODE_VALUE_CONST_VALUE;

  if (value->flags & (1 << 1))
    return 0;

  if ((value->type != VALUE_TYPE_UNDEFINED) &&
      (value->type != VALUE_TYPE_INTEGER)) {
    if (value->flags & (1 << 2))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    if ((r = value_clear(value)) < 0)
      return r;



  }

  value->type = VALUE_TYPE_INTEGER;
  value->val.integer = integer;

  return 0;
}

int value_get_string(value_t value, char **stringp, int *lengthp)
{
  int r;

  if ((r = _getval(&value)) < 0)
    return r;

  if (value->type != VALUE_TYPE_STRING)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (stringp)
    *stringp = value->val.string ? value->val.string->s : ((void *)0);
  if (lengthp)
    *lengthp = value->val.string ? value->val.string->length : -1;

  return 0;
}

int value_set_string(value_t value, const char *string, int length)
{
  int r;

  if ((r = _getval_alloc(&value)) < 0)
    return r;

  if (value->flags & (1 << 0))
    return NLL_ERRCODE_VALUE_CONST_VALUE;

  if (value->flags & (1 << 1))
    return 0;

  if ((value->type != VALUE_TYPE_UNDEFINED) &&
      (value->type != VALUE_TYPE_STRING)) {
    if (value->flags & (1 << 2))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    if ((r = value_clear(value)) < 0)
      return r;



  }

  if (!string) {
    if ((value->type == VALUE_TYPE_STRING) && value->val.string) {
      if ((r = string_del(value->val.string)) < 0)
 return r;
    }
    value->type = VALUE_TYPE_STRING;
    value->val.string = ((void *)0);
  } else {
    if (length > 65536)
      return NLL_ERRCODE_STRING_TOO_LONG;

    if ((value->type == VALUE_TYPE_UNDEFINED) ||
 ((value->type == VALUE_TYPE_STRING) && !value->val.string)) {
      if ((r = string_alloc(&value->val.string)) < 0)
 return r;
    }

    value->type = VALUE_TYPE_STRING;
    if ((r = string_set(value->val.string, string, length)) < 0)
      return 0;
  }

  return 0;
}


int value_get_float(value_t value, double *floatingp)
{
  int r;

  if ((r = _getval(&value)) < 0)
    return r;

  if (value->type != VALUE_TYPE_FLOAT)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (floatingp)
    *floatingp = value->val.floating;

  return 0;
}

int value_set_float(value_t value, double floating)
{
  int r;

  if ((r = _getval_alloc(&value)) < 0)
    return r;

  if (value->flags & (1 << 0))
    return NLL_ERRCODE_VALUE_CONST_VALUE;

  if (value->flags & (1 << 1))
    return 0;

  if ((value->type != VALUE_TYPE_UNDEFINED) &&
      (value->type != VALUE_TYPE_FLOAT)) {
    if (value->flags & (1 << 2))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    if ((r = value_clear(value)) < 0)
      return r;



  }

  value->type = VALUE_TYPE_FLOAT;
  value->val.floating = floating;

  return 0;
}


int value_get_array(value_t value, array_t *arrayp, int *offsetp)
{
  int r;

  if ((r = _getval(&value)) < 0)
    return r;

  if (value->type != VALUE_TYPE_ARRAY)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (arrayp)
    *arrayp = value->val.array.a;
  if (offsetp)
    *offsetp = value->val.array.offset;

  return 0;
}

int value_set_array(value_t value, array_t array, int offset)
{
  int r;

  if ((r = _getval_alloc(&value)) < 0)
    return r;

  if (value->flags & (1 << 0))
    return NLL_ERRCODE_VALUE_CONST_VALUE;

  if (value->flags & (1 << 1))
    return 0;

  if ((value->type != VALUE_TYPE_UNDEFINED) &&
      (value->type != VALUE_TYPE_ARRAY)) {
    if (value->flags & (1 << 2))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    if ((r = value_clear(value)) < 0)
      return r;



  }

  if (array)
    array[0].value->refcount++;

  if (value->type == VALUE_TYPE_ARRAY) {
    if (value->val.array.a) {
      if ((r = array_free(value->val.array.a, -1)) < 0)
 return r;
    }
  }

  value->type = VALUE_TYPE_ARRAY;
  value->val.array.a = array;
  value->val.array.offset = array ? offset : 0;

  return 0;
}

int value_get_area(value_t value, area_t *areap)
{
  int r;

  if ((r = _getval(&value)) < 0)
    return r;

  if (value->type != VALUE_TYPE_AREA)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (areap)
    *areap = value->val.area;

  return 0;
}

int value_set_area(value_t value, area_t area)
{
  int r;

  if ((r = _getval_alloc(&value)) < 0)
    return r;

  if (value->flags & (1 << 0))
    return NLL_ERRCODE_VALUE_CONST_VALUE;

  if (value->flags & (1 << 1))
    return 0;

  if ((value->type != VALUE_TYPE_UNDEFINED) &&
      (value->type != VALUE_TYPE_AREA)) {
    if (value->flags & (1 << 2))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    if ((r = value_clear(value)) < 0)
      return r;



  }

  if (area)
    area->refcount++;

  if (value->type == VALUE_TYPE_AREA) {
    if (value->val.area) {
      if ((r = area_free(value->val.area)) < 0)
 return r;
    }
  }

  value->type = VALUE_TYPE_AREA;
  value->val.area = area;

  return 0;
}

int value_get_pointer(value_t value, value_t *pointp, int *offsetp)
{
  int r;

  if ((r = _getval(&value)) < 0)
    return r;

  if (value->type != VALUE_TYPE_POINTER)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (pointp)
    *pointp = value->val.pointer.point;
  if (offsetp)
    *offsetp = value->val.pointer.offset;

  return 0;
}

int value_set_pointer(value_t value, value_t point, int offset)
{
  int r;

  if ((r = _getval_alloc(&value)) < 0)
    return r;

  if (value->flags & (1 << 0))
    return NLL_ERRCODE_VALUE_CONST_VALUE;

  if (value->flags & (1 << 1))
    return 0;

  if ((value->type != VALUE_TYPE_UNDEFINED) &&
      (value->type != VALUE_TYPE_POINTER)) {
    if (value->flags & (1 << 2))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    if ((r = value_clear(value)) < 0)
      return r;



  }

  if (point)
    point->refcount++;

  if (value->type == VALUE_TYPE_POINTER) {
    if (value->val.pointer.point) {
      if ((r = value_free(value->val.pointer.point)) < 0)
 return r;
    }
  }

  value->type = VALUE_TYPE_POINTER;
  value->val.pointer.point = point;
  value->val.pointer.offset = point ? offset : 0;

  return 0;
}

int value_get_function(value_t value, function_t *functionp)
{
  int r;

  if ((r = _getval(&value)) < 0)
    return r;

  if (value->type != VALUE_TYPE_FUNCTION)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (functionp)
    *functionp = value->val.function;

  return 0;
}

int value_set_function(value_t value, function_t function)
{
  int r;

  if ((r = _getval_alloc(&value)) < 0)
    return r;

  if (value->flags & (1 << 0))
    return NLL_ERRCODE_VALUE_CONST_VALUE;

  if (value->flags & (1 << 1))
    return 0;

  if ((value->type != VALUE_TYPE_UNDEFINED) &&
      (value->type != VALUE_TYPE_FUNCTION)) {
    if (value->flags & (1 << 2))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    if ((r = value_clear(value)) < 0)
      return r;



  }

  value->type = VALUE_TYPE_FUNCTION;
  value->val.function = function;

  return 0;
}

int value_get_label(value_t value, label_t *labelp)
{
  int r;

  if ((r = _getval(&value)) < 0)
    return r;

  if (value->type != VALUE_TYPE_LABEL)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (labelp)
    *labelp = value->val.label;

  return 0;
}

int value_set_label(value_t value, label_t label)
{
  int r;

  if ((r = _getval_alloc(&value)) < 0)
    return r;

  if (value->flags & (1 << 0))
    return NLL_ERRCODE_VALUE_CONST_VALUE;

  if (value->flags & (1 << 1))
    return 0;

  if ((value->type != VALUE_TYPE_UNDEFINED) &&
      (value->type != VALUE_TYPE_LABEL)) {
    if (value->flags & (1 << 2))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    if ((r = value_clear(value)) < 0)
      return r;



  }

  if (label)
    label->refcount++;

  if (value->type == VALUE_TYPE_LABEL) {
    if (value->val.label) {
      if ((r = label_del(value->val.label)) < 0)
 return r;
    }
  }

  value->type = VALUE_TYPE_LABEL;
  value->val.label = label;

  return 0;
}

int value_get_integer_float(value_t value, integer_t *integerp)
{
  int r;

  double f;


  if ((r = value_get_integer(value, integerp)) < 0) {

    if ((r = value_get_float(value, &f)) < 0)
      return r;
    if (integerp)
      *integerp = f;



  }

  return 0;
}


int value_get_float_integer(value_t value, double *floatingp)
{
  int r;
  integer_t integer;

  if ((r = value_get_float(value, floatingp)) < 0) {
    if ((r = value_get_integer(value, &integer)) < 0)
      return r;
    if (floatingp)
      *floatingp = integer;
  }

  return 0;
}


static int _puts(FILE *fp, const char *str)
{
  if (fp) {
    nll_wait_output(fp);
    fputs(str, fp);
  } else {

    framebuf_puts(str);



  }
  return 0;
}

static int output_values(FILE *fp, value_t value, const char *separator, int procid);

static int output_value(FILE *fp, value_t value, int procid)
{
  char buf[32];
  int i, n;
  char *p, c;
  value_t v;

  value = value_entity(value);
  if (!value)
    return 0;


  if (value->procid == procid) {
    _puts(fp, "...");
    goto ret;
  }
  value->procid = procid;

  switch (value->type) {
  case VALUE_TYPE_NULL:
    _puts(fp, "NULL");
    break;
  case VALUE_TYPE_VECTOR:
    _puts(fp, "(");
    output_values(fp, value->val.value, ",", procid);
    _puts(fp, ")");
    break;
  case VALUE_TYPE_INTEGER:
    sprintf(buf, "%ld", value->val.integer);
    _puts(fp, buf);
    break;
  case VALUE_TYPE_STRING:
    if (value->val.string) {
      _puts(fp, value->val.string->s);
    } else {
      _puts(fp, "NULLSTR");
    }
    break;

  case VALUE_TYPE_FLOAT:
    sprintf(buf, "%f", value->val.floating);
    _puts(fp, buf);
    break;

  case VALUE_TYPE_ARRAY:
    if (value->val.array.a) {
      _puts(fp, "[");
      n = array_get_number(value->val.array.a) - value->val.array.offset;
      for (i = 0; i < n; i++) {
 if (i > 0)
   _puts(fp, ",");
 if (array_get_value(value->val.array.a, value->val.array.offset + i, &v) < 0)
   continue;
 output_value(fp, v, procid);
      }
      _puts(fp, "]");
    } else {
      _puts(fp, "NULLARRAY");
    }
    break;
  case VALUE_TYPE_AREA:
    if (value->val.area) {
      n = area_get_size(value->val.area);
      p = area_get_buffer(value->val.area);
      for (i = 0; i < n; i++) {
 c = p[i];
 c = isprint(c) ? c : '.';
 sprintf(buf, "%c", c);
 _puts(fp, buf);
      }
    } else {
      _puts(fp, "NULLMEM");
    }
    break;
  case VALUE_TYPE_POINTER:
    if (value->val.pointer.point) {
      _puts(fp, "&");
      output_value(fp, value->val.pointer.point, procid);
    } else {
      _puts(fp, "NULLPTR");
    }
    break;
  case VALUE_TYPE_FUNCTION:
    if (value->val.function) {
      _puts(fp, value->val.function->name);
    } else {
      _puts(fp, "NULLFUNC");
    }
    break;
  case VALUE_TYPE_LABEL:
    if (value->val.label) {
      _puts(fp, value->val.label->name);
    } else {
      _puts(fp, "NULLLABEL");
    }
    break;
  case VALUE_TYPE_UNDEFINED:
  default:
    break;
  }

ret:
  if (fp)
    fflush(fp);

  return 0;
}

static int output_values(FILE *fp, value_t value, const char *separator, int procid)
{
  int printed = 0;

  if (!separator) separator = "";

  for (; value; value = value->next) {
    if (printed)
      _puts(fp, separator);
    output_value(fp, value, procid);
    printed = 1;
  }

  if (fp)
    fflush(fp);

  return 0;
}

int value_output_value(FILE *fp, value_t value)
{
  return output_value(fp, value, procid_set());
}

int value_output_values(FILE *fp, value_t value, const char *separator)
{
  return output_values(fp, value, separator, procid_set());
}

static int dump(FILE *fp, value_t value, int procid);

static int dump_value(FILE *fp, value_t value, int procid)
{
  nll_wait_output(fp);


  if (value->procid == procid) {
    fprintf(fp, "...");
    goto ret;
  }
  value->procid = procid;
# 1724 "value.c"
  switch (value->type) {
  case VALUE_TYPE_UNDEFINED:
    fprintf(fp, "UNDEF");
    break;
  case VALUE_TYPE_NULL:
    fprintf(fp, "NULL");
    break;
  case VALUE_TYPE_VALUE:
    fprintf(fp, "{");
    dump(fp, value->val.value, procid);
    fprintf(fp, "}");
    break;
  case VALUE_TYPE_VECTOR:
    fprintf(fp, "(");
    dump(fp, value->val.value, procid);
    fprintf(fp, ")");
    break;
  case VALUE_TYPE_INTEGER:
    fprintf(fp, "%ld", value->val.integer);
    break;
  case VALUE_TYPE_STRING:
    if (value->val.string) {
      string_dump_string(fp, value->val.string);
    } else {
      fprintf(fp, "NULLSTR");
    }
    break;

  case VALUE_TYPE_FLOAT:
    fprintf(fp, "%f(FLOAT)", value->val.floating);
    break;

  case VALUE_TYPE_ARRAY:
    if (value->val.array.a) {
      fprintf(fp, "ARRAY");
      array_dump(fp, value->val.array.a);
    } else {
      fprintf(fp, "NULLARRAY");
    }
    break;
  case VALUE_TYPE_AREA:
    if (value->val.area) {
      fprintf(fp, "AREA");
      area_dump(fp, value->val.area);
    } else {
      fprintf(fp, "NULLMEM");
    }
    break;
  case VALUE_TYPE_POINTER:
    if (value->val.pointer.point) {
      fprintf(fp, "&");
      dump(fp, value->val.pointer.point, procid);
      fprintf(fp, "[%d]", value->val.pointer.offset);
    } else {
      fprintf(fp, "NULLPTR");
    }
    break;
  case VALUE_TYPE_FUNCTION:
    if (value->val.function) {
      fprintf(fp, "%s(FUNC)", value->val.function->name);
    } else {
      fprintf(fp, "NULLFUNC");
    }
    break;
  case VALUE_TYPE_LABEL:
    if (value->val.label) {
      fprintf(fp, "%s(LABEL)", value->val.label->name);
    } else {
      fprintf(fp, "NULLLABEL");
    }
    break;
  default:
    fprintf(fp, "ERROR");
    break;
  }

ret:
  fflush(fp);

  return 0;
}

static int dump(FILE *fp, value_t value, int procid)
{
  value_t v = ((void *)0);

  for (v = value; value; value = value->next) {
    nll_wait_output(fp);
    if (v != value)
      fprintf(fp, ",");
    dump_value(fp, value, procid);
  }

  fflush(fp);

  return 0;
}

int value_dump_value(FILE *fp, value_t value)
{
  return dump_value(fp, value, procid_set());
}

int value_dump(FILE *fp, value_t value)
{
  return dump(fp, value, procid_set());
}
