# 0 "queueid.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "queueid.c"
# 1 "config.h" 1
# 2 "queueid.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "queueid.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "queueid.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "queueid.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 9 "queueid.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 12 "queueid.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 13 "queueid.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 14 "queueid.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 15 "queueid.c" 2
# 1 "queueid.h" 1



typedef int queueid_index_t;

int queueid_init(void);
int queueid_done(void);
int queueid_check(void);

int queueid_number(queueid_index_t index);
int queueid_headin(queueid_index_t index, value_t value);
int queueid_tailin(queueid_index_t index, value_t value);
int queueid_headout(queueid_index_t index, value_t value);
int queueid_tailout(queueid_index_t index, value_t value);

int queueid_destroy(queueid_index_t index);
queueid_index_t queueid_create(void);
# 16 "queueid.c" 2

struct qentry {
  struct qentry *next;
  struct qentry *prev;
  value_t value;
};

typedef struct queueid {
  queueid_index_t index;
  struct qentry entry;
  int num;
} *queueid_t;

static queueid_t queueids[64];
static int queueid_num = 0;

static struct qentry *pool = ((void *)0);

int queueid_init(void)
{
  queueid_num = 0;
  memset(queueids, 0, sizeof(queueids));
  return 0;
}

int queueid_done(void)
{
  queueid_index_t index;
  struct qentry *entry;

  for (index = 0; index < 64; index++) {
    if (queueids[index])
      queueid_destroy(index);
  }

  while (pool) {
    entry = pool;
    pool = pool->next;
    memory_free(entry);
  }

  return 0;
}

int queueid_check(void)
{
  queueid_index_t index;

  if (queueid_num)
    return NLL_ERRCODE_MEMORY_NOT_EMPTY;

  for (index = 0; index < 64; index++) {
    if (queueids[index])
      return NLL_ERRCODE_MEMORY_NOT_EMPTY;
  }

  if (pool)
    return NLL_ERRCODE_MEMORY_NOT_EMPTY;

  return 0;
}

static queueid_t _alloc(void)
{
  queueid_t queueid;
  if ((queueid = memory_alloc(sizeof(*queueid))) == ((void *)0))
    return ((void *)0);
  return queueid;
}

static int _free(queueid_t queueid)
{
  memory_free(queueid);
  return 0;
}

static queueid_t queueid_get(queueid_index_t index)
{
  if ((index < 0) || (index >= 64))
    return ((void *)0);

  return queueids[index];
}

static int queueid_is_empty(queueid_t queueid)
{
  return (queueid->entry.next == &queueid->entry) ? 1 : 0;
}

static int qentry_free(struct qentry *entry)
{
  if (entry->value)
    value_free(entry->value);
  entry->next = pool;
  pool = entry;
  return 0;
}

static struct qentry *qentry_alloc(value_t value)
{
  struct qentry *entry;

  if (pool) {
    entry = pool;
    pool = pool->next;
  } else {
    if ((entry = memory_alloc(sizeof(*entry))) == ((void *)0))
      goto err;
  }
  memset(entry, 0, sizeof(*entry));

  if (value_alloc(&entry->value) < 0)
    goto err;

  if (value_copy_value(entry->value, value) < 0)
    goto err;

  return entry;

err:
  if (entry)
    qentry_free(entry);
  return ((void *)0);
}

int queueid_number(queueid_index_t index)
{
  queueid_t queueid;

  queueid = queueid_get(index);
  if (!queueid)
    return -1;

  return queueid->num;
}

static int qentry_insert_next(struct qentry *prev, value_t value)
{
  struct qentry *entry;

  if ((entry = qentry_alloc(value)) == ((void *)0))
    return -1;

  prev->next->prev = entry;
  entry->next = prev->next;
  prev->next = entry;
  entry->prev = prev;

  return 0;
}

static int qentry_delete(struct qentry *entry, value_t value)
{
  if (value) {
    if (value_copy_value(value, entry->value) < 0)
      return -1;
  }

  entry->next->prev = entry->prev;
  entry->prev->next = entry->next;

  qentry_free(entry);

  return 0;
}

int queueid_headin(queueid_index_t index, value_t value)
{
  queueid_t queueid;

  queueid = queueid_get(index);
  if (!queueid)
    return -1;

  if (qentry_insert_next(&queueid->entry, value) < 0)
    return -1;
  queueid->num++;

  return 0;
}

int queueid_tailin(queueid_index_t index, value_t value)
{
  queueid_t queueid;

  queueid = queueid_get(index);
  if (!queueid)
    return -1;

  if (qentry_insert_next(queueid->entry.prev, value) < 0)
    return -1;
  queueid->num++;

  return 0;
}

int queueid_headout(queueid_index_t index, value_t value)
{
  queueid_t queueid;

  queueid = queueid_get(index);
  if (!queueid)
    return -1;

  if (queueid_is_empty(queueid)) {
    if (value_set_null(value) < 0)
      return -1;
  } else {
    if (qentry_delete(queueid->entry.next, value) < 0)
      return -1;
    queueid->num--;
  }

  return 0;
}

int queueid_tailout(queueid_index_t index, value_t value)
{
  queueid_t queueid;

  queueid = queueid_get(index);
  if (!queueid)
    return -1;

  if (queueid_is_empty(queueid)) {
    if (value_set_null(value) < 0)
      return -1;
  } else {
    if (qentry_delete(queueid->entry.prev, value) < 0)
      return -1;
    queueid->num--;
  }

  return 0;
}

static int queueid_entry_init(queueid_t queueid)
{
  queueid->entry.next = &queueid->entry;
  queueid->entry.prev = &queueid->entry;
  queueid->num = 0;
  return 0;
}

static int queueid_entry_done(queueid_t queueid)
{
  while (!queueid_is_empty(queueid)) {
    if (qentry_delete(queueid->entry.next, ((void *)0)) < 0)
      return -1;
    queueid->num--;
  }
  return 0;
}

int queueid_destroy(queueid_index_t index)
{
  queueid_t queueid;
  int r;

  queueid = queueid_get(index);
  if (!queueid)
    return -1;

  queueids[queueid->index] = ((void *)0);

  if (queueid_entry_done(queueid) < 0)
    return -1;
  memset(queueid, 0, sizeof(*queueid));

  queueid_num--;
  if ((r = _free(queueid)) < 0)
    return r;

  return 0;
}

queueid_index_t queueid_create(void)
{
  queueid_index_t index;
  queueid_t queueid = ((void *)0);

  for (index = 0; index < 64; index++) {
    if (!queueids[index])
      break;
  }
  if (index == 64)
    return -1;

  if ((queueid = _alloc()) == ((void *)0))
    return -1;
  queueid_num++;

  memset(queueid, 0, sizeof(*queueid));
  queueid->index = index;
  if (queueid_entry_init(queueid) < 0)
    return -1;

  queueids[index] = queueid;

  return queueid->index;
}
