# 0 "picture.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "picture.c"
# 1 "config.h" 1
# 2 "picture.c" 2


# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 5 "picture.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 6 "picture.c" 2
# 1 "../include/stdint.h" 1
# 7 "picture.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 8 "picture.c" 2



# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 12 "picture.c" 2


# 1 "const.h" 1
# 15 "picture.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 16 "picture.c" 2
# 1 "image.h" 1



typedef unsigned int image_draw_count_t;

typedef enum {
  IMAGE_TYPE_NONE = -1,


  IMAGE_TYPE_FULLCOLOR = 0,
  IMAGE_TYPE_MONOCOLOR,
  IMAGE_TYPE_MONOBCOLOR,
  IMAGE_TYPE_ROUGHCOLOR,
  IMAGE_TYPE_GRAYCOLOR,
  IMAGE_TYPE_HALFCOLOR,
} image_type_t;

typedef enum {
  IMAGE_STATUS_NONE = 0,
  IMAGE_STATUS_ACTIVE,
  IMAGE_STATUS_FREE,
} image_status_t;

typedef struct image *image_t;

struct image_procs {
  int bytesize;
  int (*index)(image_t image, int width, int x, int y, int *indexp, int *offsetp);
  int (*get_color)(image_t image, int x, int y);
  int (*set_color)(image_t image, int x, int y, int color, unsigned int flags);
  int (*copy_get_color)(image_t image, int x, int y);
  int (*copy_save)(image_t image, int x, int y, int width, int height);
  int (*copy_save_color)(image_t image, int x, int y);
};

union image_bitmap {
  void *p;
  int *word;
  unsigned char *byte;
  unsigned short *half;
};

struct image {
  int index;
  int width;
  int height;
  int size;
  image_type_t type;
  unsigned int flags;
  struct {
    int fg;
    int bg;
    int from;
    int to;
  } color;
  struct {
    int x;
    int y;
    int width;
    int height;
    int mulx;
    int muly;
  } range;
  struct {
    int x;
    int y;
  } offset;
  struct {
    struct {
      int x;
      int y;
    } mul;
    struct {
      int x;
      int y;
    } div;
  } scale;
  struct {
    int x;
    int y;
    int width;
    int height;
  } dot;
  struct {
    int x;
    int y;
    int color;
  } current;
  union image_bitmap bitmap;
  volatile image_status_t status;
  struct image_draw {
    image_draw_count_t count;
    image_draw_count_t *line;
    int column_per;
    int column_num;
    image_draw_count_t *column;
    image_draw_count_t *pixel;
  } draw;
  struct image_copy {
    union image_bitmap bitmap;
  } copy;
  struct image_procs *procs;
};

int image_init(void);
int image_done(void);
int image_check(void);
int image_is_draw_line(image_t image, image_draw_count_t count, int y);
int image_is_draw_column(image_t image, image_draw_count_t count, int x, int y);
int image_is_draw_pixel(image_t image, image_draw_count_t count, int x, int y);
int image_set_draw_line(image_t image, image_draw_count_t count, int y);
int image_set_draw_column(image_t image, image_draw_count_t count, int x, int y);
int image_set_draw_pixel(image_t image, image_draw_count_t count, int x, int y);
int image_get_color(image_t image, int x, int y);
int image_set_color(image_t image, int x, int y, int color, unsigned int flags);
int image_copy_save(image_t image, int x, int y, int width, int height);
int image_copy_get_color(image_t image, int x, int y);
int image_copy_save_color(image_t image, int x, int y);
int image_get_index(image_t image);
image_t image_get_image(int index);
int image_reset_draw(image_t image);
int image_destroy(image_t image);
int image_create(image_t image, int width, int height, void *bitmap,
   image_type_t type, unsigned int flags);
image_t image_get(int width, int height, void *bitmap,
    image_type_t type, unsigned int flags);
# 17 "picture.c" 2
# 1 "picture.h" 1



image_t picture_load(char *filename, unsigned int flags);
int picture_save(char *filename, image_t image,
   int x, int y, int width, int height, unsigned int flags);
# 18 "picture.c" 2

struct bmp_magic_header {
  uint8_t type[2];
};




struct bmp_file_header {
  uint32_t size;
  uint16_t reserve[2];
  uint32_t offset;
};




struct bmp_info_header {
  uint32_t ihdrsize;
  uint32_t width;
  uint32_t height;
  uint16_t planes;
  uint16_t bits;
  uint32_t compress;
  uint32_t imagesize;
  uint32_t xpix;
  uint32_t ypix;
  uint32_t colors;
  uint32_t impcolors;
};
# 63 "picture.c"
union evalue {
  uint8_t b[4];
  uint16_t h[2];
  uint32_t w[1];
};

static uint16_t read_le16(uint16_t val)
{
  union evalue e;
  e.h[0] = val;
  return (e.b[1] << 8) | e.b[0];
}

static uint32_t read_le32(uint32_t val)
{
  union evalue e;
  e.w[0] = val;
  return (e.b[3] << 24) | (e.b[2] << 16) | (e.b[1] << 8) | e.b[0];
}

static uint16_t write_le16(uint16_t val)
{
  union evalue e;
  e.b[0] = val & 0xff;
  e.b[1] = (val >> 8) & 0xff;
  return e.h[0];
}

static uint32_t write_le32(uint32_t val)
{
  union evalue e;
  e.b[0] = val & 0xff;
  e.b[1] = (val >> 8) & 0xff;
  e.b[2] = (val >> 16) & 0xff;
  e.b[3] = (val >> 24) & 0xff;
  return e.w[0];
}

struct bitfield {
  unsigned int mask;
  int shiftbits;
  int maskbits;
};

static int bitfield_calc(struct bitfield *bfd, unsigned int mask)
{
  if (!mask)
    return -1;

  bfd->mask = mask;
  bfd->shiftbits = 0;
  bfd->maskbits = 0;

  while (!(mask & 1)) {
    bfd->shiftbits++;
    mask >>= 1;
  }

  while (mask) {
    bfd->maskbits++;
    mask >>= 1;
  }

  return 0;
}

static int bitfield_load(int c, struct bitfield *bfd)
{
  unsigned int bgr[3];
  int i, s;

  for (i = 0; i < 3; i++) {
    bgr[i] = (c & bfd[i].mask) >> bfd[i].shiftbits;
    if (bfd[i].maskbits < 8) {
      s = 8 - bfd[i].maskbits;
      bgr[i] = bgr[i] ? ((bgr[i] << s) | ((1 << s) - 1)) : 0;
    } else {
      bgr[i] >>= (bfd[i].maskbits - 8);
    }
  }

  c = 0;
  for (i = 0; i < 3; i++)
    c |= ((bgr[i] & 0xff) << (i * 8));

  return c;
}

static int bitfield_save(int c, struct bitfield *bfd)
{
  unsigned int bgr[3];
  int i, s;

  for (i = 0; i < 3; i++) {
    bgr[i] = (c >> (i * 8)) & 0xff;
    if (bfd[i].maskbits > 8) {
      s = bfd[i].maskbits - 8;
      bgr[i] = bgr[i] ? ((bgr[i] << s) | ((1 << s) - 1)) : 0;
    } else {
      bgr[i] >>= (8 - bfd[i].maskbits);
    }
  }

  c = 0;
  for (i = 0; i < 3; i++)
    c |= ((bgr[i] << bfd[i].shiftbits) & bfd[i].mask);

  return c;
}

static int *palette_load(FILE *fp, int palette_num, int *palette)
{
  int i, s;
  unsigned char bgr[4];
  int c;

  for (i = 0; i < palette_num; i++) {
    s = fread(bgr, 1, sizeof(bgr), fp);
    if (s != sizeof(bgr))
      goto err;
    c = bgr[0];
    c |= (bgr[1] << 8);
    c |= (bgr[2] << 16);
    palette[i] = c;
  }

  return palette;

err:
  return ((void *)0);
}

static int palette_save(FILE *fp, int palette_num, int *palette)
{
  int i, s;
  unsigned char bgr[4];
  int c;

  bgr[3] = 0;

  for (i = 0; i < palette_num; i++) {
    c = palette[i];
    bgr[0] = c & 0xff;
    bgr[1] = (c >> 8) & 0xff;
    bgr[2] = (c >> 16) & 0xff;
    s = fwrite(bgr, 1, sizeof(bgr), fp);
    if (s != sizeof(bgr))
      goto err;
  }

  return i;

err:
  return -1;
}

static int palette_search(int palette_num, int *palette, int c)
{
  int i;

  for (i = 0; i < palette_num; i++) {
    if (palette[i] == c)
      return i;
  }

  return -1;
}

static int palette_make(image_t image, int x, int y, int width, int height,
   int palette_num, int *palette)
{
  int x0, y0, bx, by, c, num = 0;

  x0 = x;
  y0 = y;

  for (y = 0; y < height; y++) {
    for (x = 0; x < width; x++) {
      bx = x0 + x;
      by = y0 + (height - y - 1);
      if ((bx < 0) || (bx > image->width - 1) ||
   (by < 0) || (by > image->height - 1))
 c = 0;
      else {
 c = image_get_color(image, bx, by);
 c = (c < 0) ? 0 : c;
      }
      if (palette_search(num, palette, c) < 0) {
 if (num == palette_num)
   return -1;
 palette[num++] = c;
      }
    }
  }

  return num;
}

static image_t bmp_load(FILE *fp, unsigned int flags, int *palette, struct bitfield *bfd,
   int width, int height, int bits, int imagesize)
{
  int size, bytes, w, h, x, y, i, n, s, c, pad_size;
  image_t image = ((void *)0);
  unsigned char bgr[4], mask;

  w = (width > 4096 ) ? 4096 : width;
  h = (height > 4096) ? 4096 : height;

  if ((w < 1) || (h < 1))
    goto err;

  image = image_get(w, h, ((void *)0), IMAGE_TYPE_NONE, flags);
  if (!image)
    goto err;

  if (bits <= 8) {
    n = 8 / bits;
    bytes = 1;
    mask = (1 << bits) - 1;
    pad_size = 4 - (((width * bits + 7) / 8) % 4);
    pad_size = (pad_size % 4);
  } else {
    n = 1;
    bytes = bits / 8;
    mask = 0xff;
    pad_size = 4 - ((width * bytes) % 4);
    pad_size = (pad_size % 4);
  }

  size = 0;

  image->flags &= ~(1 << 10);

  for (y = 0; y < h; y++) {
    for (x = 0; x < width;) {
      for (i = 0; i < n; i++) {
 if (i == 0) {
   if (imagesize && (size + bytes > imagesize))
     goto err;
   s = fread(bgr, 1, bytes, fp);
   if (s < bytes)
     memset(bgr + s, 0, bytes - s);
   size += bytes;
 }
 if (palette) {
   c = palette[(bgr[0] >> ((n - 1 - i) * bits)) & mask];
 } else {
   c = 0;
   for (i = 0; i < bytes; i++)
     c |= (bgr[i] << (i * 8));
   if (bfd)
     c = bitfield_load(c, bfd);
 }
 if (x < w)
   image_set_color(image, x, h - y - 1, c, (0 << 16));
 x++;
      }
    }
    for (x = 0; x < pad_size; x++) {
      fread(bgr, 1, 1, fp);
      size++;
    }
  }

  image->flags |= ((1 << 10) & flags);

  return image;

err:
  if (image)
    image_destroy(image);
  return ((void *)0);
}

static image_t picture_bmp_load(char *filename, unsigned int flags)
{
  FILE *fp = ((void *)0);
  struct bmp_magic_header mhdr;
  struct bmp_file_header fhdr;
  struct bmp_info_header ihdr;
  unsigned char dummy;
  int offset, i, n, c;
  int palette[256];
  struct bitfield bfd[3], *bfdp = ((void *)0);
  int *p = ((void *)0);
  image_t image = ((void *)0);
  const char *mode;


  mode = "r";




  fp = fopen(filename, mode);
  if (!fp)
    goto err;

  if (fread(&mhdr, 1, 2, fp) != 2)
    goto err;

  offset = 2;

  if ((mhdr.type[0] != 'B') ||
      (mhdr.type[1] != 'M'))
    goto err;

  if (fread(&fhdr, 1, 12, fp) != 12)
    goto err;

  if (fread(&ihdr, 1, 40, fp) != 40)
    goto err;

  fhdr.size = read_le32(fhdr.size);
  fhdr.offset = read_le32(fhdr.offset);

  offset += 12;

  ihdr.ihdrsize = read_le32(ihdr.ihdrsize);
  ihdr.width = read_le32(ihdr.width);
  ihdr.height = read_le32(ihdr.height);
  ihdr.planes = read_le16(ihdr.planes);
  ihdr.bits = read_le16(ihdr.bits);
  ihdr.compress = read_le32(ihdr.compress);
  ihdr.imagesize = read_le32(ihdr.imagesize);
  ihdr.xpix = read_le32(ihdr.xpix);
  ihdr.ypix = read_le32(ihdr.ypix);
  ihdr.colors = read_le32(ihdr.colors);
  ihdr.impcolors = read_le32(ihdr.impcolors);

  if (ihdr.ihdrsize < 40)
    goto err;
  if (ihdr.planes != 1)
    goto err;

  for (n = 0; n < ihdr.ihdrsize - 40; n++) {
    if (fread(&dummy, 1, 1, fp) != 1)
      goto err;
  }

  offset += ihdr.ihdrsize;

  switch (ihdr.bits) {
  case 1:
  case 4:
  case 8:
  case 24:
    if (ihdr.compress != 0)
      goto err;
    break;

  case 16:
  case 32:
    switch (ihdr.compress) {
    case 3:
      if (offset + 3 * sizeof(c) <= fhdr.offset) {
 for (i = 0; i < 3; i++) {
   if (fread(&c, 1, sizeof(c), fp) != sizeof(c))
     goto err;
   c = read_le32(c);
   bitfield_calc(&bfd[2 - i], c);
   offset += sizeof(c);
 }
 break;
      }

    case 0:
      switch (ihdr.bits) {
      case 16:
 bitfield_calc(&bfd[0], 0x001f);
 bitfield_calc(&bfd[1], 0x03e0);
 bitfield_calc(&bfd[2], 0x7c00);
 break;
      case 32:
 bitfield_calc(&bfd[0], 0x000000ff);
 bitfield_calc(&bfd[1], 0x0000ff00);
 bitfield_calc(&bfd[2], 0x00ff0000);
 break;
      default:
 goto err;
      }
      break;
    default:
      goto err;
    }
    bfdp = bfd;
    break;

  default:
    goto err;
  }

  if (ihdr.bits <= 8) {
    n = ihdr.colors ? ihdr.colors : (1 << ihdr.bits);
    if (n > 256)
      goto err;
    memset(palette, 0, sizeof(palette));
    p = palette_load(fp, n, palette);
    if (!p)
      goto err;
    offset += n * sizeof(*p);
  }

  if (fhdr.offset < offset)
    goto err;

  for (offset = fhdr.offset - offset; offset > 0; offset--) {
    if (fread(&dummy, 1, 1, fp) != 1)
      goto err;
  }

  image = bmp_load(fp, flags, p, bfdp, ihdr.width, ihdr.height, ihdr.bits, ihdr.imagesize);
  if (!image)
    goto err;

  fclose(fp);
  fp = ((void *)0);

  return image;

err:
  if (fp)
    fclose(fp);
  if (image)
    image_destroy(image);
  return ((void *)0);
}

static int picture_bmp_save(char *filename, image_t image,
       int x, int y, int width, int height, unsigned int flags)
{
  FILE *fp = ((void *)0);
  struct bmp_magic_header mhdr;
  struct bmp_file_header fhdr;
  struct bmp_info_header ihdr;
  int hdrsize, bfdsize, pltsize, imgsize, bits, colors, line_size, pad_size, write_size;
  int x0, y0, bx, by, c, i, n;
  int palette[256];
  struct bitfield bfd[3], *bfdp = ((void *)0);
  unsigned char bgr[4], mask;
  const char *mode;

  x0 = x;
  y0 = y;

  if (!width ) width = image->width - x0;
  if (!height) height = image->height - y0;


  mode = "w";




  fp = fopen(filename, mode);
  if (!fp)
    goto err;

  memset(&mhdr, 0, sizeof(mhdr));
  memset(&fhdr, 0, sizeof(fhdr));
  memset(&ihdr, 0, sizeof(ihdr));

  mhdr.type[0] = 'B';
  mhdr.type[1] = 'M';

  bfdsize = 0;
  colors = -1;
  n = 1;
  mask = 0xff;

  switch (flags & (7 << 13)) {
  case (6 << 13):
    bfdsize = sizeof(unsigned int) * 3;
    write_size = 2;
    bits = write_size * 8;
    line_size = width * write_size;
    break;

  case (1 << 13):
    bfdsize = sizeof(unsigned int) * 3;
    write_size = 4;
    bits = write_size * 8;
    line_size = width * write_size;
    break;

  default:
    colors = palette_make(image, x, y, width, height, 256, palette);
    if (colors < 0) {
      write_size = 3;
      bits = write_size * 8;
      line_size = width * write_size;
    } else {
      write_size = 1;
      if (colors <= 2)
 bits = 1;
      else if (colors <= 16)
 bits = 4;
      else
 bits = 8;
      line_size = (width * bits + 7) / 8;
      n = 8 / bits;
      mask = (1 << bits) - 1;
    }
    break;
  }

  pad_size = 4 - (line_size % 4);
  pad_size = (pad_size % 4);
  line_size += pad_size;

  hdrsize = 2 + 12 + 40;
  pltsize = ((colors < 0) ? 0 : colors) * sizeof(palette[0]);
  imgsize = line_size * height;

  fhdr.size = write_le32(hdrsize + bfdsize + pltsize + imgsize);
  fhdr.offset = write_le32(hdrsize + bfdsize + pltsize);

  ihdr.ihdrsize = write_le32(40);
  ihdr.width = write_le32(width);
  ihdr.height = write_le32(height);
  ihdr.planes = write_le16(1);
  ihdr.bits = write_le16(bits);
  ihdr.compress = write_le32(bfdsize ? 3 : 0);
  ihdr.imagesize = write_le32(imgsize);
  ihdr.xpix = write_le32(2925);
  ihdr.ypix = write_le32(2925);
  ihdr.colors = write_le32((colors < 0) ? 0 : colors);
  ihdr.impcolors = write_le32(0);

  if (fwrite(&mhdr, 1, 2, fp) != 2)
    goto err;

  if (fwrite(&fhdr, 1, 12, fp) != 12)
    goto err;

  if (fwrite(&ihdr, 1, 40, fp) != 40)
    goto err;

  switch (bits) {
  case 16:
    bitfield_calc(&bfd[0], 0x001f);
    bitfield_calc(&bfd[1], 0x03e0);
    bitfield_calc(&bfd[2], 0x7c00);
    bfdp = bfd;
    break;
  case 32:
    bitfield_calc(&bfd[0], 0x000000ff);
    bitfield_calc(&bfd[1], 0x0000ff00);
    bitfield_calc(&bfd[2], 0x00ff0000);
    bfdp = bfd;
    break;
  default:
    break;
  }

  if (bfdsize) {
    for (i = 0; i < 3; i++) {
      c = write_le32(bfd[2 - i].mask);
      fwrite(&c, 1, sizeof(c), fp);
    }
  }

  if (colors >= 0) {
    if (palette_save(fp, colors, palette) < 0)
      goto err;
  }

  for (y = 0; y < height; y++) {
    for (x = 0; x < width;) {
      bgr[0] = 0;
      for (i = 0; i < n; i++) {
 bx = x0 + x;
 by = y0 + (height - y - 1);
 if ((bx < 0) || (bx > image->width - 1) ||
     (by < 0) || (by > image->height - 1)) {
   c = 0;
 } else {
   c = image_get_color(image, bx, by);
   c = (c < 0) ? 0 : c;
   if (colors >= 0) {
     c = palette_search(colors, palette, c);
     if (c < 0)
       goto err;
   }
 }
 if (colors < 0) {
   if (bfdp)
     c = bitfield_save(c, bfdp);
   for (i = 0; i < write_size; i++)
     bgr[i] = (c >> (i * 8)) & 0xff;
 } else {
   bgr[0] |= (c & mask) << ((n - 1 - i) * bits);
 }
 x++;
      }
      fwrite(bgr, 1, write_size, fp);
    }
    bgr[0] = 0;
    for (x = 0; x < pad_size; x++)
      fwrite(bgr, 1, 1, fp);
  }

  fclose(fp);

  return 0;

err:
  if (fp)
    fclose(fp);
  return -1;
}

image_t picture_load(char *filename, unsigned int flags)
{
  return picture_bmp_load(filename, flags);
}

int picture_save(char *filename, image_t image,
   int x, int y, int width, int height, unsigned int flags)
{
  return picture_bmp_save(filename, image, x, y, width, height, flags);
}
