# 0 "nllmain.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "nllmain.c"
# 1 "config.h" 1
# 2 "nllmain.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "nllmain.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "nllmain.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "nllmain.c" 2
# 1 "../include/ctype.h" 1



int isalnum(int c);
int isalpha(int c);
int isascii(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);
int tolower(int c);
int toupper(int c);
# 7 "nllmain.c" 2
# 1 "../include/unistd.h" 1
# 14 "../include/unistd.h"
void _exit(int status);
pid_t fork(void);
int execve(const char *path, char *const argv[], char *const envp[]);

ssize_t read(int fd, void *buf, size_t nbytes);
ssize_t write(int fd, const void *buf, size_t nbytes);
int close(int fd);

int dup(int oldd);
int pipe(int fildes[2]);
int dup2(int oldd, int newd);
int pipe2(int fildes[2], int flags);

pid_t getpid(void);
pid_t getppid(void);
pid_t getsid(pid_t pid);
pid_t setsid(void);
pid_t getpgid(pid_t pid);
int setpgid(pid_t pid, pid_t pgrp);
pid_t getpgrp(void);

pid_t tcgetpgrp(int fd);
int tcsetpgrp(int fd, pid_t pgrp_id);

int unlink(const char *path);
int chdir(const char *path);
int chdir(const char *path);
int fchdir(int fd);
int chown(const char *path, uid_t owner, gid_t group);
off_t lseek(int fildes, off_t offset, int whence);
int access(const char *path, int mode);
void sync(void);
int fsync(int fd);
int fchown(int fd, uid_t owner, gid_t group);

int truncate(const char *path, off_t length);
int ftruncate(int fd, off_t length);


int brk(void *addr);



void *sbrk(intptr_t incr);

char *getcwd(char *buf, size_t size);

unsigned int sleep(unsigned int seconds);
int usleep(useconds_t microseconds);

int isatty(int fd);
# 8 "nllmain.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 11 "nllmain.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 14 "nllmain.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 15 "nllmain.c" 2
# 1 "formula.h" 1



typedef enum {
  ELEMENT_TYPE_NONE,
  ELEMENT_TYPE_SYMBOL,
  ELEMENT_TYPE_INTEGER,
  ELEMENT_TYPE_STRING,

  ELEMENT_TYPE_FLOAT,

  ELEMENT_TYPE_VARIABLE,
  ELEMENT_TYPE_OPERATOR,
  ELEMENT_TYPE_ELEMENTS,
} element_type_t;

int formula_check(void);
int formula_init(void);
int formula_done(void);
int formula_get_symbol(char *dname, const char *name);
element_type_t formula_get_type(element_t element);
value_t formula_get_value(element_t element);
variable_t formula_get_variable(element_t element);
int formula_set_raw(element_t element);
int formula_free(element_t *elementp);
int formula_clean(element_t element);
int formula_parse(char *formula, char **endp, element_t *elementp, const char *terminator);
int formula_proc(element_t element, value_t *valuep);
int formula_dump(FILE *fp, element_t element);
int formula_operator_list(FILE *fp);
# 16 "nllmain.c" 2
# 1 "command.h" 1



typedef enum {
  COMMAND_UNKNOWN = 0,
  COMMAND_NONE,

  COMMAND_COMMENT,
  COMMAND_END,
  COMMAND_EXIT,
  COMMAND_ARGS,
  COMMAND_LET,
  COMMAND_PRINT,
  COMMAND_GOTO,
  COMMAND_GONEXT,
  COMMAND_GOSUB,
  COMMAND_RETURN,
  COMMAND_IF,
  COMMAND_ELSE,
  COMMAND_ENDIF,
  COMMAND_LOOP,
  COMMAND_LOOPEND,
  COMMAND_FOR,
  COMMAND_NEXT,
  COMMAND_DISCARD,
  COMMAND_DIM,
  COMMAND_MEMORY,
  COMMAND_PUSH,
  COMMAND_POP,
  COMMAND_DFROM,
  COMMAND_DREAD,
  COMMAND_DATA,
  COMMAND_RUN,
  COMMAND_STOP,
  COMMAND_SKIP,
  COMMAND_BREAK,
  COMMAND_STEP,
  COMMAND_CONTINUE,
  COMMAND_NEW,
  COMMAND_LIST,
  COMMAND_SAVE,
  COMMAND_LOAD,
  COMMAND_STDIN,
  COMMAND_STDOUT,
  COMMAND_EVAL,
  COMMAND_EVALF,
  COMMAND_EDIT,
  COMMAND_WAIT,
  COMMAND_DUMP,

  COMMAND_LAST
} command_type_t;

typedef enum {
  COMMAND_ARG_UNKNOWN = 0,
  COMMAND_ARG_LABEL,
  COMMAND_ARG_VARIABLE,
  COMMAND_ARG_FORMULA,
  COMMAND_ARG_WORD,
} command_arg_type_t;

typedef const struct command_ope {
  const char *name;
  const char *other_name;
  command_type_t type;
} *command_ope_t;

typedef struct command_arg {
  command_arg_type_t type;
  union {
    struct {
      label_t label;
    } label;
    struct {
      variable_t variable;
    } variable;
    struct {
      element_t element;
    } formula;
    struct {
      char word[0 + 1];
    } word;
  } arg;
} *command_arg_t;

struct command {
  struct command *next;
  command_ope_t ope;
  char *line;
  int errcode;
  struct {
    label_t label;
    variable_t variable;
    element_t args;
  } label;
  element_t prefix;
  struct command_arg args[4];
};

int command_check(void);
int command_search(char *p, char **endp, command_ope_t *opep);
int command_list(FILE *fp);
int command_get(command_type_t type, command_ope_t *opep);
int command_alloc(command_t *commandp);
int command_free(command_t command);
int command_set_label(command_t command, const char *name, spot_t spot);
int command_clear_label(command_t command);
int command_clear(command_t command);
int command_clean(command_t command);
int command_init(void);
int command_done(void);
int command_dump(FILE *fp, command_t command);
# 17 "nllmain.c" 2
# 1 "line.h" 1



struct line {
  struct line *next;
  struct line *prev;
  char buffer[256 + 1];
  command_t commands;
};

int line_check(void);
int line_alloc(line_t *linep);
int line_free(line_t line);
int line_clear(void);
int line_clean(void);
int line_init(void);
int line_done(void);
line_t line_head(void);
line_t line_tail(void);
int line_list_num(void);
int line_is_exist(line_t line);
int line_get(int number, line_t *linep);
int line_set(int number, int number2, char *buffer, line_t *linep, int save, int move);
int line_print(FILE *fp, int start_number, int end_number);
int line_dump(FILE *fp, line_t line);
# 18 "nllmain.c" 2
# 1 "label.h" 1



struct label {
  struct label *next;
  struct label *prev;
  struct spot spot;
  int refcount;
  char name[32 + 1];
};

int label_check(void);
int label_init(void);
int label_done(void);
int label_get(const char *name, label_t *labelp);
int label_set(const char *name, spot_t spot, label_t *labelp);
int label_clear(label_t label);
int label_clean(label_t label);
int label_del(label_t label);
int label_dump(FILE *fp, label_t label);
# 19 "nllmain.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 20 "nllmain.c" 2
# 1 "string.h" 1



struct string {
  struct string *next;
  char *s;
  int length;
  int size;
};

int string_check(void);
int string_alloc(string_t *stringp);
int string_free(string_t string);
int string_del(string_t string);
int string_init(void);
int string_done(void);
int string_set(string_t string, const char *s, int length);
char *string_buffer(void);
int string_buffer_size(void);
int string_dump_string(FILE *fp, string_t string);
int string_dump(FILE *fp, string_t string);
# 21 "nllmain.c" 2
# 1 "variable.h" 1



struct variable {
  struct variable *next;
  struct variable *prev;
  value_t value;
  int refcount;
  char name[32 + 1];
};

int variable_check(void);
int variable_del(variable_t variable);
int variable_clean(void);
int variable_clear(void);
int variable_new(variable_t variable);
int variable_init(void);
int variable_done(void);
int variable_get(const char *name, variable_t *variablep);
int variable_dump(FILE *fp, variable_t variable);
int variable_const_list(FILE *fp);
# 22 "nllmain.c" 2
# 1 "position.h" 1



struct position {
  position_type_t type;
  struct spot spot;
  value_t value;
  int arg;
};

int position_check(void);
int position_init(void);
int position_clear(void);
int position_clean(void);
int position_push(position_type_t type, spot_t spot, value_t value, int arg);
int position_pop(position_type_t type, position_type_t *typep,
   spot_t spot, value_t value, int *argp);
int position_peek(position_type_t type, spot_t spot, value_t *valuep, int *argp);
position_type_t position_get_type(void);
int position_get(spot_t spot, position_t *positionp);
int position_set(spot_t spot, position_t position);
int position_reset(position_t position);
int position_dump(FILE *fp);
# 23 "nllmain.c" 2
# 1 "array.h" 1



struct array {
  value_t value;
};

int array_check(void);
int array_init(void);
int array_get_number(array_t array);
int array_get_value(array_t array, int index, value_t *valuep);
int array_set_value(array_t array, int index, value_t value);
int array_alloc(array_t *arrayp, int number);
int array_free(array_t array, int number);
int array_make(value_t value, int *n);
int array_make_values(value_t value, value_t numbers);
int array_dump(FILE *fp, array_t array);
# 24 "nllmain.c" 2
# 1 "area.h" 1



struct area {
  struct area *next;
  struct area *prev;
  int refcount;
  int size;
  int area_size;
};

int area_check(void);
int area_alloc(area_t *areap, int size);
int area_free(area_t area);
int area_init(void);
int area_get_size(area_t area);
char *area_get_buffer(area_t area);
int area_copy_area(area_t area, int offset, area_t _area, int _offset, int size);
int area_read(area_t area, int offset, char *buffer, int size);
int area_write(area_t area, int offset, char *buffer, int size);
int area_read_integer(area_t area, int offset, integer_t *integerp, int size);
int area_write_integer(area_t area, int offset, integer_t integer, int size);
int area_dump(FILE *fp, area_t area);
# 25 "nllmain.c" 2
# 1 "stack.h" 1





typedef enum {
  STACK_TYPE_USER = 0,
  STACK_TYPE_CALL,
} stack_type_t;

struct stack_frame {
  value_t value;
};

int stack_check(void);
int stack_init(void);
int stack_getnum(void);
int stack_push_type(stack_type_t type, value_t value);
int stack_pop_type(stack_type_t type, value_t value);
int stack_push(value_t value);
int stack_pop(value_t value);
int stack_clear(void);
int stack_clean(void);
int stack_dump(FILE *fp);
# 26 "nllmain.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 27 "nllmain.c" 2
# 1 "readline.h" 1



char *nll_readline(const char *prompt);
void nll_add_history(const char *line);
void nll_edit_line(int number, line_t line);
# 28 "nllmain.c" 2
# 1 "fileid.h" 1



typedef int fileid_id_t;

int fileid_init(void);
int fileid_done(void);
int fileid_check(void);
FILE *fileid_get_fp(fileid_id_t id);
int fileid_set_fp(fileid_id_t id, FILE *fp);
int fileid_destroy(fileid_id_t id);
fileid_id_t fileid_create(FILE *fp);
# 29 "nllmain.c" 2
# 1 "queueid.h" 1



typedef int queueid_index_t;

int queueid_init(void);
int queueid_done(void);
int queueid_check(void);

int queueid_number(queueid_index_t index);
int queueid_headin(queueid_index_t index, value_t value);
int queueid_tailin(queueid_index_t index, value_t value);
int queueid_headout(queueid_index_t index, value_t value);
int queueid_tailout(queueid_index_t index, value_t value);

int queueid_destroy(queueid_index_t index);
queueid_index_t queueid_create(void);
# 30 "nllmain.c" 2
# 1 "key.h" 1



typedef enum {
  KEY_CODE_NONE = 0,

  KEY_CODE_ENTER = '\n',
  KEY_CODE_ESCAPE = 0x1b,
  KEY_CODE_BACKSPACE = '\b',
  KEY_CODE_TAB = '\t',
  KEY_CODE_SPACE = ' ',
  KEY_CODE_EXCLAIM = '!',
  KEY_CODE_QUOTEDBL = '"',
  KEY_CODE_HASH = '#',
  KEY_CODE_PERCENT = '%',
  KEY_CODE_DOLLAR = '$',
  KEY_CODE_AMPERSAND = '&',
  KEY_CODE_QUOTE = '\'',
  KEY_CODE_LEFTPAREN = '(',
  KEY_CODE_RIGHTPAREN = ')',
  KEY_CODE_ASTERISK = '*',
  KEY_CODE_PLUS = '+',
  KEY_CODE_COMMA = ',',
  KEY_CODE_MINUS = '-',
  KEY_CODE_PERIOD = '.',
  KEY_CODE_SLASH = '/',
  KEY_CODE_0 = '0',
  KEY_CODE_1 = '1',
  KEY_CODE_2 = '2',
  KEY_CODE_3 = '3',
  KEY_CODE_4 = '4',
  KEY_CODE_5 = '5',
  KEY_CODE_6 = '6',
  KEY_CODE_7 = '7',
  KEY_CODE_8 = '8',
  KEY_CODE_9 = '9',
  KEY_CODE_COLON = ':',
  KEY_CODE_SEMICOLON = ';',
  KEY_CODE_LESS = '<',
  KEY_CODE_EQUALS = '=',
  KEY_CODE_GREATER = '>',
  KEY_CODE_QUESTION = '?',
  KEY_CODE_AT = '@',
  KEY_CODE_LEFTBRACKET = '[',
  KEY_CODE_BACKSLASH = '\\',
  KEY_CODE_RIGHTBRACKET = ']',
  KEY_CODE_CARET = '^',
  KEY_CODE_UNDERSCORE = '_',
  KEY_CODE_BACKQUOTE = '`',
  KEY_CODE_A = 'a',
  KEY_CODE_B = 'b',
  KEY_CODE_C = 'c',
  KEY_CODE_D = 'd',
  KEY_CODE_E = 'e',
  KEY_CODE_F = 'f',
  KEY_CODE_G = 'g',
  KEY_CODE_H = 'h',
  KEY_CODE_I = 'i',
  KEY_CODE_J = 'j',
  KEY_CODE_K = 'k',
  KEY_CODE_L = 'l',
  KEY_CODE_M = 'm',
  KEY_CODE_N = 'n',
  KEY_CODE_O = 'o',
  KEY_CODE_P = 'p',
  KEY_CODE_Q = 'q',
  KEY_CODE_R = 'r',
  KEY_CODE_S = 's',
  KEY_CODE_T = 't',
  KEY_CODE_U = 'u',
  KEY_CODE_V = 'v',
  KEY_CODE_W = 'w',
  KEY_CODE_X = 'x',
  KEY_CODE_Y = 'y',
  KEY_CODE_Z = 'z',

  KEY_CODE_CAPSLOCK = 128,
  KEY_CODE_F1,
  KEY_CODE_F2,
  KEY_CODE_F3,
  KEY_CODE_F4,
  KEY_CODE_F5,
  KEY_CODE_F6,
  KEY_CODE_F7,
  KEY_CODE_F8,
  KEY_CODE_F9,
  KEY_CODE_F10,
  KEY_CODE_F11,
  KEY_CODE_F12,

  KEY_CODE_PRINTSCREEN,
  KEY_CODE_SCROLLLOCK,
  KEY_CODE_PAUSE,
  KEY_CODE_INSERT,
  KEY_CODE_HOME,
  KEY_CODE_PAGEUP,
  KEY_CODE_DELETE,
  KEY_CODE_END,
  KEY_CODE_PAGEDOWN,
  KEY_CODE_RIGHT,
  KEY_CODE_LEFT,
  KEY_CODE_DOWN,
  KEY_CODE_UP,

  KEY_CODE_F13,
  KEY_CODE_F14,
  KEY_CODE_F15,

  KEY_CODE_LCTRL,
  KEY_CODE_LSHIFT,
  KEY_CODE_LALT,
  KEY_CODE_RCTRL,
  KEY_CODE_RSHIFT,
  KEY_CODE_RALT,

  KEY_CODE_NUM
} key_code_t;
# 228 "key.h"
const char *keyname_get(key_code_t code);
key_code_t keycode_get(const char *name);
# 31 "nllmain.c" 2
# 1 "framebuf.h" 1



int framebuf_get_screen_flags(void);
int framebuf_get_screen_width(void);
int framebuf_get_screen_height(void);
int framebuf_get_cursor_x(void);
int framebuf_get_cursor_y(void);
int framebuf_get_cursor_effect(void);
int framebuf_get_cursor_fgcolor(void);
int framebuf_get_cursor_bgcolor(void);
int framebuf_init(void);
int framebuf_done(void);
int framebuf_setscreen(int flags, int width, int height);
int framebuf_enable(int enable);
int framebuf_cursor_on(void);
int framebuf_cursor_off(void);
int framebuf_flush(int flags);
int framebuf_seteffect(int effect);
int framebuf_setfgcolor(int color);
int framebuf_setbgcolor(int color);
int framebuf_move_cursor(int x, int y);
int framebuf_move_left(int num);
int framebuf_move_right(int num);
int framebuf_move_up(int num);
int framebuf_move_down(int num);
int framebuf_getch(int x, int y);
int framebuf_clear(int chara, int flags);
int framebuf_scroll(int x, int y, int chara);
int framebuf_puts(const char *str);
int framebuf_line(int x0, int y0, int x1, int y1, const char *str);
int framebuf_box(int x0, int y0, int x1, int y1, const char *str, int flags);
key_code_t framebuf_getkey(void);
# 32 "nllmain.c" 2
# 1 "mouse.h" 1



typedef enum {
  MOUSE_CODE_NONE = 0,

  MOUSE_CODE_RIGHT,
  MOUSE_CODE_LEFT,
  MOUSE_CODE_MIDDLE,

  MOUSE_CODE_NUM
} mouse_code_t;





const char *mousename_get(mouse_code_t code);
mouse_code_t mousecode_get(const char *name);
# 33 "nllmain.c" 2
# 1 "graphic.h" 1



int graphic_color(int red, int green, int blue);
int graphic_rgb(int color, int *redp, int *greenp, int *bluep);
int graphic_get_screen_flags(void);
int graphic_get_screen_width(void);
int graphic_get_screen_height(void);
int graphic_get_screen_image(void);
int graphic_check(void);
int graphic_init(void);
int graphic_done(void);
int graphic_setscreen(int flags, int width, int height, int index);
int graphic_sync(void);
int graphic_enable(int enable);
int graphic_flush(int flags);
int graphic_getmainimage(void);
int graphic_setmainimage(int index);
int graphic_getwidth(int index);
int graphic_getheight(int index);
int graphic_getrange(int index, int *xp, int *yp, int *widthp, int *heightp, int *mulxp, int *mulyp);
int graphic_setrange(int index, int x, int y, int width, int height, int mulx, int muly);
int graphic_getoffset(int index, int *xp, int *yp);
int graphic_setoffset(int index, int x, int y);
int graphic_getscale(int index, int *mulxp, int *mulyp, int *divxp, int *divyp);
int graphic_setscale(int index, int mulx, int muly, int divx, int divy);
int graphic_getdotoffset(int index, int *xp, int *yp);
int graphic_setdotoffset(int index, int x, int y);
int graphic_getdotsize(int index, int *widthp, int *heightp);
int graphic_setdotsize(int index, int width, int height);
int graphic_getcolor(int index, int *colorp, int *fgcolorp, int *bgcolorp, int *fromcolorp, int *tocolorp);
int graphic_setcolor(int index, int color, int fgcolor, int bgcolor, int fromcolor, int tocolor, int flags);
int graphic_getpixel(int index, int x, int y);
int graphic_keydown(key_code_t code);
int graphic_keyup(key_code_t code);
int graphic_mousemotion(int x, int y);
int graphic_mousebuttondown(mouse_code_t code, int x, int y);
int graphic_mousebuttonup(mouse_code_t code);
int graphic_clear(int index, int color, int flags);
int graphic_scroll(int index, int x, int y, int color, int flags);
int graphic_dot(int index, int x, int y, int color, int flags);
int graphic_line(int index, int x0, int y0, int x1, int y1, int color, int flags);
int graphic_box(int index, int x0, int y0, int x1, int y1, int color, int flags);
int graphic_circle(int index, int x, int y, int rx, int ry, int color, int flags);
int graphic_paint(int index, int x, int y, int color, int border, int flags);
int graphic_copy(int index, int x0, int y0, int width0, int height0, int source, int x, int y, int width, int height, int flags);
int graphic_rotate(int index, int x, int y, int width, int height, int cx, int cy, int num, int color, int flags);
int graphic_char(int index, int x, int y, int width, int height, int ch, int type, int flags);
int graphic_print(int index, int x, int y, int width, int height, const char *string, int length, int type, int xgrid, int ygrid, int flags);
key_code_t graphic_getkeybuf(void);
int graphic_getkeystatus(key_code_t code);
int graphic_getmousepos(int *xp, int *yp);
mouse_code_t graphic_getmousebuf(int *xp, int *yp);
int graphic_getmousestatus(mouse_code_t code);
int graphic_allocimage(int width, int height, unsigned int flags);
int graphic_freeimage(int index);
int graphic_loadimage(char *filename, int *widthp, int *heightp, unsigned int flags);
int graphic_saveimage(char *filename, int index, int x, int y, int width, int height, unsigned int flags);
int graphic_cmpimage(int index, int x0, int y0, int width0, int height0, int source, int x, int y, int width, int height, int flags);
int graphic_charset(int type, int *widthp, int *heightp, int *nump, int flags);


int ext_graphic_init(void);
int ext_graphic_done(void);
int ext_graphic_start(int index);
int ext_graphic_stop(void);
# 34 "nllmain.c" 2
# 1 "audio.h" 1



int audio_check(void);
int audio_init(void);
int audio_done(void);
int audio_stop(void);
int audio_clear(int aunitset_index);
int audio_clear_all(void);
int audio_getsamplefreq(void);
int audio_setsamplefreq(int samplefreq);
int audio_playnum(void);
int audio_wait(void);
int audio_unitset(int aunitset_index);
int audio_unit(int output, int amp, int flags, int aunitset_index);
int audio_osc(int index, int amp, int freq, int phase, int type, int mod, int flags, int aunitset_index);
int audio_addout(int index, int output, int amp, int flags, int aunitset_index);
int audio_envpoint(int index, int n, int step, int amp, int flags, int aunitset_index);
int audio_envcopy(int index, int source, int flags, int aunitset_index);
int audio_filpoint(int index, int type, int n, int amp, int flags, int aunitset_index);
int audio_filcopy(int index, int source, int flags, int aunitset_index);
int audio_play(const char *mml, int flags, int aunitset_index, const char *filename);
int audio_open(char *filename, int *lengthp, unsigned int flags);
int audio_close(int index);


typedef int (*ext_audio_callback_t)(int channels, int samples, short *buffer, void *arg);
int ext_audio_init(void);
int ext_audio_done(void);
int ext_audio_run(int freq, int channels, int samples, ext_audio_callback_t callback, void *arg);
int ext_audio_stop(void);
int ext_audio_wait(void);
# 35 "nllmain.c" 2
# 1 "sdl.h" 1



int sdl_init(void);
int sdl_start(void);
int sdl_done(void);
# 36 "nllmain.c" 2
# 1 "image.h" 1



typedef unsigned int image_draw_count_t;

typedef enum {
  IMAGE_TYPE_NONE = -1,


  IMAGE_TYPE_FULLCOLOR = 0,
  IMAGE_TYPE_MONOCOLOR,
  IMAGE_TYPE_MONOBCOLOR,
  IMAGE_TYPE_ROUGHCOLOR,
  IMAGE_TYPE_GRAYCOLOR,
  IMAGE_TYPE_HALFCOLOR,
} image_type_t;

typedef enum {
  IMAGE_STATUS_NONE = 0,
  IMAGE_STATUS_ACTIVE,
  IMAGE_STATUS_FREE,
} image_status_t;

typedef struct image *image_t;

struct image_procs {
  int bytesize;
  int (*index)(image_t image, int width, int x, int y, int *indexp, int *offsetp);
  int (*get_color)(image_t image, int x, int y);
  int (*set_color)(image_t image, int x, int y, int color, unsigned int flags);
  int (*copy_get_color)(image_t image, int x, int y);
  int (*copy_save)(image_t image, int x, int y, int width, int height);
  int (*copy_save_color)(image_t image, int x, int y);
};

union image_bitmap {
  void *p;
  int *word;
  unsigned char *byte;
  unsigned short *half;
};

struct image {
  int index;
  int width;
  int height;
  int size;
  image_type_t type;
  unsigned int flags;
  struct {
    int fg;
    int bg;
    int from;
    int to;
  } color;
  struct {
    int x;
    int y;
    int width;
    int height;
    int mulx;
    int muly;
  } range;
  struct {
    int x;
    int y;
  } offset;
  struct {
    struct {
      int x;
      int y;
    } mul;
    struct {
      int x;
      int y;
    } div;
  } scale;
  struct {
    int x;
    int y;
    int width;
    int height;
  } dot;
  struct {
    int x;
    int y;
    int color;
  } current;
  union image_bitmap bitmap;
  volatile image_status_t status;
  struct image_draw {
    image_draw_count_t count;
    image_draw_count_t *line;
    int column_per;
    int column_num;
    image_draw_count_t *column;
    image_draw_count_t *pixel;
  } draw;
  struct image_copy {
    union image_bitmap bitmap;
  } copy;
  struct image_procs *procs;
};

int image_init(void);
int image_done(void);
int image_check(void);
int image_is_draw_line(image_t image, image_draw_count_t count, int y);
int image_is_draw_column(image_t image, image_draw_count_t count, int x, int y);
int image_is_draw_pixel(image_t image, image_draw_count_t count, int x, int y);
int image_set_draw_line(image_t image, image_draw_count_t count, int y);
int image_set_draw_column(image_t image, image_draw_count_t count, int x, int y);
int image_set_draw_pixel(image_t image, image_draw_count_t count, int x, int y);
int image_get_color(image_t image, int x, int y);
int image_set_color(image_t image, int x, int y, int color, unsigned int flags);
int image_copy_save(image_t image, int x, int y, int width, int height);
int image_copy_get_color(image_t image, int x, int y);
int image_copy_save_color(image_t image, int x, int y);
int image_get_index(image_t image);
image_t image_get_image(int index);
int image_reset_draw(image_t image);
int image_destroy(image_t image);
int image_create(image_t image, int width, int height, void *bitmap,
   image_type_t type, unsigned int flags);
image_t image_get(int width, int height, void *bitmap,
    image_type_t type, unsigned int flags);
# 37 "nllmain.c" 2
# 1 "sound.h" 1



typedef enum {
  SOUND_TYPE_UNKNOWN = 0,
  SOUND_TYPE_WAV,
  SOUND_TYPE_TEXT,

  SOUND_TYPE_NUM
} sound_type_t;

typedef struct sound *sound_t;

struct sound {
  int index;
  sound_type_t type;

  int samplefreq;
  int channels;
  int bits;
  int samplenum;

  unsigned int flags;

  FILE *fp;
  int offset;

  union {
    void *p;
    int8_t *b;
    int16_t *h;
    int32_t *w;
  } frames;
};

int sound_init(void);
int sound_done(void);
int sound_check(void);

int sound_get_index(sound_t sound);
sound_t sound_get_sound(int index);
int sound_destroy(sound_t sound);
sound_t sound_create(sound_type_t type, unsigned int flags);

int sound_ropen(sound_t sound, const char *filename);
int sound_wopen(sound_t sound, const char *filename,
  int samplefreq, int channels, int bits, int samplenum);
int sound_read(sound_t sound, short *frames, int num);
int sound_write(sound_t sound, short *frames, int num);
int sound_rclose(sound_t sound);
int sound_wclose(sound_t sound);
# 38 "nllmain.c" 2
# 1 "nll.h" 1



int nll_clear_line(line_t line);
int nll_parse(line_t line);
int nll_start(line_t line, command_t command, int *retcodep);
int nll_exec(spot_t spot, spot_t current, position_type_t type, value_t value, int *retcodep);
int nll_parse_exec(spot_t current, position_type_t type, char *buffer, value_t value, int *retcodep);
char *nll_line_buffer(line_t line);
int nll_line_edit(int number, int number2, char *buffer, line_t *linep, int save, int move);
int nll_line_free(line_t line);
# 39 "nllmain.c" 2
# 1 "nllmain.h" 1



int nll_init(FILE *in, FILE *out);
int nll_new(void);
int nll_done(void);

int nll_make_argc(int argc);
int nll_make_argv(int argc, char *argv[]);
int nll_set_arg(int index, value_t arg);
int nll_del_argc(void);
int nll_del_argv(void);

int nll_main(int argc, char *argv[], int quit, int auto_run, int auto_number, char *command);
# 40 "nllmain.c" 2

int nll_init(FILE *in, FILE *out)
{
  nll_stdin = in;
  nll_stdout = out;

  nll_clear_line(((void *)0));

  memory_init();
  variable_init();
  value_init();
  string_init();
  position_init();
  label_init();
  formula_init();
  command_init();
  line_init();
  array_init();
  area_init();
  stack_init();
  fileid_init();
  queueid_init();

  framebuf_init();





  image_init();
  graphic_init();


  sound_init();
  audio_init();

  return 0;
}

int nll_new(void)
{
  nll_clear_line(((void *)0));

  position_clean();
  stack_clean();
  line_clear();
  variable_clean();

  return 0;
}

int nll_done(void)
{
  int r;

  fileid_done();
  queueid_done();

  framebuf_done();


  audio_done();
  sound_done();


  graphic_done();
  image_done();





  nll_clear_line(((void *)0));


  variable_clear();


  position_clear();
  stack_clear();
  line_clear();
  variable_clean();

  nll_file_allclose();

  if ((r = variable_done()) < 0) return r;
  if ((r = value_done() ) < 0) return r;
  if ((r = string_done() ) < 0) return r;
  if ((r = label_done() ) < 0) return r;
  if ((r = formula_done() ) < 0) return r;
  if ((r = command_done() ) < 0) return r;
  if ((r = line_done() ) < 0) return r;

  if ((r = fileid_check() ) < 0) return r;
  if ((r = queueid_check() ) < 0) return r;

  if ((r = audio_check() ) < 0) return r;
  if ((r = sound_check() ) < 0) return r;


  if ((r = graphic_check() ) < 0) return r;
  if ((r = image_check() ) < 0) return r;

  if ((r = memory_check() ) < 0) return r;
  if ((r = variable_check()) < 0) return r;
  if ((r = value_check() ) < 0) return r;
  if ((r = string_check() ) < 0) return r;
  if ((r = position_check()) < 0) return r;
  if ((r = label_check() ) < 0) return r;
  if ((r = formula_check() ) < 0) return r;
  if ((r = array_check() ) < 0) return r;
  if ((r = command_check() ) < 0) return r;
  if ((r = line_check() ) < 0) return r;
  if ((r = area_check() ) < 0) return r;
  if ((r = stack_check() ) < 0) return r;

  nll_stdin_restore();
  nll_stdout_restore();

  nll_stdin = ((void *)0);
  nll_stdout = ((void *)0);

  return 0;
}

static void truncate_line(char *buffer)
{
  int len;
  if (buffer) {
    len = strlen(buffer);
    while (len > 0) {
      if (!isspace(buffer[len - 1]))
 break;
      len--;
    }
    buffer[len] = '\0';
  }
}

static variable_t variable_argc = ((void *)0), variable_argv = ((void *)0);

int nll_make_argc(int argc)
{
  int r;

  if (!variable_argc) {
    if ((r = variable_get("ARGC", &variable_argc)) < 0)
      goto err;
  }

  variable_argc->value->flags &= ~(1 << 0);
  if ((r = value_set_integer(variable_argc->value, argc)) < 0)
    goto err;
  variable_argc->value->flags |= (1 << 0);

  return 0;

err:
  nll_del_argc();

  return r;
}

int nll_make_argv(int argc, char *argv[])
{
  int r, i;
  array_t array = ((void *)0);
  value_t value;

  if (!variable_argv) {
    if ((r = variable_get("ARGV", &variable_argv)) < 0)
      goto err;
  }

  if ((r = array_alloc(&array, argc)) < 0)
    goto err;

  if (argv) {
    for (i = 0; i < argc; i++) {
      if ((r = array_get_value(array, i, &value)) < 0)
 goto err;
      if ((r = value_set_string(value, argv[i], -1)) < 0)
 goto err;
    }
  }

  variable_argv->value->flags &= ~(1 << 0);
  if ((r = value_set_array(variable_argv->value, array, 0)) < 0)
    goto err;
  array = ((void *)0);
  variable_argv->value->flags |= (1 << 0);

  return 0;

err:
  if (array)
    array_free(array, -1);
  nll_del_argv();

  return r;
}

int nll_set_arg(int index, value_t arg)
{
  int r;
  array_t array;
  value_t value;

  if (!variable_argv)
    return NLL_ERRCODE_VARIABLE_NOT_FOUND;

  if ((r = value_get_array(variable_argv->value, &array, ((void *)0))) < 0)
    return r;
  if ((r = array_get_value(array, index, &value)) < 0)
    return r;
  if ((r = value_copy_value(value, arg)) < 0)
    return r;

  return 0;
}

int nll_del_argc(void)
{
  int r = 0;

  if (variable_argc) {
    r = variable_del(variable_argc);
    variable_argc = ((void *)0);
  }

  return r;
}

int nll_del_argv(void)
{
  int r = 0;

  if (variable_argv) {
    r = variable_del(variable_argv);
    variable_argv = ((void *)0);
  }

  return r;
}

int nll_main(int argc, char *argv[], int quit, int auto_run, int auto_number, char *command)
{
  char *linebuf, *readlinebuf, *top, *p, *head;
  int finished = 0, r, number, number2, move, retcode = 0, direct_mode;
  line_t line;
  FILE *fp = ((void *)0);
  char buffer[256 + 1 + 8];

  nll_make_argc(argc);
  if (argc > 0)
    nll_make_argv(argc, argv);

  auto_number = (auto_number ? 1 : 0);

  while (!finished) {
    fp = nll_file_fp();
    if (!fp)
      auto_number = 0;

    linebuf = ((void *)0);
    readlinebuf = ((void *)0);

    if (fp) {
      linebuf = buffer + auto_number;
      if (!nll_fgets(linebuf, sizeof(buffer) - auto_number, fp)) {
 nll_file_close();
 continue;
      }
      truncate_line(linebuf);
    } else if (command) {
      linebuf = command;
      command = ((void *)0);
    } else if (auto_run) {
      linebuf = "RUN";
      auto_run = 0;
    } else if (quit) {
      finished = 1;
      continue;
    } else if (nll_is_tty()) {
      nll_finished_clear();
      readlinebuf = nll_readline("nll> ");
      if (nll_is_finished()) {
 if (!readlinebuf)
   write(1, "\n", 1);
 linebuf = "";
      } else if (!readlinebuf) {
 finished = 1;
 continue;
      } else {
 linebuf = readlinebuf;
 truncate_line(linebuf);
      }
    } else {
      finished = 1;
      continue;
    }

    p = linebuf;
    while (isspace(*p))
      p++;

    if (*p == '$') {
      direct_mode = 1;
      p++;
      while (isspace(*p))
 p++;
      top = p;
    } else {
      number = strtol(p, &top, 10);
      direct_mode = (!auto_number && (top == p)) ? 1 : 0;
    }

    if (direct_mode) {
      if ((r = nll_line_edit(-1, -1, top, &line, 0, 0)) < 0) {
 nll_error_print("nllmain.c", 359, r, top);
      } else if (line) {
 nll_initialize_clear();
 nll_edit_clear();
 r = nll_parse(line);
 if (readlinebuf)
   nll_add_history(nll_line_buffer(line));
 if (r >= 0) {
   if ((r = nll_start(line, ((void *)0), &retcode)) < 0)
     finished = 1;
 }
 if ((r = nll_line_free(line)) < 0)
   nll_error_print("nllmain.c", 371, r, top);
 if (nll_is_initialize()) {
   if ((r = nll_new()) < 0)
     nll_error_print("nllmain.c", 374, r, top);
 }
 if ((number = nll_edit()) >= 0) {
   if ((r = line_get(number, &line)) >= 0) {
     if (!line)
       line = line_tail();
     if (line)
       nll_edit_line(number, line);
   }
 }
      }
    } else {
      head = p;
      move = 0;
      number2 = -1;
      if (top == p) {
 number = 0;
 *(--top) = *p ? ' ' : '#';
      } else {
 p = top;
 while (isspace(*p))
   p++;
 if ((*p == '-') || isdigit(*p)) {
   move = 1;
   number2 = strtol(p, &top, 10);
 }
      }
      if ((r = nll_line_edit(number, number2, top, &line, 1, move)) < 0) {
 nll_error_print("nllmain.c", 402, r, top);
      } else {
 if (line)
   nll_parse(line);
 if (readlinebuf) {
   if (line)
     strcpy(top, nll_line_buffer(line));
   nll_add_history(head);
 }
      }
    }

    if (readlinebuf)
      free(readlinebuf);
  }

  nll_del_argv();
  nll_del_argc();

  return retcode;
}
