# 0 "label.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "label.c"
# 1 "config.h" 1
# 2 "label.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "label.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "label.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "label.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 9 "label.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 12 "label.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 13 "label.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 14 "label.c" 2
# 1 "label.h" 1



struct label {
  struct label *next;
  struct label *prev;
  struct spot spot;
  int refcount;
  char name[32 + 1];
};

int label_check(void);
int label_init(void);
int label_done(void);
int label_get(const char *name, label_t *labelp);
int label_set(const char *name, spot_t spot, label_t *labelp);
int label_clear(label_t label);
int label_clean(label_t label);
int label_del(label_t label);
int label_dump(FILE *fp, label_t label);
# 15 "label.c" 2

static int label_num = 0;
static int pool_num = 0;

static label_t head = ((void *)0);
static label_t pool = ((void *)0);

static label_t pool_alloc(void)
{
  label_t label;

  if (!pool)
    return ((void *)0);

  label = pool;
  pool = pool->next;
  pool_num--;

  return label;
}

static int pool_free(label_t label)
{
  label->next = pool;
  pool = label;
  pool_num++;
  return 0;
}


static int _init(void)
{
  return 0;
}

static int _done(void)
{
  while (pool)
    memory_free(pool_alloc());
  return 0;
}

static int _check(void)
{
  if (pool)
    return NLL_ERRCODE_LABEL_NOT_EMPTY;
  return 0;
}

static label_t _alloc(void)
{
  label_t label;
  label = pool_alloc();
  if (!label)
    label = memory_alloc(sizeof(*label));
  return label;
}

static int _free(label_t label)
{
  if ((256 < 0) || (pool_num < 256))
    return pool_free(label);
  memory_free(label);
  return 0;
}
# 130 "label.c"
int label_check(void)
{
  if (label_num || head)
    return NLL_ERRCODE_LABEL_NOT_EMPTY;

  return _check();
}

static int label_alloc(label_t *labelp)
{
  label_t label;

  if ((label = _alloc()) == ((void *)0))
    return NLL_ERRCODE_LABEL_BUFFER_OVER;
  label_num++;

  memset(label, 0, sizeof(*label));

  *labelp = label;

  return 0;
}

static int label_free(label_t label)
{
  label_t next;
  int r;

  for (; label; label = next) {
    next = label->next;

    label_num--;
    if ((r = _free(label)) < 0)
      return r;
  }

  return 0;
}

int label_init(void)
{
  label_num = 0;
  pool_num = 0;
  head = ((void *)0);
  pool = ((void *)0);
  return _init();
}

int label_done(void)
{
  return _done();
}

int label_get(const char *name, label_t *labelp)
{
  label_t label;

  for (label = head; label; label = label->next) {
    if (!strcmp(label->name, name)) {
      *labelp = label;
      return 0;
    }
  }

  return NLL_ERRCODE_LABEL_NOT_FOUND;
}

int label_set(const char *name, spot_t spot, label_t *labelp)
{
  label_t label;
  int r;

  if (strlen(name) > 32)
    return NLL_ERRCODE_LABEL_TOO_LONG;

  if (label_get(name, &label) == 0) {
    if (spot && label->spot.line)
      return NLL_ERRCODE_LABEL_DUPLICATE;
  } else {
    if ((r = label_alloc(&label)) < 0)
      return r;

    strcpy(label->name, name);

    label->next = head;
    label->prev = ((void *)0);
    if (head)
      head->prev = label;
    head = label;
  }

  if (spot) {
    label->spot.line = spot->line;
    label->spot.command = spot->command;
  }

  label->refcount++;

  *labelp = label;

  return 0;
}

int label_clear(label_t label)
{
  label->spot.line = ((void *)0);
  label->spot.command = ((void *)0);
  return 0;
}

int label_clean(label_t label)
{
  return 0;
}

int label_del(label_t label)
{
  if (--(label->refcount) == 0) {
    if (label->next)
      label->next->prev = label->prev;
    if (label->prev)
      label->prev->next = label->next;
    if (head == label)
      head = label->next;
    label->next = label->prev = ((void *)0);
    label_free(label);
  }

  return 0;
}

int label_dump(FILE *fp, label_t label)
{
  if (!label)
    label = head;

  nll_wait_output(fp);
  fprintf(fp, "\n-- Label dump --\n");

  for (; label; label = label->next) {
    nll_wait_output(fp);
    fprintf(fp, ".%s\tRef:%d\n", label->name, label->refcount);
  }

  fflush(fp);

  return 0;
}
