# 0 "key.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "key.c"
# 1 "config.h" 1
# 2 "key.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "key.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "key.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "key.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 9 "key.c" 2


# 1 "key.h" 1



typedef enum {
  KEY_CODE_NONE = 0,

  KEY_CODE_ENTER = '\n',
  KEY_CODE_ESCAPE = 0x1b,
  KEY_CODE_BACKSPACE = '\b',
  KEY_CODE_TAB = '\t',
  KEY_CODE_SPACE = ' ',
  KEY_CODE_EXCLAIM = '!',
  KEY_CODE_QUOTEDBL = '"',
  KEY_CODE_HASH = '#',
  KEY_CODE_PERCENT = '%',
  KEY_CODE_DOLLAR = '$',
  KEY_CODE_AMPERSAND = '&',
  KEY_CODE_QUOTE = '\'',
  KEY_CODE_LEFTPAREN = '(',
  KEY_CODE_RIGHTPAREN = ')',
  KEY_CODE_ASTERISK = '*',
  KEY_CODE_PLUS = '+',
  KEY_CODE_COMMA = ',',
  KEY_CODE_MINUS = '-',
  KEY_CODE_PERIOD = '.',
  KEY_CODE_SLASH = '/',
  KEY_CODE_0 = '0',
  KEY_CODE_1 = '1',
  KEY_CODE_2 = '2',
  KEY_CODE_3 = '3',
  KEY_CODE_4 = '4',
  KEY_CODE_5 = '5',
  KEY_CODE_6 = '6',
  KEY_CODE_7 = '7',
  KEY_CODE_8 = '8',
  KEY_CODE_9 = '9',
  KEY_CODE_COLON = ':',
  KEY_CODE_SEMICOLON = ';',
  KEY_CODE_LESS = '<',
  KEY_CODE_EQUALS = '=',
  KEY_CODE_GREATER = '>',
  KEY_CODE_QUESTION = '?',
  KEY_CODE_AT = '@',
  KEY_CODE_LEFTBRACKET = '[',
  KEY_CODE_BACKSLASH = '\\',
  KEY_CODE_RIGHTBRACKET = ']',
  KEY_CODE_CARET = '^',
  KEY_CODE_UNDERSCORE = '_',
  KEY_CODE_BACKQUOTE = '`',
  KEY_CODE_A = 'a',
  KEY_CODE_B = 'b',
  KEY_CODE_C = 'c',
  KEY_CODE_D = 'd',
  KEY_CODE_E = 'e',
  KEY_CODE_F = 'f',
  KEY_CODE_G = 'g',
  KEY_CODE_H = 'h',
  KEY_CODE_I = 'i',
  KEY_CODE_J = 'j',
  KEY_CODE_K = 'k',
  KEY_CODE_L = 'l',
  KEY_CODE_M = 'm',
  KEY_CODE_N = 'n',
  KEY_CODE_O = 'o',
  KEY_CODE_P = 'p',
  KEY_CODE_Q = 'q',
  KEY_CODE_R = 'r',
  KEY_CODE_S = 's',
  KEY_CODE_T = 't',
  KEY_CODE_U = 'u',
  KEY_CODE_V = 'v',
  KEY_CODE_W = 'w',
  KEY_CODE_X = 'x',
  KEY_CODE_Y = 'y',
  KEY_CODE_Z = 'z',

  KEY_CODE_CAPSLOCK = 128,
  KEY_CODE_F1,
  KEY_CODE_F2,
  KEY_CODE_F3,
  KEY_CODE_F4,
  KEY_CODE_F5,
  KEY_CODE_F6,
  KEY_CODE_F7,
  KEY_CODE_F8,
  KEY_CODE_F9,
  KEY_CODE_F10,
  KEY_CODE_F11,
  KEY_CODE_F12,

  KEY_CODE_PRINTSCREEN,
  KEY_CODE_SCROLLLOCK,
  KEY_CODE_PAUSE,
  KEY_CODE_INSERT,
  KEY_CODE_HOME,
  KEY_CODE_PAGEUP,
  KEY_CODE_DELETE,
  KEY_CODE_END,
  KEY_CODE_PAGEDOWN,
  KEY_CODE_RIGHT,
  KEY_CODE_LEFT,
  KEY_CODE_DOWN,
  KEY_CODE_UP,

  KEY_CODE_F13,
  KEY_CODE_F14,
  KEY_CODE_F15,

  KEY_CODE_LCTRL,
  KEY_CODE_LSHIFT,
  KEY_CODE_LALT,
  KEY_CODE_RCTRL,
  KEY_CODE_RSHIFT,
  KEY_CODE_RALT,

  KEY_CODE_NUM
} key_code_t;
# 228 "key.h"
const char *keyname_get(key_code_t code);
key_code_t keycode_get(const char *name);
# 12 "key.c" 2

static const struct {
  key_code_t code;
  const char *name;
} keys[] = {
  { KEY_CODE_ENTER , "ENTER" },
  { KEY_CODE_ESCAPE , "ESC" },
  { KEY_CODE_BACKSPACE , "BACKSPACE" },
  { KEY_CODE_TAB , "TAB" },
  { KEY_CODE_SPACE , " " },
  { KEY_CODE_EXCLAIM , "!" },
  { KEY_CODE_QUOTEDBL , "\"" },
  { KEY_CODE_HASH , "#" },
  { KEY_CODE_PERCENT , "%" },
  { KEY_CODE_DOLLAR , "$" },
  { KEY_CODE_AMPERSAND , "&" },
  { KEY_CODE_QUOTE , "\'" },
  { KEY_CODE_LEFTPAREN , "(" },
  { KEY_CODE_RIGHTPAREN , ")" },
  { KEY_CODE_ASTERISK , "*" },
  { KEY_CODE_PLUS , "+" },
  { KEY_CODE_COMMA , "," },
  { KEY_CODE_MINUS , "-" },
  { KEY_CODE_PERIOD , "." },
  { KEY_CODE_SLASH , "/" },
  { KEY_CODE_0 , "0" },
  { KEY_CODE_1 , "1" },
  { KEY_CODE_2 , "2" },
  { KEY_CODE_3 , "3" },
  { KEY_CODE_4 , "4" },
  { KEY_CODE_5 , "5" },
  { KEY_CODE_6 , "6" },
  { KEY_CODE_7 , "7" },
  { KEY_CODE_8 , "8" },
  { KEY_CODE_9 , "9" },
  { KEY_CODE_COLON , ":" },
  { KEY_CODE_SEMICOLON , ";" },
  { KEY_CODE_LESS , "<" },
  { KEY_CODE_EQUALS , "=" },
  { KEY_CODE_GREATER , ">" },
  { KEY_CODE_QUESTION , "?" },
  { KEY_CODE_AT , "@" },
  { KEY_CODE_LEFTBRACKET , "[" },
  { KEY_CODE_BACKSLASH , "\\" },
  { KEY_CODE_RIGHTBRACKET, "]" },
  { KEY_CODE_CARET , "^" },
  { KEY_CODE_UNDERSCORE , "_" },
  { KEY_CODE_BACKQUOTE , "`" },
  { KEY_CODE_A , "a" },
  { KEY_CODE_B , "b" },
  { KEY_CODE_C , "c" },
  { KEY_CODE_D , "d" },
  { KEY_CODE_E , "e" },
  { KEY_CODE_F , "f" },
  { KEY_CODE_G , "g" },
  { KEY_CODE_H , "h" },
  { KEY_CODE_I , "i" },
  { KEY_CODE_J , "j" },
  { KEY_CODE_K , "k" },
  { KEY_CODE_L , "l" },
  { KEY_CODE_M , "m" },
  { KEY_CODE_N , "n" },
  { KEY_CODE_O , "o" },
  { KEY_CODE_P , "p" },
  { KEY_CODE_Q , "q" },
  { KEY_CODE_R , "r" },
  { KEY_CODE_S , "s" },
  { KEY_CODE_T , "t" },
  { KEY_CODE_U , "u" },
  { KEY_CODE_V , "v" },
  { KEY_CODE_W , "w" },
  { KEY_CODE_X , "x" },
  { KEY_CODE_Y , "y" },
  { KEY_CODE_Z , "z" },

  { KEY_CODE_CAPSLOCK , "CAPSLOCK" },
  { KEY_CODE_F1 , "F1" },
  { KEY_CODE_F2 , "F2" },
  { KEY_CODE_F3 , "F3" },
  { KEY_CODE_F4 , "F4" },
  { KEY_CODE_F5 , "F5" },
  { KEY_CODE_F6 , "F6" },
  { KEY_CODE_F7 , "F7" },
  { KEY_CODE_F8 , "F8" },
  { KEY_CODE_F9 , "F9" },
  { KEY_CODE_F10 , "F10" },
  { KEY_CODE_F11 , "F11" },
  { KEY_CODE_F12 , "F12" },

  { KEY_CODE_PRINTSCREEN , "PRINTSCREEN" },
  { KEY_CODE_SCROLLLOCK , "SCROLLLOCK" },
  { KEY_CODE_PAUSE , "PAUSE" },
  { KEY_CODE_INSERT , "INSERT" },
  { KEY_CODE_HOME , "HOME" },
  { KEY_CODE_PAGEUP , "PAGEUP" },
  { KEY_CODE_DELETE , "DELETE" },
  { KEY_CODE_END , "END" },
  { KEY_CODE_PAGEDOWN , "PAGEDOWN" },
  { KEY_CODE_RIGHT , "RIGHT" },
  { KEY_CODE_LEFT , "LEFT" },
  { KEY_CODE_DOWN , "DOWN" },
  { KEY_CODE_UP , "UP" },

  { KEY_CODE_F13 , "F13" },
  { KEY_CODE_F14 , "F14" },
  { KEY_CODE_F15 , "F15" },

  { KEY_CODE_LCTRL , "LCTRL" },
  { KEY_CODE_LSHIFT , "LSHIFT" },
  { KEY_CODE_LALT , "LALT" },
  { KEY_CODE_RCTRL , "RCTRL" },
  { KEY_CODE_RSHIFT , "RSHIFT" },
  { KEY_CODE_RALT , "RALT" },

  { KEY_CODE_NONE , ((void *)0) },
};

const char *keyname_get(key_code_t code)
{
  static const char *names[KEY_CODE_NUM];
  static int made = 0;
  int i;

  if (!made) {
    for (i = 0; i < KEY_CODE_NUM; i++)
      names[i] = ((void *)0);
    for (i = 0; keys[i].name; i++)
      names[keys[i].code] = keys[i].name;
    made = 1;
  }

  if (((code < 0) || (code >= KEY_CODE_NUM)) ||
      (code == KEY_CODE_NONE))
    return ((void *)0);

  return names[code];
}
# 158 "key.c"
static int hashindex(const char *name)
{
  int r0, r1 = 0xff, r2 = 0xaa;

  r0 = name[0];
  if (name[0]) {
    r1 = name[1];
    if (name[1]) {
      r2 = name[2];
    }
  }

  return (r0 ^ r1 ^ r2) % 256;
}

key_code_t keycode_get(const char *name)
{
  static struct {
    struct {
      key_code_t code;
      const char *name;
    } codes[2];
    int num;
  } hash[256];
  static int made = 0;
  int i, n;

  if (!made) {
    for (i = 0; i < 256; i++)
      hash[i].num = 0;
    for (i = 0; keys[i].name; i++) {
      n = hashindex(keys[i].name);
      if (hash[n].num == 2)
 return KEY_CODE_NONE;
      hash[n].codes[hash[n].num].code = keys[i].code;
      hash[n].codes[hash[n].num].name = keys[i].name;
      hash[n].num++;
    }
    made = 1;
  }

  n = hashindex(name);

  for (i = 0; i < hash[n].num; i++) {
    if (!strcmp(name, hash[n].codes[i].name))
      return hash[n].codes[i].code;
  }

  return KEY_CODE_NONE;
}
