#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "const.h"
#include "image.h"
#include "charset.h"

#define CHARACTER_SIZE 32

#define TP 0x80 /* transparent */

#define B_   (1 << 0)
#define B__  (2 << 0)
#define B___ (3 << 0)
#define G_   (1 << 2)
#define G__  (2 << 2)
#define G___ (3 << 2)
#define R_   (1 << 4)
#define R__  (2 << 4)
#define R___ (3 << 4)

#define BK 0x00 /* black */

#define BL (          B___) /* blue */
#define GR (     G___     ) /* green */
#define CY (     G___|B___) /* cyan */
#define RD (R___          ) /* red */
#define MG (R___     |B___) /* magenta */
#define YL (R___|G___     ) /* yellow */
#define WH (R___|G___|B___) /* white */

#define B0 (        B_ )
#define B1 (        B__)
#define G0 (    G_     )
#define G1 (    G__    )
#define C0 (    G_ |B_ )
#define C1 (    G__|B__)
#define R0 (R_         )
#define R1 (R__        )
#define M0 (R_     |B_ )
#define M1 (R__    |B__)
#define Y0 (R_ |G_     )
#define Y1 (R__|G__    )
#define W0 (R_ |G_ |B_ )
#define W1 (R__|G__|B__)

#define C2 (     G_  |B__ )
#define C3 (     G_  |B___)
#define C4 (     G__ |B_  )
#define C5 (     G__ |B___)
#define C6 (     G___|B_  )
#define C7 (     G___|B__ )
#define M2 (R_       |B__ )
#define M3 (R_       |B___)
#define M4 (R__      |B_  )
#define M5 (R__      |B___)
#define M6 (R___     |B_  )
#define M7 (R___     |B__ )
#define Y2 (R_  |G__      )
#define Y3 (R_  |G___     )
#define Y4 (R__ |G_       )
#define Y5 (R__ |G___     )
#define Y6 (R___|G_       )
#define Y7 (R___|G__      )

#define Z0 (R_  |G_  |B__ )
#define Z1 (R_  |G_  |B___)
#define Z2 (R_  |G__ |B_  )
#define Z3 (R_  |G__ |B__ )
#define Z4 (R_  |G__ |B___)
#define Z5 (R_  |G___|B_  )
#define Z6 (R_  |G___|B__ )
#define Z7 (R_  |G___|B___)
#define Z8 (R__ |G_  |B_  )
#define Z9 (R__ |G_  |B__ )
#define ZA (R__ |G_  |B___)
#define ZB (R__ |G__ |B_  )
#define ZC (R__ |G__ |B___)
#define ZD (R__ |G___|B_  )
#define ZE (R__ |G___|B__ )
#define ZF (R__ |G___|B___)
#define ZG (R___|G_  |B_  )
#define ZH (R___|G_  |B__ )
#define ZI (R___|G_  |B___)
#define ZJ (R___|G__ |B_  )
#define ZK (R___|G__ |B__ )
#define ZL (R___|G__ |B___)
#define ZM (R___|G___|B_  )
#define ZN (R___|G___|B__ )

#ifdef USE_GRAPHIC
static GRAPHIC_CHARACTER_PRESET_TYPE unsigned char bitmap[] = {
#ifndef GRAPHIC_CHARACTER_PRESET_LIMITED
  /* apple */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,TP,TP,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,R1,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,TP,TP,TP,TP,R1,R1,TP,TP,TP,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,R1,R1,TP,TP,TP,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,R1,R1,TP,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,R1,R1,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,R1,R1,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,TP,TP,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,TP,TP,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,TP,TP,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,TP,TP,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,TP,TP,TP,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,TP,TP,TP,TP,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* grape */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,TP,TP,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,MG,TP,TP,TP,R1,R1,R1,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,TP,R1,R1,TP,TP,TP,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,MG,MG,R1,R1,TP,TP,TP,MG,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,MG,MG,R1,R1,TP,MG,MG,MG,MG,MG,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,MG,TP,MG,MG,MG,MG,MG,MG,WH,MG,MG,M1,MG,MG,MG,MG,MG,MG,MG,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,WH,MG,M1,M1,MG,MG,MG,MG,MG,MG,MG,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,WH,MG,MG,M1,MG,MG,MG,MG,MG,MG,WH,MG,MG,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,M1,M1,MG,MG,MG,MG,MG,WH,MG,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,MG,MG,MG,MG,MG,MG,WH,MG,MG,M1,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,WH,MG,MG,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,MG,MG,MG,MG,MG,WH,MG,M1,M1,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,MG,MG,MG,MG,WH,MG,MG,M1,M1,MG,MG,MG,MG,MG,MG,MG,M1,M1,MG,M1,M1,MG,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,M1,M1,MG,MG,MG,MG,MG,MG,WH,MG,MG,M1,M1,MG,MG,MG,MG,MG,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,MG,M1,M1,MG,M1,M1,MG,MG,MG,MG,MG,WH,MG,M1,M1,MG,MG,MG,MG,MG,MG,MG,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,MG,MG,MG,MG,WH,MG,MG,MG,M1,MG,MG,MG,MG,MG,MG,MG,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,WH,MG,MG,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,MG,MG,M1,M1,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,WH,MG,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,MG,WH,MG,MG,M1,M1,MG,MG,MG,MG,MG,MG,MG,MG,MG,WH,MG,MG,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,WH,MG,M1,M1,MG,MG,MG,MG,MG,MG,WH,MG,MG,MG,MG,MG,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,WH,MG,MG,M1,M1,MG,MG,MG,MG,MG,MG,WH,MG,TP,MG,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,M1,MG,MG,MG,MG,MG,MG,MG,WH,MG,MG,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,MG,TP,TP,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,MG,MG,MG,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,MG,WH,MG,MG,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,WH,MG,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,WH,MG,MG,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,MG,MG,MG,MG,MG,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,MG,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* watermelon */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,GR,GR,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,GR,GR,TP,
  TP,GR,GR,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,GR,GR,TP,
  TP,GR,GR,WH,RD,RD,BK,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,RD,WH,GR,GR,TP,
  TP,GR,GR,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,WH,GR,GR,TP,
  TP,GR,GR,WH,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,WH,GR,GR,TP,
  TP,GR,GR,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,BK,RD,RD,BK,RD,RD,RD,RD,RD,RD,WH,GR,GR,TP,
  TP,GR,GR,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,GR,GR,TP,
  TP,GR,GR,GR,WH,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,WH,WH,GR,GR,TP,
  TP,TP,GR,GR,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,GR,GR,GR,TP,
  TP,TP,GR,GR,GR,WH,WH,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,RD,WH,WH,GR,GR,TP,TP,
  TP,TP,TP,GR,GR,GR,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,GR,GR,GR,TP,TP,
  TP,TP,TP,GR,GR,GR,GR,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,GR,GR,GR,GR,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,GR,GR,GR,GR,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* peach */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,ZK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,ZK,ZK,ZK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,ZK,ZK,ZK,ZK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,TP,
  TP,TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,TP,
  TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,
  TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,
  TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,TP,
  TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,WH,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,TP,
  TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,ZK,ZK,TP,TP,
  TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,WH,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,ZK,ZK,TP,TP,
  TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,ZK,ZK,ZK,ZK,ZK,ZK,WH,WH,ZK,ZK,TP,TP,
  TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,ZK,ZK,ZK,ZK,ZK,WH,WH,WH,ZK,TP,TP,TP,
  TP,TP,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,ZK,ZK,ZK,ZK,WH,WH,WH,ZK,ZK,TP,GR,TP,
  TP,GR,GR,TP,TP,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,WH,ZK,ZK,ZK,WH,WH,WH,ZK,ZK,TP,GR,GR,TP,
  TP,GR,GR,GR,GR,GR,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,WH,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,TP,GR,GR,GR,TP,
  TP,GR,GR,GR,GR,GR,GR,GR,ZK,ZK,ZK,ZK,ZK,ZK,ZK,ZK,WH,WH,ZK,ZK,ZK,ZK,ZK,ZK,ZK,GR,GR,GR,GR,GR,GR,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,
  TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,
  TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* banana */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,GR,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y1,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y1,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y1,Y1,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,Y1,Y1,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,Y1,Y1,Y1,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,Y1,Y1,Y1,Y1,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,Y1,Y1,Y1,Y1,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,Y1,Y1,Y1,Y1,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,TP,Y1,Y1,Y1,Y1,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,Y1,Y1,Y1,Y1,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,Y1,Y1,Y1,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,
  TP,TP,Y1,Y1,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,Y1,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,Y1,Y1,Y1,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,TP,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,TP,TP,TP,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,TP,TP,TP,TP,TP,TP,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* lemon */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,WH,WH,WH,WH,WH,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,WH,WH,WH,WH,WH,YL,WH,WH,WH,WH,WH,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,WH,WH,YL,YL,YL,YL,YL,YL,WH,YL,YL,WH,WH,WH,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,WH,WH,YL,YL,YL,YL,YL,YL,YL,WH,YL,YL,YL,YL,WH,WH,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,YL,WH,WH,WH,WH,YL,YL,YL,YL,YL,WH,WH,YL,YL,YL,YL,WH,WH,WH,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,YL,WH,YL,YL,WH,WH,WH,YL,YL,YL,YL,WH,YL,YL,YL,YL,WH,WH,WH,WH,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,YL,YL,WH,YL,YL,YL,YL,WH,WH,WH,YL,YL,WH,YL,YL,YL,WH,WH,YL,YL,WH,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,YL,YL,YL,WH,YL,YL,YL,YL,YL,YL,WH,WH,YL,WH,YL,WH,WH,WH,YL,YL,YL,WH,WH,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,YL,YL,YL,WH,YL,YL,YL,YL,YL,YL,YL,WH,WH,WH,WH,WH,YL,YL,YL,YL,YL,YL,WH,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,YL,YL,YL,WH,WH,YL,YL,YL,YL,YL,YL,YL,WH,WH,WH,WH,YL,YL,YL,YL,YL,YL,WH,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,YL,YL,YL,YL,WH,YL,YL,YL,YL,YL,YL,WH,WH,YL,WH,WH,WH,WH,YL,YL,YL,YL,WH,WH,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,YL,YL,WH,YL,YL,YL,YL,YL,WH,WH,YL,YL,WH,YL,YL,WH,WH,YL,YL,YL,YL,WH,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,YL,YL,WH,WH,YL,YL,WH,WH,WH,YL,YL,YL,WH,YL,YL,YL,WH,WH,WH,YL,YL,WH,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,BK,YL,YL,WH,WH,WH,WH,YL,YL,YL,YL,YL,WH,WH,YL,YL,YL,YL,WH,WH,YL,WH,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,WH,WH,WH,YL,YL,YL,YL,YL,YL,WH,YL,YL,YL,YL,YL,WH,WH,WH,TP,TP,TP,
  TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,WH,WH,WH,YL,YL,YL,YL,WH,YL,YL,YL,YL,YL,YL,WH,WH,TP,TP,TP,
  TP,TP,TP,YL,YL,YL,BK,YL,YL,YL,YL,YL,YL,YL,YL,WH,WH,WH,YL,YL,WH,YL,YL,YL,WH,WH,WH,WH,TP,TP,TP,TP,
  TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,WH,WH,WH,WH,WH,WH,WH,WH,YL,YL,YL,TP,TP,TP,TP,
  TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,YL,YL,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,BK,YL,YL,YL,YL,YL,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,YL,BK,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* orange */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,TP,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y7,Y7,GR,GR,TP,TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,GR,GR,Y7,Y7,Y7,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,TP,TP,TP,TP,
  TP,TP,TP,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,TP,TP,
  TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,TP,
  TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,TP,
  TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,
  TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,TP,TP,
  TP,TP,Y7,Y7,BK,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,
  TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,
  TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,TP,TP,
  TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,TP,TP,TP,
  TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,WH,Y7,Y7,Y7,TP,TP,TP,
  TP,TP,TP,TP,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,WH,WH,Y7,Y7,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,WH,WH,WH,Y7,Y7,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,WH,WH,WH,Y7,Y7,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,WH,WH,WH,WH,Y7,Y7,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,WH,WH,WH,Y7,Y7,Y7,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* strawberry */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,TP,TP,TP,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,GR,GR,GR,GR,GR,GR,TP,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,RD,RD,RD,WH,RD,RD,RD,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,GR,GR,GR,GR,RD,RD,GR,GR,GR,GR,GR,RD,RD,RD,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,GR,GR,GR,GR,GR,RD,RD,RD,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,GR,GR,GR,GR,RD,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,GR,GR,GR,GR,GR,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,GR,GR,GR,RD,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,WH,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,WH,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,WH,RD,RD,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,RD,RD,RD,WH,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* melon */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,G1,G1,G1,G1,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,G1,G1,G1,G1,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,WH,GR,GR,WH,WH,WH,WH,GR,GR,TP,TP,TP,TP,G1,G1,G1,G1,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,WH,WH,GR,GR,TP,TP,TP,G1,G1,G1,G1,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,WH,GR,WH,GR,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,G1,G1,TP,G1,G1,G1,TP,
  TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,WH,GR,WH,GR,GR,GR,WH,WH,WH,WH,GR,GR,GR,GR,GR,TP,TP,TP,G1,G1,TP,
  TP,TP,TP,TP,TP,GR,GR,GR,GR,WH,WH,GR,GR,WH,WH,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,WH,WH,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,
  TP,TP,TP,TP,GR,WH,WH,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,WH,GR,TP,TP,TP,TP,
  TP,TP,TP,GR,GR,GR,WH,WH,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,WH,GR,GR,TP,TP,TP,
  TP,TP,TP,WH,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,WH,WH,WH,GR,GR,WH,GR,GR,TP,TP,TP,
  TP,TP,TP,GR,WH,GR,GR,GR,GR,GR,WH,GR,GR,GR,WH,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,WH,GR,TP,TP,TP,
  TP,TP,GR,GR,WH,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,WH,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,WH,GR,GR,WH,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,GR,WH,GR,GR,WH,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,GR,GR,WH,WH,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,TP,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,WH,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,WH,WH,GR,GR,WH,WH,WH,GR,GR,GR,GR,GR,WH,WH,GR,GR,TP,TP,TP,
  TP,TP,TP,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,WH,WH,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,GR,GR,GR,GR,WH,WH,WH,WH,WH,WH,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,WH,WH,GR,GR,TP,TP,TP,TP,
  TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,WH,WH,WH,GR,GR,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,WH,WH,WH,WH,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,GR,GR,GR,WH,WH,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,WH,WH,WH,WH,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,WH,GR,GR,GR,GR,WH,WH,WH,WH,WH,WH,GR,GR,GR,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,WH,WH,WH,WH,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* cherry */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,TP,TP,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,RD,GR,GR,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,WH,WH,RD,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,WH,WH,RD,RD,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,WH,WH,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,WH,WH,RD,RD,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* greenapple */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,TP,TP,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,R1,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,TP,TP,TP,TP,R1,R1,TP,TP,TP,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,R1,R1,TP,TP,TP,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,R1,R1,TP,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,R1,R1,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,R1,R1,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,
  TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,
  TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,
  TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,
  TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,
  TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,
  TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,
  TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,
  TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,
  TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,
  TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,
  TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,WH,YL,YL,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,WH,WH,YL,YL,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,WH,WH,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,WH,WH,YL,YL,YL,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,WH,WH,WH,WH,YL,YL,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,WH,WH,WH,WH,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,WH,WH,WH,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* pineapple */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,Y7,GR,GR,GR,GR,GR,GR,GR,YL,YL,GR,GR,GR,Y7,Y7,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,YL,Y7,GR,GR,GR,GR,Y7,YL,YL,YL,GR,GR,GR,GR,YL,YL,YL,GR,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,YL,Y7,YL,YL,YL,YL,Y7,YL,Y7,Y7,GR,GR,GR,GR,YL,YL,YL,YL,GR,GR,GR,GR,GR,TP,TP,TP,
  TP,TP,TP,TP,TP,YL,YL,YL,Y7,YL,Y7,Y7,Y7,Y7,YL,YL,GR,GR,GR,GR,YL,YL,YL,YL,YL,GR,GR,GR,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,YL,YL,YL,Y7,YL,YL,GR,GR,GR,GR,YL,YL,YL,Y7,Y7,TP,GR,GR,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,YL,YL,YL,Y7,YL,YL,YL,YL,YL,Y7,YL,YL,GR,GR,YL,Y7,Y7,Y7,YL,YL,TP,GR,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,Y7,YL,YL,YL,YL,Y7,YL,YL,YL,YL,Y7,YL,YL,YL,Y7,Y7,Y7,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,Y7,YL,YL,YL,YL,Y7,YL,YL,YL,YL,Y7,Y7,Y7,Y7,YL,YL,YL,Y7,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,Y7,YL,YL,YL,YL,Y7,Y7,Y7,Y7,YL,Y7,YL,YL,YL,YL,YL,Y7,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,YL,YL,YL,YL,YL,Y7,YL,YL,YL,YL,YL,Y7,YL,YL,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,Y7,YL,YL,YL,YL,Y7,YL,YL,YL,YL,Y7,YL,YL,YL,YL,YL,Y7,Y7,Y7,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,Y7,YL,YL,YL,YL,Y7,YL,YL,YL,YL,YL,Y7,YL,Y7,Y7,Y7,YL,Y7,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,Y7,YL,YL,YL,YL,Y7,YL,YL,YL,Y7,Y7,Y7,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,Y7,YL,YL,YL,YL,Y7,Y7,Y7,Y7,YL,YL,Y7,YL,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,YL,YL,YL,YL,Y7,Y7,Y7,Y7,YL,Y7,YL,YL,YL,YL,YL,Y7,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,YL,YL,YL,YL,YL,Y7,YL,YL,YL,YL,YL,Y7,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,YL,YL,YL,YL,Y7,YL,YL,YL,YL,YL,Y7,YL,YL,YL,YL,Y7,Y7,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,Y7,YL,YL,YL,YL,YL,Y7,Y7,Y7,Y7,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,Y7,Y7,Y7,Y7,Y7,YL,Y7,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,Y7,Y7,Y7,Y7,Y7,Y7,Y7,YL,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,YL,YL,YL,Y7,Y7,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,YL,YL,YL,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
#endif
};

const struct charset charset_character_2 = {
  CHARACTER_SIZE, CHARACTER_SIZE,
  sizeof(bitmap) / (sizeof(*bitmap) * CHARACTER_SIZE * CHARACTER_SIZE),
  bitmap, IMAGE_TYPE_ROUGHCOLOR, NLL_G_STATIC
};
#endif
