#ifndef __NLL_FORMULA_H_INCLUDED__
#define __NLL_FORMULA_H_INCLUDED__

typedef enum {
  ELEMENT_TYPE_NONE,
  ELEMENT_TYPE_SYMBOL,
  ELEMENT_TYPE_INTEGER,
  ELEMENT_TYPE_STRING,
#ifdef NLL_FLOATING_POINT
  ELEMENT_TYPE_FLOAT,
#endif
  ELEMENT_TYPE_VARIABLE,
  ELEMENT_TYPE_OPERATOR,
  ELEMENT_TYPE_ELEMENTS,
} element_type_t;

int formula_check(void);
int formula_init(void);
int formula_done(void);
int formula_get_symbol(char *dname, const char *name);
element_type_t formula_get_type(element_t element);
value_t formula_get_value(element_t element);
variable_t formula_get_variable(element_t element);
int formula_set_raw(element_t element);
int formula_free(element_t *elementp);
int formula_clean(element_t element);
int formula_parse(char *formula, char **endp, element_t *elementp, const char *terminator);
int formula_proc(element_t element, value_t *valuep);
int formula_dump(FILE *fp, element_t element);
int formula_operator_list(FILE *fp);

#endif
