# 1 "readline.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "readline.c"
# 1 "config.h" 1
# 2 "readline.c" 2




# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 7 "readline.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 8 "readline.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 9 "readline.c" 2
# 21 "readline.c"
# 1 "../include/nlline.h" 1



typedef char **rl_completion_func_t(const char *text, int start, int end);
extern rl_completion_func_t *rl_attempted_completion_function;

char *readline(const char *prompt);
void add_history(const char *line);
void clear_history(void);
# 22 "readline.c" 2



# 1 "../include/nllibc/nllibc.h" 1
# 26 "readline.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 29 "readline.c" 2
# 1 "line.h" 1



struct line {
  struct line *next;
  struct line *prev;
  char buffer[256 + 1];
  command_t commands;
};

int line_check(void);
int line_alloc(line_t *linep);
int line_free(line_t line);
int line_clear(void);
int line_clean(void);
int line_init(void);
int line_done(void);
line_t line_head(void);
line_t line_tail(void);
int line_list_num(void);
int line_is_exist(line_t line);
int line_get(int number, line_t *linep);
int line_set(int number, int number2, char *buffer, line_t *linep, int save, int move);
int line_print(FILE *fp, int start_number, int end_number);
int line_dump(FILE *fp, line_t line);
# 30 "readline.c" 2
# 1 "readline.h" 1



char *nll_readline(const char *prompt);
void nll_add_history(const char *line);
void nll_edit_line(int number, line_t line);
# 31 "readline.c" 2
# 89 "readline.c"
char *nll_readline(const char *prompt)
{
  return readline(prompt);
}

void nll_add_history(const char *line)
{
  add_history(line);
}

void nll_edit_line(int number, line_t line)
{
  char buffer[32 + 256 + 1];
  if (line) {
    sprintf(buffer, "%d %d%s", number, number, line->buffer);
    add_history(buffer);
  }
}
