# 1 "mouse.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "mouse.c"
# 1 "config.h" 1
# 2 "mouse.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "mouse.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "mouse.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "mouse.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 9 "mouse.c" 2


# 1 "mouse.h" 1



typedef enum {
  MOUSE_CODE_NONE = 0,

  MOUSE_CODE_RIGHT,
  MOUSE_CODE_LEFT,
  MOUSE_CODE_MIDDLE,

  MOUSE_CODE_NUM
} mouse_code_t;





const char *mousename_get(mouse_code_t code);
mouse_code_t mousecode_get(const char *name);
# 12 "mouse.c" 2

static const struct {
  mouse_code_t code;
  const char *name;
} mouses[] = {
  { MOUSE_CODE_RIGHT , "RIGHT" },
  { MOUSE_CODE_LEFT , "LEFT" },
  { MOUSE_CODE_MIDDLE, "MIDDLE" },

  { MOUSE_CODE_NONE , ((void *)0) },
};

const char *mousename_get(mouse_code_t code)
{
  int i;

  for (i = 0; mouses[i].name; i++) {
    if (code == mouses[i].code)
      return mouses[i].name;
  }

  return ((void *)0);
}

mouse_code_t mousecode_get(const char *name)
{
  int i;

  if (!name)
    return MOUSE_CODE_NONE;

  for (i = 0; mouses[i].name; i++) {
    if (!strcmp(name, mouses[i].name))
      return mouses[i].code;
  }

  return MOUSE_CODE_NONE;
}
