#ifndef __NLL_GRAPHIC_H_INCLUDED__
#define __NLL_GRAPHIC_H_INCLUDED__

int graphic_color(int red, int green, int blue);
int graphic_rgb(int color, int *redp, int *greenp, int *bluep);
int graphic_get_screen_flags(void);
int graphic_get_screen_width(void);
int graphic_get_screen_height(void);
int graphic_get_screen_image(void);
int graphic_check(void);
int graphic_init(void);
int graphic_done(void);
int graphic_setscreen(int flags, int width, int height, int index);
int graphic_sync(void);
int graphic_enable(int enable);
int graphic_flush(int flags);
int graphic_getmainimage(void);
int graphic_setmainimage(int index);
int graphic_getwidth(int index);
int graphic_getheight(int index);
int graphic_getrange(int index, int *xp, int *yp, int *widthp, int *heightp, int *mulxp, int *mulyp);
int graphic_setrange(int index, int x, int y, int width, int height, int mulx, int muly);
int graphic_getoffset(int index, int *xp, int *yp);
int graphic_setoffset(int index, int x, int y);
int graphic_getscale(int index, int *mulxp, int *mulyp, int *divxp, int *divyp);
int graphic_setscale(int index, int mulx, int muly, int divx, int divy);
int graphic_getdotoffset(int index, int *xp, int *yp);
int graphic_setdotoffset(int index, int x, int y);
int graphic_getdotsize(int index, int *widthp, int *heightp);
int graphic_setdotsize(int index, int width, int height);
int graphic_getcolor(int index, int *colorp, int *fgcolorp, int *bgcolorp, int *fromcolorp, int *tocolorp);
int graphic_setcolor(int index, int color, int fgcolor, int bgcolor, int fromcolor, int tocolor, int flags);
int graphic_getpixel(int index, int x, int y);
int graphic_keydown(key_code_t code);
int graphic_keyup(key_code_t code);
int graphic_mousemotion(int x, int y);
int graphic_mousebuttondown(mouse_code_t code, int x, int y);
int graphic_mousebuttonup(mouse_code_t code);
int graphic_clear(int index, int color, int flags);
int graphic_scroll(int index, int x, int y, int color, int flags);
int graphic_dot(int index, int x, int y, int color, int flags);
int graphic_line(int index, int x0, int y0, int x1, int y1, int color, int flags);
int graphic_box(int index, int x0, int y0, int x1, int y1, int color, int flags);
int graphic_circle(int index, int x, int y, int rx, int ry, int color, int flags);
int graphic_paint(int index, int x, int y, int color, int border, int flags);
int graphic_copy(int index, int x0, int y0, int width0, int height0, int source, int x, int y, int width, int height, int flags);
int graphic_rotate(int index, int x, int y, int width, int height, int cx, int cy, int num, int color, int flags);
int graphic_char(int index, int x, int y, int width, int height, int ch, int type, int flags);
int graphic_print(int index, int x, int y, int width, int height, const char *string, int length, int type, int xgrid, int ygrid, int flags);
key_code_t graphic_getkeybuf(void);
int graphic_getkeystatus(key_code_t code);
int graphic_getmousepos(int *xp, int *yp);
mouse_code_t graphic_getmousebuf(int *xp, int *yp);
int graphic_getmousestatus(mouse_code_t code);
int graphic_allocimage(int width, int height, unsigned int flags);
int graphic_freeimage(int index);
int graphic_loadimage(char *filename, int *widthp, int *heightp, unsigned int flags);
int graphic_saveimage(char *filename, int index, int x, int y, int width, int height, unsigned int flags);
int graphic_cmpimage(int index, int x0, int y0, int width0, int height0, int source, int x, int y, int width, int height, int flags);
int graphic_charset(int type, int *widthp, int *heightp, int *nump, int flags);

/* for GRAPHIC_EXTERNAL_DRIVER */
int ext_graphic_init(void);
int ext_graphic_done(void);
int ext_graphic_start(int index);
int ext_graphic_stop(void);

#endif
