# 1 "function.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "function.c"
# 1 "config.h" 1
# 2 "function.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "function.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "function.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "function.c" 2
# 1 "../include/ctype.h" 1



int isalnum(int c);
int isalpha(int c);
int isascii(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);
int tolower(int c);
int toupper(int c);
# 7 "function.c" 2
# 1 "../include/unistd.h" 1
# 14 "../include/unistd.h"
void _exit(int status);
pid_t fork(void);
int execve(const char *path, char *const argv[], char *const envp[]);

ssize_t read(int fd, void *buf, size_t nbytes);
ssize_t write(int fd, const void *buf, size_t nbytes);
int close(int fd);

int dup(int oldd);
int pipe(int fildes[2]);
int dup2(int oldd, int newd);
int pipe2(int fildes[2], int flags);

pid_t getpid(void);
pid_t getppid(void);
pid_t getsid(pid_t pid);
pid_t setsid(void);
pid_t getpgid(pid_t pid);
int setpgid(pid_t pid, pid_t pgrp);
pid_t getpgrp(void);

pid_t tcgetpgrp(int fd);
int tcsetpgrp(int fd, pid_t pgrp_id);

int unlink(const char *path);
int chdir(const char *path);
int chdir(const char *path);
int fchdir(int fd);
int chown(const char *path, uid_t owner, gid_t group);
off_t lseek(int fildes, off_t offset, int whence);
int access(const char *path, int mode);
void sync(void);
int fsync(int fd);
int fchown(int fd, uid_t owner, gid_t group);

int truncate(const char *path, off_t length);
int ftruncate(int fd, off_t length);


int brk(void *addr);



void *sbrk(intptr_t incr);

char *getcwd(char *buf, size_t size);

unsigned int sleep(unsigned int seconds);
int usleep(useconds_t microseconds);

int isatty(int fd);
# 8 "function.c" 2
# 1 "../include/fcntl.h" 1
# 42 "../include/fcntl.h"
int open(const char *path, int flags, ...);

int fcntl(int fd, int cmd, int args);
# 9 "function.c" 2
# 1 "../include/time.h" 1
# 11 "../include/time.h"
typedef long time_t;






time_t time(time_t *tloc);
# 10 "function.c" 2
# 1 "../include/sys/time.h" 1
# 22 "../include/sys/time.h"
struct timeval {
  time_t tv_sec;
  long tv_usec;
};

struct timezone {
  int tz_minuteswest;
  int tz_dsttime;
};

struct timespec {
  time_t tv_sec;
  long tv_nsec;
};

typedef struct timezone *__timezone_ptr_t;
# 50 "../include/sys/time.h"
int gettimeofday(struct timeval *tp, struct timezone *tzp);
int settimeofday(const struct timeval *tp, const struct timezone *tzp);
# 11 "function.c" 2

# 1 "../include/signal.h" 1
# 88 "../include/signal.h"
typedef void (*sig_t)(int);
# 106 "../include/signal.h"
typedef struct {
  unsigned int sig[2];
} sigset_t;

struct siginfo;
struct sigaction;


struct sigaction {
  union {
    void (*__sa_handler)(int);
    void (*__sa_sigaction)(int, struct siginfo *, void *);
  } __sigaction_u;
  sigset_t sa_mask;
  unsigned long sa_flags;

  void (*sa_restorer)(void);

};
# 193 "../include/signal.h"
struct sigcontext;
int sigreturn(struct sigcontext *scp);
# 216 "../include/signal.h"
int kill(pid_t pid, int sig);

int sigaction(int sig, const struct sigaction *act, struct sigaction *oact);
int sigprocmask(int how, const sigset_t *set, sigset_t *oset);

int killpg(pid_t pgrp, int sig);
# 13 "function.c" 2
# 1 "../include/sys/stat.h" 1
# 23 "../include/sys/stat.h"
int chmod(const char *path, mode_t mode);
int fchmod(int fd, mode_t mode);
int mkdir(const char *path, mode_t mode);
int rmdir(const char *path);
# 14 "function.c" 2
# 1 "../include/sys/select.h" 1





typedef unsigned long __fd_mask;




typedef struct fd_set {
  __fd_mask __fds_bits[(((1024) + (((sizeof(__fd_mask) * 8)) - 1)) / ((sizeof(__fd_mask) * 8)))];
} fd_set;
# 38 "../include/sys/select.h"
struct timeval;
struct timespec;
int select(int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, struct timeval *timeout);
int pselect(int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, const struct timespec *timeout, const sigset_t *newsigmask);
# 15 "function.c" 2
# 36 "function.c"
# 1 "../include/nllibc/nllibc.h" 1
# 37 "function.c" 2


# 1 "const.h" 1
# 40 "function.c" 2
# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 41 "function.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 42 "function.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 43 "function.c" 2
# 1 "string.h" 1



struct string {
  struct string *next;
  char *s;
  int length;
  int size;
};

int string_check(void);
int string_alloc(string_t *stringp);
int string_free(string_t string);
int string_del(string_t string);
int string_init(void);
int string_done(void);
int string_set(string_t string, const char *s, int length);
char *string_buffer(void);
int string_buffer_size(void);
int string_dump_string(FILE *fp, string_t string);
int string_dump(FILE *fp, string_t string);
# 44 "function.c" 2
# 1 "array.h" 1



struct array {
  value_t value;
};

int array_check(void);
int array_init(void);
int array_get_number(array_t array);
int array_get_value(array_t array, int index, value_t *valuep);
int array_set_value(array_t array, int index, value_t value);
int array_alloc(array_t *arrayp, int number);
int array_free(array_t array, int number);
int array_make(value_t value, int *n);
int array_make_values(value_t value, value_t numbers);
int array_dump(FILE *fp, array_t array);
# 45 "function.c" 2
# 1 "area.h" 1



struct area {
  struct area *next;
  struct area *prev;
  int refcount;
  int size;
  int area_size;
};

int area_check(void);
int area_alloc(area_t *areap, int size);
int area_free(area_t area);
int area_init(void);
int area_get_size(area_t area);
char *area_get_buffer(area_t area);
int area_copy_area(area_t area, int offset, area_t _area, int _offset, int size);
int area_read(area_t area, int offset, char *buffer, int size);
int area_write(area_t area, int offset, char *buffer, int size);
int area_read_integer(area_t area, int offset, integer_t *integerp, int size);
int area_write_integer(area_t area, int offset, integer_t integer, int size);
int area_dump(FILE *fp, area_t area);
# 46 "function.c" 2
# 1 "stack.h" 1





typedef enum {
  STACK_TYPE_USER = 0,
  STACK_TYPE_CALL,
} stack_type_t;

struct stack_frame {
  value_t value;
};

int stack_check(void);
int stack_init(void);
int stack_getnum(void);
int stack_push_type(stack_type_t type, value_t value);
int stack_pop_type(stack_type_t type, value_t value);
int stack_push(value_t value);
int stack_pop(value_t value);
int stack_clear(void);
int stack_clean(void);
int stack_dump(FILE *fp);
# 47 "function.c" 2
# 1 "nll.h" 1



int nll_clear_line(line_t line);
int nll_parse(line_t line);
int nll_start(line_t line, command_t command, int *retcodep);
int nll_exec(spot_t spot, spot_t current, position_type_t type, value_t value, int *retcodep);
int nll_parse_exec(spot_t current, position_type_t type, char *buffer, value_t value, int *retcodep);
char *nll_line_buffer(line_t line);
int nll_line_edit(int number, int number2, char *buffer, line_t *linep, int save, int move);
int nll_line_free(line_t line);
# 48 "function.c" 2
# 1 "function.h" 1



enum {
  FUNCTION_TYPE_NONE = 0,
  FUNCTION_TYPE_FARGS,
  FUNCTION_TYPE_COPY,
  FUNCTION_TYPE_TRUE,
  FUNCTION_TYPE_FALSE,
  FUNCTION_TYPE_ARGNUM,
  FUNCTION_TYPE_BOOLEAN,
  FUNCTION_TYPE_COND,
  FUNCTION_TYPE_AT,
  FUNCTION_TYPE_FPUSH,
  FUNCTION_TYPE_FPOP,
  FUNCTION_TYPE_STACKNUM,
  FUNCTION_TYPE_FPRINT,
  FUNCTION_TYPE_SPRINTF,
  FUNCTION_TYPE_PRINTF,
  FUNCTION_TYPE_PRINTM,
  FUNCTION_TYPE_INPUT,
  FUNCTION_TYPE_INPUTN,
  FUNCTION_TYPE_FWAIT,
  FUNCTION_TYPE_TIMER,
  FUNCTION_TYPE_NOSYSTEM,
  FUNCTION_TYPE_NOSYSCALL,
  FUNCTION_TYPE_NONETWORK,





  FUNCTION_TYPE_SYSTEM,


  FUNCTION_TYPE_SYSCALL,

  FUNCTION_TYPE_FEVAL,
  FUNCTION_TYPE_FEVALF,
  FUNCTION_TYPE_TYPEOF,
  FUNCTION_TYPE_TYPENAME,
  FUNCTION_TYPE_SIZEOF,
  FUNCTION_TYPE_NZERO,
  FUNCTION_TYPE_CMP,
  FUNCTION_TYPE_REP,
  FUNCTION_TYPE_INSERT,
  FUNCTION_TYPE_DELETE,
  FUNCTION_TYPE_ITOC,
  FUNCTION_TYPE_CTOI,
  FUNCTION_TYPE_ITOA,
  FUNCTION_TYPE_ATOI,

  FUNCTION_TYPE_ITOF,
  FUNCTION_TYPE_FTOI,
  FUNCTION_TYPE_ATOF,
  FUNCTION_TYPE_FTOA,

  FUNCTION_TYPE_ISALNUM,
  FUNCTION_TYPE_ISALPHA,
  FUNCTION_TYPE_ISASCII,
  FUNCTION_TYPE_ISCNTRL,
  FUNCTION_TYPE_ISDIGIT,
  FUNCTION_TYPE_ISGRAPH,
  FUNCTION_TYPE_ISLOWER,
  FUNCTION_TYPE_ISPRINT,
  FUNCTION_TYPE_ISPUNCT,
  FUNCTION_TYPE_ISSPACE,
  FUNCTION_TYPE_ISUPPER,
  FUNCTION_TYPE_ISXDIGIT,
  FUNCTION_TYPE_TOLOWER,
  FUNCTION_TYPE_TOUPPER,
  FUNCTION_TYPE_LEFT,
  FUNCTION_TYPE_RIGHT,
  FUNCTION_TYPE_MID,
  FUNCTION_TYPE_INSTR,
  FUNCTION_TYPE_STRLEN,
  FUNCTION_TYPE_STRCPY,
  FUNCTION_TYPE_SPLIT,
  FUNCTION_TYPE_SPLITS,
  FUNCTION_TYPE_CHOMP,
  FUNCTION_TYPE_LCHOMP,
  FUNCTION_TYPE_RCHOMP,
  FUNCTION_TYPE_SRAND,
  FUNCTION_TYPE_RAND,
  FUNCTION_TYPE_INT,
  FUNCTION_TYPE_ABS,
  FUNCTION_TYPE_SIGN,
  FUNCTION_TYPE_MAX,
  FUNCTION_TYPE_MIN,
  FUNCTION_TYPE_ABS2SUM,
  FUNCTION_TYPE_TIME,
  FUNCTION_TYPE_DATE,
  FUNCTION_TYPE_FDIM,
  FUNCTION_TYPE_FMEMORY,
  FUNCTION_TYPE_PEEK,
  FUNCTION_TYPE_POKE,
  FUNCTION_TYPE_MREAD,
  FUNCTION_TYPE_MWRITE,
  FUNCTION_TYPE_MCOPY,
# 127 "function.h"
  FUNCTION_TYPE_RENAME,
  FUNCTION_TYPE_UNLINK,
  FUNCTION_TYPE_TRUNCATE,
  FUNCTION_TYPE_MKDIR,
  FUNCTION_TYPE_RMDIR,
  FUNCTION_TYPE_CHDIR,
  FUNCTION_TYPE_OPEN,
  FUNCTION_TYPE_CLOSE,
  FUNCTION_TYPE_READ,
  FUNCTION_TYPE_WRITE,
  FUNCTION_TYPE_LSEEK,
  FUNCTION_TYPE_FTRUNCATE,
  FUNCTION_TYPE_ISREADABLE,
  FUNCTION_TYPE_ISWRITABLE,
  FUNCTION_TYPE_FOPEN,
  FUNCTION_TYPE_FDOPEN,
  FUNCTION_TYPE_FCLOSE,
  FUNCTION_TYPE_FILENO,
  FUNCTION_TYPE_FEOF,
  FUNCTION_TYPE_FERROR,
  FUNCTION_TYPE_FGETC,
  FUNCTION_TYPE_FPUTC,
  FUNCTION_TYPE_FGETS,
  FUNCTION_TYPE_FPUTS,
  FUNCTION_TYPE_FPRINTF,
  FUNCTION_TYPE_FREAD,
  FUNCTION_TYPE_FWRITE,
  FUNCTION_TYPE_FSEEK,
  FUNCTION_TYPE_QOPEN,
  FUNCTION_TYPE_QCLOSE,
  FUNCTION_TYPE_QLENGTH,
  FUNCTION_TYPE_QPUSHF,
  FUNCTION_TYPE_QPOPL,
  FUNCTION_TYPE_QPUSHL,
  FUNCTION_TYPE_QPOPF,
# 175 "function.h"
  FUNCTION_TYPE_KEYNAME,
  FUNCTION_TYPE_KEYCODE,
  FUNCTION_TYPE_SCREEN,
  FUNCTION_TYPE_SCRSTAT,
  FUNCTION_TYPE_FLUSH,
  FUNCTION_TYPE_GETCOLOR,
  FUNCTION_TYPE_GETFGCOLOR,
  FUNCTION_TYPE_GETBGCOLOR,
  FUNCTION_TYPE_SETCOLOR,
  FUNCTION_TYPE_GETATTR,
  FUNCTION_TYPE_SETATTR,
  FUNCTION_TYPE_GETPOS,
  FUNCTION_TYPE_MOVE,
  FUNCTION_TYPE_GETCH,
  FUNCTION_TYPE_CLEAR,
  FUNCTION_TYPE_SCROLL,
  FUNCTION_TYPE_LINE,
  FUNCTION_TYPE_BOX,
  FUNCTION_TYPE_INKEY,
  FUNCTION_TYPE_GSCREEN,
  FUNCTION_TYPE_GSCRSTAT,
  FUNCTION_TYPE_GCOLOR,
  FUNCTION_TYPE_GRGB,
  FUNCTION_TYPE_GSYNC,
  FUNCTION_TYPE_GFLUSH,
  FUNCTION_TYPE_GGETMAINIMG,
  FUNCTION_TYPE_GSETMAINIMG,
  FUNCTION_TYPE_GGETSIZE,
  FUNCTION_TYPE_GGETRANGE,
  FUNCTION_TYPE_GSETRANGE,
  FUNCTION_TYPE_GGETOFFSET,
  FUNCTION_TYPE_GSETOFFSET,
  FUNCTION_TYPE_GGETSCALE,
  FUNCTION_TYPE_GSETSCALE,
  FUNCTION_TYPE_GGETDOTOFFSET,
  FUNCTION_TYPE_GSETDOTOFFSET,
  FUNCTION_TYPE_GGETDOTSIZE,
  FUNCTION_TYPE_GSETDOTSIZE,
  FUNCTION_TYPE_GGETCOLOR,
  FUNCTION_TYPE_GSETCOLOR,
  FUNCTION_TYPE_GGETPIXEL,
  FUNCTION_TYPE_GCLEAR,
  FUNCTION_TYPE_GSCROLL,
  FUNCTION_TYPE_GDOT,
  FUNCTION_TYPE_GLINE,
  FUNCTION_TYPE_GBOX,
  FUNCTION_TYPE_GCIRCLE,
  FUNCTION_TYPE_GPAINT,
  FUNCTION_TYPE_GCOPY,
  FUNCTION_TYPE_GROTATE,
  FUNCTION_TYPE_GCHAR,
  FUNCTION_TYPE_GPRINT,
  FUNCTION_TYPE_GINKEY,
  FUNCTION_TYPE_GKEYSTAT,
  FUNCTION_TYPE_GMOUSEPOS,
  FUNCTION_TYPE_GINMOUSE,
  FUNCTION_TYPE_GMOUSESTAT,
  FUNCTION_TYPE_GALLOCIMAGE,
  FUNCTION_TYPE_GFREEIMAGE,
  FUNCTION_TYPE_GLOADIMAGE,
  FUNCTION_TYPE_GSAVEIMAGE,
  FUNCTION_TYPE_GCMPIMAGE,
  FUNCTION_TYPE_GCHARSET,
  FUNCTION_TYPE_ASTOP,
  FUNCTION_TYPE_ACLEAR,
  FUNCTION_TYPE_ASOUND,
  FUNCTION_TYPE_ASNDSTAT,
  FUNCTION_TYPE_APLAYNUM,
  FUNCTION_TYPE_AWAIT,
  FUNCTION_TYPE_AUNITSET,
  FUNCTION_TYPE_AUNIT,
  FUNCTION_TYPE_AOSC,
  FUNCTION_TYPE_AADDOUT,
  FUNCTION_TYPE_AENVPOINT,
  FUNCTION_TYPE_AENVCOPY,
  FUNCTION_TYPE_AFILPOINT,
  FUNCTION_TYPE_AFILCOPY,
  FUNCTION_TYPE_APLAY,
  FUNCTION_TYPE_AOPEN,
  FUNCTION_TYPE_ACLOSE,
};

const char *function_name(function_t function);
int function_search(const char *name, function_t *functionp);
int function_list(FILE *fp);
int function_proc(function_t function, value_t *valuep, value_t args);
# 49 "function.c" 2
# 1 "function-ext.h" 1
# 50 "function.c" 2
# 1 "libprintf.h" 1



int nll_sprintf(char *str, int size, const char *format, value_t args);
# 51 "function.c" 2
# 1 "fileid.h" 1



typedef int fileid_id_t;

int fileid_init(void);
int fileid_done(void);
int fileid_check(void);
FILE *fileid_get_fp(fileid_id_t id);
int fileid_set_fp(fileid_id_t id, FILE *fp);
int fileid_destroy(fileid_id_t id);
fileid_id_t fileid_create(FILE *fp);
# 52 "function.c" 2
# 1 "queueid.h" 1



typedef int queueid_index_t;

int queueid_init(void);
int queueid_done(void);
int queueid_check(void);

int queueid_number(queueid_index_t index);
int queueid_headin(queueid_index_t index, value_t value);
int queueid_tailin(queueid_index_t index, value_t value);
int queueid_headout(queueid_index_t index, value_t value);
int queueid_tailout(queueid_index_t index, value_t value);

int queueid_destroy(queueid_index_t index);
queueid_index_t queueid_create(void);
# 53 "function.c" 2
# 1 "key.h" 1



typedef enum {
  KEY_CODE_NONE = 0,

  KEY_CODE_ENTER = '\n',
  KEY_CODE_ESCAPE = 0x1b,
  KEY_CODE_BACKSPACE = '\b',
  KEY_CODE_TAB = '\t',
  KEY_CODE_SPACE = ' ',
  KEY_CODE_EXCLAIM = '!',
  KEY_CODE_QUOTEDBL = '"',
  KEY_CODE_HASH = '#',
  KEY_CODE_PERCENT = '%',
  KEY_CODE_DOLLAR = '$',
  KEY_CODE_AMPERSAND = '&',
  KEY_CODE_QUOTE = '\'',
  KEY_CODE_LEFTPAREN = '(',
  KEY_CODE_RIGHTPAREN = ')',
  KEY_CODE_ASTERISK = '*',
  KEY_CODE_PLUS = '+',
  KEY_CODE_COMMA = ',',
  KEY_CODE_MINUS = '-',
  KEY_CODE_PERIOD = '.',
  KEY_CODE_SLASH = '/',
  KEY_CODE_0 = '0',
  KEY_CODE_1 = '1',
  KEY_CODE_2 = '2',
  KEY_CODE_3 = '3',
  KEY_CODE_4 = '4',
  KEY_CODE_5 = '5',
  KEY_CODE_6 = '6',
  KEY_CODE_7 = '7',
  KEY_CODE_8 = '8',
  KEY_CODE_9 = '9',
  KEY_CODE_COLON = ':',
  KEY_CODE_SEMICOLON = ';',
  KEY_CODE_LESS = '<',
  KEY_CODE_EQUALS = '=',
  KEY_CODE_GREATER = '>',
  KEY_CODE_QUESTION = '?',
  KEY_CODE_AT = '@',
  KEY_CODE_LEFTBRACKET = '[',
  KEY_CODE_BACKSLASH = '\\',
  KEY_CODE_RIGHTBRACKET = ']',
  KEY_CODE_CARET = '^',
  KEY_CODE_UNDERSCORE = '_',
  KEY_CODE_BACKQUOTE = '`',
  KEY_CODE_A = 'a',
  KEY_CODE_B = 'b',
  KEY_CODE_C = 'c',
  KEY_CODE_D = 'd',
  KEY_CODE_E = 'e',
  KEY_CODE_F = 'f',
  KEY_CODE_G = 'g',
  KEY_CODE_H = 'h',
  KEY_CODE_I = 'i',
  KEY_CODE_J = 'j',
  KEY_CODE_K = 'k',
  KEY_CODE_L = 'l',
  KEY_CODE_M = 'm',
  KEY_CODE_N = 'n',
  KEY_CODE_O = 'o',
  KEY_CODE_P = 'p',
  KEY_CODE_Q = 'q',
  KEY_CODE_R = 'r',
  KEY_CODE_S = 's',
  KEY_CODE_T = 't',
  KEY_CODE_U = 'u',
  KEY_CODE_V = 'v',
  KEY_CODE_W = 'w',
  KEY_CODE_X = 'x',
  KEY_CODE_Y = 'y',
  KEY_CODE_Z = 'z',

  KEY_CODE_CAPSLOCK = 128,
  KEY_CODE_F1,
  KEY_CODE_F2,
  KEY_CODE_F3,
  KEY_CODE_F4,
  KEY_CODE_F5,
  KEY_CODE_F6,
  KEY_CODE_F7,
  KEY_CODE_F8,
  KEY_CODE_F9,
  KEY_CODE_F10,
  KEY_CODE_F11,
  KEY_CODE_F12,

  KEY_CODE_PRINTSCREEN,
  KEY_CODE_SCROLLLOCK,
  KEY_CODE_PAUSE,
  KEY_CODE_INSERT,
  KEY_CODE_HOME,
  KEY_CODE_PAGEUP,
  KEY_CODE_DELETE,
  KEY_CODE_END,
  KEY_CODE_PAGEDOWN,
  KEY_CODE_RIGHT,
  KEY_CODE_LEFT,
  KEY_CODE_DOWN,
  KEY_CODE_UP,

  KEY_CODE_F13,
  KEY_CODE_F14,
  KEY_CODE_F15,

  KEY_CODE_LCTRL,
  KEY_CODE_LSHIFT,
  KEY_CODE_LALT,
  KEY_CODE_RCTRL,
  KEY_CODE_RSHIFT,
  KEY_CODE_RALT,

  KEY_CODE_NUM
} key_code_t;
# 228 "key.h"
const char *keyname_get(key_code_t code);
key_code_t keycode_get(const char *name);
# 54 "function.c" 2
# 1 "mouse.h" 1



typedef enum {
  MOUSE_CODE_NONE = 0,

  MOUSE_CODE_RIGHT,
  MOUSE_CODE_LEFT,
  MOUSE_CODE_MIDDLE,

  MOUSE_CODE_NUM
} mouse_code_t;





const char *mousename_get(mouse_code_t code);
mouse_code_t mousecode_get(const char *name);
# 55 "function.c" 2
# 1 "framebuf.h" 1



int framebuf_get_screen_flags(void);
int framebuf_get_screen_width(void);
int framebuf_get_screen_height(void);
int framebuf_get_cursor_x(void);
int framebuf_get_cursor_y(void);
int framebuf_get_cursor_effect(void);
int framebuf_get_cursor_fgcolor(void);
int framebuf_get_cursor_bgcolor(void);
int framebuf_init(void);
int framebuf_done(void);
int framebuf_setscreen(int flags, int width, int height);
int framebuf_enable(int enable);
int framebuf_cursor_on(void);
int framebuf_cursor_off(void);
int framebuf_flush(int flags);
int framebuf_seteffect(int effect);
int framebuf_setfgcolor(int color);
int framebuf_setbgcolor(int color);
int framebuf_move_cursor(int x, int y);
int framebuf_move_left(int num);
int framebuf_move_right(int num);
int framebuf_move_up(int num);
int framebuf_move_down(int num);
int framebuf_getch(int x, int y);
int framebuf_clear(int chara, int flags);
int framebuf_scroll(int x, int y, int chara);
int framebuf_puts(const char *str);
int framebuf_line(int x0, int y0, int x1, int y1, const char *str);
int framebuf_box(int x0, int y0, int x1, int y1, const char *str, int flags);
key_code_t framebuf_getkey(void);
# 56 "function.c" 2
# 1 "graphic.h" 1



int graphic_color(int red, int green, int blue);
int graphic_rgb(int color, int *redp, int *greenp, int *bluep);
int graphic_get_screen_flags(void);
int graphic_get_screen_width(void);
int graphic_get_screen_height(void);
int graphic_get_screen_image(void);
int graphic_check(void);
int graphic_init(void);
int graphic_done(void);
int graphic_setscreen(int flags, int width, int height, int index);
int graphic_sync(void);
int graphic_enable(int enable);
int graphic_flush(int flags);
int graphic_getmainimage(void);
int graphic_setmainimage(int index);
int graphic_getwidth(int index);
int graphic_getheight(int index);
int graphic_getrange(int index, int *xp, int *yp, int *widthp, int *heightp, int *mulxp, int *mulyp);
int graphic_setrange(int index, int x, int y, int width, int height, int mulx, int muly);
int graphic_getoffset(int index, int *xp, int *yp);
int graphic_setoffset(int index, int x, int y);
int graphic_getscale(int index, int *mulxp, int *mulyp, int *divxp, int *divyp);
int graphic_setscale(int index, int mulx, int muly, int divx, int divy);
int graphic_getdotoffset(int index, int *xp, int *yp);
int graphic_setdotoffset(int index, int x, int y);
int graphic_getdotsize(int index, int *widthp, int *heightp);
int graphic_setdotsize(int index, int width, int height);
int graphic_getcolor(int index, int *colorp, int *fgcolorp, int *bgcolorp, int *fromcolorp, int *tocolorp);
int graphic_setcolor(int index, int color, int fgcolor, int bgcolor, int fromcolor, int tocolor, int flags);
int graphic_getpixel(int index, int x, int y);
int graphic_keydown(key_code_t code);
int graphic_keyup(key_code_t code);
int graphic_mousemotion(int x, int y);
int graphic_mousebuttondown(mouse_code_t code, int x, int y);
int graphic_mousebuttonup(mouse_code_t code);
int graphic_clear(int index, int color, int flags);
int graphic_scroll(int index, int x, int y, int color, int flags);
int graphic_dot(int index, int x, int y, int color, int flags);
int graphic_line(int index, int x0, int y0, int x1, int y1, int color, int flags);
int graphic_box(int index, int x0, int y0, int x1, int y1, int color, int flags);
int graphic_circle(int index, int x, int y, int rx, int ry, int color, int flags);
int graphic_paint(int index, int x, int y, int color, int border, int flags);
int graphic_copy(int index, int x0, int y0, int width0, int height0, int source, int x, int y, int width, int height, int flags);
int graphic_rotate(int index, int x, int y, int width, int height, int cx, int cy, int num, int color, int flags);
int graphic_char(int index, int x, int y, int width, int height, int ch, int type, int flags);
int graphic_print(int index, int x, int y, int width, int height, const char *string, int length, int type, int xgrid, int ygrid, int flags);
key_code_t graphic_getkeybuf(void);
int graphic_getkeystatus(key_code_t code);
int graphic_getmousepos(int *xp, int *yp);
mouse_code_t graphic_getmousebuf(int *xp, int *yp);
int graphic_getmousestatus(mouse_code_t code);
int graphic_allocimage(int width, int height, unsigned int flags);
int graphic_freeimage(int index);
int graphic_loadimage(char *filename, int *widthp, int *heightp, unsigned int flags);
int graphic_saveimage(char *filename, int index, int x, int y, int width, int height, unsigned int flags);
int graphic_cmpimage(int index, int x0, int y0, int width0, int height0, int source, int x, int y, int width, int height, int flags);
int graphic_charset(int type, int *widthp, int *heightp, int *nump, int flags);


int ext_graphic_init(void);
int ext_graphic_done(void);
int ext_graphic_start(int index);
int ext_graphic_stop(void);
# 57 "function.c" 2
# 1 "audio.h" 1



int audio_check(void);
int audio_init(void);
int audio_done(void);
int audio_stop(void);
int audio_clear(int aunitset_index);
int audio_clear_all(void);
int audio_getsamplefreq(void);
int audio_setsamplefreq(int samplefreq);
int audio_playnum(void);
int audio_wait(void);
int audio_unitset(int aunitset_index);
int audio_unit(int output, int amp, int flags, int aunitset_index);
int audio_osc(int index, int amp, int freq, int phase, int type, int mod, int flags, int aunitset_index);
int audio_addout(int index, int output, int amp, int flags, int aunitset_index);
int audio_envpoint(int index, int n, int step, int amp, int flags, int aunitset_index);
int audio_envcopy(int index, int source, int flags, int aunitset_index);
int audio_filpoint(int index, int type, int n, int amp, int flags, int aunitset_index);
int audio_filcopy(int index, int source, int flags, int aunitset_index);
int audio_play(const char *mml, int flags, int aunitset_index, const char *filename);
int audio_open(char *filename, int *lengthp, unsigned int flags);
int audio_close(int index);


typedef int (*ext_audio_callback_t)(int channels, int samples, short *buffer, void *arg);
int ext_audio_init(void);
int ext_audio_done(void);
int ext_audio_run(int freq, int channels, int samples, ext_audio_callback_t callback, void *arg);
int ext_audio_stop(void);
int ext_audio_wait(void);
# 58 "function.c" 2

static int function_fargs(value_t *valuep, value_t args);
static int function_copy(value_t *valuep, value_t args);
static int function_true(value_t *valuep, value_t args);
static int function_false(value_t *valuep, value_t args);
static int function_argnum(value_t *valuep, value_t args);
static int function_boolean(value_t *valuep, value_t args);
static int function_cond(value_t *valuep, value_t args);
static int function_at(value_t *valuep, value_t args);
static int function_fpush(value_t *valuep, value_t args);
static int function_fpop(value_t *valuep, value_t args);
static int function_stacknum(value_t *valuep, value_t args);
static int function_fprint(value_t *valuep, value_t args);
static int function_sprintf(value_t *valuep, value_t args);
static int function_printf(value_t *valuep, value_t args);
static int function_printm(value_t *valuep, value_t args);
static int function_input(value_t *valuep, value_t args);
static int function_inputn(value_t *valuep, value_t args);
static int function_fwait(value_t *valuep, value_t args);
static int function_timer(value_t *valuep, value_t args);
static int function_nosystem(value_t *valuep, value_t args);
static int function_nosyscall(value_t *valuep, value_t args);
static int function_nonetwork(value_t *valuep, value_t args);





static int function_system(value_t *valuep, value_t args);


static int function_syscall(value_t *valuep, value_t args);

static int function_feval(value_t *valuep, value_t args);
static int function_fevalf(value_t *valuep, value_t args);
static int function_typeof(value_t *valuep, value_t args);
static int function_typename(value_t *valuep, value_t args);
static int function_sizeof(value_t *valuep, value_t args);
static int function_nzero(value_t *valuep, value_t args);
static int function_cmp(value_t *valuep, value_t args);
static int function_rep(value_t *valuep, value_t args);
static int function_insert(value_t *valuep, value_t args);
static int function_delete(value_t *valuep, value_t args);
static int function_itoc(value_t *valuep, value_t args);
static int function_ctoi(value_t *valuep, value_t args);
static int function_itoa(value_t *valuep, value_t args);
static int function_atoi(value_t *valuep, value_t args);

static int function_itof(value_t *valuep, value_t args);
static int function_ftoi(value_t *valuep, value_t args);
static int function_atof(value_t *valuep, value_t args);
static int function_ftoa(value_t *valuep, value_t args);

static int function_isalnum(value_t *valuep, value_t args);
static int function_isalpha(value_t *valuep, value_t args);
static int function_isascii(value_t *valuep, value_t args);
static int function_iscntrl(value_t *valuep, value_t args);
static int function_isdigit(value_t *valuep, value_t args);
static int function_isgraph(value_t *valuep, value_t args);
static int function_islower(value_t *valuep, value_t args);
static int function_isprint(value_t *valuep, value_t args);
static int function_ispunct(value_t *valuep, value_t args);
static int function_isspace(value_t *valuep, value_t args);
static int function_isupper(value_t *valuep, value_t args);
static int function_isxdigit(value_t *valuep, value_t args);
static int function_tolower(value_t *valuep, value_t args);
static int function_toupper(value_t *valuep, value_t args);
static int function_left(value_t *valuep, value_t args);
static int function_right(value_t *valuep, value_t args);
static int function_mid(value_t *valuep, value_t args);
static int function_instr(value_t *valuep, value_t args);
static int function_strlen(value_t *valuep, value_t args);
static int function_strcpy(value_t *valuep, value_t args);
static int function_split(value_t *valuep, value_t args);
static int function_splits(value_t *valuep, value_t args);
static int function_chomp(value_t *valuep, value_t args);
static int function_lchomp(value_t *valuep, value_t args);
static int function_rchomp(value_t *valuep, value_t args);
static int function_srand(value_t *valuep, value_t args);
static int function_rand(value_t *valuep, value_t args);
static int function_int(value_t *valuep, value_t args);
static int function_abs(value_t *valuep, value_t args);
static int function_sign(value_t *valuep, value_t args);
static int function_max(value_t *valuep, value_t args);
static int function_min(value_t *valuep, value_t args);
static int function_abs2sum(value_t *valuep, value_t args);
static int function_time(value_t *valuep, value_t args);
static int function_date(value_t *valuep, value_t args);
static int function_fdim(value_t *valuep, value_t args);
static int function_fmemory(value_t *valuep, value_t args);
static int function_peek(value_t *valuep, value_t args);
static int function_poke(value_t *valuep, value_t args);
static int function_mread(value_t *valuep, value_t args);
static int function_mwrite(value_t *valuep, value_t args);
static int function_mcopy(value_t *valuep, value_t args);
# 180 "function.c"
static int function_rename(value_t *valuep, value_t args);
static int function_unlink(value_t *valuep, value_t args);
static int function_truncate(value_t *valuep, value_t args);
static int function_mkdir(value_t *valuep, value_t args);
static int function_rmdir(value_t *valuep, value_t args);
static int function_chdir(value_t *valuep, value_t args);
static int function_open(value_t *valuep, value_t args);
static int function_close(value_t *valuep, value_t args);
static int function_read(value_t *valuep, value_t args);
static int function_write(value_t *valuep, value_t args);
static int function_lseek(value_t *valuep, value_t args);
static int function_ftruncate(value_t *valuep, value_t args);
static int function_isreadable(value_t *valuep, value_t args);
static int function_iswritable(value_t *valuep, value_t args);
static int function_fopen(value_t *valuep, value_t args);
static int function_fdopen(value_t *valuep, value_t args);
static int function_fclose(value_t *valuep, value_t args);
static int function_fileno(value_t *valuep, value_t args);
static int function_feof(value_t *valuep, value_t args);
static int function_ferror(value_t *valuep, value_t args);
static int function_fgetc(value_t *valuep, value_t args);
static int function_fputc(value_t *valuep, value_t args);
static int function_fgets(value_t *valuep, value_t args);
static int function_fputs(value_t *valuep, value_t args);
static int function_fprintf(value_t *valuep, value_t args);
static int function_fread(value_t *valuep, value_t args);
static int function_fwrite(value_t *valuep, value_t args);
static int function_fseek(value_t *valuep, value_t args);
static int function_qopen(value_t *valuep, value_t args);
static int function_qclose(value_t *valuep, value_t args);
static int function_qlength(value_t *valuep, value_t args);
static int function_qpushf(value_t *valuep, value_t args);
static int function_qpopl(value_t *valuep, value_t args);
static int function_qpushl(value_t *valuep, value_t args);
static int function_qpopf(value_t *valuep, value_t args);
# 228 "function.c"
static int function_keyname(value_t *valuep, value_t args);
static int function_keycode(value_t *valuep, value_t args);
static int function_screen(value_t *valuep, value_t args);
static int function_scrstat(value_t *valuep, value_t args);
static int function_flush(value_t *valuep, value_t args);
static int function_getcolor(value_t *valuep, value_t args);
static int function_getfgcolor(value_t *valuep, value_t args);
static int function_getbgcolor(value_t *valuep, value_t args);
static int function_setcolor(value_t *valuep, value_t args);
static int function_getattr(value_t *valuep, value_t args);
static int function_setattr(value_t *valuep, value_t args);
static int function_getpos(value_t *valuep, value_t args);
static int function_move(value_t *valuep, value_t args);
static int function_getch(value_t *valuep, value_t args);
static int function_clear(value_t *valuep, value_t args);
static int function_scroll(value_t *valuep, value_t args);
static int function_line(value_t *valuep, value_t args);
static int function_box(value_t *valuep, value_t args);
static int function_inkey(value_t *valuep, value_t args);
static int function_gscreen(value_t *valuep, value_t args);
static int function_gscrstat(value_t *valuep, value_t args);
static int function_gcolor(value_t *valuep, value_t args);
static int function_grgb(value_t *valuep, value_t args);
static int function_gsync(value_t *valuep, value_t args);
static int function_gflush(value_t *valuep, value_t args);
static int function_ggetmainimg(value_t *valuep, value_t args);
static int function_gsetmainimg(value_t *valuep, value_t args);
static int function_ggetsize(value_t *valuep, value_t args);
static int function_ggetrange(value_t *valuep, value_t args);
static int function_gsetrange(value_t *valuep, value_t args);
static int function_ggetoffset(value_t *valuep, value_t args);
static int function_gsetoffset(value_t *valuep, value_t args);
static int function_ggetscale(value_t *valuep, value_t args);
static int function_gsetscale(value_t *valuep, value_t args);
static int function_ggetdotoffset(value_t *valuep, value_t args);
static int function_gsetdotoffset(value_t *valuep, value_t args);
static int function_ggetdotsize(value_t *valuep, value_t args);
static int function_gsetdotsize(value_t *valuep, value_t args);
static int function_ggetcolor(value_t *valuep, value_t args);
static int function_gsetcolor(value_t *valuep, value_t args);
static int function_ggetpixel(value_t *valuep, value_t args);
static int function_gclear(value_t *valuep, value_t args);
static int function_gscroll(value_t *valuep, value_t args);
static int function_gdot(value_t *valuep, value_t args);
static int function_gline(value_t *valuep, value_t args);
static int function_gbox(value_t *valuep, value_t args);
static int function_gcircle(value_t *valuep, value_t args);
static int function_gpaint(value_t *valuep, value_t args);
static int function_gcopy(value_t *valuep, value_t args);
static int function_grotate(value_t *valuep, value_t args);
static int function_gchar(value_t *valuep, value_t args);
static int function_gprint(value_t *valuep, value_t args);
static int function_ginkey(value_t *valuep, value_t args);
static int function_gkeystat(value_t *valuep, value_t args);
static int function_gmousepos(value_t *valuep, value_t args);
static int function_ginmouse(value_t *valuep, value_t args);
static int function_gmousestat(value_t *valuep, value_t args);
static int function_gallocimage(value_t *valuep, value_t args);
static int function_gfreeimage(value_t *valuep, value_t args);
static int function_gloadimage(value_t *valuep, value_t args);
static int function_gsaveimage(value_t *valuep, value_t args);
static int function_gcmpimage(value_t *valuep, value_t args);
static int function_gcharset(value_t *valuep, value_t args);
static int function_astop(value_t *valuep, value_t args);
static int function_aclear(value_t *valuep, value_t args);
static int function_asound(value_t *valuep, value_t args);
static int function_asndstat(value_t *valuep, value_t args);
static int function_aplaynum(value_t *valuep, value_t args);
static int function_await(value_t *valuep, value_t args);
static int function_aunitset(value_t *valuep, value_t args);
static int function_aunit(value_t *valuep, value_t args);
static int function_aosc(value_t *valuep, value_t args);
static int function_aaddout(value_t *valuep, value_t args);
static int function_aenvpoint(value_t *valuep, value_t args);
static int function_aenvcopy(value_t *valuep, value_t args);
static int function_afilpoint(value_t *valuep, value_t args);
static int function_afilcopy(value_t *valuep, value_t args);
static int function_aplay(value_t *valuep, value_t args);
static int function_aopen(value_t *valuep, value_t args);
static int function_aclose(value_t *valuep, value_t args);

static const struct function functions_orig[] = {
  { "FARGS" , "VALUE" , FUNCTION_TYPE_FARGS , function_fargs , (1 << 0) },
  { "COPY" , ((void *)0) , FUNCTION_TYPE_COPY , function_copy , (1 << 0) },
  { "TRUE" , ((void *)0) , FUNCTION_TYPE_TRUE , function_true , (1 << 0) },
  { "FALSE" , ((void *)0) , FUNCTION_TYPE_FALSE , function_false , (1 << 0) },
  { "ARGNUM" , ((void *)0) , FUNCTION_TYPE_ARGNUM , function_argnum , (1 << 0) },
  { "BOOLEAN" , ((void *)0) , FUNCTION_TYPE_BOOLEAN , function_boolean , (1 << 0) },
  { "COND" , ((void *)0) , FUNCTION_TYPE_COND , function_cond , (1 << 0) },
  { "AT" , ((void *)0) , FUNCTION_TYPE_AT , function_at , (1 << 0) },
  { "FPUSH" , "LOCAL" , FUNCTION_TYPE_FPUSH , function_fpush , 0 },
  { "FPOP" , "RESTORE", FUNCTION_TYPE_FPOP , function_fpop , 0 },
  { "STACKNUM" , ((void *)0) , FUNCTION_TYPE_STACKNUM , function_stacknum , 0 },
  { "FPRINT" , ((void *)0) , FUNCTION_TYPE_FPRINT , function_fprint , 0 },
  { "SPRINTF" , ((void *)0) , FUNCTION_TYPE_SPRINTF , function_sprintf , 0 },
  { "PRINTF" , ((void *)0) , FUNCTION_TYPE_PRINTF , function_printf , 0 },
  { "PRINTM" , ((void *)0) , FUNCTION_TYPE_PRINTM , function_printm , 0 },
  { "INPUT" , ((void *)0) , FUNCTION_TYPE_INPUT , function_input , 0 },
  { "INPUTN" , ((void *)0) , FUNCTION_TYPE_INPUTN , function_inputn , 0 },
  { "FWAIT" , ((void *)0) , FUNCTION_TYPE_FWAIT , function_fwait , 0 },
  { "TIMER" , ((void *)0) , FUNCTION_TYPE_TIMER , function_timer , 0 },
  { "NOSYSTEM" , ((void *)0) , FUNCTION_TYPE_NOSYSTEM , function_nosystem , 0 },
  { "NOSYSCALL" , ((void *)0) , FUNCTION_TYPE_NOSYSCALL , function_nosyscall , 0 },
  { "NONETWORK" , ((void *)0) , FUNCTION_TYPE_NONETWORK , function_nonetwork , 0 },





  { "SYSTEM" , ((void *)0) , FUNCTION_TYPE_SYSTEM , function_system , 0 },


  { "SYSCALL" , ((void *)0) , FUNCTION_TYPE_SYSCALL , function_syscall , 0 },

  { "FEVAL" , ((void *)0) , FUNCTION_TYPE_FEVAL , function_feval , 0 },
  { "FEVALF" , ((void *)0) , FUNCTION_TYPE_FEVALF , function_fevalf , 0 },
  { "TYPEOF" , ((void *)0) , FUNCTION_TYPE_TYPEOF , function_typeof , (1 << 0) },
  { "TYPENAME" , ((void *)0) , FUNCTION_TYPE_TYPENAME , function_typename , (1 << 0) },
  { "SIZEOF" , ((void *)0) , FUNCTION_TYPE_SIZEOF , function_sizeof , (1 << 0) },
  { "NZERO" , ((void *)0) , FUNCTION_TYPE_NZERO , function_nzero , (1 << 0) },
  { "CMP" , ((void *)0) , FUNCTION_TYPE_CMP , function_cmp , (1 << 0) },
  { "REP" , ((void *)0) , FUNCTION_TYPE_REP , function_rep , (1 << 0) },
  { "INSERT" , ((void *)0) , FUNCTION_TYPE_INSERT , function_insert , (1 << 0) },
  { "DELETE" , ((void *)0) , FUNCTION_TYPE_DELETE , function_delete , (1 << 0) },
  { "ITOC" , "CHAR" , FUNCTION_TYPE_ITOC , function_itoc , (1 << 0) },
  { "CTOI" , "ASCII" , FUNCTION_TYPE_CTOI , function_ctoi , (1 << 0) },
  { "ITOA" , "STR" , FUNCTION_TYPE_ITOA , function_itoa , (1 << 0) },
  { "ATOI" , "VAL" , FUNCTION_TYPE_ATOI , function_atoi , (1 << 0) },

  { "ITOF" , ((void *)0) , FUNCTION_TYPE_ITOF , function_itof , (1 << 0) },
  { "FTOI" , ((void *)0) , FUNCTION_TYPE_FTOI , function_ftoi , (1 << 0) },
  { "ATOF" , ((void *)0) , FUNCTION_TYPE_ATOF , function_atof , (1 << 0) },
  { "FTOA" , ((void *)0) , FUNCTION_TYPE_FTOA , function_ftoa , (1 << 0) },

  { "ISALNUM" , ((void *)0) , FUNCTION_TYPE_ISALNUM , function_isalnum , (1 << 0) },
  { "ISALPHA" , ((void *)0) , FUNCTION_TYPE_ISALPHA , function_isalpha , (1 << 0) },
  { "ISASCII" , ((void *)0) , FUNCTION_TYPE_ISASCII , function_isascii , (1 << 0) },
  { "ISCNTRL" , ((void *)0) , FUNCTION_TYPE_ISCNTRL , function_iscntrl , (1 << 0) },
  { "ISDIGIT" , ((void *)0) , FUNCTION_TYPE_ISDIGIT , function_isdigit , (1 << 0) },
  { "ISGRAPH" , ((void *)0) , FUNCTION_TYPE_ISGRAPH , function_isgraph , (1 << 0) },
  { "ISLOWER" , ((void *)0) , FUNCTION_TYPE_ISLOWER , function_islower , (1 << 0) },
  { "ISPRINT" , ((void *)0) , FUNCTION_TYPE_ISPRINT , function_isprint , (1 << 0) },
  { "ISPUNCT" , ((void *)0) , FUNCTION_TYPE_ISPUNCT , function_ispunct , (1 << 0) },
  { "ISSPACE" , ((void *)0) , FUNCTION_TYPE_ISSPACE , function_isspace , (1 << 0) },
  { "ISUPPER" , ((void *)0) , FUNCTION_TYPE_ISUPPER , function_isupper , (1 << 0) },
  { "ISXDIGIT" , ((void *)0) , FUNCTION_TYPE_ISXDIGIT , function_isxdigit , (1 << 0) },
  { "TOLOWER" , ((void *)0) , FUNCTION_TYPE_TOLOWER , function_tolower , (1 << 0) },
  { "TOUPPER" , ((void *)0) , FUNCTION_TYPE_TOUPPER , function_toupper , (1 << 0) },
  { "LEFT" , ((void *)0) , FUNCTION_TYPE_LEFT , function_left , (1 << 0) },
  { "RIGHT" , ((void *)0) , FUNCTION_TYPE_RIGHT , function_right , (1 << 0) },
  { "MID" , ((void *)0) , FUNCTION_TYPE_MID , function_mid , (1 << 0) },
  { "INSTR" , ((void *)0) , FUNCTION_TYPE_INSTR , function_instr , (1 << 0) },
  { "STRLEN" , ((void *)0) , FUNCTION_TYPE_STRLEN , function_strlen , (1 << 0) },
  { "STRCPY" , ((void *)0) , FUNCTION_TYPE_STRCPY , function_strcpy , (1 << 0) },
  { "SPLIT" , ((void *)0) , FUNCTION_TYPE_SPLIT , function_split , (1 << 0) },
  { "SPLITS" , ((void *)0) , FUNCTION_TYPE_SPLITS , function_splits , (1 << 0) },
  { "CHOMP" , ((void *)0) , FUNCTION_TYPE_CHOMP , function_chomp , (1 << 0) },
  { "LCHOMP" , ((void *)0) , FUNCTION_TYPE_LCHOMP , function_lchomp , (1 << 0) },
  { "RCHOMP" , ((void *)0) , FUNCTION_TYPE_RCHOMP , function_rchomp , (1 << 0) },
  { "SRAND" , ((void *)0) , FUNCTION_TYPE_SRAND , function_srand , 0 },
  { "RAND" , "RND" , FUNCTION_TYPE_RAND , function_rand , 0 },
  { "INT" , ((void *)0) , FUNCTION_TYPE_INT , function_int , (1 << 0) },
  { "ABS" , ((void *)0) , FUNCTION_TYPE_ABS , function_abs , (1 << 0) },
  { "SIGN" , "SGN" , FUNCTION_TYPE_SIGN , function_sign , (1 << 0) },
  { "MAX" , ((void *)0) , FUNCTION_TYPE_MAX , function_max , (1 << 0) },
  { "MIN" , ((void *)0) , FUNCTION_TYPE_MIN , function_min , (1 << 0) },
  { "ABS2SUM" , ((void *)0) , FUNCTION_TYPE_ABS2SUM , function_abs2sum , (1 << 0) },
  { "TIME" , ((void *)0) , FUNCTION_TYPE_TIME , function_time , 0 },
  { "DATE" , ((void *)0) , FUNCTION_TYPE_DATE , function_date , 0 },
  { "FDIM" , ((void *)0) , FUNCTION_TYPE_FDIM , function_fdim , 0 },
  { "FMEMORY" , ((void *)0) , FUNCTION_TYPE_FMEMORY , function_fmemory , 0 },
  { "PEEK" , ((void *)0) , FUNCTION_TYPE_PEEK , function_peek , 0 },
  { "POKE" , ((void *)0) , FUNCTION_TYPE_POKE , function_poke , 0 },
  { "MREAD" , ((void *)0) , FUNCTION_TYPE_MREAD , function_mread , 0 },
  { "MWRITE" , ((void *)0) , FUNCTION_TYPE_MWRITE , function_mwrite , 0 },
  { "MCOPY" , "MEMCPY" , FUNCTION_TYPE_MCOPY , function_mcopy , 0 },
# 431 "function.c"
  { "RENAME" , ((void *)0) , FUNCTION_TYPE_RENAME , function_rename , 0 },
  { "UNLINK" , ((void *)0) , FUNCTION_TYPE_UNLINK , function_unlink , 0 },
  { "TRUNCATE" , ((void *)0) , FUNCTION_TYPE_TRUNCATE , function_truncate , 0 },
  { "MKDIR" , ((void *)0) , FUNCTION_TYPE_MKDIR , function_mkdir , 0 },
  { "RMDIR" , ((void *)0) , FUNCTION_TYPE_RMDIR , function_rmdir , 0 },
  { "CHDIR" , ((void *)0) , FUNCTION_TYPE_CHDIR , function_chdir , 0 },
  { "OPEN" , ((void *)0) , FUNCTION_TYPE_OPEN , function_open , 0 },
  { "CLOSE" , ((void *)0) , FUNCTION_TYPE_CLOSE , function_close , 0 },
  { "READ" , ((void *)0) , FUNCTION_TYPE_READ , function_read , 0 },
  { "WRITE" , ((void *)0) , FUNCTION_TYPE_WRITE , function_write , 0 },
  { "LSEEK" , ((void *)0) , FUNCTION_TYPE_LSEEK , function_lseek , 0 },
  { "FTRUNCATE" , ((void *)0) , FUNCTION_TYPE_FTRUNCATE , function_ftruncate , 0 },
  { "ISREADABLE" , ((void *)0) , FUNCTION_TYPE_ISREADABLE , function_isreadable , 0 },
  { "ISWRITABLE" , ((void *)0) , FUNCTION_TYPE_ISWRITABLE , function_iswritable , 0 },
  { "FOPEN" , ((void *)0) , FUNCTION_TYPE_FOPEN , function_fopen , 0 },
  { "FDOPEN" , ((void *)0) , FUNCTION_TYPE_FDOPEN , function_fdopen , 0 },
  { "FCLOSE" , ((void *)0) , FUNCTION_TYPE_FCLOSE , function_fclose , 0 },
  { "FILENO" , ((void *)0) , FUNCTION_TYPE_FILENO , function_fileno , 0 },
  { "FEOF" , ((void *)0) , FUNCTION_TYPE_FEOF , function_feof , 0 },
  { "FERROR" , ((void *)0) , FUNCTION_TYPE_FERROR , function_ferror , 0 },
  { "FGETC" , ((void *)0) , FUNCTION_TYPE_FGETC , function_fgetc , 0 },
  { "FPUTC" , ((void *)0) , FUNCTION_TYPE_FPUTC , function_fputc , 0 },
  { "FGETS" , ((void *)0) , FUNCTION_TYPE_FGETS , function_fgets , 0 },
  { "FPUTS" , ((void *)0) , FUNCTION_TYPE_FPUTS , function_fputs , 0 },
  { "FPRINTF" , ((void *)0) , FUNCTION_TYPE_FPRINTF , function_fprintf , 0 },
  { "FREAD" , ((void *)0) , FUNCTION_TYPE_FREAD , function_fread , 0 },
  { "FWRITE" , ((void *)0) , FUNCTION_TYPE_FWRITE , function_fwrite , 0 },
  { "FSEEK" , ((void *)0) , FUNCTION_TYPE_FSEEK , function_fseek , 0 },
  { "QOPEN" , ((void *)0) , FUNCTION_TYPE_QOPEN , function_qopen , 0 },
  { "QCLOSE" , ((void *)0) , FUNCTION_TYPE_QCLOSE , function_qclose , 0 },
  { "QLENGTH" , "QLEN" , FUNCTION_TYPE_QLENGTH , function_qlength , 0 },
  { "QPUSHF" , "QPUSH" , FUNCTION_TYPE_QPUSHF , function_qpushf , 0 },
  { "QPOPL" , "QPOP" , FUNCTION_TYPE_QPOPL , function_qpopl , 0 },
  { "QPUSHL" , ((void *)0) , FUNCTION_TYPE_QPUSHL , function_qpushl , 0 },
  { "QPOPF" , ((void *)0) , FUNCTION_TYPE_QPOPF , function_qpopf , 0 },
# 479 "function.c"
  { "KEYNAME" , ((void *)0) , FUNCTION_TYPE_KEYNAME , function_keyname , (1 << 0) },
  { "KEYCODE" , ((void *)0) , FUNCTION_TYPE_KEYCODE , function_keycode , (1 << 0) },
  { "SCREEN" , ((void *)0) , FUNCTION_TYPE_SCREEN , function_screen , 0 },
  { "SCRSTAT" , ((void *)0) , FUNCTION_TYPE_SCRSTAT , function_scrstat , 0 },
  { "FLUSH" , ((void *)0) , FUNCTION_TYPE_FLUSH , function_flush , 0 },
  { "GETCOLOR" , ((void *)0) , FUNCTION_TYPE_GETCOLOR , function_getcolor , 0 },
  { "GETFGCOLOR" , ((void *)0) , FUNCTION_TYPE_GETFGCOLOR , function_getfgcolor , 0 },
  { "GETBGCOLOR" , ((void *)0) , FUNCTION_TYPE_GETBGCOLOR , function_getbgcolor , 0 },
  { "SETCOLOR" , ((void *)0) , FUNCTION_TYPE_SETCOLOR , function_setcolor , 0 },
  { "GETATTR" , ((void *)0) , FUNCTION_TYPE_GETATTR , function_getattr , 0 },
  { "SETATTR" , ((void *)0) , FUNCTION_TYPE_SETATTR , function_setattr , 0 },
  { "GETPOS" , ((void *)0) , FUNCTION_TYPE_GETPOS , function_getpos , 0 },
  { "MOVE" , ((void *)0) , FUNCTION_TYPE_MOVE , function_move , 0 },
  { "GETCH" , ((void *)0) , FUNCTION_TYPE_GETCH , function_getch , 0 },
  { "CLEAR" , ((void *)0) , FUNCTION_TYPE_CLEAR , function_clear , 0 },
  { "SCROLL" , ((void *)0) , FUNCTION_TYPE_SCROLL , function_scroll , 0 },
  { "LINE" , ((void *)0) , FUNCTION_TYPE_LINE , function_line , 0 },
  { "BOX" , ((void *)0) , FUNCTION_TYPE_BOX , function_box , 0 },
  { "INKEY" , "KEY" , FUNCTION_TYPE_INKEY , function_inkey , 0 },
  { "GSCREEN" , ((void *)0) , FUNCTION_TYPE_GSCREEN , function_gscreen , 0 },
  { "GSCRSTAT" , ((void *)0) , FUNCTION_TYPE_GSCRSTAT , function_gscrstat , 0 },
  { "GCOLOR" , ((void *)0) , FUNCTION_TYPE_GCOLOR , function_gcolor , 0 },
  { "GRGB" , ((void *)0) , FUNCTION_TYPE_GRGB , function_grgb , 0 },
  { "GSYNC" , ((void *)0) , FUNCTION_TYPE_GSYNC , function_gsync , 0 },
  { "GFLUSH" , ((void *)0) , FUNCTION_TYPE_GFLUSH , function_gflush , 0 },
  { "GGETMAINIMG", ((void *)0) , FUNCTION_TYPE_GGETMAINIMG, function_ggetmainimg, 0 },
  { "GSETMAINIMG", ((void *)0) , FUNCTION_TYPE_GSETMAINIMG, function_gsetmainimg, 0 },
  { "GGETSIZE" , ((void *)0) , FUNCTION_TYPE_GGETSIZE , function_ggetsize , 0 },
  { "GGETRANGE" , ((void *)0) , FUNCTION_TYPE_GGETRANGE , function_ggetrange , 0 },
  { "GSETRANGE" , ((void *)0) , FUNCTION_TYPE_GSETRANGE , function_gsetrange , 0 },
  { "GGETOFFSET" , ((void *)0) , FUNCTION_TYPE_GGETOFFSET , function_ggetoffset , 0 },
  { "GSETOFFSET" , ((void *)0) , FUNCTION_TYPE_GSETOFFSET , function_gsetoffset , 0 },
  { "GGETSCALE" , ((void *)0) , FUNCTION_TYPE_GGETSCALE , function_ggetscale , 0 },
  { "GSETSCALE" , ((void *)0) , FUNCTION_TYPE_GSETSCALE , function_gsetscale , 0 },
  { "GGETDOTOFFSET", ((void *)0) , FUNCTION_TYPE_GGETDOTOFFSET, function_ggetdotoffset, 0 },
  { "GSETDOTOFFSET", ((void *)0) , FUNCTION_TYPE_GSETDOTOFFSET, function_gsetdotoffset, 0 },
  { "GGETDOTSIZE", ((void *)0) , FUNCTION_TYPE_GGETDOTSIZE, function_ggetdotsize, 0 },
  { "GSETDOTSIZE", ((void *)0) , FUNCTION_TYPE_GSETDOTSIZE, function_gsetdotsize, 0 },
  { "GGETCOLOR" , ((void *)0) , FUNCTION_TYPE_GGETCOLOR , function_ggetcolor , 0 },
  { "GSETCOLOR" , ((void *)0) , FUNCTION_TYPE_GSETCOLOR , function_gsetcolor , 0 },
  { "GGETPIXEL" , ((void *)0) , FUNCTION_TYPE_GGETPIXEL , function_ggetpixel , 0 },
  { "GCLEAR" , ((void *)0) , FUNCTION_TYPE_GCLEAR , function_gclear , 0 },
  { "GSCROLL" , ((void *)0) , FUNCTION_TYPE_GSCROLL , function_gscroll , 0 },
  { "GDOT" , "GPOINT" , FUNCTION_TYPE_GDOT , function_gdot , 0 },
  { "GLINE" , ((void *)0) , FUNCTION_TYPE_GLINE , function_gline , 0 },
  { "GBOX" , ((void *)0) , FUNCTION_TYPE_GBOX , function_gbox , 0 },
  { "GCIRCLE" , ((void *)0) , FUNCTION_TYPE_GCIRCLE , function_gcircle , 0 },
  { "GPAINT" , ((void *)0) , FUNCTION_TYPE_GPAINT , function_gpaint , 0 },
  { "GCOPY" , ((void *)0) , FUNCTION_TYPE_GCOPY , function_gcopy , 0 },
  { "GROTATE" , ((void *)0) , FUNCTION_TYPE_GROTATE , function_grotate , 0 },
  { "GCHAR" , ((void *)0) , FUNCTION_TYPE_GCHAR , function_gchar , 0 },
  { "GPRINT" , ((void *)0) , FUNCTION_TYPE_GPRINT , function_gprint , 0 },
  { "GINKEY" , "GKEY" , FUNCTION_TYPE_GINKEY , function_ginkey , 0 },
  { "GKEYSTAT" , ((void *)0) , FUNCTION_TYPE_GKEYSTAT , function_gkeystat , 0 },
  { "GMOUSEPOS" , ((void *)0) , FUNCTION_TYPE_GMOUSEPOS , function_gmousepos , 0 },
  { "GINMOUSE" , ((void *)0) , FUNCTION_TYPE_GINMOUSE , function_ginmouse , 0 },
  { "GMOUSESTAT" , ((void *)0) , FUNCTION_TYPE_GMOUSESTAT , function_gmousestat , 0 },
  { "GALLOCIMAGE", ((void *)0) , FUNCTION_TYPE_GALLOCIMAGE, function_gallocimage, 0 },
  { "GFREEIMAGE" , ((void *)0) , FUNCTION_TYPE_GFREEIMAGE , function_gfreeimage , 0 },
  { "GLOADIMAGE" , ((void *)0) , FUNCTION_TYPE_GLOADIMAGE , function_gloadimage , 0 },
  { "GSAVEIMAGE" , ((void *)0) , FUNCTION_TYPE_GSAVEIMAGE , function_gsaveimage , 0 },
  { "GCMPIMAGE" , ((void *)0) , FUNCTION_TYPE_GCMPIMAGE , function_gcmpimage , 0 },
  { "GCHARSET" , ((void *)0) , FUNCTION_TYPE_GCHARSET , function_gcharset , 0 },
  { "ASTOP" , ((void *)0) , FUNCTION_TYPE_ASTOP , function_astop , 0 },
  { "ACLEAR" , ((void *)0) , FUNCTION_TYPE_ACLEAR , function_aclear , 0 },
  { "ASOUND" , ((void *)0) , FUNCTION_TYPE_ASOUND , function_asound , 0 },
  { "ASNDSTAT" , ((void *)0) , FUNCTION_TYPE_ASNDSTAT , function_asndstat , 0 },
  { "APLAYNUM" , ((void *)0) , FUNCTION_TYPE_APLAYNUM , function_aplaynum , 0 },
  { "AWAIT" , ((void *)0) , FUNCTION_TYPE_AWAIT , function_await , 0 },
  { "AUNITSET" , ((void *)0) , FUNCTION_TYPE_AUNITSET , function_aunitset , 0 },
  { "AUNIT" , ((void *)0) , FUNCTION_TYPE_AUNIT , function_aunit , 0 },
  { "AOSC" , ((void *)0) , FUNCTION_TYPE_AOSC , function_aosc , 0 },
  { "AADDOUT" , ((void *)0) , FUNCTION_TYPE_AADDOUT , function_aaddout , 0 },
  { "AENVPOINT" , ((void *)0) , FUNCTION_TYPE_AENVPOINT , function_aenvpoint , 0 },
  { "AENVCOPY" , ((void *)0) , FUNCTION_TYPE_AENVCOPY , function_aenvcopy , 0 },
  { "AFILPOINT" , ((void *)0) , FUNCTION_TYPE_AFILPOINT , function_afilpoint , 0 },
  { "AFILCOPY" , ((void *)0) , FUNCTION_TYPE_AFILCOPY , function_afilcopy , 0 },
  { "APLAY" , ((void *)0) , FUNCTION_TYPE_APLAY , function_aplay , 0 },
  { "AOPEN" , ((void *)0) , FUNCTION_TYPE_AOPEN , function_aopen , 0 },
  { "ACLOSE" , ((void *)0) , FUNCTION_TYPE_ACLOSE , function_aclose , 0 },
  { ((void *)0) , ((void *)0) , FUNCTION_TYPE_NONE , ((void *)0) , 0 }
};

const char *function_name(function_t function)
{
  return function->name;
}



static int _search(const struct function *functions, const char *name, function_t *functionp)
{
  function_t function;




  if (!functions)
    return NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION;

  for (function = functions; function->name; function++) {
    if (!strcmp(function->name, name)) {
      *functionp = function;
      return 0;
    }
  }

  for (function = functions; function->name; function++) {
    if (function->other_name && !strcmp(function->other_name, name)) {
      *functionp = function;
      return 0;
    }
  }
# 607 "function.c"
  return NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION;
}

int function_search(const char *name, function_t *functionp)
{
  int r;
  r = _search(functions_orig, name, functionp);




  return r;
}

static int _list(const struct function *functions, FILE *fp)
{
  function_t function;

  if (!functions)
    return 0;

  for (function = functions; function->name; function++) {
    nll_wait_output(fp);
    fprintf(fp, "%s", function->name);
    if (function->other_name)
      fprintf(fp, "\t(%s)", function->other_name);
    fprintf(fp, "\n");
  }

  fflush(fp);

  return 0;
}

int function_list(FILE *fp)
{
  _list(functions_orig, fp);



  return 0;
}

int function_proc(function_t function, value_t *valuep, value_t args)
{
  return function->function(valuep, args);
}

static int function_fargs(value_t *valuep, value_t args)
{
  int r;

  for (; args; args = args->next) {
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_value(*valuep, args)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_copy(value_t *valuep, value_t args)
{
  int r;

  for (; args; args = args->next) {
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_copy_value(*valuep, args)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_true(value_t *valuep, value_t args)
{
  int r;

  if (!args) {
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, 1)) < 0)
      return r;
    valuep = &(*valuep)->next;
  } else {
    for (; args; args = args->next) {
      if ((r = value_extend_value(valuep)) < 0)
 return r;
      if ((r = value_set_integer(*valuep, 1)) < 0)
 return r;
      valuep = &(*valuep)->next;
    }
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_false(value_t *valuep, value_t args)
{
  int r;

  if (!args) {
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, 0)) < 0)
      return r;
    valuep = &(*valuep)->next;
  } else {
    for (; args; args = args->next) {
      if ((r = value_extend_value(valuep)) < 0)
 return r;
      if ((r = value_set_integer(*valuep, 0)) < 0)
 return r;
      valuep = &(*valuep)->next;
    }
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_argnum(value_t *valuep, value_t args)
{
  int r, n;

  n = 0;
  for (; args; args = args->next)
    n++;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, n)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_boolean(value_t *valuep, value_t args)
{
  int r;

  if (!args) {
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, 0)) < 0)
      return r;
    valuep = &(*valuep)->next;
  } else {
    for (; args; args = args->next) {
      if ((r = value_extend_value(valuep)) < 0)
 return r;
      if ((r = value_is_true(args)) < 0)
 return r;
      if ((r = value_set_integer(*valuep, r)) < 0)
 return r;
      valuep = &(*valuep)->next;
    }
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_cond(value_t *valuep, value_t args)
{
  int r, n;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_is_true(args)) < 0)
    return r;
  n = r ? 0 : 1;
  args = args->next;

  for (; args && (n > 0); args = args->next, n--)
    ;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if (!args) {
    if ((r = value_set_null(*valuep)) < 0)
      return r;
  } else {
    if ((r = value_copy_value(*valuep, args)) < 0)
      return r;
  }
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_at(value_t *valuep, value_t args)
{
  int r;
  integer_t integer = 0;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &integer)) < 0)
    return r;
  args = args->next;

  for (; args && (integer > 0); args = args->next, integer--)
    ;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if (!args) {
    if ((r = value_set_null(*valuep)) < 0)
      return r;
  } else {
    if ((r = value_copy_value(*valuep, args)) < 0)
      return r;
  }
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fpush(value_t *valuep, value_t args)
{
  int r, n = 0;

  for (; args; args = args->next, n++) {
    if ((r = stack_push(args)) < 0)
      return r;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, n)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fpop(value_t *valuep, value_t args)
{
  int r, i;
  integer_t n = 1;

  if (args) {
    if ((r = value_get_integer(args, &n)) < 0)
      ;
  }

  for (i = 0; i < n; i++) {
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if (stack_getnum() > 0) {
      if ((r = stack_pop(*valuep)) < 0)
 return r;
    } else {
      if ((r = value_set_null(*valuep)) < 0)
 return r;
    }
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_stacknum(value_t *valuep, value_t args)
{
  int r, n;

  n = stack_getnum();

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, n)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fprint(value_t *valuep, value_t args)
{
  int r, n = 0;

  value_output_values(((void *)0), args, ((void *)0));

  for (; args; args = args->next, n++)
    ;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, n)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_sprintf(value_t *valuep, value_t args)
{
  int r;
  char *format;
  char *buffer;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &format, ((void *)0))) < 0)
    return r;
  args = args->next;

  format = format ? format : "";
  buffer = string_buffer();

  r = nll_sprintf(buffer, string_buffer_size(), format, args);
  if (r < 0)
    strcpy(buffer, "");

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, buffer, -1)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_printf(value_t *valuep, value_t args)
{
  int r, n;
  char *format;
  char *buffer;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &format, ((void *)0))) < 0)
    return r;
  args = args->next;

  format = format ? format : "";
  buffer = string_buffer();

  n = nll_sprintf(buffer, string_buffer_size(), format, args);
  if (n > 0) {

    framebuf_puts(buffer);



  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, n)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_printm(value_t *valuep, value_t args)
{
  int r, result = 0;
  integer_t x = -1, y = -1, fgcolor = -1, bgcolor = -1;
  value_t arg;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  arg = args;
  args = args->next;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &fgcolor)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &bgcolor)) < 0)
      ;
  }


  result = framebuf_move_cursor(x, y);
  if (fgcolor >= 0) framebuf_setfgcolor(fgcolor);
  if (bgcolor >= 0) framebuf_setbgcolor(bgcolor);







  value_output_value(((void *)0), arg);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_input(value_t *valuep, value_t args)
{
  int r, len;
  char *string;
  char *buffer;


  framebuf_enable(0);


  for (; args; args = args->next) {
    if (value_get_string(args, &string, ((void *)0)) < 0)
      continue;
    string = string ? string : "?";
    fprintf(nll_stdout, "%s", string);
  }
  fflush(nll_stdout);

  buffer = string_buffer();

  if (!fgets(buffer, string_buffer_size(), nll_stdin))
    buffer[0] = '\0';

  len = strlen(buffer);
  while ((len > 0) && (buffer[len - 1] == '\n'))
    buffer[--len] = '\0';


  framebuf_enable(1);


  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, buffer, -1)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static integer_t str2val(const char *string)
{
  int base = 10, sign = 1;
  integer_t val;
  const char *p;

  p = string;

  while (isspace(*p))
    p++;

  switch (*p) {
  case '+': sign = 1; p++; break;
  case '-': sign = -1; p++; break;
  default: break;
  }

  if (*p == '0') {
    switch (p[1]) {
    case 'b':
    case 'B': base = 2; p += 2; break;
    case 'o':
    case 'O': base = 8; p += 2; break;
    case 'd':
    case 'D': base = 10; p += 2; break;
    case 'x':
    case 'X': base = 16; p += 2; break;
    default:
      break;
    }
  }

  val = strtol(p, ((void *)0), base);

  if (sign < 0)
    val = -val;

  return val;
}

static int function_inputn(value_t *valuep, value_t args)
{
  int r;
  integer_t integer;
  char *string;
  char *buffer;


  framebuf_enable(0);


  for (; args; args = args->next) {
    if (value_get_string(args, &string, ((void *)0)) < 0)
      continue;
    string = string ? string : "?";
    fprintf(nll_stdout, "%s", string);
  }
  fflush(nll_stdout);

  buffer = string_buffer();

  if (!fgets(buffer, string_buffer_size(), nll_stdin))
    buffer[0] = '\0';


  framebuf_enable(1);


  integer = str2val(buffer);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, integer)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fwait(value_t *valuep, value_t args)
{
  int r, usec = 0, sec = 0, rate = -1;
  integer_t integer;

  for (; args; args = args->next) {
    if (value_get_integer(args, &integer) < 0)
      ;
    else {
      if (rate < 0) {
 sec = integer;
 rate = 1000;
      } else {
 usec = usec + (integer * rate);
 sec += usec / 1000000;
 usec %= 1000000;
 rate /= 1000;
      }
    }
  }

  if (usec)
    nll_usleep(usec);
  if (sec)
    nll_sleep(sec);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, 0)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int _calc_diff_time(struct timeval *tp, struct timeval *t0p, struct timeval *t1p)
{
  struct timeval t;

  t.tv_sec = t.tv_usec = 0;

  if (t0p->tv_usec < t1p->tv_usec) {
    t.tv_sec = 1;
    t.tv_usec = 1000000;
  }

  tp->tv_sec = (t0p->tv_sec - t.tv_sec ) - t1p->tv_sec;
  tp->tv_usec = (t0p->tv_usec + t.tv_usec) - t1p->tv_usec;

  return 0;
}

static int calc_diff_time(struct timeval *tp, struct timeval *t0p, struct timeval *t1p)
{
  int r = 0;

  if ((t0p->tv_sec == t1p->tv_sec) && (t0p->tv_usec == t1p->tv_usec)) {
    tp->tv_sec = tp->tv_usec = 0;
  } else if ((t0p->tv_sec > t1p->tv_sec) ||
      ((t0p->tv_sec == t1p->tv_sec) && (t0p->tv_usec >= t1p->tv_usec))) {
    _calc_diff_time(tp, t0p, t1p);
    r = 1;
  } else {
    _calc_diff_time(tp, t1p, t0p);
    r = -1;
  }

  return r;
}

static struct timeval timer_time = { 0, 0 };

static int function_timer(value_t *valuep, value_t args)
{
  int r, usec = 0, sec = 0, rate = -1, check_only = 0;
  struct timeval n, a, t, w;
  integer_t integer;

  if (gettimeofday(&n, ((void *)0)) < 0)
    n.tv_sec = n.tv_usec = 0;

  if (!args) {
    w.tv_sec = timer_time.tv_sec = n.tv_sec;
    w.tv_usec = timer_time.tv_usec = n.tv_usec;
  } else {
    if (!timer_time.tv_sec && !timer_time.tv_usec) {
      timer_time.tv_sec = n.tv_sec;
      timer_time.tv_usec = n.tv_usec;
    }

    for (; args; args = args->next) {
      if (value_get_integer(args, &integer) < 0)
 ;
      else {
 if (rate < 0) {
   sec = integer;
   rate = 1000;
 } else {
   usec = usec + (integer * rate);
   sec += usec / 1000000;
   usec %= 1000000;
   rate /= 1000;
 }
      }
    }

    if (sec < 0) {
      a.tv_sec = -sec;
      a.tv_usec = -usec;
      check_only = 1;
    } else {
      a.tv_sec = sec;
      a.tv_usec = usec;
    }

    t.tv_sec = timer_time.tv_sec + a.tv_sec;
    t.tv_usec = timer_time.tv_usec + a.tv_usec;
    t.tv_sec += t.tv_usec / 1000000;
    t.tv_usec %= 1000000;

    if (calc_diff_time(&w, &t, &n) >= 0) {
      if (!check_only) {
 if (w.tv_sec || w.tv_usec) {
   nll_sleep(w.tv_sec);
   nll_usleep(w.tv_usec);
 }
      }
    } else {
      w.tv_sec = -w.tv_sec;
      w.tv_usec = -w.tv_usec;
    }

    if (!check_only) {
      timer_time.tv_sec = t.tv_sec;
      timer_time.tv_usec = t.tv_usec;
    }
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, w.tv_sec)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, w.tv_usec / 1000)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, w.tv_usec)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_nosystem(value_t *valuep, value_t args)
{
  int r, result;

  result = nll_nosystem_set();

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_nosyscall(value_t *valuep, value_t args)
{
  int r, result;

  result = nll_nosyscall_set();

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_nonetwork(value_t *valuep, value_t args)
{
  int r, result;

  result = nll_nonetwork_set();

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}
# 1487 "function.c"
static int function_system(value_t *valuep, value_t args)
{
  int r, result;
  char *command;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &command, ((void *)0))) < 0)
    return r;

  if (!command)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;




  result = -1;


  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}





static int syscall_call(int syscall_no, int argc, long *args)
{
  int r = -1;

  switch (argc) {
# 1547 "function.c"
  default:
    break;
  }

  return r;
}

static int function_syscall(value_t *valuep, value_t args)
{
  int r, result, argc = 0;
  integer_t syscall_no, integer;
  char *string;
  area_t area;
  long syscall_args[8];

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;
  if (nll_is_nosyscall())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &syscall_no)) < 0)
    return r;
  args = args->next;

  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &integer)) < 0) {
      if ((r = value_get_string(args, &string, ((void *)0))) < 0) {
 if ((r = value_get_area(args, &area)) < 0) {
   return r;
 } else {
   syscall_args[argc] = area ? (long)area_get_buffer(area) : 0;
 }
      } else {
 syscall_args[argc] = (long)string;
      }
    } else {
      syscall_args[argc] = (long)integer;
    }
    argc++;
    if (argc == 8)
      break;
  }

  result = syscall_call(syscall_no, argc, syscall_args);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}


static int function_feval(value_t *valuep, value_t args)
{
  int r;
  char *string;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &string, ((void *)0))) < 0)
    return r;

  if (!string)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if ((r = value_extend_value(valuep)) < 0)
    return r;


  if ((r = nll_parse_exec(((void *)0), POSITION_TYPE_EVAL, string, *valuep, ((void *)0))) < 0)
    return r;


  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fevalf(value_t *valuep, value_t args)
{
  int r;

  int retcode;

  char *filename = ((void *)0);
  FILE *fp = ((void *)0);
  char buffer[256 + 1];

  if (args) {
    if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
      ;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;

  if (!filename) {
    fp = nll_stdin;
  } else {
    fp = fopen(filename, "r");
    if (!fp)
      return NLL_ERRCODE_FILE_NOT_FOUND;
  }

  while (nll_fgets(buffer, 256, fp)) {

    if ((r = nll_parse_exec(((void *)0), POSITION_TYPE_EVAL, buffer, *valuep, &retcode)) < 0)
      break;
    if (retcode)
      break;

  }

  if (filename)
    fclose(fp);

  if (r < 0)
    return r;


  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_typeof(value_t *valuep, value_t args)
{
  int r, code;

  for (; args; args = args->next) {
    if ((code = value_typecode(args)) < 0)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, code)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_typename(value_t *valuep, value_t args)
{
  int r;
  const char *name;

  for (; args; args = args->next) {
    if ((name = value_typename(args)) == ((void *)0))
      return NLL_ERRCODE_VALUE_INVALID_TYPE;
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_string(*valuep, name, -1)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_sizeof(value_t *valuep, value_t args)
{
  int r, size;

  for (; args; args = args->next) {
    size = value_size(args);
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, size)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_nzero(value_t *valuep, value_t args)
{
  int r, t = 0;

  for (; args; args = args->next) {
    t = value_is_true(args);
    if (t)
      break;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, t)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_cmp(value_t *valuep, value_t args)
{
  int r, cmp = 0;
  value_t value;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  value = args;
  args = args->next;

  for (; args; args = args->next) {
    if ((r = value_cmp_value(value, args)) < 0)
      return r;
    if (r) {
      cmp = r;
      break;
    }
    value = args;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, cmp)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_rep(value_t *valuep, value_t args)
{
  int r, i;
  integer_t n;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &n)) < 0)
    return r;
  args = args->next;

  for (i = 0; i < n; i++) {
    if ((r = value_copy_values(valuep, args)) < 0)
      return r;
    while (*valuep)
      valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_insert(value_t *valuep, value_t args)
{
  int r, i = 0;
  integer_t n;
  value_t value, arg;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  value = args;
  args = args->next;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &n)) < 0)
    return r;
  args = args->next;

  if (n < 0) {
    for (arg = args; arg; arg = arg->next)
      n++;
    n++;
  }

  for (;; args = args->next, i++) {
    if (i == n) {
      if ((r = value_extend_value(valuep)) < 0)
 return r;
      if ((r = value_copy_value(*valuep, value)) < 0)
 return r;
      valuep = &(*valuep)->next;
    }
    if (!args)
      break;
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_copy_value(*valuep, args)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_delete(value_t *valuep, value_t args)
{
  int r, i = 0;
  integer_t n;
  value_t arg;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &n)) < 0)
    return r;
  args = args->next;

  if (n < 0) {
    for (arg = args; arg; arg = arg->next)
      n++;
  }

  for (; args; args = args->next, i++) {
    if (i == n)
      continue;
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_copy_value(*valuep, args)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_itoc(value_t *valuep, value_t args)
{
  int r;
  integer_t integer;
  char str[2];

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &integer)) < 0)
      return r;
    str[0] = integer;
    str[1] = '\0';
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_string(*valuep, str, -1)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_ctoi(value_t *valuep, value_t args)
{
  int r, i, length;
  integer_t integer;
  char *string;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, &length)) < 0)
      return r;
    if (!string)
      continue;
    for (i = 0; i < length; i++) {
      integer = *(unsigned char *)(string + i);
      if ((r = value_extend_value(valuep)) < 0)
 return r;
      if ((r = value_set_integer(*valuep, integer)) < 0)
 return r;
      valuep = &(*valuep)->next;
    }
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_itoa(value_t *valuep, value_t args)
{
  int r;
  integer_t integer;
  char *buffer;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  buffer = string_buffer();

  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &integer)) < 0)
      return r;
    sprintf(buffer, "%ld", integer);
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_string(*valuep, buffer, -1)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_atoi(value_t *valuep, value_t args)
{
  int r;
  integer_t integer;
  char *string;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, ((void *)0))) < 0)
      return r;
    if (!string)
      continue;
    integer = str2val(string);
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, integer)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}


static int function_itof(value_t *valuep, value_t args)
{
  int r;
  integer_t integer;
  double f;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &integer)) < 0)
      return r;
    f = (double)integer;
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_float(*valuep, f)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_ftoi(value_t *valuep, value_t args)
{
  int r;
  integer_t integer;
  double f;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  for (; args; args = args->next) {
    if ((r = value_get_float(args, &f)) < 0)
      return r;
    integer = (int)f;
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, integer)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_atof(value_t *valuep, value_t args)
{
  int r;
  double f;
  char *string;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, ((void *)0))) < 0)
      return r;
    if (!string)
      continue;



    f = 0.0;

    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_float(*valuep, f)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_ftoa(value_t *valuep, value_t args)
{
  int r;
  double f;
  char *buffer;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  buffer = string_buffer();

  for (; args; args = args->next) {
    if ((r = value_get_float(args, &f)) < 0)
      return r;
    sprintf(buffer, "%f", f);
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_string(*valuep, buffer, -1)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}


static int function_isx(function_type_t type, value_t *valuep, value_t args)
{
  int r, i, length, c;
  char *string;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, &length)) < 0)
      return r;
    if (!string)
      continue;
    for (i = 0; i < length; i++) {
      c = *(unsigned char *)(string + i);
      switch (type) {
      case FUNCTION_TYPE_ISALNUM: c = isalnum(c) ? 1 : 0; break;
      case FUNCTION_TYPE_ISALPHA: c = isalpha(c) ? 1 : 0; break;
      case FUNCTION_TYPE_ISASCII: c = isascii(c) ? 1 : 0; break;
      case FUNCTION_TYPE_ISCNTRL: c = iscntrl(c) ? 1 : 0; break;
      case FUNCTION_TYPE_ISDIGIT: c = isdigit(c) ? 1 : 0; break;
      case FUNCTION_TYPE_ISGRAPH: c = isgraph(c) ? 1 : 0; break;
      case FUNCTION_TYPE_ISLOWER: c = islower(c) ? 1 : 0; break;
      case FUNCTION_TYPE_ISPRINT: c = isprint(c) ? 1 : 0; break;
      case FUNCTION_TYPE_ISPUNCT: c = ispunct(c) ? 1 : 0; break;
      case FUNCTION_TYPE_ISSPACE: c = isspace(c) ? 1 : 0; break;
      case FUNCTION_TYPE_ISUPPER: c = isupper(c) ? 1 : 0; break;
      case FUNCTION_TYPE_ISXDIGIT: c = isxdigit(c) ? 1 : 0; break;
      default:
 return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;
      }
      if ((r = value_extend_value(valuep)) < 0)
 return r;
      if ((r = value_set_integer(*valuep, c)) < 0)
 return r;
      valuep = &(*valuep)->next;
    }
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_isalnum(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISALNUM, valuep, args);
}

static int function_isalpha(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISALPHA, valuep, args);
}

static int function_isascii(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISASCII, valuep, args);
}

static int function_iscntrl(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISCNTRL, valuep, args);
}

static int function_isdigit(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISDIGIT, valuep, args);
}

static int function_isgraph(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISGRAPH, valuep, args);
}

static int function_islower(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISLOWER, valuep, args);
}

static int function_isprint(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISPRINT, valuep, args);
}

static int function_ispunct(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISPUNCT, valuep, args);
}

static int function_isspace(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISSPACE, valuep, args);
}

static int function_isupper(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISUPPER, valuep, args);
}

static int function_isxdigit(value_t *valuep, value_t args)
{
  return function_isx(FUNCTION_TYPE_ISXDIGIT, valuep, args);
}

static int function_tox(function_type_t type, value_t *valuep, value_t args)
{
  int r, i, length, c;
  char *string;
  char *buffer;

  buffer = string_buffer();

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, &length)) < 0)
      return r;
    if (!string)
      continue;
    for (i = 0; i < length; i++) {
      c = *(unsigned char *)(string + i);
      switch (type) {
      case FUNCTION_TYPE_TOLOWER: c = tolower(c); break;
      case FUNCTION_TYPE_TOUPPER: c = toupper(c); break;
      default:
 return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;
      }
      buffer[i] = c;
    }
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_string(*valuep, buffer, length)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_tolower(value_t *valuep, value_t args)
{
  return function_tox(FUNCTION_TYPE_TOLOWER, valuep, args);
}

static int function_toupper(value_t *valuep, value_t args)
{
  return function_tox(FUNCTION_TYPE_TOUPPER, valuep, args);
}

static int function_left(value_t *valuep, value_t args)
{
  int r, i, length, offset, size;
  integer_t integer;
  char *s, *p;
  char *buffer;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &s, &length)) < 0)
    return r;
  args = args->next;

  if (!s) {
    s = "";
    length = 0;
  }

  offset = 0;
  integer = length;

  if (args) {
    if ((r = value_get_integer(args, &integer)) < 0)
      ;
  }

  size = integer + ((integer < 0) ? length : 0);

  buffer = string_buffer();
  p = buffer;

  for (i = 0; i < size; i++) {
    if ((offset + i >= 0) && (offset + i < length))
      *(p++) = s[offset + i];
  }
  *p = '\0';

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, buffer, p - buffer)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_right(value_t *valuep, value_t args)
{
  int r, i, length, offset, size;
  integer_t integer;
  char *s, *p;
  char *buffer;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &s, &length)) < 0)
    return r;
  args = args->next;

  if (!s) {
    s = "";
    length = 0;
  }

  integer = length;

  if (args) {
    if ((r = value_get_integer(args, &integer)) < 0)
      ;
  }

  size = integer + ((integer < 0) ? length : 0);
  offset = length - size;

  buffer = string_buffer();
  p = buffer;

  for (i = 0; i < size; i++) {
    if ((offset + i >= 0) && (offset + i < length))
      *(p++) = s[offset + i];
  }
  *p = '\0';

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, buffer, p - buffer)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_mid(value_t *valuep, value_t args)
{
  int r, i, length, offset, size;
  integer_t integer0 = 0, integer1;
  char *s, *p;
  char *buffer;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &s, &length)) < 0)
    return r;
  args = args->next;

  if (!s) {
    s = "";
    length = 0;
  }

  if (args) {
    if ((r = value_get_integer(args, &integer0)) < 0)
      ;
    args = args->next;
  }

  offset = integer0 + ((integer0 < 0) ? length : 0);
  integer1 = length - offset;

  if (args) {
    if ((r = value_get_integer(args, &integer1)) < 0)
      ;
  }

  size = integer1 + ((integer1 < 0) ? (length - offset) : 0);

  buffer = string_buffer();
  p = buffer;

  for (i = 0; i < size; i++) {
    if ((offset + i >= 0) && (offset + i < length))
      *(p++) = s[offset + i];
  }
  *p = '\0';

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, buffer, p - buffer)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_instr(value_t *valuep, value_t args)
{
  int r, i, n, length0, length1;
  char *s0, *s1;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &s0, &length0)) < 0)
    return r;
  args = args->next;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &s1, &length1)) < 0)
    return r;

  if (!s0) {
    s0 = "";
    length0 = 0;
  }
  if (!s1) {
    s1 = "";
    length1 = 0;
  }

  n = -1;
  for (i = 0; i <= length0 - length1; i++) {
    if (!memcmp(s0 + i, s1, length1)) {
      n = i;
      break;
    }
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, n)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_strlen(value_t *valuep, value_t args)
{
  int r, length;
  char *string;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, &length)) < 0)
      return r;
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, length)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_strcpy(value_t *valuep, value_t args)
{
  int r, length0, length1;
  integer_t offset = -1;
  char *s0, *s1;
  char *buffer;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &s0, &length0)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &offset)) < 0)
      ;
    args = args->next;
  }

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &s1, &length1)) < 0)
    return r;

  if (!s0) {
    s0 = "";
    length0 = 0;
  }
  if (!s1) {
    s1 = "";
    length1 = 0;
  }

  if (offset < 0)
    offset = length0;

  if (offset + length1 + 1 > string_buffer_size())
    return NLL_ERRCODE_STRING_TOO_LONG;

  buffer = string_buffer();

  memcpy(buffer, s0, length0);
  memcpy(buffer + offset, s1, length1);

  if (offset + length1 > length0)
    length0 = offset + length1;

  buffer[length0] = '\0';

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, buffer, length0)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_split(value_t *valuep, value_t args)
{
  int r, num, length;
  char *letters, *string, *p, *n;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &letters, &num)) < 0)
    return r;
  args = args->next;

  if (!letters) {
    letters = "";
    num = 0;
  }

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, &length)) < 0)
      return r;
    if (!string)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    p = string;
    while (1) {
      for (n = p; n - string < length; n++) {
 if (memchr(letters, *n, num))
   break;
      }

      if ((r = value_extend_value(valuep)) < 0)
 return r;
      if ((r = value_set_string(*valuep, p, n - p)) < 0)
 return r;
      valuep = &(*valuep)->next;

      if (n - string == length)
 break;

      p = n + 1;
    }
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_splits(value_t *valuep, value_t args)
{
  int r, num, length;
  char *letters, *string, *p, *n;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &letters, &num)) < 0)
    return r;
  args = args->next;

  if (!letters) {
    letters = "";
    num = 0;
  }

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, &length)) < 0)
      return r;
    if (!string)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    p = string;
    while (1) {
      for (n = p; n - string < length; n++) {
 if (memchr(letters, *n, num))
   break;
      }

      if ((r = value_extend_value(valuep)) < 0)
 return r;
      if ((r = value_set_string(*valuep, p, n - p)) < 0)
 return r;
      valuep = &(*valuep)->next;

      if (n - string == length)
 break;

      for (p = n; p - string < length; p++) {
 if (!memchr(letters, *p, num))
   break;
      }
    }
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_chomp(value_t *valuep, value_t args)
{
  int r, num, length;
  char *letters, *string;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &letters, &num)) < 0)
    return r;
  args = args->next;

  if (!letters) {
    letters = "";
    num = 0;
  }

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, &length)) < 0)
      return r;
    if (!string)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    for (; length > 0; string++, length--) {
      if (!memchr(letters, *string, num))
 break;
    }

    for (; length > 0; length--) {
      if (!memchr(letters, string[length - 1], num))
 break;
    }

    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_string(*valuep, string, length)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_lchomp(value_t *valuep, value_t args)
{
  int r, num, length;
  char *letters, *string;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &letters, &num)) < 0)
    return r;
  args = args->next;

  if (!letters) {
    letters = "";
    num = 0;
  }

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, &length)) < 0)
      return r;
    if (!string)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    for (; length > 0; string++, length--) {
      if (!memchr(letters, *string, num))
 break;
    }

    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_string(*valuep, string, length)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_rchomp(value_t *valuep, value_t args)
{
  int r, num, length;
  char *letters, *string;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &letters, &num)) < 0)
    return r;
  args = args->next;

  if (!letters) {
    letters = "";
    num = 0;
  }

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, &length)) < 0)
      return r;
    if (!string)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;

    for (; length > 0; length--) {
      if (!memchr(letters, string[length - 1], num))
 break;
    }

    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_string(*valuep, string, length)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static unsigned int seed = 1;

static unsigned int _rand(void)
{
  seed ^= seed << 13;
  seed ^= seed >> 17;
  seed ^= seed << 5;
  return seed;
}

static int _randval(void)
{
  volatile int r;

  r = (int)seed;
  if (r < 0)
    r = -r;
  if (r < 0)
    r = 1;

  return r;
}

static int function_srand(value_t *valuep, value_t args)
{
  int r;
  integer_t s = 0;

  if (args) {
    if ((r = value_get_integer(args, &s)) < 0)
      ;
    seed = !s ? time(((void *)0)) : s;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, seed)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_rand(value_t *valuep, value_t args)
{
  int r, n;
  integer_t range = 0;

  if (!args) {
    _rand();
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, _randval())) < 0)
      return r;
    valuep = &(*valuep)->next;
  } else {
    for (; args; args = args->next) {
      if ((r = value_get_integer(args, &range)) < 0)
 return r;
      n = range;
      if (n >= 0)
 _rand();
      if ((r = value_extend_value(valuep)) < 0)
 return r;
      if ((r = value_set_integer(*valuep, (n > 0) ? (_randval() % n) : _randval())) < 0)
 return r;
      valuep = &(*valuep)->next;
    }
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_int(value_t *valuep, value_t args)
{
  int r;
  integer_t integer;

  double f;


  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &integer)) < 0) {

      if ((r = value_get_float(args, &f)) < 0)
 return r;
      integer = f;
      while (integer > f)
 integer--;



    }
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, integer)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_abs(value_t *valuep, value_t args)
{
  int r, is_float;
  integer_t integer;

  double f;


  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  for (; args; args = args->next) {
    is_float = 0;
    if ((r = value_get_integer(args, &integer)) < 0) {

      if ((r = value_get_float(args, &f)) < 0)
 return r;
      f = (f < 0.0) ? -f : f;
      is_float = 1;



    } else {
      integer = (integer < 0) ? -integer : integer;
    }
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if (is_float) {

      if ((r = value_set_float(*valuep, f)) < 0)
 return r;



    } else {
      if ((r = value_set_integer(*valuep, integer)) < 0)
 return r;
    }
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_sign(value_t *valuep, value_t args)
{
  int r, is_float;
  integer_t integer;

  double f;


  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

  for (; args; args = args->next) {
    is_float = 0;
    if ((r = value_get_integer(args, &integer)) < 0) {

      if ((r = value_get_float(args, &f)) < 0)
 return r;
      if (f < 0.0) f = -1.0;
      else if (f > 0.0) f = 1.0;
      else f = 0.0;
      is_float = 1;



    } else {
      if (integer < 0) integer = -1;
      else if (integer > 0) integer = 1;
      else integer = 0;
    }
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if (is_float) {

      if ((r = value_set_float(*valuep, f)) < 0)
 return r;



    } else {
      if ((r = value_set_integer(*valuep, integer)) < 0)
 return r;
    }
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_max(value_t *valuep, value_t args)
{
  int r, has_float = 0, has_integer = 0, max = 0;
  integer_t integer;

  double f, fmax = 0.0;


  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &integer)) < 0) {

      if ((r = value_get_float(args, &f)) < 0)
 return r;
      if (!has_float || (fmax < f))
 fmax = f;
      has_float = 1;



    } else {
      if (!has_integer || (max < integer))
 max = integer;
      has_integer = 1;
    }
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if (has_float) {

    if (has_integer && (fmax < max))
      fmax = max;
    if ((r = value_set_float(*valuep, fmax)) < 0)
      return r;



  } else {
    if ((r = value_set_integer(*valuep, max)) < 0)
      return r;
  }
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_min(value_t *valuep, value_t args)
{
  int r, has_float = 0, has_integer = 0, min = 0;
  integer_t integer;

  double f, fmin = 0.0;


  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &integer)) < 0) {

      if ((r = value_get_float(args, &f)) < 0)
 return r;
      if (!has_float || (fmin > f))
 fmin = f;
      has_float = 1;



    } else {
      if (!has_integer || (min > integer))
 min = integer;
      has_integer = 1;
    }
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if (has_float) {

    if (has_integer && (fmin > min))
      fmin = min;
    if ((r = value_set_float(*valuep, fmin)) < 0)
      return r;



  } else {
    if ((r = value_set_integer(*valuep, min)) < 0)
      return r;
  }
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_abs2sum(value_t *valuep, value_t args)
{
  int r, has_float = 0, sum = 0;
  integer_t integer;

  double f, fsum = 0.0;


  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &integer)) < 0) {

      if ((r = value_get_float(args, &f)) < 0)
 return r;
      fsum += f * f;
      has_float = 1;



    } else {
      sum += integer * integer;
    }
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if (has_float) {

    fsum += sum;
    if ((r = value_set_float(*valuep, fsum)) < 0)
      return r;



  } else {
    if ((r = value_set_integer(*valuep, sum)) < 0)
      return r;
  }
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_time(value_t *valuep, value_t args)
{
  int r;
  struct timeval t;

  if (gettimeofday(&t, ((void *)0)) < 0)
    t.tv_sec = t.tv_usec = 0;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, t.tv_sec)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, t.tv_usec / 1000)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, t.tv_usec)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_date(value_t *valuep, value_t args)
{
  int r;



  char *s;





  s = "Cannot get date.";


  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, s, -1)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fdim(value_t *valuep, value_t args)
{
  int r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = array_make_values(*valuep, args)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fmemory(value_t *valuep, value_t args)
{
  int r;
  integer_t integer = -1;
  area_t area = ((void *)0);

  if (args) {
    if ((r = value_get_integer(args, &integer)) < 0)
      ;
  }

  if (integer >= 0) {
    if ((r = area_alloc(&area, integer)) < 0)
      return r;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_area(*valuep, area)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_peek(value_t *valuep, value_t args)
{
  int r;
  integer_t offset = 0, size = -1, integer;
  area_t area;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_area(args, &area)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &offset)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &size)) < 0)
      ;
  }

  if (!area)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if ((r = area_read_integer(area, offset, &integer, size)) < 0)
    return r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, integer)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_poke(value_t *valuep, value_t args)
{
  int r;
  integer_t offset = 0, size = -1, integer;
  area_t area;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_area(args, &area)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &offset)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &size)) < 0)
      ;
    args = args->next;
  }

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &integer)) < 0)
    return r;

  if (!area)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if ((r = area_write_integer(area, offset, integer, size)) < 0)
    return r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, integer)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_mread(value_t *valuep, value_t args)
{
  int r;
  integer_t offset = 0, size = -1;
  area_t area;
  char *buffer;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_area(args, &area)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &offset)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &size)) < 0)
      ;
  }

  if (!area)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (size < 0)
    size = area_get_size(area) - offset;

  if (size < 0)
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  if (size + 1 > string_buffer_size())
    return NLL_ERRCODE_STRING_TOO_LONG;

  buffer = string_buffer();

  if ((r = area_read(area, offset, buffer, size)) < 0)
    return r;
  buffer[size] = '\0';

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, buffer, size)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_mwrite(value_t *valuep, value_t args)
{
  int r, length;
  integer_t offset = 0, size = -1;
  area_t area;
  char *string;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_area(args, &area)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &offset)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &size)) < 0)
      ;
    args = args->next;
  }

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &string, &length)) < 0)
    return r;

  if (!area)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (!string) {
    string = "";
    length = 0;
  }

  if (size < 0)
    size = length;

  if (size > length)
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  if ((r = area_write(area, offset, string, size)) < 0)
    return r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, size)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_mcopy(value_t *valuep, value_t args)
{
  int r;
  integer_t doffset = 0, soffset = 0, size = -1;
  area_t darea, sarea;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_area(args, &darea)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &doffset)) < 0)
      ;
    args = args->next;
  }

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_area(args, &sarea)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &soffset)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &size)) < 0)
      ;
  }

  if (!darea || !sarea)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (size < 0)
    size = area_get_size(sarea) - soffset;

  if (size < 0)
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  if ((r = area_copy_area(darea, doffset, sarea, soffset, size)) < 0)
    return r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, size)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}
# 3819 "function.c"
static int issocket(int fd)
{
  return (fd & 0x40000000) ? 1 : 0;
}
# 3831 "function.c"
static int socket2fd(int sockt)
{
  return sockt & ~0x40000000;
}

static int function_rename(value_t *valuep, value_t args)
{
  int r, result;
  char *from, *to;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &from, ((void *)0))) < 0)
    return r;
  args = args->next;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &to, ((void *)0))) < 0)
    return r;

  if (!from || !to)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  result = rename(from, to);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_unlink(value_t *valuep, value_t args)
{
  int r, result;
  char *filename;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
    return r;

  if (!filename)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  result = unlink(filename);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_truncate(value_t *valuep, value_t args)
{
  int r, result;
  char *filename;
  integer_t length = 0;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &length)) < 0)
      ;
  }

  if (!filename)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;


  result = truncate(filename, length);




  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_mkdir(value_t *valuep, value_t args)
{
  int r, result;
  char *filename;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
    return r;

  if (!filename)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;


  result = mkdir(filename, 0755);




  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_rmdir(value_t *valuep, value_t args)
{
  int r, result;
  char *filename;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
    return r;

  if (!filename)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  result = rmdir(filename);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_chdir(value_t *valuep, value_t args)
{
  int r, result;
  char *filename;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
    return r;

  if (!filename)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  result = chdir(filename);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_open(value_t *valuep, value_t args)
{
  int r, fd = -1;
  integer_t flags = 00002;
  char *filename;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
  }

  if (!filename)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  fd = open(filename, flags);

  if ((r = value_extend_value(valuep)) < 0)
    goto err;
  if ((r = value_set_integer(*valuep, fd)) < 0)
    goto err;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    goto err;

  return 0;

err:
  if (fd >= 0)
    close(fd);
  return r;
}

static int fd_close(int fd)
{
  int r;

  if (issocket(fd)) {
    fd = socket2fd(fd);







    r = close(fd);

  } else {
    r = close(fd);
  }

  return r;
}

static int function_close(value_t *valuep, value_t args)
{
  int r, result;
  integer_t fd;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &fd)) < 0)
    return r;

  result = fd_close(fd);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_read(value_t *valuep, value_t args)
{
  int r;
  area_t area;
  integer_t fd, offset = 0, size = -1;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &fd)) < 0)
    return r;
  args = args->next;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_area(args, &area)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &offset)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &size)) < 0)
      ;
  }

  if (!area)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  fd = socket2fd(fd);

  if (size < 0)
    size = area_get_size(area) - offset;

  if (size < 0)
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  if ((offset < 0) || (offset + size > area_get_size(area)))
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  size = read(fd, area_get_buffer(area) + offset, size);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, size)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_write(value_t *valuep, value_t args)
{
  int r;
  area_t area;
  integer_t fd, offset = 0, size = -1;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &fd)) < 0)
    return r;
  args = args->next;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_area(args, &area)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &offset)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &size)) < 0)
      ;
  }

  if (!area)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  fd = socket2fd(fd);

  if (size < 0)
    size = area_get_size(area) - offset;

  if (size < 0)
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  if ((offset < 0) || (offset + size > area_get_size(area)))
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  size = write(fd, area_get_buffer(area) + offset, size);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, size)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_lseek(value_t *valuep, value_t args)
{
  int r, result;
  integer_t fd, offset = 0, whence = 0;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &fd)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &offset)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &whence)) < 0)
      ;
  }

  fd = socket2fd(fd);

  result = lseek(fd, offset, whence);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_ftruncate(value_t *valuep, value_t args)
{
  int r, result;
  integer_t fd, length = 0;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &fd)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &length)) < 0)
      ;
  }

  fd = socket2fd(fd);

  result = ftruncate(fd, length);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_isreadable(value_t *valuep, value_t args)
{
  int r, fdmax;
  integer_t fd, interval = -1;
  fd_set fds;
  struct timeval t, *tp;

  if (args) {
    if ((r = value_get_integer(args, &interval)) < 0)
      ;
    args = args->next;
  }

  fdmax = -1;
  do { int i, n; n = (((1024) + (((sizeof(__fd_mask) * 8)) - 1)) / ((sizeof(__fd_mask) * 8))); for (i = 0; i < n; i++) (&fds)->__fds_bits[i] = 0; } while (0);

  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &fd)) < 0)
      return r;
    fd = socket2fd(fd);
    if (fdmax < fd)
      fdmax = fd;
    (((&fds)->__fds_bits[(fd) / (sizeof(__fd_mask) * 8)]) |= ((__fd_mask)1 << ((fd) % (sizeof(__fd_mask) * 8))));
  }

  if (interval < 0) {
    tp = ((void *)0);
  } else {
    t.tv_sec = interval / 100;
    t.tv_usec = (interval % 100) * 10000;
    tp = &t;
  }

  r = select(fdmax + 1, &fds, ((void *)0), ((void *)0), tp);

  if (r < 0) {
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, -1)) < 0)
      return r;
    valuep = &(*valuep)->next;
  } else if (r == 0) {

  } else {
    for (fd = 0; fd <= fdmax; fd++) {
      if (((((&fds)->__fds_bits[(fd) / (sizeof(__fd_mask) * 8)]) & ((__fd_mask)1 << ((fd) % (sizeof(__fd_mask) * 8)))) != 0)) {
 if ((r = value_extend_value(valuep)) < 0)
   return r;
 if ((r = value_set_integer(*valuep, fd)) < 0)
   return r;
 valuep = &(*valuep)->next;
      }
    }
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_iswritable(value_t *valuep, value_t args)
{
  int r, fdmax;
  integer_t fd, interval = -1;
  fd_set fds;
  struct timeval t, *tp;

  if (args) {
    if ((r = value_get_integer(args, &interval)) < 0)
      ;
    args = args->next;
  }

  fdmax = -1;
  do { int i, n; n = (((1024) + (((sizeof(__fd_mask) * 8)) - 1)) / ((sizeof(__fd_mask) * 8))); for (i = 0; i < n; i++) (&fds)->__fds_bits[i] = 0; } while (0);

  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &fd)) < 0)
      return r;
    fd = socket2fd(fd);
    if (fdmax < fd)
      fdmax = fd;
    (((&fds)->__fds_bits[(fd) / (sizeof(__fd_mask) * 8)]) |= ((__fd_mask)1 << ((fd) % (sizeof(__fd_mask) * 8))));
  }

  if (interval < 0) {
    tp = ((void *)0);
  } else {
    t.tv_sec = interval / 100;
    t.tv_usec = (interval % 100) * 10000;
    tp = &t;
  }

  r = select(fdmax + 1, ((void *)0), &fds, ((void *)0), tp);

  if (r < 0) {
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, -1)) < 0)
      return r;
    valuep = &(*valuep)->next;
  } else if (r == 0) {

  } else {
    for (fd = 0; fd <= fdmax; fd++) {
      if (((((&fds)->__fds_bits[(fd) / (sizeof(__fd_mask) * 8)]) & ((__fd_mask)1 << ((fd) % (sizeof(__fd_mask) * 8)))) != 0)) {
 if ((r = value_extend_value(valuep)) < 0)
   return r;
 if ((r = value_set_integer(*valuep, fd)) < 0)
   return r;
 valuep = &(*valuep)->next;
      }
    }
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fopen(value_t *valuep, value_t args)
{
  int r;
  char *filename, *mode = "r";
  FILE *fp = ((void *)0);
  fileid_id_t id = 0;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_string(args, &mode, ((void *)0))) < 0)
      ;
    if (!mode)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;
  }

  if (!filename)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  id = fileid_create(((void *)0));
  if (id < 0)
    return NLL_ERRCODE_MEMORY_BUFFER_OVER;

  fp = fopen(filename, mode);
  if (!fp) {
    if (id > 0)
      fileid_destroy(id);
    id = -1;
  } else {
    if (fileid_set_fp(id, fp) < 0) {
      r = NLL_ERRCODE_VALUE_INVALID_TYPE;
      goto err;
    }
    fp = ((void *)0);
  }

  if ((r = value_extend_value(valuep)) < 0)
    goto err;
  if ((r = value_set_integer(*valuep, id)) < 0)
    goto err;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    goto err;

  return 0;

err:
  if (id > 0)
    fileid_destroy(id);
  if (fp)
    fclose(fp);
  return r;
}

static int function_fdopen(value_t *valuep, value_t args)
{
  int r;
  integer_t fd;
  char *mode = "r";
  FILE *fp = ((void *)0);
  fileid_id_t id = 0;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &fd)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_string(args, &mode, ((void *)0))) < 0)
      ;
    if (!mode)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;
  }

  fd = socket2fd(fd);

  id = fileid_create(((void *)0));
  if (id < 0)
    return NLL_ERRCODE_MEMORY_BUFFER_OVER;

  fp = fdopen(fd, mode);
  if (!fp) {
    if (id > 0)
      fileid_destroy(id);
    id = -1;
  } else {
    if (fileid_set_fp(id, fp) < 0) {
      r = NLL_ERRCODE_VALUE_INVALID_TYPE;
      goto err;
    }
    fp = ((void *)0);
  }

  if ((r = value_extend_value(valuep)) < 0)
    goto err;
  if ((r = value_set_integer(*valuep, id)) < 0)
    goto err;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    goto err;

  return 0;

err:
  if (id > 0)
    fileid_destroy(id);
  if (fp)
    fclose(fp);
  return r;
}

static int function_fclose(value_t *valuep, value_t args)
{
  int r, result;
  integer_t id;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &id)) < 0)
    return r;

  result = fileid_destroy(id);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fileno(value_t *valuep, value_t args)
{
  int r, result = -1;
  integer_t id;
  FILE *fp;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &id)) < 0)
    return r;

  fp = fileid_get_fp(id);
  if (fp)
    result = fileno(fp);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_feof(value_t *valuep, value_t args)
{
  int r, result = -1;
  integer_t id = 0;
  FILE *fp;

  if (args) {
    if ((r = value_get_integer(args, &id)) < 0)
      ;
  }

  fp = !id ? nll_stdin : fileid_get_fp(id);
  if (fp)
    result = feof(fp);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_ferror(value_t *valuep, value_t args)
{
  int r, result = -1;
  integer_t id = 0;
  FILE *fp;

  if (args) {
    if ((r = value_get_integer(args, &id)) < 0)
      ;
  }

  fp = !id ? nll_stdout : fileid_get_fp(id);
  if (fp)
    result = ferror(fp);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fgetc(value_t *valuep, value_t args)
{
  int r, c = -1;
  integer_t id = 0;
  FILE *fp;

  if (args) {
    if ((r = value_get_integer(args, &id)) < 0)
      ;
  }

  fp = !id ? nll_stdin : fileid_get_fp(id);
  if (fp)
    c = fgetc(fp);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if (c == (-1)) {
    if ((r = value_set_null(*valuep)) < 0)
      return r;
  } else {
    if ((r = value_set_integer(*valuep, c)) < 0)
      return r;
  }
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fputc(value_t *valuep, value_t args)
{
  int r, result = -1;
  integer_t id = 0, c = '\n';
  FILE *fp;

  if (args) {
    if ((r = value_get_integer(args, &id)) < 0)
      ;
    args = args->next;
  }

  fp = !id ? nll_stdout : fileid_get_fp(id);

  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &c)) < 0)
      return r;

    if (fp) {
      result = fputc(c, fp);
      fflush(fp);
    } else {
      result = -1;
    }

    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, result)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fgets(value_t *valuep, value_t args)
{
  int r;
  integer_t id = 0;
  char *buffer;
  FILE *fp;

  if (args) {
    if ((r = value_get_integer(args, &id)) < 0)
      ;
  }

  buffer = string_buffer();

  fp = !id ? nll_stdin : fileid_get_fp(id);
  if (fp && fgets(buffer, string_buffer_size(), fp)) {
    ;
  } else {
    buffer = ((void *)0);
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if (!buffer) {
    if ((r = value_set_null(*valuep)) < 0)
      return r;
  } else {
    if ((r = value_set_string(*valuep, buffer, -1)) < 0)
      return r;
  }
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fputs(value_t *valuep, value_t args)
{
  int r, length;
  integer_t id = 0;
  char *string;
  FILE *fp;

  if (args) {
    if ((r = value_get_integer(args, &id)) < 0)
      ;
    args = args->next;
  }

  fp = !id ? nll_stdout : fileid_get_fp(id);

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &string, &length)) < 0)
      return r;

    if (!string) {
      string = "";
      length = 0;
    }

    if (fp && (fputs(string, fp) >= 0)) {
      fflush(fp);
    } else {
      length = -1;
    }

    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, length)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fprintf(value_t *valuep, value_t args)
{
  int r, n;
  integer_t id = 0;
  char *format;
  char *buffer;
  FILE *fp;

  if (args) {
    if ((r = value_get_integer(args, &id)) < 0)
      ;
    args = args->next;
  }

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &format, ((void *)0))) < 0)
    return r;
  args = args->next;

  format = format ? format : "";
  buffer = string_buffer();

  n = nll_sprintf(buffer, string_buffer_size(), format, args);
  if (n > 0) {
    fp = !id ? nll_stdout : fileid_get_fp(id);
    if (fp && (fputs(buffer, fp) >= 0)) {
      fflush(fp);
    } else {
      n = -1;
    }
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, n)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fread(value_t *valuep, value_t args)
{
  int r;
  area_t area;
  integer_t id = 0, offset = 0, size = -1;
  FILE *fp;

  if (args) {
    if ((r = value_get_integer(args, &id)) < 0)
      ;
    args = args->next;
  }

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_area(args, &area)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &offset)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &size)) < 0)
      ;
  }

  if (!area)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (size < 0)
    size = area_get_size(area) - offset;

  if (size < 0)
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  if ((offset < 0) || (offset + size > area_get_size(area)))
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  fp = !id ? nll_stdin : fileid_get_fp(id);
  if (fp) {
    size = fread(area_get_buffer(area) + offset, 1, size, fp);
  } else {
    size = -1;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, size)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fwrite(value_t *valuep, value_t args)
{
  int r;
  area_t area;
  integer_t id = 0, offset = 0, size = -1;
  FILE *fp;

  if (args) {
    if ((r = value_get_integer(args, &id)) < 0)
      ;
    args = args->next;
  }

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_area(args, &area)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &offset)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &size)) < 0)
      ;
  }

  if (!area)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if (size < 0)
    size = area_get_size(area) - offset;

  if (size < 0)
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  if ((offset < 0) || (offset + size > area_get_size(area)))
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  fp = !id ? nll_stdout : fileid_get_fp(id);
  if (fp) {
    size = fwrite(area_get_buffer(area) + offset, 1, size, fp);
    fflush(fp);
  } else {
    size = -1;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, size)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_fseek(value_t *valuep, value_t args)
{
  int r, result = -1;
  integer_t id = 0, offset = 0, whence = 0;
  FILE *fp;

  if (args) {
    if ((r = value_get_integer(args, &id)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &offset)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &whence)) < 0)
      ;
  }

  fp = !id ? nll_stdin : fileid_get_fp(id);
  if (fp)
    result = fseek(fp, offset, whence);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_qopen(value_t *valuep, value_t args)
{
  int r;
  queueid_index_t index;

  index = queueid_create();
  if (index < 0)
    return NLL_ERRCODE_MEMORY_BUFFER_OVER;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, index)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_qclose(value_t *valuep, value_t args)
{
  int r, result;
  integer_t index;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &index)) < 0)
    return r;

  result = queueid_destroy(index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_qlength(value_t *valuep, value_t args)
{
  int r, result;
  integer_t index;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &index)) < 0)
    return r;

  result = queueid_number(index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_qpushf(value_t *valuep, value_t args)
{
  int r, n = 0;
  integer_t index;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &index)) < 0)
    return r;
  args = args->next;

  for (; args; args = args->next, n++) {
    if (queueid_headin(index, args) < 0)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, n)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_qpopl(value_t *valuep, value_t args)
{
  int r, i;
  integer_t index, n = 1;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &index)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &n)) < 0)
      ;
  }

  for (i = 0; i < n; i++) {
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if (queueid_headout(index, *valuep) < 0)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_qpushl(value_t *valuep, value_t args)
{
  int r, n = 0;
  integer_t index;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &index)) < 0)
    return r;
  args = args->next;

  for (; args; args = args->next, n++) {
    if (queueid_tailin(index, args) < 0)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, n)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_qpopf(value_t *valuep, value_t args)
{
  int r, i;
  integer_t index, n = 1;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &index)) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &n)) < 0)
      ;
  }

  for (i = 0; i < n; i++) {
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if (queueid_tailout(index, *valuep) < 0)
      return NLL_ERRCODE_VALUE_INVALID_TYPE;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}
# 5965 "function.c"
static int function_keyname(value_t *valuep, value_t args)
{
  int r;
  integer_t keycode;
  const char *keyname;

  for (; args; args = args->next) {
    if ((r = value_get_integer(args, &keycode)) < 0)
      return r;
    keyname = keyname_get(keycode);
    if (!keyname) keyname = "";
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_string(*valuep, keyname, -1)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_keycode(value_t *valuep, value_t args)
{
  int r;
  char *keyname;
  key_code_t keycode;

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &keyname, ((void *)0))) < 0)
      return r;
    if (!keyname)
      continue;
    keycode = keycode_get(keyname);
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, keycode)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int function_screen(value_t *valuep, value_t args)
{



  int r, result;
  integer_t flags = -1, width = -1, height = -1;

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &width)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height)) < 0)
      ;
  }

  result = framebuf_setscreen(flags, width, height);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_scrstat(value_t *valuep, value_t args)
{



  int r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, framebuf_get_screen_flags())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, framebuf_get_screen_width())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, framebuf_get_screen_height())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_flush(value_t *valuep, value_t args)
{



  int r, result;
  integer_t flags = 0;

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
  }

  result = framebuf_flush(flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_getcolor(value_t *valuep, value_t args)
{



  int r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, framebuf_get_cursor_fgcolor())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, framebuf_get_cursor_bgcolor())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_getfgcolor(value_t *valuep, value_t args)
{



  int r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, framebuf_get_cursor_fgcolor())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_getbgcolor(value_t *valuep, value_t args)
{



  int r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, framebuf_get_cursor_bgcolor())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_setcolor(value_t *valuep, value_t args)
{



  int r, result;
  integer_t fgcolor = -1, bgcolor = -1;

  if (args) {
    if ((r = value_get_integer(args, &fgcolor)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &bgcolor)) < 0)
      ;
  }

  result = framebuf_setfgcolor(fgcolor);
  framebuf_setbgcolor(bgcolor);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_getattr(value_t *valuep, value_t args)
{



  int r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, framebuf_get_cursor_effect())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_setattr(value_t *valuep, value_t args)
{



  int r, result;
  integer_t effect = -1;

  if (args) {
    if ((r = value_get_integer(args, &effect)) < 0)
      ;
  }

  result = framebuf_seteffect(effect);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_getpos(value_t *valuep, value_t args)
{



  int r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, framebuf_get_cursor_x())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, framebuf_get_cursor_y())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_move(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x = -1, y = -1, dx = 0, dy = 0;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &dx)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &dy)) < 0)
      ;
  }

  result = framebuf_move_cursor(x, y);

  if (dx < 0) framebuf_move_left(-dx);
  else if (dx > 0) framebuf_move_right(dx);

  if (dy < 0) framebuf_move_up(-dy);
  else if (dy > 0) framebuf_move_down(dy);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_getch(value_t *valuep, value_t args)
{



  int r;
  integer_t x = -1, y = -1;
  int ch;
  char s[2];

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
  }

  ch = framebuf_getch(x, y);

  s[0] = ch;
  s[1] = '\0';

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, s, -1)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_clear(value_t *valuep, value_t args)
{



  int r, result;
  integer_t ch = ' ', flags = 0;

  if (args) {
    if ((r = value_get_integer(args, &ch)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
  }

  result = framebuf_clear(ch, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_scroll(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x = 0, y = 0, ch = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &ch)) < 0)
      ;
  }

  result = framebuf_scroll(x, y, ch);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_line(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x0 = 0x7FFFFFFF, y0 = 0x7FFFFFFF;
  integer_t x1 = 0x7FFFFFFF, y1 = 0x7FFFFFFF;
  char *string = "";

  if (args) {
    if ((r = value_get_integer_float(args, &x0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &x1)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y1)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_string(args, &string, ((void *)0))) < 0)
      ;
  }

  string = string ? string : "";

  result = framebuf_line(x0, y0, x1, y1, string);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_box(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x0 = 0x7FFFFFFF, y0 = 0x7FFFFFFF;
  integer_t x1 = 0x7FFFFFFF, y1 = 0x7FFFFFFF;
  integer_t flags = 0;
  char *string = "";

  if (args) {
    if ((r = value_get_integer_float(args, &x0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &x1)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y1)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_string(args, &string, ((void *)0))) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
  }

  string = string ? string : "";

  result = framebuf_box(x0, y0, x1, y1, string, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_inkey(value_t *valuep, value_t args)
{



  int r;
  integer_t integer;
  char key[2];
  const char *p;

  integer = framebuf_getkey();

  switch (integer) {
  case KEY_CODE_END:
  case KEY_CODE_UP:
  case KEY_CODE_DOWN:
  case KEY_CODE_RIGHT:
  case KEY_CODE_LEFT:
  case KEY_CODE_PAGEUP:
  case KEY_CODE_PAGEDOWN:
    p = keyname_get(integer);
    break;
  default:
    key[0] = integer;
    key[1] = '\0';
    p = key;
    break;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, p, -1)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gscreen(value_t *valuep, value_t args)
{



  int r, result;
  integer_t flags = -1, width = -1, height = -1, index = -1;

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &width)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_setscreen(flags, width, height, index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gscrstat(value_t *valuep, value_t args)
{



  int r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, graphic_get_screen_flags())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, graphic_get_screen_width())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, graphic_get_screen_height())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, graphic_get_screen_image())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gcolor(value_t *valuep, value_t args)
{



  int r;
  integer_t red = 0, green = 0, blue = 0;
  int color;

  if (args) {
    if ((r = value_get_integer(args, &red)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &green)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &blue)) < 0)
      ;
  }

  color = graphic_color(red, green, blue);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, color)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_grgb(value_t *valuep, value_t args)
{



  int r;
  integer_t color = 0;
  int red, green, blue;

  if (args) {
    if ((r = value_get_integer(args, &color)) < 0)
      ;
  }

  graphic_rgb(color, &red, &green, &blue);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, red)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, green)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, blue)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gsync(value_t *valuep, value_t args)
{



  int r, result;

  result = graphic_sync();

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gflush(value_t *valuep, value_t args)
{



  int r, result;
  integer_t flags = 0;

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
  }

  result = graphic_flush(flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_ggetmainimg(value_t *valuep, value_t args)
{



  int r, result;

  result = graphic_getmainimage();

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gsetmainimg(value_t *valuep, value_t args)
{



  int r, result;
  integer_t index = -1;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_setmainimage(index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_ggetsize(value_t *valuep, value_t args)
{



  int r;
  integer_t index = -1;
  int width, height;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  width = graphic_getwidth(index);
  height = graphic_getheight(index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, width)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, height)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_ggetrange(value_t *valuep, value_t args)
{



  int r;
  integer_t index = -1;
  int x = 0, y = 0, width = 0, height = 0, mulx = 0, muly = 0;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  graphic_getrange(index, &x, &y, &width, &height, &mulx, &muly);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, x)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, y)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, width)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, height)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, mulx)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, muly)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gsetrange(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x = 0, y = 0, width = 0, height = 0, mulx = 0, muly = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &width)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &mulx)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &muly)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_setrange(index, x, y, width, height, mulx, muly);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_ggetoffset(value_t *valuep, value_t args)
{



  int r;
  integer_t index = -1;
  int x = 0, y = 0;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  graphic_getoffset(index, &x, &y);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, x)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, y)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gsetoffset(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x = 0, y = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_setoffset(index, x, y);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_ggetscale(value_t *valuep, value_t args)
{



  int r;
  integer_t index = -1;
  int mulx = 0, muly = 0, divx = 0, divy = 0;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  graphic_getscale(index, &mulx, &muly, &divx, &divy);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, mulx)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, muly)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, divx)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, divy)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gsetscale(value_t *valuep, value_t args)
{



  int r, result;
  integer_t mulx = 0, muly = 0, divx = 0, divy = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &mulx)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &muly)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &divx)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &divy)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_setscale(index, mulx, muly, divx, divy);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_ggetdotoffset(value_t *valuep, value_t args)
{



  int r;
  integer_t index = -1;
  int x = 0, y = 0;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  graphic_getdotoffset(index, &x, &y);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, x)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, y)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gsetdotoffset(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x = 0, y = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_setdotoffset(index, x, y);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_ggetdotsize(value_t *valuep, value_t args)
{



  int r;
  integer_t index = -1;
  int width = 0, height = 0;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  graphic_getdotsize(index, &width, &height);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, width)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, height)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gsetdotsize(value_t *valuep, value_t args)
{



  int r, result;
  integer_t width = 0, height = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &width)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_setdotsize(index, width, height);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_ggetcolor(value_t *valuep, value_t args)
{



  int r, color, fgcolor, bgcolor, fromcolor, tocolor;
  integer_t index = -1;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  graphic_getcolor(index, &color, &fgcolor, &bgcolor, &fromcolor, &tocolor);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, color)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, fgcolor)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, bgcolor)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, fromcolor)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, tocolor)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gsetcolor(value_t *valuep, value_t args)
{



  int r, result;
  integer_t color = 0x7FFFFFFF, fgcolor = 0x7FFFFFFF, bgcolor = 0x7FFFFFFF, fromcolor = 0x7FFFFFFF, tocolor = 0x7FFFFFFF;
  integer_t flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer(args, &color)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &fgcolor)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &bgcolor)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &fromcolor)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &tocolor)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_setcolor(index, color, fgcolor, bgcolor, fromcolor, tocolor, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_ggetpixel(value_t *valuep, value_t args)
{



  int r;
  integer_t x = -1, y = -1, index = -1;
  int color;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  color = graphic_getpixel(index, x, y);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, color)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gclear(value_t *valuep, value_t args)
{



  int r, result;
  integer_t color = 0, flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer(args, &color)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_clear(index, color, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gscroll(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x = 0, y = 0, color = 0, flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &color)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_scroll(index, x, y, color, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gdot(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x = 0x7FFFFFFF, y = 0x7FFFFFFF;
  integer_t color = 0x7FFFFFFF, flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &color)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_dot(index, x, y, color, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gline(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x0 = 0x7FFFFFFF, y0 = 0x7FFFFFFF;
  integer_t x1 = 0x7FFFFFFF, y1 = 0x7FFFFFFF;
  integer_t color = 0x7FFFFFFF, flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &x1)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y1)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &color)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_line(index, x0, y0, x1, y1, color, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gbox(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x0 = 0x7FFFFFFF, y0 = 0x7FFFFFFF;
  integer_t x1 = 0x7FFFFFFF, y1 = 0x7FFFFFFF;
  integer_t color = 0x7FFFFFFF, flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &x1)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y1)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &color)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_box(index, x0, y0, x1, y1, color, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gcircle(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x = 0x7FFFFFFF, y = 0x7FFFFFFF;
  integer_t rx = 1, ry, color = 0x7FFFFFFF, flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &rx)) < 0)
      ;
    args = args->next;
  }

  ry = rx;

  if (args) {
    if ((r = value_get_integer_float(args, &ry)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &color)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_circle(index, x, y, rx, ry, color, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gpaint(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x = 0x7FFFFFFF, y = 0x7FFFFFFF;
  integer_t color = 0x7FFFFFFF, border = 0x7FFFFFFF, flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &color)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &border)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_paint(index, x, y, color, border, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gcopy(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x0 = 0x7FFFFFFF, y0 = 0x7FFFFFFF, width0 = 0, height0 = 0;
  integer_t source = -1, x = 0, y = 0, width = 0, height = 0;
  integer_t flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &width0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &source)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &width)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_copy(index, x0, y0, width0, height0, source, x, y, width, height, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_grotate(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x = 0x7FFFFFFF, y = 0x7FFFFFFF, width = 0, height = 0, cx = 0, cy = 0;
  integer_t num = 1, color = 0, flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &width)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &cx)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &cy)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &num)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &color)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_rotate(index, x, y, width, height, cx, cy, num, color, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gchar(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x = 0x7FFFFFFF, y = 0x7FFFFFFF, width = 0, height = 0;
  integer_t ch = 0, type = 0;
  integer_t flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &width)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &ch)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &type)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_char(index, x, y, width, height, ch, type, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gprint(value_t *valuep, value_t args)
{



  int r, result, length = 0;
  integer_t x = 0x7FFFFFFF, y = 0x7FFFFFFF, width = 0, height = 0;
  integer_t type = 0;
  integer_t xgrid = 0x7FFFFFFF, ygrid = 0x7FFFFFFF;
  integer_t flags = 0, index = -1;
  char *string = "";

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &width)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_string(args, &string, &length)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &type)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &xgrid)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &ygrid)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  if (!string) {
    string = "";
    length = 0;
  }

  result = graphic_print(index, x, y, width, height, string, length, type, xgrid, ygrid, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_ginkey(value_t *valuep, value_t args)
{



  int r, keycode;
  const char *keyname;

  keycode = graphic_getkeybuf();
  keyname = keyname_get(keycode);
  if (!keyname) keyname = "";

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, keyname, -1)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gkeystat(value_t *valuep, value_t args)
{



  int r;
  char *keyname;
  int keycode, s;

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &keyname, ((void *)0))) < 0)
      return r;
    if (!keyname)
      continue;
    keycode = keycode_get(keyname);
    s = graphic_getkeystatus(keycode);
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, s)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gmousepos(value_t *valuep, value_t args)
{



  int r, x, y;

  if (graphic_getmousepos(&x, &y) < 0) {
    x = -1;
    y = -1;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, x)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, y)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_ginmouse(value_t *valuep, value_t args)
{



  int r, mousecode, x, y;
  const char *mousename;

  mousecode = graphic_getmousebuf(&x, &y);
  mousename = mousename_get(mousecode);
  if (!mousename) {
    mousename = "";
    x = -1;
    y = -1;
  }

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_string(*valuep, mousename, -1)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, x)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, y)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gmousestat(value_t *valuep, value_t args)
{



  int r;
  char *mousename;
  int mousecode, s;

  for (; args; args = args->next) {
    if ((r = value_get_string(args, &mousename, ((void *)0))) < 0)
      return r;
    if (!mousename)
      continue;
    mousecode = mousecode_get(mousename);
    s = graphic_getmousestatus(mousecode);
    if ((r = value_extend_value(valuep)) < 0)
      return r;
    if ((r = value_set_integer(*valuep, s)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gallocimage(value_t *valuep, value_t args)
{



  int r, result;
  integer_t width = 0, height = 0, flags = 0;

  if (args) {
    if ((r = value_get_integer_float(args, &width)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
  }

  result = graphic_allocimage(width, height, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gfreeimage(value_t *valuep, value_t args)
{



  int r, result;
  integer_t index = -1;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_freeimage(index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gloadimage(value_t *valuep, value_t args)
{



  int r, result, width = 0, height = 0;
  integer_t flags = 0;
  char *filename;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
  }

  if (!filename)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  result = graphic_loadimage(filename, &width, &height, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, width)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, height)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gsaveimage(value_t *valuep, value_t args)
{



  int r, result;
  integer_t source = -1, x = 0, y = 0, width = 0, height = 0, flags = 0;
  char *filename;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &source)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &width)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
  }

  if (!filename)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  result = graphic_saveimage(filename, source, x, y, width, height, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gcmpimage(value_t *valuep, value_t args)
{



  int r, result;
  integer_t x0 = 0x7FFFFFFF, y0 = 0x7FFFFFFF, width0 = 0, height0 = 0;
  integer_t source = -1, x = 0, y = 0, width = 0, height = 0;
  integer_t flags = 0, index = -1;

  if (args) {
    if ((r = value_get_integer_float(args, &x0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &width0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height0)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &source)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &x)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &y)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &width)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer_float(args, &height)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
  }

  result = graphic_cmpimage(index, x0, y0, width0, height0, source, x, y, width, height, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_gcharset(value_t *valuep, value_t args)
{



  int r, result, width = 0, height = 0, num = 0;
  integer_t type = 0, flags = 0;

  if (args) {
    if ((r = value_get_integer(args, &type)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
  }

  result = graphic_charset(type, &width, &height, &num, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, width)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, height)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, num)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_astop(value_t *valuep, value_t args)
{



  int r, result;

  result = audio_stop();

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_aclear(value_t *valuep, value_t args)
{



  int r, result;
  integer_t aunitset_index = -1;

  if (args) {
    if ((r = value_get_integer(args, &aunitset_index)) < 0)
      ;
  }

  result = audio_clear(aunitset_index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_asound(value_t *valuep, value_t args)
{



  int r, result;
  integer_t samplefreq = 0;

  if (args) {
    if ((r = value_get_integer(args, &samplefreq)) < 0)
      ;
  }

  result = audio_setsamplefreq(samplefreq);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_asndstat(value_t *valuep, value_t args)
{



  int r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, audio_getsamplefreq())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_aplaynum(value_t *valuep, value_t args)
{



  int r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, audio_playnum())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_await(value_t *valuep, value_t args)
{



  int r;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, audio_wait())) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_aunitset(value_t *valuep, value_t args)
{



  int r, result;
  integer_t aunitset_index = -1;

  if (args) {
    if ((r = value_get_integer(args, &aunitset_index)) < 0)
      ;
  }

  result = audio_unitset(aunitset_index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_aunit(value_t *valuep, value_t args)
{



  int r, result;
  integer_t output = 0, amp = 1024, flags = 0, aunitset_index = -1;

  if (args) {
    if ((r = value_get_integer(args, &output)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &amp)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &aunitset_index)) < 0)
      ;
  }

  result = audio_unit(output, amp, flags, aunitset_index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_aosc(value_t *valuep, value_t args)
{



  int r, result;
  integer_t index = 1, amp = 1024, freq = 1024, phase = 0, type = ( 0x0 << 24), mod = ( 0x0 << 24), flags = 0, aunitset_index = -1;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &amp)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &freq)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &phase)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &type)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &mod)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &aunitset_index)) < 0)
      ;
  }

  result = audio_osc(index, amp, freq, phase, type, mod, flags, aunitset_index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_aaddout(value_t *valuep, value_t args)
{



  int r, result;
  integer_t index = 1, output = 0, amp = 1024, flags = 0, aunitset_index = -1;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &output)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &amp)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &aunitset_index)) < 0)
      ;
  }

  result = audio_addout(index, output, amp, flags, aunitset_index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_aenvpoint(value_t *valuep, value_t args)
{



  int r, result;
  integer_t index = 1, n = -1, step = 0, amp = 1024, flags = 0, aunitset_index = -1;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &n)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &step)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &amp)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &aunitset_index)) < 0)
      ;
  }

  result = audio_envpoint(index, n, step, amp, flags, aunitset_index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_aenvcopy(value_t *valuep, value_t args)
{



  int r, result;
  integer_t index = 1, source = 1, flags = 0, aunitset_index = -1;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &source)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &aunitset_index)) < 0)
      ;
  }

  result = audio_envcopy(index, source, flags, aunitset_index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_afilpoint(value_t *valuep, value_t args)
{



  int r, result;
  integer_t index = 1, type = 0, n = -1, amp = 1024, flags = 0, aunitset_index = -1;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &type)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &n)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &amp)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &aunitset_index)) < 0)
      ;
  }

  result = audio_filpoint(index, type, n, amp, flags, aunitset_index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_afilcopy(value_t *valuep, value_t args)
{



  int r, result;
  integer_t index = 1, source = 1, flags = 0, aunitset_index = -1;

  if (args) {
    if ((r = value_get_integer(args, &index)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &source)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &aunitset_index)) < 0)
      ;
  }

  result = audio_filcopy(index, source, flags, aunitset_index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_aplay(value_t *valuep, value_t args)
{



  int r, result;
  char *mml = ((void *)0), *filename = ((void *)0);
  integer_t flags = 0, aunitset_index = -1;

  if (args) {
    if ((r = value_get_string(args, &mml, ((void *)0))) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_integer(args, &aunitset_index)) < 0)
      ;
    args = args->next;
  }

  if (args) {
    if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
      ;
  }

  result = audio_play(mml, flags, aunitset_index, filename);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_aopen(value_t *valuep, value_t args)
{



  int r, result, length;
  integer_t flags = 0;
  char *filename;

  if (nll_is_nosystem())
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_string(args, &filename, ((void *)0))) < 0)
    return r;
  args = args->next;

  if (args) {
    if ((r = value_get_integer(args, &flags)) < 0)
      ;
  }

  if (!filename)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  result = audio_open(filename, &length, flags);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, length)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}

static int function_aclose(value_t *valuep, value_t args)
{



  int r, result;
  integer_t index;

  if (!args)
    return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
  if ((r = value_get_integer(args, &index)) < 0)
    return r;

  result = audio_close(index);

  if ((r = value_extend_value(valuep)) < 0)
    return r;
  if ((r = value_set_integer(*valuep, result)) < 0)
    return r;
  valuep = &(*valuep)->next;

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;

}
