# 1 "audio.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "audio.c"
# 1 "config.h" 1
# 2 "audio.c" 2


# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 5 "audio.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 6 "audio.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 7 "audio.c" 2
# 1 "../include/ctype.h" 1



int isalnum(int c);
int isalpha(int c);
int isascii(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);
int tolower(int c);
int toupper(int c);
# 8 "audio.c" 2
# 1 "../include/unistd.h" 1
# 14 "../include/unistd.h"
void _exit(int status);
pid_t fork(void);
int execve(const char *path, char *const argv[], char *const envp[]);

ssize_t read(int fd, void *buf, size_t nbytes);
ssize_t write(int fd, const void *buf, size_t nbytes);
int close(int fd);

int dup(int oldd);
int pipe(int fildes[2]);
int dup2(int oldd, int newd);
int pipe2(int fildes[2], int flags);

pid_t getpid(void);
pid_t getppid(void);
pid_t getsid(pid_t pid);
pid_t setsid(void);
pid_t getpgid(pid_t pid);
int setpgid(pid_t pid, pid_t pgrp);
pid_t getpgrp(void);

pid_t tcgetpgrp(int fd);
int tcsetpgrp(int fd, pid_t pgrp_id);

int unlink(const char *path);
int chdir(const char *path);
int chdir(const char *path);
int fchdir(int fd);
int chown(const char *path, uid_t owner, gid_t group);
off_t lseek(int fildes, off_t offset, int whence);
int access(const char *path, int mode);
void sync(void);
int fsync(int fd);
int fchown(int fd, uid_t owner, gid_t group);

int truncate(const char *path, off_t length);
int ftruncate(int fd, off_t length);


int brk(void *addr);



void *sbrk(intptr_t incr);

char *getcwd(char *buf, size_t size);

unsigned int sleep(unsigned int seconds);
int usleep(useconds_t microseconds);

int isatty(int fd);
# 9 "audio.c" 2
# 19 "audio.c"
# 1 "../include/nllibc/nllibc.h" 1
# 20 "audio.c" 2


# 1 "const.h" 1
# 23 "audio.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 24 "audio.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 25 "audio.c" 2
# 1 "audio.h" 1



int audio_check(void);
int audio_init(void);
int audio_done(void);
int audio_stop(void);
int audio_clear(int aunitset_index);
int audio_clear_all(void);
int audio_getsamplefreq(void);
int audio_setsamplefreq(int samplefreq);
int audio_playnum(void);
int audio_wait(void);
int audio_unitset(int aunitset_index);
int audio_unit(int output, int amp, int flags, int aunitset_index);
int audio_osc(int index, int amp, int freq, int phase, int type, int mod, int flags, int aunitset_index);
int audio_addout(int index, int output, int amp, int flags, int aunitset_index);
int audio_envpoint(int index, int n, int step, int amp, int flags, int aunitset_index);
int audio_envcopy(int index, int source, int flags, int aunitset_index);
int audio_filpoint(int index, int type, int n, int amp, int flags, int aunitset_index);
int audio_filcopy(int index, int source, int flags, int aunitset_index);
int audio_play(const char *mml, int flags, int aunitset_index, const char *filename);
int audio_open(char *filename, int *lengthp, unsigned int flags);
int audio_close(int index);


typedef int (*ext_audio_callback_t)(int channels, int samples, short *buffer, void *arg);
int ext_audio_init(void);
int ext_audio_done(void);
int ext_audio_run(int freq, int channels, int samples, ext_audio_callback_t callback, void *arg);
int ext_audio_stop(void);
int ext_audio_wait(void);
# 26 "audio.c" 2
# 1 "sound.h" 1



typedef enum {
  SOUND_TYPE_UNKNOWN = 0,
  SOUND_TYPE_WAV,
  SOUND_TYPE_TEXT,

  SOUND_TYPE_NUM
} sound_type_t;

typedef struct sound *sound_t;

struct sound {
  int index;
  sound_type_t type;

  int samplefreq;
  int channels;
  int bits;
  int samplenum;

  unsigned int flags;

  FILE *fp;
  int offset;

  union {
    void *p;
    int8_t *b;
    int16_t *h;
    int32_t *w;
  } frames;
};

int sound_init(void);
int sound_done(void);
int sound_check(void);

int sound_get_index(sound_t sound);
sound_t sound_get_sound(int index);
int sound_destroy(sound_t sound);
sound_t sound_create(sound_type_t type, unsigned int flags);

int sound_ropen(sound_t sound, const char *filename);
int sound_wopen(sound_t sound, const char *filename,
  int samplefreq, int channels, int bits, int samplenum);
int sound_read(sound_t sound, short *frames, int num);
int sound_write(sound_t sound, short *frames, int num);
int sound_rclose(sound_t sound);
int sound_wclose(sound_t sound);
# 27 "audio.c" 2
# 1 "sdl.h" 1



int sdl_init(void);
int sdl_start(void);
int sdl_done(void);
# 28 "audio.c" 2

struct aunit {
  struct aunit *next;
  int index;
  unsigned int flags;

  struct {
    int amp;
    int freq;
    int phase;
    int type;
    int mod;
    unsigned int flags;
  } osc;

  int outnum;
  struct {
    int amp;
    struct aunit *aunit;
  } outs[8];

  struct {
    int num;
    int amp;
    struct aunit *aunit;
  } in;

  struct {
    int amp;
  } out;

  struct {
    int num;
    struct envpoint {
      int step;
      int amp;
      unsigned int flags;
    } points[16];
  } envelope;

  struct {
    struct {
      int num;
      struct {
 int amp;
 unsigned int flags;
      } points[16];
    } forward;
    struct {
      int num;
      struct {
 int amp;
 unsigned int flags;
      } points[16];
    } backward;
  } filter;
};

static struct aunitset {
  int num;
  struct aunit *aunits;
} aunitsets[64];

struct aunit_regs {
  struct aunit_regs *next;

  struct aunit *aunit;

  struct {
    int amp;
  } out;

  struct {
    int index;
  } envelope;

  struct {
    int index;
    struct {
      int amp;
    } out[16];
  } buffer;
};

struct samplestep {
  int sec;
  int count;
};

struct player {
  struct player *next;
  struct player *nextplayer;
  struct aunit_regs *pool;
  int duplicate;

  struct player *head;
  int aunitset_index;
  struct aunit_regs *regs;
  int amp;
  int freq;
  struct samplestep step;
  int stepbase;
  int steplen;
};

static int sampling_freq = 44100;

static struct player *playeres = ((void *)0);

static struct aunit *aunit_pool = ((void *)0);
static struct aunit_regs *aunit_regs_pool = ((void *)0);
static struct player *player_pool = ((void *)0);

static struct aunit *_aunit_alloc(void)
{
  struct aunit *aunit;
  if (aunit_pool) {
    aunit = aunit_pool;
    aunit_pool = aunit_pool->next;
  } else {
    aunit = memory_alloc(sizeof(*aunit));
  }
  return aunit;
}

static void _aunit_free(struct aunit *aunit)
{
  aunit->next = aunit_pool;
  aunit_pool = aunit;
}

static struct aunit_regs *_aunit_regs_alloc(void)
{
  struct aunit_regs *aunit_regs;
  if (aunit_regs_pool) {
    aunit_regs = aunit_regs_pool;
    aunit_regs_pool = aunit_regs_pool->next;
  } else {
    aunit_regs = memory_alloc(sizeof(*aunit_regs));
  }
  return aunit_regs;
}

static void _aunit_regs_free(struct aunit_regs *aunit_regs)
{
  aunit_regs->next = aunit_regs_pool;
  aunit_regs_pool = aunit_regs;
}

static struct player *_player_alloc(void)
{
  struct player *player;
  if (player_pool) {
    player = player_pool;
    player_pool = player_pool->next;
  } else {
    player = memory_alloc(sizeof(*player));
  }
  return player;
}

static void _player_free(struct player *player)
{
  player->next = player_pool;
  player_pool = player;
}

static int aunit_regs_free(struct aunit_regs *aunit_regs)
{
  struct aunit_regs *next;

  for (; aunit_regs; aunit_regs = next) {
    next = aunit_regs->next;
    _aunit_regs_free(aunit_regs);
  }

  return 0;
}

static struct aunit_regs *aunit_regs_alloc_num(int num)
{
  struct aunit_regs *aunit_regs = ((void *)0), *regs;
  int i;

  for (i = 0; i < num; i++) {
    if ((regs = _aunit_regs_alloc()) == ((void *)0))
      goto err;
    memset(regs, 0, sizeof(*regs));

    regs->next = aunit_regs;
    aunit_regs = regs;
  }

  return aunit_regs;

err:
  aunit_regs_free(aunit_regs);
  return ((void *)0);
}

static int aunit_regs_push(struct aunit_regs **pool, struct aunit_regs *aunit_regs)
{
  struct aunit_regs *regs;

  while (aunit_regs) {
    regs = aunit_regs;
    aunit_regs = aunit_regs->next;

    regs->next = *pool;
    *pool = regs;
  }

  return 0;
}

static struct aunit_regs *aunit_regs_pop(struct aunit_regs **pool, struct aunitset *aunitset)
{
  struct aunit_regs *aunit_regs = ((void *)0), *regs;
  struct aunit *aunit;

  for (aunit = aunitset->aunits; aunit; aunit = aunit->next) {
    if ((regs = *pool) == ((void *)0))
      goto err;
    *pool = (*pool)->next;
    memset(regs, 0, sizeof(*regs));

    regs->aunit = aunit;

    regs->next = aunit_regs;
    aunit_regs = regs;
  }

  return aunit_regs;

err:
  aunit_regs_push(pool, aunit_regs);
  return ((void *)0);
}

static int step_clear(struct samplestep *step)
{
  step->sec = 0;
  step->count = 0;
  return 0;
}

static int step_num(struct samplestep *step, int samplefreq)
{
  return step->sec * samplefreq + step->count;
}

static int step_diff(struct samplestep *step0, struct samplestep *step1, int samplefreq)
{
  return (step0->sec - step1->sec) * samplefreq + step0->count - step1->count;
}

static int step_copy(struct samplestep *dst, struct samplestep *src)
{
  dst->sec = src->sec;
  dst->count = src->count;
  return 0;
}

static int step_add(struct samplestep *dst, struct samplestep *src, int count, int samplefreq)
{
  struct samplestep step;

  if (!src)
    src = dst;

  step_copy(&step, src);

  step.count += count;
  while (step.count >= samplefreq) {
    step.sec++;
    step.count -= samplefreq;
  }

  step_copy(dst, &step);

  return 0;
}

static struct player *player_alloc(int aunitset_index, int amp, int freq,
       struct samplestep *step, int stepbase, int steplen)
{
  struct player *player;

  if ((player = _player_alloc()) == ((void *)0))
    return ((void *)0);
  memset(player, 0, sizeof(*player));

  player->amp = amp;
  player->freq = freq;
  step_copy(&player->step, step);
  player->stepbase = stepbase;
  player->steplen = steplen;

  player->aunitset_index = aunitset_index;

  return player;
}

static int player_free(struct player *player)
{
  struct player *next;

  for (; player; player = next) {
    if (player->nextplayer) {
      player_free(player->nextplayer);
      player->nextplayer = ((void *)0);
    }
    next = player->next;
    aunit_regs_free(player->regs);
    aunit_regs_free(player->pool);
    _player_free(player);
  }

  return 0;
}

static struct player *_player_copy(struct player *player)
{
  return player_alloc(player->aunitset_index, player->amp, player->freq,
        &player->step, player->stepbase, player->steplen);
}

static struct player *player_copy(struct player *player)
{
  struct player *dst = ((void *)0), *p, **pp, *head;

  pp = &dst;
  head = player;

  for (; player; player = player->next) {
    p = _player_copy(player);
    if (!p)
      goto err;
    p->head = head;
    if (player->nextplayer) {
      p->nextplayer = player_copy(player->nextplayer);
      if (!p->nextplayer)
 goto err;
    }
    *pp = p;
    pp = &p->next;
  }

  return dst;

err:
  player_free(dst);
  return ((void *)0);
}



static int scale2freq[12] = {
  16744036,
  17739688,
  18794545,
  19912127,
  21096164,
  22350607,
  23679643,
  25087708,
  26579501,
  28160000,
  29834481,
  31608531,
};

static int player_add(struct player **pp, int aunitset_index,
        int amp, int scale, int octave,
        struct samplestep *step, int stepbase, int steplen)
{
  struct player *player;
  int freq = 0, i;

  if (scale >= 0) {
    freq = scale2freq[scale];
    for (i = octave; i < 9; i++)
      freq >>= 1;
    freq /= 1000;
  }

  player = player_alloc(aunitset_index, amp, freq, step, stepbase, steplen);
  if (!player)
    return -1;

  player->next = *pp;
  *pp = player;

  return 0;
}

struct audio_data {
  struct audio_data *next;
  volatile int finished;
  int num;
  int samplefreq;
  int channels;
  int samples;
  struct samplestep length;
  struct samplestep step;
  struct player *ready;
  struct player *busy;
  struct player *complete;



};

static struct audio_data *audiodata_list = ((void *)0);

static struct audio_data *audiodata_alloc(void)
{
  struct audio_data *audiodata;
  audiodata = memory_alloc(sizeof(*audiodata));
  if (audiodata)
    memset(audiodata, 0, sizeof(*audiodata));
  return audiodata;
}

static int _wait(struct audio_data *audiodata)
{
# 466 "audio.c"
  return 0;
}

static int audiodata_free(struct audio_data *audiodata)
{
  struct player *player;

  _wait(audiodata);

  while (audiodata->ready) {
    player = audiodata->ready;
    audiodata->ready = audiodata->ready->nextplayer;

    player->nextplayer = audiodata->complete;
    audiodata->complete = player;
  }

  while (audiodata->busy) {
    player = audiodata->busy;
    audiodata->busy = audiodata->busy->nextplayer;

    player->nextplayer = audiodata->complete;
    audiodata->complete = player;
  }

  player_free(audiodata->complete);

  memory_free(audiodata);

  return 0;
}

static int audiodata_list_clean(void)
{
  struct audio_data *audiodata, **pp;
  int n = 0;

  for (pp = &audiodata_list; *pp;) {
    audiodata = *pp;
    if (audiodata->finished) {
      *pp = audiodata->next;
      audiodata->next = ((void *)0);
      audiodata_free(audiodata);
      continue;
    }
    n++;
    pp = &(*pp)->next;
  }

  return n;
}

static int audiodata_list_wait(void)
{
  while (audiodata_list_clean() > 0)
    nll_sleep(1);
  return 0;
}

static int audiodata_list_stop(void)
{
  struct audio_data *audiodata;
  for (audiodata = audiodata_list; audiodata; audiodata = audiodata->next)
    audiodata->finished = 1;
  return audiodata_list_wait();
}

static int audiodata_list_num(void)
{
  struct audio_data *audiodata;
  int num = 0;

  for (audiodata = audiodata_list; audiodata; audiodata = audiodata->next)
    num++;

  return num;
}

static int init(void)
{
  static int initialized = 0;

  if (!initialized) {
    memset(aunitsets, 0, sizeof(aunitsets));



    initialized = 1;
  }

  return 0;
}

int audio_check(void)
{
  int i;

  if (audiodata_list)
    return NLL_ERRCODE_MEMORY_NOT_EMPTY;

  if (playeres)
    return NLL_ERRCODE_MEMORY_NOT_EMPTY;

  for (i = 0; i < 64; i++) {
    if (aunitsets[i].aunits || aunitsets[i].num)
      return NLL_ERRCODE_MEMORY_NOT_EMPTY;
  }

  return 0;
}

int audio_init(void)
{
  int r = 0;



  return r;
}

int audio_done(void)
{
  int r;
  struct aunit *aunit;
  struct aunit_regs *aunit_regs;
  struct player *player;

  audiodata_list_stop();

  if ((r = player_free(playeres)) < 0)
    return r;
  playeres = ((void *)0);

  if ((r = audio_clear_all()) < 0)
    return r;

  while (aunit_pool) {
    aunit = aunit_pool;
    aunit_pool = aunit_pool->next;
    memory_free(aunit);
  }

  while (aunit_regs_pool) {
    aunit_regs = aunit_regs_pool;
    aunit_regs_pool = aunit_regs_pool->next;
    memory_free(aunit_regs);
  }

  while (player_pool) {
    player = player_pool;
    player_pool = player_pool->next;
    memory_free(player);
  }





  return 0;
}

static int muldiv(int val, int mul, int div)
{




  return ((val / div) * mul) + ((val % div) * mul / div);
}
# 652 "audio.c"
static const int sin_val[256 + 1] = {
      0, 201, 402, 603, 804, 1005, 1206, 1407,
   1608, 1809, 2009, 2210, 2410, 2611, 2811, 3012,
   3212, 3412, 3612, 3811, 4011, 4210, 4410, 4609,
   4808, 5007, 5205, 5404, 5602, 5800, 5998, 6195,
   6393, 6590, 6786, 6983, 7179, 7375, 7571, 7767,
   7962, 8157, 8351, 8545, 8739, 8933, 9126, 9319,
   9512, 9704, 9896, 10087, 10278, 10469, 10659, 10849,
  11039, 11228, 11417, 11605, 11793, 11980, 12167, 12353,
  12539, 12725, 12910, 13094, 13279, 13462, 13645, 13828,
  14010, 14191, 14372, 14553, 14732, 14912, 15090, 15269,
  15446, 15623, 15800, 15976, 16151, 16325, 16499, 16673,
  16846, 17018, 17189, 17360, 17530, 17700, 17869, 18037,
  18204, 18371, 18537, 18703, 18868, 19032, 19195, 19357,
  19519, 19680, 19841, 20000, 20159, 20317, 20475, 20631,
  20787, 20942, 21096, 21250, 21403, 21554, 21705, 21856,
  22005, 22154, 22301, 22448, 22594, 22739, 22884, 23027,
  23170, 23311, 23452, 23592, 23731, 23870, 24007, 24143,
  24279, 24413, 24547, 24680, 24811, 24942, 25072, 25201,
  25329, 25456, 25582, 25708, 25832, 25955, 26077, 26198,
  26319, 26438, 26556, 26674, 26790, 26905, 27019, 27133,
  27245, 27356, 27466, 27575, 27683, 27790, 27896, 28001,
  28105, 28208, 28310, 28411, 28510, 28609, 28706, 28803,
  28898, 28992, 29085, 29177, 29268, 29358, 29447, 29534,
  29621, 29706, 29791, 29874, 29956, 30037, 30117, 30195,
  30273, 30349, 30424, 30498, 30571, 30643, 30714, 30783,
  30852, 30919, 30985, 31050, 31113, 31176, 31237, 31297,
  31356, 31414, 31470, 31526, 31580, 31633, 31685, 31736,
  31785, 31833, 31880, 31926, 31971, 32014, 32057, 32098,
  32137, 32176, 32213, 32250, 32285, 32318, 32351, 32382,
  32412, 32441, 32469, 32495, 32521, 32545, 32567, 32589,
  32609, 32628, 32646, 32663, 32678, 32692, 32705, 32717,
  32728, 32737, 32745, 32752, 32757, 32761, 32765, 32766, 32767
};


static int degree_inrange(int deg)
{
  while (deg < 0)
    deg += (256*4);
  deg %= (256*4);
  return deg;
}

static int int_sin(int deg, int n)
{
  deg = degree_inrange(deg);
  if (deg >= (256*2))
    return -int_sin(deg - (256*2), n);
  if (deg > 256)
    return int_sin((256*2) - deg, n);
  return sin_val[deg];
}

static int int_triangle(int deg, int n)
{
  deg = degree_inrange(deg);
  if (deg >= (256*2))
    return -int_triangle(deg - (256*2), n);

  n = n ? n : 1024/2;
  n = muldiv(n, 256 * 2, 1024);

  if (deg <= n) deg = muldiv(deg, 256, n);
  else deg = muldiv(256*2 - deg, 256, 256*2 - n);

  return muldiv(deg, 32767, 256);
}

static int int_pulse(int deg, int n)
{
  deg = degree_inrange(deg);
  return (deg < muldiv(256*4, n, 1024)) ? 32767 : -32767;
}

static int int_sawup(int deg, int n)
{
  deg = degree_inrange(deg);
  if (deg > (256*2))
    return -int_sawup((256*4) - deg, n);
  return int_triangle(deg, 1024 - n);
}

static int int_sawdown(int deg, int n)
{
  deg = degree_inrange(deg);
  return -int_sawup(deg, n);
}

static unsigned int _rand0(unsigned int seed)
{
  seed ^= seed << 13;
  seed ^= seed >> 17;
  seed ^= seed << 5;
  return seed;
}

static unsigned int _rand1(unsigned int seed)
{
  seed ^= seed << 1;
  seed ^= seed << 10;
  seed ^= seed >> 3;
  return seed;
}

static unsigned int _rand(unsigned int seed)
{
  return (seed >> 3) ^ _rand0((seed << 1) ^ _rand1(seed));
}

static int _random(int deg)
{
  return (int)(_rand(deg + 1) % (32767 * 2 + 1)) - 32767;
}

static int int_random(int deg, int n)
{
  int i, r = 0;
  n++;
  for (i = 0; i < n; i++)
    r += _random(deg + i * 7);
  if (n)
    r /= n;
  return r;
}

static int int_noise(int deg, int n)
{
  n = n ? n : 1024;
  n = deg / muldiv(256*4, n, 1024);
  return (int)(_rand(n + 1) % (32767 * 2 + 1)) - 32767;
}

static int int_zero(int deg, int n)
{
  return 0;
}

static int int_high(int deg, int amp)
{
  amp = amp ? amp : 1024;
  amp = muldiv(amp, 32767, 1024);
  return amp;
}

static int int_inpulse(int deg, int amp)
{
  amp = amp ? amp : 1024;
  amp = muldiv(amp, 32767, 1024);
  return (deg == 0) ? amp : 0;
}

static int int_data(int deg, int index)
{
  sound_t sound;
  short frames[2];
  int i, amp;

  sound = sound_get_sound(index);
  if (!sound)
    return 0;

  deg = muldiv(deg, sampling_freq, (256*4));
  deg = muldiv(deg, ((2*2*2*2*2*2) * 1000), scale2freq[9]);
  sound->offset = muldiv(deg, sound->samplefreq, sampling_freq);

  if (sound_read(sound, frames, 1) < 0)
    return 0;

  amp = 0;
  for (i = 0; i < sound->channels; i++)
    amp += frames[i];
  amp /= sound->channels;

  return amp;
}

static int int_amp(int type, int deg)
{
  int a, param;

  param = type & ~(0xFF << 24);

  switch (type & (0xFF << 24)) {
  case ( 0x0 << 24): a = int_sin(deg, param); break;
  case ( 0x1 << 24): a = int_triangle(deg, param); break;
  case ( 0x2 << 24): a = int_pulse(deg, 1024 / 2); break;
  case ( 0x3 << 24): a = int_pulse(deg, param); break;
  case ( 0x4 << 24): a = int_sawup(deg, param); break;
  case ( 0x5 << 24): a = int_sawdown(deg, param); break;
  case ( 0x6 << 24): a = int_random(deg, param); break;
  case ( 0x7 << 24): a = int_noise(deg, param); break;
  case ( 0x8 << 24): a = int_zero(deg, param); break;
  case ( 0x9 << 24): a = int_high(deg, param); break;
  case ( 0xA << 24): a = int_inpulse(deg, param); break;
  case ( 0xC << 24): a = int_data(deg, param); break;
  default: a = 0; break;
  }

  return a;
}

static struct aunit *aunitset_search(struct aunitset *aunitset, int index)
{
  struct aunit *aunit;

  for (aunit = aunitset->aunits; aunit; aunit = aunit->next) {
    if (aunit->index == index)
      break;
  }

  return aunit;
}

static int aunit_regs_calc_envelope(struct aunit_regs *regs, int step)
{
  struct aunit *aunit;
  struct envpoint *p0;
  struct envpoint *p1;

  aunit = regs->aunit;

  if (!aunit->envelope.num)
    return 1024;

  p0 = &aunit->envelope.points[regs->envelope.index];

  if (regs->envelope.index >= aunit->envelope.num - 1)
    return p0->amp;

  p1 = p0 + 1;

  if (p0->step >= p1->step)
    return p0->amp;

  return p0->amp + muldiv(p1->amp - p0->amp, step - p0->step, p1->step - p0->step);
}

static int aunit_regs_calc_filter_bw(struct aunit_regs *regs, int amp, int step)
{
  struct aunit *aunit;
  int i, n, a, base;

  aunit = regs->aunit;

  if (aunit->filter.backward.num > 0) {
    n = regs->buffer.index;
    for (i = 0; i < aunit->filter.backward.num; i++) {
      base = 0;

      a = aunit->filter.backward.points[i].amp;

      if (aunit->filter.backward.points[i].flags & (1 << 7))
 a = (step < 1024) ? (base + muldiv(a - base, step, 1024)) : a;
      else if (aunit->filter.backward.points[i].flags & (1 << 8))
 a = (step < 1024) ? (a - muldiv(a - base, step, 1024)) : base;

      amp += muldiv(regs->buffer.out[n].amp, a, 1024);
      n = (n > 0) ? (n - 1) : (16 - 1);
      if (n == regs->buffer.index)
 break;
    }
  }

  return amp;
}

static int aunit_regs_calc_filter_fw(struct aunit_regs *regs, int amp, int step)
{
  struct aunit *aunit;
  int i, n, a, base;

  aunit = regs->aunit;

  if (aunit->filter.forward.num > 0) {
    amp = 0;
    n = regs->buffer.index;
    for (i = 0; i < aunit->filter.forward.num; i++) {
      base = (i == 0) ? 1024 : 0;

      a = aunit->filter.forward.points[i].amp;

      if (aunit->filter.forward.points[i].flags & (1 << 7))
 a = (step < 1024) ? (base + muldiv(a - base, step, 1024)) : a;
      else if (aunit->filter.forward.points[i].flags & (1 << 8))
 a = (step < 1024) ? (a - muldiv(a - base, step, 1024)) : base;

      amp += muldiv(regs->buffer.out[n].amp, a, 1024);
      n = (n > 0) ? (n - 1) : (16 - 1);
      if (n == regs->buffer.index)
 break;
    }
  }

  return amp;
}

static int calc_deg(int step, int freq, int samplefreq)
{
  return muldiv(step * freq, 256*4, samplefreq);
}

static int select_val(int val, int limit, int pval, int mval, int zval)
{
  if (val > limit) return pval;
  if (val < -limit) return mval;
  return zval;
}

static int aunit_regs_calc(struct aunit_regs *aunit_regs, int amp, int freq,
      int samplefreq, int step, int stepbase, int steplen)
{
  struct aunit_regs *regs;
  struct aunit *aunit;
  int i, deg, f, a, outamp = 0;



  int endstep, endstep_fixed, endstep_linear;

  if (!freq)
    return 0;

  if (!aunit_regs) {
    deg = calc_deg(step, freq, samplefreq);



    outamp = int_amp(( 0x0 << 24), deg);
  }

  for (regs = aunit_regs; regs; regs = regs->next) {
    aunit = regs->aunit;
    aunit->in.num = 0;
    aunit->in.amp = 0;
    aunit->out.amp = 0;
  }

  for (regs = aunit_regs; regs; regs = regs->next) {
    aunit = regs->aunit;
    aunit->out.amp = regs->out.amp;
    for (i = 0; i < aunit->outnum; i++) {
      if (aunit->outs[i].aunit) {
 aunit->outs[i].aunit->in.num++;
 aunit->outs[i].aunit->in.amp += muldiv(regs->out.amp, aunit->outs[i].amp, 1024);
      } else {



 outamp += muldiv(regs->out.amp, aunit->outs[i].amp, 1024);
      }
    }
  }
# 1017 "audio.c"
  endstep_linear = (steplen > 0) ? muldiv(step, 1024, steplen ) : 0;
  endstep_fixed = (stepbase > 0) ? muldiv(step, 1024, stepbase) : 0;

  for (regs = aunit_regs; regs; regs = regs->next) {
    aunit = regs->aunit;

    a = 0;

    if ((aunit->osc.type & (0xFF << 24)) == ( 0xB << 24)) {
      if (aunit->in.aunit)
 a = aunit->in.aunit->out.amp;
    } else {
      f = aunit->osc.freq;

      if ((aunit->osc.mod & (0xFF << 24)) == ( 0x1 << 24)) {
 f = f + muldiv(aunit->in.amp, f, 32767);
      }

      if (aunit->osc.flags & (1 << 0)) {
 deg = calc_deg(step, f, samplefreq);
      } else {
 deg = calc_deg(step, freq, samplefreq);
 deg = muldiv(deg, f, 1024);
      }

      deg += muldiv(aunit->osc.phase, 256*4, 1024);

      if ((aunit->osc.mod & (0xFF << 24)) == ( 0x0 << 24)) {
 deg = deg + muldiv(aunit->in.amp, 256*2, 32767);
      }

      a = int_amp(aunit->osc.type, deg);
    }

    a = muldiv(a, aunit->osc.amp, 1024);

    switch (aunit->osc.mod & (0xFF << 24)) {
    case ( 0x2 << 24): a = aunit->in.amp; break;
    case ( 0x3 << 24): a = a - aunit->in.amp; break;
    case ( 0x4 << 24): a = select_val(aunit->in.amp, a, aunit->in.amp, a + (a - aunit->in.amp), a + (a - aunit->in.amp)); break;
    case ( 0x5 << 24): a = select_val(aunit->in.amp, a, a + (a - aunit->in.amp), -a + (-a - aunit->in.amp), aunit->in.amp); break;
    case ( 0x6 << 24): a = select_val(aunit->in.amp, 0, a, -a, 0); break;
    case ( 0x7 << 24): a = select_val(aunit->in.amp, a, a, -a, aunit->in.amp); break;
    case ( 0x8 << 24): a = aunit->in.amp + a; break;
    case ( 0x9 << 24): a = aunit->in.amp - a; break;
    case ( 0xA << 24): a = aunit->in.amp * a; break;
    case ( 0xB << 24): a = aunit->in.amp & a; break;
    case ( 0xC << 24): a = aunit->in.amp | a; break;
    case ( 0xD << 24): a = aunit->in.amp ^ a; break;
    case ( 0xE << 24): a = (aunit->in.amp + a) / 2; break;
    case ( 0xF << 24): a = muldiv(aunit->in.amp, a, 32767); break;
    case (0x10 << 24): a = (aunit->in.amp < a) ? aunit->in.amp : a; break;
    case (0x11 << 24): a = (aunit->in.amp > a) ? aunit->in.amp : a; break;
    case (0x12 << 24): a = (aunit->in.amp < a) ? 32767 : -32767; break;
    case (0x13 << 24): a = (aunit->in.amp > a) ? 32767 : -32767; break;
    case ( 0x0 << 24):
    case ( 0x1 << 24):
    default:
      break;
    }

    endstep = (aunit->flags & (1 << 4)) ? endstep_fixed : endstep_linear;

    while ((regs->envelope.index + 1 < aunit->envelope.num) &&
    (aunit->envelope.points[regs->envelope.index + 1].step <= endstep)) {
      regs->envelope.index++;
    }
    a = muldiv(a, aunit_regs_calc_envelope(regs, endstep), 1024);

    endstep = (aunit->flags & (1 << 6)) ? endstep_fixed : endstep_linear;

    regs->buffer.out[regs->buffer.index].amp = a;
    a = aunit_regs_calc_filter_bw(regs, a, endstep);

    regs->buffer.out[regs->buffer.index].amp = a;
    a = aunit_regs_calc_filter_fw(regs, a, endstep);

    if (++regs->buffer.index == 16)
      regs->buffer.index = 0;

    regs->out.amp = a;
  }

  return muldiv(outamp, amp, 1024);
}

static int calc_frames(struct audio_data *audiodata, short *frames, int n)
{
  int i, ch, amp;
  struct player *player, **pp;
  struct samplestep stepend;
  struct aunitset *aunitset;

  if (audiodata->finished) {
    for (i = 0; i < n; i++) {
      frames[i] = 0;
      step_add(&audiodata->step, ((void *)0), 1, audiodata->samplefreq);
    }
    return n;
  }

  step_add(&stepend, &audiodata->step, n, audiodata->samplefreq);

  for (pp = &audiodata->ready; *pp;) {
    player = *pp;

    if (step_diff(&stepend, &player->step, audiodata->samplefreq) < 0) {
      pp = &player->nextplayer;
      continue;
    }

    if (player->next) {
      *pp = player->next;
      (*pp)->nextplayer = player->nextplayer;
    } else {
      *pp = player->nextplayer;
    }

    player->nextplayer = ((void *)0);

    player->next = audiodata->busy;
    audiodata->busy = player;
  }

  for (i = 0; i < n;) {
    amp = 0;
    for (pp = &audiodata->busy; *pp;) {
      player = *pp;

      step_add(&stepend, &player->step, player->steplen, audiodata->samplefreq);

      if (!(step_diff(&audiodata->step, &stepend, audiodata->samplefreq) < 0)) {
 *pp = player->next;
 aunit_regs_push(&player->head->pool, player->regs);
 player->regs = ((void *)0);
 player->next = audiodata->complete;
 audiodata->complete = player;
 continue;
      }

      if (!(step_diff(&audiodata->step, &player->step, audiodata->samplefreq) < 0)) {
 if (!player->regs) {
   aunitset = &aunitsets[player->aunitset_index];
   player->regs = aunit_regs_pop(&player->head->pool, aunitset);
 }
 amp += aunit_regs_calc(player->regs, player->amp,
          player->freq, audiodata->samplefreq,
          step_diff(&audiodata->step, &player->step, audiodata->samplefreq),
          player->stepbase, player->steplen);
      }
      pp = &player->next;
    }




    if (amp > 32767) amp = 32767;
    if (amp < -32767) amp = -32767;

    for (ch = 0; ch < audiodata->channels; ch++) {
      if (i < n)
 frames[i++] = amp;
    }

    step_add(&audiodata->step, ((void *)0), 1, audiodata->samplefreq);
  }

  n = i;

  if (!audiodata->ready && !audiodata->busy)
    audiodata->finished = 1;

  return n;
}
# 1281 "audio.c"
static int _run(struct audio_data *audiodata, unsigned int flags)
{






  audiodata->finished = 1;


  return 0;
}

static int _run_file(struct audio_data *audiodata, unsigned int flags, const char *filename)
{
  sound_t sound = ((void *)0);
  int r, bits = 16, n, samplenum;

  short frames[256];
  sound_type_t type;

  samplenum = step_num(&audiodata->length, audiodata->samplefreq);

  type = (flags & (1 << 13)) ? SOUND_TYPE_TEXT : SOUND_TYPE_WAV;

  sound = sound_create(type, flags);
  if (!sound)
    goto err;

  if ((r = sound_wopen(sound, filename, audiodata->samplefreq, audiodata->channels, bits, samplenum)) < 0)
    goto err;

  while (sound->offset < samplenum) {
    n = 256 / audiodata->channels;
    if (sound->offset + n >= samplenum)
      n = samplenum - sound->offset;
    calc_frames(audiodata, frames, n * audiodata->channels);
    sound_write(sound, frames, n);
    if (audiodata->finished)
      break;
  }

  if ((r = sound_wclose(sound)) < 0)
    goto err;

  sound_destroy(sound);

  audiodata->finished = 1;

  return 0;

err:
  if (sound)
    sound_destroy(sound);
  return -1;
}

static int player_aunit_regs_maxnum(struct player *player)
{
  struct aunitset *aunitset;
  int num = 0;

  for (; player; player = player->next) {
    if (!player->freq)
      continue;
    aunitset = &aunitsets[player->aunitset_index];
    if (num < aunitset->num)
      num = aunitset->num;
  }

  return num;
}

static struct player *player_run(struct player *player, struct samplestep *length, unsigned int flags, const char *filename)
{
  struct audio_data *audiodata;
  struct player *p, *ret = ((void *)0);
  int num = 0;

  audiodata = audiodata_alloc();
  if (!audiodata)
    return player;

  if (flags & (1 << 11)) {
    ret = player;
    player = player_copy(player);
  }

  for (p = player; p; p = p->nextplayer) {
    num++;
    p->pool = aunit_regs_alloc_num(player_aunit_regs_maxnum(p) * (p->duplicate + 1));
  }

  audiodata->finished = 0;
  audiodata->num = num;
  audiodata->samplefreq = sampling_freq;
  audiodata->channels = !(flags & (1 << 12)) ? 1 : 2;
  audiodata->samples = 256;
  step_copy(&audiodata->length, length);
  step_clear(&audiodata->step);

  audiodata->ready = player;
  audiodata->busy = ((void *)0);
  audiodata->complete = ((void *)0);

  audiodata->next = audiodata_list;
  audiodata_list = audiodata;

  if (filename)
    _run_file(audiodata, flags, filename);
  else
    _run(audiodata, flags);

  audiodata_list_clean();

  return ret;
}

static int _aunitset_index = 0;

int audio_stop(void)
{
  init();
  audiodata_list_stop();

  return 0;
}

int audio_clear(int aunitset_index)
{
  struct aunitset *aunitset;
  struct aunit *next;

  init();
  audiodata_list_stop();

  if (aunitset_index >= 64)
    return -1;

  if (aunitset_index < 0)
    return audio_clear_all();

  aunitset = &aunitsets[aunitset_index];

  player_free(playeres);
  playeres = ((void *)0);

  for (; aunitset->aunits; aunitset->aunits = next) {
    next = aunitset->aunits->next;
    _aunit_free(aunitset->aunits);
  }

  aunitset->num = 0;

  return 0;
}

int audio_clear_all(void)
{
  int r, i;

  init();
  audiodata_list_stop();

  for (i = 0; i < 64; i++) {
    if ((r = audio_clear(i)) < 0)
      return r;
  }

  return 0;
}

int audio_getsamplefreq(void)
{
  init();
  audiodata_list_clean();

  return sampling_freq;
}

int audio_setsamplefreq(int samplefreq)
{
  init();
  audiodata_list_clean();

  if (samplefreq <= 0)
    samplefreq = 44100;

  sampling_freq = samplefreq;

  return 0;
}

int audio_playnum(void)
{
  init();
  audiodata_list_clean();

  return audiodata_list_num();
}

int audio_wait(void)
{
  init();
  audiodata_list_clean();

  return audiodata_list_wait();
}

int audio_unitset(int aunitset_index)
{
  init();
  audiodata_list_clean();

  if (aunitset_index == -1)
    aunitset_index = 0;

  if ((aunitset_index < 0) || (aunitset_index >= 64))
    return -1;

  _aunitset_index = aunitset_index;

  return 0;
}

int audio_unit(int output, int amp, int flags, int aunitset_index)
{
  struct aunitset *aunitset;
  struct aunit *aunit;
  int r, n;

  init();
  audiodata_list_clean();

  if (aunitset_index == -1)
    aunitset_index = _aunitset_index;

  if ((aunitset_index < 0) || (aunitset_index >= 64))
    return -1;

  aunitset = &aunitsets[aunitset_index];

  if ((aunit = _aunit_alloc()) == ((void *)0))
    return -1;
  memset(aunit, 0, sizeof(*aunit));

  aunit->index = ++aunitset->num;
  aunit->flags = flags;

  aunit->osc.type = ( 0x8 << 24);
  aunit->osc.mod = ( 0x2 << 24);

  aunit->next = aunitset->aunits;
  aunitset->aunits = aunit;

  if (aunit->flags & (1 << 1)) {
    aunit->envelope.num = 0;
  } else if (aunit->flags & (1 << 2)) {
    n = 0;
    aunit->envelope.points[n ].step = 0;
    aunit->envelope.points[n++].amp = 1024;
    aunit->envelope.points[n ].step = 1024;
    aunit->envelope.points[n++].amp = 0;
    aunit->envelope.num = n;
  } else if (aunit->flags & (1 << 3)) {
    n = 0;
    aunit->envelope.points[n ].step = 0;
    aunit->envelope.points[n++].amp = 0;
    aunit->envelope.points[n ].step = 1024;
    aunit->envelope.points[n++].amp = 1024;
    aunit->envelope.num = n;
  }

  if (aunit->flags & (1 << 5)) {
    aunit->filter.forward.num = 0;
    aunit->filter.backward.num = 0;
  }

  if ((r = audio_addout(aunit->index, output, amp, flags, aunitset_index)) < 0) {
    aunitset->aunits = aunit->next;
    _aunit_free(aunit);
    return r;
  }

  return aunit->index;
}

int audio_osc(int index, int amp, int freq, int phase, int type, int mod, int flags, int aunitset_index)
{
  struct aunitset *aunitset;
  struct aunit *aunit;

  init();
  audiodata_list_clean();

  if (aunitset_index == -1)
    aunitset_index = _aunitset_index;

  if ((aunitset_index < 0) || (aunitset_index >= 64))
    return -1;

  aunitset = &aunitsets[aunitset_index];

  aunit = aunitset_search(aunitset, index);
  if (!aunit)
    return -1;

  aunit->osc.amp = amp;
  aunit->osc.freq = freq;
  aunit->osc.phase = phase;
  aunit->osc.type = type;
  aunit->osc.mod = mod;
  aunit->osc.flags = flags;

  if ((aunit->osc.type & (0xFF << 24)) == ( 0xB << 24)) {
    aunit->in.aunit = aunitset_search(aunitset, aunit->osc.type & ~(0xFF << 24));
  }

  return 0;
}

int audio_addout(int index, int output, int amp, int flags, int aunitset_index)
{
  struct aunitset *aunitset;
  struct aunit *aunit, *out;

  init();
  audiodata_list_clean();

  if (aunitset_index == -1)
    aunitset_index = _aunitset_index;

  if ((aunitset_index < 0) || (aunitset_index >= 64))
    return -1;

  aunitset = &aunitsets[aunitset_index];

  aunit = aunitset_search(aunitset, index);
  if (!aunit)
    return -1;

  if (aunit->outnum == 8)
    return -1;

  if (output < 0)
    return 0;

  if (output == 0) {
    out = ((void *)0);
  } else {
    out = aunitset_search(aunitset, output);
    if (!out)
      return -1;
  }

  aunit->outs[aunit->outnum ].amp = amp;
  aunit->outs[aunit->outnum++].aunit = out;

  return 0;
}

int audio_envpoint(int index, int n, int step, int amp, int flags, int aunitset_index)
{
  struct aunitset *aunitset;
  struct aunit *aunit;

  init();
  audiodata_list_clean();

  if (aunitset_index == -1)
    aunitset_index = _aunitset_index;

  if ((aunitset_index < 0) || (aunitset_index >= 64))
    return -1;

  aunitset = &aunitsets[aunitset_index];

  aunit = aunitset_search(aunitset, index);
  if (!aunit)
    return -1;

  if (flags & (1 << 1)) {
    aunit->envelope.num = 0;
    memset(aunit->envelope.points, 0, sizeof(aunit->envelope.points));
  }

  if (n < 0)
    n = aunit->envelope.num;

  if (n >= 16)
    return -1;

  aunit->envelope.points[n].step = step;
  aunit->envelope.points[n].amp = amp;
  aunit->envelope.points[n].flags = flags;
  n++;

  if (aunit->envelope.num < n)
    aunit->envelope.num = n;

  return 0;
}

int audio_envcopy(int index, int source, int flags, int aunitset_index)
{
  struct aunitset *aunitset;
  struct aunit *aunit, *saunit;
  int i;

  init();
  audiodata_list_clean();

  if (aunitset_index == -1)
    aunitset_index = _aunitset_index;

  if ((aunitset_index < 0) || (aunitset_index >= 64))
    return -1;

  aunitset = &aunitsets[aunitset_index];

  aunit = aunitset_search(aunitset, index);
  if (!aunit)
    return -1;

  saunit = aunitset_search(aunitset, source);
  if (!saunit)
    return -1;

  for (i = 0; i < 16; i++) {
    if (i < saunit->envelope.num) {
      aunit->envelope.points[i].step = saunit->envelope.points[i].step;
      aunit->envelope.points[i].amp = saunit->envelope.points[i].amp;
      aunit->envelope.points[i].flags = saunit->envelope.points[i].flags;
    } else {
      aunit->envelope.points[i].step = 0;
      aunit->envelope.points[i].amp = 0;
      aunit->envelope.points[i].flags = 0;
    }
  }

  aunit->envelope.num = saunit->envelope.num;

  return 0;
}

int audio_filpoint(int index, int type, int n, int amp, int flags, int aunitset_index)
{
  struct aunitset *aunitset;
  struct aunit *aunit;

  init();
  audiodata_list_clean();

  if (aunitset_index == -1)
    aunitset_index = _aunitset_index;

  if ((aunitset_index < 0) || (aunitset_index >= 64))
    return -1;

  aunitset = &aunitsets[aunitset_index];

  aunit = aunitset_search(aunitset, index);
  if (!aunit)
    return -1;

  switch (type) {
  case 0:
    if (flags & (1 << 5)) {
      aunit->filter.forward.num = 0;
      memset(aunit->filter.forward.points, 0, sizeof(aunit->filter.forward.points));
    }
    if (n < 0)
      n = aunit->filter.forward.num;
    if (n >= 16)
      return -1;
    aunit->filter.forward.points[n].amp = amp;
    aunit->filter.forward.points[n].flags = flags;
    n++;
    if (aunit->filter.forward.num < n)
      aunit->filter.forward.num = n;
    break;

  case 1:
    if (flags & (1 << 5)) {
      aunit->filter.backward.num = 0;
      memset(aunit->filter.backward.points, 0, sizeof(aunit->filter.backward.points));
    }
    if (n < 0)
      n = aunit->filter.backward.num;
    if (n >= 16)
      return -1;
    aunit->filter.backward.points[n].amp = amp;
    aunit->filter.backward.points[n].flags = flags;
    n++;
    if (aunit->filter.backward.num < n)
      aunit->filter.backward.num = n;
    break;

  default:
    return -1;
  }

  return 0;
}

int audio_filcopy(int index, int source, int flags, int aunitset_index)
{
  struct aunitset *aunitset;
  struct aunit *aunit, *saunit;
  int i;

  init();
  audiodata_list_clean();

  if (aunitset_index == -1)
    aunitset_index = _aunitset_index;

  if ((aunitset_index < 0) || (aunitset_index >= 64))
    return -1;

  aunitset = &aunitsets[aunitset_index];

  aunit = aunitset_search(aunitset, index);
  if (!aunit)
    return -1;

  saunit = aunitset_search(aunitset, source);
  if (!saunit)
    return -1;

  for (i = 0; i < 16; i++) {
    if (i < saunit->filter.forward.num) {
      aunit->filter.forward.points[i].amp = saunit->filter.forward.points[i].amp;
      aunit->filter.forward.points[i].flags = saunit->filter.forward.points[i].flags;
    } else {
      aunit->filter.forward.points[i].amp = 0;
      aunit->filter.forward.points[i].flags = 0;
    }
  }

  aunit->filter.forward.num = saunit->filter.forward.num;

  for (i = 0; i < 16; i++) {
    if (i < saunit->filter.backward.num) {
      aunit->filter.backward.points[i].amp = saunit->filter.backward.points[i].amp;
      aunit->filter.backward.points[i].flags = saunit->filter.backward.points[i].flags;
    } else {
      aunit->filter.backward.points[i].amp = 0;
      aunit->filter.backward.points[i].flags = 0;
    }
  }

  aunit->filter.backward.num = saunit->filter.backward.num;

  return 0;
}

static int code2scale[] = { 0, 2, 4, 5, 7, 9, 11 };

int audio_play(const char *mml, int flags, int aunitset_index, const char *filename)
{
  static struct player **pp;
  int scale, octadd = 0, oct, len;
  int interval, steplen, dot;
  static int octave = 3, length = 4, amp = 1024, tempo = 120, stepmod = 0;
  static struct samplestep step, max;
  int bracket = 0, bracketlen = 0, duplicate = 0;
  const char *s, *upper, *lower;
  char *p;

  init();
  audiodata_list_stop();

  if (aunitset_index == -1)
    aunitset_index = _aunitset_index;

  if ((aunitset_index < 0) || (aunitset_index >= 64))
    return -1;

  upper = "CDEFGAB";
  lower = "cdefgab";

  if (!playeres) {
    step_clear(&max);
  }

  if (!playeres || (flags & (1 << 10))) {
    pp = &playeres;
    step_clear(&step);
    stepmod = 0;
    duplicate = 0;
  }

  for (s = mml; s && *s;) {
    switch (*s) {
    case ' ':
    case '\t':
    case '\r':
    case '\n':
      s++;
      break;

    case 'O':
      s++;
      if (*s && isdigit(*s)) {
 octave = *s - '0';
 s++;
      }
      break;

    case '<':
      s++;
      octadd--;
      break;

    case '>':
      s++;
      octadd++;
      break;

    case 'L':
      s++;
      if (*s && isdigit(*s)) {
 length = strtol(s, &p, 10);
 if (s == p)
   goto err;
 s = p;
 length = length ? length : 4;
      }
      break;

    case 'V':
      s++;
      if (*s && isdigit(*s)) {
 amp = strtol(s, &p, 10);
 if (s == p)
   goto err;
 s = p;
      }
      break;

    case 'T':
      s++;
      if (*s && isdigit(*s)) {
 tempo = strtol(s, &p, 10);
 if (s == p)
   goto err;
 s = p;
 tempo = tempo ? tempo : 120;
      }
      break;

    case '@':
      s++;
      if (*s && isdigit(*s)) {
 aunitset_index = strtol(s, &p, 10);
 if (s == p)
   goto err;
 s = p;
 if (aunitset_index == -1)
   aunitset_index = 0;
 if ((aunitset_index < 0) || (aunitset_index >= 64))
   return -1;
      }
      break;

    case '(':
      s++;
      if (bracket)
 goto err;
      bracketlen = 0;
      bracket = 1;
      break;

    case ')':
      s++;
      if (!bracket)
 goto err;
      step_add(&step, ((void *)0), bracketlen, sampling_freq);
      bracket = 0;
      duplicate = 0;
      break;

    case 'R':
    case 'r':
    default:
      if ((*s == 'R') || (*s == 'r')) {
 scale = -1;
      } else if ((p = strchr(upper, *s)) != ((void *)0)) {
 scale = code2scale[p - upper];
      } else if ((p = strchr(lower, *s)) != ((void *)0)) {
 scale = code2scale[p - lower];
      } else {
 goto err;
      }
      s++;

      if (scale < 0) {
 oct = -1;
      } else {
 oct = octave + octadd;

 if (*s && ((*s == '#') || (*s == '+'))) {
   scale++;
   s++;
 }

 if (*s && (*s == '-')) {
   scale--;
   s++;
 }

 while (scale < 0) {
   scale += 12;
   oct--;
 }

 while (scale >= 12) {
   scale -= 12;
   oct++;
 }
      }

      len = length;
      if (*s && isdigit(*s)) {
 len = strtol(s, &p, 10);
 if (s == p)
   goto err;
 s = p;
      }

      if (len <= 0)
 goto err;
      interval = 64 / len;

      dot = interval / 2;
      while (*s && (*s == '.')) {
 interval += dot;
 s++;
      }





      steplen = muldiv(60 * interval, sampling_freq, 16);
      steplen += stepmod;
      stepmod = steplen % tempo;
      steplen = steplen / tempo;


      if (player_add(pp, aunitset_index, amp, scale, oct,
       &step, muldiv(sampling_freq, 60, tempo), steplen) < 0)
 goto err;
      if (pp == &playeres) {
 (*pp)->nextplayer = (*pp)->next;
 (*pp)->next = ((void *)0);
      }
      (*pp)->head = playeres;
      pp = &(*pp)->next;

      if (!bracket) {
 step_add(&step, ((void *)0), steplen, sampling_freq);
      } else {
 if (bracketlen < steplen)
   bracketlen = steplen;
 if (playeres->duplicate < duplicate)
   playeres->duplicate = duplicate;
 duplicate++;
      }

      break;
    }
  }

  if (step_diff(&max, &step, sampling_freq) < 0)
    step_copy(&max, &step);

  if (!(flags & (1 << 9))) {
    playeres = player_run(playeres, &max, flags, filename);
  }

  return 0;

err:
  return -1;
}

int audio_open(char *filename, int *lengthp, unsigned int flags)
{
  sound_t sound = ((void *)0);
  sound_type_t type;

  init();
  audiodata_list_stop();

  type = (flags & (1 << 13)) ? SOUND_TYPE_TEXT : SOUND_TYPE_WAV;

  sound = sound_create(type, flags);
  if (!sound)
    goto err;

  if (sound_ropen(sound, filename) < 0)
    goto err;

  if (lengthp) *lengthp = muldiv(sound->samplenum, 1000, sound->samplefreq);

  return sound_get_index(sound);

err:
  if (sound)
    sound_destroy(sound);
  return -1;
}

int audio_close(int index)
{
  sound_t sound;

  init();
  audiodata_list_stop();

  sound = sound_get_sound(index);

  if (!sound)
    return -1;

  sound_destroy(sound);

  return index;
}
