# 0 "term.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "term.c"
# 1 "config.h" 1
# 2 "term.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "term.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "term.c" 2
# 1 "../include/unistd.h" 1
# 14 "../include/unistd.h"
void _exit(int status);
pid_t fork(void);
int execve(const char *path, char *const argv[], char *const envp[]);

ssize_t read(int fd, void *buf, size_t nbytes);
ssize_t write(int fd, const void *buf, size_t nbytes);
int close(int fd);

int dup(int oldd);
int pipe(int fildes[2]);
int dup2(int oldd, int newd);
int pipe2(int fildes[2], int flags);

pid_t getpid(void);
pid_t getppid(void);
pid_t getsid(pid_t pid);
pid_t setsid(void);
pid_t getpgid(pid_t pid);
int setpgid(pid_t pid, pid_t pgrp);
pid_t getpgrp(void);

pid_t tcgetpgrp(int fd);
int tcsetpgrp(int fd, pid_t pgrp_id);

int unlink(const char *path);
int chdir(const char *path);
int chdir(const char *path);
int fchdir(int fd);
int chown(const char *path, uid_t owner, gid_t group);
off_t lseek(int fildes, off_t offset, int whence);
int access(const char *path, int mode);
void sync(void);
int fsync(int fd);
int fchown(int fd, uid_t owner, gid_t group);

int truncate(const char *path, off_t length);
int ftruncate(int fd, off_t length);


int brk(void *addr);



void *sbrk(intptr_t incr);

char *getcwd(char *buf, size_t size);

unsigned int sleep(unsigned int seconds);
int usleep(useconds_t microseconds);

int isatty(int fd);
# 6 "term.c" 2
# 1 "../include/fcntl.h" 1
# 42 "../include/fcntl.h"
int open(const char *path, int flags, ...);

int fcntl(int fd, int cmd, int args);
# 7 "term.c" 2



# 1 "../include/termios.h" 1



struct termios;
int tcgetattr(int fd, struct termios *t);
int tcsetattr(int fd, int action, const struct termios *t);
# 44 "../include/termios.h"
struct termios {
  unsigned int c_iflag;
  unsigned int c_oflag;
  unsigned int c_cflag;
  unsigned int c_lflag;
  unsigned char c_line;
  unsigned char c_cc[32];
  unsigned int c_ispeed;
  unsigned int c_ospeed;
};
# 11 "term.c" 2
# 21 "term.c"
# 1 "../include/nllibc/nllibc.h" 1
# 22 "term.c" 2


# 1 "const.h" 1
# 25 "term.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 26 "term.c" 2
# 1 "term.h" 1
# 30 "term.h"
int nll_term_init(void);
int nll_term_done(void);
int nll_term_start(int flags);
int nll_term_restore(int flags);
int nll_term_key(int flags);
# 27 "term.c" 2

static int savenum = 0;
# 42 "term.c"
static int term_init(void)
{
  return 0;
}

static int term_done(void)
{
  return 0;
}
# 115 "term.c"
static struct termios save;
static int savefl;

static int term_start(void)
{
  struct termios sets;

  if (!nll_is_tty())
    return 0;

  tcgetattr(0, &sets);

  save = sets;
  sets.c_lflag &= ~(0000010 | 0000002);
  sets.c_cc[5] = 0;
  sets.c_cc[6] = 1;
  tcsetattr(0, 0, &sets);

  savefl = fcntl(0, 3, 0);
  fcntl(0, 4, savefl | 04000);

  savenum = 0;

  return 0;
}

static int term_restore(void)
{
  if (!nll_is_tty())
    return 0;
  fcntl(0, 4, savefl);
  tcsetattr(0, 0, &save);
  return 0;
}
# 162 "term.c"
int nll_term_init(void)
{
  int r;




  if ((r = term_init()) < 0)
    return r;




  return 0;
}

int nll_term_done(void)
{
  int r;




  if ((r = term_done()) < 0)
    return r;




  return 0;
}

int nll_term_start(int flags)
{







  return term_start();



}

int nll_term_restore(int flags)
{







  return term_restore();



}
# 251 "term.c"
static int term_key(void)
{
  int r;
  unsigned char c;


  r = read(0, &c, 1);
# 271 "term.c"
  if (r <= 0)
    return -1;

  return c;
}

int nll_term_key(int flags)
{
  int i, escape = 0, k;

  static int key[8];

  for (i = 0; i < 64; i++) {







    k = term_key();
    if (k < 0)
      break;

    switch (escape) {
    case 0:
      if (k == 0x1b) {
 escape = k;
 continue;
      }
      break;

    default:
      switch (escape) {
      case 0x1b:
 escape = 0;



      case 0x4f:


      case 0x5b:


      case 0x5b35:


      case 0x5b36:

 escape = (escape << 8) | k;
 switch (escape) {
 case 0x4f64:
 case 0x5b41:
 case 0x5b42:
 case 0x5b43:
 case 0x5b44:
 case 0x5b357e:
 case 0x5b367e:
   k = escape;
   escape = 0;
   break;
 default:
   continue;
 }
 break;

      default:
 escape = 0;
 continue;
      }
      break;
    }

    if ((!savenum || (k != key[savenum - 1])) && (savenum < 8))
      key[savenum++] = k;
  }

  if (!savenum)
    return 0;

  k = key[0];
  for (i = 0; i < savenum - 1; i++)
    key[i] = key[i + 1];
  savenum--;

  return k;
}
