# 0 "string.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "string.c"
# 1 "config.h" 1
# 2 "string.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "string.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "string.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "string.c" 2
# 1 "../include/ctype.h" 1



int isalnum(int c);
int isalpha(int c);
int isascii(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);
int tolower(int c);
int toupper(int c);
# 7 "string.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 10 "string.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 13 "string.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 14 "string.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 15 "string.c" 2
# 1 "string.h" 1



struct string {
  struct string *next;
  char *s;
  int length;
  int size;
};

int string_check(void);
int string_alloc(string_t *stringp);
int string_free(string_t string);
int string_del(string_t string);
int string_init(void);
int string_done(void);
int string_set(string_t string, const char *s, int length);
char *string_buffer(void);
int string_buffer_size(void);
int string_dump_string(FILE *fp, string_t string);
int string_dump(FILE *fp, string_t string);
# 16 "string.c" 2

static int string_num = 0;
static int pool_num = 0;

static string_t head = ((void *)0);
static string_t pool = ((void *)0);

static string_t pool_alloc(void)
{
  string_t string;

  if (!pool)
    return ((void *)0);

  string = pool;
  pool = pool->next;
  pool_num--;

  return string;
}

static int pool_free(string_t string)
{
  string->next = pool;
  pool = string;
  pool_num++;
  return 0;
}


static char *buffer = ((void *)0);

static int _init(void)
{
  buffer = memory_alloc(65536 + 1);
  if (buffer == ((void *)0))
    return NLL_ERRCODE_STRING_BUFFER_OVER;
  return 0;
}

static int _done(void)
{
  while (pool)
    memory_free(pool_alloc());
  if (buffer) {
    memory_free(buffer);
    buffer = ((void *)0);
  }
  return 0;
}

static int _check(void)
{
  if (pool)
    return NLL_ERRCODE_STRING_NOT_EMPTY;
  if (buffer)
    return NLL_ERRCODE_STRING_NOT_EMPTY;
  return 0;
}

static string_t _alloc(void)
{
  string_t string;
  string = pool_alloc();
  if (!string)
    string = memory_alloc(sizeof(*string));
  return string;
}

static int _free(string_t string)
{
  if ((256 < 0) || (pool_num < 256))
    return pool_free(string);
  memory_free(string);
  return 0;
}
# 145 "string.c"
int string_check(void)
{
  if (string_num || head)
    return NLL_ERRCODE_STRING_NOT_EMPTY;

  return _check();
}

static int _string_free(string_t string)
{
  int r;


  if (string->s)
    memory_free(string->s);

  string->s = ((void *)0);

  string_num--;
  if ((r = _free(string)) < 0)
    return r;

  return 0;
}

int string_alloc(string_t *stringp)
{
  string_t string;
  int r;

  if ((string = _alloc()) == ((void *)0))
    goto err;
  string_num++;

  memset(string, 0, sizeof(*string));





  string->size = 16;
  string->s = memory_alloc(string->size);


  if (string->s == ((void *)0))
    goto err;

  memset(string->s, 0, string->size);

  string->next = head;
  head = string;

  *stringp = string;

  return 0;

err:
  if (string) {
    if ((r = _string_free(string)) < 0)
      return r;
  }

  return NLL_ERRCODE_STRING_BUFFER_OVER;
}

int string_free(string_t string)
{
  string_t next;
  int r;

  for (; string; string = next) {
    next = string->next;
    string->next = ((void *)0);
    if ((r = _string_free(string)) < 0)
      return r;
  }

  return 0;
}

int string_del(string_t string)
{
  string_t *p, next;

  for (p = &head; *p;) {
    if (*p == string) {
      next = (*p)->next;
      (*p)->next = ((void *)0);
      string_free(*p);
      *p = next;
      continue;
    }
    p = &((*p)->next);
  }

  return 0;
}

int string_init(void)
{
  string_num = 0;
  pool_num = 0;
  head = ((void *)0);
  pool = ((void *)0);
  return _init();
}

int string_done(void)
{
  return _done();
}

int string_set(string_t string, const char *s, int length)
{
  if (length < 0)
    length = strlen(s);

  if (length > 65536)
    return NLL_ERRCODE_STRING_TOO_LONG;


  if (string->size < length + 1) {
    while (string->size < length + 1)
      string->size *= 2;
    if (string->size > 65536 + 1)
      string->size = 65536 + 1;

    memory_free(string->s);
    string->s = memory_alloc(string->size);
    if (string->s == ((void *)0))
      return NLL_ERRCODE_STRING_BUFFER_OVER;

    memset(string->s, 0, string->size);
  }


  memcpy(string->s, s, length);

  string->length = length;
  string->s[length] = '\0';

  return 0;
}

char *string_buffer(void)
{
  return buffer;
}

int string_buffer_size(void)
{
  return 65536 + 1;
}

int string_dump_string(FILE *fp, string_t string)
{
  char *p, escape, c;
  int i;

  nll_wait_output(fp);
  fprintf(fp, "\"");

  for (p = string->s, i = 0; i < string->length; p++, i++) {
    nll_wait_output(fp);
    if (i >= 64) {
      fprintf(fp, "...");
      break;
    }
    escape = 0;
    switch (*p) {
    case '\t': escape = 1; c = 't'; break;
    case '\n': escape = 1; c = 'n'; break;
    case '\v': escape = 1; c = 'v'; break;
    case '\f': escape = 1; c = 'f'; break;
    case '\r': escape = 1; c = 'r'; break;
    case '\a': escape = 1; c = 'a'; break;
    default: c = *p; c = isprint(c) ? c : '.'; break;
    }
    fprintf(fp, "%s%c", (escape ? "\\" : ""), c);
  }

  fprintf(fp, "\"");

  return 0;
}

int string_dump(FILE *fp, string_t string)
{
  if (!string)
    string = head;

  nll_wait_output(fp);
  fprintf(fp, "\n-- String dump --\n");

  for (; string; string = string->next) {
    string_dump_string(fp, string);
    fprintf(fp, "\n");
  }

  fflush(fp);

  return 0;
}
