# 0 "nlllib.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "nlllib.c"
# 1 "config.h" 1
# 2 "nlllib.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "nlllib.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "nlllib.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "nlllib.c" 2
# 1 "../include/unistd.h" 1
# 14 "../include/unistd.h"
void _exit(int status);
pid_t fork(void);
int execve(const char *path, char *const argv[], char *const envp[]);

ssize_t read(int fd, void *buf, size_t nbytes);
ssize_t write(int fd, const void *buf, size_t nbytes);
int close(int fd);

int dup(int oldd);
int pipe(int fildes[2]);
int dup2(int oldd, int newd);
int pipe2(int fildes[2], int flags);

pid_t getpid(void);
pid_t getppid(void);
pid_t getsid(pid_t pid);
pid_t setsid(void);
pid_t getpgid(pid_t pid);
int setpgid(pid_t pid, pid_t pgrp);
pid_t getpgrp(void);

pid_t tcgetpgrp(int fd);
int tcsetpgrp(int fd, pid_t pgrp_id);

int unlink(const char *path);
int chdir(const char *path);
int chdir(const char *path);
int fchdir(int fd);
int chown(const char *path, uid_t owner, gid_t group);
off_t lseek(int fildes, off_t offset, int whence);
int access(const char *path, int mode);
void sync(void);
int fsync(int fd);
int fchown(int fd, uid_t owner, gid_t group);

int truncate(const char *path, off_t length);
int ftruncate(int fd, off_t length);


int brk(void *addr);



void *sbrk(intptr_t incr);

char *getcwd(char *buf, size_t size);

unsigned int sleep(unsigned int seconds);
int usleep(useconds_t microseconds);

int isatty(int fd);
# 7 "nlllib.c" 2







# 1 "../include/time.h" 1
# 11 "../include/time.h"
typedef long time_t;






time_t time(time_t *tloc);
# 15 "nlllib.c" 2
# 1 "../include/signal.h" 1
# 88 "../include/signal.h"
typedef void (*sig_t)(int);
# 106 "../include/signal.h"
typedef struct {
  unsigned int sig[2];
} sigset_t;

struct siginfo;
struct sigaction;


struct sigaction {
  union {
    void (*__sa_handler)(int);
    void (*__sa_sigaction)(int, struct siginfo *, void *);
  } __sigaction_u;
  sigset_t sa_mask;
  unsigned long sa_flags;

  void (*sa_restorer)(void);

};
# 193 "../include/signal.h"
struct sigcontext;
int sigreturn(struct sigcontext *scp);
# 216 "../include/signal.h"
int kill(pid_t pid, int sig);

int sigaction(int sig, const struct sigaction *act, struct sigaction *oact);
int sigprocmask(int how, const sigset_t *set, sigset_t *oset);

int killpg(pid_t pgrp, int sig);
# 16 "nlllib.c" 2
# 1 "../include/sys/time.h" 1
# 22 "../include/sys/time.h"
struct timeval {
  time_t tv_sec;
  long tv_usec;
};

struct timezone {
  int tz_minuteswest;
  int tz_dsttime;
};

struct timespec {
  time_t tv_sec;
  long tv_nsec;
};

typedef struct timezone *__timezone_ptr_t;
# 50 "../include/sys/time.h"
int gettimeofday(struct timeval *tp, struct timezone *tzp);
int settimeofday(const struct timeval *tp, const struct timezone *tzp);
# 17 "nlllib.c" 2
# 1 "../include/sys/select.h" 1





typedef unsigned long __fd_mask;




typedef struct fd_set {
  __fd_mask __fds_bits[(((1024) + (((sizeof(__fd_mask) * 8)) - 1)) / ((sizeof(__fd_mask) * 8)))];
} fd_set;
# 38 "../include/sys/select.h"
struct timeval;
struct timespec;
int select(int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, struct timeval *timeout);
int pselect(int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, const struct timespec *timeout, const sigset_t *newsigmask);
# 18 "nlllib.c" 2






# 1 "../include/nllibc/nllibc.h" 1
# 25 "nlllib.c" 2


# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 28 "nlllib.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 29 "nlllib.c" 2

FILE *nll_stdin = ((void *)0);
FILE *nll_stdout = ((void *)0);

void nll_error_print(const char *filename, int line,
       int errcode, const char *param)
{
  if (!param)
    param = "(?)";

  switch (errcode) {
  case NLL_ERRCODE_FILE_NOT_FOUND:
    fprintf(nll_stdout, "File not found: %s\n", param);
    break;
  case NLL_ERRCODE_LINE_BUFFER_OVER:
    fprintf(nll_stdout, "Line buffer overflow: %s\n", param);
    break;
  case NLL_ERRCODE_LINE_NOT_EMPTY:
    fprintf(nll_stdout, "Line not empty: %s\n", param);
    break;
  case NLL_ERRCODE_LINE_TOO_LONG:
    fprintf(nll_stdout, "Too long line: %s\n", param);
    break;
  case NLL_ERRCODE_LINE_NOT_FOUND:
    fprintf(nll_stdout, "Line not found: %s\n", param);
    break;
  case NLL_ERRCODE_VARIABLE_NOT_EMPTY:
    fprintf(nll_stdout, "Variable not empty: %s\n", param);
    break;
  case NLL_ERRCODE_VARIABLE_INVALID_NAME:
    fprintf(nll_stdout, "Invalid variable name: %s\n", param);
    break;
  case NLL_ERRCODE_VARIABLE_TOO_LONG:
    fprintf(nll_stdout, "Too long variable: %s\n", param);
    break;
  case NLL_ERRCODE_VARIABLE_BUFFER_OVER:
    fprintf(nll_stdout, "Variable buffer overflow: %s\n", param);
    break;
  case NLL_ERRCODE_VARIABLE_NOT_FOUND:
    fprintf(nll_stdout, "Variable not found: %s\n", param);
    break;
  case NLL_ERRCODE_VALUE_NOT_EMPTY:
    fprintf(nll_stdout, "Value not empty: %s\n", param);
    break;
  case NLL_ERRCODE_VALUE_BUFFER_OVER:
    fprintf(nll_stdout, "Value buffer overflow: %s\n", param);
    break;
  case NLL_ERRCODE_VALUE_INVALID_TYPE:
    fprintf(nll_stdout, "Invalid value type: %s\n", param);
    break;
  case NLL_ERRCODE_VALUE_CONST_VALUE:
    fprintf(nll_stdout, "Constant value: %s\n", param);
    break;
  case NLL_ERRCODE_VALUE_EMPTY_VALUE:
    fprintf(nll_stdout, "Empty value: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_NOT_EMPTY:
    fprintf(nll_stdout, "Formula not empty: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_BUFFER_OVER:
    fprintf(nll_stdout, "Calculation buffer overflow: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_LESS_PARAMETER:
    fprintf(nll_stdout, "Less parameter in operand: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_MUCH_PARAMETER:
    fprintf(nll_stdout, "Much parameter in operand: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_DIV_ZERO:
    fprintf(nll_stdout, "Division by zero: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_INVALID_OPERATOR:
    fprintf(nll_stdout, "Invalid operator: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_INVALID_PARAMETER:
    fprintf(nll_stdout, "Invalid parameter: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR:
    fprintf(nll_stdout, "Unsupported operator: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION:
    fprintf(nll_stdout, "Unknown function: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_NULL_POINTER:
    fprintf(nll_stdout, "Null pointer access: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_INVALID_POINTER:
    fprintf(nll_stdout, "Invalid pointer: %s\n", param);
    break;
  case NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION:
    fprintf(nll_stdout, "Unsupported function: %s\n", param);
    break;
  case NLL_ERRCODE_LABEL_NOT_EMPTY:
    fprintf(nll_stdout, "Label not empty: %s\n", param);
    break;
  case NLL_ERRCODE_LABEL_BUFFER_OVER:
    fprintf(nll_stdout, "Label buffer overflow: %s\n", param);
    break;
  case NLL_ERRCODE_LABEL_INVALID_NAME:
    fprintf(nll_stdout, "Invalid label name: %s\n", param);
    break;
  case NLL_ERRCODE_LABEL_TOO_LONG:
    fprintf(nll_stdout, "Too long label: %s\n", param);
    break;
  case NLL_ERRCODE_LABEL_NOT_FOUND:
    fprintf(nll_stdout, "Label not found: %s\n", param);
    break;
  case NLL_ERRCODE_LABEL_DUPLICATE:
    fprintf(nll_stdout, "Duplicate label: %s\n", param);
    break;
  case NLL_ERRCODE_POSITION_NOT_EMPTY:
    fprintf(nll_stdout, "Position not empty: %s\n", param);
    break;
  case NLL_ERRCODE_POSITION_STACK_OVER:
    fprintf(nll_stdout, "Position stack overflow: %s\n", param);
    break;
  case NLL_ERRCODE_POSITION_NOT_FOUND:
    fprintf(nll_stdout, "Position not found: %s\n", param);
    break;
  case NLL_ERRCODE_POSITION_DIFFERENT_TYPE:
    fprintf(nll_stdout, "Different position type: %s\n", param);
    break;
  case NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE:
    fprintf(nll_stdout, "Different position variable: %s\n", param);
    break;
  case NLL_ERRCODE_COMMAND_NOT_EMPTY:
    fprintf(nll_stdout, "Command not empty: %s\n", param);
    break;
  case NLL_ERRCODE_COMMAND_BUFFER_OVER:
    fprintf(nll_stdout, "Command buffer overflow: %s\n", param);
    break;
  case NLL_ERRCODE_COMMAND_TOO_LONG:
    fprintf(nll_stdout, "Too long command: %s\n", param);
    break;
  case NLL_ERRCODE_COMMAND_NOT_FOUND:
    fprintf(nll_stdout, "Command not found: %s\n", param);
    break;
  case NLL_ERRCODE_COMMAND_MUCH_ARGS:
    fprintf(nll_stdout, "Command has much arguments: %s\n", param);
    break;
  case NLL_ERRCODE_COMMAND_INVALID_FORMAT:
    fprintf(nll_stdout, "Command invalid format: %s\n", param);
    break;
  case NLL_ERRCODE_STRING_NOT_EMPTY:
    fprintf(nll_stdout, "String not empty: %s\n", param);
    break;
  case NLL_ERRCODE_STRING_TOO_LONG:
    fprintf(nll_stdout, "Too long string: %s\n", param);
    break;
  case NLL_ERRCODE_STRING_BUFFER_OVER:
    fprintf(nll_stdout, "String buffer overflow: %s\n", param);
    break;
  case NLL_ERRCODE_ARRAY_NOT_EMPTY:
    fprintf(nll_stdout, "Array not empty: %s\n", param);
    break;
  case NLL_ERRCODE_ARRAY_BUFFER_OVER:
    fprintf(nll_stdout, "Array buffer overflow: %s\n", param);
    break;
  case NLL_ERRCODE_ARRAY_OUT_OF_RANGE:
    fprintf(nll_stdout, "Out of array range: %s\n", param);
    break;
  case NLL_ERRCODE_ARRAY_INVALID_PARAMETER:
    fprintf(nll_stdout, "Invalid array parameter: %s\n", param);
    break;
  case NLL_ERRCODE_AREA_NOT_EMPTY:
    fprintf(nll_stdout, "Area not empty: %s\n", param);
    break;
  case NLL_ERRCODE_AREA_BUFFER_OVER:
    fprintf(nll_stdout, "Area buffer overflow: %s\n", param);
    break;
  case NLL_ERRCODE_AREA_OUT_OF_RANGE:
    fprintf(nll_stdout, "Out of area range: %s\n", param);
    break;
  case NLL_ERRCODE_STACK_NOT_EMPTY:
    fprintf(nll_stdout, "Stack not empty: %s\n", param);
    break;
  case NLL_ERRCODE_STACK_STACK_OVER:
    fprintf(nll_stdout, "Stack overflow: %s\n", param);
    break;
  case NLL_ERRCODE_STACK_NOT_FOUND:
    fprintf(nll_stdout, "Stack not found: %s\n", param);
    break;
  case NLL_ERRCODE_MEMORY_NOT_EMPTY:
    fprintf(nll_stdout, "Memory not empty: %s\n", param);
    break;
  case NLL_ERRCODE_MEMORY_BUFFER_OVER:
    fprintf(nll_stdout, "Memory buffer overflow: %s\n", param);
    break;
  case NLL_ERRCODE_MEMORY_INVALID_TYPE:
    fprintf(nll_stdout, "Invalid memory type: %s\n", param);
    break;
  case NLL_ERRCODE_MEMORY_INVALID_PARAMETER:
    fprintf(nll_stdout, "Invalid memory parameter: %s\n", param);
    break;
  case NLL_ERRCODE_NLL_SYNTAX_ERROR:
    fprintf(nll_stdout, "Syntax error: %s\n", param);
    break;
  case NLL_ERRCODE_NLL_SYMBOL_TOO_LONG:
    fprintf(nll_stdout, "Too long symbol name: %s\n", param);
    break;
  case NLL_ERRCODE_NLL_NO_CONTINUE_POINT:
    fprintf(nll_stdout, "No continue point: %s\n", param);
    break;
  case NLL_ERRCODE_NLL_INVALID_COMMAND:
    fprintf(nll_stdout, "Invalid command: %s\n", param);
    break;
  case NLL_ERRCODE_NLL_NO_DATA:
    fprintf(nll_stdout, "No data to read: %s\n", param);
    break;

  case NLL_ERRCODE_UNKNOWN:
  default:
    fprintf(nll_stdout, "Unknown error: (%s:%d): %s\n", filename, line, param);
    break;
  }
}

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param)
{
  nll_error_print(filename, line, errcode, param);
  exit(1);
}
# 272 "nlllib.c"
void nll_usleep(int usec)
{
  usleep(usec);
}

void nll_sleep(int sec)
{
  sleep(sec);
}

static int nosystem = 0;

int nll_is_nosystem(void)
{
  return nosystem;
}

int nll_nosystem_set(void)
{
  nosystem = 1;
  return 0;
}

static int nosyscall = 0;

int nll_is_nosyscall(void)
{
  return nosyscall;
}

int nll_nosyscall_set(void)
{
  nosyscall = 1;
  return 0;
}

static int nonetwork = 0;

int nll_is_nonetwork(void)
{
  return nonetwork;
}

int nll_nonetwork_set(void)
{
  nonetwork = 1;
  return 0;
}

static int nofixed = 0;

int nll_is_nofixed(void)
{
  return nofixed;
}

int nll_nofixed_set(void)
{
  nofixed = 1;
  return 0;
}

static int istty = 0;

int nll_is_tty(void)
{
  return istty;
}

int nll_tty_clear(void)
{
  istty = 0;
  return 0;
}

int nll_tty_set(void)
{
  istty = 1;
  return 0;
}

static int initialize = 0;

int nll_is_initialize(void)
{
  return initialize;
}

int nll_initialize_clear(void)
{
  initialize = 0;
  return 0;
}

int nll_initialize_set(void)
{
  initialize = 1;
  return 0;
}

static int edit_line = -1;

int nll_edit(void)
{
  return edit_line;
}

int nll_edit_clear(void)
{
  edit_line = -1;
  return 0;
}

int nll_edit_set(int line)
{
  edit_line = line;
  return 0;
}

static int finished = 0;
static int finished_lock = 0;

void nll_finished_clear(void)
{
  finished = 0;
}

void nll_finish(void)
{
  finished++;
}

int nll_is_finished(void)
{
  return finished_lock ? (finished > 4) : (finished > 0);
}

int nll_finish_lock(int locked)
{
  int old;
  old = finished_lock;
  finished_lock = locked;
  return old;
}

int nll_finish_is_locked(void)
{
  return finished_lock;
}

static struct file_entry {
  struct file_entry *next;
  FILE *fp;
} *nll_fps = ((void *)0);

static int nll_file_alloc(FILE *fp)
{
  struct file_entry *f;

  f = memory_alloc(sizeof(*f));
  if (!f)
    return NLL_ERRCODE_MEMORY_BUFFER_OVER;

  f->fp = fp;
  f->next = nll_fps;
  nll_fps = f;

  return 0;
}

int nll_file_stdin(void)
{
  return nll_file_alloc(stdin);
}

int nll_file_open(const char *filename)
{
  int r;
  FILE *fp;

  fp = fopen(filename, "r");
  if (!fp)
    return NLL_ERRCODE_FILE_NOT_FOUND;

  if ((r = nll_file_alloc(fp)) < 0)
    fclose(fp);

  return r;
}

int nll_file_close(void)
{
  struct file_entry *f;

  if (!nll_fps)
    return NLL_ERRCODE_FILE_NOT_FOUND;

  f = nll_fps;
  nll_fps = nll_fps->next;

  if (f->fp != stdin)
    fclose(f->fp);

  memory_free(f);

  return 0;
}

int nll_file_allclose(void)
{
  while (nll_fps)
    nll_file_close();
  return 0;
}

FILE *nll_file_fp(void)
{
  return nll_fps ? nll_fps->fp : ((void *)0);
}

static FILE *_nll_stdin = ((void *)0);
static FILE *_nll_stdout = ((void *)0);

int nll_stdin_save(FILE *fp)
{
  if (!_nll_stdin) {
    _nll_stdin = nll_stdin;
  } else {
    fclose(nll_stdin);
  }
  nll_stdin = fp;
  return 0;
}

int nll_stdin_restore(void)
{
  if (!_nll_stdin) {
    ;
  } else {
    fclose(nll_stdin);
    nll_stdin = _nll_stdin;
    _nll_stdin = ((void *)0);
  }
  return 0;
}

int nll_stdout_save(FILE *fp)
{
  fflush(nll_stdout);
  if (!_nll_stdout) {
    _nll_stdout = nll_stdout;
  } else {
    fclose(nll_stdout);
  }
  nll_stdout = fp;
  return 0;
}

int nll_stdout_restore(void)
{
  if (!_nll_stdout) {
    ;
  } else {
    fflush(nll_stdout);
    fclose(nll_stdout);
    nll_stdout = _nll_stdout;
    _nll_stdout = ((void *)0);
  }
  return 0;
}

int nll_wait_output(FILE *fp)
{

  int r, fd;
  fd_set fds;
  struct timeval t;

  if (!fp)
    fp = nll_stdout;

  while (1) {
    fd = fileno(fp);
    do { int i, n; n = (((1024) + (((sizeof(__fd_mask) * 8)) - 1)) / ((sizeof(__fd_mask) * 8))); for (i = 0; i < n; i++) (&fds)->__fds_bits[i] = 0; } while (0);
    (((&fds)->__fds_bits[(fd) / (sizeof(__fd_mask) * 8)]) |= ((__fd_mask)1 << ((fd) % (sizeof(__fd_mask) * 8))));
    t.tv_sec = 0;
    t.tv_usec = 100000;

    r = select(fd + 1, ((void *)0), &fds, ((void *)0), &t);

    if (r > 0) {
      if (((((&fds)->__fds_bits[(fd) / (sizeof(__fd_mask) * 8)]) & ((__fd_mask)1 << ((fd) % (sizeof(__fd_mask) * 8)))) != 0))
 break;
      continue;
    }

    if (r == 0)
      break;
  }





  return 0;
}

char *nll_fgets(char *str, int size, FILE *fp)
{
  char *p, *e, *last;

  p = str;
  e = ((void *)0);

  while (fgets(p, size - (p - str), fp)) {
    e = p + strlen(p);
    for (last = e; last > p; last--) {
      if (*last && !strchr(" \t\n", *last))
 break;
    }
    if (*last != '\\')
      break;
    *last = '\0';
    p = last;
  }

  if (!e || (e - str) + 1 >= size)
    return ((void *)0);

  return str;
}
