# 0 "nll.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "nll.c"
# 1 "config.h" 1
# 2 "nll.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "nll.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "nll.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "nll.c" 2
# 1 "../include/ctype.h" 1



int isalnum(int c);
int isalpha(int c);
int isascii(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);
int tolower(int c);
int toupper(int c);
# 7 "nll.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 10 "nll.c" 2


# 1 "const.h" 1
# 13 "nll.c" 2
# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 14 "nll.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 15 "nll.c" 2
# 1 "nllmain.h" 1



int nll_init(FILE *in, FILE *out);
int nll_new(void);
int nll_done(void);

int nll_make_argc(int argc);
int nll_make_argv(int argc, char *argv[]);
int nll_set_arg(int index, value_t arg);
int nll_del_argc(void);
int nll_del_argv(void);

int nll_main(int argc, char *argv[], int quit, int auto_run, int auto_number, char *command);
# 16 "nll.c" 2
# 1 "formula.h" 1



typedef enum {
  ELEMENT_TYPE_NONE,
  ELEMENT_TYPE_SYMBOL,
  ELEMENT_TYPE_INTEGER,
  ELEMENT_TYPE_STRING,

  ELEMENT_TYPE_FLOAT,

  ELEMENT_TYPE_VARIABLE,
  ELEMENT_TYPE_OPERATOR,
  ELEMENT_TYPE_ELEMENTS,
} element_type_t;

int formula_check(void);
int formula_init(void);
int formula_done(void);
int formula_get_symbol(char *dname, const char *name);
element_type_t formula_get_type(element_t element);
value_t formula_get_value(element_t element);
variable_t formula_get_variable(element_t element);
int formula_set_raw(element_t element);
int formula_free(element_t *elementp);
int formula_clean(element_t element);
int formula_parse(char *formula, char **endp, element_t *elementp, const char *terminator);
int formula_proc(element_t element, value_t *valuep);
int formula_dump(FILE *fp, element_t element);
int formula_operator_list(FILE *fp);
# 17 "nll.c" 2
# 1 "command.h" 1



typedef enum {
  COMMAND_UNKNOWN = 0,
  COMMAND_NONE,

  COMMAND_COMMENT,
  COMMAND_END,
  COMMAND_EXIT,
  COMMAND_ARGS,
  COMMAND_LET,
  COMMAND_PRINT,
  COMMAND_GOTO,
  COMMAND_GONEXT,
  COMMAND_GOSUB,
  COMMAND_RETURN,
  COMMAND_IF,
  COMMAND_ELSE,
  COMMAND_ENDIF,
  COMMAND_LOOP,
  COMMAND_LOOPEND,
  COMMAND_FOR,
  COMMAND_NEXT,
  COMMAND_DISCARD,
  COMMAND_DIM,
  COMMAND_MEMORY,
  COMMAND_PUSH,
  COMMAND_POP,
  COMMAND_DFROM,
  COMMAND_DREAD,
  COMMAND_DATA,
  COMMAND_RUN,
  COMMAND_STOP,
  COMMAND_SKIP,
  COMMAND_BREAK,
  COMMAND_STEP,
  COMMAND_CONTINUE,
  COMMAND_NEW,
  COMMAND_LIST,
  COMMAND_SAVE,
  COMMAND_LOAD,
  COMMAND_STDIN,
  COMMAND_STDOUT,
  COMMAND_EVAL,
  COMMAND_EVALF,
  COMMAND_EDIT,
  COMMAND_WAIT,
  COMMAND_DUMP,

  COMMAND_LAST
} command_type_t;

typedef enum {
  COMMAND_ARG_UNKNOWN = 0,
  COMMAND_ARG_LABEL,
  COMMAND_ARG_VARIABLE,
  COMMAND_ARG_FORMULA,
  COMMAND_ARG_WORD,
} command_arg_type_t;

typedef const struct command_ope {
  const char *name;
  const char *other_name;
  command_type_t type;
} *command_ope_t;

typedef struct command_arg {
  command_arg_type_t type;
  union {
    struct {
      label_t label;
    } label;
    struct {
      variable_t variable;
    } variable;
    struct {
      element_t element;
    } formula;
    struct {
      char word[16 + 1];
    } word;
  } arg;
} *command_arg_t;

struct command {
  struct command *next;
  command_ope_t ope;
  char *line;
  int errcode;
  struct {
    label_t label;
    variable_t variable;
    element_t args;
  } label;
  element_t prefix;
  struct command_arg args[4];
};

int command_check(void);
int command_search(char *p, char **endp, command_ope_t *opep);
int command_list(FILE *fp);
int command_get(command_type_t type, command_ope_t *opep);
int command_alloc(command_t *commandp);
int command_free(command_t command);
int command_set_label(command_t command, const char *name, spot_t spot);
int command_clear_label(command_t command);
int command_clear(command_t command);
int command_clean(command_t command);
int command_init(void);
int command_done(void);
int command_dump(FILE *fp, command_t command);
# 18 "nll.c" 2
# 1 "line.h" 1



struct line {
  struct line *next;
  struct line *prev;
  char buffer[256 + 1];
  command_t commands;
};

int line_check(void);
int line_alloc(line_t *linep);
int line_free(line_t line);
int line_clear(void);
int line_clean(void);
int line_init(void);
int line_done(void);
line_t line_head(void);
line_t line_tail(void);
int line_list_num(void);
int line_is_exist(line_t line);
int line_get(int number, line_t *linep);
int line_set(int number, int number2, char *buffer, line_t *linep, int save, int move);
int line_print(FILE *fp, int start_number, int end_number);
int line_dump(FILE *fp, line_t line);
# 19 "nll.c" 2
# 1 "label.h" 1



struct label {
  struct label *next;
  struct label *prev;
  struct spot spot;
  int refcount;
  char name[32 + 1];
};

int label_check(void);
int label_init(void);
int label_done(void);
int label_get(const char *name, label_t *labelp);
int label_set(const char *name, spot_t spot, label_t *labelp);
int label_clear(label_t label);
int label_clean(label_t label);
int label_del(label_t label);
int label_dump(FILE *fp, label_t label);
# 20 "nll.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 21 "nll.c" 2
# 1 "string.h" 1



struct string {
  struct string *next;
  char *s;
  int length;
  int size;
};

int string_check(void);
int string_alloc(string_t *stringp);
int string_free(string_t string);
int string_del(string_t string);
int string_init(void);
int string_done(void);
int string_set(string_t string, const char *s, int length);
char *string_buffer(void);
int string_buffer_size(void);
int string_dump_string(FILE *fp, string_t string);
int string_dump(FILE *fp, string_t string);
# 22 "nll.c" 2
# 1 "variable.h" 1



struct variable {
  struct variable *next;
  struct variable *prev;
  value_t value;
  int refcount;
  char name[32 + 1];
};

int variable_check(void);
int variable_del(variable_t variable);
int variable_clean(void);
int variable_clear(void);
int variable_new(variable_t variable);
int variable_init(void);
int variable_done(void);
int variable_get(const char *name, variable_t *variablep);
int variable_dump(FILE *fp, variable_t variable);
int variable_const_list(FILE *fp);
# 23 "nll.c" 2
# 1 "position.h" 1



struct position {
  position_type_t type;
  struct spot spot;
  value_t value;
  int arg;
};

int position_check(void);
int position_init(void);
int position_clear(void);
int position_clean(void);
int position_push(position_type_t type, spot_t spot, value_t value, int arg);
int position_pop(position_type_t type, position_type_t *typep,
   spot_t spot, value_t value, int *argp);
int position_peek(position_type_t type, spot_t spot, value_t *valuep, int *argp);
position_type_t position_get_type(void);
int position_get(spot_t spot, position_t *positionp);
int position_set(spot_t spot, position_t position);
int position_reset(position_t position);
int position_dump(FILE *fp);
# 24 "nll.c" 2
# 1 "array.h" 1



struct array {
  value_t value;
};

int array_check(void);
int array_init(void);
int array_get_number(array_t array);
int array_get_value(array_t array, int index, value_t *valuep);
int array_set_value(array_t array, int index, value_t value);
int array_alloc(array_t *arrayp, int number);
int array_free(array_t array, int number);
int array_make(value_t value, int *n);
int array_make_values(value_t value, value_t numbers);
int array_dump(FILE *fp, array_t array);
# 25 "nll.c" 2
# 1 "area.h" 1



struct area {
  struct area *next;
  struct area *prev;
  int refcount;
  int size;
  int area_size;
};

int area_check(void);
int area_alloc(area_t *areap, int size);
int area_free(area_t area);
int area_init(void);
int area_get_size(area_t area);
char *area_get_buffer(area_t area);
int area_copy_area(area_t area, int offset, area_t _area, int _offset, int size);
int area_read(area_t area, int offset, char *buffer, int size);
int area_write(area_t area, int offset, char *buffer, int size);
int area_read_integer(area_t area, int offset, integer_t *integerp, int size);
int area_write_integer(area_t area, int offset, integer_t integer, int size);
int area_dump(FILE *fp, area_t area);
# 26 "nll.c" 2
# 1 "stack.h" 1





typedef enum {
  STACK_TYPE_USER = 0,
  STACK_TYPE_CALL,
} stack_type_t;

struct stack_frame {
  value_t value;
};

int stack_check(void);
int stack_init(void);
int stack_getnum(void);
int stack_push_type(stack_type_t type, value_t value);
int stack_pop_type(stack_type_t type, value_t value);
int stack_push(value_t value);
int stack_pop(value_t value);
int stack_clear(void);
int stack_clean(void);
int stack_dump(FILE *fp);
# 27 "nll.c" 2
# 1 "function.h" 1



enum {
  FUNCTION_TYPE_NONE = 0,
  FUNCTION_TYPE_FARGS,
  FUNCTION_TYPE_COPY,
  FUNCTION_TYPE_TRUE,
  FUNCTION_TYPE_FALSE,
  FUNCTION_TYPE_ARGNUM,
  FUNCTION_TYPE_BOOLEAN,
  FUNCTION_TYPE_COND,
  FUNCTION_TYPE_AT,
  FUNCTION_TYPE_FPUSH,
  FUNCTION_TYPE_FPOP,
  FUNCTION_TYPE_STACKNUM,
  FUNCTION_TYPE_FPRINT,
  FUNCTION_TYPE_SPRINTF,
  FUNCTION_TYPE_PRINTF,
  FUNCTION_TYPE_PRINTM,
  FUNCTION_TYPE_INPUT,
  FUNCTION_TYPE_INPUTN,
  FUNCTION_TYPE_FWAIT,
  FUNCTION_TYPE_TIMER,
  FUNCTION_TYPE_NOSYSTEM,
  FUNCTION_TYPE_NOSYSCALL,
  FUNCTION_TYPE_NONETWORK,





  FUNCTION_TYPE_SYSTEM,


  FUNCTION_TYPE_SYSCALL,

  FUNCTION_TYPE_FEVAL,
  FUNCTION_TYPE_FEVALF,
  FUNCTION_TYPE_TYPEOF,
  FUNCTION_TYPE_TYPENAME,
  FUNCTION_TYPE_SIZEOF,
  FUNCTION_TYPE_NZERO,
  FUNCTION_TYPE_CMP,
  FUNCTION_TYPE_REP,
  FUNCTION_TYPE_INSERT,
  FUNCTION_TYPE_DELETE,
  FUNCTION_TYPE_ITOC,
  FUNCTION_TYPE_CTOI,
  FUNCTION_TYPE_ITOA,
  FUNCTION_TYPE_ATOI,

  FUNCTION_TYPE_ITOF,
  FUNCTION_TYPE_FTOI,
  FUNCTION_TYPE_ATOF,
  FUNCTION_TYPE_FTOA,

  FUNCTION_TYPE_ISALNUM,
  FUNCTION_TYPE_ISALPHA,
  FUNCTION_TYPE_ISASCII,
  FUNCTION_TYPE_ISCNTRL,
  FUNCTION_TYPE_ISDIGIT,
  FUNCTION_TYPE_ISGRAPH,
  FUNCTION_TYPE_ISLOWER,
  FUNCTION_TYPE_ISPRINT,
  FUNCTION_TYPE_ISPUNCT,
  FUNCTION_TYPE_ISSPACE,
  FUNCTION_TYPE_ISUPPER,
  FUNCTION_TYPE_ISXDIGIT,
  FUNCTION_TYPE_TOLOWER,
  FUNCTION_TYPE_TOUPPER,
  FUNCTION_TYPE_LEFT,
  FUNCTION_TYPE_RIGHT,
  FUNCTION_TYPE_MID,
  FUNCTION_TYPE_INSTR,
  FUNCTION_TYPE_STRLEN,
  FUNCTION_TYPE_STRCPY,
  FUNCTION_TYPE_SPLIT,
  FUNCTION_TYPE_SPLITS,
  FUNCTION_TYPE_CHOMP,
  FUNCTION_TYPE_LCHOMP,
  FUNCTION_TYPE_RCHOMP,
  FUNCTION_TYPE_SRAND,
  FUNCTION_TYPE_RAND,
  FUNCTION_TYPE_INT,
  FUNCTION_TYPE_ABS,
  FUNCTION_TYPE_SIGN,
  FUNCTION_TYPE_MAX,
  FUNCTION_TYPE_MIN,
  FUNCTION_TYPE_ABS2SUM,
  FUNCTION_TYPE_TIME,
  FUNCTION_TYPE_DATE,
  FUNCTION_TYPE_FDIM,
  FUNCTION_TYPE_FMEMORY,
  FUNCTION_TYPE_PEEK,
  FUNCTION_TYPE_POKE,
  FUNCTION_TYPE_MREAD,
  FUNCTION_TYPE_MWRITE,
  FUNCTION_TYPE_MCOPY,
# 127 "function.h"
  FUNCTION_TYPE_RENAME,
  FUNCTION_TYPE_UNLINK,
  FUNCTION_TYPE_TRUNCATE,
  FUNCTION_TYPE_MKDIR,
  FUNCTION_TYPE_RMDIR,
  FUNCTION_TYPE_CHDIR,
  FUNCTION_TYPE_OPEN,
  FUNCTION_TYPE_CLOSE,
  FUNCTION_TYPE_READ,
  FUNCTION_TYPE_WRITE,
  FUNCTION_TYPE_LSEEK,
  FUNCTION_TYPE_FTRUNCATE,
  FUNCTION_TYPE_ISREADABLE,
  FUNCTION_TYPE_ISWRITABLE,
  FUNCTION_TYPE_FOPEN,
  FUNCTION_TYPE_FDOPEN,
  FUNCTION_TYPE_FCLOSE,
  FUNCTION_TYPE_FILENO,
  FUNCTION_TYPE_FEOF,
  FUNCTION_TYPE_FERROR,
  FUNCTION_TYPE_FGETC,
  FUNCTION_TYPE_FPUTC,
  FUNCTION_TYPE_FGETS,
  FUNCTION_TYPE_FPUTS,
  FUNCTION_TYPE_FPRINTF,
  FUNCTION_TYPE_FREAD,
  FUNCTION_TYPE_FWRITE,
  FUNCTION_TYPE_FSEEK,
  FUNCTION_TYPE_QOPEN,
  FUNCTION_TYPE_QCLOSE,
  FUNCTION_TYPE_QLENGTH,
  FUNCTION_TYPE_QPUSHF,
  FUNCTION_TYPE_QPOPL,
  FUNCTION_TYPE_QPUSHL,
  FUNCTION_TYPE_QPOPF,
# 175 "function.h"
  FUNCTION_TYPE_KEYNAME,
  FUNCTION_TYPE_KEYCODE,
  FUNCTION_TYPE_SCREEN,
  FUNCTION_TYPE_SCRSTAT,
  FUNCTION_TYPE_FLUSH,
  FUNCTION_TYPE_GETCOLOR,
  FUNCTION_TYPE_GETFGCOLOR,
  FUNCTION_TYPE_GETBGCOLOR,
  FUNCTION_TYPE_SETCOLOR,
  FUNCTION_TYPE_GETATTR,
  FUNCTION_TYPE_SETATTR,
  FUNCTION_TYPE_GETPOS,
  FUNCTION_TYPE_MOVE,
  FUNCTION_TYPE_GETCH,
  FUNCTION_TYPE_CLEAR,
  FUNCTION_TYPE_SCROLL,
  FUNCTION_TYPE_LINE,
  FUNCTION_TYPE_BOX,
  FUNCTION_TYPE_INKEY,
  FUNCTION_TYPE_GSCREEN,
  FUNCTION_TYPE_GSCRSTAT,
  FUNCTION_TYPE_GCOLOR,
  FUNCTION_TYPE_GRGB,
  FUNCTION_TYPE_GSYNC,
  FUNCTION_TYPE_GFLUSH,
  FUNCTION_TYPE_GGETMAINIMG,
  FUNCTION_TYPE_GSETMAINIMG,
  FUNCTION_TYPE_GGETSIZE,
  FUNCTION_TYPE_GGETRANGE,
  FUNCTION_TYPE_GSETRANGE,
  FUNCTION_TYPE_GGETOFFSET,
  FUNCTION_TYPE_GSETOFFSET,
  FUNCTION_TYPE_GGETSCALE,
  FUNCTION_TYPE_GSETSCALE,
  FUNCTION_TYPE_GGETDOTOFFSET,
  FUNCTION_TYPE_GSETDOTOFFSET,
  FUNCTION_TYPE_GGETDOTSIZE,
  FUNCTION_TYPE_GSETDOTSIZE,
  FUNCTION_TYPE_GGETCOLOR,
  FUNCTION_TYPE_GSETCOLOR,
  FUNCTION_TYPE_GGETPIXEL,
  FUNCTION_TYPE_GCLEAR,
  FUNCTION_TYPE_GSCROLL,
  FUNCTION_TYPE_GDOT,
  FUNCTION_TYPE_GLINE,
  FUNCTION_TYPE_GBOX,
  FUNCTION_TYPE_GCIRCLE,
  FUNCTION_TYPE_GPAINT,
  FUNCTION_TYPE_GCOPY,
  FUNCTION_TYPE_GROTATE,
  FUNCTION_TYPE_GCHAR,
  FUNCTION_TYPE_GPRINT,
  FUNCTION_TYPE_GINKEY,
  FUNCTION_TYPE_GKEYSTAT,
  FUNCTION_TYPE_GMOUSEPOS,
  FUNCTION_TYPE_GINMOUSE,
  FUNCTION_TYPE_GMOUSESTAT,
  FUNCTION_TYPE_GALLOCIMAGE,
  FUNCTION_TYPE_GFREEIMAGE,
  FUNCTION_TYPE_GLOADIMAGE,
  FUNCTION_TYPE_GSAVEIMAGE,
  FUNCTION_TYPE_GCMPIMAGE,
  FUNCTION_TYPE_GCHARSET,
  FUNCTION_TYPE_ASTOP,
  FUNCTION_TYPE_ACLEAR,
  FUNCTION_TYPE_ASOUND,
  FUNCTION_TYPE_ASNDSTAT,
  FUNCTION_TYPE_APLAYNUM,
  FUNCTION_TYPE_AWAIT,
  FUNCTION_TYPE_AUNITSET,
  FUNCTION_TYPE_AUNIT,
  FUNCTION_TYPE_AOSC,
  FUNCTION_TYPE_AADDOUT,
  FUNCTION_TYPE_AENVPOINT,
  FUNCTION_TYPE_AENVCOPY,
  FUNCTION_TYPE_AFILPOINT,
  FUNCTION_TYPE_AFILCOPY,
  FUNCTION_TYPE_APLAY,
  FUNCTION_TYPE_AOPEN,
  FUNCTION_TYPE_ACLOSE,
};

const char *function_name(function_t function);
int function_search(const char *name, function_t *functionp);
int function_list(FILE *fp);
int function_proc(function_t function, value_t *valuep, value_t args);
# 28 "nll.c" 2
# 1 "key.h" 1



typedef enum {
  KEY_CODE_NONE = 0,

  KEY_CODE_ENTER = '\n',
  KEY_CODE_ESCAPE = 0x1b,
  KEY_CODE_BACKSPACE = '\b',
  KEY_CODE_TAB = '\t',
  KEY_CODE_SPACE = ' ',
  KEY_CODE_EXCLAIM = '!',
  KEY_CODE_QUOTEDBL = '"',
  KEY_CODE_HASH = '#',
  KEY_CODE_PERCENT = '%',
  KEY_CODE_DOLLAR = '$',
  KEY_CODE_AMPERSAND = '&',
  KEY_CODE_QUOTE = '\'',
  KEY_CODE_LEFTPAREN = '(',
  KEY_CODE_RIGHTPAREN = ')',
  KEY_CODE_ASTERISK = '*',
  KEY_CODE_PLUS = '+',
  KEY_CODE_COMMA = ',',
  KEY_CODE_MINUS = '-',
  KEY_CODE_PERIOD = '.',
  KEY_CODE_SLASH = '/',
  KEY_CODE_0 = '0',
  KEY_CODE_1 = '1',
  KEY_CODE_2 = '2',
  KEY_CODE_3 = '3',
  KEY_CODE_4 = '4',
  KEY_CODE_5 = '5',
  KEY_CODE_6 = '6',
  KEY_CODE_7 = '7',
  KEY_CODE_8 = '8',
  KEY_CODE_9 = '9',
  KEY_CODE_COLON = ':',
  KEY_CODE_SEMICOLON = ';',
  KEY_CODE_LESS = '<',
  KEY_CODE_EQUALS = '=',
  KEY_CODE_GREATER = '>',
  KEY_CODE_QUESTION = '?',
  KEY_CODE_AT = '@',
  KEY_CODE_LEFTBRACKET = '[',
  KEY_CODE_BACKSLASH = '\\',
  KEY_CODE_RIGHTBRACKET = ']',
  KEY_CODE_CARET = '^',
  KEY_CODE_UNDERSCORE = '_',
  KEY_CODE_BACKQUOTE = '`',
  KEY_CODE_A = 'a',
  KEY_CODE_B = 'b',
  KEY_CODE_C = 'c',
  KEY_CODE_D = 'd',
  KEY_CODE_E = 'e',
  KEY_CODE_F = 'f',
  KEY_CODE_G = 'g',
  KEY_CODE_H = 'h',
  KEY_CODE_I = 'i',
  KEY_CODE_J = 'j',
  KEY_CODE_K = 'k',
  KEY_CODE_L = 'l',
  KEY_CODE_M = 'm',
  KEY_CODE_N = 'n',
  KEY_CODE_O = 'o',
  KEY_CODE_P = 'p',
  KEY_CODE_Q = 'q',
  KEY_CODE_R = 'r',
  KEY_CODE_S = 's',
  KEY_CODE_T = 't',
  KEY_CODE_U = 'u',
  KEY_CODE_V = 'v',
  KEY_CODE_W = 'w',
  KEY_CODE_X = 'x',
  KEY_CODE_Y = 'y',
  KEY_CODE_Z = 'z',

  KEY_CODE_CAPSLOCK = 128,
  KEY_CODE_F1,
  KEY_CODE_F2,
  KEY_CODE_F3,
  KEY_CODE_F4,
  KEY_CODE_F5,
  KEY_CODE_F6,
  KEY_CODE_F7,
  KEY_CODE_F8,
  KEY_CODE_F9,
  KEY_CODE_F10,
  KEY_CODE_F11,
  KEY_CODE_F12,

  KEY_CODE_PRINTSCREEN,
  KEY_CODE_SCROLLLOCK,
  KEY_CODE_PAUSE,
  KEY_CODE_INSERT,
  KEY_CODE_HOME,
  KEY_CODE_PAGEUP,
  KEY_CODE_DELETE,
  KEY_CODE_END,
  KEY_CODE_PAGEDOWN,
  KEY_CODE_RIGHT,
  KEY_CODE_LEFT,
  KEY_CODE_DOWN,
  KEY_CODE_UP,

  KEY_CODE_F13,
  KEY_CODE_F14,
  KEY_CODE_F15,

  KEY_CODE_LCTRL,
  KEY_CODE_LSHIFT,
  KEY_CODE_LALT,
  KEY_CODE_RCTRL,
  KEY_CODE_RSHIFT,
  KEY_CODE_RALT,

  KEY_CODE_NUM
} key_code_t;
# 228 "key.h"
const char *keyname_get(key_code_t code);
key_code_t keycode_get(const char *name);
# 29 "nll.c" 2
# 1 "framebuf.h" 1



int framebuf_get_screen_flags(void);
int framebuf_get_screen_width(void);
int framebuf_get_screen_height(void);
int framebuf_get_cursor_x(void);
int framebuf_get_cursor_y(void);
int framebuf_get_cursor_effect(void);
int framebuf_get_cursor_fgcolor(void);
int framebuf_get_cursor_bgcolor(void);
int framebuf_init(void);
int framebuf_done(void);
int framebuf_setscreen(int flags, int width, int height);
int framebuf_enable(int enable);
int framebuf_cursor_on(void);
int framebuf_cursor_off(void);
int framebuf_flush(int flags);
int framebuf_seteffect(int effect);
int framebuf_setfgcolor(int color);
int framebuf_setbgcolor(int color);
int framebuf_move_cursor(int x, int y);
int framebuf_move_left(int num);
int framebuf_move_right(int num);
int framebuf_move_up(int num);
int framebuf_move_down(int num);
int framebuf_getch(int x, int y);
int framebuf_clear(int chara, int flags);
int framebuf_scroll(int x, int y, int chara);
int framebuf_puts(const char *str);
int framebuf_line(int x0, int y0, int x1, int y1, const char *str);
int framebuf_box(int x0, int y0, int x1, int y1, const char *str, int flags);
key_code_t framebuf_getkey(void);
# 30 "nll.c" 2
# 1 "nll.h" 1



int nll_clear_line(line_t line);
int nll_parse(line_t line);
int nll_start(line_t line, command_t command, int *retcodep);
int nll_exec(spot_t spot, spot_t current, position_type_t type, value_t value, int *retcodep);
int nll_parse_exec(spot_t current, position_type_t type, char *buffer, value_t value, int *retcodep);
char *nll_line_buffer(line_t line);
int nll_line_edit(int number, int number2, char *buffer, line_t *linep, int save, int move);
int nll_line_free(line_t line);
# 31 "nll.c" 2

static int stepping = 0;
static int skipping = 0;
static int discarding = 0;

static struct spot break_spot;
static struct spot continue_spot;

static struct {
  int index;
  struct spot spot;
} dread_spot;

static int clear_break(line_t line)
{
  if (!line || (break_spot.line == line)) {
    break_spot.line = ((void *)0);
    break_spot.command = ((void *)0);
  }
  return 0;
}

static int clear_continue(line_t line)
{
  if (!line || (continue_spot.line == line)) {
    continue_spot.line = ((void *)0);
    continue_spot.command = ((void *)0);
  }
  return 0;
}

static int clear_dread(line_t line)
{
  if (!line || (dread_spot.spot.line == line)) {
    dread_spot.spot.line = ((void *)0);
    dread_spot.spot.command = ((void *)0);
    dread_spot.index = 0;
  }
  return 0;
}

static int init_dread(void)
{
  int r;
  line_t line = ((void *)0);

  clear_dread(((void *)0));

  if ((r = line_get(1, &line)) < 0)
    return r;

  if (line) {
    dread_spot.spot.line = line;
    dread_spot.spot.command = line->commands;
    dread_spot.index = 0;
  }

  return 0;
}

int nll_clear_line(line_t line)
{
  clear_break(line);
  clear_continue(line);
  clear_dread(line);
  return 0;
}

static int get_continue(spot_t spot)
{
  if (continue_spot.line == ((void *)0))
    return NLL_ERRCODE_NLL_NO_CONTINUE_POINT;
  spot->line = continue_spot.line;
  spot->command = continue_spot.command;
  return 0;
}

static int set_continue(spot_t spot)
{
  continue_spot.line = spot->line;
  continue_spot.command = spot->command;
  return 0;
}

static int proc_end(command_arg_t args, int *retcodep)
{
  int r;
  integer_t retcode = 0;
  value_t value;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &retcode)) < 0)
 return r;
    }
  }

  if (retcodep)
    *retcodep = retcode;

  return 0;
}

static int proc_args(command_arg_t args)
{
  int r, i;

  for (i = 0; i < 4; i++) {
    if (args[i].type == COMMAND_ARG_FORMULA) {
      if ((r = formula_proc(args[i].arg.formula.element, ((void *)0))) < 0)
 return r;
    }
  }

  return 0;
}

static int proc_let(command_arg_t args)
{
  int r, i;
  value_t value = ((void *)0), v;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
  }

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &v)) < 0)
      return r;
    if (value) {
      if ((r = value_copy_values(&value, v)) < 0)
 ;
    }
  }

  for (i = 2; i < 4; i++) {
    if (args[i].type == COMMAND_ARG_FORMULA) {
      if ((r = formula_proc(args[i].arg.formula.element, ((void *)0))) < 0)
 return r;
    }
  }

  return 0;
}

static int proc_print(command_arg_t args)
{
  int r, i, printed = 0;
  value_t value;

  for (i = 0; i < 4; i++) {
    if (args[i].type == COMMAND_ARG_FORMULA) {
      if ((r = formula_proc(args[i].arg.formula.element, &value)) < 0)
 goto ret;
      if (value) {
 value_output_values(nll_stdout, value, " ");
 nll_wait_output(nll_stdout);
 fputs("\n", nll_stdout);
 printed = 1;
      }
    }
  }

  if (!printed) {
    nll_wait_output(nll_stdout);
    fputs("\n", nll_stdout);
  }

  r = 0;

ret:
  fflush(nll_stdout);

  return r;
}

static int _discard(int num)
{
  int r;
  position_type_t type;

  for (; num > 0; num--) {
    if ((r = position_pop(POSITION_TYPE_NONE, &type, ((void *)0), ((void *)0), ((void *)0))) < 0)
      return r;
    switch (type) {
    case POSITION_TYPE_GOSUB:
    case POSITION_TYPE_LABEL:
    case POSITION_TYPE_EVAL:
      if ((r = stack_pop_type(STACK_TYPE_CALL, ((void *)0))) < 0)
 return r;
      break;
    default:
      break;
    }
  }

  return 0;
}

static int proc_goto(spot_t spot, command_arg_t args)
{
  int r;
  integer_t num;
  value_t value;
  label_t label = ((void *)0);

  if (args[3].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[3].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &num)) < 0)
 return r;
      if ((r = _discard(num)) < 0)
 return r;
    }
  }

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_label(value, &label)) < 0)
 return r;
    }
  }

  if (!label || !label->spot.line)
    return NLL_ERRCODE_LABEL_NOT_FOUND;

  spot->line = label->spot.line;
  spot->command = label->spot.command;

  value = ((void *)0);
  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &value)) < 0)
      return r;
  }

  if (spot->command->label.args) {
    if ((r = stack_push_type(STACK_TYPE_CALL, value)) < 0)
      return r;
  }

  if (args[2].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[2].arg.formula.element, ((void *)0))) < 0)
      return r;
  }

  return 0;
}

static int proc_gosub(spot_t spot, spot_t current, command_arg_t args)
{
  int r;
  value_t value;
  label_t label = ((void *)0);

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_label(value, &label)) < 0)
 return r;
    }
  }

  if (!label || !label->spot.line)
    return NLL_ERRCODE_LABEL_NOT_FOUND;

  spot->line = label->spot.line;
  spot->command = label->spot.command;

  value = ((void *)0);
  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &value)) < 0)
      return r;
  }


  if ((r = stack_push_type(STACK_TYPE_CALL, ((void *)0))) < 0)
    return r;

  if (spot->command->label.args) {
    if ((r = stack_push_type(STACK_TYPE_CALL, value)) < 0)
      return r;
  }

  if ((r = position_push(POSITION_TYPE_GOSUB, current, ((void *)0), 0)) < 0)
    return r;

  return 0;
}

static int proc_gonext(spot_t spot, spot_t current, line_t line, command_arg_t args)
{
  int r;
  integer_t n = 1, n2 = -1, search = 0, num;
  value_t value;

  if (args[3].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[3].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &num)) < 0)
 return r;
      if ((r = _discard(num)) < 0)
 return r;
    }
  }

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &n)) < 0)
 return r;
      search = 1;
    }
  }

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &n2)) < 0)
 return r;
    }
  }

  if (args[2].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[2].arg.formula.element, ((void *)0))) < 0)
      return r;
  }

  if (n2 < 0) {
    n2 = 0;
    if (!search)
      search = 1;
  }

  spot->line = current->line;
  spot->command = current->command;

  if (search) {
    if (n < 0) {
      for (; spot->line && (n < 0); n++)
 spot->line = spot->line->prev;
    } else {
      for (; spot->line && (n > 0); n--)
 spot->line = spot->line->next;
    }
    spot->command = spot->line ? spot->line->commands : ((void *)0);
  }

  while (n2 > 0) {
    if (!spot->line)
      break;
    if (!spot->command) {
      spot->line = spot->line->next;
      spot->command = spot->line ? spot->line->commands : ((void *)0);
      continue;
    }
    spot->command = spot->command->next;
    n2--;
  }

  return 0;
}

static int proc_return(spot_t spot, command_arg_t args)
{
  int r, retval = 0;
  integer_t num;
  value_t value;
  position_type_t type;

  if (args[2].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[2].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &num)) < 0)
 return r;
      if ((r = _discard(num)) < 0)
 return r;
    }
  }

  value = ((void *)0);
  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
  }


  if ((r = stack_pop_type(STACK_TYPE_CALL, ((void *)0))) < 0)
    return r;

  if ((r = stack_push_type(STACK_TYPE_CALL, value)) < 0)
    return r;

  type = position_get_type();

  switch (type) {
  case POSITION_TYPE_GOSUB:
    if ((r = position_pop(POSITION_TYPE_GOSUB, ((void *)0), spot, ((void *)0), ((void *)0))) < 0)
      return r;
    if (spot->line == ((void *)0))
      return NLL_ERRCODE_NLL_NO_CONTINUE_POINT;
    value = ((void *)0);
    if (spot->command->args[2].type == COMMAND_ARG_FORMULA) {
      if ((r = formula_proc(spot->command->args[2].arg.formula.element, &value)) < 0)
 return r;
    }
    if ((r = stack_pop_type(STACK_TYPE_CALL, value)) < 0)
      return r;
    retval = 1;
    break;

  case POSITION_TYPE_LABEL:
    break;

  case POSITION_TYPE_EVAL:
    break;

  default:
    return NLL_ERRCODE_POSITION_DIFFERENT_TYPE;
  }

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, ((void *)0))) < 0)
      return r;
  }

  return retval;
}

static int proc_if(command_arg_t args)
{
  int r = 0;
  value_t value;

  if ((r = position_push(POSITION_TYPE_IF, ((void *)0), ((void *)0), discarding)) < 0)
    return r;

  if (!discarding) {
    r = 0;

    if (args[0].type == COMMAND_ARG_FORMULA) {
      if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
 return r;
      if ((r = value_is_true(value)) < 0)
 return r;
    }

    discarding = r ? 0 : 1;

    if (!discarding) {
      if (args[1].type == COMMAND_ARG_FORMULA) {
 if ((r = formula_proc(args[1].arg.formula.element, ((void *)0))) < 0)
   return r;
      }
    } else {
      if (args[2].type == COMMAND_ARG_FORMULA) {
 if ((r = formula_proc(args[2].arg.formula.element, ((void *)0))) < 0)
   return r;
      }
    }
  }

  return 0;
}

static int proc_else(command_arg_t args)
{
  int r = 0, d;
  value_t value;

  if ((r = position_peek(POSITION_TYPE_IF, ((void *)0), ((void *)0), &d)) < 0)
    return r;

  if (!d) {
    if (discarding > 0) {
      r = discarding;

      if (args[0].type == COMMAND_ARG_FORMULA) {
 if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
   return r;
 if ((r = value_is_true(value)) < 0)
   return r;
      }

      discarding = r ? 0 : 1;
    } else {
      discarding = -1;
    }

    if (!discarding) {
      if (args[1].type == COMMAND_ARG_FORMULA) {
 if ((r = formula_proc(args[1].arg.formula.element, ((void *)0))) < 0)
   return r;
      }
    } else {
      if (args[2].type == COMMAND_ARG_FORMULA) {
 if ((r = formula_proc(args[2].arg.formula.element, ((void *)0))) < 0)
   return r;
      }
    }
  }

  return 0;
}

static int proc_endif(command_arg_t args)
{
  int r = 0;

  if ((r = position_pop(POSITION_TYPE_IF, ((void *)0), ((void *)0), ((void *)0), &discarding)) < 0)
    return r;

  return 0;
}

static int proc_loop(spot_t spot, command_arg_t args)
{
  int r;
  value_t value, v;

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, ((void *)0))) < 0)
      return r;
  }

  if (args[2].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[2].arg.formula.element, &v)) < 0)
      return r;
  }

  if (args[3].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[3].arg.formula.element, ((void *)0))) < 0)
      return r;
  }

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (args[2].type == COMMAND_ARG_FORMULA) {
      if (value) {
 if ((r = value_copy_values(&value, v)) < 0)
   return r;
      }
    } else {
      if (value) {
 if ((r = value_set_integer(value, 0)) < 0)
   return r;
      }
    }
  }

  if ((r = position_push(POSITION_TYPE_LOOP, spot, ((void *)0), 0)) < 0)
    return r;

  return 0;
}

static int proc_for(spot_t spot, command_arg_t args)
{
  int r;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, ((void *)0))) < 0)
      return r;
  }

  if ((r = position_push(POSITION_TYPE_FOR, spot, ((void *)0), 0)) < 0)
    return r;

  return 0;
}

static int proc_loopend(spot_t spot, command_arg_t args)
{
  int r;
  integer_t integer = 0, count = -1, start = 0, step = 1, end = 1;
  struct spot s;
  value_t value = ((void *)0);

  if ((r = position_pop(POSITION_TYPE_LOOP, ((void *)0), &s, ((void *)0), ((void *)0))) < 0)
    return r;

  if (s.line == ((void *)0))
    return NLL_ERRCODE_NLL_NO_CONTINUE_POINT;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
  }

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, ((void *)0))) < 0)
      return r;
  }

  args = s.command->args;

  if (value) {
    if ((args[0].type != COMMAND_ARG_FORMULA) ||
 !value_is_same(value, formula_get_value(args[0].arg.formula.element)))
      return NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE;
  }

  value = ((void *)0);
  if (args[0].type == COMMAND_ARG_FORMULA)
    value = formula_get_value(args[0].arg.formula.element);

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = value_get_integer(formula_get_value(args[1].arg.formula.element), &count)) < 0)
      return r;
  }
  if (args[2].type == COMMAND_ARG_FORMULA) {
    if ((r = value_get_integer(formula_get_value(args[2].arg.formula.element), &start)) < 0)
      return r;
  }
  if (args[3].type == COMMAND_ARG_FORMULA) {
    if ((r = value_get_integer(formula_get_value(args[3].arg.formula.element), &step)) < 0)
      return r;
  }

  if (value) {
    if ((r = value_get_integer(value, &integer)) < 0)
      return r;

    integer += step;

    if ((r = value_set_integer(value, integer)) < 0)
      return r;

    end = start + step * count;
  }

  if ((count < 0) || (integer != end)) {
    if ((r = position_push(POSITION_TYPE_LOOP, &s, ((void *)0), 0)) < 0)
      return r;
    spot->line = s.line;
    spot->command = s.command;
    return 1;
  }

  return 0;
}

static int proc_next(spot_t spot, command_arg_t args)
{
  int r;
  struct spot s;
  value_t value = ((void *)0);

  if ((r = position_pop(POSITION_TYPE_FOR, ((void *)0), &s, ((void *)0), ((void *)0))) < 0)
    return r;

  if (s.line == ((void *)0))
    return NLL_ERRCODE_NLL_NO_CONTINUE_POINT;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, ((void *)0))) < 0)
      return r;
  }

  args = s.command->args;

  if (args[2].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[2].arg.formula.element, ((void *)0))) < 0)
      return r;
  }

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &value)) < 0)
      return r;
  }

  if (value) {
    if ((r = value_is_true(value)) < 0)
      return r;
    if (r)
      value = ((void *)0);
  }

  if (!value) {
    if ((r = position_push(POSITION_TYPE_FOR, &s, ((void *)0), 0)) < 0)
      return r;
    spot->line = s.line;
    spot->command = s.command;
    return 1;
  }

  return 0;
}

static int proc_discard(command_arg_t args)
{
  int r;
  integer_t num = 1;
  value_t value;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &num)) < 0)
 return r;
    }
  }

  if ((r = _discard(num)) < 0)
    return r;

  return 0;
}

static int proc_dim(command_arg_t args)
{

  int r, i, n[(4 - 1) + 1];
  integer_t integer;
  value_t value;

  for (i = 0; i < (4 - 1); i++) {
    n[i] = -1;
    if (args[i + 1].type == COMMAND_ARG_FORMULA) {
      if ((r = formula_proc(args[i + 1].arg.formula.element, &value)) < 0)
 return r;
      if (value) {
 if ((r = value_get_integer(value, &integer)) < 0)
   return r;
 n[i] = integer;
      } else {
 n[i] = 1;
      }
    }
  }
  n[i] = -1;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = array_make(value, n)) < 0)
 return r;
    }
  }

  return 0;
}

static int proc_memory(command_arg_t args)
{
  int r;
  integer_t integer;
  value_t value, v;
  area_t area = ((void *)0);

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      goto err;
  }

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &v)) < 0)
      goto err;
    if (args[0].type == COMMAND_ARG_FORMULA) {
      if ((r = value_get_integer(v, &integer)) < 0)
 goto err;
      if ((r = area_alloc(&area, integer)) < 0)
 goto err;
    }
  }

  if ((r = value_set_area(value, area)) < 0)
    goto err;
  area = ((void *)0);

  return 0;

err:
  if (area) {
    area->refcount++;
    area_free(area);
  }
  return r;
}

static int proc_push(command_arg_t args)
{
  int r, i;
  value_t value;

  for (i = 0; i < 4; i++) {
    if (args[i].type == COMMAND_ARG_FORMULA) {
      if ((r = formula_proc(args[i].arg.formula.element, &value)) < 0)
 return r;
      for (; value; value = value->next) {
 if ((r = stack_push(value)) < 0)
   return r;
      }
    }
  }

  return 0;
}

static int proc_pop(command_arg_t args)
{
  int r, i, n = 0;
  value_t value;

  for (i = 0; i < 4; i++) {
    if (args[i].type == COMMAND_ARG_FORMULA) {
      if ((r = formula_proc(args[i].arg.formula.element, &value)) < 0)
 return r;
      for (; value; value = value->next) {
 if ((r = stack_pop(value)) < 0)
   return r;
      }
      n++;
    }
  }

  if (!n) {
    if ((r = stack_pop(((void *)0))) < 0)
      return r;
  }

  return 0;
}

static int proc_dfrom(command_arg_t args)
{
  int r;
  value_t value;
  label_t label = ((void *)0);

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_label(value, &label)) < 0)
 return r;
    }
  }

  if (!label) {
    init_dread();
  } else {
    if (!label->spot.line)
      return NLL_ERRCODE_LABEL_NOT_FOUND;
    dread_spot.spot.line = label->spot.line;
    dread_spot.spot.command = label->spot.command;
    dread_spot.index = 0;
  }

  return 0;
}

static int dread(value_t value)
{
  int r, i;
  value_t v;

  while (dread_spot.spot.line) {
    if (!dread_spot.spot.command) {
      dread_spot.spot.line = dread_spot.spot.line->next;
      dread_spot.spot.command = dread_spot.spot.line ? dread_spot.spot.line->commands : ((void *)0);
      dread_spot.index = 0;
      continue;
    } else if (dread_spot.spot.command->ope->type == COMMAND_DATA) {
      if (dread_spot.index < 4) {
 i = dread_spot.index++;
 if (dread_spot.spot.command->args[i].type == COMMAND_ARG_FORMULA) {
   if ((r = formula_proc(dread_spot.spot.command->args[i].arg.formula.element, &v)) < 0)
     return r;
   break;
 }
 continue;
      }
    }
    dread_spot.spot.command = dread_spot.spot.command->next;
    dread_spot.index = 0;
  }

  if (!dread_spot.spot.line)
    return NLL_ERRCODE_NLL_NO_DATA;

  if (value) {
    if ((r = value_copy_values(&value, v)) < 0)
      return r;
  }

  return 0;
}

static int proc_dread(command_arg_t args)
{
  int r, i;
  value_t value;

  for (i = 0; i < 4; i++) {
    if (args[i].type == COMMAND_ARG_FORMULA) {
      if ((r = formula_proc(args[i].arg.formula.element, &value)) < 0)
 return r;
      if ((r = dread(value)) < 0)
 return r;
    }
  }

  return 0;
}

static int proc_run(spot_t spot, command_arg_t args)
{
  int r, n;
  integer_t integer = 1;
  value_t value, argv;
  line_t line = ((void *)0);

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer)) < 0)
 return r;
    }
  }

  if ((r = line_get(integer, &line)) < 0)
    return r;

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &argv)) < 0)
      return r;
    if (value_get_type(argv) == VALUE_TYPE_VECTOR) {
      if ((r = value_get_vector(argv, &argv)) < 0)
 return r;
    }
    for (n = 0, value = argv; value; n++, value = value->next)
      ;
    nll_make_argc(n);
    nll_make_argv(n, ((void *)0));
    for (n = 0, value = argv; value; n++, value = value->next)
      nll_set_arg(n, value);
  }

  clear_continue(((void *)0));
  init_dread();
  position_clean();
  stack_clean();
  line_clean();
  variable_clean();
  stepping = 0;
  skipping = 0;
  discarding = 0;

  if (line) {
    spot->line = line;
    spot->command = line->commands;
    return 1;
  }

  return 0;
}

static int proc_stop(command_arg_t args)
{
  int r, i;
  value_t value;

  for (i = 0; i < 4; i++) {
    if (args[i].type == COMMAND_ARG_FORMULA) {
      if ((r = formula_proc(args[i].arg.formula.element, &value)) < 0)
 goto ret;
      if (value) {
 value_output_values(nll_stdout, value, " ");
 nll_wait_output(nll_stdout);
 fputs("\n", nll_stdout);
      }
    }
  }

  r = 0;

ret:
  fflush(nll_stdout);

  return r;
}

static int proc_break(command_arg_t args)
{
  int r;
  integer_t integer0 = 0, integer1 = 0;
  value_t value;
  line_t line = ((void *)0);
  command_t command;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer0)) < 0)
 return r;
    }
  }

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer1)) < 0)
 return r;
    }
  }

  if ((r = line_get(integer0, &line)) < 0)
    return r;

  if (!line) {
    clear_break(((void *)0));
  } else {
    for (command = line->commands; command && (integer1 > 0); integer1--) {
      command = command->next;
    }
    break_spot.line = line;
    break_spot.command = command;
  }

  return 0;
}

static int proc_step(command_arg_t args)
{
  int r;
  integer_t integer = 1;
  value_t value;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer)) < 0)
 return r;
    }
  }

  stepping = integer;

  return 0;
}

static int proc_skip(command_arg_t args)
{
  int r;
  integer_t integer = 1;
  value_t value;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer)) < 0)
 return r;
    }
  }

  skipping = integer;

  return 0;
}

static int proc_new(spot_t spot, command_arg_t args)
{
  int r, i, retval = 1;
  value_t value;
  variable_t variable;

  for (i = 0; i < 4; i++) {
    if (args[i].type == COMMAND_ARG_FORMULA) {
      variable = formula_get_variable(args[i].arg.formula.element);
      if (variable) {
 if ((r = variable_new(variable)) < 0)
   return r;
      } else {
 if ((r = formula_proc(args[i].arg.formula.element, &value)) < 0)
   return r;
 if ((r = value_clear(value_entity(value))) < 0)
   return r;
      }
      retval = 0;
    }
  }

  return retval;
}

static int proc_list(command_arg_t args)
{
  int r;
  integer_t integer0 = -1, integer1 = -1;
  value_t value;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer0)) < 0)
 return r;
    }
  }

  integer1 = integer0;

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer1)) < 0)
 return r;
    }
  }

  line_print(nll_stdout, integer0, integer1);
  fflush(nll_stdout);

  return 0;
}

static int proc_save(command_arg_t args)
{
  int r;
  char *string = "sample.nll", *s;
  integer_t integer0 = -1, integer1 = -1;
  value_t value;
  FILE *fp;

  if (nll_is_nosystem())
    return NLL_ERRCODE_NLL_INVALID_COMMAND;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_string(value, &s, ((void *)0))) < 0)
 return r;
      if (s)
 string = s;
    }
  }

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer0)) < 0)
 return r;
    }
  }

  integer1 = integer0;

  if (args[2].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[2].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer1)) < 0)
 return r;
    }
  }

  fp = fopen(string, "w");
  if (!fp)
    return NLL_ERRCODE_FILE_NOT_FOUND;

  line_print(fp, integer0, integer1);

  fclose(fp);

  return 0;
}

static int proc_load(command_arg_t args)
{
  int r;
  char *string = "sample.nll", *s;
  value_t value;

  if (nll_is_nosystem())
    return NLL_ERRCODE_NLL_INVALID_COMMAND;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_string(value, &s, ((void *)0))) < 0)
 return r;
      if (s)
 string = s;
    }
  }

  if ((r = nll_file_open(string)) < 0)
    return r;

  return 0;
}

static int proc_stdin(command_arg_t args)
{
  int r;
  char *filename = ((void *)0);
  value_t value;
  FILE *fp;

  if (nll_is_nosystem())
    return NLL_ERRCODE_NLL_INVALID_COMMAND;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_string(value, &filename, ((void *)0))) < 0)
 return r;
    }
  }

  if (!filename) {
    if ((r = nll_stdin_restore()) < 0)
      return r;
  } else {
    fp = fopen(filename, "r");
    if (!fp)
      return NLL_ERRCODE_FILE_NOT_FOUND;
    if ((r = nll_stdin_save(fp)) < 0)
      return r;
  }

  return 0;
}

static int proc_stdout(command_arg_t args)
{
  int r;
  char *filename = ((void *)0);
  value_t value;
  FILE *fp;

  if (nll_is_nosystem())
    return NLL_ERRCODE_NLL_INVALID_COMMAND;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_string(value, &filename, ((void *)0))) < 0)
 return r;
    }
  }

  if (!filename) {
    if ((r = nll_stdout_restore()) < 0)
      return r;
  } else {
    fp = fopen(filename, "w");
    if (!fp)
      return NLL_ERRCODE_FILE_NOT_FOUND;
    if ((r = nll_stdout_save(fp)) < 0)
      return r;
  }

  return 0;
}

static int proc_eval(spot_t spot, command_arg_t args)
{
  int r;
  char *string = ((void *)0);
  value_t value = ((void *)0), v;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &v)) < 0)
      return r;
    if (v) {
      if ((r = value_get_string(v, &string, ((void *)0))) < 0)
 return r;
    }
  }

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &value)) < 0)
      return r;
  }

  if (!string)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  return nll_parse_exec(spot, POSITION_TYPE_EVAL, string, value, ((void *)0));
}

static int proc_evalf(spot_t spot, command_arg_t args)
{
  int r, retcode;
  char *filename = ((void *)0);
  value_t value = ((void *)0), v;
  FILE *fp = ((void *)0);
  char buffer[256 + 1];

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &v)) < 0)
      return r;
    if (v) {
      if ((r = value_get_string(v, &filename, ((void *)0))) < 0)
 return r;
    }
  }

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &value)) < 0)
      return r;
  }

  if (!filename)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  fp = fopen(filename, "r");
  if (!fp)
    return NLL_ERRCODE_FILE_NOT_FOUND;

  while (nll_fgets(buffer, 256, fp)) {
    if ((r = nll_parse_exec(spot, POSITION_TYPE_EVAL, buffer, value, &retcode)) < 0)
      goto err;
    if (retcode)
      break;
  }

  fclose(fp);

  return 0;

err:
  if (fp)
    fclose(fp);
  return r;
}

static int proc_edit(command_arg_t args)
{
  int r;
  integer_t integer = 0;
  value_t value;

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer)) < 0)
 return r;
    }
  }

  if ((r = nll_edit_set(integer)) < 0)
    return r;

  return 0;
}

static int proc_wait(command_arg_t args)
{
  int r;
  integer_t integer = 100, integer2 = 0, integer3 = 0, integer4 = 0;
  value_t value;

  if (args[1].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[1].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer2)) < 0)
 return r;
      integer = 0;
    }
  }

  if (args[0].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[0].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer)) < 0)
 return r;
    }
  }

  if (args[2].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[2].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer3)) < 0)
 return r;
    }
  }

  if (args[3].type == COMMAND_ARG_FORMULA) {
    if ((r = formula_proc(args[3].arg.formula.element, &value)) < 0)
      return r;
    if (value) {
      if ((r = value_get_integer(value, &integer4)) < 0)
 return r;
    }
  }

  nll_usleep(integer * 10000 + integer2 * 100 + integer3);

  if (integer4)
    nll_sleep(integer4);

  return 0;
}

static int proc_dump(command_arg_t args)
{
  int r, i, all = 1;
  integer_t flags;
  value_t value;

  for (i = 0; i < (4 - 1) + 1; i++) {
    if (i == (4 - 1)) {
      if (!all)
 break;
      flags = 0;
    } else {
      if (args[i].type != COMMAND_ARG_FORMULA)
 continue;
      if ((r = formula_proc(args[i].arg.formula.element, &value)) < 0)
 return r;
      if (!value)
 continue;
      if ((r = value_get_integer(value, &flags)) < 0)
 return r;
    }

    if (!flags)
      flags = ((1 << 0)|(1 << 1)|(1 << 2)|(1 << 3)|(1 << 4)|(1 << 5));

    if (flags & (1 << 0)) variable_dump(nll_stdout, ((void *)0));
    if (flags & (1 << 1) ) string_dump(nll_stdout, ((void *)0));
    if (flags & (1 << 2) ) label_dump(nll_stdout, ((void *)0));
    if (flags & (1 << 3) ) line_dump(nll_stdout, ((void *)0));
    if (flags & (1 << 4) ) stack_dump(nll_stdout);
    if (flags & (1 << 5)) position_dump(nll_stdout);
    if (flags & (1 << 16) ) command_list(nll_stdout);
    if (flags & (1 << 17)) function_list(nll_stdout);
    if (flags & (1 << 18) ) variable_const_list(nll_stdout);
    if (flags & (1 << 19)) formula_operator_list(nll_stdout);
    fflush(nll_stdout);
    all = 0;
  }

  return 0;
}

static void set_errcode(command_t command, int r)
{
  if (command)
    command->errcode = r;
}




int nll_parse(line_t line)
{
  char *p, *buffer, *pc;
  char name[32 + 1];
  int r, i, count = 0;
  command_t command = ((void *)0), *tailp;
  struct spot s;

  buffer = line->buffer;
  p = buffer;

  tailp = &line->commands;

  while (*p) {
    if (isspace(*p)) {
      p++;
      continue;
    }

    pc = p;

    if ((r = command_alloc(&command)) < 0)
      do { nll_error_print("nll.c", 1529, (r), (pc)); set_errcode((command), (r)); goto brk; } while (0);
    command->line = pc;

    if ((r = command_get(COMMAND_NONE, &command->ope)) < 0)
      do { nll_error_print("nll.c", 1533, (r), (pc)); set_errcode((command), (r)); goto brk; } while (0);

    if (*p == '.') {
      p++;
      while (isspace(*p))
 p++;
      if ((r = formula_get_symbol(name, p)) < 0)
 do { nll_error_print("nll.c", 1540, (r), (pc)); set_errcode((command), (r)); goto brk; } while (0);
      if (r == 0)
 do { nll_error_print("nll.c", 1542, (NLL_ERRCODE_LABEL_INVALID_NAME), (pc)); set_errcode((command), (NLL_ERRCODE_LABEL_INVALID_NAME)); goto brk; } while (0);
      memcpy(p, name, r);
      p += r;

      s.line = line;
      s.command = command;
      if ((r = command_set_label(command, name, &s)) < 0)
 do { nll_error_print("nll.c", 1549, (r), (pc)); set_errcode((command), (r)); goto brk; } while (0);

      if ((r = formula_parse(p, &p, &command->label.args, ";:")) < 0)
 do { nll_error_print("nll.c", 1552, (r), (pc)); set_errcode((command), (r)); goto brk; } while (0);
      if (command->label.args) {
 if ((r = formula_set_raw(command->label.args)) < 0)
   do { nll_error_print("nll.c", 1555, (r), (pc)); set_errcode((command), (r)); goto brk; } while (0);
      }

      if (*p == ':')
 p++;
    }

    if ((r = command_search(p, &p, &command->ope)) < 0) {
      if ((r = formula_parse(p, &p, &command->prefix, ";:")) < 0)
 do { nll_error_print("nll.c", 1564, (r), (pc)); set_errcode((command), (r)); goto brk; } while (0);
      if (*p == ':') {
 p++;
 while (isspace(*p))
   p++;
 if ((r = command_search(p, &p, &command->ope)) < 0) {
   if ((r = command_get(COMMAND_ARGS, &command->ope)) < 0)
     do { nll_error_print("nll.c", 1571, (r), (pc)); set_errcode((command), (r)); goto brk; } while (0);
 }
      }
    }

    while (isspace(*p))
      p++;

    switch (command->ope->type) {
    case COMMAND_NONE:
      break;

    case COMMAND_COMMENT:
      goto brk;

    case COMMAND_CONTINUE:
      break;

    case COMMAND_END:
    case COMMAND_EXIT:
    case COMMAND_ARGS:
    case COMMAND_LET:
    case COMMAND_PRINT:
    case COMMAND_GOTO:
    case COMMAND_GONEXT:
    case COMMAND_GOSUB:
    case COMMAND_RETURN:
    case COMMAND_IF:
    case COMMAND_ELSE:
    case COMMAND_ENDIF:
    case COMMAND_LOOP:
    case COMMAND_LOOPEND:
    case COMMAND_FOR:
    case COMMAND_NEXT:
    case COMMAND_DISCARD:
    case COMMAND_DIM:
    case COMMAND_MEMORY:
    case COMMAND_PUSH:
    case COMMAND_POP:
    case COMMAND_DFROM:
    case COMMAND_DREAD:
    case COMMAND_DATA:
    case COMMAND_RUN:
    case COMMAND_STOP:
    case COMMAND_SKIP:
    case COMMAND_BREAK:
    case COMMAND_STEP:
    case COMMAND_NEW:
    case COMMAND_LIST:
    case COMMAND_SAVE:
    case COMMAND_LOAD:
    case COMMAND_STDIN:
    case COMMAND_STDOUT:
    case COMMAND_EVAL:
    case COMMAND_EVALF:
    case COMMAND_EDIT:
    case COMMAND_WAIT:
    case COMMAND_DUMP:
      for (i = 0; i < 4; i++) {
 if ((r = formula_parse(p, &p, &command->args[i].arg.formula.element, ((void *)0))) < 0)
   do { nll_error_print("nll.c", 1631, (r), (pc)); set_errcode((command), (r)); goto brk; } while (0);
 if (command->args[i].arg.formula.element)
   command->args[i].type = COMMAND_ARG_FORMULA;
 if (*p == ',') p++; else break;
      }
      if (i == 4)
 do { nll_error_print("nll.c", 1637, (NLL_ERRCODE_COMMAND_MUCH_ARGS), (pc)); set_errcode((command), (NLL_ERRCODE_COMMAND_MUCH_ARGS)); goto brk; } while (0);
      break;

    case COMMAND_UNKNOWN:
    default:
      do { nll_error_print("nll.c", 1642, (NLL_ERRCODE_COMMAND_NOT_FOUND), (pc)); set_errcode((command), (NLL_ERRCODE_COMMAND_NOT_FOUND)); goto brk; } while (0);
    }

    switch (command->ope->type) {
    case COMMAND_GOTO:
    case COMMAND_GOSUB:
      if (command->args[1].type == COMMAND_ARG_FORMULA) {
 if ((r = formula_set_raw(command->args[1].arg.formula.element)) < 0)
   return r;
      }
      break;
    default:
      break;
    }

    if (*p) {
      if (*p != ';')
 do { nll_error_print("nll.c", 1659, (NLL_ERRCODE_COMMAND_INVALID_FORMAT), (pc)); set_errcode((command), (NLL_ERRCODE_COMMAND_INVALID_FORMAT)); goto brk; } while (0);
      p++;
    }

    command->next = *tailp;
    *tailp = command;
    tailp = &(command->next);
    command = ((void *)0);
    count++;
  }

  r = count;

brk:
  if (command) {
    if (!command->errcode) {
      command_free(command);
    } else {
      command_clear(command);
      command->next = *tailp;
      *tailp = command;
      tailp = &(command->next);
    }
  }

  return r;
}

static int nll_proc(spot_t spot, int *retcodep)
{
  line_t line;
  command_t command;
  int r;
  struct spot s;
  value_t value;

  line = spot->line;
  command = spot->command;

  for (; command; command = command->next) {
    if (discarding) {
      if (command->errcode)
 continue;
      if (command->prefix)
 continue;
      switch (command->ope->type) {
      case COMMAND_IF:
 if ((r = proc_if(command->args)) < 0)
   do { nll_error_print("nll.c", 1707, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
 break;
      case COMMAND_ELSE:
 if ((r = proc_else(command->args)) < 0)
   do { nll_error_print("nll.c", 1711, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
 break;
      case COMMAND_ENDIF:
 if ((r = proc_endif(command->args)) < 0)
   do { nll_error_print("nll.c", 1715, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
 break;
      default:
 break;
      }
      continue;
    }

    if (skipping && (line_is_exist(line) > 0)) {
      skipping--;
      continue;
    }

    if (nll_is_finished()) {
      fprintf(nll_stdout, "\nBreak at: %s\n", command->line);
      goto brk;
    }

    if (!nll_finish_is_locked()) {
      if (stepping && (line_is_exist(line) > 0)) {
 stepping--;
 if (!stepping) {
   fprintf(nll_stdout, "\nStep break at: %s\n", command->line);
   goto brk;
 }
      }
    }

    if (break_spot.line && (line_is_exist(line) > 0)) {
      if ((line == break_spot.line) && (command == break_spot.command)) {
 clear_break(line);
 fprintf(nll_stdout, "\nBreakpoint at: %s\n", command->line);
 goto brk;
      }
    }

    if (command->errcode)
      do { nll_error_print("nll.c", 1752, (command->errcode), (command->line)); set_errcode((((void *)0)), (command->errcode)); goto brk; } while (0);

    if (command->label.args) {
      if ((r = formula_proc(command->label.args, &value)) < 0)
 do { nll_error_print("nll.c", 1756, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      if ((r = stack_pop_type(STACK_TYPE_CALL, value)) < 0)
 do { nll_error_print("nll.c", 1758, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
    }

    if (command->prefix) {
      if ((r = formula_proc(command->prefix, &value)) < 0)
 do { nll_error_print("nll.c", 1763, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      if (command->ope->type == COMMAND_NONE)
 continue;
      if (!value) {
 r = 0;
      } else {
 if ((r = value_is_true(value)) < 0)
   do { nll_error_print("nll.c", 1770, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      }
      if (!r)
 continue;
    }

    switch (command->ope->type) {
    case COMMAND_END:
      if ((r = proc_end(command->args, retcodep)) < 0)
 do { nll_error_print("nll.c", 1779, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      goto end;

    case COMMAND_EXIT:
      if ((r = proc_end(command->args, retcodep)) < 0)
 do { nll_error_print("nll.c", 1784, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      goto ext;

    case COMMAND_ARGS:
      if ((r = proc_args(command->args)) < 0)
 do { nll_error_print("nll.c", 1789, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_LET:
      if ((r = proc_let(command->args)) < 0)
 do { nll_error_print("nll.c", 1794, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_PRINT:
      if ((r = proc_print(command->args)) < 0)
 do { nll_error_print("nll.c", 1799, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_GOTO:
      if ((r = proc_goto(spot, command->args)) < 0)
 do { nll_error_print("nll.c", 1804, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      goto next;

    case COMMAND_GONEXT:
      s.line = line;
      s.command = command;
      if ((r = proc_gonext(spot, &s, line, command->args)) < 0)
 do { nll_error_print("nll.c", 1811, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      goto next;

    case COMMAND_GOSUB:
      s.line = line;
      s.command = command;
      if ((r = proc_gosub(spot, &s, command->args)) < 0)
 do { nll_error_print("nll.c", 1818, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      goto next;

    case COMMAND_RETURN:
      if ((r = proc_return(spot, command->args)) < 0)
 do { nll_error_print("nll.c", 1823, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      if (!r) {
 if (retcodep)
   *retcodep = 1;
 goto end;
      }
      spot->command = spot->command->next;
      goto next;

    case COMMAND_IF:
      if ((r = proc_if(command->args)) < 0)
 do { nll_error_print("nll.c", 1834, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_ELSE:
      if ((r = proc_else(command->args)) < 0)
 do { nll_error_print("nll.c", 1839, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_ENDIF:
      if ((r = proc_endif(command->args)) < 0)
 do { nll_error_print("nll.c", 1844, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_LOOP:
      s.line = line;
      s.command = command;
      if ((r = proc_loop(&s, command->args)) < 0)
 do { nll_error_print("nll.c", 1851, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_FOR:
      s.line = line;
      s.command = command;
      if ((r = proc_for(&s, command->args)) < 0)
 do { nll_error_print("nll.c", 1858, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_LOOPEND:
      if ((r = proc_loopend(spot, command->args)) < 0)
 do { nll_error_print("nll.c", 1863, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      if (!r)
 break;
      spot->command = spot->command->next;
      goto next;

    case COMMAND_NEXT:
      if ((r = proc_next(spot, command->args)) < 0)
 do { nll_error_print("nll.c", 1871, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      if (!r)
 break;
      spot->command = spot->command->next;
      goto next;

    case COMMAND_DISCARD:
      if ((r = proc_discard(command->args)) < 0)
 do { nll_error_print("nll.c", 1879, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_DIM:
      if ((r = proc_dim(command->args)) < 0)
 do { nll_error_print("nll.c", 1884, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_MEMORY:
      if ((r = proc_memory(command->args)) < 0)
 do { nll_error_print("nll.c", 1889, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_PUSH:
      if ((r = proc_push(command->args)) < 0)
 do { nll_error_print("nll.c", 1894, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_POP:
      if ((r = proc_pop(command->args)) < 0)
 do { nll_error_print("nll.c", 1899, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_DFROM:
      if ((r = proc_dfrom(command->args)) < 0)
 do { nll_error_print("nll.c", 1904, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_DREAD:
      if ((r = proc_dread(command->args)) < 0)
 do { nll_error_print("nll.c", 1909, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_RUN:
      if ((r = proc_run(spot, command->args)) < 0)
 do { nll_error_print("nll.c", 1914, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      if (!r)
 break;
      goto next;

    case COMMAND_STOP:
      if ((r = proc_stop(command->args)) < 0)
 ;
      nll_finish();
      break;

    case COMMAND_BREAK:
      if ((r = proc_break(command->args)) < 0)
 do { nll_error_print("nll.c", 1927, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_STEP:
      if ((r = proc_step(command->args)) < 0)
 do { nll_error_print("nll.c", 1932, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      if (stepping) stepping++;
      goto cont;

    case COMMAND_CONTINUE:
      goto cont;

    case COMMAND_SKIP:
      if ((r = proc_skip(command->args)) < 0)
 do { nll_error_print("nll.c", 1941, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_NEW:
      if ((r = proc_new(spot, command->args)) < 0)
 do { nll_error_print("nll.c", 1946, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      if (!r)
 break;
      goto init;

    case COMMAND_LIST:
      if ((r = proc_list(command->args)) < 0)
 do { nll_error_print("nll.c", 1953, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_SAVE:
      if ((r = proc_save(command->args)) < 0)
 do { nll_error_print("nll.c", 1958, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_LOAD:
      if ((r = proc_load(command->args)) < 0)
 do { nll_error_print("nll.c", 1963, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_STDIN:
      if ((r = proc_stdin(command->args)) < 0)
 do { nll_error_print("nll.c", 1968, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_STDOUT:
      if ((r = proc_stdout(command->args)) < 0)
 do { nll_error_print("nll.c", 1973, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_EVAL:
      if ((r = proc_eval(spot, command->args)) < 0)
 do { nll_error_print("nll.c", 1978, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_EVALF:
      if ((r = proc_evalf(spot, command->args)) < 0)
 do { nll_error_print("nll.c", 1983, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_EDIT:
      if ((r = proc_edit(command->args)) < 0)
 do { nll_error_print("nll.c", 1988, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_WAIT:
      if ((r = proc_wait(command->args)) < 0)
 do { nll_error_print("nll.c", 1993, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_DUMP:
      if ((r = proc_dump(command->args)) < 0)
 do { nll_error_print("nll.c", 1998, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
      break;

    case COMMAND_NONE:
    case COMMAND_UNKNOWN:
    case COMMAND_DATA:
    default:
      break;
    }
  }

  spot->line = line->next;
  if (spot->line)
    spot->command = spot->line->commands;

next:
  return 0;

cont:
  if ((r = get_continue(spot)) < 0)
    do { nll_error_print("nll.c", 2018, (r), (command->line)); set_errcode((((void *)0)), (r)); goto brk; } while (0);
  clear_continue(((void *)0));
  return 0;

end:
  spot->line = ((void *)0);
  return 0;

init:
  nll_initialize_set();
  spot->line = ((void *)0);
  return 1;

brk:
  if (retcodep)
    *retcodep = 1;
  if (nll_finish_is_locked())
    goto ext;
  s.line = line;
  s.command = command;
  set_continue(&s);
  spot->line = ((void *)0);
  return 0;

ext:
  spot->line = ((void *)0);
  return -1;
}

static int nll_run(spot_t spot, int *retcodep)
{
  int r = 0;

  if (retcodep)
    *retcodep = 0;

  while (spot->line) {
    r = nll_proc(spot, retcodep);
    fflush(nll_stdout);
  }

  return r;
}

int nll_start(line_t line, command_t command, int *retcodep)
{
  struct spot spot;
  int r;

  nll_finished_clear();

  spot.line = line;

  if (!line)
    spot.command = ((void *)0);
  else
    spot.command = command ? command : line->commands;


  framebuf_enable(1);


  r = nll_run(&spot, retcodep);


  framebuf_enable(0);


  return r;
}

int nll_exec(spot_t spot, spot_t current, position_type_t type, value_t value, int *retcodep)
{
  int r, errcode = 0, locked;

  if ((r = position_push(type, current, ((void *)0), 0)) < 0)
    return r;

  locked = nll_finish_lock(1);
  if (nll_run(spot, retcodep))
    errcode = NLL_ERRCODE_NLL_INVALID_COMMAND;
  nll_finish_lock(locked);

  if ((r = position_pop(type, ((void *)0), ((void *)0), value, ((void *)0))) < 0)
    return r;

  return errcode;
}

int nll_parse_exec(spot_t current, position_type_t type, char *buffer, value_t value, int *retcodep)
{
  int r;
  line_t line;
  struct spot spot;

  if ((r = line_set(-1, -1, buffer, &line, 0, 0)) < 0)
    return r;
  if (!line)
    return NLL_ERRCODE_VALUE_INVALID_TYPE;

  if ((r = nll_parse(line)) < 0)
    goto err;


  if ((r = stack_push_type(STACK_TYPE_CALL, ((void *)0))) < 0)
    return r;

  spot.line = line;
  spot.command = line->commands;

  if ((r = nll_exec(&spot, current, type, ((void *)0), retcodep)) < 0)
    goto err;

  if ((r = stack_pop_type(STACK_TYPE_CALL, value)) < 0)
    return r;

  if ((r = line_free(line)) < 0)
    return r;

  return 0;

err:
  if (line)
    line_free(line);
  return r;
}

char *nll_line_buffer(line_t line)
{
  return line->buffer;
}

int nll_line_edit(int number, int number2, char *buffer, line_t *linep, int save, int move)
{
  return line_set(number, number2, buffer, linep, save, move);
}

int nll_line_free(line_t line)
{
  return line_free(line);
}
