# 0 "line.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "line.c"
# 1 "config.h" 1
# 2 "line.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "line.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "line.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "line.c" 2
# 1 "../include/ctype.h" 1



int isalnum(int c);
int isalpha(int c);
int isascii(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);
int tolower(int c);
int toupper(int c);
# 7 "line.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 10 "line.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 13 "line.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 14 "line.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 15 "line.c" 2
# 1 "command.h" 1



typedef enum {
  COMMAND_UNKNOWN = 0,
  COMMAND_NONE,

  COMMAND_COMMENT,
  COMMAND_END,
  COMMAND_EXIT,
  COMMAND_ARGS,
  COMMAND_LET,
  COMMAND_PRINT,
  COMMAND_GOTO,
  COMMAND_GONEXT,
  COMMAND_GOSUB,
  COMMAND_RETURN,
  COMMAND_IF,
  COMMAND_ELSE,
  COMMAND_ENDIF,
  COMMAND_LOOP,
  COMMAND_LOOPEND,
  COMMAND_FOR,
  COMMAND_NEXT,
  COMMAND_DISCARD,
  COMMAND_DIM,
  COMMAND_MEMORY,
  COMMAND_PUSH,
  COMMAND_POP,
  COMMAND_DFROM,
  COMMAND_DREAD,
  COMMAND_DATA,
  COMMAND_RUN,
  COMMAND_STOP,
  COMMAND_SKIP,
  COMMAND_BREAK,
  COMMAND_STEP,
  COMMAND_CONTINUE,
  COMMAND_NEW,
  COMMAND_LIST,
  COMMAND_SAVE,
  COMMAND_LOAD,
  COMMAND_STDIN,
  COMMAND_STDOUT,
  COMMAND_EVAL,
  COMMAND_EVALF,
  COMMAND_EDIT,
  COMMAND_WAIT,
  COMMAND_DUMP,

  COMMAND_LAST
} command_type_t;

typedef enum {
  COMMAND_ARG_UNKNOWN = 0,
  COMMAND_ARG_LABEL,
  COMMAND_ARG_VARIABLE,
  COMMAND_ARG_FORMULA,
  COMMAND_ARG_WORD,
} command_arg_type_t;

typedef const struct command_ope {
  const char *name;
  const char *other_name;
  command_type_t type;
} *command_ope_t;

typedef struct command_arg {
  command_arg_type_t type;
  union {
    struct {
      label_t label;
    } label;
    struct {
      variable_t variable;
    } variable;
    struct {
      element_t element;
    } formula;
    struct {
      char word[16 + 1];
    } word;
  } arg;
} *command_arg_t;

struct command {
  struct command *next;
  command_ope_t ope;
  char *line;
  int errcode;
  struct {
    label_t label;
    variable_t variable;
    element_t args;
  } label;
  element_t prefix;
  struct command_arg args[4];
};

int command_check(void);
int command_search(char *p, char **endp, command_ope_t *opep);
int command_list(FILE *fp);
int command_get(command_type_t type, command_ope_t *opep);
int command_alloc(command_t *commandp);
int command_free(command_t command);
int command_set_label(command_t command, const char *name, spot_t spot);
int command_clear_label(command_t command);
int command_clear(command_t command);
int command_clean(command_t command);
int command_init(void);
int command_done(void);
int command_dump(FILE *fp, command_t command);
# 16 "line.c" 2
# 1 "line.h" 1



struct line {
  struct line *next;
  struct line *prev;
  char buffer[256 + 1];
  command_t commands;
};

int line_check(void);
int line_alloc(line_t *linep);
int line_free(line_t line);
int line_clear(void);
int line_clean(void);
int line_init(void);
int line_done(void);
line_t line_head(void);
line_t line_tail(void);
int line_list_num(void);
int line_is_exist(line_t line);
int line_get(int number, line_t *linep);
int line_set(int number, int number2, char *buffer, line_t *linep, int save, int move);
int line_print(FILE *fp, int start_number, int end_number);
int line_dump(FILE *fp, line_t line);
# 17 "line.c" 2
# 1 "position.h" 1



struct position {
  position_type_t type;
  struct spot spot;
  value_t value;
  int arg;
};

int position_check(void);
int position_init(void);
int position_clear(void);
int position_clean(void);
int position_push(position_type_t type, spot_t spot, value_t value, int arg);
int position_pop(position_type_t type, position_type_t *typep,
   spot_t spot, value_t value, int *argp);
int position_peek(position_type_t type, spot_t spot, value_t *valuep, int *argp);
position_type_t position_get_type(void);
int position_get(spot_t spot, position_t *positionp);
int position_set(spot_t spot, position_t position);
int position_reset(position_t position);
int position_dump(FILE *fp);
# 18 "line.c" 2
# 1 "nll.h" 1



int nll_clear_line(line_t line);
int nll_parse(line_t line);
int nll_start(line_t line, command_t command, int *retcodep);
int nll_exec(spot_t spot, spot_t current, position_type_t type, value_t value, int *retcodep);
int nll_parse_exec(spot_t current, position_type_t type, char *buffer, value_t value, int *retcodep);
char *nll_line_buffer(line_t line);
int nll_line_edit(int number, int number2, char *buffer, line_t *linep, int save, int move);
int nll_line_free(line_t line);
# 19 "line.c" 2

static int line_num = 0;
static int pool_num = 0;
static int list_num = 0;

static line_t head = ((void *)0);
static line_t tail = ((void *)0);
static line_t pool = ((void *)0);

static line_t pool_alloc(void)
{
  line_t line;

  if (!pool)
    return ((void *)0);

  line = pool;
  pool = pool->next;
  pool_num--;

  return line;
}

static int pool_free(line_t line)
{
  line->next = pool;
  pool = line;
  pool_num++;
  return 0;
}


static int _init(void)
{
  return 0;
}

static int _done(void)
{
  while (pool)
    memory_free(pool_alloc());
  return 0;
}

static int _check(void)
{
  if (pool)
    return NLL_ERRCODE_LINE_NOT_EMPTY;
  return 0;
}

static line_t _alloc(void)
{
  line_t line;
  line = pool_alloc();
  if (!line)
    line = memory_alloc(sizeof(*line));
  return line;
}

static int _free(line_t line)
{
  if ((1024 < 0) || (pool_num < 1024))
    return pool_free(line);
  memory_free(line);
  return 0;
}
# 136 "line.c"
int line_check(void)
{
  if (line_num || list_num || head || tail)
    return NLL_ERRCODE_LINE_NOT_EMPTY;

  return _check();
}

int line_alloc(line_t *linep)
{
  line_t line;

  if ((line = _alloc()) == ((void *)0))
    return NLL_ERRCODE_LINE_BUFFER_OVER;
  line_num++;

  memset(line, 0, sizeof(*line));

  *linep = line;

  return 0;
}

int line_free(line_t line)
{
  int r;
  position_t position;
  struct spot s;

  command_free(line->commands);

  if ((r = nll_clear_line(line)) < 0) return r;

  s.line = line;
  s.command = ((void *)0);
  if ((r = position_get(&s, &position)) < 0) return r;

  if (position) {
    if ((r = position_reset(position)) < 0) return r;
  }

  line_num--;
  if ((r = _free(line)) < 0)
    return r;

  return 0;
}

int line_clear(void)
{
  int r;
  line_t line;

  while (head) {
    line = head;
    head = line->next;
    if (!head)
      tail = ((void *)0);
    list_num--;
    line->next = ((void *)0);
    line->prev = ((void *)0);
    if ((r = line_free(line)) < 0)
      return r;
  }

  return 0;
}

int line_clean(void)
{
  line_t line;
  int r;

  for (line = head; line; line = line->next) {
    if ((r = command_clean(line->commands)) < 0)
      return r;
  }

  return 0;
}

int line_init(void)
{
  line_num = 0;
  pool_num = 0;
  list_num = 0;
  head = ((void *)0);
  tail = ((void *)0);
  pool = ((void *)0);
  return _init();
}

int line_done(void)
{
  return _done();
}

line_t line_head(void)
{
  return head;
}

line_t line_tail(void)
{
  return tail;
}

int line_list_num(void)
{
  return list_num;
}

int line_is_exist(line_t line)
{
  line_t ln;

  for (ln = head; ln; ln = ln->next) {
    if (ln == line)
      return 1;
  }

  return 0;
}

int line_get(int number, line_t *linep)
{
  line_t line;
  int n = 0;

  for (line = head; line; line = line->next) {
    n++;
    if (number == n) {
      *linep = line;
      return 0;
    }
  }

  *linep = ((void *)0);
  return 0;
}

int line_set(int number, int number2, char *buffer, line_t *linep, int save, int move)
{
  line_t line = ((void *)0), *p = ((void *)0), *p2 = ((void *)0);
  int r, len = 0, n;

  if (buffer)
    len = strlen(buffer);

  if (len > 256)
    return NLL_ERRCODE_LINE_TOO_LONG;

  if (move) {
    n = 0;
    if (number2 > 0) {
      for (p2 = &head; *p2 && (number2 - 1 > n); p2 = &((*p2)->next))
 n++;
    } else {
      for (p2 = &tail; *p2 && (number2 < n); p2 = &((*p2)->prev))
 n--;
      p2 = *p2 ? &((*p2)->next) : &head;
    }
  }

  if (save) {
    n = 0;
    if (number > 0) {
      for (p = &head; *p && (number - 1 > n); p = &((*p)->next))
 n++;
    } else {
      if ((len == 0) || p2)
 number--;
      for (p = &tail; *p && (number < n); p = &((*p)->prev))
 n--;
      p = *p ? &((*p)->next) : &head;
    }
  }

  if (!p) {
    if (len == 0) {
      if (linep)
 *linep = ((void *)0);
      return 0;
    }
  } else {
    if ((len == 0) && !p2) {
      line = *p;
      if (*p) {
 *p = (*p)->next;
 if (*p)
   (*p)->prev = line->prev;
 else
   tail = line->prev;
 list_num--;
 line->next = ((void *)0);
 line->prev = ((void *)0);
 r = line_free(line);
 if (r < 0) return r;
      }
      if (linep)
 *linep = ((void *)0);
      return 0;
    }

    if (p2) {
      line = *p;
      if (*p) {
 if (p2 == &((*p)->next))
   p2 = p;
 *p = (*p)->next;
 if (*p)
   (*p)->prev = line->prev;
 else
   tail = line->prev;
 list_num--;
 line->next = ((void *)0);
 line->prev = ((void *)0);
 if (len == 0) {
   buffer = ((void *)0);
 } else {
   r = line_free(line);
   if (r < 0) return r;
   line = ((void *)0);
 }
      }
      if (!line && (len == 0)) {
 if (linep)
   *linep = ((void *)0);
 return 0;
      }
      p = p2;
    }
  }

  if (!line) {
    if ((r = line_alloc(&line)) < 0)
      return r;
  }

  if (buffer) {
    memcpy(line->buffer, buffer, len);
    line->buffer[len] = '\0';
  }

  if (p) {
    line->next = *p;
    if (*p) {
      line->prev = (*p)->prev;
      (*p)->prev = line;
    } else {
      line->prev = tail;
      tail = line;
    }
    list_num++;
    *p = line;
  }

  if (linep)
    *linep = buffer ? line : ((void *)0);

  return 0;
}

int line_print(FILE *fp, int start_number, int end_number)
{
  line_t line;
  int number = 0;

  for (line = head; line; line = line->next) {
    number++;
    if ((start_number >= 0) && (number < start_number))
      continue;
    if ((end_number >= 0) && (number > end_number))
      continue;
    nll_wait_output(fp);
    fprintf(fp, "%d%s\n", number, line->buffer);
  }

  fflush(fp);

  return 0;
}

int line_dump(FILE *fp, line_t line)
{
  char *p;

  if (!line)
    line = head;

  nll_wait_output(fp);
  fprintf(fp, "\n-- Line dump --\n");

  for (; line; line = line->next) {
    nll_wait_output(fp);
    for (p = line->buffer; isspace(*p); p++)
      ;
    fprintf(fp, "%s\n", p);
    command_dump(fp, line->commands);
  }

  fflush(fp);

  return 0;
}
