# 0 "formula.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "formula.c"
# 1 "config.h" 1
# 2 "formula.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "formula.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "formula.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "formula.c" 2
# 1 "../include/ctype.h" 1



int isalnum(int c);
int isalpha(int c);
int isascii(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);
int tolower(int c);
int toupper(int c);
# 7 "formula.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 10 "formula.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 13 "formula.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 14 "formula.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 15 "formula.c" 2
# 1 "command.h" 1



typedef enum {
  COMMAND_UNKNOWN = 0,
  COMMAND_NONE,

  COMMAND_COMMENT,
  COMMAND_END,
  COMMAND_EXIT,
  COMMAND_ARGS,
  COMMAND_LET,
  COMMAND_PRINT,
  COMMAND_GOTO,
  COMMAND_GONEXT,
  COMMAND_GOSUB,
  COMMAND_RETURN,
  COMMAND_IF,
  COMMAND_ELSE,
  COMMAND_ENDIF,
  COMMAND_LOOP,
  COMMAND_LOOPEND,
  COMMAND_FOR,
  COMMAND_NEXT,
  COMMAND_DISCARD,
  COMMAND_DIM,
  COMMAND_MEMORY,
  COMMAND_PUSH,
  COMMAND_POP,
  COMMAND_DFROM,
  COMMAND_DREAD,
  COMMAND_DATA,
  COMMAND_RUN,
  COMMAND_STOP,
  COMMAND_SKIP,
  COMMAND_BREAK,
  COMMAND_STEP,
  COMMAND_CONTINUE,
  COMMAND_NEW,
  COMMAND_LIST,
  COMMAND_SAVE,
  COMMAND_LOAD,
  COMMAND_STDIN,
  COMMAND_STDOUT,
  COMMAND_EVAL,
  COMMAND_EVALF,
  COMMAND_EDIT,
  COMMAND_WAIT,
  COMMAND_DUMP,

  COMMAND_LAST
} command_type_t;

typedef enum {
  COMMAND_ARG_UNKNOWN = 0,
  COMMAND_ARG_LABEL,
  COMMAND_ARG_VARIABLE,
  COMMAND_ARG_FORMULA,
  COMMAND_ARG_WORD,
} command_arg_type_t;

typedef const struct command_ope {
  const char *name;
  const char *other_name;
  command_type_t type;
} *command_ope_t;

typedef struct command_arg {
  command_arg_type_t type;
  union {
    struct {
      label_t label;
    } label;
    struct {
      variable_t variable;
    } variable;
    struct {
      element_t element;
    } formula;
    struct {
      char word[16 + 1];
    } word;
  } arg;
} *command_arg_t;

struct command {
  struct command *next;
  command_ope_t ope;
  char *line;
  int errcode;
  struct {
    label_t label;
    variable_t variable;
    element_t args;
  } label;
  element_t prefix;
  struct command_arg args[4];
};

int command_check(void);
int command_search(char *p, char **endp, command_ope_t *opep);
int command_list(FILE *fp);
int command_get(command_type_t type, command_ope_t *opep);
int command_alloc(command_t *commandp);
int command_free(command_t command);
int command_set_label(command_t command, const char *name, spot_t spot);
int command_clear_label(command_t command);
int command_clear(command_t command);
int command_clean(command_t command);
int command_init(void);
int command_done(void);
int command_dump(FILE *fp, command_t command);
# 16 "formula.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 17 "formula.c" 2
# 1 "string.h" 1



struct string {
  struct string *next;
  char *s;
  int length;
  int size;
};

int string_check(void);
int string_alloc(string_t *stringp);
int string_free(string_t string);
int string_del(string_t string);
int string_init(void);
int string_done(void);
int string_set(string_t string, const char *s, int length);
char *string_buffer(void);
int string_buffer_size(void);
int string_dump_string(FILE *fp, string_t string);
int string_dump(FILE *fp, string_t string);
# 18 "formula.c" 2
# 1 "variable.h" 1



struct variable {
  struct variable *next;
  struct variable *prev;
  value_t value;
  int refcount;
  char name[32 + 1];
};

int variable_check(void);
int variable_del(variable_t variable);
int variable_clean(void);
int variable_clear(void);
int variable_new(variable_t variable);
int variable_init(void);
int variable_done(void);
int variable_get(const char *name, variable_t *variablep);
int variable_dump(FILE *fp, variable_t variable);
int variable_const_list(FILE *fp);
# 19 "formula.c" 2
# 1 "label.h" 1



struct label {
  struct label *next;
  struct label *prev;
  struct spot spot;
  int refcount;
  char name[32 + 1];
};

int label_check(void);
int label_init(void);
int label_done(void);
int label_get(const char *name, label_t *labelp);
int label_set(const char *name, spot_t spot, label_t *labelp);
int label_clear(label_t label);
int label_clean(label_t label);
int label_del(label_t label);
int label_dump(FILE *fp, label_t label);
# 20 "formula.c" 2
# 1 "array.h" 1



struct array {
  value_t value;
};

int array_check(void);
int array_init(void);
int array_get_number(array_t array);
int array_get_value(array_t array, int index, value_t *valuep);
int array_set_value(array_t array, int index, value_t value);
int array_alloc(array_t *arrayp, int number);
int array_free(array_t array, int number);
int array_make(value_t value, int *n);
int array_make_values(value_t value, value_t numbers);
int array_dump(FILE *fp, array_t array);
# 21 "formula.c" 2
# 1 "stack.h" 1





typedef enum {
  STACK_TYPE_USER = 0,
  STACK_TYPE_CALL,
} stack_type_t;

struct stack_frame {
  value_t value;
};

int stack_check(void);
int stack_init(void);
int stack_getnum(void);
int stack_push_type(stack_type_t type, value_t value);
int stack_pop_type(stack_type_t type, value_t value);
int stack_push(value_t value);
int stack_pop(value_t value);
int stack_clear(void);
int stack_clean(void);
int stack_dump(FILE *fp);
# 22 "formula.c" 2
# 1 "function.h" 1



enum {
  FUNCTION_TYPE_NONE = 0,
  FUNCTION_TYPE_FARGS,
  FUNCTION_TYPE_COPY,
  FUNCTION_TYPE_TRUE,
  FUNCTION_TYPE_FALSE,
  FUNCTION_TYPE_ARGNUM,
  FUNCTION_TYPE_BOOLEAN,
  FUNCTION_TYPE_COND,
  FUNCTION_TYPE_AT,
  FUNCTION_TYPE_FPUSH,
  FUNCTION_TYPE_FPOP,
  FUNCTION_TYPE_STACKNUM,
  FUNCTION_TYPE_FPRINT,
  FUNCTION_TYPE_SPRINTF,
  FUNCTION_TYPE_PRINTF,
  FUNCTION_TYPE_PRINTM,
  FUNCTION_TYPE_INPUT,
  FUNCTION_TYPE_INPUTN,
  FUNCTION_TYPE_FWAIT,
  FUNCTION_TYPE_TIMER,
  FUNCTION_TYPE_NOSYSTEM,
  FUNCTION_TYPE_NOSYSCALL,
  FUNCTION_TYPE_NONETWORK,





  FUNCTION_TYPE_SYSTEM,


  FUNCTION_TYPE_SYSCALL,

  FUNCTION_TYPE_FEVAL,
  FUNCTION_TYPE_FEVALF,
  FUNCTION_TYPE_TYPEOF,
  FUNCTION_TYPE_TYPENAME,
  FUNCTION_TYPE_SIZEOF,
  FUNCTION_TYPE_NZERO,
  FUNCTION_TYPE_CMP,
  FUNCTION_TYPE_REP,
  FUNCTION_TYPE_INSERT,
  FUNCTION_TYPE_DELETE,
  FUNCTION_TYPE_ITOC,
  FUNCTION_TYPE_CTOI,
  FUNCTION_TYPE_ITOA,
  FUNCTION_TYPE_ATOI,

  FUNCTION_TYPE_ITOF,
  FUNCTION_TYPE_FTOI,
  FUNCTION_TYPE_ATOF,
  FUNCTION_TYPE_FTOA,

  FUNCTION_TYPE_ISALNUM,
  FUNCTION_TYPE_ISALPHA,
  FUNCTION_TYPE_ISASCII,
  FUNCTION_TYPE_ISCNTRL,
  FUNCTION_TYPE_ISDIGIT,
  FUNCTION_TYPE_ISGRAPH,
  FUNCTION_TYPE_ISLOWER,
  FUNCTION_TYPE_ISPRINT,
  FUNCTION_TYPE_ISPUNCT,
  FUNCTION_TYPE_ISSPACE,
  FUNCTION_TYPE_ISUPPER,
  FUNCTION_TYPE_ISXDIGIT,
  FUNCTION_TYPE_TOLOWER,
  FUNCTION_TYPE_TOUPPER,
  FUNCTION_TYPE_LEFT,
  FUNCTION_TYPE_RIGHT,
  FUNCTION_TYPE_MID,
  FUNCTION_TYPE_INSTR,
  FUNCTION_TYPE_STRLEN,
  FUNCTION_TYPE_STRCPY,
  FUNCTION_TYPE_SPLIT,
  FUNCTION_TYPE_SPLITS,
  FUNCTION_TYPE_CHOMP,
  FUNCTION_TYPE_LCHOMP,
  FUNCTION_TYPE_RCHOMP,
  FUNCTION_TYPE_SRAND,
  FUNCTION_TYPE_RAND,
  FUNCTION_TYPE_INT,
  FUNCTION_TYPE_ABS,
  FUNCTION_TYPE_SIGN,
  FUNCTION_TYPE_MAX,
  FUNCTION_TYPE_MIN,
  FUNCTION_TYPE_ABS2SUM,
  FUNCTION_TYPE_TIME,
  FUNCTION_TYPE_DATE,
  FUNCTION_TYPE_FDIM,
  FUNCTION_TYPE_FMEMORY,
  FUNCTION_TYPE_PEEK,
  FUNCTION_TYPE_POKE,
  FUNCTION_TYPE_MREAD,
  FUNCTION_TYPE_MWRITE,
  FUNCTION_TYPE_MCOPY,
# 127 "function.h"
  FUNCTION_TYPE_RENAME,
  FUNCTION_TYPE_UNLINK,
  FUNCTION_TYPE_TRUNCATE,
  FUNCTION_TYPE_MKDIR,
  FUNCTION_TYPE_RMDIR,
  FUNCTION_TYPE_CHDIR,
  FUNCTION_TYPE_OPEN,
  FUNCTION_TYPE_CLOSE,
  FUNCTION_TYPE_READ,
  FUNCTION_TYPE_WRITE,
  FUNCTION_TYPE_LSEEK,
  FUNCTION_TYPE_FTRUNCATE,
  FUNCTION_TYPE_ISREADABLE,
  FUNCTION_TYPE_ISWRITABLE,
  FUNCTION_TYPE_FOPEN,
  FUNCTION_TYPE_FDOPEN,
  FUNCTION_TYPE_FCLOSE,
  FUNCTION_TYPE_FILENO,
  FUNCTION_TYPE_FEOF,
  FUNCTION_TYPE_FERROR,
  FUNCTION_TYPE_FGETC,
  FUNCTION_TYPE_FPUTC,
  FUNCTION_TYPE_FGETS,
  FUNCTION_TYPE_FPUTS,
  FUNCTION_TYPE_FPRINTF,
  FUNCTION_TYPE_FREAD,
  FUNCTION_TYPE_FWRITE,
  FUNCTION_TYPE_FSEEK,
  FUNCTION_TYPE_QOPEN,
  FUNCTION_TYPE_QCLOSE,
  FUNCTION_TYPE_QLENGTH,
  FUNCTION_TYPE_QPUSHF,
  FUNCTION_TYPE_QPOPL,
  FUNCTION_TYPE_QPUSHL,
  FUNCTION_TYPE_QPOPF,
# 175 "function.h"
  FUNCTION_TYPE_KEYNAME,
  FUNCTION_TYPE_KEYCODE,
  FUNCTION_TYPE_SCREEN,
  FUNCTION_TYPE_SCRSTAT,
  FUNCTION_TYPE_FLUSH,
  FUNCTION_TYPE_GETCOLOR,
  FUNCTION_TYPE_GETFGCOLOR,
  FUNCTION_TYPE_GETBGCOLOR,
  FUNCTION_TYPE_SETCOLOR,
  FUNCTION_TYPE_GETATTR,
  FUNCTION_TYPE_SETATTR,
  FUNCTION_TYPE_GETPOS,
  FUNCTION_TYPE_MOVE,
  FUNCTION_TYPE_GETCH,
  FUNCTION_TYPE_CLEAR,
  FUNCTION_TYPE_SCROLL,
  FUNCTION_TYPE_LINE,
  FUNCTION_TYPE_BOX,
  FUNCTION_TYPE_INKEY,
  FUNCTION_TYPE_GSCREEN,
  FUNCTION_TYPE_GSCRSTAT,
  FUNCTION_TYPE_GCOLOR,
  FUNCTION_TYPE_GRGB,
  FUNCTION_TYPE_GSYNC,
  FUNCTION_TYPE_GFLUSH,
  FUNCTION_TYPE_GGETMAINIMG,
  FUNCTION_TYPE_GSETMAINIMG,
  FUNCTION_TYPE_GGETSIZE,
  FUNCTION_TYPE_GGETRANGE,
  FUNCTION_TYPE_GSETRANGE,
  FUNCTION_TYPE_GGETOFFSET,
  FUNCTION_TYPE_GSETOFFSET,
  FUNCTION_TYPE_GGETSCALE,
  FUNCTION_TYPE_GSETSCALE,
  FUNCTION_TYPE_GGETDOTOFFSET,
  FUNCTION_TYPE_GSETDOTOFFSET,
  FUNCTION_TYPE_GGETDOTSIZE,
  FUNCTION_TYPE_GSETDOTSIZE,
  FUNCTION_TYPE_GGETCOLOR,
  FUNCTION_TYPE_GSETCOLOR,
  FUNCTION_TYPE_GGETPIXEL,
  FUNCTION_TYPE_GCLEAR,
  FUNCTION_TYPE_GSCROLL,
  FUNCTION_TYPE_GDOT,
  FUNCTION_TYPE_GLINE,
  FUNCTION_TYPE_GBOX,
  FUNCTION_TYPE_GCIRCLE,
  FUNCTION_TYPE_GPAINT,
  FUNCTION_TYPE_GCOPY,
  FUNCTION_TYPE_GROTATE,
  FUNCTION_TYPE_GCHAR,
  FUNCTION_TYPE_GPRINT,
  FUNCTION_TYPE_GINKEY,
  FUNCTION_TYPE_GKEYSTAT,
  FUNCTION_TYPE_GMOUSEPOS,
  FUNCTION_TYPE_GINMOUSE,
  FUNCTION_TYPE_GMOUSESTAT,
  FUNCTION_TYPE_GALLOCIMAGE,
  FUNCTION_TYPE_GFREEIMAGE,
  FUNCTION_TYPE_GLOADIMAGE,
  FUNCTION_TYPE_GSAVEIMAGE,
  FUNCTION_TYPE_GCMPIMAGE,
  FUNCTION_TYPE_GCHARSET,
  FUNCTION_TYPE_ASTOP,
  FUNCTION_TYPE_ACLEAR,
  FUNCTION_TYPE_ASOUND,
  FUNCTION_TYPE_ASNDSTAT,
  FUNCTION_TYPE_APLAYNUM,
  FUNCTION_TYPE_AWAIT,
  FUNCTION_TYPE_AUNITSET,
  FUNCTION_TYPE_AUNIT,
  FUNCTION_TYPE_AOSC,
  FUNCTION_TYPE_AADDOUT,
  FUNCTION_TYPE_AENVPOINT,
  FUNCTION_TYPE_AENVCOPY,
  FUNCTION_TYPE_AFILPOINT,
  FUNCTION_TYPE_AFILCOPY,
  FUNCTION_TYPE_APLAY,
  FUNCTION_TYPE_AOPEN,
  FUNCTION_TYPE_ACLOSE,
};

const char *function_name(function_t function);
int function_search(const char *name, function_t *functionp);
int function_list(FILE *fp);
int function_proc(function_t function, value_t *valuep, value_t args);
# 23 "formula.c" 2
# 1 "nll.h" 1



int nll_clear_line(line_t line);
int nll_parse(line_t line);
int nll_start(line_t line, command_t command, int *retcodep);
int nll_exec(spot_t spot, spot_t current, position_type_t type, value_t value, int *retcodep);
int nll_parse_exec(spot_t current, position_type_t type, char *buffer, value_t value, int *retcodep);
char *nll_line_buffer(line_t line);
int nll_line_edit(int number, int number2, char *buffer, line_t *linep, int save, int move);
int nll_line_free(line_t line);
# 24 "formula.c" 2
# 1 "formula.h" 1



typedef enum {
  ELEMENT_TYPE_NONE,
  ELEMENT_TYPE_SYMBOL,
  ELEMENT_TYPE_INTEGER,
  ELEMENT_TYPE_STRING,

  ELEMENT_TYPE_FLOAT,

  ELEMENT_TYPE_VARIABLE,
  ELEMENT_TYPE_OPERATOR,
  ELEMENT_TYPE_ELEMENTS,
} element_type_t;

int formula_check(void);
int formula_init(void);
int formula_done(void);
int formula_get_symbol(char *dname, const char *name);
element_type_t formula_get_type(element_t element);
value_t formula_get_value(element_t element);
variable_t formula_get_variable(element_t element);
int formula_set_raw(element_t element);
int formula_free(element_t *elementp);
int formula_clean(element_t element);
int formula_parse(char *formula, char **endp, element_t *elementp, const char *terminator);
int formula_proc(element_t element, value_t *valuep);
int formula_dump(FILE *fp, element_t element);
int formula_operator_list(FILE *fp);
# 25 "formula.c" 2

typedef enum {
  OPERATOR_TYPE_NONE = 0 ,
  OPERATOR_TYPE_NOP ,
  OPERATOR_TYPE_VEQ ,
  OPERATOR_TYPE_VNE ,
  OPERATOR_TYPE_LSHIFTEQ ,
  OPERATOR_TYPE_RSHIFTEQ ,
  OPERATOR_TYPE_INC ,
  OPERATOR_TYPE_DEC ,
  OPERATOR_TYPE_INCA ,
  OPERATOR_TYPE_DECA ,
  OPERATOR_TYPE_LSHIFT ,
  OPERATOR_TYPE_RSHIFT ,
  OPERATOR_TYPE_LE ,
  OPERATOR_TYPE_GE ,
  OPERATOR_TYPE_EQ ,
  OPERATOR_TYPE_NE ,
  OPERATOR_TYPE_LOGAND ,
  OPERATOR_TYPE_LOGOR ,
  OPERATOR_TYPE_LOGCAND ,
  OPERATOR_TYPE_LOGCOR ,
  OPERATOR_TYPE_ADDEQ ,
  OPERATOR_TYPE_SUBEQ ,
  OPERATOR_TYPE_MULEQ ,
  OPERATOR_TYPE_DIVEQ ,
  OPERATOR_TYPE_MODEQ ,
  OPERATOR_TYPE_ANDEQ ,
  OPERATOR_TYPE_XOREQ ,
  OPERATOR_TYPE_OREQ ,
  OPERATOR_TYPE_NOT ,
  OPERATOR_TYPE_INV ,
  OPERATOR_TYPE_PLUS ,
  OPERATOR_TYPE_MINUS ,
  OPERATOR_TYPE_PUSH ,
  OPERATOR_TYPE_POP ,
  OPERATOR_TYPE_POINTER ,
  OPERATOR_TYPE_ADDRESS ,
  OPERATOR_TYPE_SIZE ,
  OPERATOR_TYPE_VALUES ,
  OPERATOR_TYPE_BOOLEAN ,
  OPERATOR_TYPE_MUL ,
  OPERATOR_TYPE_DIV ,
  OPERATOR_TYPE_MOD ,
  OPERATOR_TYPE_ADD ,
  OPERATOR_TYPE_SUB ,
  OPERATOR_TYPE_LT ,
  OPERATOR_TYPE_GT ,
  OPERATOR_TYPE_XOR ,
  OPERATOR_TYPE_AND ,
  OPERATOR_TYPE_OR ,
  OPERATOR_TYPE_COND ,
  OPERATOR_TYPE_AT ,
  OPERATOR_TYPE_SUBST ,
  OPERATOR_TYPE_REFER ,
  OPERATOR_TYPE_STATIC ,
  OPERATOR_TYPE_ARROW ,
  OPERATOR_TYPE_DOT ,
  OPERATOR_TYPE_BRACKET ,
  OPERATOR_TYPE_RBRACKET ,
  OPERATOR_TYPE_ARRAY ,
  OPERATOR_TYPE_VECTOR ,
  OPERATOR_TYPE_EXEC ,
  OPERATOR_TYPE_COMMA ,
  OPERATOR_TYPE_FUNCTION ,
} operator_type_t;

typedef enum {
  OPERATOR_SUBTYPE_NONE = 0,
  OPERATOR_SUBTYPE_MONADIC,
  OPERATOR_SUBTYPE_MON_BIN,
  OPERATOR_SUBTYPE_BINARY,
} operator_subtype_t;

typedef const struct operator {
  const char *word;
  const char *term;
  int priority;
  operator_type_t type;
  operator_subtype_t subtype;
  unsigned int flags;




} *operator_t;

typedef union element_param {
  struct {
    variable_t variable;
  } variable;
  struct {
    const struct operator *op;
    element_t args[2];
  } operator;
  struct {
    element_t head;
    const struct operator *op;
  } elements;
  struct {
    char name[32 + 1];
  } name;
} *element_param_t;

struct element {
  struct element *next;
  element_type_t type;
  unsigned int flags;


  value_t value;
  union element_param param;
};

static const struct operator operators[] = {
  { "===", ((void *)0), 6, OPERATOR_TYPE_VEQ , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "!==", ((void *)0), 6, OPERATOR_TYPE_VNE , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "<<=", ((void *)0), 12, OPERATOR_TYPE_LSHIFTEQ , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { ">>=", ((void *)0), 12, OPERATOR_TYPE_RSHIFTEQ , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { "++" , ((void *)0), 1, OPERATOR_TYPE_INC , OPERATOR_SUBTYPE_MONADIC, (1 << 0)|(1 << 2) },
  { "--" , ((void *)0), 1, OPERATOR_TYPE_DEC , OPERATOR_SUBTYPE_MONADIC, (1 << 0)|(1 << 2) },
  { "++" , ((void *)0), 1, OPERATOR_TYPE_INCA , OPERATOR_SUBTYPE_MONADIC, (1 << 1)|(1 << 2) },
  { "--" , ((void *)0), 1, OPERATOR_TYPE_DECA , OPERATOR_SUBTYPE_MONADIC, (1 << 1)|(1 << 2) },
  { "<<" , ((void *)0), 4, OPERATOR_TYPE_LSHIFT , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { ">>" , ((void *)0), 4, OPERATOR_TYPE_RSHIFT , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "<=" , ((void *)0), 5, OPERATOR_TYPE_LE , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { ">=" , ((void *)0), 5, OPERATOR_TYPE_GE , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "==" , ((void *)0), 6, OPERATOR_TYPE_EQ , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "!=" , ((void *)0), 6, OPERATOR_TYPE_NE , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "<>" , ((void *)0), 6, OPERATOR_TYPE_NE , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "&&" , ((void *)0), 10, OPERATOR_TYPE_LOGAND , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "||" , ((void *)0), 11, OPERATOR_TYPE_LOGOR , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "&>" , ((void *)0), 10, OPERATOR_TYPE_LOGCAND , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "|>" , ((void *)0), 11, OPERATOR_TYPE_LOGCOR , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "+=" , ((void *)0), 12, OPERATOR_TYPE_ADDEQ , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { "-=" , ((void *)0), 12, OPERATOR_TYPE_SUBEQ , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { "*=" , ((void *)0), 12, OPERATOR_TYPE_MULEQ , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { "/=" , ((void *)0), 12, OPERATOR_TYPE_DIVEQ , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { "%=" , ((void *)0), 12, OPERATOR_TYPE_MODEQ , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { "&=" , ((void *)0), 12, OPERATOR_TYPE_ANDEQ , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { "^=" , ((void *)0), 12, OPERATOR_TYPE_XOREQ , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { "|=" , ((void *)0), 12, OPERATOR_TYPE_OREQ , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { "?=" , ((void *)0), 12, OPERATOR_TYPE_STATIC , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { "@=" , ((void *)0), 12, OPERATOR_TYPE_REFER , OPERATOR_SUBTYPE_BINARY , (1 << 0) },
  { "->" , ((void *)0), 0, OPERATOR_TYPE_ARROW , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "!" , ((void *)0), 1, OPERATOR_TYPE_NOT , OPERATOR_SUBTYPE_MON_BIN, (1 << 0)|(1 << 3) },
  { "~" , ((void *)0), 1, OPERATOR_TYPE_INV , OPERATOR_SUBTYPE_MONADIC, (1 << 0)|(1 << 3) },
  { "+" , ((void *)0), 1, OPERATOR_TYPE_PLUS , OPERATOR_SUBTYPE_MON_BIN, (1 << 0)|(1 << 3) },
  { "-" , ((void *)0), 1, OPERATOR_TYPE_MINUS , OPERATOR_SUBTYPE_MON_BIN, (1 << 0)|(1 << 3) },
  { "+" , ((void *)0), 1, OPERATOR_TYPE_PUSH , OPERATOR_SUBTYPE_MON_BIN, (1 << 1) },
  { "-" , ((void *)0), 1, OPERATOR_TYPE_POP , OPERATOR_SUBTYPE_MON_BIN, (1 << 1)|(1 << 2) },
  { "*" , ((void *)0), 1, OPERATOR_TYPE_POINTER , OPERATOR_SUBTYPE_MON_BIN, (1 << 0)|(1 << 3) },
  { "&" , ((void *)0), 1, OPERATOR_TYPE_ADDRESS , OPERATOR_SUBTYPE_MON_BIN, (1 << 0)|(1 << 3) },
  { "#" , ((void *)0), 1, OPERATOR_TYPE_SIZE , OPERATOR_SUBTYPE_MON_BIN, (1 << 0)|(1 << 3) },
  { "%" , ((void *)0), 1, OPERATOR_TYPE_VALUES , OPERATOR_SUBTYPE_MON_BIN, (1 << 0)|(1 << 3) },
  { "?" , ((void *)0), 1, OPERATOR_TYPE_BOOLEAN , OPERATOR_SUBTYPE_MON_BIN, (1 << 0)|(1 << 3) },
  { "*" , ((void *)0), 2, OPERATOR_TYPE_MUL , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "/" , ((void *)0), 2, OPERATOR_TYPE_DIV , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "%" , ((void *)0), 2, OPERATOR_TYPE_MOD , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "+" , ((void *)0), 3, OPERATOR_TYPE_ADD , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "-" , ((void *)0), 3, OPERATOR_TYPE_SUB , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "<" , ((void *)0), 5, OPERATOR_TYPE_LT , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { ">" , ((void *)0), 5, OPERATOR_TYPE_GT , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "^" , ((void *)0), 8, OPERATOR_TYPE_XOR , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "&" , ((void *)0), 7, OPERATOR_TYPE_AND , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "|" , ((void *)0), 9, OPERATOR_TYPE_OR , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "?" , ((void *)0), 2, OPERATOR_TYPE_COND , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 3) },
  { "@" , ((void *)0), 2, OPERATOR_TYPE_AT , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 3) },
  { "=" , ((void *)0), 12, OPERATOR_TYPE_SUBST , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 2) },
  { "." , ((void *)0), 0, OPERATOR_TYPE_DOT , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "(" , ")" , 0, OPERATOR_TYPE_BRACKET , OPERATOR_SUBTYPE_MONADIC, (1 << 0)|(1 << 3) },
  { "{" , "}" , 0, OPERATOR_TYPE_RBRACKET , OPERATOR_SUBTYPE_MONADIC, (1 << 0)|(1 << 3) },
  { "[" , "]" , 0, OPERATOR_TYPE_ARRAY , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "#" , ((void *)0), 1, OPERATOR_TYPE_VECTOR , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "!" , ((void *)0), 12, OPERATOR_TYPE_EXEC , OPERATOR_SUBTYPE_BINARY , (1 << 1)|(1 << 3) },
  { "," , ((void *)0), 13, OPERATOR_TYPE_COMMA , OPERATOR_SUBTYPE_NONE , 0 },
  { ((void *)0) , ((void *)0), 13, OPERATOR_TYPE_NOP , OPERATOR_SUBTYPE_NONE , (1 << 1)|(1 << 3) },
  { ((void *)0) , ((void *)0), 1, OPERATOR_TYPE_FUNCTION , OPERATOR_SUBTYPE_BINARY , (1 << 0)|(1 << 3) },
  { ((void *)0) , ((void *)0), 0, OPERATOR_TYPE_NONE , OPERATOR_SUBTYPE_NONE , 0 },
};






static int element_num = 0;
static int pool_num = 0;

static element_t pool = ((void *)0);

static element_t pool_alloc(void)
{
  element_t element;

  if (!pool)
    return ((void *)0);

  element = pool;
  pool = pool->next;
  pool_num--;

  return element;
}

static int pool_free(element_t element)
{
  element->next = pool;
  pool = element;
  pool_num++;
  return 0;
}


static int _init(void)
{
  return 0;
}

static int _done(void)
{
  while (pool)
    memory_free(pool_alloc());
  return 0;
}

static int _check(void)
{
  if (pool)
    return NLL_ERRCODE_FORMULA_NOT_EMPTY;
  return 0;
}

static element_t _alloc(void)
{
  element_t element;
  element = pool_alloc();
  if (!element)
    element = memory_alloc(sizeof(*element));
  return element;
}

static int _free(element_t element)
{
  if ((1024 < 0) || (pool_num < 1024))
    return pool_free(element);
  memory_free(element);
  return 0;
}
# 324 "formula.c"
int formula_check(void)
{
  if (element_num)
    return NLL_ERRCODE_FORMULA_NOT_EMPTY;

  return _check();
}

static operator_t operator_get(operator_type_t type)
{
  operator_t operator;
  for (operator = operators; operator->type != OPERATOR_TYPE_NONE; operator++) {
    if (operator->type == type)
      return operator;
  }
  return ((void *)0);
}

static int element_free(element_t element)
{
  element_t next;
  int r;

  for (; element; element = next) {
    next = element->next;

    if (element->value) {




      if ((r = value_free(element->value)) < 0)
 return r;
      element->value = ((void *)0);
    }
    element->type = ELEMENT_TYPE_NONE;

    element_num--;
    if ((r = _free(element)) < 0)
      return r;
  }

  return 0;
}

static int element_alloc(element_t *elementp)
{
  element_t element;

  if ((element = _alloc()) == ((void *)0))
    return NLL_ERRCODE_FORMULA_BUFFER_OVER;
  element_num++;

  memset(element, 0, sizeof(*element));
  element->next = ((void *)0);
  element->type = ELEMENT_TYPE_NONE;

  *elementp = element;

  return 0;
}

static int element_clean(element_t element)
{
  value_t value;
  int r;

  for (value = element->value; value; value = value->next) {
    element->flags &= ~(1 << 0);
    if ((r = value_clear(value)) < 0)
      return r;
  }

  return 0;
}

static int element_init(void)
{
  element_num = 0;
  pool_num = 0;
  pool = ((void *)0);
  return _init();
}

static int element_done(void)
{
  return _done();
}

int formula_init(void)
{
  return element_init();
}

int formula_done(void)
{
  return element_done();
}

int formula_get_symbol(char *dname, const char *name)
{
  const char *p;

  for (p = name; *p; p++) {
    if (p == name) {
      if (isalpha(*p) || (*p == '_'))
 ;

      else if (*p & 0x80)
 ;

      else
 break;
    } else {
      if (isalnum(*p) || (*p == '_'))
 ;

      else if (*p & 0x80)
 ;

      else
 break;
    }
    if (p - name >= 32)
      return NLL_ERRCODE_NLL_SYMBOL_TOO_LONG;
    *(dname++) = toupper(*p);
  }

  *dname = '\0';

  return p - name;
}

element_type_t formula_get_type(element_t element)
{
  return element ? element->type : ELEMENT_TYPE_NONE;
}

value_t formula_get_value(element_t element)
{
  return element ? element->value : ((void *)0);
}

variable_t formula_get_variable(element_t element)
{
  if (!element || (element->type != ELEMENT_TYPE_VARIABLE))
    return ((void *)0);
  return element->param.variable.variable;
}

int formula_set_raw(element_t element)
{
  if (!element)
    return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;
  element->flags |= (1 << 1);
  return 0;
}

union val {
  integer_t integer;
  struct {
    char *s;
    int length;
  } string;

  double floating;

};

static int element_alloc_value(element_t element)
{
  return value_alloc(&element->value);
}

static int element_push(element_t *elementp, element_type_t type, unsigned int flags,
   union val *val, element_param_t param)
{
  element_t element = ((void *)0);
  int r;

  if ((r = element_alloc(&element)) < 0)
    goto err;

  element->type = type;
  element->flags |= flags;

  switch (type) {
  case ELEMENT_TYPE_INTEGER:
    if ((r = element_alloc_value(element)) < 0)
      goto err;
    if ((r = value_set_integer(element->value, val->integer)) < 0)
      goto err;
    element->value->flags |= (1 << 0);
    break;
  case ELEMENT_TYPE_STRING:
    if ((r = element_alloc_value(element)) < 0)
      goto err;
    if ((r = value_set_string(element->value, val->string.s, val->string.length)) < 0)
      goto err;
    element->value->flags |= (1 << 0);
    break;

  case ELEMENT_TYPE_FLOAT:
    if ((r = element_alloc_value(element)) < 0)
      goto err;
    if ((r = value_set_float(element->value, val->floating)) < 0)
      goto err;
    element->value->flags |= (1 << 0);
    break;

  default:
    break;
  }

  if (param)
    memcpy(&element->param, param, sizeof(element->param));

  element->next = *elementp;
  *elementp = element;

  return 0;

err:
  if (element)
    element_free(element);
  return r;
}

static int a2val(char c)
{
  if (isdigit(c))
    return c - '0';
  else if (isalpha(c))
    return toupper(c) - 'A' + 10;
  return -1;
}

static int lex(element_t *elementp, char *formula, char **endp, const char *terminator)
{
  int r, v, scale, is_float;
  integer_t integer;
  union val val;

  double fscale;

  char quat = '\0';
  int escape = 0, escape_scale = 0;
  element_t head, *tail, element;
  char *p;
  char *word, *wp = ((void *)0);
  union element_param param;
  operator_t operator;

  word = string_buffer();

  p = formula;

  head = ((void *)0);
  tail = &head;

  while (1) {
    if (*p == '\0')
      break;

    if (quat) {
      if (escape && escape_scale) {
 v = a2val(*p);
 if ((v < 0) || (v >= escape_scale)) {
   *(wp++) = integer;
   escape = 0;
   p--;
 } else {
   integer = integer * escape_scale + v;
 }
      } else if (escape) {
 switch (*p) {
 case '0': integer = 0; escape_scale = 8; break;
 case 'x':
 case 'X': integer = 0; escape_scale = 16; break;
 case 'b':
 case 'B': integer = 0; escape_scale = 2; break;
 case 'T':
 case 't': *(wp++) = '\t'; escape = 0; break;
 case 'N':
 case 'n': *(wp++) = '\n'; escape = 0; break;
 case 'V':
 case 'v': *(wp++) = '\v'; escape = 0; break;
 case 'F':
 case 'f': *(wp++) = '\f'; escape = 0; break;
 case 'R':
 case 'r': *(wp++) = '\r'; escape = 0; break;
 case 'A':
 case 'a': *(wp++) = '\a'; escape = 0; break;
 default: *(wp++) = *p; escape = 0; break;
 }
      } else if (*p == quat) {
 *wp = '\0';
 switch (quat) {
 case '\'':
   val.integer = *(unsigned char *)word;
   if ((r = element_push(tail, ELEMENT_TYPE_INTEGER, 0, &val, ((void *)0))) < 0)
     goto ret;
   tail = &((*tail)->next);
   break;
 case '\"':
   val.string.s = word;
   val.string.length = wp - word;
   if ((r = element_push(tail, ELEMENT_TYPE_STRING, 0, &val, ((void *)0))) < 0)
     goto ret;
   tail = &((*tail)->next);
   break;
 default:
   break;
 }
 quat = '\0';
      } else if (*p == '\\') {
 escape = 1;
 escape_scale = 0;
      } else {
 *(wp++) = *p;
      }
      p++;
    } else if (strchr(terminator, *p)) {
      break;
    } else if ((*p == '\'') || (*p == '\"')) {
      quat = *p;
      escape = 0;
      wp = word;
      p++;
    } else if (isspace(*p)) {
      p++;
      continue;
    } else if (isdigit(*p)) {
      integer = 0;
      scale = 10;
      is_float = 0;

      fscale = 0;

      if (*p == '0') {
 scale = 8;
 p++;
 if ((*p == 'x') || (*p == 'X')) {
   scale = 16;
   p++;
 } else if ((*p == 'b') || (*p == 'B')) {
   scale = 2;
   p++;
 }
      }
      while (1) {

 if (*p == '.') {
   val.floating = integer;
   scale = 10;
   integer = 0;
   fscale = 1;
   is_float = 1;
   p++;
   continue;
 }

 v = a2val(*p);
 if (v < 0)
   break;
 if (v >= scale)
   break;
 integer = integer * scale + v;

 if (is_float)
   fscale *= scale;

 p++;
      }
      if (is_float) {

 val.floating += integer / fscale;
 if ((r = element_push(tail, ELEMENT_TYPE_FLOAT, 0, &val, ((void *)0))) < 0)
   goto ret;

      } else {
 val.integer = integer;
 if ((r = element_push(tail, ELEMENT_TYPE_INTEGER, 0, &val, ((void *)0))) < 0)
   goto ret;
      }
      tail = &((*tail)->next);
    } else if ((r = formula_get_symbol(param.name.name, p)) != 0) {
      if (r < 0)
 goto ret;
      memcpy(p, param.name.name, r);
      p += r;
      if ((r = element_push(tail, ELEMENT_TYPE_SYMBOL, 0, ((void *)0), &param)) < 0)
 goto ret;
      tail = &((*tail)->next);
    } else {
      for (operator = operators; operator->type != OPERATOR_TYPE_NONE; operator++) {
 if (operator->word && !strncmp(operator->word, p, strlen(operator->word)))
   break;
      }
      if (operator->type == OPERATOR_TYPE_NONE) {
 r = NLL_ERRCODE_FORMULA_INVALID_OPERATOR;
 goto ret;
      }
      p += strlen(operator->word);
      if ((operator->type == OPERATOR_TYPE_BRACKET) ||
   (operator->type == OPERATOR_TYPE_RBRACKET)) {
 if ((r = lex(&element, p, &p, operator->term)) < 0)
   goto ret;
 if (*p) p++;
 param.elements.head = element;
 param.elements.op = operator;
 if ((r = element_push(tail, ELEMENT_TYPE_ELEMENTS,
         (operator->type == OPERATOR_TYPE_RBRACKET) ? (1 << 1) : 0,
         ((void *)0), &param)) < 0)
   goto ret;
      } else {
 param.operator.op = operator;
 param.operator.args[0] = ((void *)0);
 param.operator.args[1] = ((void *)0);
 if ((r = element_push(tail, ELEMENT_TYPE_OPERATOR, 0, ((void *)0), &param)) < 0)
   goto ret;
      }
      tail = &((*tail)->next);
      if (operator->type == OPERATOR_TYPE_ARRAY) {
 if ((r = lex(&element, p, &p, operator->term)) < 0)
   goto ret;
 if (*p) p++;
 param.elements.head = element;
 param.elements.op = operator;
 if ((r = element_push(tail, ELEMENT_TYPE_ELEMENTS, 0, ((void *)0), &param)) < 0)
   goto ret;
 tail = &((*tail)->next);
      }
    }
  }

  r = 0;

ret:
  if (r < 0)
    formula_free(&head);

  *elementp = head;
  if (endp)
    *endp = p;

  return r;
}

static int parse(element_t *elementp)
{
  int r, priority, i;
  unsigned int d;
  element_t e, el, er, *elp;
  operator_type_t opetype;
  variable_t variable;
  operator_t funcop;

  for (e = *elementp; e; e = e->next) {
    switch (e->type) {
    case ELEMENT_TYPE_ELEMENTS:
      if ((r = parse(&e->param.elements.head)) < 0)
 return r;
      if ((r = element_alloc_value(e)) < 0)
 return r;
      break;

    case ELEMENT_TYPE_SYMBOL:
      if ((r = variable_get(e->param.name.name, &variable)) < 0)
 return r;
      e->type = ELEMENT_TYPE_VARIABLE;
      e->param.variable.variable = variable;
      if ((r = element_alloc_value(e)) < 0)
 return r;
      break;

    default:
      break;
    }
  }

  el = ((void *)0);
  for (e = *elementp; e; el = e, e = e->next) {
    er = e->next;

    if ((e->type != ELEMENT_TYPE_OPERATOR) ||
 (e->param.operator.op->type != OPERATOR_TYPE_COMMA))
      continue;

    if (!el ||
 ((el->type == ELEMENT_TYPE_OPERATOR) &&
  (el->param.operator.op->type == OPERATOR_TYPE_COMMA))) {
      elp = el ? &(el->next) : elementp;
      if ((r = element_alloc(&el)) < 0)
 return r;
      el->type = ELEMENT_TYPE_OPERATOR;
      el->param.operator.op = operator_get(OPERATOR_TYPE_NOP);

      el->next = e;
      *elp = el;
    }

    if (!er ||
 ((er->type == ELEMENT_TYPE_OPERATOR) &&
  (er->param.operator.op->type == OPERATOR_TYPE_COMMA))) {
      el = e;
      if ((r = element_alloc(&e)) < 0)
 return r;
      e->type = ELEMENT_TYPE_OPERATOR;
      e->param.operator.op = operator_get(OPERATOR_TYPE_NOP);

      e->next = er;
      el->next = e;
    }
  }

  funcop = operator_get(OPERATOR_TYPE_FUNCTION);

  for (i = 0; i < (13 - 0 + 1); i++) {
    priority = 0 + i;

    for (d = (1 << 0); d != 0;
  d = (d == (1 << 0)) ? (1 << 1) : 0) {

      e = *elementp;
      *elementp = ((void *)0);
      for (; e; e = er) {
 er = e->next;
 e->next = *elementp;
 *elementp = e;
      }

      el = ((void *)0);
      elp = ((void *)0);
      for (e = *elementp; e; el = e, e = e->next) {
 er = e->next;

 if ((funcop->flags & d) && (funcop->priority == priority)) {
   if (el && el->value && e->value) {
     er = e;
     if ((r = element_alloc(&e)) < 0)
       return r;
     e->type = ELEMENT_TYPE_OPERATOR;
     e->param.operator.op = operator_get(OPERATOR_TYPE_FUNCTION);

     e->next = er;
     el->next = e;
   }
 }

 if (e->type != ELEMENT_TYPE_OPERATOR)
   goto next;
 if (!(e->param.operator.op->flags & d))
   goto next;
 if (e->param.operator.op->priority != priority)
   goto next;

 opetype = e->param.operator.op->type;

 switch (e->param.operator.op->subtype) {
 case OPERATOR_SUBTYPE_MON_BIN:
   if (er && er->value) {
     if (el && el->value) {
       switch (opetype) {
       case OPERATOR_TYPE_PLUS:
       case OPERATOR_TYPE_PUSH:
  e->param.operator.op = operator_get(OPERATOR_TYPE_ADD); break;
       case OPERATOR_TYPE_MINUS:
       case OPERATOR_TYPE_POP:
  e->param.operator.op = operator_get(OPERATOR_TYPE_SUB); break;
       case OPERATOR_TYPE_POINTER:
  e->param.operator.op = operator_get(OPERATOR_TYPE_MUL); break;
       case OPERATOR_TYPE_ADDRESS:
  e->param.operator.op = operator_get(OPERATOR_TYPE_AND); break;
       case OPERATOR_TYPE_SIZE:
  e->param.operator.op = operator_get(OPERATOR_TYPE_VECTOR); break;
       case OPERATOR_TYPE_VALUES:
  e->param.operator.op = operator_get(OPERATOR_TYPE_MOD); break;
       case OPERATOR_TYPE_BOOLEAN:
  e->param.operator.op = operator_get(OPERATOR_TYPE_COND); break;
       case OPERATOR_TYPE_NOT:
  e->param.operator.op = operator_get(OPERATOR_TYPE_EXEC); break;
       default:
  return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
       }
       break;
     }
   }


 case OPERATOR_SUBTYPE_MONADIC:
   if (!el || !el->value) {
     switch (opetype) {
     case OPERATOR_TYPE_INC:
       e->param.operator.op = operator_get(OPERATOR_TYPE_INCA); break;
     case OPERATOR_TYPE_DEC:
       e->param.operator.op = operator_get(OPERATOR_TYPE_DECA); break;
     case OPERATOR_TYPE_PLUS:
       e->param.operator.op = operator_get(OPERATOR_TYPE_PUSH); break;
     case OPERATOR_TYPE_MINUS:
       e->param.operator.op = operator_get(OPERATOR_TYPE_POP); break;
     default:
       return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
     }
     break;
   }
   *elp = e;
   el->next = ((void *)0);
   e->param.operator.args[0] = el;
   if ((r = element_alloc_value(e)) < 0)
     return r;
   continue;

 case OPERATOR_SUBTYPE_BINARY:
   if (!el || !er)
     return NLL_ERRCODE_FORMULA_LESS_PARAMETER;
   *elp = e;
   e->next = er->next;
   el->next = ((void *)0);
   er->next = ((void *)0);
   switch (d) {
   case (1 << 0):
     e->param.operator.args[0] = er;
     e->param.operator.args[1] = el;
     break;
   case (1 << 1):
   default:
     e->param.operator.args[0] = el;
     e->param.operator.args[1] = er;
     break;
   }
   if (opetype == OPERATOR_TYPE_FUNCTION)
     e->param.operator.args[1]->flags |= (1 << 1);
   if ((r = element_alloc_value(e)) < 0)
     return r;
   continue;

 case OPERATOR_SUBTYPE_NONE:
   switch (opetype) {
   case OPERATOR_TYPE_NOP:
     if ((r = element_alloc_value(e)) < 0)
       return r;
     break;
   default:
     break;
   }
   goto next;

 default:
   return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
 }

      next:
 elp = elp ? &((*elp)->next) : elementp;
      }
    }
  }

  for (e = *elementp; e && e->next; e = e->next) {
    er = e->next;
    if ((er->type == ELEMENT_TYPE_OPERATOR) &&
 (er->param.operator.op->type == OPERATOR_TYPE_COMMA)) {
      e->next = er->next;
      er->next = ((void *)0);
      element_free(er);
    }
  }

  return 0;
}

static int proc_monadic_integer(const struct operator *op, value_t v, value_t v0)
{
  int r;
  integer_t x;

  if (op->flags & (1 << 2)) {
    if ((r = value_get_integer(v, &x)) < 0)
      return r;
  } else {
    if ((r = value_get_integer(v0, &x)) < 0)
      return r;
  }

  switch (op->type) {
  case OPERATOR_TYPE_INC: x++; break;
  case OPERATOR_TYPE_DEC: x--; break;
  case OPERATOR_TYPE_INCA: break;
  case OPERATOR_TYPE_DECA: break;

  case OPERATOR_TYPE_PLUS: break;
  case OPERATOR_TYPE_MINUS: x = -x; break;
  case OPERATOR_TYPE_INV: x = ~x; break;

  case OPERATOR_TYPE_NOT:
  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_integer(v, x)) < 0)
    return r;

  switch (op->type) {
  case OPERATOR_TYPE_INCA: x++; break;
  case OPERATOR_TYPE_DECA: x--; break;
  default: break;
  }

  if (op->flags & (1 << 2)) {
    if ((r = value_set_integer(v0, x)) < 0)
      return r;
  }

  return 0;
}


static int proc_monadic_float(const struct operator *op, value_t v, value_t v0)
{
  int r;
  double f0;

  if (op->flags & (1 << 2)) {
    if ((r = value_get_float_integer(v, &f0)) < 0)
      return r;
  } else {
    if ((r = value_get_float_integer(v0, &f0)) < 0)
      return r;
  }

  switch (op->type) {
  case OPERATOR_TYPE_INC: f0 = f0 + 1.0; break;
  case OPERATOR_TYPE_DEC: f0 = f0 - 1.0; break;
  case OPERATOR_TYPE_INCA: break;
  case OPERATOR_TYPE_DECA: break;

  case OPERATOR_TYPE_PLUS: break;
  case OPERATOR_TYPE_MINUS: f0 = -f0; break;

  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_float(v, f0)) < 0)
    return r;

  switch (op->type) {
  case OPERATOR_TYPE_INCA: f0 = f0 + 1.0; break;
  case OPERATOR_TYPE_DECA: f0 = f0 - 1.0; break;
  default: break;
  }

  if (op->flags & (1 << 2)) {
    if ((r = value_set_float(v0, f0)) < 0)
      return r;
  }

  return 0;
}


static int proc_monadic_array(const struct operator *op, value_t v, value_t v0)
{
  int r, offset0;
  array_t a0;

  if (op->flags & (1 << 2)) {
    if ((r = value_get_array(v, &a0, &offset0)) < 0)
      return r;
  } else {
    if ((r = value_get_array(v0, &a0, &offset0)) < 0)
      return r;
  }

  switch (op->type) {
  case OPERATOR_TYPE_INC: offset0++; break;
  case OPERATOR_TYPE_DEC: offset0--; break;
  case OPERATOR_TYPE_INCA: break;
  case OPERATOR_TYPE_DECA: break;

  case OPERATOR_TYPE_NOT:
  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_array(v, a0, offset0)) < 0)
    return r;

  switch (op->type) {
  case OPERATOR_TYPE_INCA: offset0++; break;
  case OPERATOR_TYPE_DECA: offset0--; break;
  default: break;
  }

  if (op->flags & (1 << 2)) {
    if ((r = value_set_array(v0, a0, offset0)) < 0)
      return r;
  }

  return 0;
}

static int proc_monadic_pointer(const struct operator *op, value_t v, value_t v0)
{
  int r, offset0;
  value_t p0;

  if (op->flags & (1 << 2)) {
    if ((r = value_get_pointer(v, &p0, &offset0)) < 0)
      return r;
  } else {
    if ((r = value_get_pointer(v0, &p0, &offset0)) < 0)
      return r;
  }

  switch (op->type) {
  case OPERATOR_TYPE_INC: offset0++; break;
  case OPERATOR_TYPE_DEC: offset0--; break;
  case OPERATOR_TYPE_INCA: break;
  case OPERATOR_TYPE_DECA: break;

  case OPERATOR_TYPE_NOT:
  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_pointer(v, p0, offset0)) < 0)
    return r;

  switch (op->type) {
  case OPERATOR_TYPE_INCA: offset0++; break;
  case OPERATOR_TYPE_DECA: offset0--; break;
  default: break;
  }

  if (op->flags & (1 << 2)) {
    if ((r = value_set_pointer(v0, p0, offset0)) < 0)
      return r;
  }

  return 0;
}

static int proc_binary_null(const struct operator *op, value_t v, value_t v0, value_t v1)
{
  int r, null0 = 0, null1 = 0;
  integer_t x;

  if (value_get_type(v0) == VALUE_TYPE_NULL)
    null0 = 1;

  if (op->flags & (1 << 2)) {
    if (value_get_type(v) == VALUE_TYPE_NULL)
      null1 = 1;
  } else {
    if (value_get_type(v1) == VALUE_TYPE_NULL)
      null1 = 1;
  }

  switch (op->type) {
  case OPERATOR_TYPE_EQ: x = (null0 == null1); break;
  case OPERATOR_TYPE_NE: x = (null0 != null1); break;

  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_integer(v, x)) < 0)
    return r;

  return 0;
}

static int proc_binary_integer(const struct operator *op, value_t v, value_t v0, value_t v1)
{
  int r;
  integer_t x, y;

  if ((r = value_get_integer(v0, &x)) < 0)
    return r;

  if (op->flags & (1 << 2)) {
    if ((r = value_get_integer(v, &y)) < 0)
      return r;
  } else {
    if ((r = value_get_integer(v1, &y)) < 0)
      return r;
  }

  switch (op->type) {
  case OPERATOR_TYPE_DIV:
  case OPERATOR_TYPE_MOD:
  case OPERATOR_TYPE_DIVEQ:
  case OPERATOR_TYPE_MODEQ:
    if (y == 0)
      return NLL_ERRCODE_FORMULA_DIV_ZERO;
    break;
  default:
    break;
  }

  switch (op->type) {
  case OPERATOR_TYPE_LSHIFT: x = x << y; break;
  case OPERATOR_TYPE_RSHIFT: x = x >> y; break;
  case OPERATOR_TYPE_LE: x = x <= y; break;
  case OPERATOR_TYPE_GE: x = x >= y; break;
  case OPERATOR_TYPE_EQ: x = x == y; break;
  case OPERATOR_TYPE_NE: x = x != y; break;
  case OPERATOR_TYPE_MUL: x = x * y; break;
  case OPERATOR_TYPE_DIV: x = x / y; break;
  case OPERATOR_TYPE_MOD: x = x % y; break;
  case OPERATOR_TYPE_ADD: x = x + y; break;
  case OPERATOR_TYPE_SUB: x = x - y; break;
  case OPERATOR_TYPE_LT: x = x < y; break;
  case OPERATOR_TYPE_GT: x = x > y; break;
  case OPERATOR_TYPE_XOR: x = x ^ y; break;
  case OPERATOR_TYPE_AND: x = x & y; break;
  case OPERATOR_TYPE_OR: x = x | y; break;

  case OPERATOR_TYPE_LSHIFTEQ: x <<= y; break;
  case OPERATOR_TYPE_RSHIFTEQ: x >>= y; break;
  case OPERATOR_TYPE_ADDEQ: x += y; break;
  case OPERATOR_TYPE_SUBEQ: x -= y; break;
  case OPERATOR_TYPE_MULEQ: x *= y; break;
  case OPERATOR_TYPE_DIVEQ: x /= y; break;
  case OPERATOR_TYPE_MODEQ: x %= y; break;
  case OPERATOR_TYPE_ANDEQ: x &= y; break;
  case OPERATOR_TYPE_XOREQ: x ^= y; break;
  case OPERATOR_TYPE_OREQ: x |= y; break;

  case OPERATOR_TYPE_LOGAND: x = x && y; break;
  case OPERATOR_TYPE_LOGOR: x = x || y; break;
  case OPERATOR_TYPE_LOGCAND: x = x && y; break;
  case OPERATOR_TYPE_LOGCOR: x = x || y; break;

  case OPERATOR_TYPE_SUBST:
  case OPERATOR_TYPE_STATIC:
  case OPERATOR_TYPE_REFER:
  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_integer(v, x)) < 0)
    return r;

  if (op->flags & (1 << 2)) {
    if ((r = value_set_integer(v0, x)) < 0)
      return r;
  }

  return 0;
}

static int string_cmp(const char *s0, int length0,
        const char *s1, int length1)
{
  const unsigned char *p0, *p1;
  int i;

  if (!s0 || !s1) {
    if (!s0 && s1) return -1;
    if ( s0 && !s1) return 1;
    return 0;
  }

  p0 = (const unsigned char *)s0;
  p1 = (const unsigned char *)s1;

  for (i = 0; ((i < length0) && (i < length1)); i++) {
    if (p0[i] < p1[i]) return -1;
    if (p0[i] > p1[i]) return 1;
  }

  if (length0 < length1) return -1;
  if (length0 > length1) return 1;

  return 0;
}

static int proc_binary_string(const struct operator *op, value_t v, value_t v0, value_t v1)
{
  int r, length0, length1;
  integer_t x;
  char *s0, *s1;
  char *word;

  if ((r = value_get_string(v0, &s0, &length0)) < 0)
    return r;

  if (op->flags & (1 << 2)) {
    if ((r = value_get_string(v, &s1, &length1)) < 0)
      return r;
  } else {
    if ((r = value_get_string(v1, &s1, &length1)) < 0)
      return r;
  }

  word = string_buffer();

  switch (op->type) {
  case OPERATOR_TYPE_ADD:
  case OPERATOR_TYPE_ADDEQ:
    if (!s0) {
      s0 = "";
      length0 = 0;
    }
    if (!s1) {
      s1 = "";
      length1 = 0;
    }
    if (length0 + length1 + 1 > string_buffer_size())
      return NLL_ERRCODE_STRING_TOO_LONG;
    memcpy(word, s0, length0);
    memcpy(word + length0, s1, length1);
    word[length0 + length1] = '\0';
    if ((r = value_set_string(v, word, length0 + length1)) < 0)
      return r;
    if (op->flags & (1 << 2)) {
      if ((r = value_set_string(v0, word, length0 + length1)) < 0)
 return r;
    }
    return 0;

  case OPERATOR_TYPE_LT: x = (string_cmp(s0, length0, s1, length1) < 0) ? 1 : 0; break;
  case OPERATOR_TYPE_GT: x = (string_cmp(s0, length0, s1, length1) > 0) ? 1 : 0; break;
  case OPERATOR_TYPE_LE: x = (string_cmp(s0, length0, s1, length1) <= 0) ? 1 : 0; break;
  case OPERATOR_TYPE_GE: x = (string_cmp(s0, length0, s1, length1) >= 0) ? 1 : 0; break;
  case OPERATOR_TYPE_EQ: x = (string_cmp(s0, length0, s1, length1) == 0) ? 1 : 0; break;
  case OPERATOR_TYPE_NE: x = (string_cmp(s0, length0, s1, length1) != 0) ? 1 : 0; break;

  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_integer(v, x)) < 0)
    return r;

  return 0;
}


static int proc_binary_float(const struct operator *op, value_t v, value_t v0, value_t v1)
{
  int r;
  integer_t x;
  double f0, f1;

  if ((r = value_get_float_integer(v0, &f0)) < 0)
    return r;

  if (op->flags & (1 << 2)) {
    if ((r = value_get_float_integer(v, &f1)) < 0)
      return r;
  } else {
    if ((r = value_get_float_integer(v1, &f1)) < 0)
      return r;
  }

  switch (op->type) {
  case OPERATOR_TYPE_DIV:
  case OPERATOR_TYPE_MOD:
  case OPERATOR_TYPE_DIVEQ:
  case OPERATOR_TYPE_MODEQ:
    if (f1 == 0)
      return NLL_ERRCODE_FORMULA_DIV_ZERO;
    break;
  default:
    break;
  }

  switch (op->type) {
  case OPERATOR_TYPE_LT: x = (f0 < f1) ? 1 : 0; goto set_integer;
  case OPERATOR_TYPE_GT: x = (f0 > f1) ? 1 : 0; goto set_integer;
  case OPERATOR_TYPE_LE: x = (f0 <= f1) ? 1 : 0; goto set_integer;
  case OPERATOR_TYPE_GE: x = (f0 >= f1) ? 1 : 0; goto set_integer;
  case OPERATOR_TYPE_EQ: x = (f0 == f1) ? 1 : 0; goto set_integer;
  case OPERATOR_TYPE_NE: x = (f0 != f1) ? 1 : 0; goto set_integer;
  set_integer:
    if ((r = value_set_integer(v, x)) < 0)
      return r;
    return 0;

  case OPERATOR_TYPE_MUL: f0 = f0 * f1; break;
  case OPERATOR_TYPE_DIV: f0 = f0 / f1; break;
  case OPERATOR_TYPE_ADD: f0 = f0 + f1; break;
  case OPERATOR_TYPE_SUB: f0 = f0 - f1; break;

  case OPERATOR_TYPE_MULEQ: f0 *= f1; break;
  case OPERATOR_TYPE_DIVEQ: f0 /= f1; break;
  case OPERATOR_TYPE_ADDEQ: f0 += f1; break;
  case OPERATOR_TYPE_SUBEQ: f0 -= f1; break;

  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_float(v, f0)) < 0)
    return r;

  if (op->flags & (1 << 2)) {
    if ((r = value_set_float(v0, f0)) < 0)
      return r;
  }

  return 0;
}


static int proc_binary_area(const struct operator *op, value_t v, value_t v0, value_t v1)
{
  int r;
  integer_t x;
  area_t a0, a1;

  if ((r = value_get_area(v0, &a0)) < 0)
    return r;

  if (op->flags & (1 << 2)) {
    if ((r = value_get_area(v, &a1)) < 0)
      return r;
  } else {
    if ((r = value_get_area(v1, &a1)) < 0)
      return r;
  }

  switch (op->type) {
  case OPERATOR_TYPE_EQ: x = (a0 == a1); break;
  case OPERATOR_TYPE_NE: x = (a0 != a1); break;

  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_integer(v, x)) < 0)
    return r;

  return 0;
}

static int proc_binary_array(const struct operator *op, value_t v, value_t v0, value_t v1)
{
  int r, offset0, offset1, is_int0 = 0, is_int1 = 0;
  integer_t x, integer0, integer1;
  array_t a0 = ((void *)0), a1 = ((void *)0);

  if ((r = value_get_array(v0, &a0, &offset0)) < 0) {
    if ((r = value_get_integer(v0, &integer0)) < 0)
      return r;
    is_int0 = 1;
  }

  if (op->flags & (1 << 2)) {
    if ((r = value_get_array(v, &a1, &offset1)) < 0) {
      if ((r = value_get_integer(v, &integer1)) < 0)
 return r;
      is_int1 = 1;
    }
  } else {
    if ((r = value_get_array(v1, &a1, &offset1)) < 0) {
      if ((r = value_get_integer(v1, &integer1)) < 0)
 return r;
      is_int1 = 1;
    }
  }

  switch (op->type) {
  case OPERATOR_TYPE_ADD:
  case OPERATOR_TYPE_ADDEQ:
    if (a0 && is_int1) {
      offset1 = integer1;
    } else if (a1 && is_int0) {
      a0 = a1;
      offset0 = integer0;
    } else {
      return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;
    }
    if (op->flags & (1 << 2)) {
      if ((r = value_clear(v)) < 0)
 return r;
    }
    if ((r = value_set_array(v, a0, offset0 + offset1)) < 0)
      return r;
    if (op->flags & (1 << 2)) {
      if ((r = value_set_array(v0, a0, offset0 + offset1)) < 0)
 return r;
    }
    return 0;

  case OPERATOR_TYPE_SUB:
  case OPERATOR_TYPE_SUBEQ:
    if (a0 && a1) {
      if (a0 != a1)
 return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;
      if ((r = value_set_integer(v, offset0 - offset1)) < 0)
 return r;
      return 0;
    } else if (a0 && is_int1) {
      offset1 = integer1;
    } else {
      return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;
    }
    if (op->flags & (1 << 2)) {
      if ((r = value_clear(v)) < 0)
 return r;
    }
    if ((r = value_set_array(v, a0, offset0 - offset1)) < 0)
      return r;
    if (op->flags & (1 << 2)) {
      if ((r = value_set_array(v0, a0, offset0 - offset1)) < 0)
 return r;
    }
    return 0;

  default:
    break;
  }

  if (is_int0 || is_int1)
    return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;

  switch (op->type) {
  case OPERATOR_TYPE_LT: x = (a0 == a1) && (offset0 < offset1); break;
  case OPERATOR_TYPE_GT: x = (a0 == a1) && (offset0 > offset1); break;
  case OPERATOR_TYPE_LE: x = (a0 == a1) && (offset0 <= offset1); break;
  case OPERATOR_TYPE_GE: x = (a0 == a1) && (offset0 >= offset1); break;
  case OPERATOR_TYPE_EQ: x = (a0 == a1) && (offset0 == offset1); break;
  case OPERATOR_TYPE_NE: x = (a0 != a1) || (offset0 != offset1); break;

  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_integer(v, x)) < 0)
    return r;

  return 0;
}

static int proc_binary_pointer(const struct operator *op, value_t v, value_t v0, value_t v1)
{
  int r, offset0, offset1, is_int0 = 0, is_int1 = 0;
  integer_t x, integer0, integer1;
  value_t p0 = ((void *)0), p1 = ((void *)0);

  if ((r = value_get_pointer(v0, &p0, &offset0)) < 0) {
    if ((r = value_get_integer(v0, &integer0)) < 0)
      return r;
    is_int0 = 1;
  }

  if (op->flags & (1 << 2)) {
    if ((r = value_get_pointer(v, &p1, &offset1)) < 0) {
      if ((r = value_get_integer(v, &integer1)) < 0)
 return r;
      is_int1 = 1;
    }
  } else {
    if ((r = value_get_pointer(v1, &p1, &offset1)) < 0) {
      if ((r = value_get_integer(v1, &integer1)) < 0)
 return r;
      is_int1 = 1;
    }
  }

  switch (op->type) {
  case OPERATOR_TYPE_ADD:
  case OPERATOR_TYPE_ADDEQ:
    if (p0 && is_int1) {
      offset1 = integer1;
    } else if (p1 && is_int0) {
      p0 = p1;
      offset0 = integer0;
    } else {
      return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;
    }
    if (op->flags & (1 << 2)) {
      if ((r = value_clear(v)) < 0)
 return r;
    }
    if ((r = value_set_pointer(v, p0, offset0 + offset1)) < 0)
      return r;
    if (op->flags & (1 << 2)) {
      if ((r = value_set_pointer(v0, p0, offset0 + offset1)) < 0)
 return r;
    }
    return 0;

  case OPERATOR_TYPE_SUB:
  case OPERATOR_TYPE_SUBEQ:
    if (p0 && p1) {




      if ((r = value_set_integer(v, offset0 - offset1)) < 0)
 return r;
      return 0;
    } else if (p0 && is_int1) {
      offset1 = integer1;
    } else {
      return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;
    }
    if (op->flags & (1 << 2)) {
      if ((r = value_clear(v)) < 0)
 return r;
    }
    if ((r = value_set_pointer(v, p0, offset0 - offset1)) < 0)
      return r;
    if (op->flags & (1 << 2)) {
      if ((r = value_set_pointer(v0, p0, offset0 - offset1)) < 0)
 return r;
    }
    return 0;

  default:
    break;
  }

  if (is_int0 || is_int1)
    return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;

  switch (op->type) {
  case OPERATOR_TYPE_LT: x = (p0 == p1) && (offset0 < offset1); break;
  case OPERATOR_TYPE_GT: x = (p0 == p1) && (offset0 > offset1); break;
  case OPERATOR_TYPE_LE: x = (p0 == p1) && (offset0 <= offset1); break;
  case OPERATOR_TYPE_GE: x = (p0 == p1) && (offset0 >= offset1); break;
  case OPERATOR_TYPE_EQ: x = (p0 == p1) && (offset0 == offset1); break;
  case OPERATOR_TYPE_NE: x = (p0 != p1) || (offset0 != offset1); break;

  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_integer(v, x)) < 0)
    return r;

  return 0;
}

static int proc_binary_logical(const struct operator *op, value_t v, value_t v0, value_t v1)
{
  int r, x;

  switch (op->type) {
  case OPERATOR_TYPE_LOGAND:
    if ((r = value_is_true(v0)) < 0)
      return r;
    x = r;
    if ((r = value_is_true(v1)) < 0)
      return r;
    x = x && r;
    break;

  case OPERATOR_TYPE_LOGOR:
    if ((r = value_is_true(v0)) < 0)
      return r;
    x = r;
    if ((r = value_is_true(v1)) < 0)
      return r;
    x = x || r;
    break;

  case OPERATOR_TYPE_LOGCAND:
    if ((r = value_is_true(v0)) < 0)
      return r;
    x = r;
    if (r) {
      if ((r = value_is_true(v1)) < 0)
 return r;
      x = x && r;
    }
    break;

  case OPERATOR_TYPE_LOGCOR:
    if ((r = value_is_true(v0)) < 0)
      return r;
    x = r;
    if (!r) {
      if ((r = value_is_true(v1)) < 0)
 return r;
      x = x || r;
    }
    break;

  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_integer(v, x)) < 0)
    return r;

  return 0;
}

static int proc_binary_function(const struct operator *op, value_t v, value_t v0, value_t v1)
{
  int r;
  integer_t x;
  function_t f0, f1;

  if ((r = value_get_function(v0, &f0)) < 0)
    return r;

  if (op->flags & (1 << 2)) {
    if ((r = value_get_function(v, &f1)) < 0)
      return r;
  } else {
    if ((r = value_get_function(v1, &f1)) < 0)
      return r;
  }

  switch (op->type) {
  case OPERATOR_TYPE_EQ: x = (f0 == f1); break;
  case OPERATOR_TYPE_NE: x = (f0 != f1); break;

  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_integer(v, x)) < 0)
    return r;

  return 0;
}

static int proc_binary_label(const struct operator *op, value_t v, value_t v0, value_t v1)
{
  int r;
  integer_t x;
  label_t label0, label1;

  if ((r = value_get_label(v0, &label0)) < 0)
    return r;

  if (op->flags & (1 << 2)) {
    if ((r = value_get_label(v, &label1)) < 0)
      return r;
  } else {
    if ((r = value_get_label(v1, &label1)) < 0)
      return r;
  }

  switch (op->type) {
  case OPERATOR_TYPE_EQ: x = (label0 == label1); break;
  case OPERATOR_TYPE_NE: x = (label0 != label1); break;

  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if ((r = value_set_integer(v, x)) < 0)
    return r;

  return 0;
}

static int proc_monadic(const struct operator *op, value_t *vp, value_t *v0p)
{
  int r, offset, n;
  value_type_t t0;
  value_t p;
  value_t v, v0;
  array_t array;

  if (op->flags & (1 << 2)) {





    if ((r = value_copy_values(vp, *v0p)) < 0)
      return r;
  }

  for (; *v0p; vp = &(*vp)->next, v0p = &(*v0p)->next) {
    if ((r = value_extend_value(vp)) < 0)
      return r;

    switch (op->type) {
    case OPERATOR_TYPE_PUSH:
      if ((r = stack_push(*v0p)) < 0)
 return r;
      if ((r = value_set_value(*vp, *v0p)) < 0)
 return r;
      continue;

    case OPERATOR_TYPE_POP:

      if ((r = stack_pop(*v0p)) < 0)
 return r;
      continue;

    case OPERATOR_TYPE_ADDRESS:
      if ((r = value_set_pointer(*vp, value_entity(*v0p), 0)) < 0)
 return r;
      continue;

    case OPERATOR_TYPE_SIZE:
      if ((r = value_size(*v0p)) < 0)
 return r;
      if ((r = value_set_integer(*vp, r)) < 0)
 return r;
      continue;

    case OPERATOR_TYPE_BOOLEAN:
      if ((r = value_is_true(*v0p)) < 0)
 return r;
      if ((r = value_set_integer(*vp, r)) < 0)
 return r;
      continue;

    default:
      break;
    }

    t0 = value_get_type(*v0p);

    if (t0 == VALUE_TYPE_VECTOR) {
      if (value_get_type(*vp) != VALUE_TYPE_VECTOR) {
 if ((r = value_set_vector(*vp, ((void *)0))) < 0)
   return r;
      }
      v = value_entity(*vp);
      v0 = value_entity(*v0p);
      if ((r = proc_monadic(op, &v->val.value, &v0->val.value)) < 0)
 return r;
      continue;
    }

    switch (op->type) {
    case OPERATOR_TYPE_NOT:
      if ((r = value_is_true(*v0p)) < 0)
 return r;
      if ((r = value_set_integer(*vp, !r)) < 0)
 return r;
      continue;

    case OPERATOR_TYPE_POINTER:
      if ((r = value_get_pointer(*v0p, &p, &offset)) < 0)
 return r;
      if (!p)
 return NLL_ERRCODE_FORMULA_NULL_POINTER;
      switch (value_get_type(p)) {
      case VALUE_TYPE_ARRAY:
 if ((r = value_get_array(p, &array, &n)) < 0)
   return r;

 if ((r = value_clear(*vp)) < 0)
   return r;
 if ((r = value_set_array(*vp, array, n + offset)) < 0)
   return r;
 continue;
# 1887 "formula.c"
      default:
 if (offset != 0)
   return NLL_ERRCODE_FORMULA_INVALID_POINTER;
 break;
      }
      if ((r = value_set_value(*vp, p)) < 0)
 return r;
      continue;

    default:
      break;
    }


    if (t0 == VALUE_TYPE_FLOAT) {
      if ((r = proc_monadic_float(op, *vp, *v0p)) < 0)
 return r;
      continue;
    }


    if (t0 == VALUE_TYPE_ARRAY) {
      if ((r = proc_monadic_array(op, *vp, *v0p)) < 0)
 return r;
      continue;
    }

    if (t0 == VALUE_TYPE_POINTER) {
      if ((r = proc_monadic_pointer(op, *vp, *v0p)) < 0)
 return r;
      continue;
    }

    if (t0 == VALUE_TYPE_INTEGER) {
      if ((r = proc_monadic_integer(op, *vp, *v0p)) < 0)
 return r;
      continue;
    }

    return NLL_ERRCODE_VALUE_INVALID_TYPE;
  }

  return 0;
}

static int proc_binary(const struct operator *op, value_t *vp, value_t *v0p, value_t *v1p)
{
  int r, x;
  value_type_t t0, t1;
  value_t v, v0, v1;

  if (op->flags & (1 << 2)) {





    if ((r = value_copy_values(vp, *v1p)) < 0)
      return r;
  }

  for (; *v0p && *v1p; vp = &(*vp)->next, v0p = &(*v0p)->next, v1p = &(*v1p)->next) {
    if ((r = value_extend_value(vp)) < 0)
      return r;

    switch (op->type) {
    case OPERATOR_TYPE_STATIC:

      if ((r = value_copy_values(v0p, *vp)) < 0)
 return r;
      if ((r = value_set_flags(*v0p, (1 << 2))) < 0)
 return r;
      continue;

    case OPERATOR_TYPE_REFER:
      v0 = value_entity(*v0p);
      for (v = *v1p; v; v = v->val.value) {
 if (v == v0)
   return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;
 if (v->type != VALUE_TYPE_VALUE)
   break;
      }
      if ((r = value_set_value(v0, *v1p)) < 0)
 return r;
      if ((r = value_set_value(*vp, *v0p)) < 0)
 return r;
      continue;

    case OPERATOR_TYPE_SUBST:

      if ((r = value_copy_value(*v0p, *vp)) < 0)
 return r;
      continue;

    case OPERATOR_TYPE_VEQ:
      if ((r = value_cmp_value(*v0p, *v1p)) < 0)
 return r;
      x = !r;
      if ((r = value_set_integer(*vp, x)) < 0)
 return r;
      continue;

    case OPERATOR_TYPE_VNE:
      if ((r = value_cmp_value(*v0p, *v1p)) < 0)
 return r;
      x = r;
      if ((r = value_set_integer(*vp, x)) < 0)
 return r;
      continue;
# 2007 "formula.c"
    case OPERATOR_TYPE_EXEC:
      if ((r = value_is_true(*v0p)) < 0)
 return r;
      if (!r) {
 if ((r = value_copy_value(*vp, *v0p)) < 0)
   return r;
      } else {
 if ((r = value_copy_value(*vp, *v1p)) < 0)
   return r;
      }
      continue;

    default:
      break;
    }

    t0 = value_get_type(*v0p);
    t1 = value_get_type(*v1p);

    if (t1 == VALUE_TYPE_VECTOR) {
      if (value_get_type(*vp) != VALUE_TYPE_VECTOR) {
 if ((r = value_set_vector(*vp, ((void *)0))) < 0)
   return r;
      }
      if (value_get_type(*v0p) != VALUE_TYPE_VECTOR)
 return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;
      v = value_entity(*vp);
      v0 = value_entity(*v0p);
      v1 = value_entity(*v1p);
      if ((r = proc_binary(op, &v->val.value, &v0->val.value, &v1->val.value)) < 0)
 return r;
      continue;
    }

    switch (op->type) {
    case OPERATOR_TYPE_LOGAND:
    case OPERATOR_TYPE_LOGOR:
    case OPERATOR_TYPE_LOGCAND:
    case OPERATOR_TYPE_LOGCOR:
      if ((r = proc_binary_logical(op, *vp, *v0p, *v1p)) < 0)
 return r;
      continue;

    default:
      break;
    }

    if ((t0 == VALUE_TYPE_NULL) || (t1 == VALUE_TYPE_NULL)) {
      if ((r = proc_binary_null(op, *vp, *v0p, *v1p)) < 0)
 return r;
      continue;
    }

    if ((t0 == VALUE_TYPE_STRING) || (t1 == VALUE_TYPE_STRING)) {
      if ((r = proc_binary_string(op, *vp, *v0p, *v1p)) < 0)
 return r;
      continue;
    }



    if ((t0 == VALUE_TYPE_FLOAT) || (t1 == VALUE_TYPE_FLOAT)) {
      if ((r = proc_binary_float(op, *vp, *v0p, *v1p)) < 0)
 return r;
      continue;
    }



    if ((t0 == VALUE_TYPE_ARRAY) || (t1 == VALUE_TYPE_ARRAY)) {
      if ((r = proc_binary_array(op, *vp, *v0p, *v1p)) < 0)
 return r;
      continue;
    }


    if ((t0 == VALUE_TYPE_POINTER) || (t1 == VALUE_TYPE_POINTER)) {
      if ((r = proc_binary_pointer(op, *vp, *v0p, *v1p)) < 0)
 return r;
      continue;
    }

    if ((t0 == VALUE_TYPE_INTEGER) || (t1 == VALUE_TYPE_INTEGER)) {
      if ((r = proc_binary_integer(op, *vp, *v0p, *v1p)) < 0)
 return r;
      continue;
    }

    if ((t0 == VALUE_TYPE_AREA) || (t1 == VALUE_TYPE_AREA)) {
      if ((r = proc_binary_area(op, *vp, *v0p, *v1p)) < 0)
 return r;
      continue;
    }

    if ((t0 == VALUE_TYPE_FUNCTION) || (t1 == VALUE_TYPE_FUNCTION)) {
      if ((r = proc_binary_function(op, *vp, *v0p, *v1p)) < 0)
 return r;
      continue;
    }

    if ((t0 == VALUE_TYPE_LABEL) || (t1 == VALUE_TYPE_LABEL)) {
      if ((r = proc_binary_label(op, *vp, *v0p, *v1p)) < 0)
 return r;
      continue;
    }

    return NLL_ERRCODE_VALUE_INVALID_TYPE;
  }

  return 0;
}

static int label_proc(label_t label, value_t value, value_t args)
{
  int r;
  struct spot s;

  if (!label->spot.line)
    return NLL_ERRCODE_LABEL_NOT_FOUND;

  s.line = label->spot.line;
  s.command = label->spot.command;


  if ((r = stack_push_type(STACK_TYPE_CALL, ((void *)0))) < 0)
    return r;

  if (s.command->label.args) {
    if ((r = stack_push_type(STACK_TYPE_CALL, args)) < 0)
      return r;
  }


  if ((r = nll_exec(&s, ((void *)0), POSITION_TYPE_LABEL, ((void *)0), ((void *)0))) < 0)
    return r;


  if ((r = stack_pop_type(STACK_TYPE_CALL, value)) < 0)
    return r;

  return 0;
}

static int element_set_values(element_t element, value_t value)
{
  int r;
  value_t *valuep;

  if (value_get_type(value) == VALUE_TYPE_VECTOR) {
    if ((r = value_get_vector(value, &value)) < 0)
      return r;
  }

  valuep = &element->value;
  for (; value; value = value->next) {
    if (!*valuep) {
      if ((r = value_alloc(valuep)) < 0)
 return r;
    }
    if ((r = value_set_value(*valuep, value)) < 0)
      return r;
    valuep = &(*valuep)->next;
  }

  if ((r = value_shrink_value(valuep)) < 0)
    return r;

  return 0;
}

static int element_set_vector(element_t element)
{
  int r;
  element_t e;
  value_t value, *valuep;





  if ((r = value_clear(element->value)) < 0)
    return r;
  if ((r = value_set_vector(element->value, ((void *)0))) < 0)
    return r;

  valuep = &element->value->val.value;
  for (e = element->param.elements.head; e; e = e->next) {
    for (value = e->value; value; value = value->next) {
      if (!*valuep) {
 if ((r = value_alloc(valuep)) < 0)
   return r;
      }
      if ((r = value_set_value(*valuep, value)) < 0)
 return r;
      valuep = &(*valuep)->next;
    }
  }

  if (!(element->flags & (1 << 1))) {
    if (element->value->val.value && !element->value->val.value->next) {
      if ((r = value_vector_to_value(element->value)) < 0)
 return r;
    }
  }

  return 0;
}

static int element_set_fixed(element_t element)
{
  element_t e;

  for (e = element->param.elements.head; e; e = e->next) {
    if (!(e->flags & (1 << 0)))
      return 0;
  }

  element->flags |= (1 << 0);

  return 1;
}

static int proc_element(element_t element);
static int proc(element_t element, value_t *valuep);

static int proc_logical(const struct operator *op, element_t e0, element_t e1)
{
  int r;

  for (; e0 && e1; e0 = e0->next, e1 = e1->next) {
    switch (op->type) {
    case OPERATOR_TYPE_EXEC:
      if ((r = value_is_true(e0->value)) < 0)
 return r;
      if (r) {
 if ((r = proc_element(e1)) < 0)
   return r;
      }
      continue;

    default:
      break;
    }


    if ((e0->type == ELEMENT_TYPE_ELEMENTS) &&
 (e1->type == ELEMENT_TYPE_ELEMENTS)) {
      if ((r = element_set_vector(e1)) < 0)
 return r;
      if ((r = element_set_fixed(e1)) < 0)
 return r;
      if ((r = proc_logical(op,
       e0->param.elements.head,
       e1->param.elements.head)) < 0)
 return r;
      continue;
    }


    switch (op->type) {
    case OPERATOR_TYPE_LOGCAND:
      if ((r = value_is_true(e0->value)) < 0)
 return r;
      if (r) {
 if ((r = proc_element(e1)) < 0)
   return r;
      }
      break;

    case OPERATOR_TYPE_LOGCOR:
      if ((r = value_is_true(e0->value)) < 0)
 return r;
      if (!r) {
 if ((r = proc_element(e1)) < 0)
   return r;
      }
      break;

    default:
      return NLL_ERRCODE_FORMULA_INVALID_OPERATOR;
    }
  }

  return 0;
}

static int proc_at(const struct operator *op, element_t element, int num)
{
  int r, n;
  element_t e;

  e = element->param.operator.args[1];
  if ((e->type != ELEMENT_TYPE_ELEMENTS) || (e->flags & (1 << 1))) {

    if ((r = proc(e, ((void *)0))) < 0)
      return r;
  } else {
    if ((r = element_set_vector(e)) < 0)
      return r;
    e = e->param.elements.head;
    for (n = 0; e && (n < num); n++)
      e = e->next;
    if (e) {
      if ((r = proc_element(e)) < 0)
 return r;
    }
  }

  return 0;
}

static int proc_element(element_t element)
{
  int r, n;
  const struct operator *op;
  integer_t integer;
  array_t array;
  value_t value, v, args;
  function_t function;
  label_t label;


  if (element->flags & (1 << 0)) {
    if (!nll_is_nofixed())
      return 0;
  }


  switch (element->type) {
  case ELEMENT_TYPE_ELEMENTS:
    if ((r = proc(element->param.elements.head, ((void *)0))) < 0)
      return r;
    if ((r = element_set_vector(element)) < 0)
      return r;
    if ((r = element_set_fixed(element)) < 0)
      return r;
    break;
  case ELEMENT_TYPE_VARIABLE:
    if ((r = value_set_value(element->value, element->param.variable.variable->value)) < 0)
      return r;
    if (element->param.variable.variable->value->flags & ((1 << 0)|(1 << 1)))
      element->flags |= (1 << 0);
    break;
  case ELEMENT_TYPE_INTEGER:
  case ELEMENT_TYPE_STRING:

  case ELEMENT_TYPE_FLOAT:

    if (element->value->flags & ((1 << 0)|(1 << 1)))
      element->flags |= (1 << 0);
    break;
  default:
    break;
  }

  if (element->type != ELEMENT_TYPE_OPERATOR)
    return 0;

  op = element->param.operator.op;

  switch (op->subtype) {
  case OPERATOR_SUBTYPE_MON_BIN:
  case OPERATOR_SUBTYPE_MONADIC:
    if (!element->param.operator.args[0])
      return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

    if ((r = proc(element->param.operator.args[0], ((void *)0))) < 0)
      return r;

    if (op->type == OPERATOR_TYPE_VALUES) {
      if (element->value) {
 if ((r = value_clear(element->value)) < 0)
   return r;
      }
      if ((r = element_set_values(element, element->param.operator.args[0]->value)) < 0)
 return r;
      break;
    }

    if ((r = proc_monadic(op, &element->value,
     &element->param.operator.args[0]->value)) < 0)
      return r;

    break;

  case OPERATOR_SUBTYPE_BINARY:
    if (!element->param.operator.args[0] ||
 !element->param.operator.args[1])
      return NLL_ERRCODE_FORMULA_LESS_PARAMETER;

    if ((r = proc(element->param.operator.args[0], ((void *)0))) < 0)
      return r;

    if ((op->type == OPERATOR_TYPE_COND) || (op->type == OPERATOR_TYPE_AT)) {
      value = element->param.operator.args[0]->value;
      switch (op->type) {
      case OPERATOR_TYPE_COND:
 if ((r = value_is_true(value)) < 0)
   return r;
 integer = r ? 0 : 1;
 break;
      case OPERATOR_TYPE_AT:
 if ((r = value_get_integer(value, &integer)) < 0)
   return r;
 break;
      default:
 return NLL_ERRCODE_FORMULA_INVALID_OPERATOR;
      }

      value = element->param.operator.args[1]->value;

      if (integer < 0)
 return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;
      if ((r = proc_at(op, element, integer)) < 0)
 return r;

      if (value_get_type(value) == VALUE_TYPE_VECTOR) {
 if ((r = value_get_vector(value, &value)) < 0)
   return r;
      }
      for (n = 0; value && (n < integer); n++)
 value = value->next;
      if (!value) {

 if ((r = value_clear(element->value)) < 0)
   return r;
 if ((r = value_set_null(element->value)) < 0)
   return r;
      } else {
 if ((r = value_set_value(element->value, value)) < 0)
   return r;
      }
      break;
    }

    switch (op->type) {
    case OPERATOR_TYPE_LOGCAND:
    case OPERATOR_TYPE_LOGCOR:
    case OPERATOR_TYPE_EXEC:
      if ((r = proc_logical(op,
       element->param.operator.args[0],
       element->param.operator.args[1])) < 0)
 return r;
      break;

    default:
      if ((r = proc(element->param.operator.args[1], ((void *)0))) < 0)
 return r;
      break;
    }

    if ((op->type == OPERATOR_TYPE_DOT) || (op->type == OPERATOR_TYPE_ARROW)) {
      value = element->param.operator.args[1]->value;
      if ((r = value_get_integer(value, &integer)) < 0)
 return r;

      value = element->param.operator.args[0]->value;
      if (op->type == OPERATOR_TYPE_ARROW) {
 if ((r = value_get_pointer(value, &value, &n)) < 0)
   return r;
 integer += n;
      }

      if (integer < 0)
 return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;

      if (value_get_type(value) == VALUE_TYPE_VECTOR) {
 if ((r = value_get_vector(value, &value)) < 0)
   return r;
      }
      for (n = 0; value && (n < integer); n++)
 value = value->next;
      if (!value)
 return NLL_ERRCODE_FORMULA_INVALID_PARAMETER;
      if ((r = value_set_value(element->value, value)) < 0)
 return r;
      break;
    }

    if (op->type == OPERATOR_TYPE_ARRAY) {
      if ((r = value_get_integer(element->param.operator.args[1]->value, &integer)) < 0)
 return r;
      if ((r = value_get_array(element->param.operator.args[0]->value, &array, &n)) < 0)
 return r;
      if ((r = array_get_value(array, n + integer, &value)) < 0)
 return r;
      if ((r = value_set_value(element->value, value)) < 0)
 return r;
      break;
    }

    if (op->type == OPERATOR_TYPE_VECTOR) {
      if ((r = value_get_integer(element->param.operator.args[1]->value, &integer)) < 0)
 return r;
      value = element->param.operator.args[0]->value;
      n = (integer < 0) ? value_size(value) + integer : 0;
      if (value_get_type(value) == VALUE_TYPE_VECTOR) {
 if ((r = value_get_vector(value, &value)) < 0)
   return r;
      }

      if ((r = value_clear(element->value)) < 0)
 return r;
      if ((r = value_set_null(element->value)) < 0)
 return r;
      for (; n > 0; n--) {
 if (!value)
   break;
 value = value->next;
      }
      integer = (integer < 0) ? -integer : integer;
      if (integer == 1) {
 if (value) {
   if ((r = value_set_value(element->value, value)) < 0)
     return r;
 }
      } else {
 if ((r = value_set_vector(element->value, ((void *)0))) < 0)
   return r;
 if ((r = value_match_values(&element->value->val.value, integer)) < 0)
   return r;
 v = element->value->val.value;
 for (; n < 0; n++) {
   if (!v)
     break;
   v = v->next;
 }
 if ((r = value_set_values(v, value)) < 0)
   return r;
      }
      break;
    }

    if (op->type == OPERATOR_TYPE_FUNCTION) {
      if ((r = value_get_function(element->param.operator.args[0]->value, &function)) < 0) {
 if ((r = value_get_label(element->param.operator.args[0]->value, &label)) < 0)
   return r;
 element->param.operator.args[1]->flags &= ~(1 << 0);
 args = element->param.operator.args[1]->value;
 if (label) {
   if ((r = label_proc(label, element->value, args)) < 0)
     return r;
 }
 break;
      }
      if (!function || !(function->flags & (1 << 0)))
 element->param.operator.args[1]->flags &= ~(1 << 0);
      args = element->param.operator.args[1]->value;
      if (value_get_type(args) == VALUE_TYPE_VECTOR) {
 if ((r = value_get_vector(args, &args)) < 0)
   return r;
      }




      if ((r = value_clear(element->value)) < 0)
 return r;
      if ((r = value_set_vector(element->value, ((void *)0))) < 0)
 return r;
      if (function) {
 if ((r = function_proc(function, &element->value->val.value, args)) < 0)
   return r;
      }
      if (!(element->flags & (1 << 1))) {
 if (element->value->val.value && !element->value->val.value->next) {
   if ((r = value_vector_to_value(element->value)) < 0)
     return r;
 }
      }
      break;
    }

    if ((r = proc_binary(op, &element->value,
    &element->param.operator.args[0]->value,
    &element->param.operator.args[1]->value)) < 0)
      return r;

    break;

  case OPERATOR_SUBTYPE_NONE:
    break;

  default:
    return NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR;
  }

  if (op->flags & (1 << 3)) {
    switch (op->subtype) {
    case OPERATOR_SUBTYPE_MON_BIN:
    case OPERATOR_SUBTYPE_MONADIC:
      if (element->param.operator.args[0]->flags & (1 << 0))
 element->flags |= (1 << 0);
      break;
    case OPERATOR_SUBTYPE_BINARY:
      if ((element->param.operator.args[0]->flags & (1 << 0)) &&
   (element->param.operator.args[1]->flags & (1 << 0)))
 element->flags |= (1 << 0);
      break;
    default:
      element->flags |= (1 << 0);
      break;
    }
  }

  return 0;
}

static int proc(element_t element, value_t *valuep)
{
  int r;
  value_t value = ((void *)0);

  for (; element; element = element->next) {
    if ((r = proc_element(element)) < 0)
      return r;
    value = element->value;
  }

  if (valuep)
    *valuep = value;

  return 0;
}

int formula_free(element_t *elementp)
{
  element_t e;

  while (*elementp) {
    e = *elementp;
    *elementp = (*elementp)->next;
    e->next = ((void *)0);

    switch (e->type) {
    case ELEMENT_TYPE_VARIABLE:
      if (e->param.variable.variable)
 variable_del(e->param.variable.variable);
      break;

    case ELEMENT_TYPE_ELEMENTS:
      if (e->param.elements.head)
 formula_free(&e->param.elements.head);
      break;

    case ELEMENT_TYPE_OPERATOR:
      if (e->param.operator.args[0])
 formula_free(&e->param.operator.args[0]);
      if (e->param.operator.args[1])
 formula_free(&e->param.operator.args[1]);
      break;

    default:
      break;
    }

    element_free(e);
  }

  return 0;
}

int formula_clean(element_t element)
{
  int r;

  for (; element; element = element->next) {
    if ((r = element_clean(element)) < 0)
      return r;
    switch (element->type) {
    case ELEMENT_TYPE_VARIABLE:
      if (element->param.variable.variable) {
 if ((r = value_clear(element->param.variable.variable->value)) < 0)
   return r;
      }
      break;

    case ELEMENT_TYPE_ELEMENTS:
      if (element->param.elements.head) {
 if ((r = formula_clean(element->param.elements.head)) < 0)
   return r;
      }
      break;

    case ELEMENT_TYPE_OPERATOR:
      if (element->param.operator.args[0]) {
 if ((r = formula_clean(element->param.operator.args[0])) < 0)
   return r;
      }
      if (element->param.operator.args[1]) {
 if ((r = formula_clean(element->param.operator.args[1])) < 0)
   return r;
      }
      break;

    default:
      break;
    }
  }

  return 0;
}

int formula_parse(char *formula, char **endp, element_t *elementp, const char *terminator)
{
  element_t element = ((void *)0);
  int r;

  if (!terminator)
    terminator = ",;";

  if ((r = lex(&element, formula, endp, terminator)) < 0) {
    formula_free(&element);
    return r;
  }

  if ((r = parse(&element)) < 0) {
    formula_free(&element);
    return r;
  }

  if (elementp)
    *elementp = element;

  return 0;
}

int formula_proc(element_t element, value_t *valuep)
{
  int r;
  value_t value;

  if ((r = proc(element, &value)) < 0)
    return r;

  if (valuep)
    *valuep = value;

  return 0;
}

int formula_dump(FILE *fp, element_t element)
{
  const char *name;
  element_t left = ((void *)0);

  for (; element; left = element, element = element->next) {
    nll_wait_output(fp);
    if (left)
      fprintf(fp, ",");
    switch (element->type) {
    case ELEMENT_TYPE_SYMBOL:
      fprintf(fp, "%s", element->param.name.name);
      break;

    case ELEMENT_TYPE_INTEGER:
    case ELEMENT_TYPE_STRING:

    case ELEMENT_TYPE_FLOAT:

      value_dump(fp, element->value);
      break;

    case ELEMENT_TYPE_VARIABLE:
      fprintf(fp, "%s", element->param.variable.variable->name);
      break;

    case ELEMENT_TYPE_ELEMENTS:
      if (element->param.elements.op)
 fprintf(fp, "%s", element->param.elements.op->word);
      formula_dump(fp, element->param.elements.head);
      if (element->param.elements.op)
 fprintf(fp, "%s", element->param.elements.op->term);
      break;

    case ELEMENT_TYPE_OPERATOR:
      switch (element->param.operator.op->type) {
      case OPERATOR_TYPE_ARRAY:
 name = "";
 break;
      case OPERATOR_TYPE_NOP:
 name = "NOP";
 break;
      case OPERATOR_TYPE_FUNCTION:
 name = "";
 if (element->param.operator.args[1]->type != ELEMENT_TYPE_ELEMENTS)
   name = " ";
 break;
      default:
 name = element->param.operator.op->word;
 name = name ? name : "";
 break;
      }

      switch (element->param.operator.op->subtype) {
      case OPERATOR_SUBTYPE_MONADIC:
      case OPERATOR_SUBTYPE_MON_BIN:
 if (element->param.operator.op->flags & (1 << 0))
   fprintf(fp, "%s", name);
 if (element->param.operator.args[0])
   formula_dump(fp, element->param.operator.args[0]);
 if (element->param.operator.op->flags & (1 << 1))
   fprintf(fp, "%s", name);
 break;

      case OPERATOR_SUBTYPE_BINARY:
 if (element->param.operator.args[0])
   formula_dump(fp, element->param.operator.args[0]);
 fprintf(fp, "%s", name);
 if (element->param.operator.args[1])
   formula_dump(fp, element->param.operator.args[1]);
 break;

      case OPERATOR_SUBTYPE_NONE:
      default:
 fprintf(fp, "%s", name);
 break;
      }
      break;

    case ELEMENT_TYPE_NONE:
    default:
      fprintf(fp, "?");
      break;
    }
  }

  return 0;
}

int formula_operator_list(FILE *fp)
{
  operator_t operator;
  int priority, i;
  unsigned int d;

  nll_wait_output(fp);
  fprintf(fp, "Name\tPri\tType\tDir\tFlags\n");

  for (i = 0; i < (13 - 0 + 1); i++) {
    priority = 0 + i;

    for (d = (1 << 0); d != 0;
  d = (d == (1 << 0)) ? (1 << 1) : 0) {

      for (operator = operators; operator->type != OPERATOR_TYPE_NONE; operator++) {
 if (!(operator->flags & d))
   continue;
 if (operator->priority != priority)
   continue;

 nll_wait_output(fp);

 if (!operator->word) {
   switch (operator->type) {
   case OPERATOR_TYPE_NOP: fprintf(fp, "NOP"); break;
   case OPERATOR_TYPE_FUNCTION: fprintf(fp, "FUNC"); break;
   case OPERATOR_TYPE_NONE:
   default:
     continue;
   }
 } else {
   fprintf(fp, "%s", operator->word);
 }

 if (operator->term)
   fprintf(fp, "%s", operator->term);

 fprintf(fp, "\t%d", operator->priority);
 switch (operator->subtype) {
 case OPERATOR_SUBTYPE_MONADIC:
 case OPERATOR_SUBTYPE_MON_BIN: fprintf(fp, "\tMONADIC"); break;
 case OPERATOR_SUBTYPE_BINARY: fprintf(fp, "\tBINARY"); break;
 case OPERATOR_SUBTYPE_NONE:
 default: fprintf(fp, "\tNONE"); break;
 }
 switch (d) {
 case (1 << 0): fprintf(fp, "\tR->L"); break;
 case (1 << 1): fprintf(fp, "\tL->R"); break;
 }
 fprintf(fp, "\t(");

 if (operator->flags & (1 << 2)) fprintf(fp, " EFFECT");
 if (operator->flags & (1 << 3)) fprintf(fp, " FIXED");
 fprintf(fp, " )\n");
      }
    }
  }

  fflush(fp);

  return 0;
}
