#ifndef __NLL_CONST_H_INCLUDED__
#define __NLL_CONST_H_INCLUDED__

#define NLL_T_UNKNOWN   -1
#define NLL_T_UNDEFINED  0
#define NLL_T_NULL       1
#define NLL_T_VALUE      2
#define NLL_T_VECTOR     3
#define NLL_T_INTEGER    4
#define NLL_T_STRING     5
#ifdef NLL_FLOATING_POINT
#define NLL_T_FLOAT      6
#endif
#define NLL_T_ARRAY      7
#define NLL_T_AREA       8
#define NLL_T_POINTER    9
#define NLL_T_FUNCTION  10
#define NLL_T_LABEL     11

#define NLL_D_VARIABLE (1 <<  0)
#define NLL_D_STRING   (1 <<  1)
#define NLL_D_LABEL    (1 <<  2)
#define NLL_D_LINE     (1 <<  3)
#define NLL_D_STACK    (1 <<  4)
#define NLL_D_POSITION (1 <<  5)
#define NLL_D_ALL      (NLL_D_VARIABLE|NLL_D_STRING|NLL_D_LABEL|NLL_D_LINE|NLL_D_STACK|NLL_D_POSITION)
#define NLL_L_COMMAND  (1 << 16)
#define NLL_L_FUNCTION (1 << 17)
#define NLL_L_CONST    (1 << 18)
#define NLL_L_OPERATOR (1 << 19)

#ifdef USE_FRAMEBUF
#define NLL_F_DISABLE  0
#define NLL_F_ENABLE   NLL_F_BUFFER
#define NLL_F_BUFFER   (1 <<  0)
#define NLL_F_FLUSH    (1 <<  1)
#define NLL_F_CURSOR   (1 <<  2)
#define NLL_F_CURSES   (1 <<  3)
#define NLL_F_FORCE    (1 <<  4)

#define NLL_F_FILL     (1 <<  0)

#define NLL_F_CURSORPOS 0x7FFFFFFF

#define NLL_C_RESET      9
#define NLL_C_BLACK      0
#define NLL_C_RED        1
#define NLL_C_GREEN      2
#define NLL_C_YELLOW     3
#define NLL_C_BLUE       4
#define NLL_C_MAGENTA    5
#define NLL_C_CYAN       6
#define NLL_C_WHITE      7

#define NLL_A_RESET      0
#define NLL_A_BOLD       1
#define NLL_A_FAINT      2
#define NLL_A_ITALIC     3
#define NLL_A_UNDERLINE  4
#define NLL_A_BLINK      5
#define NLL_A_RAPIDBLINK 6
#define NLL_A_INVERSE    7
#define NLL_A_INVISIBLE  8
#define NLL_A_CROSSOUT   9
#endif

#ifdef USE_GRAPHIC

/* flags for context */
#define NLL_G_DISABLE    0
#define NLL_G_ENABLE     NLL_G_DIRECT
#define NLL_G_DIRECT     (1 <<  0)
#define NLL_G_BUFFER     (1 <<  1)
#define NLL_G_MODE_MASK  (3 <<  0)
#define NLL_G_RENDERER   (1 <<  2)
#define NLL_G_FORCE      (1 <<  3)
#define NLL_G_SYNC       (1 <<  4)
#define NLL_G_FLUSH      (1 <<  5)
#define NLL_G_ROUGH      (1 <<  6)
#define NLL_G_HROUGH     (1 <<  7)

/* flags for image */
#define NLL_G_CONST      (1 <<  8)
#define NLL_G_STATIC     (1 <<  9)
#define NLL_G_RDONLY     (1 << 10)
#define NLL_G_AUTOCOLOR  (0 << 13)
#define NLL_G_FULLCOLOR  (1 << 13)
#define NLL_G_MONOCOLOR  (2 << 13)
#define NLL_G_MONOBCOLOR (3 << 13)
#define NLL_G_ROUGHCOLOR (4 << 13)
#define NLL_G_GRAYCOLOR  (5 << 13)
#define NLL_G_HALFCOLOR  (6 << 13)
#define NLL_G_COLOR_MASK (7 << 13)

/* flags for draw */
#define NLL_G_SET        (0 << 16)
#define NLL_G_AND        (1 << 16)
#define NLL_G_OR         (2 << 16)
#define NLL_G_XOR        (3 << 16)
#define NLL_G_SET_MASK   (3 << 16)
#define NLL_G_FILL       (1 << 18)
#define NLL_G_ODDPOS     (1 << 19)
#define NLL_G_EVENPOS    (1 << 20)
#define NLL_G_NUPDATE    (1 << 21)
#define NLL_G_OFFSET     (1 << 22)

#define NLL_G_MAINIMG   -1

#define NLL_G_FONT8X8   0
#define NLL_G_FONT16X16 1
#define NLL_G_FONT5X5   2
#define NLL_G_CHARA     3
#define NLL_G_CHARA2    4
#define NLL_G_CHARA3    5

#define NLL_G_DEFAULT 0x7FFFFFFF

#define NLL_G_BLACK     0x000000
#define NLL_G_BLUE      0x0000FF
#define NLL_G_GREEN     0x00FF00
#define NLL_G_CYAN      0x00FFFF
#define NLL_G_RED       0xFF0000
#define NLL_G_MAGENTA   0xFF00FF
#define NLL_G_YELLOW    0xFFFF00
#define NLL_G_WHITE     0xFFFFFF

#define NLL_G_TRANSPARENT -1
#endif

#ifdef USE_AUDIO
#define NLL_A_OUTPUT    0
#define NLL_A_NOOUT    -1

#define NLL_A_TYPE_SHIFT 24
#define NLL_A_SIN       ( 0x0 << NLL_A_TYPE_SHIFT)
#define NLL_A_TRIANGLE  ( 0x1 << NLL_A_TYPE_SHIFT)
#define NLL_A_SQUARE    ( 0x2 << NLL_A_TYPE_SHIFT)
#define NLL_A_PULSE     ( 0x3 << NLL_A_TYPE_SHIFT)
#define NLL_A_SAWUP     ( 0x4 << NLL_A_TYPE_SHIFT)
#define NLL_A_SAWDOWN   ( 0x5 << NLL_A_TYPE_SHIFT)
#define NLL_A_RANDOM    ( 0x6 << NLL_A_TYPE_SHIFT)
#define NLL_A_NOISE     ( 0x7 << NLL_A_TYPE_SHIFT)
#define NLL_A_ZERO      ( 0x8 << NLL_A_TYPE_SHIFT)
#define NLL_A_HIGH      ( 0x9 << NLL_A_TYPE_SHIFT)
#define NLL_A_INPULSE   ( 0xA << NLL_A_TYPE_SHIFT)
#define NLL_A_EXTIN     ( 0xB << NLL_A_TYPE_SHIFT)
#define NLL_A_DATA      ( 0xC << NLL_A_TYPE_SHIFT)
#define NLL_A_TYPE_MASK (0xFF << NLL_A_TYPE_SHIFT)

#define NLL_A_MOD_SHIFT 24
#define NLL_A_PHASE    ( 0x0 << NLL_A_MOD_SHIFT)
#define NLL_A_FREQ     ( 0x1 << NLL_A_MOD_SHIFT)
#define NLL_A_NULL     ( 0x2 << NLL_A_MOD_SHIFT)
#define NLL_A_REV      ( 0x3 << NLL_A_MOD_SHIFT)
#define NLL_A_ABS      ( 0x4 << NLL_A_MOD_SHIFT)
#define NLL_A_INV      ( 0x5 << NLL_A_MOD_SHIFT)
#define NLL_A_SIGN     ( 0x6 << NLL_A_MOD_SHIFT)
#define NLL_A_CLIP     ( 0x7 << NLL_A_MOD_SHIFT)
#define NLL_A_ADD      ( 0x8 << NLL_A_MOD_SHIFT)
#define NLL_A_SUB      ( 0x9 << NLL_A_MOD_SHIFT)
#define NLL_A_MUL      ( 0xA << NLL_A_MOD_SHIFT)
#define NLL_A_AND      ( 0xB << NLL_A_MOD_SHIFT)
#define NLL_A_OR       ( 0xC << NLL_A_MOD_SHIFT)
#define NLL_A_XOR      ( 0xD << NLL_A_MOD_SHIFT)
#define NLL_A_AVE      ( 0xE << NLL_A_MOD_SHIFT)
#define NLL_A_PER      ( 0xF << NLL_A_MOD_SHIFT)
#define NLL_A_MIN      (0x10 << NLL_A_MOD_SHIFT)
#define NLL_A_MAX      (0x11 << NLL_A_MOD_SHIFT)
#define NLL_A_LT       (0x12 << NLL_A_MOD_SHIFT)
#define NLL_A_GT       (0x13 << NLL_A_MOD_SHIFT)
#define NLL_A_MOD_MASK (0xFF << NLL_A_MOD_SHIFT)

#define NLL_A_FILFW     0
#define NLL_A_FILBW     1

#define NLL_A_FLUSH     0
#define NLL_A_FIXED     (1 <<  0)
#define NLL_A_ENVCLEAR  (1 <<  1)
#define NLL_A_ENVFDOUT  (1 <<  2)
#define NLL_A_ENVFDIN   (1 <<  3)
#define NLL_A_ENVFIXED  (1 <<  4)
#define NLL_A_FILCLEAR  (1 <<  5)
#define NLL_A_FILFIXED  (1 <<  6)
#define NLL_A_FILINC    (1 <<  7)
#define NLL_A_FILDEC    (1 <<  8)
#define NLL_A_SAVE      (1 <<  9)
#define NLL_A_NEW       (1 << 10)
#define NLL_A_REMAIN    (1 << 11)
#define NLL_A_STEREO    (1 << 12)
#define NLL_A_TEXT      (1 << 13)

#define NLL_A_NULLUNITSET -1
#define NLL_A_DEFUNITSET   0
#endif

#endif
