# 0 "command.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "command.c"
# 1 "config.h" 1
# 2 "command.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "command.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "command.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "command.c" 2
# 1 "../include/ctype.h" 1



int isalnum(int c);
int isalpha(int c);
int isascii(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);
int tolower(int c);
int toupper(int c);
# 7 "command.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 10 "command.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 13 "command.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 14 "command.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 15 "command.c" 2
# 1 "formula.h" 1



typedef enum {
  ELEMENT_TYPE_NONE,
  ELEMENT_TYPE_SYMBOL,
  ELEMENT_TYPE_INTEGER,
  ELEMENT_TYPE_STRING,

  ELEMENT_TYPE_FLOAT,

  ELEMENT_TYPE_VARIABLE,
  ELEMENT_TYPE_OPERATOR,
  ELEMENT_TYPE_ELEMENTS,
} element_type_t;

int formula_check(void);
int formula_init(void);
int formula_done(void);
int formula_get_symbol(char *dname, const char *name);
element_type_t formula_get_type(element_t element);
value_t formula_get_value(element_t element);
variable_t formula_get_variable(element_t element);
int formula_set_raw(element_t element);
int formula_free(element_t *elementp);
int formula_clean(element_t element);
int formula_parse(char *formula, char **endp, element_t *elementp, const char *terminator);
int formula_proc(element_t element, value_t *valuep);
int formula_dump(FILE *fp, element_t element);
int formula_operator_list(FILE *fp);
# 16 "command.c" 2
# 1 "label.h" 1



struct label {
  struct label *next;
  struct label *prev;
  struct spot spot;
  int refcount;
  char name[32 + 1];
};

int label_check(void);
int label_init(void);
int label_done(void);
int label_get(const char *name, label_t *labelp);
int label_set(const char *name, spot_t spot, label_t *labelp);
int label_clear(label_t label);
int label_clean(label_t label);
int label_del(label_t label);
int label_dump(FILE *fp, label_t label);
# 17 "command.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 18 "command.c" 2
# 1 "variable.h" 1



struct variable {
  struct variable *next;
  struct variable *prev;
  value_t value;
  int refcount;
  char name[32 + 1];
};

int variable_check(void);
int variable_del(variable_t variable);
int variable_clean(void);
int variable_clear(void);
int variable_new(variable_t variable);
int variable_init(void);
int variable_done(void);
int variable_get(const char *name, variable_t *variablep);
int variable_dump(FILE *fp, variable_t variable);
int variable_const_list(FILE *fp);
# 19 "command.c" 2
# 1 "command.h" 1



typedef enum {
  COMMAND_UNKNOWN = 0,
  COMMAND_NONE,

  COMMAND_COMMENT,
  COMMAND_END,
  COMMAND_EXIT,
  COMMAND_ARGS,
  COMMAND_LET,
  COMMAND_PRINT,
  COMMAND_GOTO,
  COMMAND_GONEXT,
  COMMAND_GOSUB,
  COMMAND_RETURN,
  COMMAND_IF,
  COMMAND_ELSE,
  COMMAND_ENDIF,
  COMMAND_LOOP,
  COMMAND_LOOPEND,
  COMMAND_FOR,
  COMMAND_NEXT,
  COMMAND_DISCARD,
  COMMAND_DIM,
  COMMAND_MEMORY,
  COMMAND_PUSH,
  COMMAND_POP,
  COMMAND_DFROM,
  COMMAND_DREAD,
  COMMAND_DATA,
  COMMAND_RUN,
  COMMAND_STOP,
  COMMAND_SKIP,
  COMMAND_BREAK,
  COMMAND_STEP,
  COMMAND_CONTINUE,
  COMMAND_NEW,
  COMMAND_LIST,
  COMMAND_SAVE,
  COMMAND_LOAD,
  COMMAND_STDIN,
  COMMAND_STDOUT,
  COMMAND_EVAL,
  COMMAND_EVALF,
  COMMAND_EDIT,
  COMMAND_WAIT,
  COMMAND_DUMP,

  COMMAND_LAST
} command_type_t;

typedef enum {
  COMMAND_ARG_UNKNOWN = 0,
  COMMAND_ARG_LABEL,
  COMMAND_ARG_VARIABLE,
  COMMAND_ARG_FORMULA,
  COMMAND_ARG_WORD,
} command_arg_type_t;

typedef const struct command_ope {
  const char *name;
  const char *other_name;
  command_type_t type;
} *command_ope_t;

typedef struct command_arg {
  command_arg_type_t type;
  union {
    struct {
      label_t label;
    } label;
    struct {
      variable_t variable;
    } variable;
    struct {
      element_t element;
    } formula;
    struct {
      char word[16 + 1];
    } word;
  } arg;
} *command_arg_t;

struct command {
  struct command *next;
  command_ope_t ope;
  char *line;
  int errcode;
  struct {
    label_t label;
    variable_t variable;
    element_t args;
  } label;
  element_t prefix;
  struct command_arg args[4];
};

int command_check(void);
int command_search(char *p, char **endp, command_ope_t *opep);
int command_list(FILE *fp);
int command_get(command_type_t type, command_ope_t *opep);
int command_alloc(command_t *commandp);
int command_free(command_t command);
int command_set_label(command_t command, const char *name, spot_t spot);
int command_clear_label(command_t command);
int command_clear(command_t command);
int command_clean(command_t command);
int command_init(void);
int command_done(void);
int command_dump(FILE *fp, command_t command);
# 20 "command.c" 2

static int command_num = 0;
static int pool_num = 0;

static command_t pool = ((void *)0);

static command_t pool_alloc(void)
{
  command_t command;

  if (!pool)
    return ((void *)0);

  command = pool;
  pool = pool->next;
  pool_num--;

  return command;
}

static int pool_free(command_t command)
{
  command->next = pool;
  pool = command;
  pool_num++;
  return 0;
}


static int _init(void)
{
  return 0;
}

static int _done(void)
{
  while (pool)
    memory_free(pool_alloc());
  return 0;
}

static int _check(void)
{
  if (pool)
    return NLL_ERRCODE_COMMAND_NOT_EMPTY;
  return 0;
}

static command_t _alloc(void)
{
  command_t command;
  command = pool_alloc();
  if (!command)
    command = memory_alloc(sizeof(*command));
  return command;
}

static int _free(command_t command)
{
  if ((1024 < 0) || (pool_num < 1024))
    return pool_free(command);
  memory_free(command);
  return 0;
}
# 134 "command.c"
static const struct command_ope opecodes[] = {
  { ((void *)0) , ((void *)0) , COMMAND_NONE },
  { "#" , ((void *)0) , COMMAND_COMMENT },
  { "RUN" , "RN.", COMMAND_RUN },
  { "EDIT" , "ET.", COMMAND_EDIT },
  { "END" , ((void *)0) , COMMAND_END },
  { "EXIT" , ((void *)0) , COMMAND_EXIT },
  { "QUIT" , "QT.", COMMAND_EXIT },
  { "BREAK" , "BK.", COMMAND_BREAK },
  { "STEP" , "SE.", COMMAND_STEP },
  { "STOP" , "SP.", COMMAND_STOP },
  { "SKIP" , ((void *)0) , COMMAND_SKIP },
  { "CONTINUE", "CN.", COMMAND_CONTINUE },
  { "ARGS" , "AG.", COMMAND_ARGS },
  { "LET" , "LT.", COMMAND_LET },
  { "PRINT" , "PT.", COMMAND_PRINT },
  { "GOTO" , "GT.", COMMAND_GOTO },
  { "GONEXT" , "GN.", COMMAND_GONEXT },
  { "GOSUB" , "GS.", COMMAND_GOSUB },
  { "RETURN" , "RT.", COMMAND_RETURN },
  { "IF" , ((void *)0) , COMMAND_IF },
  { "ELSE" , "ES.", COMMAND_ELSE },
  { "ENDIF" , "EI.", COMMAND_ENDIF },
  { "LOOPEND" , "LE.", COMMAND_LOOPEND },
  { "LOOP" , "LP.", COMMAND_LOOP },
  { "FOR" , "FR.", COMMAND_FOR },
  { "NEXT" , "NX.", COMMAND_NEXT },
  { "DIM" , "DM.", COMMAND_DIM },
  { "MEMORY" , "MM.", COMMAND_MEMORY },
  { "PUSH" , "PS.", COMMAND_PUSH },
  { "POP" , "PP.", COMMAND_POP },
  { "DFROM" , "FM.", COMMAND_DFROM },
  { "DREAD" , "RD.", COMMAND_DREAD },
  { "DATA" , "DT.", COMMAND_DATA },
  { "DISCARD" , "DC.", COMMAND_DISCARD },
  { "NEW" , "NW.", COMMAND_NEW },
  { "LIST" , "LS.", COMMAND_LIST },
  { "SAVE" , "SV.", COMMAND_SAVE },
  { "LOAD" , "LD.", COMMAND_LOAD },
  { "STDIN" , "SI.", COMMAND_STDIN },
  { "STDOUT" , "SO.", COMMAND_STDOUT },
  { "EVAL" , "EV.", COMMAND_EVAL },
  { "EVALF" , "EF.", COMMAND_EVALF },
  { "WAIT" , "WT.", COMMAND_WAIT },
  { "DUMP" , "DP.", COMMAND_DUMP },
  { ((void *)0) , ((void *)0) , COMMAND_LAST }
};

int command_check(void)
{
  if (command_num)
    return NLL_ERRCODE_COMMAND_NOT_EMPTY;

  return _check();
}

static int namecmp(const char *s0, const char *s1, int len)
{
  int i;
  for (i = 0; i < len; i++) {
    if (toupper(*(s0++)) != toupper(*(s1++)))
      return -1;
  }
  return 0;
}

int command_search(char *p, char **endp, command_ope_t *opep)
{
  command_ope_t ope;
  int i, len;

  for (ope = opecodes; ope->type != COMMAND_LAST; ope++) {
    if (ope->name) {
      len = strlen(ope->name);
      if (!namecmp(ope->name, p, len)) {

 if (p[len] && (ope->type != COMMAND_COMMENT)) {
   if (isalnum(p[len]) || (p[len] == '_'))
     continue;

   else if (p[len] & 0x80)
     continue;

 }

 goto found;
      }
    }
  }

  for (ope = opecodes; ope->type != COMMAND_LAST; ope++) {
    if (ope->other_name) {
      len = strlen(ope->other_name);
      if (!namecmp(ope->other_name, p, len))
 goto found;
    }
  }

  for (ope = opecodes; ope->type != COMMAND_LAST; ope++) {
    if (ope->name) {
      len = strlen(ope->name);
      for (i = 1; i < len; i++) {
 if (!namecmp(ope->name, p, i) && (p[i] == '.')) {
   len = i + 1;
   goto found;
 }
      }
    }
  }

  return NLL_ERRCODE_COMMAND_NOT_FOUND;

found:
  *opep = ope;
  for (i = 0; i < len; i++, p++)
    *p = toupper(*p);
  if (endp)
    *endp = p;
  return 0;
}

int command_list(FILE *fp)
{
  command_ope_t ope;

  for (ope = opecodes; ope->type != COMMAND_LAST; ope++) {
    nll_wait_output(fp);
    if (ope->name) {
      fprintf(fp, "%s", ope->name);
      if (ope->other_name)
 fprintf(fp, "\t(%s)", ope->other_name);
      fprintf(fp, "\n");
    }
  }

  fflush(fp);

  return 0;
}

int command_get(command_type_t type, command_ope_t *opep)
{
  command_ope_t ope;

  for (ope = opecodes; ope->type != COMMAND_LAST; ope++) {
    if (ope->type == type) {
      *opep = ope;
      return 0;
    }
  }

  return NLL_ERRCODE_COMMAND_NOT_FOUND;
}

int command_alloc(command_t *commandp)
{
  command_t command;

  if ((command = _alloc()) == ((void *)0))
    return NLL_ERRCODE_COMMAND_BUFFER_OVER;
  command_num++;

  memset(command, 0, sizeof(*command));

  *commandp = command;

  return 0;
}

int command_free(command_t command)
{
  command_t next;
  int r;

  for (; command; command = next) {
    next = command->next;

    command_clear(command);

    command_num--;
    if ((r = _free(command)) < 0)
      return r;
  }

  return 0;
}

int command_set_label(command_t command, const char *name, spot_t spot)
{
  int r;

  if ((r = variable_get(name, &command->label.variable)) < 0)
    return r;
  if (command->label.variable->value->flags & ((1 << 0)|(1 << 1)))
    return NLL_ERRCODE_LABEL_DUPLICATE;

  if ((r = label_set(command->label.variable->name, spot,
       &command->label.label)) < 0)
    return r;


  if ((r = value_clear(command->label.variable->value)) < 0)
    return r;

  if ((r = value_set_label(command->label.variable->value,
      command->label.label)) < 0)
    return r;

  command->label.variable->value->flags |= (1 << 0);

  return 0;
}

int command_clear_label(command_t command)
{
  int r;

  if (command->label.args) {
    if ((r = formula_free(&command->label.args)) < 0)
      return r;
    command->label.args = ((void *)0);
  }

  if (command->label.variable) {

    command->label.variable->value->flags &= ~(1 << 0);
    if ((r = value_clear(command->label.variable->value)) < 0)
      return r;
    if ((r = variable_del(command->label.variable)) < 0)
      return r;
    command->label.variable = ((void *)0);
  }

  if (command->label.label) {
    if ((r = label_clear(command->label.label)) < 0)
      return r;
    if ((r = label_del(command->label.label)) < 0)
      return r;
    command->label.label = ((void *)0);
  }

  return 0;
}

int command_clear(command_t command)
{
  command_arg_t arg;
  int i;

  command_clear_label(command);

  if (command->prefix) {
    formula_free(&command->prefix);
    command->prefix = ((void *)0);
  }

  for (i = 0; i < 4; i++) {
    arg = &command->args[i];
    switch (arg->type) {
    case COMMAND_ARG_LABEL:
      if (arg->arg.label.label)
 label_del(arg->arg.label.label);
      break;
    case COMMAND_ARG_VARIABLE:
      if (arg->arg.variable.variable)
 variable_del(arg->arg.variable.variable);
      break;
    case COMMAND_ARG_FORMULA:
      if (arg->arg.formula.element)
 formula_free(&arg->arg.formula.element);
      break;
    case COMMAND_ARG_WORD:
    case COMMAND_ARG_UNKNOWN:
    default:
      break;
    }
  }

  memset(command->args, 0, sizeof(command->args));

  command->ope = ((void *)0);

  return 0;
}

int command_clean(command_t command)
{
  command_arg_t arg;
  int r, i;

  for (; command; command = command->next) {
    if (command->label.label) {
      if ((r = label_clean(command->label.label)) < 0)
 return r;
    }
    if (command->label.variable) {
      if ((r = value_clear(command->label.variable->value)) < 0)
 return r;
    }
    if (command->label.args) {
      if ((r = formula_clean(command->label.args)) < 0)
 return r;
    }

    if (command->prefix) {
      if ((r = formula_clean(command->prefix)) < 0)
 return r;
    }

    for (i = 0; i < 4; i++) {
      arg = &command->args[i];
      switch (arg->type) {
      case COMMAND_ARG_LABEL:
 if (arg->arg.label.label) {
   if ((r = label_clean(arg->arg.label.label)) < 0)
     return r;
 }
 break;
      case COMMAND_ARG_VARIABLE:
 if (arg->arg.variable.variable) {
   if ((r = value_clear(arg->arg.variable.variable->value)) < 0)
     return r;
 }
 break;
      case COMMAND_ARG_FORMULA:
 if (arg->arg.formula.element) {
   if ((r = formula_clean(arg->arg.formula.element)) < 0)
     return r;
 }
 break;
      case COMMAND_ARG_WORD:
      case COMMAND_ARG_UNKNOWN:
      default:
 break;
      }
    }
  }

  return 0;
}

int command_init(void)
{
  command_num = 0;
  pool_num = 0;
  pool = ((void *)0);
  return _init();
}

int command_done(void)
{
  return _done();
}

int command_dump(FILE *fp, command_t command)
{
  int i;
  command_arg_t arg;
  char *s;

  for (; command; command = command->next) {
    nll_wait_output(fp);
    fprintf(fp, "\t");
    if (command->errcode) {
      fprintf(fp, "ERROR\t");
      nll_error_print("command.c", 499, command->errcode, command->line);
      continue;
    }
    if (command->label.label) {
      fprintf(fp, ".");
      if (command->label.variable)
 fprintf(fp, "%s", command->label.variable->name);
      if (command->label.args)
 fprintf(fp, " ");
      formula_dump(fp, command->label.args);
      fprintf(fp, ":");
    }
    if (command->prefix) {
      if (command->label.label)
 fprintf(fp, "\t");
      formula_dump(fp, command->prefix);
    }
    fprintf(fp, "\t");
    if (command->ope) {
      fprintf(fp, "%s", command->ope->name ? command->ope->name : "NONE");
    } else {
      fprintf(fp, "NULL");
    }
    fprintf(fp, "\tArgs:");
    for (i = 0; i < 4; i++) {
      arg = &command->args[i];
      s = "";
      switch (arg->type) {
      case COMMAND_ARG_VARIABLE: if (arg->arg.variable.variable) s = " V"; break;
      case COMMAND_ARG_WORD: if (arg->arg.word.word[0]) s = " W"; break;
      case COMMAND_ARG_LABEL:
 if (arg->arg.label.label) {
   fprintf(fp, " L:");
 }
 break;

      case COMMAND_ARG_FORMULA:
 if (arg->arg.formula.element) {
   fprintf(fp, " F:");
   formula_dump(fp, arg->arg.formula.element);
 }
 break;

      case COMMAND_ARG_UNKNOWN:
      default:
 break;
      }
      fprintf(fp, "%s", s);
    }
    fprintf(fp, "\n");
  }

  fflush(fp);

  return 0;
}
