#ifndef __NLSYS_ARGUMENT_H_INCLUDED__
#define __NLSYS_ARGUMENT_H_INCLUDED__

/* #define ARGUMENT_SUPPORT_FLOAT */

typedef enum {
  ARGUMENT_TYPE_NONE,
  ARGUMENT_TYPE_FUNCTION,
  ARGUMENT_TYPE_FLAG_ON,
  ARGUMENT_TYPE_FLAG_OFF,
  ARGUMENT_TYPE_INTEGER,
#ifdef ARGUMENT_SUPPORT_FLOAT
  ARGUMENT_TYPE_FLOAT,
#endif
  ARGUMENT_TYPE_STRING
} argument_type_t;

#define ARGUMENT_FLAG_ON  1
#define ARGUMENT_FLAG_OFF 0

typedef struct _argument {
  const char *name;
  argument_type_t type;
  void *value;
} argument_t;

#define ARGUMENT_IGNORE_FIRST   (1 <<  0)
#define ARGUMENT_DELETE_REST    (1 <<  1)
#define ARGUMENT_NOTFOUND_BREAK (1 <<  2)

int argument_read(int *argc, char *argv[], const argument_t args[], unsigned int flags);

#endif
