# 0 "area.c"
# 1 "/tmp/nlux/nll//"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "area.c"
# 1 "config.h" 1
# 2 "area.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "area.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "area.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "area.c" 2
# 1 "../include/ctype.h" 1



int isalnum(int c);
int isalpha(int c);
int isascii(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);
int tolower(int c);
int toupper(int c);
# 7 "area.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 10 "area.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 13 "area.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 14 "area.c" 2
# 1 "memory.h" 1



int memory_check(void);
void *memory_alloc(int size);
int memory_free(void *p);
int memory_init(void);
# 15 "area.c" 2
# 1 "area.h" 1



struct area {
  struct area *next;
  struct area *prev;
  int refcount;
  int size;
  int area_size;
};

int area_check(void);
int area_alloc(area_t *areap, int size);
int area_free(area_t area);
int area_init(void);
int area_get_size(area_t area);
char *area_get_buffer(area_t area);
int area_copy_area(area_t area, int offset, area_t _area, int _offset, int size);
int area_read(area_t area, int offset, char *buffer, int size);
int area_write(area_t area, int offset, char *buffer, int size);
int area_read_integer(area_t area, int offset, integer_t *integerp, int size);
int area_write_integer(area_t area, int offset, integer_t integer, int size);
int area_dump(FILE *fp, area_t area);
# 16 "area.c" 2

static int buffer_size = 0;

static area_t head;
static area_t tail;


static int _init(void)
{
  static struct area _head;
  head = &_head;
  return 0;
}

static int _check(void)
{
  return 0;
}

static area_t _alloc(int size)
{
  area_t area;
  if ((area = memory_alloc(sizeof(*area) + size)) == ((void *)0))
    return ((void *)0);
  return area;
}

static int _free(area_t area)
{
  memory_free(area);
  return 0;
}
# 81 "area.c"
int area_check(void)
{
  if (buffer_size)
    return NLL_ERRCODE_AREA_NOT_EMPTY;

  if (head != tail)
    return NLL_ERRCODE_AREA_NOT_EMPTY;

  if (head->next || tail->prev)
    return NLL_ERRCODE_AREA_NOT_EMPTY;

  return _check();
}

int area_alloc(area_t *areap, int size)
{
  area_t area;
  int area_size;

  if (size < 0)
    return NLL_ERRCODE_MEMORY_INVALID_PARAMETER;

  area_size = ((size + 15) / 16) * 16;

  if ((area = _alloc(area_size)) == ((void *)0))
    return NLL_ERRCODE_AREA_BUFFER_OVER;
  buffer_size += area_size;

  memset(area, 0, sizeof(*area));

  memset(area + 1, 0, area_size);
  area->size = size;
  area->area_size = area_size;

  area->next = tail->next;
  area->prev = tail;
  tail->next = area;

  tail = area;

  *areap = area;

  return 0;
}

int area_free(area_t area)
{
  int r;

  if (--(area->refcount) != 0)
    return 1;

  area->prev->next = area->next;
  if (area->next)
    area->next->prev = area->prev;
  if (area == tail)
    tail = area->prev;

  buffer_size -= area->area_size;
  if ((r = _free(area)) < 0)
    return r;

  return 0;
}

int area_init(void)
{
  int r;

  buffer_size = 0;

  if ((r = _init()) < 0)
    return r;

  memset(head, 0, sizeof(*head));

  head->prev = ((void *)0);
  head->next = ((void *)0);
  head->size = 0;
  head->area_size = 0;

  tail = head;

  return 0;
}

int area_get_size(area_t area)
{
  return area->size;
}

char *area_get_buffer(area_t area)
{
  return (char *)(area + 1);
}

int area_copy_area(area_t area, int offset, area_t _area, int _offset, int size)
{
  char *p, *_p;

  if ((offset < 0) || (offset + size > area->size))
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;
  if ((_offset < 0) || (_offset + size > _area->size))
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  p = (char *)(area + 1) + offset;
  _p = (char *)(_area + 1) + _offset;

  memcpy(p, _p, size);

  return 0;
}

int area_read(area_t area, int offset, char *buffer, int size)
{
  char *p;

  if ((offset < 0) || (offset + size > area->size))
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  p = (char *)(area + 1) + offset;

  memcpy(buffer, p, size);

  return 0;
}

int area_write(area_t area, int offset, char *buffer, int size)
{
  char *p;

  if ((offset < 0) || (offset + size > area->size))
    return NLL_ERRCODE_AREA_OUT_OF_RANGE;

  p = (char *)(area + 1) + offset;

  memcpy(p, buffer, size);

  return 0;
}

union val {
  char top;
  integer_t integer;
  unsigned char c;
  unsigned short s;
  unsigned int i;
  unsigned long l;
};

int area_read_integer(area_t area, int offset, integer_t *integerp, int size)
{
  int r;
  union val val;
  integer_t integer;

  if ((size != sizeof(val.c)) && (size != sizeof(val.s)) &&
      (size != sizeof(val.i)) && (size != sizeof(val.l)))
    size = sizeof(val.integer);

  memset(&val, 0, sizeof(val));

  if ((r = area_read(area, offset, &val.top, size)) < 0)
    return r;

  switch (size) {
  case sizeof(val.c): integer = val.c; break;
  case sizeof(val.s): integer = val.s; break;
  case sizeof(val.i): integer = val.i; break;
  default: integer = val.integer; break;
  }

  *integerp = integer;

  return 0;
}

int area_write_integer(area_t area, int offset, integer_t integer, int size)
{
  int r;
  union val val;

  if ((size != sizeof(val.c)) && (size != sizeof(val.s)) &&
      (size != sizeof(val.i)) && (size != sizeof(val.l)))
    size = sizeof(val.integer);

  memset(&val, 0, sizeof(val));

  switch (size) {
  case sizeof(val.c): val.c = integer; break;
  case sizeof(val.s): val.s = integer; break;
  case sizeof(val.i): val.i = integer; break;
  default: val.integer = integer; break;
  }

  if ((r = area_write(area, offset, &val.top, size)) < 0)
    return r;

  return 0;
}

int area_dump(FILE *fp, area_t area)
{
  char *p, c;
  int i;

  nll_wait_output(fp);
  fprintf(fp, "(%d)[", area->size);

  p = (char *)(area + 1);
  for (i = 0; i < area->size; p++, i++) {
    nll_wait_output(fp);
    if (i >= 64) {
      fprintf(fp, "...");
      break;
    }
    c = *p;
    c = isprint(c) ? c : '.';
    fprintf(fp, "%c", c);
  }

  fprintf(fp, "]");

  return 0;
}
