#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)
#if defined(__i386__)

/*
 * Use FreeBSD/NetBSD system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4         7
#define SYS_kill         37
#define SYS_execve       59

#define SYS_read          3
#define SYS_write         4
#define SYS_open          5
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         90
#define SYS_pipe2       542

#define SYS_sigaction   416
#define SYS_sigprocmask 340 /* 48? */
#define SYS_sigreturn   417

#define SYS_getpid       20
#define SYS_getppid      39
#define SYS_getsid      310
#define SYS_setsid      147
#define SYS_getpgid     207
#define SYS_setpgid      82
#define SYS_getpgrp      81

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir       13
#define SYS_chmod        15
#define SYS_chown        16
#define SYS_lseek       478
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl        92
#define SYS_fsync        95
#define SYS_fchown      123
#define SYS_fchmod      124
#define SYS_rename      128

#define SYS_mkdir       136
#define SYS_rmdir       137

#define SYS_mmap        477
#define SYS_munmap       73

#define SYS_truncate    479
#define SYS_ftruncate   480

#define SYS_select       93
#define SYS_pselect     522

#define SYS_gettimeofday 116
#define SYS_settimeofday 122

#define SYS_ioctl        54
#define SYS_break        17
#define SYS_sbrk         69
#define SYS_getdents    272
#define SYS_getcwd      326

	.section .text

	.globl	___exit
	.type	___exit, @function
___exit:
	mov	$SYS_exit, %eax
	jmp	_syscall

	.globl	__fork
	.type	__fork, @function
__fork:
	mov	$SYS_fork, %eax
	jmp	_syscall

	.globl	__wait4
	.type	__wait4, @function
__wait4:
	mov	$SYS_wait4, %eax
	jmp	_syscall

	.globl	__kill
	.type	__kill, @function
__kill:
	mov	$SYS_kill, %eax
	jmp	_syscall

	.globl	__execve
	.type	__execve, @function
__execve:
	mov	$SYS_execve, %eax
	jmp	_syscall

	.globl	__read
	.type	__read, @function
__read:
	mov	$SYS_read, %eax
	jmp	_syscall

	.globl	__write
	.type	__write, @function
__write:
	mov	$SYS_write, %eax
	jmp	_syscall

	.globl	__open
	.type	__open, @function
__open:
	mov	$SYS_open, %eax
	jmp	_syscall

	.globl	__close
	.type	__close, @function
__close:
	mov	$SYS_close, %eax
	jmp	_syscall

	.globl	__dup
	.type	__dup, @function
__dup:
	mov	$SYS_dup, %eax
	jmp	_syscall

	.globl	__pipe
	.type	__pipe, @function
__pipe:
	mov	$SYS_pipe, %eax
	jmp	_syscall

	.globl	__dup2
	.type	__dup2, @function
__dup2:
	mov	$SYS_dup2, %eax
	jmp	_syscall

	.globl	__pipe2
	.type	__pipe2, @function
__pipe2:
	mov	$SYS_pipe2, %eax
	jmp	_syscall

	.globl	__sigaction
	.type	__sigaction, @function
__sigaction:
	mov	$SYS_sigaction, %eax
	jmp	_syscall

	.globl	__sigprocmask
	.type	__sigprocmask, @function
__sigprocmask:
	mov	$SYS_sigprocmask, %eax
	jmp	_syscall

	.globl	__sigreturn
	.type	__sigreturn, @function
__sigreturn:
	mov	$SYS_sigreturn, %eax
	jmp	_syscall

	.globl	__getpid
	.type	__getpid, @function
__getpid:
	mov	$SYS_getpid, %eax
	jmp	_syscall

	.globl	__getppid
	.type	__getppid, @function
__getppid:
	mov	$SYS_getppid, %eax
	jmp	_syscall

	.globl	__getsid
	.type	__getsid, @function
__getsid:
	mov	$SYS_getsid, %eax
	jmp	_syscall

	.globl	__setsid
	.type	__setsid, @function
__setsid:
	mov	$SYS_setsid, %eax
	jmp	_syscall

	.globl	__getpgid
	.type	__getpgid, @function
__getpgid:
	mov	$SYS_getpgid, %eax
	jmp	_syscall

	.globl	__setpgid
	.type	__setpgid, @function
__setpgid:
	mov	$SYS_setpgid, %eax
	jmp	_syscall

	.globl	__getpgrp
	.type	__getpgrp, @function
__getpgrp:
	mov	$SYS_getpgrp, %eax
	jmp	_syscall

	.globl	__unlink
	.type	__unlink, @function
__unlink:
	mov	$SYS_unlink, %eax
	jmp	_syscall

	.globl	__chdir
	.type	__chdir, @function
__chdir:
	mov	$SYS_chdir, %eax
	jmp	_syscall

	.globl	__fchdir
	.type	__fchdir, @function
__fchdir:
	mov	$SYS_fchdir, %eax
	jmp	_syscall

	.globl	__chmod
	.type	__chmod, @function
__chmod:
	mov	$SYS_chmod, %eax
	jmp	_syscall

	.globl	__chown
	.type	__chown, @function
__chown:
	mov	$SYS_chown, %eax
	jmp	_syscall

	.globl	__lseek
	.type	__lseek, @function
__lseek:
	mov	$SYS_lseek, %eax
	jmp	_syscall

	.globl	__access
	.type	__access, @function
__access:
	mov	$SYS_access, %eax
	jmp	_syscall

	.globl	__sync
	.type	__sync, @function
__sync:
	mov	$SYS_sync, %eax
	jmp	_syscall

	.globl	__fcntl
	.type	__fcntl, @function
__fcntl:
	mov	$SYS_fcntl, %eax
	jmp	_syscall

	.globl	__fsync
	.type	__fsync, @function
__fsync:
	mov	$SYS_fsync, %eax
	jmp	_syscall

	.globl	__fchown
	.type	__fchown, @function
__fchown:
	mov	$SYS_fchown, %eax
	jmp	_syscall

	.globl	__fchmod
	.type	__fchmod, @function
__fchmod:
	mov	$SYS_fchmod, %eax
	jmp	_syscall

	.globl	__rename
	.type	__rename, @function
__rename:
	mov	$SYS_rename, %eax
	jmp	_syscall

	.globl	__mkdir
	.type	__mkdir, @function
__mkdir:
	mov	$SYS_mkdir, %eax
	jmp	_syscall

	.globl	__rmdir
	.type	__rmdir, @function
__rmdir:
	mov	$SYS_rmdir, %eax
	jmp	_syscall

	.globl	__mmap
	.type	__mmap, @function
__mmap:
	mov	$SYS_mmap, %eax
	jmp	_syscall

	.globl	__munmap
	.type	__munmap, @function
__munmap:
	mov	$SYS_munmap, %eax
	jmp	_syscall

	.globl	__truncate
	.type	__truncate, @function
__truncate:
	mov	$SYS_truncate, %eax
	jmp	_syscall

	.globl	__ftruncate
	.type	__ftruncate, @function
__ftruncate:
	mov	$SYS_ftruncate, %eax
	jmp	_syscall

	.globl	__select
	.type	__select, @function
__select:
	mov	$SYS_select, %eax
	jmp	_syscall

	.globl	__pselect
	.type	__pselect, @function
__pselect:
	mov	$SYS_pselect, %eax
	jmp	_syscall

	.globl	__gettimeofday
	.type	__gettimeofday, @function
__gettimeofday:
	mov	$SYS_gettimeofday, %eax
	jmp	_syscall

	.globl	__settimeofday
	.type	__settimeofday, @function
__settimeofday:
	mov	$SYS_settimeofday, %eax
	jmp	_syscall

	.globl	__ioctl
	.type	__ioctl, @function
__ioctl:
	mov	$SYS_ioctl, %eax
	jmp	_syscall

	.globl	__break
	.type	__break, @function
__break:
	mov	$SYS_break, %eax
	jmp	_syscall

	.globl	__sbrk
	.type	__sbrk, @function
__sbrk:
	mov	$SYS_sbrk, %eax
	jmp	_syscall

	.globl	__getdents
	.type	__getdents, @function
__getdents:
	mov	$SYS_getdents, %eax
	jmp	_syscall

	.globl	____getcwd
	.type	____getcwd, @function
____getcwd:
	mov	$SYS_getcwd, %eax
	jmp	_syscall

_syscall:
	int	$0x80
	jnc	ret
err:	push	%eax
	call	_set_errno
	add	$0x4, %esp
ret:	ret
#endif
#endif
