#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "config.h"
#include "lib.h"
#include "objlist.h"
#include "type.h"
#include "syntax.h"
#include "model.h"
#include "typedef.h"

/*****************************************************************
 * typedef_t
 */

void typedef_print(typedef_t _typedef, int indent)
{
  indent_print(indent);
  printf("TYPEDEF: %s\n", _typedef->name);
  indent++;
  model_print(_typedef->model, indent);
}

/*****************************************************************
 * library
 */

typedef_t typedef_list_search(objlist_t list, char *name)
{
  objentry_t entry;
  typedef_t _typedef;

  for (entry = objlist_get_head(list);
       !objlist_is_end(list, entry);
       entry = objentry_get_next(entry)) {
    _typedef = objentry_get_obj(entry);
    if ((_typedef->name != NULL) && !strcmp(name, _typedef->name))
      return _typedef;
  }

  return NULL;
}
