#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef USE_SDL1
#include <SDL/SDL.h>
#endif
#ifdef USE_SDL2
#include <SDL2/SDL.h>
#endif

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "sdl.h"

#ifdef USE_SDL
static int sdl_enable = 0;

int sdl_init(void)
{
  /* Initialize at start graphic or audio */
  return 0;
}

int sdl_start(void)
{
  unsigned int flags = 0;
  static int initialized = 0;

  if (!initialized) {
#ifdef USE_SDLSIXEL
    if (getenv("SDL_VIDEODRIVER") == NULL)
      setenv("SDL_VIDEODRIVER", "sixel", 0);
#endif

    initialized = 1;
  }

  if (!sdl_enable) {
    flags |= SDL_INIT_TIMER;
#ifdef USE_GRAPHIC
    flags |= SDL_INIT_VIDEO;
#endif
#ifdef USE_AUDIO
    flags |= SDL_INIT_AUDIO;
#endif
#ifdef USE_SDL2
    flags |= SDL_INIT_EVENTS;
#endif

    SDL_Init(flags);

    sdl_enable = 1;
  }

  return 0;
}

int sdl_done(void)
{
  if (sdl_enable) {
    SDL_Quit();

    sdl_enable = 0;
  }

  return 0;
}
#endif
