void printi(int val);

int _isalpha(int c);
int _isdigit(int c);
int _islower(int c);
int _isupper(int c);

int _isalnum(int c)
{
  if (_isalpha(c) || _isdigit(c))
    return 1;
  return 0;
}

int _isalpha(int c)
{
  if (_islower(c) || _isupper(c))
    return 1;
  return 0;
}

int _isascii(int c)
{
  if ((c >= '\0') && (c <= '\x7f'))
    return 1;
  return 0;
}

int _iscntrl(int c)
{
  if (((c >= '\0') && (c <= '\x1f')) || (c == '\x7f'))
    return 1;
  return 0;
}

int _isdigit(int c)
{
  if ((c >= '0') && (c <= '9'))
    return 1;
  return 0;
}

int _isgraph(int c)
{
  if (((c >= '!') && (c <= '~')))
    return 1;
  return 0;
}

int _islower(int c)
{
  if ((c >= 'a') && (c <= 'z'))
    return 1;
  return 0;
}

int _isprint(int c)
{
  if ((c == ' ') || _isgraph(c))
    return 1;
  return 0;
}

int _ispunct(int c)
{
  if (((c >= '!') && (c <= '/')) || ((c >= ':') && (c <= '@')) ||
      ((c >= '[') && (c <= '`')) || ((c >= '{') && (c <= '~')))
    return 1;
  return 0;
}

int _isspace(int c)
{
  switch (c) {
  case '\t':
  case '\n':
  case '\v':
  case '\f':
  case '\r':
  case ' ':
    return 1;
  default:
    break;
  }
  return 0;
}

int _isupper(int c)
{
  if ((c >= 'A') && (c <= 'Z'))
    return 1;
  return 0;
}

int _isxdigit(int c)
{
  if (_isdigit(c) ||
      ((c >= 'A') && (c <= 'F')) || ((c >= 'a') && (c <= 'f')))
    return 1;
  return 0;
}

int _tolower(int c)
{
  if (_isupper(c))
    return c + ('a' - 'A');
  return c;
}

int _toupper(int c)
{
  if (_islower(c))
    return c - ('a' - 'A');
  return c;
}

int main()
{
  int i;

  for (i = 0; i < 256; i++) {
    printi(_isalnum(i));
    printi(_isalpha(i));
    printi(_isascii(i));
    printi(_iscntrl(i));
    printi(_isdigit(i));
    printi(_isgraph(i));
    printi(_islower(i));
    printi(_isprint(i));
    printi(_ispunct(i));
    printi(_isspace(i));
    printi(_isupper(i));
    printi(_isxdigit(i));
    printi(_tolower(i));
    printi(_toupper(i));
  }

  return 0;
}
