#include <errno.h>
#include <sys/ioctl.h>
#include <termios.h>
#ifdef __linux__
#include <termio.h>
#endif

#include <nllibc.h>

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)
int tcgetattr(int fd, struct termios *t)
{
  return ioctl(fd, TIOCGETA, t);
}

int tcsetattr(int fd, int action, const struct termios *t)
{
  switch (action) {
  case TCSANOW:   return ioctl(fd, TIOCSETA,  t);
  case TCSADRAIN: return ioctl(fd, TIOCSETAW, t);
  case TCSAFLUSH: return ioctl(fd, TIOCSETAF, t);
  default:
    break;
  }
  errno = EINVAL;
  return -1;
}
#endif
#if defined(__linux__)
int tcgetattr(int fd, struct termios *t)
{
  return ioctl(fd, TCGETS, t);
}

int tcsetattr(int fd, int action, const struct termios *t)
{
  switch (action) {
  case TCSANOW:   return ioctl(fd, TCSETS,  t);
  case TCSADRAIN: return ioctl(fd, TCSETSW, t);
#if TCSANOW != TCSAFLUSH /* for Termux on Android (Android SELinux rule) */
  case TCSAFLUSH: return ioctl(fd, TCSETSF, t);
#endif
  default:
    break;
  }
  errno = EINVAL;
  return -1;
}
#endif

int isatty(int fd)
{
#ifndef WIN32
  struct termios sets;
  return (tcgetattr(fd, &sets) < 0) ? 0 : 1;
#else
  return 0;
#endif
}
