#if defined(__linux__)
#if defined(__riscv) && !defined(__LP64__)

/*
 * Use Linux system call.
 */

#define SYS_exit         93
#define SYS_fork         -1
#define SYS_wait4       260
#define SYS_kill        129
#define SYS_execve      221

#define SYS_read         63
#define SYS_write        64
#define SYS_open         -1
#define SYS_close        57

#define SYS_dup          23
#define SYS_pipe         -1
#define SYS_dup2         24 /* dup3 */
#define SYS_pipe2        59

#define SYS_sigaction   134 /* rt_sigaction */
#define SYS_sigprocmask 135 /* rt_sigprocmask */
#define SYS_sigreturn   139 /* rt_sigreturn */

#define SYS_getpid      172
#define SYS_getppid     173
#define SYS_getsid      156
#define SYS_setsid      157
#define SYS_getpgid     155
#define SYS_setpgid     154
#define SYS_getpgrp      -1

#define SYS_unlink       -1
#define SYS_chdir        49
#define SYS_fchdir       50
#define SYS_chmod        -1
#define SYS_chown        -1
#define SYS_lseek        62
#define SYS_access       -1
#define SYS_sync         81
#define SYS_fcntl        25
#define SYS_fsync        82
#define SYS_fchown       55
#define SYS_fchmod       52

#define SYS_mkdir        -1
#define SYS_rmdir        -1

#define SYS_mmap        222
#define SYS_munmap      215

#define SYS_truncate     45
#define SYS_ftruncate    46

#define SYS_select       -1
#define SYS_pselect      72 /* pselect6 */

#define SYS_gettimeofday 169
#define SYS_settimeofday 170

#define SYS_ioctl        29
#define SYS_brk         214
#define SYS_getdents     61 /* getdents64 */
#define SYS_getcwd       17

	.section .text

	.globl	___exit
	.type	___exit, @function
___exit:
	li	a7, SYS_exit
	ecall
	ret

	.globl	__fork
	.type	__fork, @function
__fork:
	li	a7, SYS_fork
	ecall
	ret

	.globl	__wait4
	.type	__wait4, @function
__wait4:
	li	a7, SYS_wait4
	ecall
	ret

	.globl	__kill
	.type	__kill, @function
__kill:
	li	a7, SYS_kill
	ecall
	ret

	.globl	__execve
	.type	__execve, @function
__execve:
	li	a7, SYS_execve
	ecall
	ret

	.globl	__read
	.type	__read, @function
__read:
	li	a7, SYS_read
	ecall
	ret

	.globl	__write
	.type	__write, @function
__write:
	li	a7, SYS_write
	ecall
	ret

	.globl	__open
	.type	__open, @function
__open:
	li	a7, SYS_open
	ecall
	ret

	.globl	__close
	.type	__close, @function
__close:
	li	a7, SYS_close
	ecall
	ret

	.globl	__dup
	.type	__dup, @function
__dup:
	li	a7, SYS_dup
	ecall
	ret

	.globl	__pipe
	.type	__pipe, @function
__pipe:
	li	a7, SYS_pipe
	ecall
	ret

	.globl	__dup2
	.type	__dup2, @function
__dup2:
	li	a7, SYS_dup2
	ecall
	ret

	.globl	__pipe2
	.type	__pipe2, @function
__pipe2:
	li	a7, SYS_pipe2
	ecall
	ret

	.globl	__sigaction
	.type	__sigaction, @function
__sigaction:
	li	a7, SYS_sigaction
	ecall
	ret

	.globl	__sigprocmask
	.type	__sigprocmask, @function
__sigprocmask:
	li	a7, SYS_sigprocmask
	ecall
	ret

	.globl	__sigreturn
	.type	__sigreturn, @function
__sigreturn:
	li	a7, SYS_sigreturn
	ecall
	ret

	.globl	__getpid
	.type	__getpid, @function
__getpid:
	li	a7, SYS_getpid
	ecall
	ret

	.globl	__getppid
	.type	__getppid, @function
__getppid:
	li	a7, SYS_getppid
	ecall
	ret

	.globl	__getsid
	.type	__getsid, @function
__getsid:
	li	a7, SYS_getsid
	ecall
	ret

	.globl	__setsid
	.type	__setsid, @function
__setsid:
	li	a7, SYS_setsid
	ecall
	ret

	.globl	__getpgid
	.type	__getpgid, @function
__getpgid:
	li	a7, SYS_getpgid
	ecall
	ret

	.globl	__setpgid
	.type	__setpgid, @function
__setpgid:
	li	a7, SYS_setpgid
	ecall
	ret

	.globl	__getpgrp
	.type	__getpgrp, @function
__getpgrp:
	li	a7, SYS_getpgrp
	ecall
	ret

	.globl	__unlink
	.type	__unlink, @function
__unlink:
	li	a7, SYS_unlink
	ecall
	ret

	.globl	__chdir
	.type	__chdir, @function
__chdir:
	li	a7, SYS_chdir
	ecall
	ret

	.globl	__fchdir
	.type	__fchdir, @function
__fchdir:
	li	a7, SYS_fchdir
	ecall
	ret

	.globl	__chmod
	.type	__chmod, @function
__chmod:
	li	a7, SYS_chmod
	ecall
	ret

	.globl	__chown
	.type	__chown, @function
__chown:
	li	a7, SYS_chown
	ecall
	ret

	.globl	__lseek
	.type	__lseek, @function
__lseek:
	li	a7, SYS_lseek
	ecall
	ret

	.globl	__access
	.type	__access, @function
__access:
	li	a7, SYS_access
	ecall
	ret

	.globl	__sync
	.type	__sync, @function
__sync:
	li	a7, SYS_sync
	ecall
	ret

	.globl	__fcntl
	.type	__fcntl, @function
__fcntl:
	li	a7, SYS_fcntl
	ecall
	ret

	.globl	__fsync
	.type	__fsync, @function
__fsync:
	li	a7, SYS_fsync
	ecall
	ret

	.globl	__fchown
	.type	__fchown, @function
__fchown:
	li	a7, SYS_fchown
	ecall
	ret

	.globl	__fchmod
	.type	__fchmod, @function
__fchmod:
	li	a7, SYS_fchmod
	ecall
	ret

	.globl	__mkdir
	.type	__mkdir, @function
__mkdir:
	li	a7, SYS_mkdir
	ecall
	ret

	.globl	__rmdir
	.type	__rmdir, @function
__rmdir:
	li	a7, SYS_rmdir
	ecall
	ret

	.globl	__mmap
	.type	__mmap, @function
__mmap:
	li	a7, SYS_mmap
	ecall
	ret

	.globl	__munmap
	.type	__munmap, @function
__munmap:
	li	a7, SYS_munmap
	ecall
	ret

	.globl	__truncate
	.type	__truncate, @function
__truncate:
	li	a7, SYS_truncate
	ecall
	ret

	.globl	__ftruncate
	.type	__ftruncate, @function
__ftruncate:
	li	a7, SYS_ftruncate
	ecall
	ret

	.globl	__select
	.type	__select, @function
__select:
	li	a7, SYS_select
	ecall
	ret

	.globl	__pselect
	.type	__pselect, @function
__pselect:
	li	a7, SYS_pselect
	ecall
	ret

	.globl	__gettimeofday
	.type	__gettimeofday, @function
__gettimeofday:
	li	a7, SYS_gettimeofday
	ecall
	ret

	.globl	__settimeofday
	.type	__settimeofday, @function
__settimeofday:
	li	a7, SYS_settimeofday
	ecall
	ret

	.globl	__ioctl
	.type	__ioctl, @function
__ioctl:
	li	a7, SYS_ioctl
	ecall
	ret

	.globl	__brk
	.type	__brk, @function
__brk:
	li	a7, SYS_brk
	ecall
	ret

	.globl	__getdents
	.type	__getdents, @function
__getdents:
	li	a7, SYS_getdents
	ecall
	ret

	.globl	____getcwd
	.type	____getcwd, @function
____getcwd:
	li	a7, SYS_getcwd
	ecall
	ret
#endif
#endif
