#ifndef __NLLIBC_FCNTL_H_INCLUDED__
#define __NLLIBC_FCNTL_H_INCLUDED__

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)
#define O_RDONLY   0x0000
#define O_WRONLY   0x0001
#define O_RDWR     0x0002
#define O_ACCMODE  0x0003
#define O_NONBLOCK 0x0004
#define O_APPEND   0x0008
#define O_CREAT    0x0200
#define O_TRUNC    0x0400
#endif

#if defined(__linux__)
#define O_RDONLY   00000
#define O_WRONLY   00001
#define O_RDWR     00002
#define O_ACCMODE  00003
#define O_NONBLOCK 04000
#define O_APPEND   02000
#define O_CREAT    00100
#define O_TRUNC    01000
#endif

#ifdef WIN32
#define O_RDONLY   0x0000
#define O_WRONLY   0x0001
#define O_RDWR     0x0002
#define O_ACCMODE  0x0003
#define O_APPEND   0x0008
#define O_CREAT    0x0100
#define O_TRUNC    0x0200
#endif

#define F_DUPFD 0
#define F_GETFD 1
#define F_SETFD 2
#define F_GETFL 3
#define F_SETFL 4

int open(const char *path, int flags, ...);

int fcntl(int fd, int cmd, int args);

#endif
