#ifndef __NLSYS_DEFINES_H_INCLUDED__
#define __NLSYS_DEFINES_H_INCLUDED__

typedef struct _defines *defines_t;

#include "type.h"
#include "objlist.h"
#include "symbol.h"
#include "struct.h"
#include "union.h"
#include "enum.h"
#include "typedef.h"
#include "defines.h"

struct _defines {
  struct objentry entry;
  struct objlist symbol_list;
  struct objlist struct_list;
  struct objlist union_list;
  struct objlist enum_list;
  struct objlist typedef_list;
};

/*****************************************************************
 * defines_t
 */

defines_t defines_destroy(defines_t defines);
defines_t defines_create(void);

/*****************************************************************
 * library
 */

/* search */
symbol_t defines_list_search_symbol_name(objlist_t defines_list, char *name);
struct_t defines_list_search_struct_name(objlist_t defines_list, char *name);
union_t defines_list_search_union_name(objlist_t defines_list, char *name);
enum_t defines_list_search_enum_name(objlist_t defines_list, char *name);
typedef_t defines_list_search_typedef_name(objlist_t defines_list, char *name);

/* get */
objlist_t defines_list_get_symbol_list(objlist_t defines_list);
objlist_t defines_list_get_struct_list(objlist_t defines_list);
objlist_t defines_list_get_union_list(objlist_t defines_list);
objlist_t defines_list_get_enum_list(objlist_t defines_list);
objlist_t defines_list_get_typedef_list(objlist_t defines_list);

/* insert */
symbol_t defines_list_insert_symbol(objlist_t defines_list, symbol_t symbol);
struct_t defines_list_insert_struct(objlist_t defines_list, struct_t _struct);
union_t defines_list_insert_union(objlist_t defines_list, union_t _union);
enum_t defines_list_insert_enum(objlist_t defines_list, enum_t _enum);
typedef_t defines_list_insert_typedef(objlist_t defines_list, typedef_t _typedef);

/* delete */
symbol_t defines_list_delete_symbol(objlist_t defines_list, symbol_t symbol);
struct_t defines_list_delete_struct(objlist_t defines_list, struct_t _struct);
union_t defines_list_delete_union(objlist_t defines_list, union_t _union);
enum_t defines_list_delete_enum(objlist_t defines_list, enum_t _enum);
typedef_t defines_list_delete_typedef(objlist_t defines_list, typedef_t _typedef);

#endif
