/*
 * __nlcc_attr_funcnoinit:
 * The function defined this attribute is called by the assembly output,
 * and restrains calling of the builtin memcpy() to initialization of the
 * automatic variables. (See: asm_symbol.c:asm_symbol_function())
 * This attribute is to avoid a recursive call between the assembly output
 * of the builtin memcpy() and other builtin functions.
 * But, initialization of the automatic variables is not processed,
 * you cannot give an initial value to automatic variable of the function
 * defined this attribute.
 *
 * Example:
 *
 * __nlcc_attr_funcnoinit
 * static int __builtin_NG_sample(int arg)
 * {
 *   int ng = 0;  ...not initialized!
 *   ...
 * }
 *
 * __nlcc_attr_funcnoinit
 * static int __builtin_OK_sample(int arg)
 * {
 *   int ok;
 *   ok = 0;
 *   ...
 * }
 */

char *builtin_symbols =
"typedef long *__builtin_va_list;\n"
"long __builtin_va_arg(__nlcc_type_symbol __builtin_va_list arg, __nlcc_type_type int type);\n"
"void __builtin_va_start(__nlcc_type_symbol __builtin_va_list arg, __nlcc_type_symbol int symbol);\n"
"void __builtin_va_end(__nlcc_type_symbol __builtin_va_list arg);\n"
"\n"

"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static void *__builtin_memcpy(void *dst, const void *src, int len)\n"
"{\n"
"  int i;\n"
"  char *d;\n"
"  const char *s;\n"
"  d = dst;\n"
"  s = src;\n"
"  for (i = 0; i < len; i++)\n"
"    d[i] = s[i];\n"
"  return dst;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static void *__builtin_memcpy4(void *dst, const void *src, int len)\n"
"{\n"
"  int i;\n"
"  int *d;\n"
"  const int *s;\n"
"  d = dst;\n"
"  s = src;\n"
"  for (i = 0; i < len; i++)\n"
"    d[i] = s[i];\n"
"  return dst;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static void *__builtin_memcpy16(void *dst, const void *src, int len)\n"
"{\n"
"  int i;\n"
"  int *d;\n"
"  const int *s;\n"
"  d = dst;\n"
"  s = src;\n"
"  for (i = 0; i < len; i++) {\n"
"    *(d++) = *(s++);\n"
"    *(d++) = *(s++);\n"
"    *(d++) = *(s++);\n"
"    *(d++) = *(s++);\n"
"  }\n"
"  return dst;\n"
"}\n"
"\n"

"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static long __builtin_bitfield_read(long val, int size, int bits, int shift)\n"
"{\n"
"  int high;\n"
"  high = (sizeof(long) * 8) - (bits + shift);\n"
"  val <<= high;\n"
"  val >>= high + shift;\n"
"  return val;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_bitfield_uread(unsigned long val, int size, int bits, int shift)\n"
"{\n"
"  int high;\n"
"  high = (sizeof(long) * 8) - (bits + shift);\n"
"  val <<= high;\n"
"  val >>= high + shift;\n"
"  return val;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_bitfield_write(unsigned long val, unsigned long wval, int size, int bits, int shift)\n"
"{\n"
"  int high;\n"
"  unsigned long mask;\n"
"  mask = ~0L;\n"
"  high = (sizeof(long) * 8) - (bits + shift);\n"
"  mask <<= high + shift;\n"
"  mask >>= high;\n"
"  val <<= shift;\n"
"  val &= mask;\n"
"  wval &= ~mask;\n"
"  wval |= val;\n"
"  return wval;\n"
"}\n"
"\n"

"/*\n"
" * To prevent the recursive call of sign extension,\n"
" * the functions are separated and simplified.\n"
" */\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_extension_uchar(unsigned long val)\n"
"{\n"
"  return val & 0xffUL;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_extension_char(unsigned long val)\n"
"{\n"
"  if (val & 0x80UL)\n"
"    return val | ~0xffUL;\n"
"  return val & 0xffUL;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_extension_ushort(unsigned long val)\n"
"{\n"
"  return val & 0xffffUL;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_extension_short(unsigned long val)\n"
"{\n"
"  if (val & 0x8000UL)\n"
"    return val | ~0xffffUL;\n"
"  return val & 0xffffUL;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_extension_uint(unsigned long val)\n"
"{\n"
"  return val & 0xffffffffUL;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_extension_int(unsigned long val)\n"
"{\n"
"  if (val & 0x80000000UL)\n"
"    return val | ~0xffffffffUL;\n"
"  return val & 0xffffffffUL;\n"
"}\n"
"\n"

"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static long __builtin_inv(long val)\n"
"{\n"
"  return val ^ -1L;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static long __builtin_minus(long val)\n"
"{\n"
"  return 0L - val;\n"
"}\n"
"\n"

"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_xor_ulong(unsigned long val, unsigned long xor, int bits)\n"
"{\n"
"  return (val | xor) - (val & xor);\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned int __builtin_xor_uint(unsigned int val, unsigned int xor, int bits)\n"
"{\n"
"  return (val | xor) - (val & xor);\n"
"}\n"
"\n"

"static unsigned long __builtin_mask_array[] = {\n"
"  0x00000001UL, 0x00000002UL, 0x00000004UL, 0x00000008UL,\n"
"  0x00000010UL, 0x00000020UL, 0x00000040UL, 0x00000080UL,\n"
"  0x00000100UL, 0x00000200UL, 0x00000400UL, 0x00000800UL,\n"
"  0x00001000UL, 0x00002000UL, 0x00004000UL, 0x00008000UL,\n"
"  0x00010000UL, 0x00020000UL, 0x00040000UL, 0x00080000UL,\n"
"  0x00100000UL, 0x00200000UL, 0x00400000UL, 0x00800000UL,\n"
"  0x01000000UL, 0x02000000UL, 0x04000000UL, 0x08000000UL,\n"
"  0x10000000UL, 0x20000000UL, 0x40000000UL, 0x80000000UL,\n"
"  /* 64bit values */\n"
"  0x00000001UL<<32, 0x00000002UL<<32, 0x00000004UL<<32, 0x00000008UL<<32,\n"
"  0x00000010UL<<32, 0x00000020UL<<32, 0x00000040UL<<32, 0x00000080UL<<32,\n"
"  0x00000100UL<<32, 0x00000200UL<<32, 0x00000400UL<<32, 0x00000800UL<<32,\n"
"  0x00001000UL<<32, 0x00002000UL<<32, 0x00004000UL<<32, 0x00008000UL<<32,\n"
"  0x00010000UL<<32, 0x00020000UL<<32, 0x00040000UL<<32, 0x00080000UL<<32,\n"
"  0x00100000UL<<32, 0x00200000UL<<32, 0x00400000UL<<32, 0x00800000UL<<32,\n"
"  0x01000000UL<<32, 0x02000000UL<<32, 0x04000000UL<<32, 0x08000000UL<<32,\n"
"  0x10000000UL<<32, 0x20000000UL<<32, 0x40000000UL<<32, 0x80000000UL<<32,\n"
"};\n"
"\n"
"/* This type must be unsigned char to avoid multiplication for arrays */\n"
"static unsigned char __builtin_ulong_size[] = {\n"
"  sizeof(unsigned long) *  0, sizeof(unsigned long) *  1,\n"
"  sizeof(unsigned long) *  2, sizeof(unsigned long) *  3,\n"
"  sizeof(unsigned long) *  4, sizeof(unsigned long) *  5,\n"
"  sizeof(unsigned long) *  6, sizeof(unsigned long) *  7,\n"
"  sizeof(unsigned long) *  8, sizeof(unsigned long) *  9,\n"
"  sizeof(unsigned long) * 10, sizeof(unsigned long) * 11,\n"
"  sizeof(unsigned long) * 12, sizeof(unsigned long) * 13,\n"
"  sizeof(unsigned long) * 14, sizeof(unsigned long) * 15,\n"
"  sizeof(unsigned long) * 16, sizeof(unsigned long) * 17,\n"
"  sizeof(unsigned long) * 18, sizeof(unsigned long) * 19,\n"
"  sizeof(unsigned long) * 20, sizeof(unsigned long) * 21,\n"
"  sizeof(unsigned long) * 22, sizeof(unsigned long) * 23,\n"
"  sizeof(unsigned long) * 24, sizeof(unsigned long) * 25,\n"
"  sizeof(unsigned long) * 26, sizeof(unsigned long) * 27,\n"
"  sizeof(unsigned long) * 28, sizeof(unsigned long) * 29,\n"
"  sizeof(unsigned long) * 30, sizeof(unsigned long) * 31,\n"
"};\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_mask(int n)\n"
"{\n"
"  int offset;\n"
"\n"
"  /* return mask[n]; */ /* Make it declined to avoid multiplication at the pointer calculation */\n"
"\n"
"  /* To avoid a recursive calling of the buildin-left-shift and the buildin-multiplication */\n"
"  if (n < 32) {\n"
"    offset = __builtin_ulong_size[n];\n"
"  } else {\n"
"    /* It is calculated, because the value is outside the range of unsigned char */\n"
"    offset = __builtin_ulong_size[n - 32];\n"
"    offset += sizeof(unsigned long) * 32;\n"
"  }\n"
"  return *(unsigned long *)((char *)__builtin_mask_array + offset);\n"
"}\n"
"\n"
"static unsigned long __builtin_lshldi3(unsigned long val, int s, int bits);\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static long __builtin_ashldi3(long val, int s, int bits) /* left shift arithmetic */\n"
"{\n"
"  return __builtin_lshldi3(val, s, bits);\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_lshldi3(unsigned long val, int s, int bits) /* left shift logical */\n"
"{\n"
"  unsigned long v;\n"
"  int i;\n"
"\n"
"  v = 0;\n"
"  s &= (bits - 1);\n"
"\n"
"  for (i = 0; i < bits; i++) {\n"
"    if (i >= s) {\n"
"      if (val & __builtin_mask(i - s))\n"
"        v |= __builtin_mask(i);\n"
"    }\n"
"  }\n"
"\n"
"  return v;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static long __builtin_ashrdi3(long val, int s, int bits) /* right shift arithmetic */\n"
"{\n"
"  unsigned long v;\n"
"  int i;\n"
"\n"
"  v = 0;\n"
"  s &= (bits - 1);\n"
"\n"
"  for (i = 0; i < bits; i++) {\n"
"    if (i + s < bits) {\n"
"      if (val & __builtin_mask(i + s))\n"
"        v |= __builtin_mask(i);\n"
"    } else {\n"
"      if (val & __builtin_mask(bits - 1))\n"
"        v |= __builtin_mask(i);\n"
"    }\n"
"  }\n"
"\n"
"  return v;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_lshrdi3(unsigned long val, int s, int bits) /* right shift logical */\n"
"{\n"
"  unsigned long v;\n"
"  int i;\n"
"\n"
"  v = 0;\n"
"  s &= (bits - 1);\n"
"\n"
"  for (i = 0; i < bits; i++) {\n"
"    if (i + s < bits) {\n"
"      if (val & __builtin_mask(i + s))\n"
"        v |= __builtin_mask(i);\n"
"    }\n"
"  }\n"
"\n"
"  return v;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static int __builtin_ashlsi3(int val, int s, int bits) /* left shift arithmetic */\n"
"{\n"
"  return __builtin_ashldi3(val, s, bits);\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned int __builtin_lshlsi3(unsigned int val, int s, int bits) /* left shift logical */\n"
"{\n"
"  return __builtin_lshldi3(val, s, bits);\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static int __builtin_ashrsi3(int val, int s, int bits) /* right shift arithmetic */\n"
"{\n"
"  return __builtin_ashrdi3(val, s, bits);\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned int __builtin_lshrsi3(unsigned int val, int s, int bits) /* right shift logical */\n"
"{\n"
"  return __builtin_lshrdi3(val, s, bits);\n"
"}\n"
"\n"

"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_div_ulong(unsigned long val, unsigned long div, int bits, int isrem)\n"
"{\n"
"  unsigned long div2n, quot, rem;\n"
"  unsigned long n;\n"
"\n"
"  if (div == 0)\n"
"    *(int *)0 = 0;\n"
"\n"
"  div2n = div;\n"
"  for (n = 1; ((div2n < val) && ((long)div2n > 0)); n <<= 1)\n"
"    div2n <<= 1;\n"
"\n"
"  rem = val;\n"
"  for (quot = 0; rem >= div; quot += n) {\n"
"    for (; div2n > rem; n >>= 1)\n"
"      div2n >>= 1;\n"
"    rem -= div2n;\n"
"  }\n"
"\n"
"  return isrem ? rem : quot;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static long __builtin_divdi3(long val, long div, int bits)\n"
"{\n"
"  long r;\n"
"  int minus;\n"
"\n"
"  minus = 0;\n"
"  if (val < 0) {\n"
"    val = -val;\n"
"    minus = !minus;\n"
"  }\n"
"  if (div < 0) {\n"
"    div = -div;\n"
"    minus = !minus;\n"
"  }\n"
"\n"
"  r = __builtin_div_ulong(val, div, bits, 0);\n"
"\n"
"  return minus ? -r : r;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static long __builtin_moddi3(long val, long div, int bits)\n"
"{\n"
"  long r;\n"
"  int minus;\n"
"\n"
"  minus = 0;\n"
"  if (val < 0) {\n"
"    val = -val;\n"
"    minus = !minus;\n"
"  }\n"
"  if (div < 0) {\n"
"    div = -div;\n"
"  }\n"
"\n"
"  r = __builtin_div_ulong(val, div, bits, 1);\n"
"\n"
"  return minus ? -r : r;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_udivdi3(unsigned long val, unsigned long div, int bits)\n"
"{\n"
"  return __builtin_div_ulong(val, div, bits, 0);\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_umoddi3(unsigned long val, unsigned long div, int bits)\n"
"{\n"
"  return __builtin_div_ulong(val, div, bits, 1);\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static int __builtin_divsi3(int val, int div, int bits)\n"
"{\n"
"  return __builtin_divdi3(val, div, bits);\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static int __builtin_modsi3(int val, int div, int bits)\n"
"{\n"
"  return __builtin_moddi3(val, div, bits);\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned int __builtin_udivsi3(unsigned int val, unsigned int div, int bits)\n"
"{\n"
"  return __builtin_udivdi3(val, div, bits);\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned int __builtin_umodsi3(unsigned int val, unsigned int div, int bits)\n"
"{\n"
"  return __builtin_umoddi3(val, div, bits);\n"
"}\n"
"\n"

"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_mul_ulong(unsigned long val, unsigned long mul, int bits)\n"
"{\n"
"  unsigned long val2n, r;\n"
"  unsigned long n;\n"
"\n"
"  val2n = val;\n"
"  for (n = 1; ((n < mul) && ((long)val2n > 0)); n <<= 1)\n"
"    val2n <<= 1;\n"
"\n"
"  for (r = 0; mul > 0; mul -= n) {\n"
"    for (; n > mul; n >>= 1)\n"
"      val2n >>= 1;\n"
"    r += val2n;\n"
"  }\n"
"\n"
"  return r;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned int __builtin_mul_uint(unsigned int val, unsigned int mul, int bits)\n"
"{\n"
"  unsigned int val2n, r;\n"
"  unsigned int n;\n"
"\n"
"  val2n = val;\n"
"  for (n = 1; ((n < mul) && ((int)val2n > 0)); n <<= 1)\n"
"    val2n <<= 1;\n"
"\n"
"  for (r = 0; mul > 0; mul -= n) {\n"
"    for (; n > mul; n >>= 1)\n"
"      val2n >>= 1;\n"
"    r += val2n;\n"
"  }\n"
"\n"
"  return r;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static long __builtin_muldi3(long val, long mul, int bits)\n"
"{\n"
"  long r;\n"
"  int minus;\n"
"\n"
"  minus = 0;\n"
"  if (val < 0) {\n"
"    val = -val;\n"
"    minus = !minus;\n"
"  }\n"
"  if (mul < 0) {\n"
"    mul = -mul;\n"
"    minus = !minus;\n"
"  }\n"
"\n"
"  r = __builtin_mul_ulong(val, mul, bits);\n"
"\n"
"  return minus ? -r : r;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned long __builtin_umuldi3(unsigned long val, unsigned long mul, int bits)\n"
"{\n"
"  return __builtin_muldi3(val, mul, bits);\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static int __builtin_mulsi3(int val, int mul, int bits)\n"
"{\n"
"  int r;\n"
"  int minus;\n"
"\n"
"  minus = 0;\n"
"  if (val < 0) {\n"
"    val = -val;\n"
"    minus = !minus;\n"
"  }\n"
"  if (mul < 0) {\n"
"    mul = -mul;\n"
"    minus = !minus;\n"
"  }\n"
"\n"
"  r = __builtin_mul_uint(val, mul, bits);\n"
"\n"
"  return minus ? -r : r;\n"
"}\n"
"\n"
"__nlcc_attr_funcnoinit /* used in the processing of assembly output */\n"
"static unsigned int __builtin_umulsi3(unsigned int val, unsigned int mul, int bits)\n"
"{\n"
"  return __builtin_mulsi3(val, mul, bits);\n"
"}\n"
"\n"

"static unsigned short __builtin_bswap16(unsigned short val)\n"
"{\n"
"  return (val >> 8) | (val << 8);\n"
"}\n"
"static unsigned int __builtin_bswap32(unsigned int val)\n"
"{\n"
"  return __builtin_bswap16(val >> 16) | (__builtin_bswap16(val) << 16);\n"
"}\n"
"static unsigned long long __builtin_bswap64(unsigned long long val)\n"
"{\n"
"  return __builtin_bswap32(val);\n"
"}\n"
"\n"
"# 1\n";
