#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "config.h"
#include "lib.h"
#include "objlist.h"
#include "type.h"
#include "syntax.h"
#include "symbol.h"
#include "asm.h"
#include "asm_syntax.h"
#include "asm_symbol.h"

int asm_syntax_list(FILE *out, objlist_t syntax_list, symbol_t function)
{
  objentry_t entry;
  syntax_t syntax;

  for (entry = objlist_get_head(syntax_list);
       !objlist_is_end(syntax_list, entry);
       entry = objentry_get_next(entry)) {
    syntax = objentry_get_syntax(entry);
    asm_syntax(out, syntax, function);
  }

  return 0;
}

int asm_symbol_list(FILE *out, objlist_t symbol_list)
{
  objentry_t entry;
  symbol_t symbol;

  for (entry = objlist_get_head(symbol_list);
       !objlist_is_end(symbol_list, entry);
       entry = objentry_get_next(entry)) {
    symbol = objentry_get_obj(entry);
    asm_symbol(out, symbol);
  }

  return 0;
}
