#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>

#ifdef USE_MATHLIB
#include <math.h>
#endif
#ifndef WIN32
#include <sys/socket.h>
#else
#include <winsock2.h>
#endif

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "const.h"
#include "nlltypes.h"
#include "value.h"
#include "key.h"
#include "constval.h"

const struct const_variable const_variables[] = {
#ifdef NLL_VERSION
  { "VERSION"     , VALUE_FLAG_CONST, VALUE_TYPE_STRING   , 0, NLL_VERSION        , NULL },
#endif

  { "UNDEF"       , VALUE_FLAG_RDONLY,VALUE_TYPE_UNDEFINED, 0               , NULL, NULL },
  { "NULL"        , VALUE_FLAG_CONST, VALUE_TYPE_NULL     , 0               , NULL, NULL },
  { "NULLSTR"     , VALUE_FLAG_CONST, VALUE_TYPE_STRING   , 0               , NULL, NULL },
  { "NULLARRAY"   , VALUE_FLAG_CONST, VALUE_TYPE_ARRAY    , 0               , NULL, NULL },
  { "NULLMEM"     , VALUE_FLAG_CONST, VALUE_TYPE_AREA     , 0               , NULL, NULL },
  { "NULLPTR"     , VALUE_FLAG_CONST, VALUE_TYPE_POINTER  , 0               , NULL, NULL },
  { "NULLFUNC"    , VALUE_FLAG_CONST, VALUE_TYPE_FUNCTION , 0               , NULL, NULL },
  { "NULLLABEL"   , VALUE_FLAG_CONST, VALUE_TYPE_LABEL    , 0               , NULL, NULL },

  { "T_UNKNOWN"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_UNKNOWN   , NULL, NULL },
  { "T_UNDEFINED" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_UNDEFINED , NULL, NULL },
  { "T_NULL"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_NULL      , NULL, NULL },
  { "T_VALUE"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_VALUE     , NULL, NULL },
  { "T_VECTOR"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_VECTOR    , NULL, NULL },
  { "T_INTEGER"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_INTEGER   , NULL, NULL },
  { "T_STRING"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_STRING    , NULL, NULL },
#ifdef NLL_FLOATING_POINT
  { "T_FLOAT"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_FLOAT     , NULL, NULL },
#endif
  { "T_ARRAY"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_ARRAY     , NULL, NULL },
  { "T_AREA"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_AREA      , NULL, NULL },
  { "T_POINTER"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_POINTER   , NULL, NULL },
  { "T_FUNCTION"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_FUNCTION  , NULL, NULL },
  { "T_LABEL"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_T_LABEL     , NULL, NULL },

  { "D_VARIABLE"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_D_VARIABLE  , NULL, NULL },
  { "D_STRING"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_D_STRING    , NULL, NULL },
  { "D_LABEL"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_D_LABEL     , NULL, NULL },
  { "D_LINE"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_D_LINE      , NULL, NULL },
  { "D_STACK"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_D_STACK     , NULL, NULL },
  { "D_POSITION"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_D_POSITION  , NULL, NULL },
  { "D_ALL"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_D_ALL       , NULL, NULL },
  { "L_COMMAND"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_L_COMMAND   , NULL, NULL },
  { "L_FUNCTION"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_L_FUNCTION  , NULL, NULL },
  { "L_CONST"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_L_CONST     , NULL, NULL },
  { "L_OPERATOR"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_L_OPERATOR  , NULL, NULL },

#ifdef USE_FRAMEBUF
  { "F_DISABLE"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_F_DISABLE   , NULL, NULL },
  { "F_ENABLE"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_F_ENABLE    , NULL, NULL },
  { "F_BUFFER"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_F_BUFFER    , NULL, NULL },
  { "F_FLUSH"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_F_FLUSH     , NULL, NULL },
  { "F_CURSOR"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_F_CURSOR    , NULL, NULL },
  { "F_CURSES"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_F_CURSES    , NULL, NULL },
  { "F_FORCE"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_F_FORCE     , NULL, NULL },

  { "F_FILL"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_F_FILL      , NULL, NULL },

  { "F_CURSORPOS" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_F_CURSORPOS , NULL, NULL },

  { "C_RESET"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_C_RESET     , NULL, NULL },
  { "C_BLACK"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_C_BLACK     , NULL, NULL },
  { "C_RED"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_C_RED       , NULL, NULL },
  { "C_GREEN"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_C_GREEN     , NULL, NULL },
  { "C_YELLOW"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_C_YELLOW    , NULL, NULL },
  { "C_BLUE"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_C_BLUE      , NULL, NULL },
  { "C_MAGENTA"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_C_MAGENTA   , NULL, NULL },
  { "C_CYAN"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_C_CYAN      , NULL, NULL },
  { "C_WHITE"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_C_WHITE     , NULL, NULL },

  { "A_RESET"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_RESET     , NULL, NULL },
  { "A_BOLD"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_BOLD      , NULL, NULL },
  { "A_FAINT"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_FAINT     , NULL, NULL },
  { "A_ITALIC"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_ITALIC    , NULL, NULL },
  { "A_UNDERLINE" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_UNDERLINE , NULL, NULL },
  { "A_BLINK"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_BLINK     , NULL, NULL },
  { "A_RAPIDBLINK", VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_RAPIDBLINK, NULL, NULL },
  { "A_INVERSE"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_INVERSE   , NULL, NULL },
  { "A_INVISIBLE" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_INVISIBLE , NULL, NULL },
  { "A_CROSSOUT"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_CROSSOUT  , NULL, NULL },
#endif

  { "KEY_ENTER"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_ENTER       , NULL, NULL },
  { "KEY_ESCAPE"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_ESCAPE      , NULL, NULL },
  { "KEY_BACKSPACE"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_BACKSPACE   , NULL, NULL },
  { "KEY_TAB"         , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_TAB         , NULL, NULL },
  { "KEY_SPACE"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_SPACE       , NULL, NULL },
  { "KEY_EXCLAIM"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_EXCLAIM     , NULL, NULL },
  { "KEY_QUOTEDBL"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_QUOTEDBL    , NULL, NULL },
  { "KEY_HASH"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_HASH        , NULL, NULL },
  { "KEY_PERCENT"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_PERCENT     , NULL, NULL },
  { "KEY_DOLLAR"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_DOLLAR      , NULL, NULL },
  { "KEY_AMPERSAND"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_AMPERSAND   , NULL, NULL },
  { "KEY_QUOTE"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_QUOTE       , NULL, NULL },
  { "KEY_LEFTPAREN"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_LEFTPAREN   , NULL, NULL },
  { "KEY_RIGHTPAREN"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_RIGHTPAREN  , NULL, NULL },
  { "KEY_ASTERISK"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_ASTERISK    , NULL, NULL },
  { "KEY_PLUS"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_PLUS        , NULL, NULL },
  { "KEY_COMMA"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_COMMA       , NULL, NULL },
  { "KEY_MINUS"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_MINUS       , NULL, NULL },
  { "KEY_PERIOD"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_PERIOD      , NULL, NULL },
  { "KEY_SLASH"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_SLASH       , NULL, NULL },
  { "KEY_0"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_0           , NULL, NULL },
  { "KEY_1"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_1           , NULL, NULL },
  { "KEY_2"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_2           , NULL, NULL },
  { "KEY_3"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_3           , NULL, NULL },
  { "KEY_4"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_4           , NULL, NULL },
  { "KEY_5"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_5           , NULL, NULL },
  { "KEY_6"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_6           , NULL, NULL },
  { "KEY_7"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_7           , NULL, NULL },
  { "KEY_8"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_8           , NULL, NULL },
  { "KEY_9"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_9           , NULL, NULL },
  { "KEY_COLON"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_COLON       , NULL, NULL },
  { "KEY_SEMICOLON"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_SEMICOLON   , NULL, NULL },
  { "KEY_LESS"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_LESS        , NULL, NULL },
  { "KEY_EQUALS"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_EQUALS      , NULL, NULL },
  { "KEY_GREATER"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_GREATER     , NULL, NULL },
  { "KEY_QUESTION"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_QUESTION    , NULL, NULL },
  { "KEY_AT"          , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_AT          , NULL, NULL },
  { "KEY_LEFTBRACKET" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_LEFTBRACKET , NULL, NULL },
  { "KEY_BACKSLASH"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_BACKSLASH   , NULL, NULL },
  { "KEY_RIGHTBRACKET", VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_RIGHTBRACKET, NULL, NULL },
  { "KEY_CARET"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_CARET       , NULL, NULL },
  { "KEY_UNDERSCORE"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_UNDERSCORE  , NULL, NULL },
  { "KEY_BACKQUOTE"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_BACKQUOTE   , NULL, NULL },
  { "KEY_A"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_A           , NULL, NULL },
  { "KEY_B"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_B           , NULL, NULL },
  { "KEY_C"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_C           , NULL, NULL },
  { "KEY_D"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_D           , NULL, NULL },
  { "KEY_E"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_E           , NULL, NULL },
  { "KEY_F"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F           , NULL, NULL },
  { "KEY_G"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_G           , NULL, NULL },
  { "KEY_H"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_H           , NULL, NULL },
  { "KEY_I"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_I           , NULL, NULL },
  { "KEY_J"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_J           , NULL, NULL },
  { "KEY_K"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_K           , NULL, NULL },
  { "KEY_L"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_L           , NULL, NULL },
  { "KEY_M"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_M           , NULL, NULL },
  { "KEY_N"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_N           , NULL, NULL },
  { "KEY_O"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_O           , NULL, NULL },
  { "KEY_P"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_P           , NULL, NULL },
  { "KEY_Q"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_Q           , NULL, NULL },
  { "KEY_R"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_R           , NULL, NULL },
  { "KEY_S"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_S           , NULL, NULL },
  { "KEY_T"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_T           , NULL, NULL },
  { "KEY_U"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_U           , NULL, NULL },
  { "KEY_V"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_V           , NULL, NULL },
  { "KEY_W"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_W           , NULL, NULL },
  { "KEY_X"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_X           , NULL, NULL },
  { "KEY_Y"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_Y           , NULL, NULL },
  { "KEY_Z"           , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_Z           , NULL, NULL },

  { "KEY_CAPSLOCK"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_CAPSLOCK    , NULL, NULL },
  { "KEY_F1"          , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F1          , NULL, NULL },
  { "KEY_F2"          , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F2          , NULL, NULL },
  { "KEY_F3"          , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F3          , NULL, NULL },
  { "KEY_F4"          , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F4          , NULL, NULL },
  { "KEY_F5"          , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F5          , NULL, NULL },
  { "KEY_F6"          , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F6          , NULL, NULL },
  { "KEY_F7"          , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F7          , NULL, NULL },
  { "KEY_F8"          , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F8          , NULL, NULL },
  { "KEY_F9"          , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F9          , NULL, NULL },
  { "KEY_F10"         , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F10         , NULL, NULL },
  { "KEY_F11"         , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F11         , NULL, NULL },
  { "KEY_F12"         , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F12         , NULL, NULL },

  { "KEY_PRINTSCREEN" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_PRINTSCREEN , NULL, NULL },
  { "KEY_SCROLLLOCK"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_SCROLLLOCK  , NULL, NULL },
  { "KEY_PAUSE"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_PAUSE       , NULL, NULL },
  { "KEY_INSERT"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_INSERT      , NULL, NULL },
  { "KEY_HOME"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_HOME        , NULL, NULL },
  { "KEY_PAGEUP"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_PAGEUP      , NULL, NULL },
  { "KEY_DELETE"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_DELETE      , NULL, NULL },
  { "KEY_END"         , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_END         , NULL, NULL },
  { "KEY_PAGEDOWN"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_PAGEDOWN    , NULL, NULL },
  { "KEY_RIGHT"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_RIGHT       , NULL, NULL },
  { "KEY_LEFT"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_LEFT        , NULL, NULL },
  { "KEY_DOWN"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_DOWN        , NULL, NULL },
  { "KEY_UP"          , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_UP          , NULL, NULL },

  { "KEY_F13"         , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F13         , NULL, NULL },
  { "KEY_F14"         , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F14         , NULL, NULL },
  { "KEY_F15"         , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_F15         , NULL, NULL },

  { "KEY_LCTRL"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_LCTRL       , NULL, NULL },
  { "KEY_LSHIFT"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_LSHIFT      , NULL, NULL },
  { "KEY_LALT"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_LALT        , NULL, NULL },
  { "KEY_RCTRL"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_RCTRL       , NULL, NULL },
  { "KEY_RSHIFT"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_RSHIFT      , NULL, NULL },
  { "KEY_RALT"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , KEY_CODE_RALT        , NULL, NULL },

#ifdef O_RDONLY
  { "O_RDONLY"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , O_RDONLY        , NULL, NULL },
#endif
#ifdef O_WRONLY
  { "O_WRONLY"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , O_WRONLY        , NULL, NULL },
#endif
#ifdef O_RDWR
  { "O_RDWR"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , O_RDWR          , NULL, NULL },
#endif
#ifdef O_ACCMODE
  { "O_ACCMODE"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , O_ACCMODE       , NULL, NULL },
#endif
#ifdef O_APPEND
  { "O_APPEND"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , O_APPEND        , NULL, NULL },
#endif
#ifdef O_CREAT
  { "O_CREAT"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , O_CREAT         , NULL, NULL },
#endif
#ifdef O_TRUNC
  { "O_TRUNC"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , O_TRUNC         , NULL, NULL },
#endif
#ifdef WIN32
#ifdef O_TEXT
  { "O_TEXT"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , O_TEXT          , NULL, NULL },
#endif
#ifdef O_BINARY
  { "O_BINARY"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , O_BINARY        , NULL, NULL },
#endif
#endif

#ifdef SEEK_SET
  { "SEEK_SET"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , SEEK_SET        , NULL, NULL },
#endif
#ifdef SEEK_CUR
  { "SEEK_CUR"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , SEEK_CUR        , NULL, NULL },
#endif
#ifdef SEEK_END
  { "SEEK_END"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , SEEK_END        , NULL, NULL },
#endif

  { "INADDR_ANY"      , VALUE_FLAG_CONST, VALUE_TYPE_STRING, 0, "0.0.0.0"        , NULL },
  { "INADDR_BROADCAST", VALUE_FLAG_CONST, VALUE_TYPE_STRING, 0, "255.255.255.255", NULL },
  { "INADDR_LOOPBACK" , VALUE_FLAG_CONST, VALUE_TYPE_STRING, 0, "127.0.0.1"      , NULL },
  { "IN6ADDR_ANY"     , VALUE_FLAG_CONST, VALUE_TYPE_STRING, 0, "::"             , NULL },
  { "IN6ADDR_LOOPBACK", VALUE_FLAG_CONST, VALUE_TYPE_STRING, 0, "::1"            , NULL },

#ifdef AF_UNIX
  { "AF_UNIX"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , AF_UNIX         , NULL, NULL },
#endif
#ifdef AF_INET
  { "AF_INET"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , AF_INET         , NULL, NULL },
#endif
#ifdef AF_INET6
  { "AF_INET6"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , AF_INET6        , NULL, NULL },
#endif
#ifdef SOCK_STREAM
  { "SOCK_STREAM" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , SOCK_STREAM     , NULL, NULL },
#endif
#ifdef SOCK_DGRAM
  { "SOCK_DGRAM"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , SOCK_DGRAM      , NULL, NULL },
#endif
#ifdef SHUT_RD
  { "SHUT_RD"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , SHUT_RD         , NULL, NULL },
#endif
#ifdef SHUT_WR
  { "SHUT_WR"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , SHUT_WR         , NULL, NULL },
#endif
#ifdef SHUT_RDWR
  { "SHUT_RDWR"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , SHUT_RDWR       , NULL, NULL },
#endif

#ifdef NLL_FLOATING_POINT
#ifdef USE_MATHLIB
  { "M_E"         , VALUE_FLAG_CONST, VALUE_TYPE_FLOAT    , 0               , NULL, NULL },
  { "M_PI"        , VALUE_FLAG_CONST, VALUE_TYPE_FLOAT    , 0               , NULL, NULL },
#endif
#endif

#ifdef USE_GRAPHIC
  { "G_DISABLE"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_DISABLE   , NULL, NULL },
  { "G_ENABLE"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_ENABLE    , NULL, NULL },
  { "G_DIRECT"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_DIRECT    , NULL, NULL },
  { "G_BUFFER"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_BUFFER    , NULL, NULL },
  { "G_RENDERER"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_RENDERER  , NULL, NULL },
  { "G_FORCE"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_FORCE     , NULL, NULL },
  { "G_SYNC"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_SYNC      , NULL, NULL },
  { "G_FLUSH"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_FLUSH     , NULL, NULL },
  { "G_ROUGH"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_ROUGH     , NULL, NULL },
  { "G_HROUGH"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_HROUGH    , NULL, NULL },

  { "G_CONST"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_CONST     , NULL, NULL },
  { "G_STATIC"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_STATIC    , NULL, NULL },
  { "G_RDONLY"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_RDONLY    , NULL, NULL },
  { "G_NDRAWPIXEL", VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_NDRAWPIXEL, NULL, NULL },
  { "G_AUTOCOLOR" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_AUTOCOLOR , NULL, NULL },
  { "G_FULLCOLOR" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_FULLCOLOR , NULL, NULL },
  { "G_MONOCOLOR" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_MONOCOLOR , NULL, NULL },
  { "G_MONOBCOLOR", VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_MONOBCOLOR, NULL, NULL },
  { "G_BASICCOLOR", VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_BASICCOLOR, NULL, NULL },
  { "G_ROUGHCOLOR", VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_ROUGHCOLOR, NULL, NULL },
  { "G_GRAYCOLOR" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_GRAYCOLOR , NULL, NULL },
  { "G_HALFCOLOR" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_HALFCOLOR , NULL, NULL },

  { "G_SET"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_SET       , NULL, NULL },
  { "G_AND"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_AND       , NULL, NULL },
  { "G_OR"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_OR        , NULL, NULL },
  { "G_XOR"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_XOR       , NULL, NULL },
  { "G_FILL"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_FILL      , NULL, NULL },
  { "G_ODDPOS"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_ODDPOS    , NULL, NULL },
  { "G_EVENPOS"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_EVENPOS   , NULL, NULL },
  { "G_NUPDATE"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_NUPDATE   , NULL, NULL },
  { "G_OFFSET"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_OFFSET    , NULL, NULL },

  { "G_MAINIMG"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_MAINIMG   , NULL, NULL },

  { "G_FONT8X8"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_FONT8X8   , NULL, NULL },
  { "G_FONT16X16" , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_FONT16X16 , NULL, NULL },
  { "G_FONT5X5"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_FONT5X5   , NULL, NULL },
  { "G_CHARA"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_CHARA     , NULL, NULL },
  { "G_CHARA2"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_CHARA2    , NULL, NULL },
  { "G_CHARA3"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_CHARA3    , NULL, NULL },

  { "G_DEFAULT"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_DEFAULT   , NULL, NULL },

  { "G_BLACK"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_BLACK     , NULL, NULL },
  { "G_BLUE"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_BLUE      , NULL, NULL },
  { "G_GREEN"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_GREEN     , NULL, NULL },
  { "G_CYAN"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_CYAN      , NULL, NULL },
  { "G_RED"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_RED       , NULL, NULL },
  { "G_MAGENTA"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_MAGENTA   , NULL, NULL },
  { "G_YELLOW"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_YELLOW    , NULL, NULL },
  { "G_WHITE"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_G_WHITE     , NULL, NULL },

  { "G_TRANSPARENT", VALUE_FLAG_CONST, VALUE_TYPE_INTEGER , NLL_G_TRANSPARENT,NULL, NULL },
#endif

#ifdef USE_AUDIO
  { "A_OUTPUT"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_OUTPUT    , NULL, NULL },
  { "A_NOOUT"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_NOOUT     , NULL, NULL },

  { "A_SIN"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_SIN       , NULL, NULL },
  { "A_TRIANGLE"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_TRIANGLE  , NULL, NULL },
  { "A_SQUARE"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_SQUARE    , NULL, NULL },
  { "A_PULSE"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_PULSE     , NULL, NULL },
  { "A_SAWUP"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_SAWUP     , NULL, NULL },
  { "A_SAWDOWN"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_SAWDOWN   , NULL, NULL },
  { "A_SAWTOOTH"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_SAWDOWN   , NULL, NULL },
  { "A_RANDOM"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_RANDOM    , NULL, NULL },
  { "A_NOISE"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_NOISE     , NULL, NULL },
  { "A_ZERO"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_ZERO      , NULL, NULL },
  { "A_HIGH"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_HIGH      , NULL, NULL },
  { "A_INPULSE"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_INPULSE   , NULL, NULL },
  { "A_EXTIN"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_EXTIN     , NULL, NULL },
  { "A_DATA"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_DATA      , NULL, NULL },

  { "A_FLUSH"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_FLUSH     , NULL, NULL },
  { "A_FIXED"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_FIXED     , NULL, NULL },
  { "A_ENVCLEAR"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_ENVCLEAR  , NULL, NULL },
  { "A_ENVFDOUT"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_ENVFDOUT  , NULL, NULL },
  { "A_ENVFDIN"   , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_ENVFDIN   , NULL, NULL },
  { "A_ENVFIXED"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_ENVFIXED  , NULL, NULL },
  { "A_FILCLEAR"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_FILCLEAR  , NULL, NULL },
  { "A_FILFIXED"  , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_FILFIXED  , NULL, NULL },
  { "A_FILINC"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_FILINC    , NULL, NULL },
  { "A_FILDEC"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_FILDEC    , NULL, NULL },
  { "A_SAVE"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_SAVE      , NULL, NULL },
  { "A_NEW"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_NEW       , NULL, NULL },
  { "A_REMAIN"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_REMAIN    , NULL, NULL },
  { "A_STEREO"    , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_STEREO    , NULL, NULL },
  { "A_TEXT"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_TEXT      , NULL, NULL },

  { "A_PHASE"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_PHASE     , NULL, NULL },
  { "A_FREQ"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_FREQ      , NULL, NULL },
  { "A_NULL"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_NULL      , NULL, NULL },
  { "A_REV"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_REV       , NULL, NULL },
  { "A_ABS"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_ABS       , NULL, NULL },
  { "A_INV"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_INV       , NULL, NULL },
  { "A_SIGN"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_SIGN      , NULL, NULL },
  { "A_CLIP"      , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_CLIP      , NULL, NULL },
  { "A_ADD"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_ADD       , NULL, NULL },
  { "A_SUB"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_SUB       , NULL, NULL },
  { "A_MUL"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_MUL       , NULL, NULL },
  { "A_AND"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_AND       , NULL, NULL },
  { "A_OR"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_OR        , NULL, NULL },
  { "A_XOR"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_XOR       , NULL, NULL },
  { "A_AVE"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_AVE       , NULL, NULL },
  { "A_PER"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_PER       , NULL, NULL },
  { "A_MIN"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_MIN       , NULL, NULL },
  { "A_MAX"       , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_MAX       , NULL, NULL },
  { "A_LT"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_LT        , NULL, NULL },
  { "A_GT"        , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_GT        , NULL, NULL },

  { "A_FILFW"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_FILFW     , NULL, NULL },
  { "A_FILBW"     , VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_FILBW     , NULL, NULL },

  { "A_NULLUNITSET",VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_NULLUNITSET,NULL, NULL },
  { "A_DEFUNITSET", VALUE_FLAG_CONST, VALUE_TYPE_INTEGER  , NLL_A_DEFUNITSET, NULL, NULL },
#endif

  { NULL          , 0               , VALUE_TYPE_UNDEFINED, 0               , NULL, NULL }
};

#ifdef NLL_FLOATING_POINT
const double const_variables_floating[] = {
#ifdef USE_MATHLIB
  M_E,
  M_PI,
#endif
  0.0
};
#endif
