# 1 "position.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "position.c"
# 1 "config.h" 1
# 2 "position.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "position.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "position.c" 2
# 1 "../include/string.h" 1





# 1 "../include/strings.h" 1





int bcmp(const void *b1, const void *b2, size_t len);
void bcopy(const void *src, void *dst, size_t len);
void bzero(void *b, size_t len);
# 7 "../include/string.h" 2

size_t strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, size_t len);
char *strcat(char *s, const char *append);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t len);
char *strchr(const char *s, int c);
char *strrchr(const char *s, int c);
char *strdup(const char *str);
void *memset(void *dest, int c, size_t len);
void *memcpy(void *dst, const void *src, size_t len);
void *memmove(void *dst, const void *src, size_t len);
int memcmp(const void *b1, const void *b2, size_t len);
void *memchr(const void *b, int c, size_t len);
# 6 "position.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 9 "position.c" 2


# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 12 "position.c" 2
# 1 "nlllib.h" 1



enum {
  NLL_ERRCODE_UNKNOWN = - 1,

  NLL_ERRCODE_FILE_NOT_FOUND = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER = - 21,
  NLL_ERRCODE_LINE_TOO_LONG = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY = -100,
  NLL_ERRCODE_STRING_TOO_LONG = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY = -130,
  NLL_ERRCODE_STACK_STACK_OVER = -131,
  NLL_ERRCODE_STACK_NOT_FOUND = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND = -153,
  NLL_ERRCODE_NLL_NO_DATA = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
       int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
      int errcode, const char *param);







void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);
# 13 "position.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 14 "position.c" 2
# 1 "position.h" 1



struct position {
  position_type_t type;
  struct spot spot;
  value_t value;
  int arg;
};

int position_check(void);
int position_init(void);
int position_clear(void);
int position_clean(void);
int position_push(position_type_t type, spot_t spot, value_t value, int arg);
int position_pop(position_type_t type, position_type_t *typep,
   spot_t spot, value_t value, int *argp);
int position_peek(position_type_t type, spot_t spot, value_t *valuep, int *argp);
position_type_t position_get_type(void);
int position_get(spot_t spot, position_t *positionp);
int position_set(spot_t spot, position_t position);
int position_reset(position_t position);
int position_dump(FILE *fp);
# 15 "position.c" 2

static struct position positions[64];
static int position_num = 0;

int position_check(void)
{
  if (position_num)
    return NLL_ERRCODE_POSITION_NOT_EMPTY;

  return 0;
}

int position_init(void)
{
  memset(positions, 0, sizeof(positions));
  position_num = 0;
  return 0;
}

int position_clear(void)
{
  return position_clean();
}

int position_clean(void)
{
  int r;

  while (position_num > 0) {
    if ((r = position_pop(POSITION_TYPE_NONE, ((void *)0), ((void *)0), ((void *)0), ((void *)0))) < 0)
      return r;
  }

  return 0;
}

int position_push(position_type_t type, spot_t spot, value_t value, int arg)
{
  int r;
  position_t position;

  if (position_num >= 64)
    return NLL_ERRCODE_POSITION_STACK_OVER;

  position = &positions[position_num];
  memset(position, 0, sizeof(*position));
  position->type = type;
  position->spot.line = spot ? spot->line : ((void *)0);
  position->spot.command = spot ? spot->command : ((void *)0);
  position->value = ((void *)0);
  position->arg = arg;

  if ((r = value_alloc(&position->value)) < 0)
    return r;

  if (value) {
    if ((r = value_copy_value(position->value, value)) < 0)
      return r;
  }

  position_num++;

  return 0;
}

int position_pop(position_type_t type, position_type_t *typep,
   spot_t spot, value_t value, int *argp)
{
  int r;
  position_t position;

  if (position_num == 0)
    return NLL_ERRCODE_POSITION_NOT_FOUND;

  position = &positions[position_num - 1];
  if ((type != POSITION_TYPE_NONE) && (type != position->type))
    return NLL_ERRCODE_POSITION_DIFFERENT_TYPE;

  position_num--;

  if (typep) {
    *typep = position->type;
  }

  if (spot) {
    spot->line = position->spot.line;
    spot->command = position->spot.command;
  }

  if (value) {
    if ((r = value_copy_value(value, position->value)) < 0)
      return r;
  }

  if (argp) {
    *argp = position->arg;
  }

  if ((r = value_free(position->value)) < 0)
    return r;

  return 0;
}

int position_peek(position_type_t type, spot_t spot, value_t *valuep, int *argp)
{
  position_t position;

  if (position_num == 0)
    return NLL_ERRCODE_POSITION_NOT_FOUND;

  position = &positions[position_num - 1];
  if ((type != POSITION_TYPE_NONE) && (type != position->type))
    return NLL_ERRCODE_POSITION_DIFFERENT_TYPE;

  if (spot) {
    spot->line = position->spot.line;
    spot->command = position->spot.command;
  }

  if (valuep) {
    *valuep = position->value;
  }

  if (argp) {
    *argp = position->arg;
  }

  return 0;
}

position_type_t position_get_type(void)
{
  position_t position;

  if (position_num == 0)
    return POSITION_TYPE_NONE;

  position = &positions[position_num - 1];

  return position->type;
}

int position_get(spot_t spot, position_t *positionp)
{
  position_t position;
  int i;

  for (i = 0; i < position_num; i++) {
    position = &positions[i];
    if ((position->spot.line == spot->line) &&
 (!spot->command || (position->spot.command == spot->command))) {
      *positionp = position;
      return 0;
    }
  }

  *positionp = ((void *)0);
  return 0;
}

int position_set(spot_t spot, position_t position)
{
  position->spot.line = spot->line;
  position->spot.command = spot->command;
  return 0;
}

int position_reset(position_t position)
{
  struct spot s;
  s.line = ((void *)0);
  s.command = ((void *)0);
  return position_set(&s, position);
}

int position_dump(FILE *fp)
{
  position_t position;
  int i;
  char *s;

  nll_wait_output(fp);
  fprintf(fp, "\n-- Position dump --\n");

  for (i = 0; i < position_num; i++) {
    nll_wait_output(fp);
    position = &positions[i];
    switch (position->type) {
    case POSITION_TYPE_NONE: s = "NONE"; break;
    case POSITION_TYPE_LOOP: s = "LOOP"; break;
    case POSITION_TYPE_FOR: s = "FOR"; break;
    case POSITION_TYPE_IF: s = "IF"; break;
    case POSITION_TYPE_GOSUB: s = "GOSUB"; break;
    case POSITION_TYPE_LABEL: s = "LABEL"; break;
    case POSITION_TYPE_EVAL: s = "EVAL"; break;
    default: s = "UNKNOWN"; break;
    }
    fprintf(fp, "[%d]\tType:%s\tArg:%d\tValue:", i, s, position->arg);
    value_dump(fp, position->value);
    fprintf(fp, "\n");
  }

  fflush(fp);

  return 0;
}
