#ifndef __NLL_KEY_H_INCLUDED__
#define __NLL_KEY_H_INCLUDED__

typedef enum {
  KEY_CODE_NONE         = 0,

  KEY_CODE_ENTER        = '\n',
  KEY_CODE_ESCAPE       = 0x1b,
  KEY_CODE_BACKSPACE    = '\b',
  KEY_CODE_TAB          = '\t',
  KEY_CODE_SPACE        = ' ',
  KEY_CODE_EXCLAIM      = '!',
  KEY_CODE_QUOTEDBL     = '"',
  KEY_CODE_HASH         = '#',
  KEY_CODE_PERCENT      = '%',
  KEY_CODE_DOLLAR       = '$',
  KEY_CODE_AMPERSAND    = '&',
  KEY_CODE_QUOTE        = '\'',
  KEY_CODE_LEFTPAREN    = '(',
  KEY_CODE_RIGHTPAREN   = ')',
  KEY_CODE_ASTERISK     = '*',
  KEY_CODE_PLUS         = '+',
  KEY_CODE_COMMA        = ',',
  KEY_CODE_MINUS        = '-',
  KEY_CODE_PERIOD       = '.',
  KEY_CODE_SLASH        = '/',
  KEY_CODE_0            = '0',
  KEY_CODE_1            = '1',
  KEY_CODE_2            = '2',
  KEY_CODE_3            = '3',
  KEY_CODE_4            = '4',
  KEY_CODE_5            = '5',
  KEY_CODE_6            = '6',
  KEY_CODE_7            = '7',
  KEY_CODE_8            = '8',
  KEY_CODE_9            = '9',
  KEY_CODE_COLON        = ':',
  KEY_CODE_SEMICOLON    = ';',
  KEY_CODE_LESS         = '<',
  KEY_CODE_EQUALS       = '=',
  KEY_CODE_GREATER      = '>',
  KEY_CODE_QUESTION     = '?',
  KEY_CODE_AT           = '@',
  KEY_CODE_LEFTBRACKET  = '[',
  KEY_CODE_BACKSLASH    = '\\',
  KEY_CODE_RIGHTBRACKET = ']',
  KEY_CODE_CARET        = '^',
  KEY_CODE_UNDERSCORE   = '_',
  KEY_CODE_BACKQUOTE    = '`',
  KEY_CODE_A            = 'a',
  KEY_CODE_B            = 'b',
  KEY_CODE_C            = 'c',
  KEY_CODE_D            = 'd',
  KEY_CODE_E            = 'e',
  KEY_CODE_F            = 'f',
  KEY_CODE_G            = 'g',
  KEY_CODE_H            = 'h',
  KEY_CODE_I            = 'i',
  KEY_CODE_J            = 'j',
  KEY_CODE_K            = 'k',
  KEY_CODE_L            = 'l',
  KEY_CODE_M            = 'm',
  KEY_CODE_N            = 'n',
  KEY_CODE_O            = 'o',
  KEY_CODE_P            = 'p',
  KEY_CODE_Q            = 'q',
  KEY_CODE_R            = 'r',
  KEY_CODE_S            = 's',
  KEY_CODE_T            = 't',
  KEY_CODE_U            = 'u',
  KEY_CODE_V            = 'v',
  KEY_CODE_W            = 'w',
  KEY_CODE_X            = 'x',
  KEY_CODE_Y            = 'y',
  KEY_CODE_Z            = 'z',

  KEY_CODE_CAPSLOCK     = 128,
  KEY_CODE_F1,
  KEY_CODE_F2,
  KEY_CODE_F3,
  KEY_CODE_F4,
  KEY_CODE_F5,
  KEY_CODE_F6,
  KEY_CODE_F7,
  KEY_CODE_F8,
  KEY_CODE_F9,
  KEY_CODE_F10,
  KEY_CODE_F11,
  KEY_CODE_F12,

  KEY_CODE_PRINTSCREEN,
  KEY_CODE_SCROLLLOCK,
  KEY_CODE_PAUSE,
  KEY_CODE_INSERT,
  KEY_CODE_HOME,
  KEY_CODE_PAGEUP,
  KEY_CODE_DELETE,
  KEY_CODE_END,
  KEY_CODE_PAGEDOWN,
  KEY_CODE_RIGHT,
  KEY_CODE_LEFT,
  KEY_CODE_DOWN,
  KEY_CODE_UP,

  KEY_CODE_F13,
  KEY_CODE_F14,
  KEY_CODE_F15,

  KEY_CODE_LCTRL,
  KEY_CODE_LSHIFT,
  KEY_CODE_LALT,
  KEY_CODE_RCTRL,
  KEY_CODE_RSHIFT,
  KEY_CODE_RALT,

  KEY_CODE_NUM
} key_code_t;

#define KEY_NAME_ENTER        "ENTER"
#define KEY_NAME_ESCAPE       "ESC"
#define KEY_NAME_BACKSPACE    "BACKSPACE"
#define KEY_NAME_TAB          "TAB"
#define KEY_NAME_SPACE        " "
#define KEY_NAME_EXCLAIM      "!"
#define KEY_NAME_QUOTEDBL     "\""
#define KEY_NAME_HASH         "#"
#define KEY_NAME_PERCENT      "%"
#define KEY_NAME_DOLLAR       "$"
#define KEY_NAME_AMPERSAND    "&"
#define KEY_NAME_QUOTE        "\'"
#define KEY_NAME_LEFTPAREN    "("
#define KEY_NAME_RIGHTPAREN   ")"
#define KEY_NAME_ASTERISK     "*"
#define KEY_NAME_PLUS         "+"
#define KEY_NAME_COMMA        ","
#define KEY_NAME_MINUS        "-"
#define KEY_NAME_PERIOD       "."
#define KEY_NAME_SLASH        "/"
#define KEY_NAME_0            "0"
#define KEY_NAME_1            "1"
#define KEY_NAME_2            "2"
#define KEY_NAME_3            "3"
#define KEY_NAME_4            "4"
#define KEY_NAME_5            "5"
#define KEY_NAME_6            "6"
#define KEY_NAME_7            "7"
#define KEY_NAME_8            "8"
#define KEY_NAME_9            "9"
#define KEY_NAME_COLON        ":"
#define KEY_NAME_SEMICOLON    ";"
#define KEY_NAME_LESS         "<"
#define KEY_NAME_EQUALS       "="
#define KEY_NAME_GREATER      ">"
#define KEY_NAME_QUESTION     "?"
#define KEY_NAME_AT           "@"
#define KEY_NAME_LEFTBRACKET  "["
#define KEY_NAME_BACKSLASH    "\\"
#define KEY_NAME_RIGHTBRACKET "]"
#define KEY_NAME_CARET        "^"
#define KEY_NAME_UNDERSCORE   "_"
#define KEY_NAME_BACKQUOTE    "`"
#define KEY_NAME_A            "a"
#define KEY_NAME_B            "b"
#define KEY_NAME_C            "c"
#define KEY_NAME_D            "d"
#define KEY_NAME_E            "e"
#define KEY_NAME_F            "f"
#define KEY_NAME_G            "g"
#define KEY_NAME_H            "h"
#define KEY_NAME_I            "i"
#define KEY_NAME_J            "j"
#define KEY_NAME_K            "k"
#define KEY_NAME_L            "l"
#define KEY_NAME_M            "m"
#define KEY_NAME_N            "n"
#define KEY_NAME_O            "o"
#define KEY_NAME_P            "p"
#define KEY_NAME_Q            "q"
#define KEY_NAME_R            "r"
#define KEY_NAME_S            "s"
#define KEY_NAME_T            "t"
#define KEY_NAME_U            "u"
#define KEY_NAME_V            "v"
#define KEY_NAME_W            "w"
#define KEY_NAME_X            "x"
#define KEY_NAME_Y            "y"
#define KEY_NAME_Z            "z"

#define KEY_NAME_CAPSLOCK     "CAPSLOCK"
#define KEY_NAME_F1           "F1"
#define KEY_NAME_F2           "F2"
#define KEY_NAME_F3           "F3"
#define KEY_NAME_F4           "F4"
#define KEY_NAME_F5           "F5"
#define KEY_NAME_F6           "F6"
#define KEY_NAME_F7           "F7"
#define KEY_NAME_F8           "F8"
#define KEY_NAME_F9           "F9"
#define KEY_NAME_F10          "F10"
#define KEY_NAME_F11          "F11"
#define KEY_NAME_F12          "F12"

#define KEY_NAME_PRINTSCREEN  "PRINTSCREEN"
#define KEY_NAME_SCROLLLOCK   "SCROLLLOCK"
#define KEY_NAME_PAUSE        "PAUSE"
#define KEY_NAME_INSERT       "INSERT"
#define KEY_NAME_HOME         "HOME"
#define KEY_NAME_PAGEUP       "PAGEUP"
#define KEY_NAME_DELETE       "DELETE"
#define KEY_NAME_END          "END"
#define KEY_NAME_PAGEDOWN     "PAGEDOWN"
#define KEY_NAME_RIGHT        "RIGHT"
#define KEY_NAME_LEFT         "LEFT"
#define KEY_NAME_DOWN         "DOWN"
#define KEY_NAME_UP           "UP"

#define KEY_NAME_F13          "F13"
#define KEY_NAME_F14          "F14"
#define KEY_NAME_F15          "F15"

#define KEY_NAME_LCTRL        "LCTRL"
#define KEY_NAME_LSHIFT       "LSHIFT"
#define KEY_NAME_LALT         "LALT"
#define KEY_NAME_RCTRL        "RCTRL"
#define KEY_NAME_RSHIFT       "RSHIFT"
#define KEY_NAME_RALT         "RALT"

const char *keyname_get(key_code_t code);
key_code_t keycode_get(const char *name);

#endif
