# 1 "imath.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "imath.c"
# 1 "config.h" 1
# 2 "imath.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "imath.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "imath.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 8 "imath.c" 2


# 1 "imath.h" 1



int imath_deg(void);
int imath_amp(void);
int imath_sin(int deg);
int imath_cos(int deg);
long imath_sqr(long val);
long imath_pow(long b, int n);
int imath_log(long b, long val);
# 11 "imath.c" 2
# 30 "imath.c"
static const int sin_val[256 + 1] = {
      0, 201, 402, 603, 804, 1005, 1206, 1407,
   1608, 1809, 2009, 2210, 2410, 2611, 2811, 3012,
   3212, 3412, 3612, 3811, 4011, 4210, 4410, 4609,
   4808, 5007, 5205, 5404, 5602, 5800, 5998, 6195,
   6393, 6590, 6786, 6983, 7179, 7375, 7571, 7767,
   7962, 8157, 8351, 8545, 8739, 8933, 9126, 9319,
   9512, 9704, 9896, 10087, 10278, 10469, 10659, 10849,
  11039, 11228, 11417, 11605, 11793, 11980, 12167, 12353,
  12539, 12725, 12910, 13094, 13279, 13462, 13645, 13828,
  14010, 14191, 14372, 14553, 14732, 14912, 15090, 15269,
  15446, 15623, 15800, 15976, 16151, 16325, 16499, 16673,
  16846, 17018, 17189, 17360, 17530, 17700, 17869, 18037,
  18204, 18371, 18537, 18703, 18868, 19032, 19195, 19357,
  19519, 19680, 19841, 20000, 20159, 20317, 20475, 20631,
  20787, 20942, 21096, 21250, 21403, 21554, 21705, 21856,
  22005, 22154, 22301, 22448, 22594, 22739, 22884, 23027,
  23170, 23311, 23452, 23592, 23731, 23870, 24007, 24143,
  24279, 24413, 24547, 24680, 24811, 24942, 25072, 25201,
  25329, 25456, 25582, 25708, 25832, 25955, 26077, 26198,
  26319, 26438, 26556, 26674, 26790, 26905, 27019, 27133,
  27245, 27356, 27466, 27575, 27683, 27790, 27896, 28001,
  28105, 28208, 28310, 28411, 28510, 28609, 28706, 28803,
  28898, 28992, 29085, 29177, 29268, 29358, 29447, 29534,
  29621, 29706, 29791, 29874, 29956, 30037, 30117, 30195,
  30273, 30349, 30424, 30498, 30571, 30643, 30714, 30783,
  30852, 30919, 30985, 31050, 31113, 31176, 31237, 31297,
  31356, 31414, 31470, 31526, 31580, 31633, 31685, 31736,
  31785, 31833, 31880, 31926, 31971, 32014, 32057, 32098,
  32137, 32176, 32213, 32250, 32285, 32318, 32351, 32382,
  32412, 32441, 32469, 32495, 32521, 32545, 32567, 32589,
  32609, 32628, 32646, 32663, 32678, 32692, 32705, 32717,
  32728, 32737, 32745, 32752, 32757, 32761, 32765, 32766, 32767
};


static int degree_inrange(int deg)
{
  while (deg < 0)
    deg += (256*4);
  deg %= (256*4);
  return deg;
}

static int int_sin(int deg)
{
  deg = degree_inrange(deg);
  if (deg >= (256*2))
    return -int_sin(deg - (256*2));
  if (deg > 256)
    return int_sin((256*2) - deg);
  return sin_val[deg];
}

int imath_deg(void)
{
  return 256 * 4;
}

int imath_amp(void)
{
  return 32767;
}

int imath_sin(int deg)
{
  return int_sin(deg);
}

int imath_cos(int deg)
{
  return int_sin(deg + 256);
}

long imath_sqr(long val)
{
  long m, n, m2, n2;

  m = m2 = 0;
  for (n = 1;; n++) {
    n2 = n * n;
    if (m2 > n2)
      break;
    if (n2 > val)
      return m;
    m = n;
    m2 = n2;
  }

  return -1;
}

long imath_pow(long b, int n)
{
  int i;
  long val = 1;

  for (i = 0; i < n; i++)
    val *= b;

  return val;
}

int imath_log(long b, long val)
{
  int m, n;
  long mm, nn;

  if (b <= 1)
    return -1;

  m = 0;
  mm = nn = 1;
  for (n = 1;; n++) {
    nn = nn * b;
    if (mm > nn)
      break;
    if (nn > val)
      return m;
    m = n;
    mm = nn;
  }

  return -1;
}
